/* $Header: /cvs/gnome/gIDE/src/gI_project_changelog.c,v 1.1 2000/03/21 23:36:12 jpr Exp $ */
/* gIDE
 * Copyright (C) 1998-2000 Steffen Kern
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include "gide.h"
#include "gI_project.h"
#include "gI_project_changelog.h"
#include "gI_common.h"

/* prototypes */
static void changelog_add_entry(gchar* changelogFileName,
	gchar* changelogEntry);
static gchar* changelog_move_to_tmp(gchar* filename);
static glong changelog_append_file(gchar* filea, gchar* fileb);
static gint dialogAddChangelogOkButtonPress(GtkWidget* widget, gpointer data);

static const gchar* dlgKey = "dialogChangeLogFileKey";
static const gchar* dlgWinKey = "dialogChangeLogWindowKey";
static const gchar* dialogAddChangelogTitle = N_("Add to ChangeLog?");
static const gchar* dialogAddChangelogFrame = N_("ChangeLog addition:");
static const gchar* dialogAddChangelogOk = N_(" Add to ChangeLog ");
static const gchar* dialogAddChangelogCancel = N_(" Cancel ");

/*
 * Changelog Add Dialog
 */
void
gI_changelog_popup(
	gchar*								changelogEntry,
	gchar*								changelogFileName
)
{
	GtkWidget*							dialogWindow;
	GtkWidget*							frame;
	GtkWidget*							textEntry;
	GtkWidget*							okButton;
	GtkWidget*							cancelButton;
	gint								pos = 0;

	g_return_if_fail(changelogEntry);
	g_return_if_fail(changelogFileName);

	dialogWindow = gtk_dialog_new();
	gtk_window_set_title(GTK_WINDOW(dialogWindow), dialogAddChangelogTitle);
	gtk_widget_set_usize(dialogWindow, 500, 150);
	gtk_signal_connect_object(GTK_OBJECT(dialogWindow), "destroy",
		GTK_SIGNAL_FUNC(gtk_widget_destroy), GTK_OBJECT(dialogWindow));

	frame = gtk_frame_new(dialogAddChangelogFrame);
	gtk_box_pack_start(GTK_BOX(GTK_DIALOG(dialogWindow)->vbox),
		frame, TRUE, TRUE, 0);

	textEntry = gtk_text_new(FALSE, FALSE);
	gtk_text_set_editable(GTK_TEXT(textEntry), TRUE);
	gtk_container_add(GTK_CONTAINER(frame), textEntry);

	okButton = gtk_button_new_with_label(dialogAddChangelogOk);
	gtk_signal_connect(GTK_OBJECT(okButton), "clicked",
		GTK_SIGNAL_FUNC(dialogAddChangelogOkButtonPress), textEntry);
	gtk_object_set_data(GTK_OBJECT(okButton), dlgKey, changelogFileName);
	gtk_object_set_data(GTK_OBJECT(okButton), dlgWinKey, dialogWindow);
	gtk_box_pack_start(GTK_BOX(GTK_DIALOG(dialogWindow)->action_area),
		okButton, FALSE, FALSE, 0);

	cancelButton = gtk_button_new_with_label(dialogAddChangelogCancel);
	gtk_signal_connect_object(GTK_OBJECT(cancelButton), "clicked",
		GTK_SIGNAL_FUNC(gtk_widget_destroy), GTK_OBJECT(dialogWindow));
	gtk_box_pack_end(GTK_BOX(GTK_DIALOG(dialogWindow)->action_area),
		cancelButton, FALSE, FALSE, 0);

	gtk_widget_show_all(dialogWindow);
	gtk_widget_realize(textEntry);

	gtk_editable_insert_text(GTK_EDITABLE(textEntry), changelogEntry,
		strlen(changelogEntry), &pos);
}

static gint
dialogAddChangelogOkButtonPress(
	GtkWidget*							widget,
	gpointer							data
)
{
	GtkWidget*							dialogWindow;
	GtkWidget*							text;
	gchar*								changelogFileName;
	gchar*								changelogEntry;
	gint								len;

	text = data;
	dialogWindow = gtk_object_get_data(GTK_OBJECT(widget), dlgWinKey);
	changelogFileName = gtk_object_get_data(GTK_OBJECT(widget), dlgKey);

	g_return_val_if_fail(text, 0);
	g_return_val_if_fail(changelogFileName, 0);
	g_return_val_if_fail(dialogWindow, 0);

	len = gtk_text_get_length(GTK_TEXT(text));

	changelogEntry = gtk_editable_get_chars(GTK_EDITABLE(text), 0, len);

	if(isempty(changelogEntry))
	{
		gI_error_dialog(_("Please enter a changelog addition."));
		return 0;
	}

	changelog_add_entry(changelogFileName, changelogEntry);

	gtk_widget_destroy(dialogWindow);

	return 0;
}


static void
changelog_add_entry(
	gchar*								changelogFileName,
	gchar*								changelogEntry
)
{
	GString*							buf;
	FILE*								changelog;
	gchar*								tmpname = NULL;

	if(file_exist(changelogFileName))
	{
		tmpname = changelog_move_to_tmp(changelogFileName);
		if(!tmpname)
		{
			/* error handling */
			gI_error_dialog(_("Unable to move ChangeLog to temponary file"));
			return;
		}
	}
	changelog = fopen(changelogFileName, "w");
	if(!changelog)
	{
		/* error handling */
		gI_error_dialog(_("Unable to open ChangeLog-File"));
		return;
	}

	/* Only 2 trailing newlines */
	buf = g_string_new(changelogEntry);
	while(buf->len && buf->str[buf->len - 1] == '\n')
	{
		g_string_truncate(buf, buf->len - 1);
	}

	if(!isempty(buf->str))
	{
		fprintf(changelog, "%s\n\n", buf->str);
	}

	g_string_free(buf, FALSE);

	fclose(changelog);
	if(tmpname)
	{
		changelog_append_file(changelogFileName, tmpname);
	}

	remove(tmpname);

	g_free(tmpname);
}

static gchar*
changelog_move_to_tmp(
	gchar*								filename
)
{
	gchar*								newfname;

	newfname = g_strdup_printf("%s/gide_chnglog^^.%d.%d", cfg->tmpdir,
		(int)time(0), (int)getpid());

	if(rename(filename, newfname) == -1)
	{
		perror("rename");
		g_free(newfname);
		return(NULL);
	}

	return(newfname);
}


static glong
changelog_append_file(
	gchar*								filea,
	gchar*								fileb
)
{
	FILE*								fa;
	FILE*								fb;
	gchar								buf[STRLEN];

	fa = fopen(filea, "a");
	if(!fa)
	{
		perror("fopen");
		return(-1);
	}

	fb = fopen(fileb, "r");
	if(!fb)
	{
		perror("fopen");
		return(-1);
	}

	while(fgets(buf, sizeof(buf), fb))
	{
		fputs(buf, fa);
	}

	fclose(fa);
	fclose(fb);

	return(0);
}
