/* $Header: /cvs/gnome/gIDE/src/gI_search.h,v 1.5 2000/04/04 05:25:10 jpr Exp $ */
/* gIDE
 * Copyright (C) 1998-2000 Steffen Kern
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#ifndef GI_SEARCH_H
#define GI_SEARCH_H

#include <config.h>
#include <gnome.h>

typedef struct _SearchReplaceState SearchReplaceState;
typedef struct _FileSearchReplaceState FileSearchReplaceState;

struct _SearchReplaceState {
	gchar *search;
	gchar *replace;

	gint start;
	gint found;
	
	gboolean back;
	gboolean re;
	gboolean cs;

};

struct _FileSearchReplaceState {
	gchar *dir;
	gchar *pat;
	
	gchar *search;
	gchar *replace;

	gboolean re;
	gboolean cs;
	gboolean sub;
};

/*
 * Prototypes for 'gI_search.c'
 */
void __goto_point( gint point );
void search_goto_line( GtkWidget *widget, gpointer data );
void search_search( GtkWidget *widget, gpointer data );
void search_again( GtkWidget *widget, gpointer data );
void search_replace( GtkWidget *widget, gpointer data );
void find_in_files( GtkWidget *widget, gpointer data );
void replace_in_files( GtkWidget *widget, gpointer data );

#endif






















