/* $Header: /cvs/gnome/gIDE/src/gI_tools.c,v 1.21 2000/04/16 04:59:57 jpr Exp $ */
/* gIDE
 * Copyright (C) 1998-2000 Steffen Kern
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include "gide.h"
#include "gI_menus.h"
#include "gI_pathwidget.h"
#include "gI_tools.h"

/* Prototypes */
static void gI_tool_class_init (ToolClass *class);
static void gI_tool_init (Tool *tool);
static void gI_tool_destroy (GtkObject *object, gpointer data);

guint
gI_tool_get_type()
{
	static guint tool_type = 0;

	if (!tool_type) {
           GtkTypeInfo tool_info = {
               "Tool",
               sizeof (Tool),
               sizeof (ToolClass),
               (GtkClassInitFunc) gI_tool_class_init,
               (GtkObjectInitFunc) gI_tool_init,
               (GtkArgSetFunc) NULL,
               (GtkArgGetFunc) NULL
             };
             tool_type = gtk_type_unique (gtk_object_get_type (),
					  &tool_info);
           }

         return tool_type;
}

static void
gI_tool_class_init( ToolClass *class )
{
	GtkObjectClass *object_class;
	
	object_class = (GtkObjectClass*) class;
}

static void
gI_tool_init( Tool *tool )
{
	tool->name = NULL;
	tool->sens_func = NULL;
	tool->menu_name = NULL;
  	tool->popup_name = NULL;
		
	gtk_signal_connect( GTK_OBJECT( tool ), "destroy",
	                    GTK_SIGNAL_FUNC( gI_tool_destroy ),
			    NULL );	
}

GtkObject *
gI_tool_new( const gchar * name, void *func )
{
	Tool *tool;

	tool = TOOL( gtk_type_new( gI_tool_get_type()) );
	tool->name = g_strdup( name );
	tool->func = func;

	return GTK_OBJECT( tool );
}

void
gI_tool_set_menu_data( Tool *tool, void *sens_func,
		       const char *menu_name, const char *popup_name )
{
	tool->sens_func = sens_func;
	tool->menu_name = g_strdup ( menu_name );
	tool->popup_name = g_strdup ( popup_name );
}

static void
gI_tool_destroy (GtkObject *object, gpointer data)
{
	Tool *tool;

	tool = TOOL( object );

	g_free( tool->name );
	g_free( tool->menu_name );
	g_free( tool->popup_name );
}









