/* $Header: /cvs/gnome/gIDE/src/gide-tools.c,v 1.12 2000/04/16 04:59:58 jpr Exp $ */
/* gIDE
 * Copyright (C) 1998-2000 Steffen Kern
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include "gide.h"
#include "gI_tools.h"
#include "gI_menus.h"
#include "gide-tools.h"

static GList *tool_list;
static GList *tool_window_list;

static void gide_tool_activate (GtkObject *object, gpointer data);

static void
gide_tool_menu_add( GideWindow *window, Tool *tool )
{
	gchar root[200] = "";
	gchar *path;
	gchar *name;
	gchar **tokens;
	GtkWidget *item;
	GtkMenuBar *menubar;
	GtkWidget *parent;
	GtkWidget *submenu;
	gint pos, i;

	menubar = GTK_MENU_BAR( GNOME_APP( window )->menubar );

	tokens = g_strsplit( tool->menu_name, "/", 0);

	g_snprintf( root, 200, "%s/", tokens[0] ); 
	parent = gnome_app_find_menu_pos( GTK_WIDGET( menubar ),
					  root, &pos );	
	root[0] = '\0';
					  
	for (i=1; tokens[i] != NULL; i++) {
		path = g_strconcat( root, tokens[i-1], "/", NULL );
		submenu = gnome_app_find_menu_pos( GTK_WIDGET( menubar ),
						   path, &pos );
		if (!submenu) {
			submenu = gtk_menu_new();
			gtk_widget_show( submenu );
			
			item = gtk_tearoff_menu_item_new();
			gtk_widget_show( item );
						
			gtk_menu_append( GTK_MENU(submenu), item );
			
			item = gtk_menu_item_new_with_label( tokens[i-1] );
			gtk_menu_item_set_submenu( GTK_MENU_ITEM(item),
						   submenu);
			gtk_widget_show( item );
			
			gtk_menu_append( GTK_MENU( parent ), item );
			gI_menus_add_item_widget( window, path, item );
		}
		parent = submenu;
			
		g_snprintf( root, 200, "%s", path );
		g_free( path );
	}
	g_strfreev(tokens);

	name = strrchr( tool->menu_name, '/' );
	if (name == NULL)
		name = tool->menu_name;
	else
		name ++;
		
	item = gtk_menu_item_new_with_label( name );
	gtk_object_set_user_data( GTK_OBJECT(item), tool );
	
	gtk_menu_shell_append( GTK_MENU_SHELL( parent ), item );
	gtk_signal_connect( GTK_OBJECT( item ), "activate",
	                    GTK_SIGNAL_FUNC( gide_tool_activate ),
			    (gpointer) window );
	gtk_widget_show( item );

	/* add new item to association list */
	gI_menus_add_item_widget( window, tool->menu_name, item );

}

static void
gide_tool_menu_remove( GideWindow *window, Tool *tool )
{
	gchar path[200];
	char *str;
	GtkWidget *widget, *parent, *item;
	GtkMenuBar *menubar;
	gint pos;

	menubar = GTK_MENU_BAR( GNOME_APP( window )->menubar );
	
	g_snprintf( path, 200, tool->menu_name );

	widget = gI_menus_get_item_widget( window, path );
	if( widget ) {
		gtk_widget_destroy( widget );
		gI_menus_remove_item_widget( window, path );
		
		/* Now remove any unused submenus */
		str = strrchr( path, '/');
		while ( str ) {
			str++;
			*str = '\0';
			parent = gnome_app_find_menu_pos( GTK_WIDGET( menubar ), path, &pos );
			if ( g_list_length(
				GTK_MENU_SHELL( parent )->children) <= 1 ) {
				gtk_widget_destroy( parent );
				
				item = gI_menus_get_item_widget (window, path);
				gtk_widget_destroy( item );
				gI_menus_remove_item_widget( window, path );

			} else {
				break;
			}
			str--;
			*str = '\0';
			str = strrchr( path, '/');				
		}
	} else {
		printf( "Unable to destroy %s\n",path );
	}
}

static void
gide_tool_menu_sensitive( GideWindow *window, Tool *tool, gboolean sensitive )
{
	GtkWidget *widget;

	if (tool->menu_name) {
		widget = gI_menus_get_item_widget( window, tool->menu_name );
		gtk_widget_set_sensitive( widget, sensitive );
	}	
}


static void
gide_tool_popup_add( GideWindow *window, Tool *tool )
{
	gchar root[200] = "";
	gchar pw[200] = "";
	gchar *path;
	gchar *name;
	gchar **tokens;
	GtkWidget *item;
	GtkMenu *menu;
	GtkWidget *parent;
	GtkWidget *submenu;
	gint pos, i;

	menu = GTK_MENU( window->popup );
	parent = window->popup;
	
	tokens = g_strsplit( tool->popup_name, "/", 0);
					  
	for (i=1; tokens[i] != NULL; i++) {
		path = g_strconcat( root, tokens[i-1], "/", NULL );
		submenu = gnome_app_find_menu_pos( GTK_WIDGET( menu ),
						   path, &pos );
		if (!submenu) {
			submenu = gtk_menu_new();
			gtk_widget_show( submenu );
			
			item = gtk_tearoff_menu_item_new();
			gtk_widget_show( item );
						
			gtk_menu_append( GTK_MENU(submenu), item );
			
			item = gtk_menu_item_new_with_label( tokens[i-1] );
			gtk_menu_item_set_submenu( GTK_MENU_ITEM(item),
						   submenu);

			gtk_widget_show( item );
			gtk_menu_append( GTK_MENU( parent ), item );
			
			g_snprintf( pw, 200, "Popup/%s", path );
			gI_menus_add_item_widget( window, pw, item );
		}
		parent = submenu;
			
		g_snprintf( root, 200, "%s", path );
		g_free( path );
	}
	g_strfreev(tokens);

	name = strrchr( tool->menu_name, '/' );
	if (name == NULL)
		name = tool->menu_name;
	else
		name ++;
		
	item = gtk_menu_item_new_with_label( name );
	gtk_object_set_user_data( GTK_OBJECT(item), tool );
	
	gtk_menu_shell_append( GTK_MENU_SHELL( parent ), item );
	gtk_signal_connect( GTK_OBJECT( item ), "activate",
	                    GTK_SIGNAL_FUNC( gide_tool_activate ),
			    (gpointer) window );
	gtk_widget_show( item );

	/* add new item to association list */
	g_snprintf( pw, 200, "Popup/%s", tool->popup_name );
	gI_menus_add_item_widget( window, pw, item );

}

static void
gide_tool_popup_remove( GideWindow *window, Tool *tool )
{
	gchar path[200];
	gchar pw[200];
	char *str;
	GtkWidget *widget, *parent, *item;
	GtkMenu *menu;
	gint pos;

	menu = GTK_MENU( window->popup );

	g_snprintf( path, 200, tool->popup_name );
	g_snprintf( pw, 200, "Popup/%s", path );

	widget = gI_menus_get_item_widget( window, pw );
	if( widget ) {
		gtk_widget_destroy( widget );
		gI_menus_remove_item_widget( window, pw );
		
		/* Now remove any unused submenus */
		str = strrchr( path, '/');
		while ( str ) {
			str++;
			*str = '\0';
			parent = gnome_app_find_menu_pos( GTK_WIDGET( menu ),
							  path, &pos );
			if ( g_list_length(
				GTK_MENU_SHELL(parent)->children) <= 1 ) {
				gtk_widget_destroy( parent );
				
				g_snprintf( pw, 200, "Popup/%s", path );
				item = gI_menus_get_item_widget (window, pw);
				gtk_widget_destroy( item );
				gI_menus_remove_item_widget( window, pw );

			} else {
				break;
			}
			str--;
			*str = '\0';
			str = strrchr( path, '/');				
		}
	} else {
		printf( "Unable to destroy %s\n",path );
	}
}

static void
gide_tool_popup_sensitive( GideWindow *window, Tool *tool, gboolean sensitive )
{
	GtkWidget *widget;
	gchar pw[200];

	if (tool->popup_name) {
		g_snprintf( pw, 200, "Popup/%s", tool->popup_name );
		
		widget = gI_menus_get_item_widget( window, pw );
		gtk_widget_set_sensitive( widget, sensitive );
	}
}

static void
gide_tool_activate (GtkObject *object, gpointer data)
{
	Tool *tool;
	ToolState state;
	
	tool = TOOL(gtk_object_get_user_data( GTK_OBJECT(object) ));

	g_assert(IS_GIDE_WINDOW(data));

	state.window = GIDE_WINDOW(data);
	state.document = gI_window_get_current_doc(GIDE_WINDOW(data));
	state.project = gI_project_get_current();

	tool->func ( tool, &state );
}

void
gide_tool_add( Tool *tool )
{
	GideWindow *window;
	int len, i;

	tool_list = g_list_append( tool_list, (gpointer)tool );

	len = g_list_length( tool_window_list );
	for (i=0; i<len; i++) {
		window = GIDE_WINDOW(
			g_list_nth_data( tool_window_list, i));
		if ( tool->menu_name ) 
			gide_tool_menu_add( window, tool );
		if ( tool->popup_name ) 
			gide_tool_popup_add( window, tool );
		gide_sensitivity_tools(window);
	}
}

void
gide_tool_remove( gchar *name )
{
	Tool *tool = NULL;
	GideWindow *window;
	int len, len2, i, j;
	
	len = g_list_length( tool_list );
	for (i=0; i<len; i++){
		tool = TOOL(g_list_nth_data( tool_list, i ));
		if ( !strcmp(tool->name, name) ) {
			len2 = g_list_length( tool_window_list );
			for (j=0; j<len2; j++) {
				window = GIDE_WINDOW(
					g_list_nth_data( tool_window_list, j));
				if ( tool->menu_name ) 
					gide_tool_menu_remove( window, tool );
				if ( tool->popup_name ) 
					gide_tool_popup_remove( window, tool );
			}
			break;	
		}
	}

	g_list_remove( tool_list, tool );
}

void
gide_add_tools( GideWindow *window )
{
	Tool *tool;
	int len, i;
	
	len = g_list_length( tool_list );
	for (i=0; i<len; i++){
		tool = TOOL(g_list_nth_data( tool_list, i ));
		if ( tool->menu_name ) 
			gide_tool_menu_add( window, tool );
		if ( tool->popup_name )
			gide_tool_popup_add( window, tool );
	}

	tool_window_list = g_list_append( tool_window_list,
					  (gpointer)window );
	gide_sensitivity_tools(window);
}

void
gide_sensitivity_tools( GideWindow *window )
{
	Tool *tool;
	ToolState state;
	gboolean sensitive;
	gint len, i;
	
	state.window = window;
	state.document = gI_window_get_current_doc( window );
	state.project = gI_project_get_current();
	
	len = g_list_length( tool_list );
	for (i=0; i<len; i++){
		tool = TOOL(g_list_nth_data( tool_list, i ));

		if (tool->sens_func) {
			sensitive = tool->sens_func ( tool, &state );

			if ( tool->menu_name ) 
				gide_tool_menu_sensitive( window, tool,
							  sensitive );
			if ( tool->popup_name )
				gide_tool_popup_sensitive( window, tool,
							   sensitive );
		}
	}
}
