/* $Header: /cvs/gnome/gIDE/src/gide.c,v 1.21 2000/04/22 03:13:53 jpr Exp $ */
/* gIDE
 * Copyright (C) 1998-2000 Steffen Kern
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <config.h>
#include <gnome.h>
#include <glade/glade.h>
#include <sys/stat.h>

#include "structs.h"
#include "gI_window.h"
#include "gI_file.h"
#include "gI_cfp.h"
#include "gI_menus.h"
#include "gI_edit.h"
#include "gI_cfgfiles.h"
#include "gI_commands.h"
#include "gI_plugin.h"
#include "gide-windows.h"

#ifdef HAVE_GUILE
#include <guile/gh.h>
#include "gI_guilesupport.h"
#endif

#include <libgnorba/gnorba.h>

/* --- global vars --- */

/* Widgets: Main-Window & Box */
GideWindow *main_window;

/* Configuration */
gI_config *cfg;

/* Paths */
gchar gide_path[MAXLEN];
gchar tools_path[MAXLEN];
gchar prj_path[MAXLEN];

/* Command line args */
static poptContext ctx;
static gchar *cfgfile = NULL;
static gboolean disablefontstuff = FALSE;

static const struct poptOption gIDE_popt_options [] = {
	{ "cfgfile", '\0', POPT_ARG_STRING, &cfgfile, 0,
	  N_("Use alternate configuration file"), N_("FILE") },
	{ "disable-font-stuff", '\0', POPT_ARG_NONE, &disablefontstuff, 0,
	  N_("Disable fancy font stuff"), NULL },

	{ NULL, '\0', 0, NULL, 0 }
};

#ifdef HAVE_LIBGNORBA
/* GNORBA vars */
CORBA_ORB global_orb;
PortableServer_POA root_poa;
PortableServer_POAManager root_poa_manager;
CORBA_Environment *global_ev;
CORBA_Object name_service;
#endif

/* --- local functions --- */

#ifdef HAVE_LIBGNORBA
void corba_exception( CORBA_Environment* ev )
{
	switch( ev->_major )
	{
		case CORBA_SYSTEM_EXCEPTION:
			g_log("gIDE CORBA", G_LOG_LEVEL_DEBUG,
			         "CORBA system exception %s.\n",
			         CORBA_exception_id(ev));
		break;

		case CORBA_USER_EXCEPTION:
			g_log("gIDE CORBA", G_LOG_LEVEL_DEBUG,
			         "CORBA user exception: %s.\n",
			         CORBA_exception_id (ev));
		break;

		default:
		break;
	}
}
#endif


static void open_history( gchar *filename )
{
/*
	FILE* history;
	gchar buf[MAXLEN];
	gchar historywp[MAXLEN];
	gchar *ptr;

	g_snprintf( historywp, MAXLEN, "%s/%s", gide_path, filename );

	history = fopen( historywp, "r" );
	if( history )
	{
		while( fgets( buf, sizeof(buf), history ) )
		{
			ptr = strchr( buf, '\n' );
			if( ptr )
				*ptr = '\0';
			file_open_by_name( main_window, buf );
		}
		fclose( history );
		} */
}

/* doesn't seem to belong here. should be in gI_cfg.c or so */
static void free_cfg( gI_config *cfg )
{
	g_return_if_fail( cfg != NULL );

	g_free( cfg->cfgfile );
	g_free( cfg->cc );
	g_free( cfg->ld );
	g_free( cfg->incpath );
	g_free( cfg->ccopt );
	g_free( cfg->libpath );
	g_free( cfg->ldopt );
	g_free( cfg->db );
	g_free( cfg->tmpdir );
	g_free( cfg->fontname );
	g_free( cfg->redit );
	g_free( cfg->ign_file );
	g_free( cfg->bash );
	g_free( cfg->make );
	g_free( cfg->man );
	g_free( cfg->xterm );
	g_free( cfg->email );
	g_free( cfg->smtp );
#ifdef HAVE_GTKTEXT_PATCH
	g_free( cfg->patternfile );
	g_free( cfg->globassocfile );
	g_free( cfg->hli_file );
#endif
	g_free( cfg );
}


/* doesn't seem to belong here. should be in gI_cfg.c or so (is actually already
   present in gI_prefs.c) */
void set_cfg_defaults()
{
	glong i;

/*	cfg->cfgfile = NULL;*/

	cfg->cc = (gchar *) realloc( cfg->cc, 10 );
	strcpy( cfg->cc, "gcc" );

	cfg->make = (gchar *) realloc( cfg->make, 10 );
	strcpy( cfg->make, "make" );

	cfg->tmpdir = (gchar *) realloc( cfg->tmpdir, 10 );
	strcpy( cfg->tmpdir, "/tmp" );

	cfg->fontname = (gchar *) realloc( cfg->fontname, 100 );

	strcpy( cfg->fontname, "-dec-terminal-medium-r-normal-*-*-140-*-*-c-*-iso8859-1" );
/*	cfg->font = NULL;*/
	cfg->disable_font_stuff = FALSE;
	cfg->bgcol = NULL;
	cfg->fgcol = NULL;

	cfg->wordwrap = TRUE;

	cfg->autosave = FALSE;
	cfg->autosave_freq = 0;
	cfg->use_redit = FALSE;
	cfg->redit = (gchar *) realloc( cfg->redit, 2 );
	strcpy( cfg->redit, "" );
	cfg->highlight = FALSE;
	cfg->ign_file = (gchar *) realloc( cfg->ign_file, 20 );
	strcpy( cfg->ign_file, "functions.ignore" );

	cfg->toolbar = TRUE;
	cfg->toolbar_custom = FALSE;
	cfg->toolbar_custom_items_no = 0;
	for(i=0; i<MAX_TOOLBAR_ITEMS; i++)
	{
		cfg->toolbar_custom_items[i] = NULL;
	}
	cfg->prjftree = TRUE;

#ifdef HAVE_GTKTEXT_PATCH
	cfg->hli_file = (gchar *) realloc( cfg->hli_file, 20 );
strcpy( cfg->hli_file, "functions.highlight" );
	cfg->patternfile = (gchar *) realloc( cfg->patternfile, 20 );
	strcpy( cfg->patternfile, PATTERNS );
	cfg->globassocfile = (gchar *) realloc( cfg->globassocfile, 10 );
	strcpy( cfg->globassocfile, GLOBASSOC );
#endif

	cfg->tab_width = 4;
	cfg->incpath = (gchar *) realloc( cfg->incpath, 40 );
	strcpy( cfg->incpath, "/usr/include:/usr/local/include" );
	cfg->ccopt = (gchar *) realloc( cfg->ccopt, 2 );
	strcpy( cfg->ccopt, "" );
	cfg->libpath = (gchar *) realloc( cfg->libpath, 40 );
	strcpy( cfg->libpath, "/lib:/usr/lib:/usr/local/lib" );
	cfg->ldopt = (gchar *) realloc( cfg->ldopt, 2 );
	strcpy( cfg->ldopt, "" );

	cfg->bash = (gchar *) realloc( cfg->bash, 20 );
	strcpy( cfg->bash, "/bin/bash" );

	cfg->xterm = (gchar *) realloc( cfg->xterm, 10 );
	strcpy( cfg->xterm, "xterm" );

	cfg->man = (gchar *) realloc( cfg->man, 5 );
	strcpy( cfg->man, "man" );

#ifdef HAVE_GTKTEXT_PATCH
	cfg->edtab = TRUE;
#endif

	cfg->db = (gchar *) realloc( cfg->db, 10 );
	strcpy( cfg->db, "gdb" );

	cfg->smtp = (gchar *) realloc( cfg->smtp, 20 );
	strcpy( cfg->smtp, "127.0.0.1" );

	cfg->email = (gchar *) realloc( cfg->email, 1 );
	strcpy( cfg->email, "" );

	cfg->sor = 0;

	if( cfg->style )
	{
		gtk_style_unref( cfg->style );
	}
	cfg->style = gtk_style_new();
	gdk_font_unref( cfg->style->font );
	cfg->style->font = gdk_font_load( cfg->fontname );
/*	if( !cfg->style->font )
	{
		strcpy( cfg->fontname, "default font???" );
		cfg->style->font = gdk_font_load( cfg->fontname );
	}*/
}

/* some things here happen also in prefs (since they change when prefs change).
   so, should be in common function */
static void real_main( gint argc, gchar *argv[] )
{
	gint nofargs = 0;
	gchar* extra_dir;
	gchar* home;
	const char** startup_files = NULL;

#if HAVE_GTKTEXT_PATCH
#if !HAVE_GUILE
	gchar pfwp[STRLEN];
	gchar *tmp;
#endif
#endif
	home = g_get_home_dir();
	if( !home ) {
		gnome_error_dialog( "Home directory not found!" );
		exit( -1 );
	}

	g_snprintf( gide_path, MAXLEN, "%s/.gide", home );

	if( mkdir( gide_path, 00750 ) == 0 ) {
		g_print("Created %s!\n",gide_path );
		extra_dir = g_strconcat( GIDE_CFGDIR, "/extra", NULL );
		gI_get_cfgfiles( extra_dir, gide_path );
		g_free( extra_dir );
	}

	g_snprintf( tools_path, MAXLEN, "%s/tools", gide_path );

	if( mkdir( tools_path, 00750 ) == 0 ) {
		g_print("Created %s!\n",tools_path);
	}

	g_snprintf( prj_path, MAXLEN, "%s/projects", gide_path );

	if( mkdir( prj_path, 00750 ) == 0 ) {
		g_print("Created %s!\n",prj_path);
	}

	cfg = (gI_config *) g_malloc0( sizeof( gI_config ) );

	/* Set Defaults */
	set_cfg_defaults();

	/* load compile sets */
	load_compile_sets( CSET_FILE );

#if HAVE_GUILE
	/* initialise guilesupport */
	guile_init ();
#endif

	/* Initialize plugins */
	plugins_init( NULL );
		
	cfg->cfgfile = cfgfile;
	cfg->disable_font_stuff = disablefontstuff;

	/* parse config file */
	if( !cfg->cfgfile )
		cfg->cfgfile = (gchar *) getenv( "GIDECFG" );

	if( !cfg->cfgfile )
	{
		/* memory leak! */
		cfg->cfgfile = g_strdup_printf("%s/%s", gide_path, CONFIG);
	}

#if HAVE_GUILE
	/* parse config file...with guile, we just treat the input file as a
	* scheme program.  This one file is responsible for configuring
	* everything, we don't need different files for patterns and glob
	* assoc.  */
	/* FIXME: we need another error handler... */
	gh_eval_file_with_standard_handler( cfg->cfgfile );

	/* now guile has the config stuff...we're gonna extract it! */
	guile_extract_cfg ();

#if HAVE_GTKTEXT_PATCH
	guile_extract_pattern_list();
	guile_extract_globassoc();
#endif

#else /*!HAVE_GUILE*/

	/* parse config file */
	gI_cf_parse( cfg->cfgfile );

#ifdef HAVE_GTKTEXT_PATCH
	g_snprintf( pfwp, STRLEN, cfg->patternfile );
	tmp = g_strconcat (gide_path, "/", cfg->patternfile, NULL);
	gI_hilite_load_patterns( tmp );
	g_free ( tmp );
	g_snprintf( pfwp, STRLEN, cfg->globassocfile );
	tmp = g_strconcat (gide_path, "/", cfg->globassocfile, NULL);
	gI_glob_load_globassoc ( tmp );
	g_free ( tmp );
#endif

#endif /*HAVE_GUILE*/

	if( !cfg->disable_font_stuff )
	{
		GdkFont* new_font;
		if( cfg->style )
		{
			gtk_style_unref( cfg->style );
		}
		cfg->style = gtk_style_new();
		gdk_font_unref( cfg->style->font );
		if( (new_font = gdk_font_load( cfg->fontname )) )
		{
			cfg->style->font = new_font;
		}
	}

	main_window = gide_window_new();
	
	/* open the files */
	startup_files = poptGetArgs(ctx);
	nofargs = 0;
	if (startup_files)
	{
		while (startup_files[nofargs])
		{
			file_open_by_name( main_window,
					   g_strdup(startup_files[nofargs]));
			nofargs++;
		}
	}
	poptFreeContext(ctx);

	if( nofargs == 0 )
	{
		/* no files given on the commandline, open files from last session */
		open_history( HISTORY );
	}

	/* GTK Main Loop */
	gtk_main();

	/* Destroy the main_window */
	gtk_object_destroy( GTK_OBJECT(main_window) );

	/* free path/widget association for menus */
	gI_menus_free_items( main_window );

	/* free config */
	free_cfg( cfg );
}


gint main( gint argc, gchar **argv )
{
	/* Internationalization */
	bindtextdomain(PACKAGE, GNOMELOCALEDIR);
	textdomain(PACKAGE);

#ifdef HAVE_LIBGNORBA
	/* GNOME CORBA Init */
	global_ev = g_new0 (CORBA_Environment, 1);

	CORBA_exception_init (global_ev);
	global_orb = gnome_CORBA_init_with_popt_table( PACKAGE,
						       VERSION,
						       &argc, argv,
						       gIDE_popt_options,
						       0, &ctx, 0,
						       global_ev );
	corba_exception( global_ev );

	root_poa = CORBA_ORB_resolve_initial_references( global_orb,
							 "RootPOA",
							 global_ev );
	corba_exception( global_ev );

	root_poa_manager =
		PortableServer_POA__get_the_POAManager( root_poa,
							global_ev );
	corba_exception( global_ev );

	PortableServer_POAManager_activate( root_poa_manager, global_ev );
	corba_exception( global_ev );

	name_service = gnome_name_service_get();
#else
	gnome_init_with_popt_table(PACKAGE, VERSION,
				   argc, argv, gIDE_popt_options,
				   0, &ctx);
#endif

	glade_gnome_init ();
	
#if HAVE_GUILE
	/* then we init, and enter guile */
	gh_enter( argc, argv, real_main );
#else
	real_main(argc, argv);
#endif

	/* alls great, return EXIT_SUCCESS */
	return( EXIT_SUCCESS );
}
