/* gIDE
 * Copyright (C) 2001 Dirk Vangestel
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.  
 */

#ifndef __GIDE_DOC_H__
#define __GIDE_DOC_H__

#include <gdl/GDL.h>

GNOME_Development_EditorBuffer gide_get_editor_buffer (GideTool *tool);

gboolean gide_show_file (GideTool* tool, gchar* path);
gchar* gide_get_current_filename (GideTool* tool);
char *gide_get_current_word (GideTool *tool);
glong gide_get_document_length (GideTool* tool);
gchar* gide_get_document_chars (GideTool* tool, glong start_pos, glong end_pos);

glong gide_get_line_num (GideTool* tool);
void gide_set_line_num (GideTool* tool, glong line);

glong gide_get_cursor_pos (GideTool* tool);
void gide_set_cursor_pos (GideTool* tool, glong pos);

void gide_insert_text_at_pos (GideTool *tool, glong pos, gchar *text);
void gide_insert_text_at_cursor (GideTool *tool, gchar *text);
void gide_delete_text (GideTool *tool, glong startpos, glong endpos);

void gide_add_marker (GideTool *tool, const char *path, 
		      int line, const char *type);
void gide_remove_marker (GideTool *tool, const char *path, 
			 int line, const char *type);

#endif
