/* gIDE
 * Copyright (C) 2000 Dave Camp
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.  
 */

#ifndef GIDE_DOCUMENT_MANAGER_H
#define GIDE_DOCUMENT_MANAGER_H

#include <bonobo.h>
#include <gnome.h>
#include "gide-document.h"
#include "gide-document-manager-obj.h"

BEGIN_GNOME_DECLS
 
typedef struct _GideDocumentManager      GideDocumentManager;
typedef struct _GideDocumentManagerClass GideDocumentManagerClass;
typedef struct _GideDocumentManagerPriv  GideDocumentManagerPriv;

#define GIDE_DOCUMENT_MANAGER_TYPE        (gide_document_manager_get_type ())
#define GIDE_DOCUMENT_MANAGER(o)          (GTK_CHECK_CAST ((o), GIDE_DOCUMENT_MANAGER_TYPE, GideDocumentManager))
#define GIDE_DOCUMENT_MANAGER_CLASS(k)    (GTK_CHECK_CLASS_CAST((k), GIDE_DOCUMENT_MANAGER_TYPE, GideDocumentManagerClass))
#define GIDE_IS_DOCUMENT_MANAGER(o)       (GTK_CHECK_TYPE ((o), GIDE_DOCUMENT_MANAGER_TYPE))
#define GIDE_IS_DOCUMENT_MANAGER_CLASS(k) (GTK_CHECK_CLASS_TYPE ((k), GIDE_DOCUMENT_MANAGER_TYPE))

struct _GideDocumentManager {
	GtkNotebook parent;

	GideDocument *current_document;

	GList *documents;
	Bonobo_UIContainer ui_container;
	GideDocumentManagerObj *docman_obj;

	GideDocumentManagerPriv *priv;
};

struct _GideDocumentManagerClass {
	GtkNotebookClass parent_class;

	void (*current_document_changed)(GideDocumentManager *docman, 
					 GideDocument *document);
};
GtkType       gide_document_manager_get_type          (void);
GtkWidget *   gide_document_manager_new               (Bonobo_UIContainer ui_container);


/* Document Manipulation */
void gide_document_manager_add_doc (GideDocumentManager *docman,
				    GideDocument        *doc);

void gide_document_manager_remove_doc (GideDocumentManager *docman, 
				       GideDocument *doc);

void          gide_document_manager_goto_doc_by_index (GideDocumentManager *docman,
						       gint                 index);
gint          gide_document_manager_num_docs          (GideDocumentManager *docman);
gint gide_document_manager_num_changed_docs (GideDocumentManager *docman);
GideDocument *gide_document_manager_get_nth_doc       (GideDocumentManager *docman,
						       guint                index);
GideDocument *gide_document_manager_get_doc_by_name   (GideDocumentManager *doc,
						       const char *filename);
GideDocument *gide_document_manager_get_current_doc   (GideDocumentManager *docman);
gchar * gide_document_manager_get_doc_label (GideDocumentManager *docman, 
					     GideDocument *document);

void gide_document_manager_set_doc_label (GideDocumentManager *docman,
				     GideDocument *document,
					  const gchar *str);
void
gide_document_manager_set_doc_label_style (GideDocumentManager *docman,
					   GideDocument *document,
					   GtkStyle *style);
gboolean gide_document_manager_is_open_doc (GideDocumentManager *docman, 
				   const gchar *filename);





/* Navigation */
void          gide_document_manager_goto_doc_by_index (GideDocumentManager *docman,
						       gint                 index);
void          gide_document_manager_goto_doc_by_file  (GideDocumentManager *docman,
						       const gchar         *filename);






END_GNOME_DECLS
#endif
