/* gIDE
 * Copyright (C) 2000 Helix Code, Inc.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.  
 */

#ifndef SHELL_H
#define SHELL_H

#include <bonobo.h>
#include <bonobo/bonobo-event-source.h>
#include <libgide/libgide.h>
#include "gI_window.h"

BEGIN_GNOME_DECLS
 
typedef struct _GideShell      GideShell;
typedef struct _GideShellClass GideShellClass;
typedef struct _GideShellPriv  GideShellPriv;

#define GIDE_SHELL_TYPE        (gide_shell_get_type ())
#define GIDE_SHELL(o)          (GTK_CHECK_CAST ((o), GIDE_SHELL_TYPE, GideShell))
#define GIDE_SHELL_CLASS(k)    (GTK_CHECK_CLASS_CAST((k), GIDE_SHELL_TYPE, GideShellClass))
#define GIDE_IS_SHELL(o)       (GTK_CHECK_TYPE ((o), GIDE_SHELL_TYPE))
#define GIDE_IS_SHELL_CLASS(k) (GTK_CHECK_CLASS_TYPE ((k), GIDE_SHELL_TYPE))

struct _GideShell {
	BonoboObject parent;
	
	GideWindow *window;
	BonoboEventSource *event_source;
	BonoboItemContainer *item_container;
	
	char *id;

	GideShellPriv *priv;
};

struct _GideShellClass {
	BonoboObjectClass parent_class;
};

GtkType gide_shell_get_type (void);
GideShell *gide_shell_new (GideWindow *win);

GideShell *gide_get_shell (const char *id);

END_GNOME_DECLS
#endif
