/* gIDE
 * Copyright (C) 2000 Dave Camp
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.  
 */

#ifndef GIDE_TOOL_H
#define GIDE_TOOL_H

#include <bonobo.h>

BEGIN_GNOME_DECLS

typedef struct _GideTool      GideTool;
typedef struct _GideToolClass GideToolClass;
typedef struct _GideToolPriv  GideToolPriv;

#define GIDE_TOOL_TYPE        (gide_tool_get_type ())
#define GIDE_TOOL(o)          (GTK_CHECK_CAST ((o), GIDE_TOOL_TYPE, GideTool))
#define GIDE_TOOL_CLASS(k)    (GTK_CHECK_CLASS_CAST((k), GIDE_TOOL_TYPE, GideToolClass))
#define GIDE_IS_TOOL(o)       (GTK_CHECK_TYPE ((o), GIDE_TOOL_TYPE))
#define GIDE_IS_TOOL_CLASS(k) (GTK_CHECK_CLASS_TYPE ((k), GIDE_TOOL_TYPE))

typedef gboolean (*GideToolInitFn) (GideTool *tool,
				    gpointer closure);
typedef void     (*GideToolCleanupFn) (GideTool *tool,
				       gpointer closure);

struct _GideTool {
	GtkObject parent;

	GNOME_Development_Environment_Shell shell;
	char *shell_id;
	Bonobo_UIContainer ui_container;	

	GideToolPriv *priv;
	gpointer data;

	BonoboPropertyBag *props;
};

struct _GideToolClass {
	BonoboObjectClass parent_class;
};

GtkType   gide_tool_get_type (void);
GideTool *gide_tool_new      (GideToolInitFn    init_fn,
			      GideToolCleanupFn cleanup_fn,
			      gpointer          data);




END_GNOME_DECLS
#endif
