/* gIDE
 * 
 * Copyright (C) 2001 Dave Camp <dave@ximian.com>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.  
 */

#include <config.h>
#include "gide-document-obj.h"
#include <libgide/libgide.h>
#include "gide-document.h"

#define PARENT_TYPE BONOBO_X_OBJECT_TYPE

static GtkObjectClass *parent_class = NULL;

GideDocumentObj *
gide_document_obj_construct (GideDocumentObj *docobj, GideDocument *doc)
{
	docobj->doc = doc;

	return docobj;
}

GideDocumentObj *
gide_document_obj_new (GideDocument *doc)
{
	GideDocumentObj *docobj = gtk_type_new (GIDE_DOCUMENT_OBJ_TYPE);

	return gide_document_obj_construct (docobj, doc);
}

/* implementation functions */

static char *
impl_get_filename (PortableServer_Servant servant,
		   CORBA_Environment *ev)
{
	GideDocumentObj *docobj = GIDE_DOCUMENT_OBJ (bonobo_object_from_servant (servant));
	char *filename = gide_document_get_filename (docobj->doc);
	filename = filename ? filename : "";
	
	return CORBA_string_dup (filename);
}

static char *
impl_get_mime_type (PortableServer_Servant servant,
		    CORBA_Environment *ev)
{
	GideDocumentObj *docobj = GIDE_DOCUMENT_OBJ (bonobo_object_from_servant (servant));

	return CORBA_string_dup (gide_document_get_mime_type (docobj->doc));
}

static Bonobo_Control
impl_get_editor (PortableServer_Servant servant,
		 CORBA_Environment *ev)
{
	GideDocumentObj *docobj = GIDE_DOCUMENT_OBJ (bonobo_object_from_servant (servant));
	BonoboObjectClient *cli;
	
	cli = gide_document_get_control (GIDE_DOCUMENT (docobj->doc));
	
	return bonobo_object_dup_ref (BONOBO_OBJREF (cli), ev);
}

static Bonobo_Unknown
impl_get_editor_interface (PortableServer_Servant servant,
			   const CORBA_char *repo_id,
			   CORBA_Environment *ev)
{
	GideDocumentObj *docobj = GIDE_DOCUMENT_OBJ (bonobo_object_from_servant (servant));
	BonoboObjectClient *cli;
	Bonobo_Unknown obj;
	

	cli = gide_document_get_control (GIDE_DOCUMENT (docobj->doc));
	obj = Bonobo_Unknown_queryInterface (BONOBO_OBJREF (cli), repo_id, ev);
	
	return obj;
}

static void 
gide_document_obj_destroy (GtkObject *object)
{
//	GideDocumentObj *docobj = GIDE_DOCUMENT_OBJ (object);
	parent_class->destroy (object);
}

static void
gide_document_obj_class_init (GideDocumentObjClass *klass)
{
	GtkObjectClass *object_class = (GtkObjectClass *)klass;
	POA_GNOME_Development_Environment_Document__epv *epv = &klass->epv;
	parent_class = gtk_type_class (PARENT_TYPE);
	object_class->destroy = gide_document_obj_destroy;

	epv->getFilename = impl_get_filename;
	epv->getMimeType = impl_get_mime_type;
	epv->getEditor = impl_get_editor;
	epv->getEditorInterface = impl_get_editor_interface;
}

static void 
gide_document_obj_init (GideDocumentObj *bs)
{
}

GtkType
gide_document_obj_get_gtk_type (void)
{
	static GtkType type = 0;
	
	if (!type) {
		GtkTypeInfo info = {
			"GideDocumentObj",
			sizeof (GideDocumentObj),
			sizeof (GideDocumentObjClass),
			(GtkClassInitFunc) gide_document_obj_class_init,
			(GtkObjectInitFunc) gide_document_obj_init,
			NULL, NULL, 
			(GtkClassInitFunc) NULL
		};
		
		type = bonobo_x_type_unique (PARENT_TYPE,
					     POA_GNOME_Development_Environment_Document__init,
					     NULL, GTK_STRUCT_OFFSET (GideDocumentObjClass, epv), &info);
	}
	return type;
}
