/*
 * gIDE functiontree plugin
 *
 * Shows a tree of functions in the active documents
 */

#include <config.h>

#include <gnome.h>
#include <bonobo.h>
#include <liboaf/liboaf.h>
#include <libgide/libgide.h>
#include <unistd.h>
#include <sys/stat.h>
#include <gdl/GDL.h>
#include <dirent.h>
#include <errno.h>

#include "help.h"

#define HELP_COMPONENT_IID "OAFIID:GNOME_Development_Plugin:help"
#define PLUGIN_NAME			"gide-help-plugin"
#define PLUGIN_XML			"gide-help-plugin.xml"

static gboolean
is_program_in_path (const char *program)
{
        static char **paths = NULL;
        char **p;
        
        if (paths == NULL)
                paths = g_strsplit(g_getenv("PATH"), ":", -1);
        
        for (p = paths; *p != NULL; p++){
                char *f = g_strconcat (*p, "/", program, NULL);
                if (access (f, X_OK) == 0) {
                        g_free (f);
			return 1;
		}
		
                g_free (f);
        }
        return 0;
}

static void
show_man_browser (
	GtkWidget*			widget,
	gpointer			data
)
{
	GideTool*			tool = (GideTool*)data;

	help(tool);
}

static void
show_devhelp (GtkWidget *widget, gpointer data)
{
	GideTool *tool = GIDE_TOOL (data);
	
	if (is_program_in_path ("devhelp")) {
		char *argv[] = { "devhelp" };
		gnome_execute_async (g_get_home_dir (), 1, argv);
	} else {
		gI_error_dialog (_("The devhelp program is not installed.  You must install devhelp to browse developer documentation."));
	}
}

static void
show_devhelp_function (GtkWidget *widget, gpointer data)
{
	GideTool *tool = GIDE_TOOL (data);
	
	if (is_program_in_path ("devhelp")) {
		char *curword;
		curword = gide_get_current_word (tool);
		if (curword) {
			char *argv[] = { "devhelp", "--use-factory", "-s", NULL };
			argv[3] = curword;
			gnome_execute_async (g_get_home_dir (), 4, argv);
			g_free (curword);
		}
	} else {
		gI_error_dialog (_("The devhelp program is not installed.  You must install devhelp to browse developer documentation."));
	}
}

/*
 * Define the verbs in this plugin
 */
static BonoboUIVerb verbs[] = {
	BONOBO_UI_UNSAFE_VERB("Man", show_man_browser),
	BONOBO_UI_UNSAFE_VERB("Devhelp", show_devhelp),
	BONOBO_UI_UNSAFE_VERB("DevhelpFunction", show_devhelp_function),
	BONOBO_UI_VERB_END
};

/*
 * Boilerplate initialization function
 */
static gboolean
impl_init(
	GideTool*			tool,
	gpointer			closure
)
{
	BonoboUIComponent*		uic;
	CORBA_Environment		ev;

	g_return_val_if_fail(tool != NULL, FALSE);
	g_return_val_if_fail(GIDE_IS_TOOL(tool), FALSE);

	CORBA_exception_init(&ev);

	uic = bonobo_ui_component_new(PLUGIN_NAME);
	bonobo_ui_component_set_container(uic, tool->ui_container);
	bonobo_ui_util_set_ui(uic, GIDE_DATADIR, PLUGIN_XML,
		PLUGIN_NAME);

	bonobo_ui_component_add_verb_list_with_data(uic, verbs, tool);

	CORBA_exception_free(&ev);

	return TRUE;
}

/*
 * Boilerplace cleanup function
 */
static void
impl_cleanup(
	GideTool*			tool,
	gpointer			closure
)
{
}

/*
 * Boilerplate creation function
 */
static CORBA_Object
make_object(
	PortableServer_POA		poa,
	const char*			iid,
	gpointer			impl_ptr,
	CORBA_Environment*		ev
)
{
	GideTool*			tool;

	tool = gide_tool_new(impl_init, impl_cleanup, NULL);

	oaf_plugin_use(poa, impl_ptr);

	return BONOBO_OBJREF (tool->props);
}

/*
 * List of plugins
 */
static const OAFPluginObject plugin_list[] =
{
	{
		HELP_COMPONENT_IID,
		make_object
	},
	{
		NULL
	}
};

/*
 * Plugin description
 */
const OAFPlugin OAF_Plugin_info = {
	plugin_list,
	"gIDE Help Plugin"
};
