/*
 * gIDE swapch plugin
 *
 * Switches besteen .c and .h file
 */

#include <config.h>

#include <libgide/libgide.h>
#include <unistd.h>
#include <sys/stat.h>
#include <ctype.h>

#define SWAPCH_COMPONENT_IID "OAFIID:GNOME_Development_Plugin:swapch"
#define PLUGIN_NAME			"gide-swapch-plugin"
#define PLUGIN_XML			"gide-swapch-plugin.xml"

static void
swapch(
	GtkWidget*			widget,
	gpointer			data
)
{
	GideTool*			tool = (GideTool*)data;
	size_t				len;
	gchar*				newfname;
	gchar*				filename;

	filename = gide_get_current_filename(tool);
	if(!filename)
	{
		return;
	}

	len = strlen(filename) - 1;
	while(len)
	{
		if(filename[len] == '.')
		{
			break;
		}

		--len;
	}
	if(!len)
	{
		return;
	}

	if(strcasecmp(&filename[len], ".h") == 0)
	{
		len++;
		newfname = g_malloc(len + 4);
		strcpy(newfname, filename);
		strcpy(&newfname[len], "cc");
		if(!file_check_if_exist(newfname, FALSE))
		{
			strcpy(&newfname[len], "cpp");
			if(!file_check_if_exist(newfname, FALSE))
			{
				newfname[len + 1] = 0;
				if(!file_check_if_exist(newfname, TRUE))
				{
					g_free(newfname);
					return;
				}
			}
		}
	}
	else if(strncasecmp(&filename[len], ".c", 2) == 0)
	{
		len++;
		newfname = g_strdup(filename);
		newfname[len] = 'h';
		newfname[len + 1] = 0;
		if(!file_check_if_exist(newfname, TRUE))
		{
			g_free(newfname);
			return;
		}
	}
	else
	{
		return;
	}

	gide_show_file(tool, newfname);
	g_free(newfname);
}

/*
 * Define the verbs in this plugin
 */
static BonoboUIVerb verbs[] = {
	BONOBO_UI_UNSAFE_VERB("SwapCH", swapch),
	BONOBO_UI_VERB_END
};

/*
 * Boilerplate initialization function
 */
static gboolean
impl_init(
	GideTool*			tool,
	gpointer			closure
)
{
	BonoboUIComponent*		uic;
	CORBA_Environment		ev;

	g_return_val_if_fail(tool != NULL, FALSE);
	g_return_val_if_fail(GIDE_IS_TOOL(tool), FALSE);

	CORBA_exception_init(&ev);

	uic = bonobo_ui_component_new(PLUGIN_NAME);
	bonobo_ui_component_set_container(uic, tool->ui_container);
	bonobo_ui_util_set_ui(uic, GIDE_DATADIR, PLUGIN_XML,
		PLUGIN_NAME);

	bonobo_ui_component_add_verb_list_with_data(uic, verbs, tool);

	CORBA_exception_free(&ev);

	return TRUE;
}

/*
 * Boilerplace cleanup function
 */
static void
impl_cleanup(
	GideTool*			tool,
	gpointer			closure
)
{
}

/*
 * Boilerplate creation function
 */
static CORBA_Object
make_object(
	PortableServer_POA		poa,
	const char*			iid,
	gpointer			impl_ptr,
	CORBA_Environment*		ev
)
{
	GideTool*			tool;

	tool = gide_tool_new(impl_init, impl_cleanup, NULL);

	oaf_plugin_use(poa, impl_ptr);

	return BONOBO_OBJREF (tool->props);
}

/*
 * List of plugins
 */
static const OAFPluginObject plugin_list[] =
{
	{
		SWAPCH_COMPONENT_IID,
		make_object
	},
	{
		NULL
	}
};

/*
 * Plugin description
 */
const OAFPlugin OAF_Plugin_info = {
	plugin_list,
	"gIDE SwapCH Plugin"
};
