/* gIDE moniker: a moniker for simplifying access the gide object model 
 * 
 * Author:
 *    Dave Camp <dave@ximian.com>
 * 
 * Copyright 2001 Dave Camp
 */

#include <bonobo/bonobo-exception.h>
#include <bonobo/bonobo-moniker-util.h>

#include "moniker.h"
#include <shell.h>
#include <gdl/gdl.h>

static Bonobo_Unknown
resolve (BonoboMoniker *moniker,
			     const Bonobo_ResolveOptions *options,
			     const CORBA_char *requested_interface,
			     CORBA_Environment *ev)
{
	const char *name = bonobo_moniker_get_name (moniker);
	Bonobo_Unknown retval;
	GideShell *shell;
	
	shell = gide_get_shell (name);
	
	GDL_TRACE ();	

	if (!strcmp (requested_interface, "IDL:GNOME/Development/Environment/Shell:1.0")) {
		GDL_TRACE ();
		
		return bonobo_object_dup_ref (BONOBO_OBJREF (shell), ev);
	} else if (!strcmp (requested_interface, "IDL:Bonobo/ItemContainer:1.0")) {
		return bonobo_object_dup_ref (BONOBO_OBJREF (shell->item_container), ev);
	} else if (!strcmp (requested_interface, "IDL:Bonobo/EventSource:1.0")) {
		return bonobo_object_dup_ref (BONOBO_OBJREF (shell->event_source), ev);
	}
	
	return CORBA_OBJECT_NIL;
}

static BonoboObject *
moniker_factory (BonoboGenericFactory *fact,
		 const char *object_id,
		 void *data)
{
	GDL_TRACE ();
	return BONOBO_OBJECT (bonobo_moniker_simple_new ("gide:", resolve));
}

void
gide_moniker_init (void)
{
	BonoboGenericFactory *factory;

	GDL_TRACE ();

	factory = bonobo_generic_factory_new ("OAFIID:Bonobo_Moniker_gide_Factory", moniker_factory, NULL);
}



