/* The GIMP -- an image manipulation program
 * Copyright (C) 1995-2000 Spencer Kimball and Peter Mattis
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

/* NOTE: This file is autogenerated by pdbgen.pl. */

#include "procedural_db.h"

#include <string.h>

#include "gimage.h"
#include "path.h"
#include "pathP.h"

static ProcRecord path_list_proc;
static ProcRecord path_get_points_proc;
static ProcRecord path_get_current_proc;
static ProcRecord path_set_current_proc;
static ProcRecord path_set_points_proc;
static ProcRecord path_stroke_current_proc;
static ProcRecord path_get_point_at_dist_proc;
static ProcRecord path_get_tattoo_proc;
static ProcRecord get_path_by_tattoo_proc;
static ProcRecord path_delete_proc;
static ProcRecord path_get_locked_proc;
static ProcRecord path_set_locked_proc;
static ProcRecord path_set_tattoo_proc;

void
register_paths_procs (void)
{
  procedural_db_register (&path_list_proc);
  procedural_db_register (&path_get_points_proc);
  procedural_db_register (&path_get_current_proc);
  procedural_db_register (&path_set_current_proc);
  procedural_db_register (&path_set_points_proc);
  procedural_db_register (&path_stroke_current_proc);
  procedural_db_register (&path_get_point_at_dist_proc);
  procedural_db_register (&path_get_tattoo_proc);
  procedural_db_register (&get_path_by_tattoo_proc);
  procedural_db_register (&path_delete_proc);
  procedural_db_register (&path_get_locked_proc);
  procedural_db_register (&path_set_locked_proc);
  procedural_db_register (&path_set_tattoo_proc);
}

static Argument *
path_list_invoker (Argument *args)
{
  gboolean success = TRUE;
  Argument *return_args;
  GimpImage *gimage;
  gint32 num_paths = 0;
  gchar **path_list = NULL;
  PathList *plist;

  gimage = pdb_id_to_image (args[0].value.pdb_int);
  if (gimage == NULL)
    success = FALSE;

  if (success)
    {
      plist = gimage->paths;
    
      if (plist && plist->bz_paths)
	{
	  gint    count = 0;
	  GSList *pl    = plist->bz_paths;
    
	  num_paths = g_slist_length (pl);
    
	  path_list = g_new (gchar *, num_paths);
	  while (pl)
	    {
	      Path *pptr = pl->data;
	      path_list[count++] = g_strdup (pptr->name);
	      pl = pl->next;
	    }
	}
    }

  return_args = procedural_db_return_args (&path_list_proc, success);

  if (success)
    {
      return_args[1].value.pdb_int = num_paths;
      return_args[2].value.pdb_pointer = path_list;
    }

  return return_args;
}

static ProcArg path_list_inargs[] =
{
  {
    PDB_IMAGE,
    "image",
    "The ID of the image to list the paths from"
  }
};

static ProcArg path_list_outargs[] =
{
  {
    PDB_INT32,
    "num_paths",
    "The number of paths returned"
  },
  {
    PDB_STRINGARRAY,
    "path_list",
    "List of the paths belonging to this image"
  }
};

static ProcRecord path_list_proc =
{
  "gimp_path_list",
  "List the paths associated with the passed image.",
  "List the paths associated with the passed image.",
  "Andy Thomas",
  "Andy Thomas",
  "1999",
  PDB_INTERNAL,
  1,
  path_list_inargs,
  2,
  path_list_outargs,
  { { path_list_invoker } }
};

static Argument *
path_get_points_invoker (Argument *args)
{
  gboolean success = TRUE;
  Argument *return_args;
  GimpImage *gimage;
  gchar *pname;
  gint32 num_pdetails = 0;
  gdouble *pnts = NULL;
  PathList *plist;
  Path *pptr = NULL;

  gimage = pdb_id_to_image (args[0].value.pdb_int);
  if (gimage == NULL)
    success = FALSE;

  pname = (gchar *) args[1].value.pdb_pointer;
  if (pname == NULL)
    success = FALSE;

  if (success)
    {
      /* Get the path with the given name */
      plist = gimage->paths;
	  
      if (plist && plist->bz_paths)
	{
	  GSList *pl = plist->bz_paths;
    
	  while (pl)
	    {
	      pptr = pl->data;
    
	      if (!strcmp (pname, pptr->name))
		break; /* Found the path */
    
	      pl = pl->next;
	      pptr = NULL;
	    }
    
	  if (pl && pptr)
	    {
	      GSList  *points_list;
	      gint     pcount = 0;
    
	      points_list = pptr->path_details;
	      if (points_list)
		{
		  num_pdetails = g_slist_length (points_list) * 3;
    
		  pnts = g_new (gdouble, num_pdetails);
    
		  /* fill points and types in */
		  while (points_list)
		    {
		      PathPoint *ppoint = points_list->data;
		      pnts[pcount] = ppoint->x;
		      pnts[pcount + 1] = ppoint->y;
		      pnts[pcount + 2] = (gfloat) ppoint->type; /* Bit of fiddle but should be understandable why it was done */
		      pcount += 3;
		      points_list = points_list->next;
		    }
		}        
	      else
		success = FALSE;
	    }
	  else
	    success = FALSE;
	}
    }

  return_args = procedural_db_return_args (&path_get_points_proc, success);

  if (success)
    {
      return_args[1].value.pdb_int = pptr->pathtype;
      return_args[2].value.pdb_int = pptr->closed;
      return_args[3].value.pdb_int = num_pdetails;
      return_args[4].value.pdb_pointer = pnts;
    }

  return return_args;
}

static ProcArg path_get_points_inargs[] =
{
  {
    PDB_IMAGE,
    "image",
    "The ID of the image to list the paths from"
  },
  {
    PDB_STRING,
    "pathname",
    "the name of the path whose points should be listed"
  }
};

static ProcArg path_get_points_outargs[] =
{
  {
    PDB_INT32,
    "path_type",
    "The type of the path. Currently only one type (1 = Bezier) is supported"
  },
  {
    PDB_INT32,
    "path_closed",
    "Return if the path is closed. {0=path open, 1= path closed}"
  },
  {
    PDB_INT32,
    "num_path_point_details",
    "The number of points returned. Each point is made up of (x,y,pnt_type) of floats"
  },
  {
    PDB_FLOATARRAY,
    "points_pairs",
    "The points in the path represented as 3 floats. The first is the x pos, next is the y pos, last is the type of the pnt. The type field is dependant on the path type. For beziers (type 1 paths) the type can either be {1.0= BEZIER_ANCHOR, 2.0= BEZIER_CONTROL}. Note all points are returned in pixel resolution"
  }
};

static ProcRecord path_get_points_proc =
{
  "gimp_path_get_points",
  "List the points associated with the named path.",
  "List the points associated with the named path.",
  "Andy Thomas",
  "Andy Thomas",
  "1999",
  PDB_INTERNAL,
  2,
  path_get_points_inargs,
  4,
  path_get_points_outargs,
  { { path_get_points_invoker } }
};

static Argument *
path_get_current_invoker (Argument *args)
{
  gboolean success = TRUE;
  Argument *return_args;
  GimpImage *gimage;
  PathList *plist;
  Path *pptr = NULL;

  gimage = pdb_id_to_image (args[0].value.pdb_int);
  if (gimage == NULL)
    success = FALSE;

  if (success)
    {
      /* Get the path with the given name */
      plist = gimage->paths;
    
      if (plist && plist->bz_paths && plist->last_selected_row >= 0)
	pptr = (Path*) g_slist_nth_data (plist->bz_paths, plist->last_selected_row);
      else
	success = FALSE;
    }

  return_args = procedural_db_return_args (&path_get_current_proc, success);

  if (success)
    return_args[1].value.pdb_pointer = g_strdup (pptr->name);

  return return_args;
}

static ProcArg path_get_current_inargs[] =
{
  {
    PDB_IMAGE,
    "image",
    "The ID of the image to get the current paths from"
  }
};

static ProcArg path_get_current_outargs[] =
{
  {
    PDB_STRING,
    "current_path_name",
    "The name of the current path"
  }
};

static ProcRecord path_get_current_proc =
{
  "gimp_path_get_current",
  "The name of the current path. Error if no paths.",
  "The name of the current path. Error if no paths.",
  "Andy Thomas",
  "Andy Thomas",
  "1999",
  PDB_INTERNAL,
  1,
  path_get_current_inargs,
  1,
  path_get_current_outargs,
  { { path_get_current_invoker } }
};

static Argument *
path_set_current_invoker (Argument *args)
{
  gboolean success = TRUE;
  GimpImage *gimage;
  gchar *pname;

  gimage = pdb_id_to_image (args[0].value.pdb_int);
  if (gimage == NULL)
    success = FALSE;

  pname = (gchar *) args[1].value.pdb_pointer;
  if (pname == NULL)
    success = FALSE;

  if (success)
    success = path_set_path (gimage, pname);

  return procedural_db_return_args (&path_set_current_proc, success);
}

static ProcArg path_set_current_inargs[] =
{
  {
    PDB_IMAGE,
    "image",
    "The ID of the image to list set the paths in"
  },
  {
    PDB_STRING,
    "set_current_path_name",
    "The name of the path to set the current path to"
  }
};

static ProcRecord path_set_current_proc =
{
  "gimp_path_set_current",
  "List the paths associated with the passed image.",
  "List the paths associated with the passed image.",
  "Andy Thomas",
  "Andy Thomas",
  "1999",
  PDB_INTERNAL,
  2,
  path_set_current_inargs,
  0,
  NULL,
  { { path_set_current_invoker } }
};

static Argument *
path_set_points_invoker (Argument *args)
{
  gboolean success = TRUE;
  GimpImage *gimage;
  gchar *pname = NULL;
  gint32 ptype;
  gint32 numpoints = 0;
  gdouble *pnts;
  gboolean pclosed = FALSE;

  gimage = pdb_id_to_image (args[0].value.pdb_int);
  if (gimage == NULL)
    success = FALSE;

  pname = (gchar *) args[1].value.pdb_pointer;
  if (pname == NULL)
    success = FALSE;

  ptype = args[2].value.pdb_int;

  numpoints = args[3].value.pdb_int;
  if (numpoints <= 0)
    success = FALSE;

  pnts = (gdouble *) args[4].value.pdb_pointer;

  if (success)
    {
      if ((numpoints / 3) % 3 == 0)
	pclosed = TRUE;
      else if ((numpoints / 3) % 3 != 2)
	success = FALSE;
    
      if (success && !path_set_path_points (gimage, pname, ptype, pclosed,
					    numpoints, pnts))
	success = FALSE;
    }

  return procedural_db_return_args (&path_set_points_proc, success);
}

static ProcArg path_set_points_inargs[] =
{
  {
    PDB_IMAGE,
    "image",
    "The ID of the image to set the paths in"
  },
  {
    PDB_STRING,
    "pathname",
    "The name of the path to create (if it exists then a unique name will be created - query the list of paths if you want to make sure that the name of the path you create is unique. This will be set as the current path."
  },
  {
    PDB_INT32,
    "ptype",
    "The type of the path. Currently only one type (1 = Bezier) is supported"
  },
  {
    PDB_INT32,
    "num_path_points",
    "The number of points in the path. Each point is made up of (x,y,type) of floats. Currently only the creation of bezier curves is allowed. The type parameter must be set to (1) to indicate a BEZIER type curve. For BEZIERS. Note the that points must be given in the following order... ACCACCAC ... If the path is not closed the last control point is missed off. Points consist of three control points (control/anchor/control) so for a curve that is not closed there must be at least two points passed (2 x,y pairs). If num_path_pnts % 3 = 0 then the path is assumed to be closed and the points are ACCACCACCACC."
  },
  {
    PDB_FLOATARRAY,
    "points_pairs",
    "The points in the path represented as 3 floats. The first is the x pos, next is the y pos, last is the type of the pnt. The type field is dependant on the path type. For beziers (type 1 paths) the type can either be {1.0= BEZIER_ANCHOR, 2.0= BEZIER_CONTROL}. Note all points are returned in pixel resolution"
  }
};

static ProcRecord path_set_points_proc =
{
  "gimp_path_set_points",
  "Set the points associated with the named path.",
  "Set the points associated with the named path.",
  "Andy Thomas",
  "Andy Thomas",
  "1999",
  PDB_INTERNAL,
  5,
  path_set_points_inargs,
  0,
  NULL,
  { { path_set_points_invoker } }
};

static Argument *
path_stroke_current_invoker (Argument *args)
{
  gboolean success = TRUE;
  GimpImage *gimage;
  PathList *plist;
  Path *pptr = NULL;

  gimage = pdb_id_to_image (args[0].value.pdb_int);
  if (gimage == NULL)
    success = FALSE;

  if (success)
    {
      /* Get the path with the given name */
      plist = gimage->paths;
    
      if (plist && plist->bz_paths && plist->last_selected_row >= 0)
	{
	  if ((pptr = (Path*) g_slist_nth_data (plist->bz_paths,
						plist->last_selected_row)))
		  
	    path_stroke (gimage, plist, pptr); /* Found the path to stroke.. */
	  else
	    success = FALSE;
	}
      else
	success = FALSE;
    }

  return procedural_db_return_args (&path_stroke_current_proc, success);
}

static ProcArg path_stroke_current_inargs[] =
{
  {
    PDB_IMAGE,
    "image",
    "The ID of the image which contains the path to stroke"
  }
};

static ProcRecord path_stroke_current_proc =
{
  "gimp_path_stroke_current",
  "Stroke the current path in the passed image.",
  "Stroke the current path in the passed image.",
  "Andy Thomas",
  "Andy Thomas",
  "1999",
  PDB_INTERNAL,
  1,
  path_stroke_current_inargs,
  0,
  NULL,
  { { path_stroke_current_invoker } }
};

static Argument *
path_get_point_at_dist_invoker (Argument *args)
{
  gboolean success = TRUE;
  Argument *return_args;
  GimpImage *gimage;
  gdouble distance;
  gint32 x_point = 0;
  gint32 y_point = 0;
  gdouble gradient = 0;
  PathList *plist;
  Path *pptr = NULL;

  gimage = pdb_id_to_image (args[0].value.pdb_int);
  if (gimage == NULL)
    success = FALSE;

  distance = args[1].value.pdb_float;

  if (success)
    {
      /* Get the path with the given name */
      plist = gimage->paths;
    
      if (plist && plist->bz_paths && plist->last_selected_row >= 0)
	{
	  pptr = (Path*) g_slist_nth_data (plist->bz_paths,
					   plist->last_selected_row);
	  success = path_distance (pptr, distance, &x_point, &y_point,
				   &gradient);
	}
      else
	success = FALSE;
    }

  return_args = procedural_db_return_args (&path_get_point_at_dist_proc, success);

  if (success)
    {
      return_args[1].value.pdb_int = x_point;
      return_args[2].value.pdb_int = y_point;
      return_args[3].value.pdb_float = gradient;
    }

  return return_args;
}

static ProcArg path_get_point_at_dist_inargs[] =
{
  {
    PDB_IMAGE,
    "image",
    "The ID of the image the paths belongs to"
  },
  {
    PDB_FLOAT,
    "distance",
    "The distance along the path"
  }
};

static ProcArg path_get_point_at_dist_outargs[] =
{
  {
    PDB_INT32,
    "x_point",
    "The x position of the point"
  },
  {
    PDB_INT32,
    "y_point",
    "The y position of the point"
  },
  {
    PDB_FLOAT,
    "gradient",
    "The gradient at the specified point"
  }
};

static ProcRecord path_get_point_at_dist_proc =
{
  "gimp_path_get_point_at_dist",
  "Get point on a path at a specified distance along the path.",
  "This will return the x,y position of a point at a given distance along the bezier curve. The distance will the obtained by first digitizing the curve internally an then walking along the curve. For a closed curve the start of the path is the first point on the path that was created. This might not be obvious. Note the current path is used.",
  "Andy Thomas",
  "Andy Thomas",
  "1999",
  PDB_INTERNAL,
  2,
  path_get_point_at_dist_inargs,
  3,
  path_get_point_at_dist_outargs,
  { { path_get_point_at_dist_invoker } }
};

static Argument *
path_get_tattoo_invoker (Argument *args)
{
  gboolean success = TRUE;
  Argument *return_args;
  GimpImage *gimage;
  gchar *pname;
  gint32 tattoo = 0;
  PathList *plist;
  Path *pptr = NULL;

  gimage = pdb_id_to_image (args[0].value.pdb_int);
  if (gimage == NULL)
    success = FALSE;

  pname = (gchar *) args[1].value.pdb_pointer;
  if (pname == NULL)
    success = FALSE;

  if (success)
    {
      /* Get the path with the given name */
      plist = gimage->paths;
	  
      if (plist && plist->bz_paths)
	{
	  GSList *pl = plist->bz_paths;
    
	  while (pl)
	    {
	      pptr = pl->data;
    
	      if (!strcmp (pname, pptr->name))
		break; /* Found the path */
    
	      pl = pl->next;
	      pptr = NULL;
	    }
    
	  if (pl && pptr)
	    tattoo = path_get_tattoo (pptr);
	  else
	    success = FALSE;
	}
      else
	success = FALSE;
    }

  return_args = procedural_db_return_args (&path_get_tattoo_proc, success);

  if (success)
    return_args[1].value.pdb_int = tattoo;

  return return_args;
}

static ProcArg path_get_tattoo_inargs[] =
{
  {
    PDB_IMAGE,
    "image",
    "The image"
  },
  {
    PDB_STRING,
    "pathname",
    "the name of the path whose tattoo should be obtained"
  }
};

static ProcArg path_get_tattoo_outargs[] =
{
  {
    PDB_INT32,
    "tattoo",
    "The tattoo associated with the name path"
  }
};

static ProcRecord path_get_tattoo_proc =
{
  "gimp_path_get_tattoo",
  "Returns the tattoo associated with the name path.",
  "This procedure returns the tattoo associated with the specified path. A tattoo is a unique and permanent identifier attached to a path that can be used to uniquely identify a path within an image even between sessions.",
  "Andy Thomas",
  "Andy Thomas",
  "1999",
  PDB_INTERNAL,
  2,
  path_get_tattoo_inargs,
  1,
  path_get_tattoo_outargs,
  { { path_get_tattoo_invoker } }
};

static Argument *
get_path_by_tattoo_invoker (Argument *args)
{
  gboolean success = TRUE;
  Argument *return_args;
  GimpImage *gimage;
  gint32 tattoo;
  PathList *plist;
  Path *pptr = NULL;

  gimage = pdb_id_to_image (args[0].value.pdb_int);
  if (gimage == NULL)
    success = FALSE;

  tattoo = args[1].value.pdb_int;

  if (success)
    {
      /* Get the path with the given name */
      plist = gimage->paths;
    
      if (plist && plist->bz_paths)
	{        
	  if ((pptr = path_get_path_by_tattoo (gimage, tattoo)) == NULL)
	    success = FALSE;
	}
      else
	success = FALSE;
    }

  return_args = procedural_db_return_args (&get_path_by_tattoo_proc, success);

  if (success)
    return_args[1].value.pdb_pointer = g_strdup (pptr->name);

  return return_args;
}

static ProcArg get_path_by_tattoo_inargs[] =
{
  {
    PDB_IMAGE,
    "image",
    "The image"
  },
  {
    PDB_INT32,
    "tattoo",
    "The tattoo of the required path"
  }
};

static ProcArg get_path_by_tattoo_outargs[] =
{
  {
    PDB_STRING,
    "path_name",
    "The name of the path with the specified tattoo"
  }
};

static ProcRecord get_path_by_tattoo_proc =
{
  "gimp_get_path_by_tattoo",
  "Return the name of the path with the given tattoo.",
  "The procedure returns the name of the path in the specified image which has the passed tattoo. The tattoos are unique within the image and will be preserved across sessions and through renaming of the path. An error is returned if no path woth the specified tattoo can be found.",
  "Andy Thomas",
  "Andy Thomas",
  "1999",
  PDB_INTERNAL,
  2,
  get_path_by_tattoo_inargs,
  1,
  get_path_by_tattoo_outargs,
  { { get_path_by_tattoo_invoker } }
};

static Argument *
path_delete_invoker (Argument *args)
{
  gboolean success = TRUE;
  GimpImage *gimage;
  gchar *pname;

  gimage = pdb_id_to_image (args[0].value.pdb_int);
  if (gimage == NULL)
    success = FALSE;

  pname = (gchar *) args[1].value.pdb_pointer;
  if (pname == NULL)
    success = FALSE;

  if (success)
    success = path_delete_path (gimage, pname);

  return procedural_db_return_args (&path_delete_proc, success);
}

static ProcArg path_delete_inargs[] =
{
  {
    PDB_IMAGE,
    "image",
    "The ID of the image to list delete the paths from"
  },
  {
    PDB_STRING,
    "path_name_to_del",
    "The name of the path to delete"
  }
};

static ProcRecord path_delete_proc =
{
  "gimp_path_delete",
  "Delete the named paths associated with the passed image.",
  "Delete the named path.",
  "Andy Thomas",
  "Andy Thomas",
  "1999",
  PDB_INTERNAL,
  2,
  path_delete_inargs,
  0,
  NULL,
  { { path_delete_invoker } }
};

static Argument *
path_get_locked_invoker (Argument *args)
{
  gboolean success = TRUE;
  Argument *return_args;
  GimpImage *gimage;
  gchar *pname;
  gint32 lockstatus = 0;
  PathList *plist;
  Path *pptr = NULL;

  gimage = pdb_id_to_image (args[0].value.pdb_int);
  if (gimage == NULL)
    success = FALSE;

  pname = (gchar *) args[1].value.pdb_pointer;
  if (pname == NULL)
    success = FALSE;

  if (success)
    {
      /* Get the path with the given name */
      plist = gimage->paths;
	  
      if (plist && plist->bz_paths)
	{
	  GSList *pl = plist->bz_paths;
    
	  while (pl)
	    {
	      pptr = pl->data;
    
	      if (!strcmp (pname, pptr->name))
		break; /* Found the path */
    
	      pl = pl->next;
	      pptr = NULL;
	    }
    
	  if (pl && pptr)
	    lockstatus = pptr->locked;
	  else
	    success = FALSE;
	}
      else
	success = FALSE;
    }

  return_args = procedural_db_return_args (&path_get_locked_proc, success);

  if (success)
    return_args[1].value.pdb_int = lockstatus;

  return return_args;
}

static ProcArg path_get_locked_inargs[] =
{
  {
    PDB_IMAGE,
    "image",
    "The image"
  },
  {
    PDB_STRING,
    "pathname",
    "the name of the path whose locked status should be obtained"
  }
};

static ProcArg path_get_locked_outargs[] =
{
  {
    PDB_INT32,
    "lockstatus",
    "The lock status associated with the name path. 0 returned if the path is not locked. 1 is returned if the path is locked"
  }
};

static ProcRecord path_get_locked_proc =
{
  "gimp_path_get_locked",
  "Returns the locked status associated with the name path.",
  "This procedure returns the lock status associated with the specified path. A path can be \"locked\" which means that the transformation tool operations will also apply to the path.",
  "Andy Thomas",
  "Andy Thomas",
  "1999",
  PDB_INTERNAL,
  2,
  path_get_locked_inargs,
  1,
  path_get_locked_outargs,
  { { path_get_locked_invoker } }
};

static Argument *
path_set_locked_invoker (Argument *args)
{
  gboolean success = TRUE;
  GimpImage *gimage;
  gchar *pname;
  gint32 lockstatus = 0;
  PathList *plist;
  Path *pptr = NULL;

  gimage = pdb_id_to_image (args[0].value.pdb_int);
  if (gimage == NULL)
    success = FALSE;

  pname = (gchar *) args[1].value.pdb_pointer;
  if (pname == NULL)
    success = FALSE;

  lockstatus = args[2].value.pdb_int;

  if (success)
    {
      /* Get the path with the given name */
      plist = gimage->paths;
	  
      if (plist && plist->bz_paths)
	{
	  GSList *pl = plist->bz_paths;
    
	  while (pl)
	    {
	      pptr = pl->data;
    
	      if (!strcmp (pname, pptr->name))
		break; /* Found the path */
    
	      pl = pl->next;
	      pptr = NULL;
	    }
    
	  if (pl && pptr && lockstatus >=0 && lockstatus <= 1)
	    pptr->locked = lockstatus;
	  else
	    success = FALSE;
	}
      else
	success = FALSE;
    }

  return procedural_db_return_args (&path_set_locked_proc, success);
}

static ProcArg path_set_locked_inargs[] =
{
  {
    PDB_IMAGE,
    "image",
    "The image"
  },
  {
    PDB_STRING,
    "pathname",
    "the name of the path whose locked status should be set"
  },
  {
    PDB_INT32,
    "lockstatus",
    "The lock status associated with the name path. 0 if the path is not locked. 1 if the path is to be locked"
  }
};

static ProcRecord path_set_locked_proc =
{
  "gimp_path_set_locked",
  "Set the locked status associated with the name path.",
  "This procedure sets the lock status associated with the specified path. A path can be \"locked\" which means that the transformation tool operations will also apply to the path.",
  "Andy Thomas",
  "Andy Thomas",
  "1999",
  PDB_INTERNAL,
  3,
  path_set_locked_inargs,
  0,
  NULL,
  { { path_set_locked_invoker } }
};

static Argument *
path_set_tattoo_invoker (Argument *args)
{
  gboolean success = TRUE;
  GimpImage *gimage;
  gchar *pname;
  gint32 tattovalue = 0;
  PathList *plist;
  Path *pptr = NULL;

  gimage = pdb_id_to_image (args[0].value.pdb_int);
  if (gimage == NULL)
    success = FALSE;

  pname = (gchar *) args[1].value.pdb_pointer;
  if (pname == NULL)
    success = FALSE;

  tattovalue = args[2].value.pdb_int;

  if (success)
    {
      /* Get the path with the given name */
      plist = gimage->paths;
	  
      if (plist && plist->bz_paths)
	{
	  GSList *pl = plist->bz_paths;
    
	  while (pl)
	    {
	      pptr = pl->data;
    
	      if (!strcmp (pname, pptr->name))
		break; /* Found the path */
    
	      pl = pl->next;
	      pptr = NULL;
	    }
    
	  if (pl && pptr)
	    pptr->tattoo = tattovalue ;
	  else
	    success = FALSE;
	}
      else
	success = FALSE;
    }

  return procedural_db_return_args (&path_set_tattoo_proc, success);
}

static ProcArg path_set_tattoo_inargs[] =
{
  {
    PDB_IMAGE,
    "image",
    "The image"
  },
  {
    PDB_STRING,
    "pathname",
    "the name of the path whose tattoo should be set"
  },
  {
    PDB_INT32,
    "tattovalue",
    "The tattoo associated with the name path. Only values returned from 'path_get_tattoo' should be used here"
  }
};

static ProcRecord path_set_tattoo_proc =
{
  "gimp_path_set_tattoo",
  "Sets the tattoo associated with the name path.",
  "This procedure sets the tattoo associated with the specified path. A tattoo is a unique and permenant identifier attached to a path that can be used to uniquely identify a path within an image even between sessions. Note that the value passed to this function must have been obtained from a previous call to path_get_tattoo.",
  "Andy Thomas",
  "Andy Thomas",
  "1999",
  PDB_INTERNAL,
  3,
  path_set_tattoo_inargs,
  0,
  NULL,
  { { path_set_tattoo_invoker } }
};
