/* $Id$

   Copyright (C) 2018 Ole Aamot Software
   Author(s): Ole Aamot <ole@gnome.org>
   License: GNU GPL version 3
   Version: 0.0.4 (2018-07-14)
   Website: http://www.gingerblue.org/
 
 */
 
#include <gst/gst.h>
#include <gtk/gtk.h>
#include <glib/gstdio.h>
#include <glib/gi18n.h>
#include "gingerblue.h"

GingerblueData *gingerblue_data;

int main (int argc, char **argv) {
	GingerblueData *data;
	GtkWidget *window;
	GtkWidget *frame;
	GtkWidget *soundboard;
	GtkWidget *toolbar;
	GtkWidget *input_volume;
	gdouble input_volume_value;
	gtk_init (&argc, &argv);
	window = gtk_window_new (GTK_WINDOW_TOPLEVEL);
	gtk_container_set_border_width (GTK_CONTAINER (window), 10);
	gtk_window_set_title (GTK_WINDOW (window), _("GNOME Gingerblue 0.0.4 (2018-07-14)"));
	gtk_window_set_default_size (GTK_WINDOW (window), 720, 540);
	soundboard = gtk_box_new (GTK_ORIENTATION_VERTICAL, 10);
	input_volume = gtk_volume_button_new ();
	frame = gtk_frame_new (NULL);
	gtk_container_add (GTK_CONTAINER (frame), input_volume);
	gtk_container_add (GTK_CONTAINER (soundboard), frame);
	gtk_container_add (GTK_CONTAINER (window), soundboard);
	/* toolbar = gtk_toolbar_new (); */
	/* gtk_box_pack_start (GTK_BOX (soundboard),  */
	gtk_widget_show_all (window);
	gingerblue_data = gb_file_config_load (gingerblue_data, g_strconcat("gingerblue.xml", NULL));
	/* g_printf ("Cfg volume: %s\n", data->volume); */
	/* input_volume_value = g_ascii_strtod(data->volume, NULL); */
	g_printf ("INPUT volume: %0.2f\n", input_volume_value);
	/* gtk_scale_button_set_value (GTK_SCALE_BUTTON (input_volume), data->volume);  */
	gst_init (&argc, &argv);
	/* input_volume_value = gb_window_set_volume(GTK_VOLUME_BUTTON (input_volume), 0.00);   */
	g_signal_connect (GTK_VOLUME_BUTTON (input_volume), "value-changed", G_CALLBACK (gb_window_new_volume), 0);
	/* input_volume_value = gb_window_get_volume(GTK_VOLUME_BUTTON (input_volume), 0.00); */
	g_signal_connect (GTK_WINDOW (window), "destroy", G_CALLBACK (gtk_main_quit), NULL);
	g_free (gingerblue_data);
	gtk_main ();
	return (0);
}
