/* $Id$

   Copyright (C) 2018-2021 Aamot Software
   Author(s): Ole Aamot <ole@gnome.org>
   License: GNU GPL version 3
   Version: 0.4.1 (2021-05-29)
   Website: http://www.gingerblue.org/

 */

#include <config.h>
#include <stdlib.h>
#include <glib/gi18n.h>
#include <gst/gst.h>
#include <gst/player/player.h>
#include <gtk/gtk.h>
#include <glib/gstdio.h>
#include <glib/gi18n.h>
#include "gingerblue.h"
#include "gingerblue-chord.h"
#include "gingerblue-main.h"
#include "gingerblue-record.h"

static void gb_assistant_entry_changed(GtkEditable *, GtkAssistant *,
				       GstElement *);
static void gb_assistant_button_toggled(GtkCheckButton *, GtkAssistant *);
static void gb_assistant_button_clicked(GtkButton *, GtkAssistant *);
static void gb_assistant_cancel(GtkAssistant *, gpointer);
static void gb_assistant_close(GtkAssistant *, gpointer);
static void gb_assistant_apply(GtkAssistant *, gpointer);

typedef struct {
	GtkWidget *widget;
	gint index;
	const gchar *title;
	GtkAssistantPageType type;
	gboolean complete;
} PageInfo;

GtkWidget *musician_entry, *musician_label;
GtkWidget *song_entry, *song_label;
GtkWidget *instrument_entry, *instrument_label;
GtkWidget *label_entry, *label_label;
GtkWidget *line_entry, *line_label;
GtkWidget *recording_entry, *recording_label;
GtkWidget *summary_entry, *summary_label;

GMainLoop *main_loops;

static void gb_assistant_entry_changed(GtkEditable * editable,
				       GtkAssistant * assistant,
				       GstElement * pipeline)
{
	return;
}

static void gb_assistant_button_toggled(GtkCheckButton * checkbutton,
					GtkAssistant * assistant)
{
	return;
}

static void gb_assistant_button_clicked(GtkButton * button,
					GtkAssistant * assistant)
{
	GstElement *src, *conv, *enc, *muxer, *sink, *recorder;

	gst_element_send_event(recorder, gst_event_new_eos());

	recorder = gst_pipeline_new("record_pipe");

	src = gst_element_factory_make("autoaudiosrc", "auto_source");
	conv = gst_element_factory_make("audioconvert", "convert");
	enc = gst_element_factory_make("vorbisenc", "vorbis_enc");
	muxer = gst_element_factory_make("oggmux", "oggmux");
	sink = gst_element_factory_make("filesink", "sink");

	g_object_set(G_OBJECT(sink), "location",
		     g_strconcat(g_get_user_special_dir(G_USER_DIRECTORY_MUSIC),
				 "/", g_get_real_name(), " - ",
				 gtk_entry_get_text(GTK_ENTRY(song_entry)),
				 ".ogg", NULL), NULL);

	gst_bin_add_many(GST_BIN(recorder), src, conv, enc, muxer, sink, NULL);
	gst_element_link_many(src, conv, enc, muxer, sink, NULL);

	gst_element_set_state(recorder, GST_STATE_PLAYING);

	main_loops = g_main_loop_new(NULL, TRUE);
	g_main_loop_run(main_loops);

	gst_element_set_state(recorder, GST_STATE_NULL);
	g_main_loop_unref(main_loops);
	gst_object_unref(GST_OBJECT(recorder));
}

static void gb_assistant_cancel(GtkAssistant * assistant, gpointer data)
{
	if (!main_loops) {
		g_error("Quit more loops than there are.");
	} else {
		GMainLoop *loop = main_loops;
		g_main_loop_quit(loop);
		gtk_main_quit();
	}
}

static void gb_assistant_close(GtkAssistant * assistant, gpointer data)
{
	FILE *fp = NULL;
	gchar *filename =
	    g_strconcat(g_get_user_special_dir(G_USER_DIRECTORY_MUSIC), "/",
			gtk_entry_get_text(GTK_ENTRY(musician_entry)), " - ",
			gtk_entry_get_text(GTK_ENTRY(song_entry)),
			".gingerblue", NULL);
	fp = fopen(filename, "w");
	fprintf(fp, "<?xml version='1.0' encoding='UTF-8'?>\n");
	fprintf(fp, "<gingerblue version='%s'>\n", VERSION);
	fprintf(fp, "  <musician>%s</musician>\n",
		gtk_entry_get_text(GTK_ENTRY(musician_entry)));
	fprintf(fp, "  <song>%s</song>\n",
		gtk_entry_get_text(GTK_ENTRY(song_entry)));
	fprintf(fp, "  <instrument>%s</instrument>\n",
		gtk_entry_get_text(GTK_ENTRY(instrument_entry)));
	fprintf(fp, "  <line>%s</line>\n",
		gtk_entry_get_text(GTK_ENTRY(line_entry)));
	fprintf(fp, "  <label>%s</label>\n",
		gtk_entry_get_text(GTK_ENTRY(label_entry)));
	fprintf(fp, "</gingerblue>\n");
	fclose(fp);
}

static void gb_assistant_apply(GtkAssistant * assistant, gpointer data)
{
	gst_element_send_event(data, gst_event_new_eos());
}

GtkAssistantPageFunc gb_assistant_cb(GtkAssistant * assistant,
				     GDateTime * datestamp)
{
	/* gtk_assistant_next_page(assistant); */
}

int main(int argc, char **argv)
{
	GDateTime *datestamp;
	GingerblueData *data;
	GingerblueChord *gingerblue_chord;
	GstPlayer *player;
	GstElement *src, *conv, *enc, *muxer, *sink, *pipeline;
	GtkWidget *introduction;
	GtkWidget *entry, *label, *button, *progress, *hbox;
	GtkWidget *summary_label, *summary_entry;
	GtkWidget *gingerblue_main;
	guint i;
	GtkWidget *musicianpage;
	GtkWidget *songpage;
	GtkWidget *instrumentpage;
	GtkWidget *recordpage;
	GtkWidget *window;
	GtkWidget *frame;
	GtkWidget *input;
	GtkWidget *main_window;
	GtkWidget *mixer;
	GtkWidget *control;
	GtkWidget *soundboard;
	GtkWidget *toolbar;
	GtkWidget *input_record;
	GtkWidget *input_pause;
	GtkWidget *input_break;
	GtkWidget *input_stop;
	GtkWidget *input_volume;
	gdouble input_volume_value;
	gint64 real_time;
	PageInfo page[7] = {
		{NULL, -1, "Gingerblue Setup", GTK_ASSISTANT_PAGE_INTRO, TRUE},
		{NULL, -1, "Musician", GTK_ASSISTANT_PAGE_CONTENT, TRUE},
		{NULL, -1, "Song", GTK_ASSISTANT_PAGE_CONTENT, TRUE},
		{NULL, -1, "Instrument", GTK_ASSISTANT_PAGE_CONTENT, TRUE},
		{NULL, -1, "Input Line", GTK_ASSISTANT_PAGE_CONTENT, TRUE},
		{NULL, -1, "Label", GTK_ASSISTANT_PAGE_CONTENT, TRUE},
		{NULL, -1, "Recording", GTK_ASSISTANT_PAGE_CONFIRM, TRUE},
	};
	datestamp = g_date_time_new_now_utc ();
	gtk_init(&argc, &argv);
	window = gtk_window_new(GTK_WINDOW_TOPLEVEL);
	introduction = gtk_assistant_new();
	gtk_widget_set_size_request(GTK_WIDGET(introduction), 450, 300);
	gtk_window_set_title(GTK_WINDOW(introduction), "GNOME Gingerblue");
	g_signal_connect(G_OBJECT(introduction), "destroy",
			 G_CALLBACK(gtk_main_quit), NULL);
	page[0].widget = gtk_label_new(_("Welcome to GNOME Gingerblue!\n\nClick Next to setup a music recording session!"));
	page[1].widget = gtk_box_new(FALSE, 5);
	musician_label = gtk_label_new(_("Musician:"));
	musician_entry = gtk_entry_new();
	gtk_entry_set_text(GTK_ENTRY(musician_entry), g_get_real_name());
	gtk_box_pack_start(GTK_BOX(page[1].widget), GTK_WIDGET(musician_label),
			   FALSE, FALSE, 5);
	gtk_box_pack_start(GTK_BOX(page[1].widget), GTK_WIDGET(musician_entry),
			   FALSE, FALSE, 5);
	page[2].widget = gtk_box_new(FALSE, 5);
	song_label = gtk_label_new(_("Song:"));
	song_entry = gtk_entry_new();
	gtk_entry_set_text(GTK_ENTRY(song_entry), g_strconcat (_("Song - "), g_date_time_format_iso8601 (datestamp), NULL));
	gtk_box_pack_start(GTK_BOX(page[2].widget), GTK_WIDGET(song_label),
			   FALSE, FALSE, 5);
	gtk_box_pack_start(GTK_BOX(page[2].widget), GTK_WIDGET(song_entry),
			   FALSE, FALSE, 5);
	page[3].widget = gtk_box_new(FALSE, 5);
	instrument_label = gtk_label_new(_("Instrument:"));
	instrument_entry = gtk_entry_new();
	gtk_entry_set_text(GTK_ENTRY(instrument_entry), _("Guitar"));
	gtk_box_pack_start(GTK_BOX(page[3].widget),
			   GTK_WIDGET(instrument_label), FALSE, FALSE, 5);
	gtk_box_pack_start(GTK_BOX(page[3].widget),
			   GTK_WIDGET(instrument_entry), FALSE, FALSE, 5);
	page[4].widget = gtk_box_new(FALSE, 5);
	line_label = gtk_label_new(_("Line Input:"));
	line_entry = gtk_entry_new();
	gtk_entry_set_text(GTK_ENTRY(line_entry), _("Mic"));
	gtk_box_pack_start(GTK_BOX(page[4].widget), GTK_WIDGET(line_label),
			   FALSE, FALSE, 5);
	gtk_box_pack_start(GTK_BOX(page[4].widget), GTK_WIDGET(line_entry),
			   FALSE, FALSE, 5);
	page[5].widget = gtk_box_new(FALSE, 5);
	label_label = gtk_label_new(_("Label:"));
	label_entry = gtk_entry_new();
	gtk_entry_set_text(GTK_ENTRY(label_entry), _("GNOME"));
	gtk_box_pack_start(GTK_BOX(page[5].widget), GTK_WIDGET(label_label),
			   FALSE, FALSE, 5);
	gtk_box_pack_start(GTK_BOX(page[5].widget), GTK_WIDGET(label_entry),
			   FALSE, FALSE, 5);
	recording_label = gtk_button_new_with_label("Recording");
	g_signal_connect(G_OBJECT(recording_label), "clicked",
			 G_CALLBACK(gb_record_cb),
			 g_strconcat(g_get_user_special_dir
				     (G_USER_DIRECTORY_MUSIC), "/",
				     g_get_real_name(), " - ",
				     gtk_entry_get_text(GTK_ENTRY(song_entry)),
				     ".ogg", NULL));
	page[6].widget = gtk_entry_new();
	gtk_entry_set_text(GTK_ENTRY(page[6].widget), g_strconcat(g_get_user_special_dir
								   (G_USER_DIRECTORY_MUSIC), "/",
							           g_get_real_name(), " - ", gtk_entry_get_text(GTK_ENTRY(song_entry)), ".ogg", NULL));
	gtk_box_pack_start(GTK_BOX(page[6].widget), GTK_WIDGET(recording_label),
			   FALSE, FALSE, 5);
	for (i = 0; i < 7; i++) {
	        page[i].index =
		    gtk_assistant_append_page(GTK_ASSISTANT(introduction),
					      GTK_WIDGET(page[i].widget));
		gtk_assistant_set_page_title(GTK_ASSISTANT(introduction),
					     GTK_WIDGET(page[i].widget),
					     page[i].title);
		gtk_assistant_set_page_type(GTK_ASSISTANT(introduction),
					    GTK_WIDGET(page[i].widget),
					    page[i].type);
		gtk_assistant_set_page_complete(GTK_ASSISTANT(introduction),
						GTK_WIDGET(page[i].widget),
						page[i].complete);
	}
	g_signal_connect(G_OBJECT(entry), "changed",
			 G_CALLBACK(gb_assistant_entry_changed), pipeline);
	g_signal_connect(G_OBJECT(introduction), "cancel",
			 G_CALLBACK(gb_assistant_cancel), main_loops);
	g_signal_connect(G_OBJECT(introduction), "close",
			 G_CALLBACK(gb_assistant_close), main_loops);
	g_signal_connect(G_OBJECT(introduction), "apply",
			 G_CALLBACK(gb_assistant_apply), pipeline);
/* musicianpage = gtk_entry_new (); */
	/* real_time = g_get_real_time(); */
	/* gtk_assistant_insert_page (introduction, */
	/*                         musicianpage, */
	/*                         0); */
	/* gtk_assistant_set_page_title (introduction, */
	/*                            musicianpage, */
	/*                            "Musician Setup"); */
	/* gtk_assistant_set_page_type (introduction, */
	/*                           musicianpage, */
	/*                           GTK_ASSISTANT_PAGE_INTRO); */
	/* songpage = gtk_entry_new (); */
	/* gtk_entry_set_text (songpage, g_strconcat(g_get_home_dir(), _("/Music/"), g_get_real_name(), " - Song.gingerblue", NULL)); */
	/* real_time = g_get_real_time(); */
	/* gtk_assistant_insert_page (introduction, */
	/*                         songpage, */
	/*                         1); */
	/* gtk_assistant_set_page_title (introduction, */
	/*                            songpage, */
	/*                            "Song Setup"); */
	/* gtk_assistant_set_page_type (introduction, */
	/*                           songpage, */
	/*                           GTK_ASSISTANT_PAGE_CONTENT); */
	/* gtk_assistant_next_page(introduction); */
	/* instrumentpage = gtk_entry_new (); */
	/* gtk_entry_set_text (instrumentpage, "Guitar"); */
	/* gtk_assistant_set_page_type (introduction, */
	/*                           instrumentpage, */
	/*                           GTK_ASSISTANT_PAGE_CONTENT); */
	/* gtk_assistant_insert_page (introduction, */
	/*                         instrumentpage, */
	/*                         2); */
	/* gtk_assistant_set_page_title (introduction, */
	/*                            instrumentpage, */
	/*                            "Instrument Setup"); */
	/* recordpage = gtk_entry_new (); */
	/* gtk_entry_set_text (recordpage, "Microphone Line"); */
	/* gtk_assistant_set_page_type (introduction, */
	/*                           recordpage, */
	/*                           GTK_ASSISTANT_PAGE_SUMMARY); */
	/* gtk_assistant_insert_page (introduction, */
	/*                         recordpage, */
	/*                         3); */
	/* gtk_assistant_set_page_title (introduction, */
	/*                            recordpage, */
	/*                            "Recording Setup"); */
	/* gtk_assistant_set_page_complete (introduction, recordpage, 1); */
	/* gtk_assistant_set_forward_page_func (introduction, */
	/*                                   gb_assistant_cb, */
	/*                                   NULL, */
	/*                                   NULL); */
	/* gtk_assistant_commit (introduction); */
	gtk_widget_show_all(GTK_WIDGET(introduction));
	/* FIXME Fix core dump
	   main_window = gingerblue_main_loop (data);
	   gtk_widget_show_all (main_window);
	 */
	gst_init(&argc, &argv);
	gst_init(NULL, NULL);

	pipeline = gst_pipeline_new("record_pipe");

	src = gst_element_factory_make("autoaudiosrc", "auto_source");
	conv = gst_element_factory_make("audioconvert", "convert");
	enc = gst_element_factory_make("vorbisenc", "vorbis_enc");
	muxer = gst_element_factory_make("oggmux", "oggmux");
	sink = gst_element_factory_make("filesink", "sink");

	g_object_set(G_OBJECT(sink), "location",
		     g_strconcat(g_get_user_special_dir(G_USER_DIRECTORY_MUSIC),
				 "/", g_get_real_name(), " - ",
				 gtk_entry_get_text(GTK_ENTRY(song_entry)),
				 ".ogg", NULL), NULL);

	gst_bin_add_many(GST_BIN(pipeline), src, conv, enc, muxer, sink, NULL);
	gst_element_link_many(src, conv, enc, muxer, sink, NULL);

	gst_element_set_state(pipeline, GST_STATE_PLAYING);

	main_loops = g_main_loop_new(NULL, TRUE);
	g_main_loop_run(main_loops);

	gst_element_set_state(pipeline, GST_STATE_NULL);
	g_main_loop_unref(main_loops);
	gst_object_unref(GST_OBJECT(pipeline));

	/* player = play_new ("http://stream.radionorwegian.com/56.ogg", gingerblue_data->volume); */
	/* input_volume_value = gb_window_set_volume(GTK_VOLUME_BUTTON (input_volume), 0.00);   *\/ */
	/* g_signal_connect (GTK_BUTTON (input_record), "clicked", G_CALLBACK (gb_window_new_record), gingerblue_data->volume); */
	/* g_signal_connect (GTK_BUTTON (input_pause), "clicked", G_CALLBACK (gb_window_pause_record), gingerblue_data->volume); */
	/* g_signal_connect (GTK_BUTTON (input_break), "clicked", G_CALLBACK (gb_window_break_record), gingerblue_data->volume); */
	/* g_signal_connect (GTK_VOLUME_BUTTON (input_volume), "value-changed", G_CALLBACK (gb_window_pause_record), gingerblue_data->volume); */
	/* g_signal_connect (GTK_VOLUME_BUTTON (input_volume), "value-changed", G_CALLBACK (gb_window_store_volume), gingerblue_data->volume);   */
	g_signal_connect(GTK_WINDOW(introduction), "destroy",
			 G_CALLBACK(gtk_main_quit), NULL);
	g_signal_connect(GTK_WINDOW(introduction), "destroy",
			 G_CALLBACK(gtk_main_quit), NULL);
	/* g_free (gingerblue_data); */
	/* play_free (player); */
	g_date_time_unref (datestamp);

	gtk_main();
	return (0);
}
