/* $Id$

   Copyright (C) 2020-2021 Aamot Software
   Author(s): Ole Aamot <ole@gnome.org>
   License: GNU GPL version 3
   Version: 0.7.0 (2021-07-14)
   Website: http://www.gingerblue.org/

 */

#include <config.h>
#include <glib/gi18n.h>
#include <gtk/gtk.h>
#include <gtk/gtkbox.h>
#include <gtk/gtkbutton.h>
#include <gtk/gtkcontainer.h>
#include <gtk/gtkwindow.h>

#include <gst/gst.h>
#include "gingerblue.h"
#include "gingerblue-main-loop.h"
#include "gingerblue-studio-config.h"

extern GtkWidget *computer_entry;
extern GtkWidget *studio_entry;

void studio_location_selected (GtkWidget *widget, gpointer *data)
{
    g_print ("Studio selected - %s\n", data);
}

GtkWidget *main_config (gchar *location_data) {
       GingerblueData *Gingerblue;
       GtkButton *AddStudioButton;
       GtkButton *NewStudioButton;
       GtkBox *Studio;
       GtkListBox *Location;
       GtkWidget *Computer;
       GtkWidget *Studios;
       GtkWidget *StudioLabel;
       GtkContainer *Container;
       GtkWindow *gingerblue;
       gingerblue = gtk_window_new (GTK_WINDOW_TOPLEVEL);
       gtk_window_set_title (GTK_WINDOW (gingerblue), g_strconcat(_("Gingerblue Music Studio ("), gtk_entry_get_text(GTK_ENTRY(computer_entry)), _(") on "), gtk_entry_get_text(GTK_ENTRY(studio_entry)), _(" ("), PACKAGE_STRING, ")", NULL));
       AddStudioButton = gtk_button_new_with_label(_("Add Studio"));
       NewStudioButton = gtk_button_new_with_label(_("New Studio"));
       Studio = gtk_box_new (GTK_ORIENTATION_VERTICAL, 8);
       Location = gtk_list_box_new ();
       Computer = gtk_list_box_row_new();
       Studios = gtk_box_new(GTK_ORIENTATION_HORIZONTAL, 0);
       gtk_container_add (GTK_CONTAINER (Computer), Studios);
       StudioLabel = gtk_label_new (location_data);
       gtk_box_pack_start (GTK_BOX (Studios), StudioLabel, TRUE, TRUE, 0);
       gtk_container_add (GTK_CONTAINER (gingerblue), GTK_WIDGET (Studio));
       gtk_container_add (GTK_CONTAINER (Location), Computer);
       gtk_box_pack_start (GTK_BOX (Studio), GTK_BUTTON (AddStudioButton), TRUE, TRUE, 0);
       g_signal_connect (GTK_BUTTON(AddStudioButton), "clicked", main_studio_config, (gchar *)gtk_entry_get_text(GTK_ENTRY(studio_entry)));
       gtk_box_pack_start (GTK_BOX (Studio), GTK_LIST_BOX (Location), TRUE, TRUE, 0);
       gtk_box_pack_start (GTK_BOX (Studio), GTK_BUTTON (NewStudioButton), TRUE, TRUE, 0);
       gtk_widget_show_all (GTK_WIDGET (gingerblue));
       return (GtkWidget *) gingerblue;
}
