Name:           gingerblue
Version:        1.2.0
Release:        1%{?dist}
Summary:        Gingerblue is Free Music Software for GNOME
License:        GPLv3+
URL:            http://www.gingerblue.org/
Source:         https://download.gnome.org/sources/%{name}/1.2/%{name}-%{version}.tar.xz

BuildRequires:  gtk4-devel
BuildRequires:  pango
BuildRequires:  libchamplain-devel
BuildRequires:  libxml2-devel
BuildRequires:  intltool
BuildRequires:  itstool
BuildRequires:  libappstream-glib
BuildRequires:  desktop-file-utils
BuildRequires:  geocode-glib-devel
BuildRequires:  gstreamer1-devel
BuildRequires:  gstreamer1-plugins-bad-free-devel
BuildRequires:  gstreamer1-plugins-base-devel
Requires:       gstreamer1 >= 1.8.3
Requires:       gstreamer1-plugins-ugly-free >= 1.8.3
Requires:       geocode-glib >= 3.20.1
Requires:       libshout-devel >= 2.4.3

%description
GNOME Gingerblue is Free Music Software for GTK+/GNOME.

It supports immediate audio recording in compressed Ogg
encoded audio files stored in the $HOME/Music directory
from the line input on a computer or remote audio cards
through USB connection through PipeWire with GStreamer.

%prep
%setup -q

%build
%configure
%make_build

%install
%make_install
%find_lang %{name} --with-man

%check
appstream-util validate-relax --nonet %{buildroot}/%{_metainfodir}/%{name}.appdata.xml
desktop-file-validate %{buildroot}/%{_datadir}/applications/%{name}.desktop
%post
%files -f %{name}.lang
%doc AUTHORS NEWS README TODO ChangeLog
%license COPYING
%{_bindir}/%{name}
%{_bindir}/gingerblue
%{_datadir}/applications/%{name}.desktop
%{_datadir}/icons/hicolor/*/apps/%{name}.png
%{_includedir}/gingerblue
%{_metainfodir}/%{name}.appdata.xml
%{_sysconfdir}/icecast-server.xml

%changelog
* Thu Aug 12 2021 Ole Aamot <ole@gnome.org> - 1.2.0-0
- Multiple-Location Audio Recording support

* Tue Jul 27 2021 Ole Aamot <ole@gnome.org> - 1.1.0-0
- Icecast broadcasting via libshout 2.4.3) is blocked

* Thu Jul 15 2021 Ole Aamot <ole@gnome.org> - 1.0.0-0
- GNOME Gingerblue Music Studio - First major release

* Wed Jul 14 2021 Ole Aamot <ole@gnome.org> - 0.9.0-0
- Icecast broadcasting via libshout 2.4.3) is pending

* Wed Jul 14 2021 Ole Aamot <ole@gnome.org> - 0.8.0-0
- Package of eight release

* Wed Jul 14 2021 Ole Aamot <ole@gnome.org> - 0.7.0-0
- Package of seventh release

* Mon Jun 28 2021 Ole Aamot <ole@gnome.org> - 0.5.0-0
- Package of fifth release

* Sat May 29 2021 Ole Aamot <ole@gnome.org> - 0.4.1-0
- Bug #7 (Build on Fedora Core 34) is fixed.

* Sat May 29 2021 Ole Aamot <ole@gnome.org> - 0.4.0-0
- Fix Fedora Core 34 build

* Wed Aug 12 2020 Ole Aamot <ole@gnome.org> - 0.2.1-0
- Add i18n

* Tue Jul 14 2020 Ole Aamot <ole@gnome.org> - 0.1.8-0
- Fix Fedora Core 32 build

* Tue Jul 14 2020 Ole Aamot <ole@gnome.org> - 0.1.7-0
- Add cancellation of a recording loop

* Tue Jul 14 2020 Ole Aamot <ole@gnome.org> - 0.1.6-0
- Add recording support with GStreamer

* Tue Jul 14 2020 Ole Aamot <ole@gnome.org> - 0.1.5-0
- Support G_USER_DIRECTORY_MUSIC as XML storage path

* Sun Jul 05 2020 Ole Aamot <ole@gnome.org> - 0.1.4-0
- Package of fourth release

* Sun Jul 05 2020 Ole Aamot <ole@gnome.org> - 0.1.3-0
- Package of third release

* Tue Jan 29 2019 Ole Aamot <ole@gnome.org> - 0.1.2-0
- Fix metainfo and icons path

* Mon Dec 31 2018 Ole Aamot <ole@gnome.org> - 0.1.1-0
- Package of second release

* Sun Aug 12 2018 Ole Aamot <ole@gnome.org> - 0.1.0-0
- Package of initial release
