/* gitg-repository.c generated by valac 0.26.1, the Vala compiler
 * generated from gitg-repository.vala, do not modify */

/*
 * This file is part of gitg
 *
 * Copyright (C) 2012 - Jesse van den Kieboom
 *
 * gitg is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * gitg is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with gitg. If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib.h>
#include <glib-object.h>
#include <libgit2-glib/ggit.h>
#include <gio/gio.h>
#include <stdlib.h>
#include <string.h>
#include <gee.h>


#define GITG_TYPE_REPOSITORY (gitg_repository_get_type ())
#define GITG_REPOSITORY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GITG_TYPE_REPOSITORY, GitgRepository))
#define GITG_REPOSITORY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GITG_TYPE_REPOSITORY, GitgRepositoryClass))
#define GITG_IS_REPOSITORY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GITG_TYPE_REPOSITORY))
#define GITG_IS_REPOSITORY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GITG_TYPE_REPOSITORY))
#define GITG_REPOSITORY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GITG_TYPE_REPOSITORY, GitgRepositoryClass))

typedef struct _GitgRepository GitgRepository;
typedef struct _GitgRepositoryClass GitgRepositoryClass;
typedef struct _GitgRepositoryPrivate GitgRepositoryPrivate;

#define GITG_TYPE_REF (gitg_ref_get_type ())
#define GITG_REF(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GITG_TYPE_REF, GitgRef))
#define GITG_IS_REF(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GITG_TYPE_REF))
#define GITG_REF_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), GITG_TYPE_REF, GitgRefIface))

typedef struct _GitgRef GitgRef;
typedef struct _GitgRefIface GitgRefIface;

#define GITG_TYPE_PARSED_REF_NAME (gitg_parsed_ref_name_get_type ())
#define GITG_PARSED_REF_NAME(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GITG_TYPE_PARSED_REF_NAME, GitgParsedRefName))
#define GITG_PARSED_REF_NAME_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GITG_TYPE_PARSED_REF_NAME, GitgParsedRefNameClass))
#define GITG_IS_PARSED_REF_NAME(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GITG_TYPE_PARSED_REF_NAME))
#define GITG_IS_PARSED_REF_NAME_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GITG_TYPE_PARSED_REF_NAME))
#define GITG_PARSED_REF_NAME_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GITG_TYPE_PARSED_REF_NAME, GitgParsedRefNameClass))

typedef struct _GitgParsedRefName GitgParsedRefName;
typedef struct _GitgParsedRefNameClass GitgParsedRefNameClass;

#define GITG_TYPE_REF_STATE (gitg_ref_state_get_type ())

#define GITG_TYPE_STAGE (gitg_stage_get_type ())
#define GITG_STAGE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GITG_TYPE_STAGE, GitgStage))
#define GITG_STAGE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GITG_TYPE_STAGE, GitgStageClass))
#define GITG_IS_STAGE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GITG_TYPE_STAGE))
#define GITG_IS_STAGE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GITG_TYPE_STAGE))
#define GITG_STAGE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GITG_TYPE_STAGE, GitgStageClass))

typedef struct _GitgStage GitgStage;
typedef struct _GitgStageClass GitgStageClass;
#define _g_hash_table_unref0(var) ((var == NULL) ? NULL : (var = (g_hash_table_unref (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define __g_slist_free__g_object_unref0_0(var) ((var == NULL) ? NULL : (var = (_g_slist_free__g_object_unref0_ (var), NULL)))
#define __vala_GgitOId_free0(var) ((var == NULL) ? NULL : (var = (_vala_GgitOId_free (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_date_time_unref0(var) ((var == NULL) ? NULL : (var = (g_date_time_unref (var), NULL)))

struct _GitgRepository {
	GgitRepository parent_instance;
	GitgRepositoryPrivate * priv;
};

struct _GitgRepositoryClass {
	GgitRepositoryClass parent_class;
};

typedef enum  {
	GITG_REF_STATE_NONE,
	GITG_REF_STATE_SELECTED,
	GITG_REF_STATE_PRELIGHT
} GitgRefState;

struct _GitgRefIface {
	GTypeInterface parent_iface;
	GitgRepository* (*get_owner) (GitgRef* self);
	GitgParsedRefName* (*get_d_parsed_name) (GitgRef* self);
	void (*set_d_parsed_name) (GitgRef* self, GitgParsedRefName* value);
	GList* (*get_d_pushes) (GitgRef* self);
	void (*set_d_pushes) (GitgRef* self, GList* value);
	GitgRefState (*get_state) (GitgRef* self);
	void (*set_state) (GitgRef* self, GitgRefState value);
	gboolean (*get_working) (GitgRef* self);
	void (*set_working) (GitgRef* self, gboolean value);
};

struct _GitgRepositoryPrivate {
	GHashTable* d_refs;
	GitgStage* d_stage;
};


static gpointer gitg_repository_parent_class = NULL;

GType gitg_repository_get_type (void) G_GNUC_CONST;
GType gitg_parsed_ref_name_get_type (void) G_GNUC_CONST;
GType gitg_ref_state_get_type (void) G_GNUC_CONST;
GType gitg_ref_get_type (void) G_GNUC_CONST;
GType gitg_stage_get_type (void) G_GNUC_CONST;
#define GITG_REPOSITORY_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), GITG_TYPE_REPOSITORY, GitgRepositoryPrivate))
enum  {
	GITG_REPOSITORY_DUMMY_PROPERTY,
	GITG_REPOSITORY_NAME,
	GITG_REPOSITORY_STAGE
};
GitgRepository* gitg_repository_new (GFile* location, GFile* workdir, GError** error);
GitgRepository* gitg_repository_construct (GType object_type, GFile* location, GFile* workdir, GError** error);
static void gitg_repository_ensure_refs_add (GitgRepository* self, GgitOId* id, GitgRef* r);
static GgitOId* _vala_GgitOId_copy (GgitOId* self);
static void _g_object_unref0_ (gpointer var);
static void _g_slist_free__g_object_unref0_ (GSList* self);
void gitg_repository_clear_refs_cache (GitgRepository* self);
static void gitg_repository_ensure_refs (GitgRepository* self);
static guint _ggit_oid_hash_ghash_func (gconstpointer key);
static gboolean _ggit_oid_equal_gequal_func (gconstpointer a, gconstpointer b);
static void _vala_GgitOId_free (GgitOId* self);
static void __vala_GgitOId_free0_ (gpointer var);
static void __g_slist_free__g_object_unref0_0_ (gpointer var);
static gint ___lambda23_ (GitgRepository* self, const gchar* name);
GitgRef* gitg_repository_lookup_reference (GitgRepository* self, const gchar* name, GError** error);
gpointer gitg_repository_lookup (GitgRepository* self, GType t_type, GBoxedCopyFunc t_dup_func, GDestroyNotify t_destroy_func, GgitOId* id, GError** error);
static gint ____lambda23__ggit_references_name_callback (const gchar* name, gpointer self);
GSList* gitg_repository_refs_for_id (GitgRepository* self, GgitOId* id);
GitgRef* gitg_repository_create_reference (GitgRepository* self, const gchar* name, GgitOId* oid, GgitSignature* signature, const gchar* message, GError** error);
GitgRef* gitg_repository_create_symbolic_reference (GitgRepository* self, const gchar* name, const gchar* target, GgitSignature* signature, const gchar* message, GError** error);
GitgRef* gitg_repository_get_head (GitgRepository* self, GError** error);
GgitSignature* gitg_repository_get_signature_with_environment (GitgRepository* self, GeeMap* env, const gchar* envname, GError** error);
GDateTime* gitg_date_parse (const gchar* date, GError** error);
gchar* gitg_repository_get_name (GitgRepository* self);
GitgStage* gitg_repository_get_stage (GitgRepository* self);
GitgStage* gitg_stage_new (GitgRepository* repository);
GitgStage* gitg_stage_construct (GType object_type, GitgRepository* repository);
static void gitg_repository_finalize (GObject* obj);
static void _vala_gitg_repository_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);


GitgRepository* gitg_repository_construct (GType object_type, GFile* location, GFile* workdir, GError** error) {
	GitgRepository * self = NULL;
	GFile* _tmp0_ = NULL;
	GFile* _tmp1_ = NULL;
	GError * _inner_error_ = NULL;
#line 37 "/home/jesse/devel/gitg/libgitg/gitg-repository.vala"
	g_return_val_if_fail (location != NULL, NULL);
#line 39 "/home/jesse/devel/gitg/libgitg/gitg-repository.vala"
	_tmp0_ = location;
#line 39 "/home/jesse/devel/gitg/libgitg/gitg-repository.vala"
	_tmp1_ = workdir;
#line 39 "/home/jesse/devel/gitg/libgitg/gitg-repository.vala"
	self = (GitgRepository*) g_object_new (object_type, "location", _tmp0_, "workdir", _tmp1_, NULL);
#line 42 "/home/jesse/devel/gitg/libgitg/gitg-repository.vala"
	g_initable_init (G_TYPE_CHECK_INSTANCE_CAST (self, G_TYPE_INITABLE, GInitable), NULL, &_inner_error_);
#line 42 "/home/jesse/devel/gitg/libgitg/gitg-repository.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 42 "/home/jesse/devel/gitg/libgitg/gitg-repository.vala"
		g_propagate_error (error, _inner_error_);
#line 42 "/home/jesse/devel/gitg/libgitg/gitg-repository.vala"
		_g_object_unref0 (self);
#line 42 "/home/jesse/devel/gitg/libgitg/gitg-repository.vala"
		return NULL;
#line 181 "gitg-repository.c"
	}
#line 37 "/home/jesse/devel/gitg/libgitg/gitg-repository.vala"
	return self;
#line 185 "gitg-repository.c"
}


GitgRepository* gitg_repository_new (GFile* location, GFile* workdir, GError** error) {
#line 37 "/home/jesse/devel/gitg/libgitg/gitg-repository.vala"
	return gitg_repository_construct (GITG_TYPE_REPOSITORY, location, workdir, error);
#line 192 "gitg-repository.c"
}


static gpointer _g_object_ref0 (gpointer self) {
#line 56 "/home/jesse/devel/gitg/libgitg/gitg-repository.vala"
	return self ? g_object_ref (self) : NULL;
#line 199 "gitg-repository.c"
}


static GgitOId* _vala_GgitOId_copy (GgitOId* self) {
#line 63 "/home/jesse/devel/gitg/libgitg/gitg-repository.vala"
	return g_boxed_copy (ggit_oid_get_type (), self);
#line 206 "gitg-repository.c"
}


static gpointer __vala_GgitOId_copy0 (gpointer self) {
#line 63 "/home/jesse/devel/gitg/libgitg/gitg-repository.vala"
	return self ? _vala_GgitOId_copy (self) : NULL;
#line 213 "gitg-repository.c"
}


static void _g_object_unref0_ (gpointer var) {
#line 54 "/home/jesse/devel/gitg/libgitg/gitg-repository.vala"
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
#line 220 "gitg-repository.c"
}


static void _g_slist_free__g_object_unref0_ (GSList* self) {
#line 54 "/home/jesse/devel/gitg/libgitg/gitg-repository.vala"
	g_slist_foreach (self, (GFunc) _g_object_unref0_, NULL);
#line 54 "/home/jesse/devel/gitg/libgitg/gitg-repository.vala"
	g_slist_free (self);
#line 229 "gitg-repository.c"
}


static void gitg_repository_ensure_refs_add (GitgRepository* self, GgitOId* id, GitgRef* r) {
	GgitOId* _tmp0_ = NULL;
	GSList* refs = NULL;
	GHashTable* _tmp1_ = NULL;
	GgitOId* _tmp2_ = NULL;
	gconstpointer _tmp3_ = NULL;
	gboolean _tmp4_ = FALSE;
#line 45 "/home/jesse/devel/gitg/libgitg/gitg-repository.vala"
	g_return_if_fail (self != NULL);
#line 45 "/home/jesse/devel/gitg/libgitg/gitg-repository.vala"
	g_return_if_fail (r != NULL);
#line 47 "/home/jesse/devel/gitg/libgitg/gitg-repository.vala"
	_tmp0_ = id;
#line 47 "/home/jesse/devel/gitg/libgitg/gitg-repository.vala"
	if (_tmp0_ == NULL) {
#line 49 "/home/jesse/devel/gitg/libgitg/gitg-repository.vala"
		return;
#line 250 "gitg-repository.c"
	}
#line 54 "/home/jesse/devel/gitg/libgitg/gitg-repository.vala"
	_tmp1_ = self->priv->d_refs;
#line 54 "/home/jesse/devel/gitg/libgitg/gitg-repository.vala"
	_tmp2_ = id;
#line 54 "/home/jesse/devel/gitg/libgitg/gitg-repository.vala"
	_tmp4_ = g_hash_table_lookup_extended (_tmp1_, _tmp2_, NULL, &_tmp3_);
#line 54 "/home/jesse/devel/gitg/libgitg/gitg-repository.vala"
	refs = _tmp3_;
#line 54 "/home/jesse/devel/gitg/libgitg/gitg-repository.vala"
	if (_tmp4_) {
#line 262 "gitg-repository.c"
		GitgRef* _tmp5_ = NULL;
		GitgRef* _tmp6_ = NULL;
#line 56 "/home/jesse/devel/gitg/libgitg/gitg-repository.vala"
		_tmp5_ = r;
#line 56 "/home/jesse/devel/gitg/libgitg/gitg-repository.vala"
		_tmp6_ = _g_object_ref0 (_tmp5_);
#line 56 "/home/jesse/devel/gitg/libgitg/gitg-repository.vala"
		refs = g_slist_append (refs, _tmp6_);
#line 271 "gitg-repository.c"
	} else {
		GSList* nrefs = NULL;
		GitgRef* _tmp7_ = NULL;
		GitgRef* _tmp8_ = NULL;
		GHashTable* _tmp9_ = NULL;
		GgitOId* _tmp10_ = NULL;
		GgitOId* _tmp11_ = NULL;
		GSList* _tmp12_ = NULL;
#line 60 "/home/jesse/devel/gitg/libgitg/gitg-repository.vala"
		nrefs = NULL;
#line 61 "/home/jesse/devel/gitg/libgitg/gitg-repository.vala"
		_tmp7_ = r;
#line 61 "/home/jesse/devel/gitg/libgitg/gitg-repository.vala"
		_tmp8_ = _g_object_ref0 (_tmp7_);
#line 61 "/home/jesse/devel/gitg/libgitg/gitg-repository.vala"
		nrefs = g_slist_append (nrefs, _tmp8_);
#line 63 "/home/jesse/devel/gitg/libgitg/gitg-repository.vala"
		_tmp9_ = self->priv->d_refs;
#line 63 "/home/jesse/devel/gitg/libgitg/gitg-repository.vala"
		_tmp10_ = id;
#line 63 "/home/jesse/devel/gitg/libgitg/gitg-repository.vala"
		_tmp11_ = __vala_GgitOId_copy0 (_tmp10_);
#line 63 "/home/jesse/devel/gitg/libgitg/gitg-repository.vala"
		_tmp12_ = nrefs;
#line 63 "/home/jesse/devel/gitg/libgitg/gitg-repository.vala"
		nrefs = NULL;
#line 63 "/home/jesse/devel/gitg/libgitg/gitg-repository.vala"
		g_hash_table_insert (_tmp9_, _tmp11_, _tmp12_);
#line 54 "/home/jesse/devel/gitg/libgitg/gitg-repository.vala"
		__g_slist_free__g_object_unref0_0 (nrefs);
#line 302 "gitg-repository.c"
	}
}


void gitg_repository_clear_refs_cache (GitgRepository* self) {
#line 67 "/home/jesse/devel/gitg/libgitg/gitg-repository.vala"
	g_return_if_fail (self != NULL);
#line 69 "/home/jesse/devel/gitg/libgitg/gitg-repository.vala"
	_g_hash_table_unref0 (self->priv->d_refs);
#line 69 "/home/jesse/devel/gitg/libgitg/gitg-repository.vala"
	self->priv->d_refs = NULL;
#line 314 "gitg-repository.c"
}


static guint _ggit_oid_hash_ghash_func (gconstpointer key) {
	guint result;
	result = ggit_oid_hash (key);
#line 79 "/home/jesse/devel/gitg/libgitg/gitg-repository.vala"
	return result;
#line 323 "gitg-repository.c"
}


static gboolean _ggit_oid_equal_gequal_func (gconstpointer a, gconstpointer b) {
	gboolean result;
	result = ggit_oid_equal (a, (GgitOId*) b);
#line 79 "/home/jesse/devel/gitg/libgitg/gitg-repository.vala"
	return result;
#line 332 "gitg-repository.c"
}


static void _vala_GgitOId_free (GgitOId* self) {
#line 79 "/home/jesse/devel/gitg/libgitg/gitg-repository.vala"
	g_boxed_free (ggit_oid_get_type (), self);
#line 339 "gitg-repository.c"
}


static void __vala_GgitOId_free0_ (gpointer var) {
#line 79 "/home/jesse/devel/gitg/libgitg/gitg-repository.vala"
	(var == NULL) ? NULL : (var = (_vala_GgitOId_free (var), NULL));
#line 346 "gitg-repository.c"
}


static void __g_slist_free__g_object_unref0_0_ (gpointer var) {
#line 79 "/home/jesse/devel/gitg/libgitg/gitg-repository.vala"
	(var == NULL) ? NULL : (var = (_g_slist_free__g_object_unref0_ (var), NULL));
#line 353 "gitg-repository.c"
}


static gint ___lambda23_ (GitgRepository* self, const gchar* name) {
	gint result = 0;
	GitgRef* r = NULL;
	GitgRef* _tmp4_ = NULL;
	GgitOId* id = NULL;
	GitgRef* _tmp5_ = NULL;
	GgitOId* _tmp6_ = NULL;
	GgitOId* _tmp7_ = NULL;
	GgitOId* _tmp8_ = NULL;
	GitgRef* _tmp9_ = NULL;
	GError * _inner_error_ = NULL;
#line 84 "/home/jesse/devel/gitg/libgitg/gitg-repository.vala"
	g_return_val_if_fail (name != NULL, 0);
#line 370 "gitg-repository.c"
	{
		GitgRef* _tmp0_ = NULL;
		const gchar* _tmp1_ = NULL;
		GitgRef* _tmp2_ = NULL;
		GitgRef* _tmp3_ = NULL;
#line 89 "/home/jesse/devel/gitg/libgitg/gitg-repository.vala"
		_tmp1_ = name;
#line 89 "/home/jesse/devel/gitg/libgitg/gitg-repository.vala"
		_tmp2_ = gitg_repository_lookup_reference (self, _tmp1_, &_inner_error_);
#line 89 "/home/jesse/devel/gitg/libgitg/gitg-repository.vala"
		_tmp0_ = _tmp2_;
#line 89 "/home/jesse/devel/gitg/libgitg/gitg-repository.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 384 "gitg-repository.c"
			goto __catch2_g_error;
		}
#line 89 "/home/jesse/devel/gitg/libgitg/gitg-repository.vala"
		_tmp3_ = _tmp0_;
#line 89 "/home/jesse/devel/gitg/libgitg/gitg-repository.vala"
		_tmp0_ = NULL;
#line 89 "/home/jesse/devel/gitg/libgitg/gitg-repository.vala"
		_g_object_unref0 (r);
#line 89 "/home/jesse/devel/gitg/libgitg/gitg-repository.vala"
		r = _tmp3_;
#line 87 "/home/jesse/devel/gitg/libgitg/gitg-repository.vala"
		_g_object_unref0 (_tmp0_);
#line 397 "gitg-repository.c"
	}
	goto __finally2;
	__catch2_g_error:
	{
#line 87 "/home/jesse/devel/gitg/libgitg/gitg-repository.vala"
		g_clear_error (&_inner_error_);
#line 87 "/home/jesse/devel/gitg/libgitg/gitg-repository.vala"
		_inner_error_ = NULL;
#line 91 "/home/jesse/devel/gitg/libgitg/gitg-repository.vala"
		result = 0;
#line 91 "/home/jesse/devel/gitg/libgitg/gitg-repository.vala"
		_g_object_unref0 (r);
#line 91 "/home/jesse/devel/gitg/libgitg/gitg-repository.vala"
		return result;
#line 412 "gitg-repository.c"
	}
	__finally2:
#line 87 "/home/jesse/devel/gitg/libgitg/gitg-repository.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 87 "/home/jesse/devel/gitg/libgitg/gitg-repository.vala"
		_g_object_unref0 (r);
#line 87 "/home/jesse/devel/gitg/libgitg/gitg-repository.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 87 "/home/jesse/devel/gitg/libgitg/gitg-repository.vala"
		g_clear_error (&_inner_error_);
#line 87 "/home/jesse/devel/gitg/libgitg/gitg-repository.vala"
		return 0;
#line 425 "gitg-repository.c"
	}
#line 93 "/home/jesse/devel/gitg/libgitg/gitg-repository.vala"
	_tmp4_ = r;
#line 93 "/home/jesse/devel/gitg/libgitg/gitg-repository.vala"
	if (_tmp4_ == NULL) {
#line 95 "/home/jesse/devel/gitg/libgitg/gitg-repository.vala"
		result = 0;
#line 95 "/home/jesse/devel/gitg/libgitg/gitg-repository.vala"
		_g_object_unref0 (r);
#line 95 "/home/jesse/devel/gitg/libgitg/gitg-repository.vala"
		return result;
#line 437 "gitg-repository.c"
	}
#line 98 "/home/jesse/devel/gitg/libgitg/gitg-repository.vala"
	_tmp5_ = r;
#line 98 "/home/jesse/devel/gitg/libgitg/gitg-repository.vala"
	_tmp6_ = ggit_ref_get_target ((GgitRef*) _tmp5_);
#line 98 "/home/jesse/devel/gitg/libgitg/gitg-repository.vala"
	id = _tmp6_;
#line 100 "/home/jesse/devel/gitg/libgitg/gitg-repository.vala"
	_tmp7_ = id;
#line 100 "/home/jesse/devel/gitg/libgitg/gitg-repository.vala"
	if (_tmp7_ == NULL) {
#line 102 "/home/jesse/devel/gitg/libgitg/gitg-repository.vala"
		result = 0;
#line 102 "/home/jesse/devel/gitg/libgitg/gitg-repository.vala"
		__vala_GgitOId_free0 (id);
#line 102 "/home/jesse/devel/gitg/libgitg/gitg-repository.vala"
		_g_object_unref0 (r);
#line 102 "/home/jesse/devel/gitg/libgitg/gitg-repository.vala"
		return result;
#line 457 "gitg-repository.c"
	}
#line 105 "/home/jesse/devel/gitg/libgitg/gitg-repository.vala"
	_tmp8_ = id;
#line 105 "/home/jesse/devel/gitg/libgitg/gitg-repository.vala"
	_tmp9_ = r;
#line 105 "/home/jesse/devel/gitg/libgitg/gitg-repository.vala"
	gitg_repository_ensure_refs_add (self, _tmp8_, _tmp9_);
#line 465 "gitg-repository.c"
	{
		GgitTag* tag = NULL;
		GgitOId* _tmp10_ = NULL;
		gpointer _tmp11_ = NULL;
		GgitTag* _tmp12_ = NULL;
		GgitOId* _tmp13_ = NULL;
		GgitOId* _tmp14_ = NULL;
#line 111 "/home/jesse/devel/gitg/libgitg/gitg-repository.vala"
		_tmp10_ = id;
#line 111 "/home/jesse/devel/gitg/libgitg/gitg-repository.vala"
		_tmp11_ = gitg_repository_lookup (self, ggit_tag_get_type (), (GBoxedCopyFunc) g_object_ref, g_object_unref, _tmp10_, &_inner_error_);
#line 111 "/home/jesse/devel/gitg/libgitg/gitg-repository.vala"
		tag = (GgitTag*) _tmp11_;
#line 111 "/home/jesse/devel/gitg/libgitg/gitg-repository.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 481 "gitg-repository.c"
			goto __catch3_g_error;
		}
#line 114 "/home/jesse/devel/gitg/libgitg/gitg-repository.vala"
		_tmp12_ = tag;
#line 114 "/home/jesse/devel/gitg/libgitg/gitg-repository.vala"
		_tmp13_ = ggit_tag_get_target_id (_tmp12_);
#line 114 "/home/jesse/devel/gitg/libgitg/gitg-repository.vala"
		__vala_GgitOId_free0 (id);
#line 114 "/home/jesse/devel/gitg/libgitg/gitg-repository.vala"
		id = _tmp13_;
#line 116 "/home/jesse/devel/gitg/libgitg/gitg-repository.vala"
		_tmp14_ = id;
#line 116 "/home/jesse/devel/gitg/libgitg/gitg-repository.vala"
		if (_tmp14_ != NULL) {
#line 496 "gitg-repository.c"
			GgitOId* _tmp15_ = NULL;
			GitgRef* _tmp16_ = NULL;
#line 118 "/home/jesse/devel/gitg/libgitg/gitg-repository.vala"
			_tmp15_ = id;
#line 118 "/home/jesse/devel/gitg/libgitg/gitg-repository.vala"
			_tmp16_ = r;
#line 118 "/home/jesse/devel/gitg/libgitg/gitg-repository.vala"
			gitg_repository_ensure_refs_add (self, _tmp15_, _tmp16_);
#line 505 "gitg-repository.c"
		}
#line 109 "/home/jesse/devel/gitg/libgitg/gitg-repository.vala"
		_g_object_unref0 (tag);
#line 509 "gitg-repository.c"
	}
	goto __finally3;
	__catch3_g_error:
	{
#line 109 "/home/jesse/devel/gitg/libgitg/gitg-repository.vala"
		g_clear_error (&_inner_error_);
#line 109 "/home/jesse/devel/gitg/libgitg/gitg-repository.vala"
		_inner_error_ = NULL;
#line 518 "gitg-repository.c"
	}
	__finally3:
#line 109 "/home/jesse/devel/gitg/libgitg/gitg-repository.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 109 "/home/jesse/devel/gitg/libgitg/gitg-repository.vala"
		__vala_GgitOId_free0 (id);
#line 109 "/home/jesse/devel/gitg/libgitg/gitg-repository.vala"
		_g_object_unref0 (r);
#line 109 "/home/jesse/devel/gitg/libgitg/gitg-repository.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 109 "/home/jesse/devel/gitg/libgitg/gitg-repository.vala"
		g_clear_error (&_inner_error_);
#line 109 "/home/jesse/devel/gitg/libgitg/gitg-repository.vala"
		return 0;
#line 533 "gitg-repository.c"
	}
#line 122 "/home/jesse/devel/gitg/libgitg/gitg-repository.vala"
	result = 0;
#line 122 "/home/jesse/devel/gitg/libgitg/gitg-repository.vala"
	__vala_GgitOId_free0 (id);
#line 122 "/home/jesse/devel/gitg/libgitg/gitg-repository.vala"
	_g_object_unref0 (r);
#line 122 "/home/jesse/devel/gitg/libgitg/gitg-repository.vala"
	return result;
#line 543 "gitg-repository.c"
}


static gint ____lambda23__ggit_references_name_callback (const gchar* name, gpointer self) {
	gint result;
	result = ___lambda23_ ((GitgRepository*) self, name);
#line 84 "/home/jesse/devel/gitg/libgitg/gitg-repository.vala"
	return result;
#line 552 "gitg-repository.c"
}


static void gitg_repository_ensure_refs (GitgRepository* self) {
	GHashTable* _tmp0_ = NULL;
	GHashTable* _tmp1_ = NULL;
	GError * _inner_error_ = NULL;
#line 72 "/home/jesse/devel/gitg/libgitg/gitg-repository.vala"
	g_return_if_fail (self != NULL);
#line 74 "/home/jesse/devel/gitg/libgitg/gitg-repository.vala"
	_tmp0_ = self->priv->d_refs;
#line 74 "/home/jesse/devel/gitg/libgitg/gitg-repository.vala"
	if (_tmp0_ != NULL) {
#line 76 "/home/jesse/devel/gitg/libgitg/gitg-repository.vala"
		return;
#line 568 "gitg-repository.c"
	}
#line 79 "/home/jesse/devel/gitg/libgitg/gitg-repository.vala"
	_tmp1_ = g_hash_table_new_full (_ggit_oid_hash_ghash_func, _ggit_oid_equal_gequal_func, __vala_GgitOId_free0_, __g_slist_free__g_object_unref0_0_);
#line 79 "/home/jesse/devel/gitg/libgitg/gitg-repository.vala"
	_g_hash_table_unref0 (self->priv->d_refs);
#line 79 "/home/jesse/devel/gitg/libgitg/gitg-repository.vala"
	self->priv->d_refs = _tmp1_;
#line 576 "gitg-repository.c"
	{
#line 84 "/home/jesse/devel/gitg/libgitg/gitg-repository.vala"
		ggit_repository_references_foreach_name ((GgitRepository*) self, ____lambda23__ggit_references_name_callback, self, &_inner_error_);
#line 84 "/home/jesse/devel/gitg/libgitg/gitg-repository.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 582 "gitg-repository.c"
			goto __catch1_g_error;
		}
	}
	goto __finally1;
	__catch1_g_error:
	{
#line 82 "/home/jesse/devel/gitg/libgitg/gitg-repository.vala"
		g_clear_error (&_inner_error_);
#line 82 "/home/jesse/devel/gitg/libgitg/gitg-repository.vala"
		_inner_error_ = NULL;
#line 593 "gitg-repository.c"
	}
	__finally1:
#line 82 "/home/jesse/devel/gitg/libgitg/gitg-repository.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 82 "/home/jesse/devel/gitg/libgitg/gitg-repository.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 82 "/home/jesse/devel/gitg/libgitg/gitg-repository.vala"
		g_clear_error (&_inner_error_);
#line 82 "/home/jesse/devel/gitg/libgitg/gitg-repository.vala"
		return;
#line 604 "gitg-repository.c"
	}
}


GSList* gitg_repository_refs_for_id (GitgRepository* self, GgitOId* id) {
	GSList* result = NULL;
	GHashTable* _tmp0_ = NULL;
	GgitOId* _tmp1_ = NULL;
	gconstpointer _tmp2_ = NULL;
#line 128 "/home/jesse/devel/gitg/libgitg/gitg-repository.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 128 "/home/jesse/devel/gitg/libgitg/gitg-repository.vala"
	g_return_val_if_fail (id != NULL, NULL);
#line 130 "/home/jesse/devel/gitg/libgitg/gitg-repository.vala"
	gitg_repository_ensure_refs (self);
#line 132 "/home/jesse/devel/gitg/libgitg/gitg-repository.vala"
	_tmp0_ = self->priv->d_refs;
#line 132 "/home/jesse/devel/gitg/libgitg/gitg-repository.vala"
	_tmp1_ = id;
#line 132 "/home/jesse/devel/gitg/libgitg/gitg-repository.vala"
	_tmp2_ = g_hash_table_lookup (_tmp0_, _tmp1_);
#line 132 "/home/jesse/devel/gitg/libgitg/gitg-repository.vala"
	result = (GSList*) _tmp2_;
#line 132 "/home/jesse/devel/gitg/libgitg/gitg-repository.vala"
	return result;
#line 630 "gitg-repository.c"
}


gpointer gitg_repository_lookup (GitgRepository* self, GType t_type, GBoxedCopyFunc t_dup_func, GDestroyNotify t_destroy_func, GgitOId* id, GError** error) {
	gpointer result = NULL;
	GgitObject* _tmp0_ = NULL;
	GgitOId* _tmp1_ = NULL;
	GgitObject* _tmp2_ = NULL;
	GgitObject* _tmp3_ = NULL;
	GError * _inner_error_ = NULL;
#line 135 "/home/jesse/devel/gitg/libgitg/gitg-repository.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 135 "/home/jesse/devel/gitg/libgitg/gitg-repository.vala"
	g_return_val_if_fail (id != NULL, NULL);
#line 137 "/home/jesse/devel/gitg/libgitg/gitg-repository.vala"
	_tmp1_ = id;
#line 137 "/home/jesse/devel/gitg/libgitg/gitg-repository.vala"
	_tmp2_ = ggit_repository_lookup (G_TYPE_CHECK_INSTANCE_CAST (self, ggit_repository_get_type (), GgitRepository), _tmp1_, t_type, &_inner_error_);
#line 137 "/home/jesse/devel/gitg/libgitg/gitg-repository.vala"
	_tmp0_ = _tmp2_;
#line 137 "/home/jesse/devel/gitg/libgitg/gitg-repository.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 137 "/home/jesse/devel/gitg/libgitg/gitg-repository.vala"
		g_propagate_error (error, _inner_error_);
#line 137 "/home/jesse/devel/gitg/libgitg/gitg-repository.vala"
		return NULL;
#line 657 "gitg-repository.c"
	}
#line 137 "/home/jesse/devel/gitg/libgitg/gitg-repository.vala"
	_tmp3_ = _tmp0_;
#line 137 "/home/jesse/devel/gitg/libgitg/gitg-repository.vala"
	_tmp0_ = NULL;
#line 137 "/home/jesse/devel/gitg/libgitg/gitg-repository.vala"
	result = (gpointer) _tmp3_;
#line 137 "/home/jesse/devel/gitg/libgitg/gitg-repository.vala"
	_g_object_unref0 (_tmp0_);
#line 137 "/home/jesse/devel/gitg/libgitg/gitg-repository.vala"
	return result;
#line 669 "gitg-repository.c"
}


GitgRef* gitg_repository_lookup_reference (GitgRepository* self, const gchar* name, GError** error) {
	GitgRef* result = NULL;
	GgitRef* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	GgitRef* _tmp2_ = NULL;
	GgitRef* _tmp3_ = NULL;
	GitgRef* _tmp4_ = NULL;
	GError * _inner_error_ = NULL;
#line 141 "/home/jesse/devel/gitg/libgitg/gitg-repository.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 141 "/home/jesse/devel/gitg/libgitg/gitg-repository.vala"
	g_return_val_if_fail (name != NULL, NULL);
#line 143 "/home/jesse/devel/gitg/libgitg/gitg-repository.vala"
	_tmp1_ = name;
#line 143 "/home/jesse/devel/gitg/libgitg/gitg-repository.vala"
	_tmp2_ = ggit_repository_lookup_reference (G_TYPE_CHECK_INSTANCE_CAST (self, ggit_repository_get_type (), GgitRepository), _tmp1_, &_inner_error_);
#line 143 "/home/jesse/devel/gitg/libgitg/gitg-repository.vala"
	_tmp0_ = _tmp2_;
#line 143 "/home/jesse/devel/gitg/libgitg/gitg-repository.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 143 "/home/jesse/devel/gitg/libgitg/gitg-repository.vala"
		g_propagate_error (error, _inner_error_);
#line 143 "/home/jesse/devel/gitg/libgitg/gitg-repository.vala"
		return NULL;
#line 697 "gitg-repository.c"
	}
#line 143 "/home/jesse/devel/gitg/libgitg/gitg-repository.vala"
	_tmp3_ = _tmp0_;
#line 143 "/home/jesse/devel/gitg/libgitg/gitg-repository.vala"
	_tmp0_ = NULL;
#line 143 "/home/jesse/devel/gitg/libgitg/gitg-repository.vala"
	_tmp4_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp3_, GITG_TYPE_REF) ? ((GitgRef*) _tmp3_) : NULL;
#line 143 "/home/jesse/devel/gitg/libgitg/gitg-repository.vala"
	if (_tmp4_ == NULL) {
#line 143 "/home/jesse/devel/gitg/libgitg/gitg-repository.vala"
		_g_object_unref0 (_tmp3_);
#line 709 "gitg-repository.c"
	}
#line 143 "/home/jesse/devel/gitg/libgitg/gitg-repository.vala"
	result = _tmp4_;
#line 143 "/home/jesse/devel/gitg/libgitg/gitg-repository.vala"
	_g_object_unref0 (_tmp0_);
#line 143 "/home/jesse/devel/gitg/libgitg/gitg-repository.vala"
	return result;
#line 717 "gitg-repository.c"
}


GitgRef* gitg_repository_create_reference (GitgRepository* self, const gchar* name, GgitOId* oid, GgitSignature* signature, const gchar* message, GError** error) {
	GitgRef* result = NULL;
	GgitRef* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	GgitOId* _tmp2_ = NULL;
	GgitSignature* _tmp3_ = NULL;
	const gchar* _tmp4_ = NULL;
	GgitRef* _tmp5_ = NULL;
	GgitRef* _tmp6_ = NULL;
	GitgRef* _tmp7_ = NULL;
	GError * _inner_error_ = NULL;
#line 146 "/home/jesse/devel/gitg/libgitg/gitg-repository.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 146 "/home/jesse/devel/gitg/libgitg/gitg-repository.vala"
	g_return_val_if_fail (name != NULL, NULL);
#line 146 "/home/jesse/devel/gitg/libgitg/gitg-repository.vala"
	g_return_val_if_fail (oid != NULL, NULL);
#line 146 "/home/jesse/devel/gitg/libgitg/gitg-repository.vala"
	g_return_val_if_fail (signature != NULL, NULL);
#line 146 "/home/jesse/devel/gitg/libgitg/gitg-repository.vala"
	g_return_val_if_fail (message != NULL, NULL);
#line 148 "/home/jesse/devel/gitg/libgitg/gitg-repository.vala"
	_tmp1_ = name;
#line 148 "/home/jesse/devel/gitg/libgitg/gitg-repository.vala"
	_tmp2_ = oid;
#line 148 "/home/jesse/devel/gitg/libgitg/gitg-repository.vala"
	_tmp3_ = signature;
#line 148 "/home/jesse/devel/gitg/libgitg/gitg-repository.vala"
	_tmp4_ = message;
#line 148 "/home/jesse/devel/gitg/libgitg/gitg-repository.vala"
	_tmp5_ = ggit_repository_create_reference (G_TYPE_CHECK_INSTANCE_CAST (self, ggit_repository_get_type (), GgitRepository), _tmp1_, _tmp2_, _tmp3_, _tmp4_, &_inner_error_);
#line 148 "/home/jesse/devel/gitg/libgitg/gitg-repository.vala"
	_tmp0_ = _tmp5_;
#line 148 "/home/jesse/devel/gitg/libgitg/gitg-repository.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 148 "/home/jesse/devel/gitg/libgitg/gitg-repository.vala"
		g_propagate_error (error, _inner_error_);
#line 148 "/home/jesse/devel/gitg/libgitg/gitg-repository.vala"
		return NULL;
#line 760 "gitg-repository.c"
	}
#line 148 "/home/jesse/devel/gitg/libgitg/gitg-repository.vala"
	_tmp6_ = _tmp0_;
#line 148 "/home/jesse/devel/gitg/libgitg/gitg-repository.vala"
	_tmp0_ = NULL;
#line 148 "/home/jesse/devel/gitg/libgitg/gitg-repository.vala"
	_tmp7_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp6_, GITG_TYPE_REF) ? ((GitgRef*) _tmp6_) : NULL;
#line 148 "/home/jesse/devel/gitg/libgitg/gitg-repository.vala"
	if (_tmp7_ == NULL) {
#line 148 "/home/jesse/devel/gitg/libgitg/gitg-repository.vala"
		_g_object_unref0 (_tmp6_);
#line 772 "gitg-repository.c"
	}
#line 148 "/home/jesse/devel/gitg/libgitg/gitg-repository.vala"
	result = _tmp7_;
#line 148 "/home/jesse/devel/gitg/libgitg/gitg-repository.vala"
	_g_object_unref0 (_tmp0_);
#line 148 "/home/jesse/devel/gitg/libgitg/gitg-repository.vala"
	return result;
#line 780 "gitg-repository.c"
}


GitgRef* gitg_repository_create_symbolic_reference (GitgRepository* self, const gchar* name, const gchar* target, GgitSignature* signature, const gchar* message, GError** error) {
	GitgRef* result = NULL;
	GgitRef* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	GgitSignature* _tmp3_ = NULL;
	const gchar* _tmp4_ = NULL;
	GgitRef* _tmp5_ = NULL;
	GgitRef* _tmp6_ = NULL;
	GitgRef* _tmp7_ = NULL;
	GError * _inner_error_ = NULL;
#line 151 "/home/jesse/devel/gitg/libgitg/gitg-repository.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 151 "/home/jesse/devel/gitg/libgitg/gitg-repository.vala"
	g_return_val_if_fail (name != NULL, NULL);
#line 151 "/home/jesse/devel/gitg/libgitg/gitg-repository.vala"
	g_return_val_if_fail (target != NULL, NULL);
#line 151 "/home/jesse/devel/gitg/libgitg/gitg-repository.vala"
	g_return_val_if_fail (signature != NULL, NULL);
#line 151 "/home/jesse/devel/gitg/libgitg/gitg-repository.vala"
	g_return_val_if_fail (message != NULL, NULL);
#line 153 "/home/jesse/devel/gitg/libgitg/gitg-repository.vala"
	_tmp1_ = name;
#line 153 "/home/jesse/devel/gitg/libgitg/gitg-repository.vala"
	_tmp2_ = target;
#line 153 "/home/jesse/devel/gitg/libgitg/gitg-repository.vala"
	_tmp3_ = signature;
#line 153 "/home/jesse/devel/gitg/libgitg/gitg-repository.vala"
	_tmp4_ = message;
#line 153 "/home/jesse/devel/gitg/libgitg/gitg-repository.vala"
	_tmp5_ = ggit_repository_create_symbolic_reference (G_TYPE_CHECK_INSTANCE_CAST (self, ggit_repository_get_type (), GgitRepository), _tmp1_, _tmp2_, _tmp3_, _tmp4_, &_inner_error_);
#line 153 "/home/jesse/devel/gitg/libgitg/gitg-repository.vala"
	_tmp0_ = _tmp5_;
#line 153 "/home/jesse/devel/gitg/libgitg/gitg-repository.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 153 "/home/jesse/devel/gitg/libgitg/gitg-repository.vala"
		g_propagate_error (error, _inner_error_);
#line 153 "/home/jesse/devel/gitg/libgitg/gitg-repository.vala"
		return NULL;
#line 823 "gitg-repository.c"
	}
#line 153 "/home/jesse/devel/gitg/libgitg/gitg-repository.vala"
	_tmp6_ = _tmp0_;
#line 153 "/home/jesse/devel/gitg/libgitg/gitg-repository.vala"
	_tmp0_ = NULL;
#line 153 "/home/jesse/devel/gitg/libgitg/gitg-repository.vala"
	_tmp7_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp6_, GITG_TYPE_REF) ? ((GitgRef*) _tmp6_) : NULL;
#line 153 "/home/jesse/devel/gitg/libgitg/gitg-repository.vala"
	if (_tmp7_ == NULL) {
#line 153 "/home/jesse/devel/gitg/libgitg/gitg-repository.vala"
		_g_object_unref0 (_tmp6_);
#line 835 "gitg-repository.c"
	}
#line 153 "/home/jesse/devel/gitg/libgitg/gitg-repository.vala"
	result = _tmp7_;
#line 153 "/home/jesse/devel/gitg/libgitg/gitg-repository.vala"
	_g_object_unref0 (_tmp0_);
#line 153 "/home/jesse/devel/gitg/libgitg/gitg-repository.vala"
	return result;
#line 843 "gitg-repository.c"
}


GitgRef* gitg_repository_get_head (GitgRepository* self, GError** error) {
	GitgRef* result = NULL;
	GgitRef* _tmp0_ = NULL;
	GgitRef* _tmp1_ = NULL;
	GgitRef* _tmp2_ = NULL;
	GitgRef* _tmp3_ = NULL;
	GError * _inner_error_ = NULL;
#line 156 "/home/jesse/devel/gitg/libgitg/gitg-repository.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 158 "/home/jesse/devel/gitg/libgitg/gitg-repository.vala"
	_tmp1_ = ggit_repository_get_head (G_TYPE_CHECK_INSTANCE_CAST (self, ggit_repository_get_type (), GgitRepository), &_inner_error_);
#line 158 "/home/jesse/devel/gitg/libgitg/gitg-repository.vala"
	_tmp0_ = _tmp1_;
#line 158 "/home/jesse/devel/gitg/libgitg/gitg-repository.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 158 "/home/jesse/devel/gitg/libgitg/gitg-repository.vala"
		g_propagate_error (error, _inner_error_);
#line 158 "/home/jesse/devel/gitg/libgitg/gitg-repository.vala"
		return NULL;
#line 866 "gitg-repository.c"
	}
#line 158 "/home/jesse/devel/gitg/libgitg/gitg-repository.vala"
	_tmp2_ = _tmp0_;
#line 158 "/home/jesse/devel/gitg/libgitg/gitg-repository.vala"
	_tmp0_ = NULL;
#line 158 "/home/jesse/devel/gitg/libgitg/gitg-repository.vala"
	_tmp3_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp2_, GITG_TYPE_REF) ? ((GitgRef*) _tmp2_) : NULL;
#line 158 "/home/jesse/devel/gitg/libgitg/gitg-repository.vala"
	if (_tmp3_ == NULL) {
#line 158 "/home/jesse/devel/gitg/libgitg/gitg-repository.vala"
		_g_object_unref0 (_tmp2_);
#line 878 "gitg-repository.c"
	}
#line 158 "/home/jesse/devel/gitg/libgitg/gitg-repository.vala"
	result = _tmp3_;
#line 158 "/home/jesse/devel/gitg/libgitg/gitg-repository.vala"
	_g_object_unref0 (_tmp0_);
#line 158 "/home/jesse/devel/gitg/libgitg/gitg-repository.vala"
	return result;
#line 886 "gitg-repository.c"
}


static const gchar* string_to_string (const gchar* self) {
	const gchar* result = NULL;
#line 1314 "/usr/share/vala-0.26/vapi/glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, NULL);
#line 1315 "/usr/share/vala-0.26/vapi/glib-2.0.vapi"
	result = self;
#line 1315 "/usr/share/vala-0.26/vapi/glib-2.0.vapi"
	return result;
#line 898 "gitg-repository.c"
}


GgitSignature* gitg_repository_get_signature_with_environment (GitgRepository* self, GeeMap* env, const gchar* envname, GError** error) {
	GgitSignature* result = NULL;
	gchar* user = NULL;
	gchar* email = NULL;
	GDateTime* date = NULL;
	gchar* nameenv = NULL;
	const gchar* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	gchar* emailenv = NULL;
	const gchar* _tmp3_ = NULL;
	const gchar* _tmp4_ = NULL;
	gchar* _tmp5_ = NULL;
	gchar* dateenv = NULL;
	const gchar* _tmp6_ = NULL;
	const gchar* _tmp7_ = NULL;
	gchar* _tmp8_ = NULL;
	GeeMap* _tmp9_ = NULL;
	const gchar* _tmp10_ = NULL;
	gboolean _tmp11_ = FALSE;
	GeeMap* _tmp15_ = NULL;
	const gchar* _tmp16_ = NULL;
	gboolean _tmp17_ = FALSE;
	GeeMap* _tmp21_ = NULL;
	const gchar* _tmp22_ = NULL;
	gboolean _tmp23_ = FALSE;
	GDateTime* _tmp32_ = NULL;
	GgitConfig* conf = NULL;
	GgitConfig* _tmp34_ = NULL;
	const gchar* _tmp35_ = NULL;
	const gchar* _tmp40_ = NULL;
	const gchar* _tmp45_ = NULL;
	const gchar* _tmp46_ = NULL;
	const gchar* _tmp48_ = NULL;
	const gchar* _tmp49_ = NULL;
	GgitSignature* _tmp51_ = NULL;
	GDateTime* _tmp52_ = NULL;
	GgitSignature* _tmp53_ = NULL;
	GgitSignature* _tmp54_ = NULL;
	GError * _inner_error_ = NULL;
#line 174 "/home/jesse/devel/gitg/libgitg/gitg-repository.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 174 "/home/jesse/devel/gitg/libgitg/gitg-repository.vala"
	g_return_val_if_fail (env != NULL, NULL);
#line 174 "/home/jesse/devel/gitg/libgitg/gitg-repository.vala"
	g_return_val_if_fail (envname != NULL, NULL);
#line 176 "/home/jesse/devel/gitg/libgitg/gitg-repository.vala"
	user = NULL;
#line 177 "/home/jesse/devel/gitg/libgitg/gitg-repository.vala"
	email = NULL;
#line 178 "/home/jesse/devel/gitg/libgitg/gitg-repository.vala"
	date = NULL;
#line 180 "/home/jesse/devel/gitg/libgitg/gitg-repository.vala"
	_tmp0_ = envname;
#line 180 "/home/jesse/devel/gitg/libgitg/gitg-repository.vala"
	_tmp1_ = string_to_string (_tmp0_);
#line 180 "/home/jesse/devel/gitg/libgitg/gitg-repository.vala"
	_tmp2_ = g_strconcat ("GIT_", _tmp1_, "_NAME", NULL);
#line 180 "/home/jesse/devel/gitg/libgitg/gitg-repository.vala"
	nameenv = _tmp2_;
#line 181 "/home/jesse/devel/gitg/libgitg/gitg-repository.vala"
	_tmp3_ = envname;
#line 181 "/home/jesse/devel/gitg/libgitg/gitg-repository.vala"
	_tmp4_ = string_to_string (_tmp3_);
#line 181 "/home/jesse/devel/gitg/libgitg/gitg-repository.vala"
	_tmp5_ = g_strconcat ("GIT_", _tmp4_, "_EMAIL", NULL);
#line 181 "/home/jesse/devel/gitg/libgitg/gitg-repository.vala"
	emailenv = _tmp5_;
#line 182 "/home/jesse/devel/gitg/libgitg/gitg-repository.vala"
	_tmp6_ = envname;
#line 182 "/home/jesse/devel/gitg/libgitg/gitg-repository.vala"
	_tmp7_ = string_to_string (_tmp6_);
#line 182 "/home/jesse/devel/gitg/libgitg/gitg-repository.vala"
	_tmp8_ = g_strconcat ("GIT_", _tmp7_, "_DATE", NULL);
#line 182 "/home/jesse/devel/gitg/libgitg/gitg-repository.vala"
	dateenv = _tmp8_;
#line 184 "/home/jesse/devel/gitg/libgitg/gitg-repository.vala"
	_tmp9_ = env;
#line 184 "/home/jesse/devel/gitg/libgitg/gitg-repository.vala"
	_tmp10_ = nameenv;
#line 184 "/home/jesse/devel/gitg/libgitg/gitg-repository.vala"
	_tmp11_ = gee_map_has_key (_tmp9_, _tmp10_);
#line 184 "/home/jesse/devel/gitg/libgitg/gitg-repository.vala"
	if (_tmp11_) {
#line 986 "gitg-repository.c"
		GeeMap* _tmp12_ = NULL;
		const gchar* _tmp13_ = NULL;
		gpointer _tmp14_ = NULL;
#line 186 "/home/jesse/devel/gitg/libgitg/gitg-repository.vala"
		_tmp12_ = env;
#line 186 "/home/jesse/devel/gitg/libgitg/gitg-repository.vala"
		_tmp13_ = nameenv;
#line 186 "/home/jesse/devel/gitg/libgitg/gitg-repository.vala"
		_tmp14_ = gee_map_get (_tmp12_, _tmp13_);
#line 186 "/home/jesse/devel/gitg/libgitg/gitg-repository.vala"
		_g_free0 (user);
#line 186 "/home/jesse/devel/gitg/libgitg/gitg-repository.vala"
		user = (gchar*) _tmp14_;
#line 1000 "gitg-repository.c"
	}
#line 189 "/home/jesse/devel/gitg/libgitg/gitg-repository.vala"
	_tmp15_ = env;
#line 189 "/home/jesse/devel/gitg/libgitg/gitg-repository.vala"
	_tmp16_ = emailenv;
#line 189 "/home/jesse/devel/gitg/libgitg/gitg-repository.vala"
	_tmp17_ = gee_map_has_key (_tmp15_, _tmp16_);
#line 189 "/home/jesse/devel/gitg/libgitg/gitg-repository.vala"
	if (_tmp17_) {
#line 1010 "gitg-repository.c"
		GeeMap* _tmp18_ = NULL;
		const gchar* _tmp19_ = NULL;
		gpointer _tmp20_ = NULL;
#line 191 "/home/jesse/devel/gitg/libgitg/gitg-repository.vala"
		_tmp18_ = env;
#line 191 "/home/jesse/devel/gitg/libgitg/gitg-repository.vala"
		_tmp19_ = emailenv;
#line 191 "/home/jesse/devel/gitg/libgitg/gitg-repository.vala"
		_tmp20_ = gee_map_get (_tmp18_, _tmp19_);
#line 191 "/home/jesse/devel/gitg/libgitg/gitg-repository.vala"
		_g_free0 (email);
#line 191 "/home/jesse/devel/gitg/libgitg/gitg-repository.vala"
		email = (gchar*) _tmp20_;
#line 1024 "gitg-repository.c"
	}
#line 194 "/home/jesse/devel/gitg/libgitg/gitg-repository.vala"
	_tmp21_ = env;
#line 194 "/home/jesse/devel/gitg/libgitg/gitg-repository.vala"
	_tmp22_ = dateenv;
#line 194 "/home/jesse/devel/gitg/libgitg/gitg-repository.vala"
	_tmp23_ = gee_map_has_key (_tmp21_, _tmp22_);
#line 194 "/home/jesse/devel/gitg/libgitg/gitg-repository.vala"
	if (_tmp23_) {
#line 1034 "gitg-repository.c"
		{
			GDateTime* _tmp24_ = NULL;
			GeeMap* _tmp25_ = NULL;
			const gchar* _tmp26_ = NULL;
			gpointer _tmp27_ = NULL;
			gchar* _tmp28_ = NULL;
			GDateTime* _tmp29_ = NULL;
			GDateTime* _tmp30_ = NULL;
			GDateTime* _tmp31_ = NULL;
#line 198 "/home/jesse/devel/gitg/libgitg/gitg-repository.vala"
			_tmp25_ = env;
#line 198 "/home/jesse/devel/gitg/libgitg/gitg-repository.vala"
			_tmp26_ = dateenv;
#line 198 "/home/jesse/devel/gitg/libgitg/gitg-repository.vala"
			_tmp27_ = gee_map_get (_tmp25_, _tmp26_);
#line 198 "/home/jesse/devel/gitg/libgitg/gitg-repository.vala"
			_tmp28_ = (gchar*) _tmp27_;
#line 198 "/home/jesse/devel/gitg/libgitg/gitg-repository.vala"
			_tmp29_ = gitg_date_parse (_tmp28_, &_inner_error_);
#line 198 "/home/jesse/devel/gitg/libgitg/gitg-repository.vala"
			_tmp30_ = _tmp29_;
#line 198 "/home/jesse/devel/gitg/libgitg/gitg-repository.vala"
			_g_free0 (_tmp28_);
#line 198 "/home/jesse/devel/gitg/libgitg/gitg-repository.vala"
			_tmp24_ = _tmp30_;
#line 198 "/home/jesse/devel/gitg/libgitg/gitg-repository.vala"
			if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1062 "gitg-repository.c"
				goto __catch4_g_error;
			}
#line 198 "/home/jesse/devel/gitg/libgitg/gitg-repository.vala"
			_tmp31_ = _tmp24_;
#line 198 "/home/jesse/devel/gitg/libgitg/gitg-repository.vala"
			_tmp24_ = NULL;
#line 198 "/home/jesse/devel/gitg/libgitg/gitg-repository.vala"
			_g_date_time_unref0 (date);
#line 198 "/home/jesse/devel/gitg/libgitg/gitg-repository.vala"
			date = _tmp31_;
#line 196 "/home/jesse/devel/gitg/libgitg/gitg-repository.vala"
			_g_date_time_unref0 (_tmp24_);
#line 1075 "gitg-repository.c"
		}
		goto __finally4;
		__catch4_g_error:
		{
#line 196 "/home/jesse/devel/gitg/libgitg/gitg-repository.vala"
			g_clear_error (&_inner_error_);
#line 196 "/home/jesse/devel/gitg/libgitg/gitg-repository.vala"
			_inner_error_ = NULL;
#line 1084 "gitg-repository.c"
		}
		__finally4:
#line 196 "/home/jesse/devel/gitg/libgitg/gitg-repository.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 196 "/home/jesse/devel/gitg/libgitg/gitg-repository.vala"
			g_propagate_error (error, _inner_error_);
#line 196 "/home/jesse/devel/gitg/libgitg/gitg-repository.vala"
			_g_free0 (dateenv);
#line 196 "/home/jesse/devel/gitg/libgitg/gitg-repository.vala"
			_g_free0 (emailenv);
#line 196 "/home/jesse/devel/gitg/libgitg/gitg-repository.vala"
			_g_free0 (nameenv);
#line 196 "/home/jesse/devel/gitg/libgitg/gitg-repository.vala"
			_g_date_time_unref0 (date);
#line 196 "/home/jesse/devel/gitg/libgitg/gitg-repository.vala"
			_g_free0 (email);
#line 196 "/home/jesse/devel/gitg/libgitg/gitg-repository.vala"
			_g_free0 (user);
#line 196 "/home/jesse/devel/gitg/libgitg/gitg-repository.vala"
			return NULL;
#line 1105 "gitg-repository.c"
		}
	}
#line 203 "/home/jesse/devel/gitg/libgitg/gitg-repository.vala"
	_tmp32_ = date;
#line 203 "/home/jesse/devel/gitg/libgitg/gitg-repository.vala"
	if (_tmp32_ == NULL) {
#line 1112 "gitg-repository.c"
		GDateTime* _tmp33_ = NULL;
#line 205 "/home/jesse/devel/gitg/libgitg/gitg-repository.vala"
		_tmp33_ = g_date_time_new_now_local ();
#line 205 "/home/jesse/devel/gitg/libgitg/gitg-repository.vala"
		_g_date_time_unref0 (date);
#line 205 "/home/jesse/devel/gitg/libgitg/gitg-repository.vala"
		date = _tmp33_;
#line 1120 "gitg-repository.c"
	}
#line 208 "/home/jesse/devel/gitg/libgitg/gitg-repository.vala"
	_tmp34_ = ggit_repository_get_config ((GgitRepository*) self, &_inner_error_);
#line 208 "/home/jesse/devel/gitg/libgitg/gitg-repository.vala"
	conf = _tmp34_;
#line 208 "/home/jesse/devel/gitg/libgitg/gitg-repository.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 208 "/home/jesse/devel/gitg/libgitg/gitg-repository.vala"
		g_propagate_error (error, _inner_error_);
#line 208 "/home/jesse/devel/gitg/libgitg/gitg-repository.vala"
		_g_free0 (dateenv);
#line 208 "/home/jesse/devel/gitg/libgitg/gitg-repository.vala"
		_g_free0 (emailenv);
#line 208 "/home/jesse/devel/gitg/libgitg/gitg-repository.vala"
		_g_free0 (nameenv);
#line 208 "/home/jesse/devel/gitg/libgitg/gitg-repository.vala"
		_g_date_time_unref0 (date);
#line 208 "/home/jesse/devel/gitg/libgitg/gitg-repository.vala"
		_g_free0 (email);
#line 208 "/home/jesse/devel/gitg/libgitg/gitg-repository.vala"
		_g_free0 (user);
#line 208 "/home/jesse/devel/gitg/libgitg/gitg-repository.vala"
		return NULL;
#line 1144 "gitg-repository.c"
	}
#line 210 "/home/jesse/devel/gitg/libgitg/gitg-repository.vala"
	_tmp35_ = user;
#line 210 "/home/jesse/devel/gitg/libgitg/gitg-repository.vala"
	if (_tmp35_ == NULL) {
#line 1150 "gitg-repository.c"
		{
			const gchar* _tmp36_ = NULL;
			GgitConfig* _tmp37_ = NULL;
			const gchar* _tmp38_ = NULL;
			gchar* _tmp39_ = NULL;
#line 214 "/home/jesse/devel/gitg/libgitg/gitg-repository.vala"
			_tmp37_ = conf;
#line 214 "/home/jesse/devel/gitg/libgitg/gitg-repository.vala"
			_tmp38_ = ggit_config_get_string (_tmp37_, "user.name", &_inner_error_);
#line 214 "/home/jesse/devel/gitg/libgitg/gitg-repository.vala"
			_tmp36_ = _tmp38_;
#line 214 "/home/jesse/devel/gitg/libgitg/gitg-repository.vala"
			if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1164 "gitg-repository.c"
				goto __catch5_g_error;
			}
#line 214 "/home/jesse/devel/gitg/libgitg/gitg-repository.vala"
			_tmp39_ = g_strdup (_tmp36_);
#line 214 "/home/jesse/devel/gitg/libgitg/gitg-repository.vala"
			_g_free0 (user);
#line 214 "/home/jesse/devel/gitg/libgitg/gitg-repository.vala"
			user = _tmp39_;
#line 1173 "gitg-repository.c"
		}
		goto __finally5;
		__catch5_g_error:
		{
#line 212 "/home/jesse/devel/gitg/libgitg/gitg-repository.vala"
			g_clear_error (&_inner_error_);
#line 212 "/home/jesse/devel/gitg/libgitg/gitg-repository.vala"
			_inner_error_ = NULL;
#line 1182 "gitg-repository.c"
		}
		__finally5:
#line 212 "/home/jesse/devel/gitg/libgitg/gitg-repository.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 212 "/home/jesse/devel/gitg/libgitg/gitg-repository.vala"
			g_propagate_error (error, _inner_error_);
#line 212 "/home/jesse/devel/gitg/libgitg/gitg-repository.vala"
			_g_object_unref0 (conf);
#line 212 "/home/jesse/devel/gitg/libgitg/gitg-repository.vala"
			_g_free0 (dateenv);
#line 212 "/home/jesse/devel/gitg/libgitg/gitg-repository.vala"
			_g_free0 (emailenv);
#line 212 "/home/jesse/devel/gitg/libgitg/gitg-repository.vala"
			_g_free0 (nameenv);
#line 212 "/home/jesse/devel/gitg/libgitg/gitg-repository.vala"
			_g_date_time_unref0 (date);
#line 212 "/home/jesse/devel/gitg/libgitg/gitg-repository.vala"
			_g_free0 (email);
#line 212 "/home/jesse/devel/gitg/libgitg/gitg-repository.vala"
			_g_free0 (user);
#line 212 "/home/jesse/devel/gitg/libgitg/gitg-repository.vala"
			return NULL;
#line 1205 "gitg-repository.c"
		}
	}
#line 218 "/home/jesse/devel/gitg/libgitg/gitg-repository.vala"
	_tmp40_ = email;
#line 218 "/home/jesse/devel/gitg/libgitg/gitg-repository.vala"
	if (_tmp40_ == NULL) {
#line 1212 "gitg-repository.c"
		{
			const gchar* _tmp41_ = NULL;
			GgitConfig* _tmp42_ = NULL;
			const gchar* _tmp43_ = NULL;
			gchar* _tmp44_ = NULL;
#line 222 "/home/jesse/devel/gitg/libgitg/gitg-repository.vala"
			_tmp42_ = conf;
#line 222 "/home/jesse/devel/gitg/libgitg/gitg-repository.vala"
			_tmp43_ = ggit_config_get_string (_tmp42_, "user.email", &_inner_error_);
#line 222 "/home/jesse/devel/gitg/libgitg/gitg-repository.vala"
			_tmp41_ = _tmp43_;
#line 222 "/home/jesse/devel/gitg/libgitg/gitg-repository.vala"
			if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1226 "gitg-repository.c"
				goto __catch6_g_error;
			}
#line 222 "/home/jesse/devel/gitg/libgitg/gitg-repository.vala"
			_tmp44_ = g_strdup (_tmp41_);
#line 222 "/home/jesse/devel/gitg/libgitg/gitg-repository.vala"
			_g_free0 (email);
#line 222 "/home/jesse/devel/gitg/libgitg/gitg-repository.vala"
			email = _tmp44_;
#line 1235 "gitg-repository.c"
		}
		goto __finally6;
		__catch6_g_error:
		{
#line 220 "/home/jesse/devel/gitg/libgitg/gitg-repository.vala"
			g_clear_error (&_inner_error_);
#line 220 "/home/jesse/devel/gitg/libgitg/gitg-repository.vala"
			_inner_error_ = NULL;
#line 1244 "gitg-repository.c"
		}
		__finally6:
#line 220 "/home/jesse/devel/gitg/libgitg/gitg-repository.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 220 "/home/jesse/devel/gitg/libgitg/gitg-repository.vala"
			g_propagate_error (error, _inner_error_);
#line 220 "/home/jesse/devel/gitg/libgitg/gitg-repository.vala"
			_g_object_unref0 (conf);
#line 220 "/home/jesse/devel/gitg/libgitg/gitg-repository.vala"
			_g_free0 (dateenv);
#line 220 "/home/jesse/devel/gitg/libgitg/gitg-repository.vala"
			_g_free0 (emailenv);
#line 220 "/home/jesse/devel/gitg/libgitg/gitg-repository.vala"
			_g_free0 (nameenv);
#line 220 "/home/jesse/devel/gitg/libgitg/gitg-repository.vala"
			_g_date_time_unref0 (date);
#line 220 "/home/jesse/devel/gitg/libgitg/gitg-repository.vala"
			_g_free0 (email);
#line 220 "/home/jesse/devel/gitg/libgitg/gitg-repository.vala"
			_g_free0 (user);
#line 220 "/home/jesse/devel/gitg/libgitg/gitg-repository.vala"
			return NULL;
#line 1267 "gitg-repository.c"
		}
	}
#line 226 "/home/jesse/devel/gitg/libgitg/gitg-repository.vala"
	_tmp46_ = user;
#line 226 "/home/jesse/devel/gitg/libgitg/gitg-repository.vala"
	if (_tmp46_ != NULL) {
#line 1274 "gitg-repository.c"
		const gchar* _tmp47_ = NULL;
#line 226 "/home/jesse/devel/gitg/libgitg/gitg-repository.vala"
		_tmp47_ = user;
#line 226 "/home/jesse/devel/gitg/libgitg/gitg-repository.vala"
		_tmp45_ = _tmp47_;
#line 1280 "gitg-repository.c"
	} else {
#line 226 "/home/jesse/devel/gitg/libgitg/gitg-repository.vala"
		_tmp45_ = "";
#line 1284 "gitg-repository.c"
	}
#line 227 "/home/jesse/devel/gitg/libgitg/gitg-repository.vala"
	_tmp49_ = email;
#line 227 "/home/jesse/devel/gitg/libgitg/gitg-repository.vala"
	if (_tmp49_ != NULL) {
#line 1290 "gitg-repository.c"
		const gchar* _tmp50_ = NULL;
#line 227 "/home/jesse/devel/gitg/libgitg/gitg-repository.vala"
		_tmp50_ = email;
#line 227 "/home/jesse/devel/gitg/libgitg/gitg-repository.vala"
		_tmp48_ = _tmp50_;
#line 1296 "gitg-repository.c"
	} else {
#line 227 "/home/jesse/devel/gitg/libgitg/gitg-repository.vala"
		_tmp48_ = "";
#line 1300 "gitg-repository.c"
	}
#line 226 "/home/jesse/devel/gitg/libgitg/gitg-repository.vala"
	_tmp52_ = date;
#line 226 "/home/jesse/devel/gitg/libgitg/gitg-repository.vala"
	_tmp53_ = ggit_signature_new (_tmp45_, _tmp48_, _tmp52_, &_inner_error_);
#line 226 "/home/jesse/devel/gitg/libgitg/gitg-repository.vala"
	_tmp51_ = _tmp53_;
#line 226 "/home/jesse/devel/gitg/libgitg/gitg-repository.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 226 "/home/jesse/devel/gitg/libgitg/gitg-repository.vala"
		g_propagate_error (error, _inner_error_);
#line 226 "/home/jesse/devel/gitg/libgitg/gitg-repository.vala"
		_g_object_unref0 (conf);
#line 226 "/home/jesse/devel/gitg/libgitg/gitg-repository.vala"
		_g_free0 (dateenv);
#line 226 "/home/jesse/devel/gitg/libgitg/gitg-repository.vala"
		_g_free0 (emailenv);
#line 226 "/home/jesse/devel/gitg/libgitg/gitg-repository.vala"
		_g_free0 (nameenv);
#line 226 "/home/jesse/devel/gitg/libgitg/gitg-repository.vala"
		_g_date_time_unref0 (date);
#line 226 "/home/jesse/devel/gitg/libgitg/gitg-repository.vala"
		_g_free0 (email);
#line 226 "/home/jesse/devel/gitg/libgitg/gitg-repository.vala"
		_g_free0 (user);
#line 226 "/home/jesse/devel/gitg/libgitg/gitg-repository.vala"
		return NULL;
#line 1328 "gitg-repository.c"
	}
#line 226 "/home/jesse/devel/gitg/libgitg/gitg-repository.vala"
	_tmp54_ = _tmp51_;
#line 226 "/home/jesse/devel/gitg/libgitg/gitg-repository.vala"
	_tmp51_ = NULL;
#line 226 "/home/jesse/devel/gitg/libgitg/gitg-repository.vala"
	result = _tmp54_;
#line 226 "/home/jesse/devel/gitg/libgitg/gitg-repository.vala"
	_g_object_unref0 (_tmp51_);
#line 226 "/home/jesse/devel/gitg/libgitg/gitg-repository.vala"
	_g_object_unref0 (conf);
#line 226 "/home/jesse/devel/gitg/libgitg/gitg-repository.vala"
	_g_free0 (dateenv);
#line 226 "/home/jesse/devel/gitg/libgitg/gitg-repository.vala"
	_g_free0 (emailenv);
#line 226 "/home/jesse/devel/gitg/libgitg/gitg-repository.vala"
	_g_free0 (nameenv);
#line 226 "/home/jesse/devel/gitg/libgitg/gitg-repository.vala"
	_g_date_time_unref0 (date);
#line 226 "/home/jesse/devel/gitg/libgitg/gitg-repository.vala"
	_g_free0 (email);
#line 226 "/home/jesse/devel/gitg/libgitg/gitg-repository.vala"
	_g_free0 (user);
#line 226 "/home/jesse/devel/gitg/libgitg/gitg-repository.vala"
	return result;
#line 1354 "gitg-repository.c"
}


gchar* gitg_repository_get_name (GitgRepository* self) {
	gchar* result;
	GFile* _tmp0_ = NULL;
	GFile* _tmp1_ = NULL;
	GFile* _tmp2_ = NULL;
	GFile* _tmp3_ = NULL;
	gboolean _tmp4_ = FALSE;
	GFile* f = NULL;
	GFile* _tmp9_ = NULL;
	gchar* _tmp10_ = NULL;
	GFile* _tmp11_ = NULL;
#line 30 "/home/jesse/devel/gitg/libgitg/gitg-repository.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 32 "/home/jesse/devel/gitg/libgitg/gitg-repository.vala"
	g_object_get ((GgitRepository*) self, "workdir", &_tmp1_, NULL);
#line 32 "/home/jesse/devel/gitg/libgitg/gitg-repository.vala"
	_tmp2_ = _tmp1_;
#line 32 "/home/jesse/devel/gitg/libgitg/gitg-repository.vala"
	_tmp3_ = _tmp2_;
#line 32 "/home/jesse/devel/gitg/libgitg/gitg-repository.vala"
	_tmp4_ = _tmp3_ != NULL;
#line 32 "/home/jesse/devel/gitg/libgitg/gitg-repository.vala"
	_g_object_unref0 (_tmp3_);
#line 32 "/home/jesse/devel/gitg/libgitg/gitg-repository.vala"
	if (_tmp4_) {
#line 1383 "gitg-repository.c"
		GFile* _tmp5_ = NULL;
		GFile* _tmp6_ = NULL;
#line 32 "/home/jesse/devel/gitg/libgitg/gitg-repository.vala"
		g_object_get ((GgitRepository*) self, "workdir", &_tmp5_, NULL);
#line 32 "/home/jesse/devel/gitg/libgitg/gitg-repository.vala"
		_tmp6_ = _tmp5_;
#line 32 "/home/jesse/devel/gitg/libgitg/gitg-repository.vala"
		_g_object_unref0 (_tmp0_);
#line 32 "/home/jesse/devel/gitg/libgitg/gitg-repository.vala"
		_tmp0_ = _tmp6_;
#line 1394 "gitg-repository.c"
	} else {
		GFile* _tmp7_ = NULL;
		GFile* _tmp8_ = NULL;
#line 32 "/home/jesse/devel/gitg/libgitg/gitg-repository.vala"
		_tmp7_ = ggit_repository_get_location ((GgitRepository*) self);
#line 32 "/home/jesse/devel/gitg/libgitg/gitg-repository.vala"
		_tmp8_ = _tmp7_;
#line 32 "/home/jesse/devel/gitg/libgitg/gitg-repository.vala"
		_g_object_unref0 (_tmp0_);
#line 32 "/home/jesse/devel/gitg/libgitg/gitg-repository.vala"
		_tmp0_ = _tmp8_;
#line 1406 "gitg-repository.c"
	}
#line 32 "/home/jesse/devel/gitg/libgitg/gitg-repository.vala"
	_tmp9_ = _g_object_ref0 (_tmp0_);
#line 32 "/home/jesse/devel/gitg/libgitg/gitg-repository.vala"
	f = _tmp9_;
#line 33 "/home/jesse/devel/gitg/libgitg/gitg-repository.vala"
	_tmp11_ = f;
#line 33 "/home/jesse/devel/gitg/libgitg/gitg-repository.vala"
	if (_tmp11_ != NULL) {
#line 1416 "gitg-repository.c"
		GFile* _tmp12_ = NULL;
		gchar* _tmp13_ = NULL;
#line 33 "/home/jesse/devel/gitg/libgitg/gitg-repository.vala"
		_tmp12_ = f;
#line 33 "/home/jesse/devel/gitg/libgitg/gitg-repository.vala"
		_tmp13_ = g_file_get_basename (_tmp12_);
#line 33 "/home/jesse/devel/gitg/libgitg/gitg-repository.vala"
		_g_free0 (_tmp10_);
#line 33 "/home/jesse/devel/gitg/libgitg/gitg-repository.vala"
		_tmp10_ = _tmp13_;
#line 1427 "gitg-repository.c"
	} else {
#line 33 "/home/jesse/devel/gitg/libgitg/gitg-repository.vala"
		_g_free0 (_tmp10_);
#line 33 "/home/jesse/devel/gitg/libgitg/gitg-repository.vala"
		_tmp10_ = NULL;
#line 1433 "gitg-repository.c"
	}
#line 33 "/home/jesse/devel/gitg/libgitg/gitg-repository.vala"
	result = _tmp10_;
#line 33 "/home/jesse/devel/gitg/libgitg/gitg-repository.vala"
	_g_object_unref0 (f);
#line 33 "/home/jesse/devel/gitg/libgitg/gitg-repository.vala"
	_g_object_unref0 (_tmp0_);
#line 33 "/home/jesse/devel/gitg/libgitg/gitg-repository.vala"
	return result;
#line 1443 "gitg-repository.c"
}


GitgStage* gitg_repository_get_stage (GitgRepository* self) {
	GitgStage* result;
	GitgStage* _tmp0_ = NULL;
	GitgStage* _tmp2_ = NULL;
	GitgStage* _tmp3_ = NULL;
#line 163 "/home/jesse/devel/gitg/libgitg/gitg-repository.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 165 "/home/jesse/devel/gitg/libgitg/gitg-repository.vala"
	_tmp0_ = self->priv->d_stage;
#line 165 "/home/jesse/devel/gitg/libgitg/gitg-repository.vala"
	if (_tmp0_ == NULL) {
#line 1458 "gitg-repository.c"
		GitgStage* _tmp1_ = NULL;
#line 167 "/home/jesse/devel/gitg/libgitg/gitg-repository.vala"
		_tmp1_ = gitg_stage_new (self);
#line 167 "/home/jesse/devel/gitg/libgitg/gitg-repository.vala"
		_g_object_unref0 (self->priv->d_stage);
#line 167 "/home/jesse/devel/gitg/libgitg/gitg-repository.vala"
		self->priv->d_stage = _tmp1_;
#line 1466 "gitg-repository.c"
	}
#line 170 "/home/jesse/devel/gitg/libgitg/gitg-repository.vala"
	_tmp2_ = self->priv->d_stage;
#line 170 "/home/jesse/devel/gitg/libgitg/gitg-repository.vala"
	_tmp3_ = _g_object_ref0 (_tmp2_);
#line 170 "/home/jesse/devel/gitg/libgitg/gitg-repository.vala"
	result = _tmp3_;
#line 170 "/home/jesse/devel/gitg/libgitg/gitg-repository.vala"
	return result;
#line 1476 "gitg-repository.c"
}


static void gitg_repository_class_init (GitgRepositoryClass * klass) {
#line 23 "/home/jesse/devel/gitg/libgitg/gitg-repository.vala"
	gitg_repository_parent_class = g_type_class_peek_parent (klass);
#line 23 "/home/jesse/devel/gitg/libgitg/gitg-repository.vala"
	g_type_class_add_private (klass, sizeof (GitgRepositoryPrivate));
#line 23 "/home/jesse/devel/gitg/libgitg/gitg-repository.vala"
	G_OBJECT_CLASS (klass)->get_property = _vala_gitg_repository_get_property;
#line 23 "/home/jesse/devel/gitg/libgitg/gitg-repository.vala"
	G_OBJECT_CLASS (klass)->finalize = gitg_repository_finalize;
#line 23 "/home/jesse/devel/gitg/libgitg/gitg-repository.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), GITG_REPOSITORY_NAME, g_param_spec_string ("name", "name", "name", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
#line 23 "/home/jesse/devel/gitg/libgitg/gitg-repository.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), GITG_REPOSITORY_STAGE, g_param_spec_object ("stage", "stage", "stage", GITG_TYPE_STAGE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
#line 1493 "gitg-repository.c"
}


static void gitg_repository_instance_init (GitgRepository * self) {
#line 23 "/home/jesse/devel/gitg/libgitg/gitg-repository.vala"
	self->priv = GITG_REPOSITORY_GET_PRIVATE (self);
#line 1500 "gitg-repository.c"
}


static void gitg_repository_finalize (GObject* obj) {
	GitgRepository * self;
#line 23 "/home/jesse/devel/gitg/libgitg/gitg-repository.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GITG_TYPE_REPOSITORY, GitgRepository);
#line 25 "/home/jesse/devel/gitg/libgitg/gitg-repository.vala"
	_g_hash_table_unref0 (self->priv->d_refs);
#line 26 "/home/jesse/devel/gitg/libgitg/gitg-repository.vala"
	_g_object_unref0 (self->priv->d_stage);
#line 23 "/home/jesse/devel/gitg/libgitg/gitg-repository.vala"
	G_OBJECT_CLASS (gitg_repository_parent_class)->finalize (obj);
#line 1514 "gitg-repository.c"
}


GType gitg_repository_get_type (void) {
	static volatile gsize gitg_repository_type_id__volatile = 0;
	if (g_once_init_enter (&gitg_repository_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (GitgRepositoryClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) gitg_repository_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GitgRepository), 0, (GInstanceInitFunc) gitg_repository_instance_init, NULL };
		GType gitg_repository_type_id;
		gitg_repository_type_id = g_type_register_static (ggit_repository_get_type (), "GitgRepository", &g_define_type_info, 0);
		g_once_init_leave (&gitg_repository_type_id__volatile, gitg_repository_type_id);
	}
	return gitg_repository_type_id__volatile;
}


static void _vala_gitg_repository_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	GitgRepository * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GITG_TYPE_REPOSITORY, GitgRepository);
#line 23 "/home/jesse/devel/gitg/libgitg/gitg-repository.vala"
	switch (property_id) {
#line 23 "/home/jesse/devel/gitg/libgitg/gitg-repository.vala"
		case GITG_REPOSITORY_NAME:
#line 23 "/home/jesse/devel/gitg/libgitg/gitg-repository.vala"
		g_value_take_string (value, gitg_repository_get_name (self));
#line 23 "/home/jesse/devel/gitg/libgitg/gitg-repository.vala"
		break;
#line 23 "/home/jesse/devel/gitg/libgitg/gitg-repository.vala"
		case GITG_REPOSITORY_STAGE:
#line 23 "/home/jesse/devel/gitg/libgitg/gitg-repository.vala"
		g_value_take_object (value, gitg_repository_get_stage (self));
#line 23 "/home/jesse/devel/gitg/libgitg/gitg-repository.vala"
		break;
#line 1547 "gitg-repository.c"
		default:
#line 23 "/home/jesse/devel/gitg/libgitg/gitg-repository.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 23 "/home/jesse/devel/gitg/libgitg/gitg-repository.vala"
		break;
#line 1553 "gitg-repository.c"
	}
}



