/* gitg-credentials-manager.c generated by valac 0.30.0.16-6dbb1, the Vala compiler
 * generated from gitg-credentials-manager.vala, do not modify */

/*
 * This file is part of gitg
 *
 * Copyright (C) 2014 - Jesse van den Kieboom
 *
 * gitg is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * gitg is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with gitg. If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib.h>
#include <glib-object.h>
#include <libgit2-glib/ggit.h>
#include <gtk/gtk.h>
#include <gee.h>
#include <stdlib.h>
#include <string.h>
#include <libsecret/secret.h>
#include <stdio.h>
#include <gio/gio.h>
#include <libsoup/soup.h>
#include <gobject/gvaluecollector.h>


#define GITG_TYPE_CREDENTIALS_MANAGER (gitg_credentials_manager_get_type ())
#define GITG_CREDENTIALS_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GITG_TYPE_CREDENTIALS_MANAGER, GitgCredentialsManager))
#define GITG_CREDENTIALS_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GITG_TYPE_CREDENTIALS_MANAGER, GitgCredentialsManagerClass))
#define GITG_IS_CREDENTIALS_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GITG_TYPE_CREDENTIALS_MANAGER))
#define GITG_IS_CREDENTIALS_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GITG_TYPE_CREDENTIALS_MANAGER))
#define GITG_CREDENTIALS_MANAGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GITG_TYPE_CREDENTIALS_MANAGER, GitgCredentialsManagerClass))

typedef struct _GitgCredentialsManager GitgCredentialsManager;
typedef struct _GitgCredentialsManagerClass GitgCredentialsManagerClass;
typedef struct _GitgCredentialsManagerPrivate GitgCredentialsManagerPrivate;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

#define GITG_TYPE_AUTHENTICATION_LIFE_TIME (gitg_authentication_life_time_get_type ())
typedef struct _Block5Data Block5Data;
#define _gitg_credentials_manager_unref0(var) ((var == NULL) ? NULL : (var = (gitg_credentials_manager_unref (var), NULL)))

#define GITG_TYPE_AUTHENTICATION_DIALOG (gitg_authentication_dialog_get_type ())
#define GITG_AUTHENTICATION_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GITG_TYPE_AUTHENTICATION_DIALOG, GitgAuthenticationDialog))
#define GITG_AUTHENTICATION_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GITG_TYPE_AUTHENTICATION_DIALOG, GitgAuthenticationDialogClass))
#define GITG_IS_AUTHENTICATION_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GITG_TYPE_AUTHENTICATION_DIALOG))
#define GITG_IS_AUTHENTICATION_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GITG_TYPE_AUTHENTICATION_DIALOG))
#define GITG_AUTHENTICATION_DIALOG_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GITG_TYPE_AUTHENTICATION_DIALOG, GitgAuthenticationDialogClass))

typedef struct _GitgAuthenticationDialog GitgAuthenticationDialog;
typedef struct _GitgAuthenticationDialogClass GitgAuthenticationDialogClass;
#define _g_hash_table_unref0(var) ((var == NULL) ? NULL : (var = (g_hash_table_unref (var), NULL)))
#define __vala_SoupURI_free0(var) ((var == NULL) ? NULL : (var = (_vala_SoupURI_free (var), NULL)))
#define _secret_schema_unref0(var) ((var == NULL) ? NULL : (var = (secret_schema_unref (var), NULL)))
typedef struct _GitgParamSpecCredentialsManager GitgParamSpecCredentialsManager;

typedef enum  {
	GITG_CREDENTIALS_ERROR_CANCELLED
} GitgCredentialsError;
#define GITG_CREDENTIALS_ERROR gitg_credentials_error_quark ()
struct _GitgCredentialsManager {
	GTypeInstance parent_instance;
	volatile int ref_count;
	GitgCredentialsManagerPrivate * priv;
};

struct _GitgCredentialsManagerClass {
	GTypeClass parent_class;
	void (*finalize) (GitgCredentialsManager *self);
};

struct _GitgCredentialsManagerPrivate {
	GgitConfig* d_config;
	GtkWindow* d_window;
	GeeHashMap* d_usermap;
	gboolean d_save_user_in_config;
	gchar* d_last_user;
	GeeHashMap* d_auth_tried;
};

typedef enum  {
	GITG_AUTHENTICATION_LIFE_TIME_FORGET,
	GITG_AUTHENTICATION_LIFE_TIME_SESSION,
	GITG_AUTHENTICATION_LIFE_TIME_FOREVER
} GitgAuthenticationLifeTime;

struct _Block5Data {
	int _ref_count_;
	GitgCredentialsManager* self;
	GMutex mutex;
	GCond cond;
	GtkResponseType response;
	gchar* password;
	gchar* newusername;
	GitgAuthenticationLifeTime lifetime;
	gchar* url;
	gchar* username;
};

struct _GitgParamSpecCredentialsManager {
	GParamSpec parent_instance;
};


static gpointer gitg_credentials_manager_parent_class = NULL;
static SecretSchema* gitg_credentials_manager_s_secret_schema;
static SecretSchema* gitg_credentials_manager_s_secret_schema = NULL;

GQuark gitg_credentials_error_quark (void);
gpointer gitg_credentials_manager_ref (gpointer instance);
void gitg_credentials_manager_unref (gpointer instance);
GParamSpec* gitg_param_spec_credentials_manager (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void gitg_value_set_credentials_manager (GValue* value, gpointer v_object);
void gitg_value_take_credentials_manager (GValue* value, gpointer v_object);
gpointer gitg_value_get_credentials_manager (const GValue* value);
GType gitg_credentials_manager_get_type (void) G_GNUC_CONST;
#define GITG_CREDENTIALS_MANAGER_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), GITG_TYPE_CREDENTIALS_MANAGER, GitgCredentialsManagerPrivate))
enum  {
	GITG_CREDENTIALS_MANAGER_DUMMY_PROPERTY
};
GitgCredentialsManager* gitg_credentials_manager_new (GgitConfig* config, GtkWindow* window, gboolean save_user_in_config);
GitgCredentialsManager* gitg_credentials_manager_construct (GType object_type, GgitConfig* config, GtkWindow* window, gboolean save_user_in_config);
static gchar* gitg_credentials_manager_lookup_user (GitgCredentialsManager* self, const gchar* host);
static gint _____lambda39_ (GitgCredentialsManager* self, GMatchInfo* info, const gchar* value);
static gint ______lambda39__ggit_config_match_callback (GMatchInfo* match_info, const gchar* value, gpointer self);
static GgitCred* gitg_credentials_manager_user_pass_dialog (GitgCredentialsManager* self, const gchar* url, const gchar* scheme, const gchar* host, const gchar* username, GError** error);
GType gitg_authentication_life_time_get_type (void) G_GNUC_CONST;
static Block5Data* block5_data_ref (Block5Data* _data5_);
static void block5_data_unref (void * _userdata_);
static gboolean __lambda40_ (Block5Data* _data5_);
GType gitg_authentication_dialog_get_type (void) G_GNUC_CONST;
GitgAuthenticationDialog* gitg_authentication_dialog_new (const gchar* url, const gchar* username, gboolean failed);
GitgAuthenticationDialog* gitg_authentication_dialog_construct (GType object_type, const gchar* url, const gchar* username, gboolean failed);
const gchar* gitg_authentication_dialog_get_username (GitgAuthenticationDialog* self);
const gchar* gitg_authentication_dialog_get_password (GitgAuthenticationDialog* self);
GitgAuthenticationLifeTime gitg_authentication_dialog_get_life_time (GitgAuthenticationDialog* self);
static gboolean ___lambda40__gsource_func (gpointer self);
static void _g_free0_ (gpointer var);
static void ___lambda41_ (GitgCredentialsManager* self, GObject* obj, GAsyncResult* res);
static void ____lambda41__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self);
static void ___lambda42_ (GitgCredentialsManager* self, GObject* obj, GAsyncResult* res);
static void ____lambda42__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self);
static GgitCred* gitg_credentials_manager_query_user_pass (GitgCredentialsManager* self, const gchar* url, const gchar* username, GError** error);
static void _vala_SoupURI_free (SoupURI* self);
GgitCred* gitg_credentials_manager_credentials (GitgCredentialsManager* self, const gchar* url, const gchar* username, GgitCredtype allowed_types, GError** error);
static void gitg_credentials_manager_finalize (GitgCredentialsManager* obj);
static void _vala_clear_GMutex (GMutex * mutex);
static void _vala_clear_GRecMutex (GRecMutex * mutex);
static void _vala_clear_GRWLock (GRWLock * mutex);
static void _vala_clear_GCond (GCond * mutex);


GQuark gitg_credentials_error_quark (void) {
	return g_quark_from_static_string ("gitg_credentials_error-quark");
}


static gpointer _g_object_ref0 (gpointer self) {
#line 49 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-credentials-manager.vala"
	return self ? g_object_ref (self) : NULL;
#line 175 "gitg-credentials-manager.c"
}


GitgCredentialsManager* gitg_credentials_manager_construct (GType object_type, GgitConfig* config, GtkWindow* window, gboolean save_user_in_config) {
	GitgCredentialsManager* self = NULL;
	GgitConfig* _tmp0_ = NULL;
	GgitConfig* _tmp1_ = NULL;
	gboolean _tmp2_ = FALSE;
	GeeHashMap* _tmp3_ = NULL;
	GtkWindow* _tmp4_ = NULL;
	GtkWindow* _tmp5_ = NULL;
#line 47 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-credentials-manager.vala"
	g_return_val_if_fail (window != NULL, NULL);
#line 47 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-credentials-manager.vala"
	self = (GitgCredentialsManager*) g_type_create_instance (object_type);
#line 49 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-credentials-manager.vala"
	_tmp0_ = config;
#line 49 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-credentials-manager.vala"
	_tmp1_ = _g_object_ref0 (_tmp0_);
#line 49 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-credentials-manager.vala"
	_g_object_unref0 (self->priv->d_config);
#line 49 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-credentials-manager.vala"
	self->priv->d_config = _tmp1_;
#line 50 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-credentials-manager.vala"
	_tmp2_ = save_user_in_config;
#line 50 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-credentials-manager.vala"
	self->priv->d_save_user_in_config = _tmp2_;
#line 51 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-credentials-manager.vala"
	_tmp3_ = gee_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, ggit_credtype_get_type (), NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
#line 51 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-credentials-manager.vala"
	_g_object_unref0 (self->priv->d_auth_tried);
#line 51 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-credentials-manager.vala"
	self->priv->d_auth_tried = _tmp3_;
#line 52 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-credentials-manager.vala"
	_tmp4_ = window;
#line 52 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-credentials-manager.vala"
	_tmp5_ = _g_object_ref0 (_tmp4_);
#line 52 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-credentials-manager.vala"
	_g_object_unref0 (self->priv->d_window);
#line 52 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-credentials-manager.vala"
	self->priv->d_window = _tmp5_;
#line 47 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-credentials-manager.vala"
	return self;
#line 219 "gitg-credentials-manager.c"
}


GitgCredentialsManager* gitg_credentials_manager_new (GgitConfig* config, GtkWindow* window, gboolean save_user_in_config) {
#line 47 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-credentials-manager.vala"
	return gitg_credentials_manager_construct (GITG_TYPE_CREDENTIALS_MANAGER, config, window, save_user_in_config);
#line 226 "gitg-credentials-manager.c"
}


static gint _____lambda39_ (GitgCredentialsManager* self, GMatchInfo* info, const gchar* value) {
	gint result = 0;
	GeeHashMap* _tmp0_ = NULL;
	GMatchInfo* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	const gchar* _tmp4_ = NULL;
#line 67 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-credentials-manager.vala"
	g_return_val_if_fail (info != NULL, 0);
#line 67 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-credentials-manager.vala"
	g_return_val_if_fail (value != NULL, 0);
#line 68 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-credentials-manager.vala"
	_tmp0_ = self->priv->d_usermap;
#line 68 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-credentials-manager.vala"
	_tmp1_ = info;
#line 68 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-credentials-manager.vala"
	_tmp2_ = g_match_info_fetch (_tmp1_, 1);
#line 68 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-credentials-manager.vala"
	_tmp3_ = _tmp2_;
#line 68 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-credentials-manager.vala"
	_tmp4_ = value;
#line 68 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-credentials-manager.vala"
	gee_abstract_map_set ((GeeAbstractMap*) _tmp0_, _tmp3_, _tmp4_);
#line 68 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-credentials-manager.vala"
	_g_free0 (_tmp3_);
#line 69 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-credentials-manager.vala"
	result = 0;
#line 69 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-credentials-manager.vala"
	return result;
#line 259 "gitg-credentials-manager.c"
}


static gint ______lambda39__ggit_config_match_callback (GMatchInfo* match_info, const gchar* value, gpointer self) {
	gint result;
	result = _____lambda39_ ((GitgCredentialsManager*) self, match_info, value);
#line 67 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-credentials-manager.vala"
	return result;
#line 268 "gitg-credentials-manager.c"
}


static gchar* gitg_credentials_manager_lookup_user (GitgCredentialsManager* self, const gchar* host) {
	gchar* result = NULL;
	GeeHashMap* _tmp0_ = NULL;
	GeeHashMap* _tmp13_ = NULL;
	const gchar* _tmp14_ = NULL;
	gpointer _tmp15_ = NULL;
	GError * _inner_error_ = NULL;
#line 55 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-credentials-manager.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 55 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-credentials-manager.vala"
	g_return_val_if_fail (host != NULL, NULL);
#line 57 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-credentials-manager.vala"
	_tmp0_ = self->priv->d_usermap;
#line 57 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-credentials-manager.vala"
	if (_tmp0_ == NULL) {
#line 287 "gitg-credentials-manager.c"
		GeeHashMap* _tmp1_ = NULL;
		GgitConfig* _tmp2_ = NULL;
#line 59 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-credentials-manager.vala"
		_tmp1_ = gee_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
#line 59 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-credentials-manager.vala"
		_g_object_unref0 (self->priv->d_usermap);
#line 59 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-credentials-manager.vala"
		self->priv->d_usermap = _tmp1_;
#line 61 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-credentials-manager.vala"
		_tmp2_ = self->priv->d_config;
#line 61 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-credentials-manager.vala"
		if (_tmp2_ != NULL) {
#line 300 "gitg-credentials-manager.c"
			{
				GRegex* r = NULL;
				GRegex* _tmp3_ = NULL;
				GgitConfig* _tmp4_ = NULL;
				GgitConfig* _tmp5_ = NULL;
				GgitConfig* _tmp6_ = NULL;
				GgitConfig* _tmp7_ = NULL;
				GgitConfig* _tmp8_ = NULL;
				GRegex* _tmp9_ = NULL;
#line 65 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-credentials-manager.vala"
				_tmp3_ = g_regex_new ("credential\\.(.*)\\.username", 0, 0, &_inner_error_);
#line 65 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-credentials-manager.vala"
				r = _tmp3_;
#line 65 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-credentials-manager.vala"
				if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 316 "gitg-credentials-manager.c"
					goto __catch24_g_error;
				}
#line 67 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-credentials-manager.vala"
				_tmp5_ = self->priv->d_config;
#line 67 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-credentials-manager.vala"
				_tmp6_ = ggit_config_snapshot (_tmp5_, &_inner_error_);
#line 67 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-credentials-manager.vala"
				_tmp4_ = _tmp6_;
#line 67 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-credentials-manager.vala"
				if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 67 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-credentials-manager.vala"
					_g_regex_unref0 (r);
#line 329 "gitg-credentials-manager.c"
					goto __catch24_g_error;
				}
#line 67 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-credentials-manager.vala"
				_tmp7_ = _tmp4_;
#line 67 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-credentials-manager.vala"
				_tmp4_ = NULL;
#line 67 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-credentials-manager.vala"
				_tmp8_ = _tmp7_;
#line 67 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-credentials-manager.vala"
				_tmp9_ = r;
#line 67 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-credentials-manager.vala"
				ggit_config_match_foreach (_tmp8_, _tmp9_, ______lambda39__ggit_config_match_callback, self, &_inner_error_);
#line 67 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-credentials-manager.vala"
				_g_object_unref0 (_tmp8_);
#line 67 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-credentials-manager.vala"
				if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 67 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-credentials-manager.vala"
					_g_object_unref0 (_tmp4_);
#line 67 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-credentials-manager.vala"
					_g_regex_unref0 (r);
#line 350 "gitg-credentials-manager.c"
					goto __catch24_g_error;
				}
#line 63 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-credentials-manager.vala"
				_g_object_unref0 (_tmp4_);
#line 63 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-credentials-manager.vala"
				_g_regex_unref0 (r);
#line 357 "gitg-credentials-manager.c"
			}
			goto __finally24;
			__catch24_g_error:
			{
				GError* e = NULL;
				FILE* _tmp10_ = NULL;
				GError* _tmp11_ = NULL;
				const gchar* _tmp12_ = NULL;
#line 63 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-credentials-manager.vala"
				e = _inner_error_;
#line 63 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-credentials-manager.vala"
				_inner_error_ = NULL;
#line 74 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-credentials-manager.vala"
				_tmp10_ = stderr;
#line 74 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-credentials-manager.vala"
				_tmp11_ = e;
#line 74 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-credentials-manager.vala"
				_tmp12_ = _tmp11_->message;
#line 74 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-credentials-manager.vala"
				fprintf (_tmp10_, "Could not get username from git config: %s\n", _tmp12_);
#line 63 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-credentials-manager.vala"
				_g_error_free0 (e);
#line 380 "gitg-credentials-manager.c"
			}
			__finally24:
#line 63 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-credentials-manager.vala"
			if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 63 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-credentials-manager.vala"
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 63 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-credentials-manager.vala"
				g_clear_error (&_inner_error_);
#line 63 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-credentials-manager.vala"
				return NULL;
#line 391 "gitg-credentials-manager.c"
			}
		}
	}
#line 79 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-credentials-manager.vala"
	_tmp13_ = self->priv->d_usermap;
#line 79 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-credentials-manager.vala"
	_tmp14_ = host;
#line 79 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-credentials-manager.vala"
	_tmp15_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp13_, _tmp14_);
#line 79 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-credentials-manager.vala"
	result = (gchar*) _tmp15_;
#line 79 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-credentials-manager.vala"
	return result;
#line 405 "gitg-credentials-manager.c"
}


static Block5Data* block5_data_ref (Block5Data* _data5_) {
#line 82 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-credentials-manager.vala"
	g_atomic_int_inc (&_data5_->_ref_count_);
#line 82 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-credentials-manager.vala"
	return _data5_;
#line 414 "gitg-credentials-manager.c"
}


static void block5_data_unref (void * _userdata_) {
	Block5Data* _data5_;
	_data5_ = (Block5Data*) _userdata_;
#line 82 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-credentials-manager.vala"
	if (g_atomic_int_dec_and_test (&_data5_->_ref_count_)) {
#line 423 "gitg-credentials-manager.c"
		GitgCredentialsManager* self;
#line 82 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-credentials-manager.vala"
		self = _data5_->self;
#line 82 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-credentials-manager.vala"
		_g_free0 (_data5_->newusername);
#line 82 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-credentials-manager.vala"
		_g_free0 (_data5_->password);
#line 82 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-credentials-manager.vala"
		_vala_clear_GCond (&_data5_->cond);
#line 82 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-credentials-manager.vala"
		_vala_clear_GMutex (&_data5_->mutex);
#line 82 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-credentials-manager.vala"
		_g_free0 (_data5_->url);
#line 82 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-credentials-manager.vala"
		_g_free0 (_data5_->username);
#line 82 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-credentials-manager.vala"
		_gitg_credentials_manager_unref0 (self);
#line 82 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-credentials-manager.vala"
		g_slice_free (Block5Data, _data5_);
#line 443 "gitg-credentials-manager.c"
	}
}


static gboolean __lambda40_ (Block5Data* _data5_) {
	GitgCredentialsManager* self;
	gboolean result = FALSE;
	GitgAuthenticationDialog* d = NULL;
	const gchar* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	GeeHashMap* _tmp2_ = NULL;
	const gchar* _tmp3_ = NULL;
	gpointer _tmp4_ = NULL;
	GitgAuthenticationDialog* _tmp5_ = NULL;
	GitgAuthenticationDialog* _tmp6_ = NULL;
	GtkWindow* _tmp7_ = NULL;
	GitgAuthenticationDialog* _tmp8_ = NULL;
	gint _tmp9_ = 0;
	GtkResponseType _tmp10_ = 0;
	GitgAuthenticationDialog* _tmp22_ = NULL;
#line 95 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-credentials-manager.vala"
	self = _data5_->self;
#line 96 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-credentials-manager.vala"
	_tmp0_ = _data5_->url;
#line 96 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-credentials-manager.vala"
	_tmp1_ = _data5_->username;
#line 96 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-credentials-manager.vala"
	_tmp2_ = self->priv->d_auth_tried;
#line 96 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-credentials-manager.vala"
	_tmp3_ = _data5_->username;
#line 96 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-credentials-manager.vala"
	_tmp4_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp2_, _tmp3_);
#line 96 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-credentials-manager.vala"
	_tmp5_ = gitg_authentication_dialog_new (_tmp0_, _tmp1_, ((GgitCredtype) ((gintptr) _tmp4_)) != 0);
#line 96 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-credentials-manager.vala"
	g_object_ref_sink (_tmp5_);
#line 96 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-credentials-manager.vala"
	d = _tmp5_;
#line 97 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-credentials-manager.vala"
	_tmp6_ = d;
#line 97 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-credentials-manager.vala"
	_tmp7_ = self->priv->d_window;
#line 97 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-credentials-manager.vala"
	gtk_window_set_transient_for ((GtkWindow*) _tmp6_, _tmp7_);
#line 99 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-credentials-manager.vala"
	_tmp8_ = d;
#line 99 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-credentials-manager.vala"
	_tmp9_ = gtk_dialog_run ((GtkDialog*) _tmp8_);
#line 99 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-credentials-manager.vala"
	_data5_->response = (GtkResponseType) _tmp9_;
#line 101 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-credentials-manager.vala"
	_tmp10_ = _data5_->response;
#line 101 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-credentials-manager.vala"
	if (_tmp10_ == GTK_RESPONSE_OK) {
#line 498 "gitg-credentials-manager.c"
		GitgAuthenticationDialog* _tmp11_ = NULL;
		const gchar* _tmp12_ = NULL;
		const gchar* _tmp13_ = NULL;
		gchar* _tmp14_ = NULL;
		GitgAuthenticationDialog* _tmp15_ = NULL;
		const gchar* _tmp16_ = NULL;
		const gchar* _tmp17_ = NULL;
		gchar* _tmp18_ = NULL;
		GitgAuthenticationDialog* _tmp19_ = NULL;
		GitgAuthenticationLifeTime _tmp20_ = 0;
		GitgAuthenticationLifeTime _tmp21_ = 0;
#line 103 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-credentials-manager.vala"
		_tmp11_ = d;
#line 103 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-credentials-manager.vala"
		_tmp12_ = gitg_authentication_dialog_get_username (_tmp11_);
#line 103 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-credentials-manager.vala"
		_tmp13_ = _tmp12_;
#line 103 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-credentials-manager.vala"
		_tmp14_ = g_strdup (_tmp13_);
#line 103 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-credentials-manager.vala"
		_g_free0 (_data5_->newusername);
#line 103 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-credentials-manager.vala"
		_data5_->newusername = _tmp14_;
#line 104 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-credentials-manager.vala"
		_tmp15_ = d;
#line 104 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-credentials-manager.vala"
		_tmp16_ = gitg_authentication_dialog_get_password (_tmp15_);
#line 104 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-credentials-manager.vala"
		_tmp17_ = _tmp16_;
#line 104 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-credentials-manager.vala"
		_tmp18_ = g_strdup (_tmp17_);
#line 104 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-credentials-manager.vala"
		_g_free0 (_data5_->password);
#line 104 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-credentials-manager.vala"
		_data5_->password = _tmp18_;
#line 105 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-credentials-manager.vala"
		_tmp19_ = d;
#line 105 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-credentials-manager.vala"
		_tmp20_ = gitg_authentication_dialog_get_life_time (_tmp19_);
#line 105 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-credentials-manager.vala"
		_tmp21_ = _tmp20_;
#line 105 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-credentials-manager.vala"
		_data5_->lifetime = _tmp21_;
#line 542 "gitg-credentials-manager.c"
	}
#line 108 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-credentials-manager.vala"
	_tmp22_ = d;
#line 108 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-credentials-manager.vala"
	gtk_widget_destroy ((GtkWidget*) _tmp22_);
#line 110 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-credentials-manager.vala"
	g_mutex_lock (&_data5_->mutex);
#line 111 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-credentials-manager.vala"
	g_cond_signal (&_data5_->cond);
#line 112 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-credentials-manager.vala"
	g_mutex_unlock (&_data5_->mutex);
#line 114 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-credentials-manager.vala"
	result = FALSE;
#line 114 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-credentials-manager.vala"
	_g_object_unref0 (d);
#line 114 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-credentials-manager.vala"
	return result;
#line 560 "gitg-credentials-manager.c"
}


static gboolean ___lambda40__gsource_func (gpointer self) {
	gboolean result;
	result = __lambda40_ (self);
#line 95 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-credentials-manager.vala"
	return result;
#line 569 "gitg-credentials-manager.c"
}


static const gchar* string_to_string (const gchar* self) {
	const gchar* result = NULL;
#line 1314 "/opt/gnome/share/vala-0.30/vapi/glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, NULL);
#line 1315 "/opt/gnome/share/vala-0.30/vapi/glib-2.0.vapi"
	result = self;
#line 1315 "/opt/gnome/share/vala-0.30/vapi/glib-2.0.vapi"
	return result;
#line 581 "gitg-credentials-manager.c"
}


static void _g_free0_ (gpointer var) {
#line 148 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-credentials-manager.vala"
	var = (g_free (var), NULL);
#line 588 "gitg-credentials-manager.c"
}


static void ___lambda41_ (GitgCredentialsManager* self, GObject* obj, GAsyncResult* res) {
	GError * _inner_error_ = NULL;
#line 169 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-credentials-manager.vala"
	g_return_if_fail (res != NULL);
#line 596 "gitg-credentials-manager.c"
	{
		GAsyncResult* _tmp0_ = NULL;
#line 172 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-credentials-manager.vala"
		_tmp0_ = res;
#line 172 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-credentials-manager.vala"
		secret_password_store_finish (_tmp0_, &_inner_error_);
#line 172 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-credentials-manager.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 605 "gitg-credentials-manager.c"
			goto __catch26_g_error;
		}
	}
	goto __finally26;
	__catch26_g_error:
	{
		GError* e = NULL;
		FILE* _tmp1_ = NULL;
		GError* _tmp2_ = NULL;
		const gchar* _tmp3_ = NULL;
#line 170 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-credentials-manager.vala"
		e = _inner_error_;
#line 170 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-credentials-manager.vala"
		_inner_error_ = NULL;
#line 176 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-credentials-manager.vala"
		_tmp1_ = stderr;
#line 176 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-credentials-manager.vala"
		_tmp2_ = e;
#line 176 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-credentials-manager.vala"
		_tmp3_ = _tmp2_->message;
#line 176 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-credentials-manager.vala"
		fprintf (_tmp1_, "Failed to store secret in keyring: %s\n", _tmp3_);
#line 170 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-credentials-manager.vala"
		_g_error_free0 (e);
#line 630 "gitg-credentials-manager.c"
	}
	__finally26:
#line 170 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-credentials-manager.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 170 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-credentials-manager.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 170 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-credentials-manager.vala"
		g_clear_error (&_inner_error_);
#line 170 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-credentials-manager.vala"
		return;
#line 641 "gitg-credentials-manager.c"
	}
}


static void ____lambda41__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self) {
#line 163 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-credentials-manager.vala"
	___lambda41_ ((GitgCredentialsManager*) self, source_object, res);
#line 163 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-credentials-manager.vala"
	gitg_credentials_manager_unref (self);
#line 651 "gitg-credentials-manager.c"
}


static void ___lambda42_ (GitgCredentialsManager* self, GObject* obj, GAsyncResult* res) {
	GError * _inner_error_ = NULL;
#line 182 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-credentials-manager.vala"
	g_return_if_fail (res != NULL);
#line 659 "gitg-credentials-manager.c"
	{
		GAsyncResult* _tmp0_ = NULL;
#line 185 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-credentials-manager.vala"
		_tmp0_ = res;
#line 185 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-credentials-manager.vala"
		secret_password_clear_finish (_tmp0_, &_inner_error_);
#line 185 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-credentials-manager.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 668 "gitg-credentials-manager.c"
			goto __catch27_g_error;
		}
	}
	goto __finally27;
	__catch27_g_error:
	{
		GError* e = NULL;
		FILE* _tmp1_ = NULL;
		GError* _tmp2_ = NULL;
		const gchar* _tmp3_ = NULL;
#line 183 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-credentials-manager.vala"
		e = _inner_error_;
#line 183 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-credentials-manager.vala"
		_inner_error_ = NULL;
#line 189 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-credentials-manager.vala"
		_tmp1_ = stderr;
#line 189 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-credentials-manager.vala"
		_tmp2_ = e;
#line 189 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-credentials-manager.vala"
		_tmp3_ = _tmp2_->message;
#line 189 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-credentials-manager.vala"
		fprintf (_tmp1_, "Failed to clear secret from keyring: %s\n", _tmp3_);
#line 183 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-credentials-manager.vala"
		_g_error_free0 (e);
#line 693 "gitg-credentials-manager.c"
	}
	__finally27:
#line 183 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-credentials-manager.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 183 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-credentials-manager.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 183 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-credentials-manager.vala"
		g_clear_error (&_inner_error_);
#line 183 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-credentials-manager.vala"
		return;
#line 704 "gitg-credentials-manager.c"
	}
}


static void ____lambda42__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self) {
#line 182 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-credentials-manager.vala"
	___lambda42_ ((GitgCredentialsManager*) self, source_object, res);
#line 182 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-credentials-manager.vala"
	gitg_credentials_manager_unref (self);
#line 714 "gitg-credentials-manager.c"
}


static GgitCred* gitg_credentials_manager_user_pass_dialog (GitgCredentialsManager* self, const gchar* url, const gchar* scheme, const gchar* host, const gchar* username, GError** error) {
	GgitCred* result = NULL;
	Block5Data* _data5_;
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	gchar* _tmp4_ = NULL;
	gchar* _tmp5_ = NULL;
	GtkResponseType _tmp6_ = 0;
	const gchar* _tmp8_ = NULL;
	gchar* _tmp9_ = NULL;
	gboolean _tmp10_ = FALSE;
	const gchar* _tmp11_ = NULL;
	GHashTable* attributes = NULL;
	GHashFunc _tmp37_ = NULL;
	GEqualFunc _tmp38_ = NULL;
	GHashTable* _tmp39_ = NULL;
	GHashTable* _tmp40_ = NULL;
	gchar* _tmp41_ = NULL;
	const gchar* _tmp42_ = NULL;
	gchar* _tmp43_ = NULL;
	GHashTable* _tmp44_ = NULL;
	gchar* _tmp45_ = NULL;
	const gchar* _tmp46_ = NULL;
	gchar* _tmp47_ = NULL;
	GHashTable* _tmp48_ = NULL;
	gchar* _tmp49_ = NULL;
	const gchar* _tmp50_ = NULL;
	gchar* _tmp51_ = NULL;
	GitgAuthenticationLifeTime _tmp52_ = 0;
	GeeHashMap* _tmp67_ = NULL;
	const gchar* _tmp68_ = NULL;
	GgitCredPlaintext* _tmp69_ = NULL;
	const gchar* _tmp70_ = NULL;
	const gchar* _tmp71_ = NULL;
	GgitCredPlaintext* _tmp72_ = NULL;
	GgitCredPlaintext* _tmp73_ = NULL;
	GError * _inner_error_ = NULL;
#line 82 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-credentials-manager.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 82 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-credentials-manager.vala"
	g_return_val_if_fail (url != NULL, NULL);
#line 82 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-credentials-manager.vala"
	g_return_val_if_fail (scheme != NULL, NULL);
#line 82 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-credentials-manager.vala"
	g_return_val_if_fail (host != NULL, NULL);
#line 82 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-credentials-manager.vala"
	_data5_ = g_slice_new0 (Block5Data);
#line 82 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-credentials-manager.vala"
	_data5_->_ref_count_ = 1;
#line 82 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-credentials-manager.vala"
	_data5_->self = gitg_credentials_manager_ref (self);
#line 82 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-credentials-manager.vala"
	_tmp0_ = url;
#line 82 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-credentials-manager.vala"
	_tmp1_ = g_strdup (_tmp0_);
#line 82 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-credentials-manager.vala"
	_g_free0 (_data5_->url);
#line 82 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-credentials-manager.vala"
	_data5_->url = _tmp1_;
#line 82 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-credentials-manager.vala"
	_tmp2_ = username;
#line 82 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-credentials-manager.vala"
	_tmp3_ = g_strdup (_tmp2_);
#line 82 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-credentials-manager.vala"
	_g_free0 (_data5_->username);
#line 82 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-credentials-manager.vala"
	_data5_->username = _tmp3_;
#line 84 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-credentials-manager.vala"
	g_mutex_init (&_data5_->mutex);
#line 85 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-credentials-manager.vala"
	g_mutex_lock (&_data5_->mutex);
#line 87 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-credentials-manager.vala"
	g_cond_init (&_data5_->cond);
#line 89 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-credentials-manager.vala"
	_data5_->response = GTK_RESPONSE_CANCEL;
#line 91 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-credentials-manager.vala"
	_tmp4_ = g_strdup ("");
#line 91 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-credentials-manager.vala"
	_data5_->password = _tmp4_;
#line 92 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-credentials-manager.vala"
	_tmp5_ = g_strdup ("");
#line 92 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-credentials-manager.vala"
	_data5_->newusername = _tmp5_;
#line 93 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-credentials-manager.vala"
	_data5_->lifetime = GITG_AUTHENTICATION_LIFE_TIME_FORGET;
#line 95 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-credentials-manager.vala"
	g_idle_add_full (G_PRIORITY_DEFAULT_IDLE, ___lambda40__gsource_func, block5_data_ref (_data5_), block5_data_unref);
#line 117 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-credentials-manager.vala"
	g_cond_wait (&_data5_->cond, &_data5_->mutex);
#line 118 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-credentials-manager.vala"
	g_mutex_unlock (&_data5_->mutex);
#line 120 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-credentials-manager.vala"
	_tmp6_ = _data5_->response;
#line 120 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-credentials-manager.vala"
	if (_tmp6_ != GTK_RESPONSE_OK) {
#line 815 "gitg-credentials-manager.c"
		GError* _tmp7_ = NULL;
#line 122 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-credentials-manager.vala"
		_tmp7_ = g_error_new_literal (GITG_CREDENTIALS_ERROR, GITG_CREDENTIALS_ERROR_CANCELLED, "cancelled by user");
#line 122 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-credentials-manager.vala"
		_inner_error_ = _tmp7_;
#line 122 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-credentials-manager.vala"
		g_propagate_error (error, _inner_error_);
#line 122 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-credentials-manager.vala"
		block5_data_unref (_data5_);
#line 122 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-credentials-manager.vala"
		_data5_ = NULL;
#line 122 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-credentials-manager.vala"
		return NULL;
#line 829 "gitg-credentials-manager.c"
	}
#line 125 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-credentials-manager.vala"
	_tmp8_ = _data5_->newusername;
#line 125 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-credentials-manager.vala"
	_tmp9_ = g_strdup (_tmp8_);
#line 125 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-credentials-manager.vala"
	_g_free0 (self->priv->d_last_user);
#line 125 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-credentials-manager.vala"
	self->priv->d_last_user = _tmp9_;
#line 128 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-credentials-manager.vala"
	_tmp11_ = _data5_->username;
#line 128 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-credentials-manager.vala"
	if (_tmp11_ == NULL) {
#line 128 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-credentials-manager.vala"
		_tmp10_ = TRUE;
#line 845 "gitg-credentials-manager.c"
	} else {
		gboolean _tmp12_ = FALSE;
		gboolean _tmp13_ = FALSE;
		const gchar* _tmp14_ = NULL;
		const gchar* _tmp15_ = NULL;
#line 128 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-credentials-manager.vala"
		_tmp14_ = _data5_->newusername;
#line 128 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-credentials-manager.vala"
		_tmp15_ = _data5_->username;
#line 128 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-credentials-manager.vala"
		if (g_strcmp0 (_tmp14_, _tmp15_) != 0) {
#line 857 "gitg-credentials-manager.c"
			GgitConfig* _tmp16_ = NULL;
#line 128 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-credentials-manager.vala"
			_tmp16_ = self->priv->d_config;
#line 128 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-credentials-manager.vala"
			_tmp13_ = _tmp16_ != NULL;
#line 863 "gitg-credentials-manager.c"
		} else {
#line 128 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-credentials-manager.vala"
			_tmp13_ = FALSE;
#line 867 "gitg-credentials-manager.c"
		}
#line 128 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-credentials-manager.vala"
		if (_tmp13_) {
#line 871 "gitg-credentials-manager.c"
			gboolean _tmp17_ = FALSE;
#line 128 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-credentials-manager.vala"
			_tmp17_ = self->priv->d_save_user_in_config;
#line 128 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-credentials-manager.vala"
			_tmp12_ = _tmp17_;
#line 877 "gitg-credentials-manager.c"
		} else {
#line 128 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-credentials-manager.vala"
			_tmp12_ = FALSE;
#line 881 "gitg-credentials-manager.c"
		}
#line 128 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-credentials-manager.vala"
		_tmp10_ = _tmp12_;
#line 885 "gitg-credentials-manager.c"
	}
#line 128 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-credentials-manager.vala"
	if (_tmp10_) {
#line 889 "gitg-credentials-manager.c"
		GeeHashMap* _tmp18_ = NULL;
#line 130 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-credentials-manager.vala"
		_tmp18_ = self->priv->d_usermap;
#line 130 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-credentials-manager.vala"
		if (_tmp18_ == NULL) {
#line 895 "gitg-credentials-manager.c"
			GeeHashMap* _tmp19_ = NULL;
#line 132 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-credentials-manager.vala"
			_tmp19_ = gee_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
#line 132 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-credentials-manager.vala"
			_g_object_unref0 (self->priv->d_usermap);
#line 132 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-credentials-manager.vala"
			self->priv->d_usermap = _tmp19_;
#line 903 "gitg-credentials-manager.c"
		}
		{
			gchar* hid = NULL;
			const gchar* _tmp20_ = NULL;
			const gchar* _tmp21_ = NULL;
			const gchar* _tmp22_ = NULL;
			const gchar* _tmp23_ = NULL;
			gchar* _tmp24_ = NULL;
			GgitConfig* _tmp25_ = NULL;
			const gchar* _tmp26_ = NULL;
			const gchar* _tmp27_ = NULL;
			gchar* _tmp28_ = NULL;
			gchar* _tmp29_ = NULL;
			const gchar* _tmp30_ = NULL;
			GeeHashMap* _tmp31_ = NULL;
			const gchar* _tmp32_ = NULL;
			const gchar* _tmp33_ = NULL;
#line 137 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-credentials-manager.vala"
			_tmp20_ = scheme;
#line 137 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-credentials-manager.vala"
			_tmp21_ = string_to_string (_tmp20_);
#line 137 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-credentials-manager.vala"
			_tmp22_ = host;
#line 137 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-credentials-manager.vala"
			_tmp23_ = string_to_string (_tmp22_);
#line 137 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-credentials-manager.vala"
			_tmp24_ = g_strconcat (_tmp21_, "://", _tmp23_, NULL);
#line 137 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-credentials-manager.vala"
			hid = _tmp24_;
#line 139 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-credentials-manager.vala"
			_tmp25_ = self->priv->d_config;
#line 139 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-credentials-manager.vala"
			_tmp26_ = hid;
#line 139 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-credentials-manager.vala"
			_tmp27_ = string_to_string (_tmp26_);
#line 139 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-credentials-manager.vala"
			_tmp28_ = g_strconcat ("credential.", _tmp27_, ".username", NULL);
#line 139 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-credentials-manager.vala"
			_tmp29_ = _tmp28_;
#line 139 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-credentials-manager.vala"
			_tmp30_ = _data5_->newusername;
#line 139 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-credentials-manager.vala"
			ggit_config_set_string (_tmp25_, _tmp29_, _tmp30_, &_inner_error_);
#line 139 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-credentials-manager.vala"
			_g_free0 (_tmp29_);
#line 139 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-credentials-manager.vala"
			if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 139 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-credentials-manager.vala"
				_g_free0 (hid);
#line 953 "gitg-credentials-manager.c"
				goto __catch25_g_error;
			}
#line 140 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-credentials-manager.vala"
			_tmp31_ = self->priv->d_usermap;
#line 140 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-credentials-manager.vala"
			_tmp32_ = hid;
#line 140 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-credentials-manager.vala"
			_tmp33_ = _data5_->newusername;
#line 140 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-credentials-manager.vala"
			gee_abstract_map_set ((GeeAbstractMap*) _tmp31_, _tmp32_, _tmp33_);
#line 135 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-credentials-manager.vala"
			_g_free0 (hid);
#line 966 "gitg-credentials-manager.c"
		}
		goto __finally25;
		__catch25_g_error:
		{
			GError* e = NULL;
			FILE* _tmp34_ = NULL;
			GError* _tmp35_ = NULL;
			const gchar* _tmp36_ = NULL;
#line 135 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-credentials-manager.vala"
			e = _inner_error_;
#line 135 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-credentials-manager.vala"
			_inner_error_ = NULL;
#line 144 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-credentials-manager.vala"
			_tmp34_ = stderr;
#line 144 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-credentials-manager.vala"
			_tmp35_ = e;
#line 144 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-credentials-manager.vala"
			_tmp36_ = _tmp35_->message;
#line 144 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-credentials-manager.vala"
			fprintf (_tmp34_, "Failed to store username in config: %s\n", _tmp36_);
#line 135 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-credentials-manager.vala"
			_g_error_free0 (e);
#line 989 "gitg-credentials-manager.c"
		}
		__finally25:
#line 135 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-credentials-manager.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 135 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-credentials-manager.vala"
			g_propagate_error (error, _inner_error_);
#line 135 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-credentials-manager.vala"
			block5_data_unref (_data5_);
#line 135 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-credentials-manager.vala"
			_data5_ = NULL;
#line 135 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-credentials-manager.vala"
			return NULL;
#line 1002 "gitg-credentials-manager.c"
		}
	}
#line 148 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-credentials-manager.vala"
	_tmp37_ = g_str_hash;
#line 148 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-credentials-manager.vala"
	_tmp38_ = g_str_equal;
#line 148 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-credentials-manager.vala"
	_tmp39_ = g_hash_table_new_full (_tmp37_, _tmp38_, _g_free0_, _g_free0_);
#line 148 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-credentials-manager.vala"
	attributes = _tmp39_;
#line 149 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-credentials-manager.vala"
	_tmp40_ = attributes;
#line 149 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-credentials-manager.vala"
	_tmp41_ = g_strdup ("scheme");
#line 149 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-credentials-manager.vala"
	_tmp42_ = scheme;
#line 149 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-credentials-manager.vala"
	_tmp43_ = g_strdup (_tmp42_);
#line 149 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-credentials-manager.vala"
	g_hash_table_insert (_tmp40_, _tmp41_, _tmp43_);
#line 150 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-credentials-manager.vala"
	_tmp44_ = attributes;
#line 150 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-credentials-manager.vala"
	_tmp45_ = g_strdup ("host");
#line 150 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-credentials-manager.vala"
	_tmp46_ = host;
#line 150 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-credentials-manager.vala"
	_tmp47_ = g_strdup (_tmp46_);
#line 150 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-credentials-manager.vala"
	g_hash_table_insert (_tmp44_, _tmp45_, _tmp47_);
#line 151 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-credentials-manager.vala"
	_tmp48_ = attributes;
#line 151 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-credentials-manager.vala"
	_tmp49_ = g_strdup ("user");
#line 151 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-credentials-manager.vala"
	_tmp50_ = _data5_->newusername;
#line 151 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-credentials-manager.vala"
	_tmp51_ = g_strdup (_tmp50_);
#line 151 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-credentials-manager.vala"
	g_hash_table_insert (_tmp48_, _tmp49_, _tmp51_);
#line 154 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-credentials-manager.vala"
	_tmp52_ = _data5_->lifetime;
#line 154 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-credentials-manager.vala"
	if (_tmp52_ != GITG_AUTHENTICATION_LIFE_TIME_FORGET) {
#line 1047 "gitg-credentials-manager.c"
		gchar* collection = NULL;
		GitgAuthenticationLifeTime _tmp53_ = 0;
		SecretSchema* _tmp55_ = NULL;
		GHashTable* _tmp56_ = NULL;
		const gchar* _tmp57_ = NULL;
		const gchar* _tmp58_ = NULL;
		const gchar* _tmp59_ = NULL;
		const gchar* _tmp60_ = NULL;
		const gchar* _tmp61_ = NULL;
		gchar* _tmp62_ = NULL;
		gchar* _tmp63_ = NULL;
		const gchar* _tmp64_ = NULL;
#line 156 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-credentials-manager.vala"
		collection = NULL;
#line 158 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-credentials-manager.vala"
		_tmp53_ = _data5_->lifetime;
#line 158 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-credentials-manager.vala"
		if (_tmp53_ == GITG_AUTHENTICATION_LIFE_TIME_SESSION) {
#line 1066 "gitg-credentials-manager.c"
			gchar* _tmp54_ = NULL;
#line 160 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-credentials-manager.vala"
			_tmp54_ = g_strdup (SECRET_COLLECTION_SESSION);
#line 160 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-credentials-manager.vala"
			_g_free0 (collection);
#line 160 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-credentials-manager.vala"
			collection = _tmp54_;
#line 1074 "gitg-credentials-manager.c"
		}
#line 163 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-credentials-manager.vala"
		_tmp55_ = gitg_credentials_manager_s_secret_schema;
#line 163 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-credentials-manager.vala"
		_tmp56_ = attributes;
#line 163 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-credentials-manager.vala"
		_tmp57_ = collection;
#line 163 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-credentials-manager.vala"
		_tmp58_ = scheme;
#line 163 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-credentials-manager.vala"
		_tmp59_ = string_to_string (_tmp58_);
#line 163 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-credentials-manager.vala"
		_tmp60_ = host;
#line 163 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-credentials-manager.vala"
		_tmp61_ = string_to_string (_tmp60_);
#line 163 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-credentials-manager.vala"
		_tmp62_ = g_strconcat (_tmp59_, "://", _tmp61_, NULL);
#line 163 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-credentials-manager.vala"
		_tmp63_ = _tmp62_;
#line 163 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-credentials-manager.vala"
		_tmp64_ = _data5_->password;
#line 163 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-credentials-manager.vala"
		secret_password_storev (_tmp55_, _tmp56_, _tmp57_, _tmp63_, _tmp64_, NULL, ____lambda41__gasync_ready_callback, gitg_credentials_manager_ref (self));
#line 163 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-credentials-manager.vala"
		_g_free0 (_tmp63_);
#line 154 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-credentials-manager.vala"
		_g_free0 (collection);
#line 1102 "gitg-credentials-manager.c"
	} else {
		SecretSchema* _tmp65_ = NULL;
		GHashTable* _tmp66_ = NULL;
#line 182 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-credentials-manager.vala"
		_tmp65_ = gitg_credentials_manager_s_secret_schema;
#line 182 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-credentials-manager.vala"
		_tmp66_ = attributes;
#line 182 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-credentials-manager.vala"
		secret_password_clearv (_tmp65_, _tmp66_, NULL, ____lambda42__gasync_ready_callback, gitg_credentials_manager_ref (self));
#line 1112 "gitg-credentials-manager.c"
	}
#line 194 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-credentials-manager.vala"
	_tmp67_ = self->priv->d_auth_tried;
#line 194 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-credentials-manager.vala"
	_tmp68_ = _data5_->newusername;
#line 194 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-credentials-manager.vala"
	gee_abstract_map_set ((GeeAbstractMap*) _tmp67_, _tmp68_, (gpointer) ((gintptr) GGIT_CREDTYPE_USERPASS_PLAINTEXT));
#line 195 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-credentials-manager.vala"
	_tmp70_ = _data5_->newusername;
#line 195 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-credentials-manager.vala"
	_tmp71_ = _data5_->password;
#line 195 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-credentials-manager.vala"
	_tmp72_ = ggit_cred_plaintext_new (_tmp70_, _tmp71_, &_inner_error_);
#line 195 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-credentials-manager.vala"
	_tmp69_ = _tmp72_;
#line 195 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-credentials-manager.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 195 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-credentials-manager.vala"
		g_propagate_error (error, _inner_error_);
#line 195 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-credentials-manager.vala"
		_g_hash_table_unref0 (attributes);
#line 195 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-credentials-manager.vala"
		block5_data_unref (_data5_);
#line 195 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-credentials-manager.vala"
		_data5_ = NULL;
#line 195 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-credentials-manager.vala"
		return NULL;
#line 1140 "gitg-credentials-manager.c"
	}
#line 195 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-credentials-manager.vala"
	_tmp73_ = _tmp69_;
#line 195 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-credentials-manager.vala"
	_tmp69_ = NULL;
#line 195 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-credentials-manager.vala"
	result = (GgitCred*) _tmp73_;
#line 195 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-credentials-manager.vala"
	_g_object_unref0 (_tmp69_);
#line 195 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-credentials-manager.vala"
	_g_hash_table_unref0 (attributes);
#line 195 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-credentials-manager.vala"
	block5_data_unref (_data5_);
#line 195 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-credentials-manager.vala"
	_data5_ = NULL;
#line 195 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-credentials-manager.vala"
	return result;
#line 1158 "gitg-credentials-manager.c"
}


static void _vala_SoupURI_free (SoupURI* self) {
#line 230 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-credentials-manager.vala"
	g_boxed_free (soup_uri_get_type (), self);
#line 1165 "gitg-credentials-manager.c"
}


static GgitCred* gitg_credentials_manager_query_user_pass (GitgCredentialsManager* self, const gchar* url, const gchar* username, GError** error) {
	GgitCred* result = NULL;
	gchar* user = NULL;
	SoupURI* uri = NULL;
	const gchar* _tmp0_ = NULL;
	SoupURI* _tmp1_ = NULL;
	gchar* host = NULL;
	SoupURI* _tmp2_ = NULL;
	const gchar* _tmp3_ = NULL;
	gchar* _tmp4_ = NULL;
	SoupURI* _tmp5_ = NULL;
	gboolean _tmp6_ = FALSE;
	gchar* scheme = NULL;
	SoupURI* _tmp14_ = NULL;
	const gchar* _tmp15_ = NULL;
	gchar* _tmp16_ = NULL;
	const gchar* _tmp17_ = NULL;
	const gchar* _tmp27_ = NULL;
	GError * _inner_error_ = NULL;
#line 198 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-credentials-manager.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 198 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-credentials-manager.vala"
	g_return_val_if_fail (url != NULL, NULL);
#line 202 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-credentials-manager.vala"
	_tmp0_ = url;
#line 202 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-credentials-manager.vala"
	_tmp1_ = soup_uri_new (_tmp0_);
#line 202 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-credentials-manager.vala"
	uri = _tmp1_;
#line 203 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-credentials-manager.vala"
	_tmp2_ = uri;
#line 203 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-credentials-manager.vala"
	_tmp3_ = soup_uri_get_host (_tmp2_);
#line 203 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-credentials-manager.vala"
	_tmp4_ = g_strdup (_tmp3_);
#line 203 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-credentials-manager.vala"
	host = _tmp4_;
#line 205 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-credentials-manager.vala"
	_tmp5_ = uri;
#line 205 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-credentials-manager.vala"
	_tmp6_ = soup_uri_uses_default_port (_tmp5_);
#line 205 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-credentials-manager.vala"
	if (!_tmp6_) {
#line 1212 "gitg-credentials-manager.c"
		const gchar* _tmp7_ = NULL;
		const gchar* _tmp8_ = NULL;
		SoupURI* _tmp9_ = NULL;
		guint _tmp10_ = 0U;
		gchar* _tmp11_ = NULL;
		gchar* _tmp12_ = NULL;
		gchar* _tmp13_ = NULL;
#line 207 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-credentials-manager.vala"
		_tmp7_ = host;
#line 207 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-credentials-manager.vala"
		_tmp8_ = string_to_string (_tmp7_);
#line 207 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-credentials-manager.vala"
		_tmp9_ = uri;
#line 207 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-credentials-manager.vala"
		_tmp10_ = soup_uri_get_port (_tmp9_);
#line 207 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-credentials-manager.vala"
		_tmp11_ = g_strdup_printf ("%u", _tmp10_);
#line 207 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-credentials-manager.vala"
		_tmp12_ = _tmp11_;
#line 207 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-credentials-manager.vala"
		_tmp13_ = g_strconcat (_tmp8_, ":", _tmp12_, NULL);
#line 207 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-credentials-manager.vala"
		_g_free0 (host);
#line 207 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-credentials-manager.vala"
		host = _tmp13_;
#line 207 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-credentials-manager.vala"
		_g_free0 (_tmp12_);
#line 1240 "gitg-credentials-manager.c"
	}
#line 210 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-credentials-manager.vala"
	_tmp14_ = uri;
#line 210 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-credentials-manager.vala"
	_tmp15_ = soup_uri_get_scheme (_tmp14_);
#line 210 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-credentials-manager.vala"
	_tmp16_ = g_strdup (_tmp15_);
#line 210 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-credentials-manager.vala"
	scheme = _tmp16_;
#line 212 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-credentials-manager.vala"
	_tmp17_ = username;
#line 212 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-credentials-manager.vala"
	if (_tmp17_ == NULL) {
#line 1254 "gitg-credentials-manager.c"
		const gchar* _tmp18_ = NULL;
		const gchar* _tmp19_ = NULL;
		const gchar* _tmp20_ = NULL;
		const gchar* _tmp21_ = NULL;
		gchar* _tmp22_ = NULL;
		gchar* _tmp23_ = NULL;
		gchar* _tmp24_ = NULL;
#line 215 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-credentials-manager.vala"
		_tmp18_ = scheme;
#line 215 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-credentials-manager.vala"
		_tmp19_ = string_to_string (_tmp18_);
#line 215 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-credentials-manager.vala"
		_tmp20_ = host;
#line 215 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-credentials-manager.vala"
		_tmp21_ = string_to_string (_tmp20_);
#line 215 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-credentials-manager.vala"
		_tmp22_ = g_strconcat (_tmp19_, "://", _tmp21_, NULL);
#line 215 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-credentials-manager.vala"
		_tmp23_ = _tmp22_;
#line 215 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-credentials-manager.vala"
		_tmp24_ = gitg_credentials_manager_lookup_user (self, _tmp23_);
#line 215 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-credentials-manager.vala"
		_g_free0 (user);
#line 215 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-credentials-manager.vala"
		user = _tmp24_;
#line 215 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-credentials-manager.vala"
		_g_free0 (_tmp23_);
#line 1282 "gitg-credentials-manager.c"
	} else {
		const gchar* _tmp25_ = NULL;
		gchar* _tmp26_ = NULL;
#line 219 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-credentials-manager.vala"
		_tmp25_ = username;
#line 219 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-credentials-manager.vala"
		_tmp26_ = g_strdup (_tmp25_);
#line 219 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-credentials-manager.vala"
		_g_free0 (user);
#line 219 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-credentials-manager.vala"
		user = _tmp26_;
#line 1294 "gitg-credentials-manager.c"
	}
#line 222 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-credentials-manager.vala"
	_tmp27_ = user;
#line 222 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-credentials-manager.vala"
	if (_tmp27_ != NULL) {
#line 1300 "gitg-credentials-manager.c"
		GgitCredtype tried = 0;
		GeeHashMap* _tmp28_ = NULL;
		const gchar* _tmp29_ = NULL;
		gpointer _tmp30_ = NULL;
		GgitCredtype _tmp31_ = 0;
#line 224 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-credentials-manager.vala"
		_tmp28_ = self->priv->d_auth_tried;
#line 224 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-credentials-manager.vala"
		_tmp29_ = user;
#line 224 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-credentials-manager.vala"
		_tmp30_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp28_, _tmp29_);
#line 224 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-credentials-manager.vala"
		tried = (GgitCredtype) ((gintptr) _tmp30_);
#line 226 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-credentials-manager.vala"
		_tmp31_ = tried;
#line 226 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-credentials-manager.vala"
		if ((_tmp31_ & GGIT_CREDTYPE_USERPASS_PLAINTEXT) == 0) {
#line 1318 "gitg-credentials-manager.c"
			gchar* secret = NULL;
			const gchar* _tmp39_ = NULL;
			GeeHashMap* _tmp47_ = NULL;
			const gchar* _tmp48_ = NULL;
#line 228 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-credentials-manager.vala"
			secret = NULL;
#line 1325 "gitg-credentials-manager.c"
			{
				gchar* _tmp32_ = NULL;
				SecretSchema* _tmp33_ = NULL;
				const gchar* _tmp34_ = NULL;
				const gchar* _tmp35_ = NULL;
				const gchar* _tmp36_ = NULL;
				gchar* _tmp37_ = NULL;
				gchar* _tmp38_ = NULL;
#line 232 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-credentials-manager.vala"
				_tmp33_ = gitg_credentials_manager_s_secret_schema;
#line 232 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-credentials-manager.vala"
				_tmp34_ = scheme;
#line 232 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-credentials-manager.vala"
				_tmp35_ = host;
#line 232 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-credentials-manager.vala"
				_tmp36_ = user;
#line 232 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-credentials-manager.vala"
				_tmp37_ = secret_password_lookup_sync (_tmp33_, NULL, &_inner_error_, "scheme", _tmp34_, "host", _tmp35_, "user", _tmp36_, NULL);
#line 232 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-credentials-manager.vala"
				_tmp32_ = _tmp37_;
#line 232 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-credentials-manager.vala"
				if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1348 "gitg-credentials-manager.c"
					goto __catch28_g_error;
				}
#line 232 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-credentials-manager.vala"
				_tmp38_ = _tmp32_;
#line 232 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-credentials-manager.vala"
				_tmp32_ = NULL;
#line 232 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-credentials-manager.vala"
				_g_free0 (secret);
#line 232 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-credentials-manager.vala"
				secret = _tmp38_;
#line 230 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-credentials-manager.vala"
				_g_free0 (_tmp32_);
#line 1361 "gitg-credentials-manager.c"
			}
			goto __finally28;
			__catch28_g_error:
			{
#line 230 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-credentials-manager.vala"
				g_clear_error (&_inner_error_);
#line 230 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-credentials-manager.vala"
				_inner_error_ = NULL;
#line 1370 "gitg-credentials-manager.c"
			}
			__finally28:
#line 230 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-credentials-manager.vala"
			if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 230 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-credentials-manager.vala"
				g_propagate_error (error, _inner_error_);
#line 230 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-credentials-manager.vala"
				_g_free0 (secret);
#line 230 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-credentials-manager.vala"
				_g_free0 (scheme);
#line 230 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-credentials-manager.vala"
				_g_free0 (host);
#line 230 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-credentials-manager.vala"
				__vala_SoupURI_free0 (uri);
#line 230 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-credentials-manager.vala"
				_g_free0 (user);
#line 230 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-credentials-manager.vala"
				return NULL;
#line 1389 "gitg-credentials-manager.c"
			}
#line 239 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-credentials-manager.vala"
			_tmp39_ = secret;
#line 239 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-credentials-manager.vala"
			if (_tmp39_ == NULL) {
#line 1395 "gitg-credentials-manager.c"
				GgitCred* _tmp40_ = NULL;
				const gchar* _tmp41_ = NULL;
				const gchar* _tmp42_ = NULL;
				const gchar* _tmp43_ = NULL;
				const gchar* _tmp44_ = NULL;
				GgitCred* _tmp45_ = NULL;
				GgitCred* _tmp46_ = NULL;
#line 241 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-credentials-manager.vala"
				_tmp41_ = url;
#line 241 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-credentials-manager.vala"
				_tmp42_ = scheme;
#line 241 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-credentials-manager.vala"
				_tmp43_ = host;
#line 241 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-credentials-manager.vala"
				_tmp44_ = user;
#line 241 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-credentials-manager.vala"
				_tmp45_ = gitg_credentials_manager_user_pass_dialog (self, _tmp41_, _tmp42_, _tmp43_, _tmp44_, &_inner_error_);
#line 241 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-credentials-manager.vala"
				_tmp40_ = _tmp45_;
#line 241 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-credentials-manager.vala"
				if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 241 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-credentials-manager.vala"
					g_propagate_error (error, _inner_error_);
#line 241 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-credentials-manager.vala"
					_g_free0 (secret);
#line 241 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-credentials-manager.vala"
					_g_free0 (scheme);
#line 241 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-credentials-manager.vala"
					_g_free0 (host);
#line 241 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-credentials-manager.vala"
					__vala_SoupURI_free0 (uri);
#line 241 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-credentials-manager.vala"
					_g_free0 (user);
#line 241 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-credentials-manager.vala"
					return NULL;
#line 1431 "gitg-credentials-manager.c"
				}
#line 241 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-credentials-manager.vala"
				_tmp46_ = _tmp40_;
#line 241 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-credentials-manager.vala"
				_tmp40_ = NULL;
#line 241 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-credentials-manager.vala"
				result = _tmp46_;
#line 241 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-credentials-manager.vala"
				_g_object_unref0 (_tmp40_);
#line 241 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-credentials-manager.vala"
				_g_free0 (secret);
#line 241 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-credentials-manager.vala"
				_g_free0 (scheme);
#line 241 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-credentials-manager.vala"
				_g_free0 (host);
#line 241 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-credentials-manager.vala"
				__vala_SoupURI_free0 (uri);
#line 241 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-credentials-manager.vala"
				_g_free0 (user);
#line 241 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-credentials-manager.vala"
				return result;
#line 1453 "gitg-credentials-manager.c"
			}
#line 244 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-credentials-manager.vala"
			_tmp47_ = self->priv->d_auth_tried;
#line 244 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-credentials-manager.vala"
			_tmp48_ = user;
#line 244 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-credentials-manager.vala"
			gee_abstract_map_set ((GeeAbstractMap*) _tmp47_, _tmp48_, (gpointer) ((gintptr) GGIT_CREDTYPE_USERPASS_PLAINTEXT));
#line 1461 "gitg-credentials-manager.c"
			{
				GgitCredPlaintext* _tmp49_ = NULL;
				const gchar* _tmp50_ = NULL;
				const gchar* _tmp51_ = NULL;
				GgitCredPlaintext* _tmp52_ = NULL;
				GgitCredPlaintext* _tmp53_ = NULL;
#line 248 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-credentials-manager.vala"
				_tmp50_ = user;
#line 248 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-credentials-manager.vala"
				_tmp51_ = secret;
#line 248 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-credentials-manager.vala"
				_tmp52_ = ggit_cred_plaintext_new (_tmp50_, _tmp51_, &_inner_error_);
#line 248 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-credentials-manager.vala"
				_tmp49_ = _tmp52_;
#line 248 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-credentials-manager.vala"
				if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1478 "gitg-credentials-manager.c"
					goto __catch29_g_error;
				}
#line 248 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-credentials-manager.vala"
				_tmp53_ = _tmp49_;
#line 248 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-credentials-manager.vala"
				_tmp49_ = NULL;
#line 248 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-credentials-manager.vala"
				result = (GgitCred*) _tmp53_;
#line 248 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-credentials-manager.vala"
				_g_object_unref0 (_tmp49_);
#line 248 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-credentials-manager.vala"
				_g_free0 (secret);
#line 248 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-credentials-manager.vala"
				_g_free0 (scheme);
#line 248 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-credentials-manager.vala"
				_g_free0 (host);
#line 248 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-credentials-manager.vala"
				__vala_SoupURI_free0 (uri);
#line 248 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-credentials-manager.vala"
				_g_free0 (user);
#line 248 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-credentials-manager.vala"
				return result;
#line 1501 "gitg-credentials-manager.c"
			}
			goto __finally29;
			__catch29_g_error:
			{
				GError* e = NULL;
				GgitCred* _tmp54_ = NULL;
				const gchar* _tmp55_ = NULL;
				const gchar* _tmp56_ = NULL;
				const gchar* _tmp57_ = NULL;
				const gchar* _tmp58_ = NULL;
				GgitCred* _tmp59_ = NULL;
				GgitCred* _tmp60_ = NULL;
#line 246 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-credentials-manager.vala"
				e = _inner_error_;
#line 246 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-credentials-manager.vala"
				_inner_error_ = NULL;
#line 252 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-credentials-manager.vala"
				_tmp55_ = url;
#line 252 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-credentials-manager.vala"
				_tmp56_ = scheme;
#line 252 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-credentials-manager.vala"
				_tmp57_ = host;
#line 252 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-credentials-manager.vala"
				_tmp58_ = user;
#line 252 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-credentials-manager.vala"
				_tmp59_ = gitg_credentials_manager_user_pass_dialog (self, _tmp55_, _tmp56_, _tmp57_, _tmp58_, &_inner_error_);
#line 252 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-credentials-manager.vala"
				_tmp54_ = _tmp59_;
#line 252 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-credentials-manager.vala"
				if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 252 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-credentials-manager.vala"
					_g_error_free0 (e);
#line 1534 "gitg-credentials-manager.c"
					goto __finally29;
				}
#line 252 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-credentials-manager.vala"
				_tmp60_ = _tmp54_;
#line 252 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-credentials-manager.vala"
				_tmp54_ = NULL;
#line 252 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-credentials-manager.vala"
				result = _tmp60_;
#line 252 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-credentials-manager.vala"
				_g_object_unref0 (_tmp54_);
#line 252 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-credentials-manager.vala"
				_g_error_free0 (e);
#line 252 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-credentials-manager.vala"
				_g_free0 (secret);
#line 252 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-credentials-manager.vala"
				_g_free0 (scheme);
#line 252 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-credentials-manager.vala"
				_g_free0 (host);
#line 252 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-credentials-manager.vala"
				__vala_SoupURI_free0 (uri);
#line 252 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-credentials-manager.vala"
				_g_free0 (user);
#line 252 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-credentials-manager.vala"
				return result;
#line 1559 "gitg-credentials-manager.c"
			}
			__finally29:
#line 246 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-credentials-manager.vala"
			g_propagate_error (error, _inner_error_);
#line 246 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-credentials-manager.vala"
			_g_free0 (secret);
#line 246 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-credentials-manager.vala"
			_g_free0 (scheme);
#line 246 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-credentials-manager.vala"
			_g_free0 (host);
#line 246 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-credentials-manager.vala"
			__vala_SoupURI_free0 (uri);
#line 246 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-credentials-manager.vala"
			_g_free0 (user);
#line 246 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-credentials-manager.vala"
			return NULL;
#line 1576 "gitg-credentials-manager.c"
		} else {
			GgitCred* _tmp61_ = NULL;
			const gchar* _tmp62_ = NULL;
			const gchar* _tmp63_ = NULL;
			const gchar* _tmp64_ = NULL;
			const gchar* _tmp65_ = NULL;
			GgitCred* _tmp66_ = NULL;
			GgitCred* _tmp67_ = NULL;
#line 257 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-credentials-manager.vala"
			_tmp62_ = url;
#line 257 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-credentials-manager.vala"
			_tmp63_ = scheme;
#line 257 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-credentials-manager.vala"
			_tmp64_ = host;
#line 257 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-credentials-manager.vala"
			_tmp65_ = user;
#line 257 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-credentials-manager.vala"
			_tmp66_ = gitg_credentials_manager_user_pass_dialog (self, _tmp62_, _tmp63_, _tmp64_, _tmp65_, &_inner_error_);
#line 257 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-credentials-manager.vala"
			_tmp61_ = _tmp66_;
#line 257 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-credentials-manager.vala"
			if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 257 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-credentials-manager.vala"
				g_propagate_error (error, _inner_error_);
#line 257 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-credentials-manager.vala"
				_g_free0 (scheme);
#line 257 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-credentials-manager.vala"
				_g_free0 (host);
#line 257 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-credentials-manager.vala"
				__vala_SoupURI_free0 (uri);
#line 257 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-credentials-manager.vala"
				_g_free0 (user);
#line 257 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-credentials-manager.vala"
				return NULL;
#line 1611 "gitg-credentials-manager.c"
			}
#line 257 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-credentials-manager.vala"
			_tmp67_ = _tmp61_;
#line 257 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-credentials-manager.vala"
			_tmp61_ = NULL;
#line 257 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-credentials-manager.vala"
			result = _tmp67_;
#line 257 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-credentials-manager.vala"
			_g_object_unref0 (_tmp61_);
#line 257 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-credentials-manager.vala"
			_g_free0 (scheme);
#line 257 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-credentials-manager.vala"
			_g_free0 (host);
#line 257 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-credentials-manager.vala"
			__vala_SoupURI_free0 (uri);
#line 257 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-credentials-manager.vala"
			_g_free0 (user);
#line 257 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-credentials-manager.vala"
			return result;
#line 1631 "gitg-credentials-manager.c"
		}
	} else {
		GgitCred* _tmp68_ = NULL;
		const gchar* _tmp69_ = NULL;
		const gchar* _tmp70_ = NULL;
		const gchar* _tmp71_ = NULL;
		const gchar* _tmp72_ = NULL;
		GgitCred* _tmp73_ = NULL;
		GgitCred* _tmp74_ = NULL;
#line 262 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-credentials-manager.vala"
		_tmp69_ = url;
#line 262 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-credentials-manager.vala"
		_tmp70_ = scheme;
#line 262 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-credentials-manager.vala"
		_tmp71_ = host;
#line 262 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-credentials-manager.vala"
		_tmp72_ = user;
#line 262 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-credentials-manager.vala"
		_tmp73_ = gitg_credentials_manager_user_pass_dialog (self, _tmp69_, _tmp70_, _tmp71_, _tmp72_, &_inner_error_);
#line 262 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-credentials-manager.vala"
		_tmp68_ = _tmp73_;
#line 262 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-credentials-manager.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 262 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-credentials-manager.vala"
			g_propagate_error (error, _inner_error_);
#line 262 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-credentials-manager.vala"
			_g_free0 (scheme);
#line 262 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-credentials-manager.vala"
			_g_free0 (host);
#line 262 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-credentials-manager.vala"
			__vala_SoupURI_free0 (uri);
#line 262 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-credentials-manager.vala"
			_g_free0 (user);
#line 262 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-credentials-manager.vala"
			return NULL;
#line 1667 "gitg-credentials-manager.c"
		}
#line 262 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-credentials-manager.vala"
		_tmp74_ = _tmp68_;
#line 262 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-credentials-manager.vala"
		_tmp68_ = NULL;
#line 262 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-credentials-manager.vala"
		result = _tmp74_;
#line 262 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-credentials-manager.vala"
		_g_object_unref0 (_tmp68_);
#line 262 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-credentials-manager.vala"
		_g_free0 (scheme);
#line 262 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-credentials-manager.vala"
		_g_free0 (host);
#line 262 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-credentials-manager.vala"
		__vala_SoupURI_free0 (uri);
#line 262 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-credentials-manager.vala"
		_g_free0 (user);
#line 262 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-credentials-manager.vala"
		return result;
#line 1687 "gitg-credentials-manager.c"
	}
#line 198 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-credentials-manager.vala"
	_g_free0 (scheme);
#line 198 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-credentials-manager.vala"
	_g_free0 (host);
#line 198 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-credentials-manager.vala"
	__vala_SoupURI_free0 (uri);
#line 198 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-credentials-manager.vala"
	_g_free0 (user);
#line 1697 "gitg-credentials-manager.c"
}


GgitCred* gitg_credentials_manager_credentials (GitgCredentialsManager* self, const gchar* url, const gchar* username, GgitCredtype allowed_types, GError** error) {
	GgitCred* result = NULL;
	const gchar* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	gchar* uslookup = NULL;
	gchar* _tmp3_ = NULL;
	GgitCredtype tried = 0;
	GeeHashMap* _tmp4_ = NULL;
	const gchar* _tmp5_ = NULL;
	gpointer _tmp6_ = NULL;
	GgitCredtype untried_allowed_types = 0;
	GgitCredtype _tmp7_ = 0;
	GgitCredtype _tmp8_ = 0;
	GgitCredtype _tmp9_ = 0;
	GError * _inner_error_ = NULL;
#line 266 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-credentials-manager.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 266 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-credentials-manager.vala"
	g_return_val_if_fail (url != NULL, NULL);
#line 270 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-credentials-manager.vala"
	_tmp1_ = username;
#line 270 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-credentials-manager.vala"
	if (_tmp1_ != NULL) {
#line 1724 "gitg-credentials-manager.c"
		const gchar* _tmp2_ = NULL;
#line 270 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-credentials-manager.vala"
		_tmp2_ = username;
#line 270 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-credentials-manager.vala"
		_tmp0_ = _tmp2_;
#line 1730 "gitg-credentials-manager.c"
	} else {
#line 270 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-credentials-manager.vala"
		_tmp0_ = "";
#line 1734 "gitg-credentials-manager.c"
	}
#line 270 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-credentials-manager.vala"
	_tmp3_ = g_strdup (_tmp0_);
#line 270 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-credentials-manager.vala"
	uslookup = _tmp3_;
#line 271 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-credentials-manager.vala"
	_tmp4_ = self->priv->d_auth_tried;
#line 271 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-credentials-manager.vala"
	_tmp5_ = uslookup;
#line 271 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-credentials-manager.vala"
	_tmp6_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp4_, _tmp5_);
#line 271 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-credentials-manager.vala"
	tried = (GgitCredtype) ((gintptr) _tmp6_);
#line 273 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-credentials-manager.vala"
	_tmp7_ = allowed_types;
#line 273 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-credentials-manager.vala"
	_tmp8_ = tried;
#line 273 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-credentials-manager.vala"
	untried_allowed_types = _tmp7_ & (~_tmp8_);
#line 275 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-credentials-manager.vala"
	_tmp9_ = untried_allowed_types;
#line 275 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-credentials-manager.vala"
	if ((_tmp9_ & GGIT_CREDTYPE_SSH_KEY) != 0) {
#line 1758 "gitg-credentials-manager.c"
		GeeHashMap* _tmp10_ = NULL;
		const gchar* _tmp11_ = NULL;
		GgitCredtype _tmp12_ = 0;
		GgitCredSshKeyFromAgent* _tmp13_ = NULL;
		const gchar* _tmp14_ = NULL;
		GgitCredSshKeyFromAgent* _tmp15_ = NULL;
		GgitCredSshKeyFromAgent* _tmp16_ = NULL;
#line 277 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-credentials-manager.vala"
		_tmp10_ = self->priv->d_auth_tried;
#line 277 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-credentials-manager.vala"
		_tmp11_ = uslookup;
#line 277 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-credentials-manager.vala"
		_tmp12_ = tried;
#line 277 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-credentials-manager.vala"
		gee_abstract_map_set ((GeeAbstractMap*) _tmp10_, _tmp11_, (gpointer) ((gintptr) (_tmp12_ | GGIT_CREDTYPE_SSH_KEY)));
#line 278 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-credentials-manager.vala"
		_tmp14_ = username;
#line 278 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-credentials-manager.vala"
		_tmp15_ = ggit_cred_ssh_key_from_agent_new (_tmp14_, &_inner_error_);
#line 278 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-credentials-manager.vala"
		_tmp13_ = _tmp15_;
#line 278 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-credentials-manager.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 278 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-credentials-manager.vala"
			g_propagate_error (error, _inner_error_);
#line 278 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-credentials-manager.vala"
			_g_free0 (uslookup);
#line 278 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-credentials-manager.vala"
			return NULL;
#line 1788 "gitg-credentials-manager.c"
		}
#line 278 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-credentials-manager.vala"
		_tmp16_ = _tmp13_;
#line 278 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-credentials-manager.vala"
		_tmp13_ = NULL;
#line 278 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-credentials-manager.vala"
		result = (GgitCred*) _tmp16_;
#line 278 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-credentials-manager.vala"
		_g_object_unref0 (_tmp13_);
#line 278 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-credentials-manager.vala"
		_g_free0 (uslookup);
#line 278 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-credentials-manager.vala"
		return result;
#line 1802 "gitg-credentials-manager.c"
	} else {
		GgitCredtype _tmp17_ = 0;
#line 280 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-credentials-manager.vala"
		_tmp17_ = allowed_types;
#line 280 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-credentials-manager.vala"
		if ((_tmp17_ & GGIT_CREDTYPE_USERPASS_PLAINTEXT) != 0) {
#line 1809 "gitg-credentials-manager.c"
			GgitCred* _tmp18_ = NULL;
			const gchar* _tmp19_ = NULL;
			const gchar* _tmp20_ = NULL;
			GgitCred* _tmp21_ = NULL;
			GgitCred* _tmp22_ = NULL;
#line 282 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-credentials-manager.vala"
			_tmp19_ = url;
#line 282 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-credentials-manager.vala"
			_tmp20_ = username;
#line 282 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-credentials-manager.vala"
			_tmp21_ = gitg_credentials_manager_query_user_pass (self, _tmp19_, _tmp20_, &_inner_error_);
#line 282 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-credentials-manager.vala"
			_tmp18_ = _tmp21_;
#line 282 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-credentials-manager.vala"
			if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 282 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-credentials-manager.vala"
				g_propagate_error (error, _inner_error_);
#line 282 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-credentials-manager.vala"
				_g_free0 (uslookup);
#line 282 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-credentials-manager.vala"
				return NULL;
#line 1831 "gitg-credentials-manager.c"
			}
#line 282 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-credentials-manager.vala"
			_tmp22_ = _tmp18_;
#line 282 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-credentials-manager.vala"
			_tmp18_ = NULL;
#line 282 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-credentials-manager.vala"
			result = _tmp22_;
#line 282 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-credentials-manager.vala"
			_g_object_unref0 (_tmp18_);
#line 282 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-credentials-manager.vala"
			_g_free0 (uslookup);
#line 282 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-credentials-manager.vala"
			return result;
#line 1845 "gitg-credentials-manager.c"
		}
	}
#line 285 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-credentials-manager.vala"
	result = NULL;
#line 285 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-credentials-manager.vala"
	_g_free0 (uslookup);
#line 285 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-credentials-manager.vala"
	return result;
#line 1854 "gitg-credentials-manager.c"
}


static void gitg_value_credentials_manager_init (GValue* value) {
#line 28 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-credentials-manager.vala"
	value->data[0].v_pointer = NULL;
#line 1861 "gitg-credentials-manager.c"
}


static void gitg_value_credentials_manager_free_value (GValue* value) {
#line 28 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-credentials-manager.vala"
	if (value->data[0].v_pointer) {
#line 28 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-credentials-manager.vala"
		gitg_credentials_manager_unref (value->data[0].v_pointer);
#line 1870 "gitg-credentials-manager.c"
	}
}


static void gitg_value_credentials_manager_copy_value (const GValue* src_value, GValue* dest_value) {
#line 28 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-credentials-manager.vala"
	if (src_value->data[0].v_pointer) {
#line 28 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-credentials-manager.vala"
		dest_value->data[0].v_pointer = gitg_credentials_manager_ref (src_value->data[0].v_pointer);
#line 1880 "gitg-credentials-manager.c"
	} else {
#line 28 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-credentials-manager.vala"
		dest_value->data[0].v_pointer = NULL;
#line 1884 "gitg-credentials-manager.c"
	}
}


static gpointer gitg_value_credentials_manager_peek_pointer (const GValue* value) {
#line 28 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-credentials-manager.vala"
	return value->data[0].v_pointer;
#line 1892 "gitg-credentials-manager.c"
}


static gchar* gitg_value_credentials_manager_collect_value (GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
#line 28 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-credentials-manager.vala"
	if (collect_values[0].v_pointer) {
#line 1899 "gitg-credentials-manager.c"
		GitgCredentialsManager* object;
		object = collect_values[0].v_pointer;
#line 28 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-credentials-manager.vala"
		if (object->parent_instance.g_class == NULL) {
#line 28 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-credentials-manager.vala"
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 1906 "gitg-credentials-manager.c"
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
#line 28 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-credentials-manager.vala"
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 1910 "gitg-credentials-manager.c"
		}
#line 28 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-credentials-manager.vala"
		value->data[0].v_pointer = gitg_credentials_manager_ref (object);
#line 1914 "gitg-credentials-manager.c"
	} else {
#line 28 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-credentials-manager.vala"
		value->data[0].v_pointer = NULL;
#line 1918 "gitg-credentials-manager.c"
	}
#line 28 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-credentials-manager.vala"
	return NULL;
#line 1922 "gitg-credentials-manager.c"
}


static gchar* gitg_value_credentials_manager_lcopy_value (const GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	GitgCredentialsManager** object_p;
	object_p = collect_values[0].v_pointer;
#line 28 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-credentials-manager.vala"
	if (!object_p) {
#line 28 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-credentials-manager.vala"
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
#line 1933 "gitg-credentials-manager.c"
	}
#line 28 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-credentials-manager.vala"
	if (!value->data[0].v_pointer) {
#line 28 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-credentials-manager.vala"
		*object_p = NULL;
#line 1939 "gitg-credentials-manager.c"
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
#line 28 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-credentials-manager.vala"
		*object_p = value->data[0].v_pointer;
#line 1943 "gitg-credentials-manager.c"
	} else {
#line 28 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-credentials-manager.vala"
		*object_p = gitg_credentials_manager_ref (value->data[0].v_pointer);
#line 1947 "gitg-credentials-manager.c"
	}
#line 28 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-credentials-manager.vala"
	return NULL;
#line 1951 "gitg-credentials-manager.c"
}


GParamSpec* gitg_param_spec_credentials_manager (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) {
	GitgParamSpecCredentialsManager* spec;
#line 28 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-credentials-manager.vala"
	g_return_val_if_fail (g_type_is_a (object_type, GITG_TYPE_CREDENTIALS_MANAGER), NULL);
#line 28 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-credentials-manager.vala"
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
#line 28 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-credentials-manager.vala"
	G_PARAM_SPEC (spec)->value_type = object_type;
#line 28 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-credentials-manager.vala"
	return G_PARAM_SPEC (spec);
#line 1965 "gitg-credentials-manager.c"
}


gpointer gitg_value_get_credentials_manager (const GValue* value) {
#line 28 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-credentials-manager.vala"
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, GITG_TYPE_CREDENTIALS_MANAGER), NULL);
#line 28 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-credentials-manager.vala"
	return value->data[0].v_pointer;
#line 1974 "gitg-credentials-manager.c"
}


void gitg_value_set_credentials_manager (GValue* value, gpointer v_object) {
	GitgCredentialsManager* old;
#line 28 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-credentials-manager.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, GITG_TYPE_CREDENTIALS_MANAGER));
#line 28 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-credentials-manager.vala"
	old = value->data[0].v_pointer;
#line 28 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-credentials-manager.vala"
	if (v_object) {
#line 28 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-credentials-manager.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, GITG_TYPE_CREDENTIALS_MANAGER));
#line 28 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-credentials-manager.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 28 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-credentials-manager.vala"
		value->data[0].v_pointer = v_object;
#line 28 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-credentials-manager.vala"
		gitg_credentials_manager_ref (value->data[0].v_pointer);
#line 1994 "gitg-credentials-manager.c"
	} else {
#line 28 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-credentials-manager.vala"
		value->data[0].v_pointer = NULL;
#line 1998 "gitg-credentials-manager.c"
	}
#line 28 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-credentials-manager.vala"
	if (old) {
#line 28 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-credentials-manager.vala"
		gitg_credentials_manager_unref (old);
#line 2004 "gitg-credentials-manager.c"
	}
}


void gitg_value_take_credentials_manager (GValue* value, gpointer v_object) {
	GitgCredentialsManager* old;
#line 28 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-credentials-manager.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, GITG_TYPE_CREDENTIALS_MANAGER));
#line 28 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-credentials-manager.vala"
	old = value->data[0].v_pointer;
#line 28 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-credentials-manager.vala"
	if (v_object) {
#line 28 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-credentials-manager.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, GITG_TYPE_CREDENTIALS_MANAGER));
#line 28 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-credentials-manager.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 28 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-credentials-manager.vala"
		value->data[0].v_pointer = v_object;
#line 2023 "gitg-credentials-manager.c"
	} else {
#line 28 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-credentials-manager.vala"
		value->data[0].v_pointer = NULL;
#line 2027 "gitg-credentials-manager.c"
	}
#line 28 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-credentials-manager.vala"
	if (old) {
#line 28 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-credentials-manager.vala"
		gitg_credentials_manager_unref (old);
#line 2033 "gitg-credentials-manager.c"
	}
}


static void gitg_credentials_manager_class_init (GitgCredentialsManagerClass * klass) {
	SecretSchema* _tmp0_ = NULL;
#line 28 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-credentials-manager.vala"
	gitg_credentials_manager_parent_class = g_type_class_peek_parent (klass);
#line 28 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-credentials-manager.vala"
	((GitgCredentialsManagerClass *) klass)->finalize = gitg_credentials_manager_finalize;
#line 28 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-credentials-manager.vala"
	g_type_class_add_private (klass, sizeof (GitgCredentialsManagerPrivate));
#line 40 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-credentials-manager.vala"
	_tmp0_ = secret_schema_new ("org.gnome.Gitg.Credentials", SECRET_SCHEMA_NONE, "scheme", SECRET_SCHEMA_ATTRIBUTE_STRING, "host", SECRET_SCHEMA_ATTRIBUTE_STRING, "user", SECRET_SCHEMA_ATTRIBUTE_STRING, NULL);
#line 40 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-credentials-manager.vala"
	_secret_schema_unref0 (gitg_credentials_manager_s_secret_schema);
#line 40 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-credentials-manager.vala"
	gitg_credentials_manager_s_secret_schema = _tmp0_;
#line 2052 "gitg-credentials-manager.c"
}


static void gitg_credentials_manager_instance_init (GitgCredentialsManager * self) {
#line 28 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-credentials-manager.vala"
	self->priv = GITG_CREDENTIALS_MANAGER_GET_PRIVATE (self);
#line 28 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-credentials-manager.vala"
	self->ref_count = 1;
#line 2061 "gitg-credentials-manager.c"
}


static void gitg_credentials_manager_finalize (GitgCredentialsManager* obj) {
	GitgCredentialsManager * self;
#line 28 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-credentials-manager.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GITG_TYPE_CREDENTIALS_MANAGER, GitgCredentialsManager);
#line 28 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-credentials-manager.vala"
	g_signal_handlers_destroy (self);
#line 30 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-credentials-manager.vala"
	_g_object_unref0 (self->priv->d_config);
#line 31 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-credentials-manager.vala"
	_g_object_unref0 (self->priv->d_window);
#line 32 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-credentials-manager.vala"
	_g_object_unref0 (self->priv->d_usermap);
#line 34 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-credentials-manager.vala"
	_g_free0 (self->priv->d_last_user);
#line 35 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-credentials-manager.vala"
	_g_object_unref0 (self->priv->d_auth_tried);
#line 2081 "gitg-credentials-manager.c"
}


GType gitg_credentials_manager_get_type (void) {
	static volatile gsize gitg_credentials_manager_type_id__volatile = 0;
	if (g_once_init_enter (&gitg_credentials_manager_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { gitg_value_credentials_manager_init, gitg_value_credentials_manager_free_value, gitg_value_credentials_manager_copy_value, gitg_value_credentials_manager_peek_pointer, "p", gitg_value_credentials_manager_collect_value, "p", gitg_value_credentials_manager_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (GitgCredentialsManagerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) gitg_credentials_manager_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GitgCredentialsManager), 0, (GInstanceInitFunc) gitg_credentials_manager_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType gitg_credentials_manager_type_id;
		gitg_credentials_manager_type_id = g_type_register_fundamental (g_type_fundamental_next (), "GitgCredentialsManager", &g_define_type_info, &g_define_type_fundamental_info, 0);
		g_once_init_leave (&gitg_credentials_manager_type_id__volatile, gitg_credentials_manager_type_id);
	}
	return gitg_credentials_manager_type_id__volatile;
}


gpointer gitg_credentials_manager_ref (gpointer instance) {
	GitgCredentialsManager* self;
	self = instance;
#line 28 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-credentials-manager.vala"
	g_atomic_int_inc (&self->ref_count);
#line 28 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-credentials-manager.vala"
	return instance;
#line 2106 "gitg-credentials-manager.c"
}


void gitg_credentials_manager_unref (gpointer instance) {
	GitgCredentialsManager* self;
	self = instance;
#line 28 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-credentials-manager.vala"
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
#line 28 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-credentials-manager.vala"
		GITG_CREDENTIALS_MANAGER_GET_CLASS (self)->finalize (self);
#line 28 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-credentials-manager.vala"
		g_type_free_instance ((GTypeInstance *) self);
#line 2119 "gitg-credentials-manager.c"
	}
}


static void _vala_clear_GMutex (GMutex * mutex) {
	GMutex zero_mutex = { 0 };
	if (memcmp (mutex, &zero_mutex, sizeof (GMutex))) {
		g_mutex_clear (mutex);
		memset (mutex, 0, sizeof (GMutex));
	}
}


static void _vala_clear_GRecMutex (GRecMutex * mutex) {
	GRecMutex zero_mutex = { 0 };
	if (memcmp (mutex, &zero_mutex, sizeof (GRecMutex))) {
		g_rec_mutex_clear (mutex);
		memset (mutex, 0, sizeof (GRecMutex));
	}
}


static void _vala_clear_GRWLock (GRWLock * mutex) {
	GRWLock zero_mutex = { 0 };
	if (memcmp (mutex, &zero_mutex, sizeof (GRWLock))) {
		g_rw_lock_clear (mutex);
		memset (mutex, 0, sizeof (GRWLock));
	}
}


static void _vala_clear_GCond (GCond * mutex) {
	GCond zero_mutex = { 0 };
	if (memcmp (mutex, &zero_mutex, sizeof (GCond))) {
		g_cond_clear (mutex);
		memset (mutex, 0, sizeof (GCond));
	}
}



