/* gitg-repository.c generated by valac 0.30.0.38-a55d, the Vala compiler
 * generated from gitg-repository.vala, do not modify */

/*
 * This file is part of gitg
 *
 * Copyright (C) 2012 - Jesse van den Kieboom
 *
 * gitg is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * gitg is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with gitg. If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib.h>
#include <glib-object.h>
#include <libgit2-glib/ggit.h>
#include <gio/gio.h>
#include <stdlib.h>
#include <string.h>
#include <gee.h>


#define GITG_TYPE_REPOSITORY (gitg_repository_get_type ())
#define GITG_REPOSITORY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GITG_TYPE_REPOSITORY, GitgRepository))
#define GITG_REPOSITORY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GITG_TYPE_REPOSITORY, GitgRepositoryClass))
#define GITG_IS_REPOSITORY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GITG_TYPE_REPOSITORY))
#define GITG_IS_REPOSITORY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GITG_TYPE_REPOSITORY))
#define GITG_REPOSITORY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GITG_TYPE_REPOSITORY, GitgRepositoryClass))

typedef struct _GitgRepository GitgRepository;
typedef struct _GitgRepositoryClass GitgRepositoryClass;
typedef struct _GitgRepositoryPrivate GitgRepositoryPrivate;

#define GITG_TYPE_REF (gitg_ref_get_type ())
#define GITG_REF(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GITG_TYPE_REF, GitgRef))
#define GITG_IS_REF(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GITG_TYPE_REF))
#define GITG_REF_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), GITG_TYPE_REF, GitgRefIface))

typedef struct _GitgRef GitgRef;
typedef struct _GitgRefIface GitgRefIface;

#define GITG_TYPE_PARSED_REF_NAME (gitg_parsed_ref_name_get_type ())
#define GITG_PARSED_REF_NAME(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GITG_TYPE_PARSED_REF_NAME, GitgParsedRefName))
#define GITG_PARSED_REF_NAME_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GITG_TYPE_PARSED_REF_NAME, GitgParsedRefNameClass))
#define GITG_IS_PARSED_REF_NAME(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GITG_TYPE_PARSED_REF_NAME))
#define GITG_IS_PARSED_REF_NAME_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GITG_TYPE_PARSED_REF_NAME))
#define GITG_PARSED_REF_NAME_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GITG_TYPE_PARSED_REF_NAME, GitgParsedRefNameClass))

typedef struct _GitgParsedRefName GitgParsedRefName;
typedef struct _GitgParsedRefNameClass GitgParsedRefNameClass;

#define GITG_TYPE_REF_STATE (gitg_ref_state_get_type ())

#define GITG_TYPE_STAGE (gitg_stage_get_type ())
#define GITG_STAGE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GITG_TYPE_STAGE, GitgStage))
#define GITG_STAGE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GITG_TYPE_STAGE, GitgStageClass))
#define GITG_IS_STAGE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GITG_TYPE_STAGE))
#define GITG_IS_STAGE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GITG_TYPE_STAGE))
#define GITG_STAGE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GITG_TYPE_STAGE, GitgStageClass))

typedef struct _GitgStage GitgStage;
typedef struct _GitgStageClass GitgStageClass;
#define _g_hash_table_unref0(var) ((var == NULL) ? NULL : (var = (g_hash_table_unref (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define __g_slist_free__g_object_unref0_0(var) ((var == NULL) ? NULL : (var = (_g_slist_free__g_object_unref0_ (var), NULL)))
#define __vala_GgitOId_free0(var) ((var == NULL) ? NULL : (var = (_vala_GgitOId_free (var), NULL)))

#define GITG_TYPE_BRANCH (gitg_branch_get_type ())
#define GITG_BRANCH(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GITG_TYPE_BRANCH, GitgBranch))
#define GITG_IS_BRANCH(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GITG_TYPE_BRANCH))
#define GITG_BRANCH_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), GITG_TYPE_BRANCH, GitgBranchIface))

typedef struct _GitgBranch GitgBranch;
typedef struct _GitgBranchIface GitgBranchIface;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_date_time_unref0(var) ((var == NULL) ? NULL : (var = (g_date_time_unref (var), NULL)))

struct _GitgRepository {
	GgitRepository parent_instance;
	GitgRepositoryPrivate * priv;
};

struct _GitgRepositoryClass {
	GgitRepositoryClass parent_class;
};

typedef enum  {
	GITG_REF_STATE_NONE,
	GITG_REF_STATE_SELECTED,
	GITG_REF_STATE_PRELIGHT
} GitgRefState;

struct _GitgRefIface {
	GTypeInterface parent_iface;
	GitgRepository* (*get_owner) (GitgRef* self);
	GitgParsedRefName* (*get_d_parsed_name) (GitgRef* self);
	void (*set_d_parsed_name) (GitgRef* self, GitgParsedRefName* value);
	GList* (*get_d_pushes) (GitgRef* self);
	void (*set_d_pushes) (GitgRef* self, GList* value);
	GitgRefState (*get_state) (GitgRef* self);
	void (*set_state) (GitgRef* self, GitgRefState value);
	gboolean (*get_working) (GitgRef* self);
	void (*set_working) (GitgRef* self, gboolean value);
};

struct _GitgRepositoryPrivate {
	GHashTable* d_refs;
	GitgStage* d_stage;
};

struct _GitgBranchIface {
	GTypeInterface parent_iface;
	GitgRef* (*get_upstream) (GitgBranch* self, GError** error);
};


static gpointer gitg_repository_parent_class = NULL;

GType gitg_repository_get_type (void) G_GNUC_CONST;
GType gitg_parsed_ref_name_get_type (void) G_GNUC_CONST;
GType gitg_ref_state_get_type (void) G_GNUC_CONST;
GType gitg_ref_get_type (void) G_GNUC_CONST;
GType gitg_stage_get_type (void) G_GNUC_CONST;
#define GITG_REPOSITORY_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), GITG_TYPE_REPOSITORY, GitgRepositoryPrivate))
enum  {
	GITG_REPOSITORY_DUMMY_PROPERTY,
	GITG_REPOSITORY_NAME,
	GITG_REPOSITORY_STAGE
};
GitgRepository* gitg_repository_new (GFile* location, GFile* workdir, GError** error);
GitgRepository* gitg_repository_construct (GType object_type, GFile* location, GFile* workdir, GError** error);
static void gitg_repository_ensure_refs_add (GitgRepository* self, GgitOId* id, GitgRef* r);
static GgitOId* _vala_GgitOId_copy (GgitOId* self);
static void _g_object_unref0_ (gpointer var);
static void _g_slist_free__g_object_unref0_ (GSList* self);
void gitg_repository_clear_refs_cache (GitgRepository* self);
static void gitg_repository_ensure_refs (GitgRepository* self);
static guint _ggit_oid_hash_ghash_func (gconstpointer key);
static gboolean _ggit_oid_equal_gequal_func (gconstpointer a, gconstpointer b);
static void _vala_GgitOId_free (GgitOId* self);
static void __vala_GgitOId_free0_ (gpointer var);
static void __g_slist_free__g_object_unref0_0_ (gpointer var);
static gint ___lambda29_ (GitgRepository* self, const gchar* name);
GitgRef* gitg_repository_lookup_reference (GitgRepository* self, const gchar* name, GError** error);
gpointer gitg_repository_lookup (GitgRepository* self, GType t_type, GBoxedCopyFunc t_dup_func, GDestroyNotify t_destroy_func, GgitOId* id, GError** error);
static gint ____lambda29__ggit_references_name_callback (const gchar* name, gpointer self);
GSList* gitg_repository_refs_for_id (GitgRepository* self, GgitOId* id);
GitgRef* gitg_repository_lookup_reference_dwim (GitgRepository* self, const gchar* short_name, GError** error);
GType gitg_branch_get_type (void) G_GNUC_CONST;
GitgBranch* gitg_repository_create_branch (GitgRepository* self, const gchar* name, GgitObject* obj, GgitCreateFlags flags, GError** error);
GitgRef* gitg_repository_create_reference (GitgRepository* self, const gchar* name, GgitOId* oid, const gchar* message, GError** error);
GitgRef* gitg_repository_create_symbolic_reference (GitgRepository* self, const gchar* name, const gchar* target, const gchar* message, GError** error);
GitgRef* gitg_repository_get_head (GitgRepository* self, GError** error);
GitgRepository* gitg_repository_init_repository (GFile* location, gboolean is_bare, GError** error);
GgitSignature* gitg_repository_get_signature_with_environment (GitgRepository* self, GeeMap* env, const gchar* envname, GError** error);
GDateTime* gitg_date_parse (const gchar* date, GError** error);
gchar* gitg_repository_get_name (GitgRepository* self);
GitgStage* gitg_repository_get_stage (GitgRepository* self);
GitgStage* gitg_stage_new (GitgRepository* repository);
GitgStage* gitg_stage_construct (GType object_type, GitgRepository* repository);
static void gitg_repository_finalize (GObject* obj);
static void _vala_gitg_repository_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);


GitgRepository* gitg_repository_construct (GType object_type, GFile* location, GFile* workdir, GError** error) {
	GitgRepository * self = NULL;
	GFile* _tmp0_ = NULL;
	GFile* _tmp1_ = NULL;
	GError * _inner_error_ = NULL;
#line 37 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository.vala"
	g_return_val_if_fail (location != NULL, NULL);
#line 39 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository.vala"
	_tmp0_ = location;
#line 39 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository.vala"
	_tmp1_ = workdir;
#line 39 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository.vala"
	self = (GitgRepository*) g_object_new (object_type, "location", _tmp0_, "workdir", _tmp1_, NULL);
#line 42 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository.vala"
	g_initable_init (G_TYPE_CHECK_INSTANCE_CAST (self, G_TYPE_INITABLE, GInitable), NULL, &_inner_error_);
#line 42 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 42 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository.vala"
		g_propagate_error (error, _inner_error_);
#line 42 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository.vala"
		_g_object_unref0 (self);
#line 42 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository.vala"
		return NULL;
#line 198 "gitg-repository.c"
	}
#line 37 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository.vala"
	return self;
#line 202 "gitg-repository.c"
}


GitgRepository* gitg_repository_new (GFile* location, GFile* workdir, GError** error) {
#line 37 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository.vala"
	return gitg_repository_construct (GITG_TYPE_REPOSITORY, location, workdir, error);
#line 209 "gitg-repository.c"
}


static gpointer _g_object_ref0 (gpointer self) {
#line 56 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository.vala"
	return self ? g_object_ref (self) : NULL;
#line 216 "gitg-repository.c"
}


static GgitOId* _vala_GgitOId_copy (GgitOId* self) {
#line 63 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository.vala"
	return g_boxed_copy (ggit_oid_get_type (), self);
#line 223 "gitg-repository.c"
}


static gpointer __vala_GgitOId_copy0 (gpointer self) {
#line 63 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository.vala"
	return self ? _vala_GgitOId_copy (self) : NULL;
#line 230 "gitg-repository.c"
}


static void _g_object_unref0_ (gpointer var) {
#line 54 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository.vala"
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
#line 237 "gitg-repository.c"
}


static void _g_slist_free__g_object_unref0_ (GSList* self) {
#line 54 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository.vala"
	g_slist_foreach (self, (GFunc) _g_object_unref0_, NULL);
#line 54 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository.vala"
	g_slist_free (self);
#line 246 "gitg-repository.c"
}


static void gitg_repository_ensure_refs_add (GitgRepository* self, GgitOId* id, GitgRef* r) {
	GgitOId* _tmp0_ = NULL;
	GSList* refs = NULL;
	GHashTable* _tmp1_ = NULL;
	GgitOId* _tmp2_ = NULL;
	gconstpointer _tmp3_ = NULL;
	gboolean _tmp4_ = FALSE;
#line 45 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository.vala"
	g_return_if_fail (self != NULL);
#line 45 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository.vala"
	g_return_if_fail (r != NULL);
#line 47 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository.vala"
	_tmp0_ = id;
#line 47 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository.vala"
	if (_tmp0_ == NULL) {
#line 49 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository.vala"
		return;
#line 267 "gitg-repository.c"
	}
#line 54 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository.vala"
	_tmp1_ = self->priv->d_refs;
#line 54 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository.vala"
	_tmp2_ = id;
#line 54 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository.vala"
	_tmp4_ = g_hash_table_lookup_extended (_tmp1_, _tmp2_, NULL, &_tmp3_);
#line 54 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository.vala"
	refs = _tmp3_;
#line 54 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository.vala"
	if (_tmp4_) {
#line 279 "gitg-repository.c"
		GitgRef* _tmp5_ = NULL;
		GitgRef* _tmp6_ = NULL;
#line 56 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository.vala"
		_tmp5_ = r;
#line 56 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository.vala"
		_tmp6_ = _g_object_ref0 (_tmp5_);
#line 56 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository.vala"
		refs = g_slist_append (refs, _tmp6_);
#line 288 "gitg-repository.c"
	} else {
		GSList* nrefs = NULL;
		GitgRef* _tmp7_ = NULL;
		GitgRef* _tmp8_ = NULL;
		GHashTable* _tmp9_ = NULL;
		GgitOId* _tmp10_ = NULL;
		GgitOId* _tmp11_ = NULL;
		GSList* _tmp12_ = NULL;
#line 60 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository.vala"
		nrefs = NULL;
#line 61 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository.vala"
		_tmp7_ = r;
#line 61 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository.vala"
		_tmp8_ = _g_object_ref0 (_tmp7_);
#line 61 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository.vala"
		nrefs = g_slist_append (nrefs, _tmp8_);
#line 63 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository.vala"
		_tmp9_ = self->priv->d_refs;
#line 63 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository.vala"
		_tmp10_ = id;
#line 63 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository.vala"
		_tmp11_ = __vala_GgitOId_copy0 (_tmp10_);
#line 63 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository.vala"
		_tmp12_ = nrefs;
#line 63 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository.vala"
		nrefs = NULL;
#line 63 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository.vala"
		g_hash_table_insert (_tmp9_, _tmp11_, _tmp12_);
#line 54 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository.vala"
		__g_slist_free__g_object_unref0_0 (nrefs);
#line 319 "gitg-repository.c"
	}
}


void gitg_repository_clear_refs_cache (GitgRepository* self) {
#line 67 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository.vala"
	g_return_if_fail (self != NULL);
#line 69 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository.vala"
	_g_hash_table_unref0 (self->priv->d_refs);
#line 69 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository.vala"
	self->priv->d_refs = NULL;
#line 331 "gitg-repository.c"
}


static guint _ggit_oid_hash_ghash_func (gconstpointer key) {
	guint result;
	result = ggit_oid_hash (key);
#line 79 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository.vala"
	return result;
#line 340 "gitg-repository.c"
}


static gboolean _ggit_oid_equal_gequal_func (gconstpointer a, gconstpointer b) {
	gboolean result;
	result = ggit_oid_equal (a, (GgitOId*) b);
#line 79 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository.vala"
	return result;
#line 349 "gitg-repository.c"
}


static void _vala_GgitOId_free (GgitOId* self) {
#line 79 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository.vala"
	g_boxed_free (ggit_oid_get_type (), self);
#line 356 "gitg-repository.c"
}


static void __vala_GgitOId_free0_ (gpointer var) {
#line 79 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository.vala"
	(var == NULL) ? NULL : (var = (_vala_GgitOId_free (var), NULL));
#line 363 "gitg-repository.c"
}


static void __g_slist_free__g_object_unref0_0_ (gpointer var) {
#line 79 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository.vala"
	(var == NULL) ? NULL : (var = (_g_slist_free__g_object_unref0_ (var), NULL));
#line 370 "gitg-repository.c"
}


static gint ___lambda29_ (GitgRepository* self, const gchar* name) {
	gint result = 0;
	GitgRef* r = NULL;
	GitgRef* _tmp4_ = NULL;
	GgitOId* id = NULL;
	GitgRef* _tmp5_ = NULL;
	GgitOId* _tmp6_ = NULL;
	GgitOId* _tmp7_ = NULL;
	GgitOId* _tmp8_ = NULL;
	GitgRef* _tmp9_ = NULL;
	GError * _inner_error_ = NULL;
#line 84 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository.vala"
	g_return_val_if_fail (name != NULL, 0);
#line 387 "gitg-repository.c"
	{
		GitgRef* _tmp0_ = NULL;
		const gchar* _tmp1_ = NULL;
		GitgRef* _tmp2_ = NULL;
		GitgRef* _tmp3_ = NULL;
#line 89 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository.vala"
		_tmp1_ = name;
#line 89 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository.vala"
		_tmp2_ = gitg_repository_lookup_reference (self, _tmp1_, &_inner_error_);
#line 89 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository.vala"
		_tmp0_ = _tmp2_;
#line 89 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 401 "gitg-repository.c"
			goto __catch53_g_error;
		}
#line 89 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository.vala"
		_tmp3_ = _tmp0_;
#line 89 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository.vala"
		_tmp0_ = NULL;
#line 89 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository.vala"
		_g_object_unref0 (r);
#line 89 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository.vala"
		r = _tmp3_;
#line 87 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository.vala"
		_g_object_unref0 (_tmp0_);
#line 414 "gitg-repository.c"
	}
	goto __finally53;
	__catch53_g_error:
	{
#line 87 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository.vala"
		g_clear_error (&_inner_error_);
#line 87 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository.vala"
		_inner_error_ = NULL;
#line 91 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository.vala"
		result = 0;
#line 91 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository.vala"
		_g_object_unref0 (r);
#line 91 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository.vala"
		return result;
#line 429 "gitg-repository.c"
	}
	__finally53:
#line 87 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 87 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository.vala"
		_g_object_unref0 (r);
#line 87 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 87 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository.vala"
		g_clear_error (&_inner_error_);
#line 87 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository.vala"
		return 0;
#line 442 "gitg-repository.c"
	}
#line 93 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository.vala"
	_tmp4_ = r;
#line 93 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository.vala"
	if (_tmp4_ == NULL) {
#line 95 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository.vala"
		result = 0;
#line 95 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository.vala"
		_g_object_unref0 (r);
#line 95 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository.vala"
		return result;
#line 454 "gitg-repository.c"
	}
#line 98 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository.vala"
	_tmp5_ = r;
#line 98 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository.vala"
	_tmp6_ = ggit_ref_get_target ((GgitRef*) _tmp5_);
#line 98 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository.vala"
	id = _tmp6_;
#line 100 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository.vala"
	_tmp7_ = id;
#line 100 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository.vala"
	if (_tmp7_ == NULL) {
#line 102 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository.vala"
		result = 0;
#line 102 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository.vala"
		__vala_GgitOId_free0 (id);
#line 102 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository.vala"
		_g_object_unref0 (r);
#line 102 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository.vala"
		return result;
#line 474 "gitg-repository.c"
	}
#line 105 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository.vala"
	_tmp8_ = id;
#line 105 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository.vala"
	_tmp9_ = r;
#line 105 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository.vala"
	gitg_repository_ensure_refs_add (self, _tmp8_, _tmp9_);
#line 482 "gitg-repository.c"
	{
		GgitTag* tag = NULL;
		GgitOId* _tmp10_ = NULL;
		gpointer _tmp11_ = NULL;
		GgitTag* _tmp12_ = NULL;
		GgitOId* _tmp13_ = NULL;
		GgitOId* _tmp14_ = NULL;
#line 111 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository.vala"
		_tmp10_ = id;
#line 111 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository.vala"
		_tmp11_ = gitg_repository_lookup (self, ggit_tag_get_type (), (GBoxedCopyFunc) g_object_ref, g_object_unref, _tmp10_, &_inner_error_);
#line 111 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository.vala"
		tag = (GgitTag*) _tmp11_;
#line 111 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 498 "gitg-repository.c"
			goto __catch54_g_error;
		}
#line 114 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository.vala"
		_tmp12_ = tag;
#line 114 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository.vala"
		_tmp13_ = ggit_tag_get_target_id (_tmp12_);
#line 114 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository.vala"
		__vala_GgitOId_free0 (id);
#line 114 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository.vala"
		id = _tmp13_;
#line 116 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository.vala"
		_tmp14_ = id;
#line 116 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository.vala"
		if (_tmp14_ != NULL) {
#line 513 "gitg-repository.c"
			GgitOId* _tmp15_ = NULL;
			GitgRef* _tmp16_ = NULL;
#line 118 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository.vala"
			_tmp15_ = id;
#line 118 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository.vala"
			_tmp16_ = r;
#line 118 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository.vala"
			gitg_repository_ensure_refs_add (self, _tmp15_, _tmp16_);
#line 522 "gitg-repository.c"
		}
#line 109 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository.vala"
		_g_object_unref0 (tag);
#line 526 "gitg-repository.c"
	}
	goto __finally54;
	__catch54_g_error:
	{
#line 109 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository.vala"
		g_clear_error (&_inner_error_);
#line 109 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository.vala"
		_inner_error_ = NULL;
#line 535 "gitg-repository.c"
	}
	__finally54:
#line 109 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 109 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository.vala"
		__vala_GgitOId_free0 (id);
#line 109 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository.vala"
		_g_object_unref0 (r);
#line 109 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 109 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository.vala"
		g_clear_error (&_inner_error_);
#line 109 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository.vala"
		return 0;
#line 550 "gitg-repository.c"
	}
#line 122 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository.vala"
	result = 0;
#line 122 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository.vala"
	__vala_GgitOId_free0 (id);
#line 122 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository.vala"
	_g_object_unref0 (r);
#line 122 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository.vala"
	return result;
#line 560 "gitg-repository.c"
}


static gint ____lambda29__ggit_references_name_callback (const gchar* name, gpointer self) {
	gint result;
	result = ___lambda29_ ((GitgRepository*) self, name);
#line 84 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository.vala"
	return result;
#line 569 "gitg-repository.c"
}


static void gitg_repository_ensure_refs (GitgRepository* self) {
	GHashTable* _tmp0_ = NULL;
	GHashTable* _tmp1_ = NULL;
	GError * _inner_error_ = NULL;
#line 72 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository.vala"
	g_return_if_fail (self != NULL);
#line 74 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository.vala"
	_tmp0_ = self->priv->d_refs;
#line 74 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository.vala"
	if (_tmp0_ != NULL) {
#line 76 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository.vala"
		return;
#line 585 "gitg-repository.c"
	}
#line 79 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository.vala"
	_tmp1_ = g_hash_table_new_full (_ggit_oid_hash_ghash_func, _ggit_oid_equal_gequal_func, __vala_GgitOId_free0_, __g_slist_free__g_object_unref0_0_);
#line 79 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository.vala"
	_g_hash_table_unref0 (self->priv->d_refs);
#line 79 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository.vala"
	self->priv->d_refs = _tmp1_;
#line 593 "gitg-repository.c"
	{
#line 84 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository.vala"
		ggit_repository_references_foreach_name ((GgitRepository*) self, ____lambda29__ggit_references_name_callback, self, &_inner_error_);
#line 84 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 599 "gitg-repository.c"
			goto __catch52_g_error;
		}
	}
	goto __finally52;
	__catch52_g_error:
	{
#line 82 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository.vala"
		g_clear_error (&_inner_error_);
#line 82 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository.vala"
		_inner_error_ = NULL;
#line 610 "gitg-repository.c"
	}
	__finally52:
#line 82 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 82 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 82 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository.vala"
		g_clear_error (&_inner_error_);
#line 82 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository.vala"
		return;
#line 621 "gitg-repository.c"
	}
}


GSList* gitg_repository_refs_for_id (GitgRepository* self, GgitOId* id) {
	GSList* result = NULL;
	GHashTable* _tmp0_ = NULL;
	GgitOId* _tmp1_ = NULL;
	gconstpointer _tmp2_ = NULL;
#line 128 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 128 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository.vala"
	g_return_val_if_fail (id != NULL, NULL);
#line 130 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository.vala"
	gitg_repository_ensure_refs (self);
#line 132 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository.vala"
	_tmp0_ = self->priv->d_refs;
#line 132 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository.vala"
	_tmp1_ = id;
#line 132 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository.vala"
	_tmp2_ = g_hash_table_lookup (_tmp0_, _tmp1_);
#line 132 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository.vala"
	result = (GSList*) _tmp2_;
#line 132 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository.vala"
	return result;
#line 647 "gitg-repository.c"
}


gpointer gitg_repository_lookup (GitgRepository* self, GType t_type, GBoxedCopyFunc t_dup_func, GDestroyNotify t_destroy_func, GgitOId* id, GError** error) {
	gpointer result = NULL;
	GgitObject* _tmp0_ = NULL;
	GgitOId* _tmp1_ = NULL;
	GgitObject* _tmp2_ = NULL;
	GgitObject* _tmp3_ = NULL;
	GError * _inner_error_ = NULL;
#line 135 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 135 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository.vala"
	g_return_val_if_fail (id != NULL, NULL);
#line 137 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository.vala"
	_tmp1_ = id;
#line 137 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository.vala"
	_tmp2_ = ggit_repository_lookup (G_TYPE_CHECK_INSTANCE_CAST (self, ggit_repository_get_type (), GgitRepository), _tmp1_, t_type, &_inner_error_);
#line 137 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository.vala"
	_tmp0_ = _tmp2_;
#line 137 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 137 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository.vala"
		g_propagate_error (error, _inner_error_);
#line 137 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository.vala"
		return NULL;
#line 674 "gitg-repository.c"
	}
#line 137 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository.vala"
	_tmp3_ = _tmp0_;
#line 137 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository.vala"
	_tmp0_ = NULL;
#line 137 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository.vala"
	result = (gpointer) _tmp3_;
#line 137 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository.vala"
	_g_object_unref0 (_tmp0_);
#line 137 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository.vala"
	return result;
#line 686 "gitg-repository.c"
}


GitgRef* gitg_repository_lookup_reference (GitgRepository* self, const gchar* name, GError** error) {
	GitgRef* result = NULL;
	GgitRef* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	GgitRef* _tmp2_ = NULL;
	GgitRef* _tmp3_ = NULL;
	GitgRef* _tmp4_ = NULL;
	GError * _inner_error_ = NULL;
#line 141 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 141 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository.vala"
	g_return_val_if_fail (name != NULL, NULL);
#line 143 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository.vala"
	_tmp1_ = name;
#line 143 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository.vala"
	_tmp2_ = ggit_repository_lookup_reference (G_TYPE_CHECK_INSTANCE_CAST (self, ggit_repository_get_type (), GgitRepository), _tmp1_, &_inner_error_);
#line 143 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository.vala"
	_tmp0_ = _tmp2_;
#line 143 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 143 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository.vala"
		g_propagate_error (error, _inner_error_);
#line 143 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository.vala"
		return NULL;
#line 714 "gitg-repository.c"
	}
#line 143 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository.vala"
	_tmp3_ = _tmp0_;
#line 143 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository.vala"
	_tmp0_ = NULL;
#line 143 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository.vala"
	_tmp4_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp3_, GITG_TYPE_REF) ? ((GitgRef*) _tmp3_) : NULL;
#line 143 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository.vala"
	if (_tmp4_ == NULL) {
#line 143 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository.vala"
		_g_object_unref0 (_tmp3_);
#line 726 "gitg-repository.c"
	}
#line 143 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository.vala"
	result = _tmp4_;
#line 143 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository.vala"
	_g_object_unref0 (_tmp0_);
#line 143 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository.vala"
	return result;
#line 734 "gitg-repository.c"
}


GitgRef* gitg_repository_lookup_reference_dwim (GitgRepository* self, const gchar* short_name, GError** error) {
	GitgRef* result = NULL;
	GgitRef* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	GgitRef* _tmp2_ = NULL;
	GgitRef* _tmp3_ = NULL;
	GitgRef* _tmp4_ = NULL;
	GError * _inner_error_ = NULL;
#line 146 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 146 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository.vala"
	g_return_val_if_fail (short_name != NULL, NULL);
#line 148 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository.vala"
	_tmp1_ = short_name;
#line 148 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository.vala"
	_tmp2_ = ggit_repository_lookup_reference_dwim (G_TYPE_CHECK_INSTANCE_CAST (self, ggit_repository_get_type (), GgitRepository), _tmp1_, &_inner_error_);
#line 148 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository.vala"
	_tmp0_ = _tmp2_;
#line 148 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 148 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository.vala"
		g_propagate_error (error, _inner_error_);
#line 148 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository.vala"
		return NULL;
#line 762 "gitg-repository.c"
	}
#line 148 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository.vala"
	_tmp3_ = _tmp0_;
#line 148 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository.vala"
	_tmp0_ = NULL;
#line 148 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository.vala"
	_tmp4_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp3_, GITG_TYPE_REF) ? ((GitgRef*) _tmp3_) : NULL;
#line 148 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository.vala"
	if (_tmp4_ == NULL) {
#line 148 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository.vala"
		_g_object_unref0 (_tmp3_);
#line 774 "gitg-repository.c"
	}
#line 148 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository.vala"
	result = _tmp4_;
#line 148 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository.vala"
	_g_object_unref0 (_tmp0_);
#line 148 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository.vala"
	return result;
#line 782 "gitg-repository.c"
}


GitgBranch* gitg_repository_create_branch (GitgRepository* self, const gchar* name, GgitObject* obj, GgitCreateFlags flags, GError** error) {
	GitgBranch* result = NULL;
	GgitBranch* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	GgitObject* _tmp2_ = NULL;
	GgitCreateFlags _tmp3_ = 0;
	GgitBranch* _tmp4_ = NULL;
	GgitBranch* _tmp5_ = NULL;
	GitgBranch* _tmp6_ = NULL;
	GError * _inner_error_ = NULL;
#line 151 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 151 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository.vala"
	g_return_val_if_fail (name != NULL, NULL);
#line 151 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository.vala"
	g_return_val_if_fail (obj != NULL, NULL);
#line 153 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository.vala"
	_tmp1_ = name;
#line 153 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository.vala"
	_tmp2_ = obj;
#line 153 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository.vala"
	_tmp3_ = flags;
#line 153 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository.vala"
	_tmp4_ = ggit_repository_create_branch (G_TYPE_CHECK_INSTANCE_CAST (self, ggit_repository_get_type (), GgitRepository), _tmp1_, _tmp2_, _tmp3_, &_inner_error_);
#line 153 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository.vala"
	_tmp0_ = _tmp4_;
#line 153 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 153 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository.vala"
		g_propagate_error (error, _inner_error_);
#line 153 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository.vala"
		return NULL;
#line 818 "gitg-repository.c"
	}
#line 153 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository.vala"
	_tmp5_ = _tmp0_;
#line 153 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository.vala"
	_tmp0_ = NULL;
#line 153 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository.vala"
	_tmp6_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp5_, GITG_TYPE_BRANCH) ? ((GitgBranch*) _tmp5_) : NULL;
#line 153 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository.vala"
	if (_tmp6_ == NULL) {
#line 153 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository.vala"
		_g_object_unref0 (_tmp5_);
#line 830 "gitg-repository.c"
	}
#line 153 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository.vala"
	result = _tmp6_;
#line 153 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository.vala"
	_g_object_unref0 (_tmp0_);
#line 153 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository.vala"
	return result;
#line 838 "gitg-repository.c"
}


GitgRef* gitg_repository_create_reference (GitgRepository* self, const gchar* name, GgitOId* oid, const gchar* message, GError** error) {
	GitgRef* result = NULL;
	GgitRef* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	GgitOId* _tmp2_ = NULL;
	const gchar* _tmp3_ = NULL;
	GgitRef* _tmp4_ = NULL;
	GgitRef* _tmp5_ = NULL;
	GitgRef* _tmp6_ = NULL;
	GError * _inner_error_ = NULL;
#line 156 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 156 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository.vala"
	g_return_val_if_fail (name != NULL, NULL);
#line 156 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository.vala"
	g_return_val_if_fail (oid != NULL, NULL);
#line 156 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository.vala"
	g_return_val_if_fail (message != NULL, NULL);
#line 158 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository.vala"
	_tmp1_ = name;
#line 158 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository.vala"
	_tmp2_ = oid;
#line 158 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository.vala"
	_tmp3_ = message;
#line 158 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository.vala"
	_tmp4_ = ggit_repository_create_reference (G_TYPE_CHECK_INSTANCE_CAST (self, ggit_repository_get_type (), GgitRepository), _tmp1_, _tmp2_, _tmp3_, &_inner_error_);
#line 158 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository.vala"
	_tmp0_ = _tmp4_;
#line 158 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 158 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository.vala"
		g_propagate_error (error, _inner_error_);
#line 158 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository.vala"
		return NULL;
#line 876 "gitg-repository.c"
	}
#line 158 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository.vala"
	_tmp5_ = _tmp0_;
#line 158 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository.vala"
	_tmp0_ = NULL;
#line 158 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository.vala"
	_tmp6_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp5_, GITG_TYPE_REF) ? ((GitgRef*) _tmp5_) : NULL;
#line 158 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository.vala"
	if (_tmp6_ == NULL) {
#line 158 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository.vala"
		_g_object_unref0 (_tmp5_);
#line 888 "gitg-repository.c"
	}
#line 158 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository.vala"
	result = _tmp6_;
#line 158 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository.vala"
	_g_object_unref0 (_tmp0_);
#line 158 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository.vala"
	return result;
#line 896 "gitg-repository.c"
}


GitgRef* gitg_repository_create_symbolic_reference (GitgRepository* self, const gchar* name, const gchar* target, const gchar* message, GError** error) {
	GitgRef* result = NULL;
	GgitRef* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	const gchar* _tmp3_ = NULL;
	GgitRef* _tmp4_ = NULL;
	GgitRef* _tmp5_ = NULL;
	GitgRef* _tmp6_ = NULL;
	GError * _inner_error_ = NULL;
#line 161 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 161 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository.vala"
	g_return_val_if_fail (name != NULL, NULL);
#line 161 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository.vala"
	g_return_val_if_fail (target != NULL, NULL);
#line 161 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository.vala"
	g_return_val_if_fail (message != NULL, NULL);
#line 163 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository.vala"
	_tmp1_ = name;
#line 163 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository.vala"
	_tmp2_ = target;
#line 163 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository.vala"
	_tmp3_ = message;
#line 163 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository.vala"
	_tmp4_ = ggit_repository_create_symbolic_reference (G_TYPE_CHECK_INSTANCE_CAST (self, ggit_repository_get_type (), GgitRepository), _tmp1_, _tmp2_, _tmp3_, &_inner_error_);
#line 163 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository.vala"
	_tmp0_ = _tmp4_;
#line 163 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 163 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository.vala"
		g_propagate_error (error, _inner_error_);
#line 163 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository.vala"
		return NULL;
#line 934 "gitg-repository.c"
	}
#line 163 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository.vala"
	_tmp5_ = _tmp0_;
#line 163 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository.vala"
	_tmp0_ = NULL;
#line 163 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository.vala"
	_tmp6_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp5_, GITG_TYPE_REF) ? ((GitgRef*) _tmp5_) : NULL;
#line 163 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository.vala"
	if (_tmp6_ == NULL) {
#line 163 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository.vala"
		_g_object_unref0 (_tmp5_);
#line 946 "gitg-repository.c"
	}
#line 163 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository.vala"
	result = _tmp6_;
#line 163 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository.vala"
	_g_object_unref0 (_tmp0_);
#line 163 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository.vala"
	return result;
#line 954 "gitg-repository.c"
}


GitgRef* gitg_repository_get_head (GitgRepository* self, GError** error) {
	GitgRef* result = NULL;
	GgitRef* _tmp0_ = NULL;
	GgitRef* _tmp1_ = NULL;
	GgitRef* _tmp2_ = NULL;
	GitgRef* _tmp3_ = NULL;
	GError * _inner_error_ = NULL;
#line 166 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 168 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository.vala"
	_tmp1_ = ggit_repository_get_head (G_TYPE_CHECK_INSTANCE_CAST (self, ggit_repository_get_type (), GgitRepository), &_inner_error_);
#line 168 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository.vala"
	_tmp0_ = _tmp1_;
#line 168 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 168 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository.vala"
		g_propagate_error (error, _inner_error_);
#line 168 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository.vala"
		return NULL;
#line 977 "gitg-repository.c"
	}
#line 168 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository.vala"
	_tmp2_ = _tmp0_;
#line 168 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository.vala"
	_tmp0_ = NULL;
#line 168 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository.vala"
	_tmp3_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp2_, GITG_TYPE_REF) ? ((GitgRef*) _tmp2_) : NULL;
#line 168 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository.vala"
	if (_tmp3_ == NULL) {
#line 168 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository.vala"
		_g_object_unref0 (_tmp2_);
#line 989 "gitg-repository.c"
	}
#line 168 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository.vala"
	result = _tmp3_;
#line 168 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository.vala"
	_g_object_unref0 (_tmp0_);
#line 168 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository.vala"
	return result;
#line 997 "gitg-repository.c"
}


GitgRepository* gitg_repository_init_repository (GFile* location, gboolean is_bare, GError** error) {
	GitgRepository* result = NULL;
	GgitRepository* _tmp0_ = NULL;
	GFile* _tmp1_ = NULL;
	gboolean _tmp2_ = FALSE;
	GgitRepository* _tmp3_ = NULL;
	GgitRepository* _tmp4_ = NULL;
	GitgRepository* _tmp5_ = NULL;
	GError * _inner_error_ = NULL;
#line 171 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository.vala"
	g_return_val_if_fail (location != NULL, NULL);
#line 173 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository.vala"
	_tmp1_ = location;
#line 173 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository.vala"
	_tmp2_ = is_bare;
#line 173 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository.vala"
	_tmp3_ = ggit_repository_init_repository (_tmp1_, _tmp2_, &_inner_error_);
#line 173 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository.vala"
	_tmp0_ = _tmp3_;
#line 173 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 173 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository.vala"
		g_propagate_error (error, _inner_error_);
#line 173 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository.vala"
		return NULL;
#line 1026 "gitg-repository.c"
	}
#line 173 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository.vala"
	_tmp4_ = _tmp0_;
#line 173 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository.vala"
	_tmp0_ = NULL;
#line 173 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository.vala"
	_tmp5_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp4_, GITG_TYPE_REPOSITORY) ? ((GitgRepository*) _tmp4_) : NULL;
#line 173 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository.vala"
	if (_tmp5_ == NULL) {
#line 173 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository.vala"
		_g_object_unref0 (_tmp4_);
#line 1038 "gitg-repository.c"
	}
#line 173 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository.vala"
	result = _tmp5_;
#line 173 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository.vala"
	_g_object_unref0 (_tmp0_);
#line 173 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository.vala"
	return result;
#line 1046 "gitg-repository.c"
}


static const gchar* string_to_string (const gchar* self) {
	const gchar* result = NULL;
#line 1314 "/opt/gnome/share/vala-0.32/vapi/glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, NULL);
#line 1315 "/opt/gnome/share/vala-0.32/vapi/glib-2.0.vapi"
	result = self;
#line 1315 "/opt/gnome/share/vala-0.32/vapi/glib-2.0.vapi"
	return result;
#line 1058 "gitg-repository.c"
}


GgitSignature* gitg_repository_get_signature_with_environment (GitgRepository* self, GeeMap* env, const gchar* envname, GError** error) {
	GgitSignature* result = NULL;
	gchar* user = NULL;
	gchar* email = NULL;
	GDateTime* date = NULL;
	gchar* nameenv = NULL;
	const gchar* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	gchar* emailenv = NULL;
	const gchar* _tmp3_ = NULL;
	const gchar* _tmp4_ = NULL;
	gchar* _tmp5_ = NULL;
	gchar* dateenv = NULL;
	const gchar* _tmp6_ = NULL;
	const gchar* _tmp7_ = NULL;
	gchar* _tmp8_ = NULL;
	GeeMap* _tmp9_ = NULL;
	const gchar* _tmp10_ = NULL;
	gboolean _tmp11_ = FALSE;
	GeeMap* _tmp15_ = NULL;
	const gchar* _tmp16_ = NULL;
	gboolean _tmp17_ = FALSE;
	GeeMap* _tmp21_ = NULL;
	const gchar* _tmp22_ = NULL;
	gboolean _tmp23_ = FALSE;
	GDateTime* _tmp32_ = NULL;
	GgitConfig* _tmp34_ = NULL;
	GgitConfig* _tmp35_ = NULL;
	GgitConfig* conf = NULL;
	GgitConfig* _tmp36_ = NULL;
	GgitConfig* _tmp37_ = NULL;
	GgitConfig* _tmp38_ = NULL;
	GgitConfig* _tmp39_ = NULL;
	const gchar* _tmp40_ = NULL;
	const gchar* _tmp45_ = NULL;
	const gchar* _tmp50_ = NULL;
	const gchar* _tmp51_ = NULL;
	const gchar* _tmp53_ = NULL;
	const gchar* _tmp54_ = NULL;
	GgitSignature* _tmp56_ = NULL;
	GDateTime* _tmp57_ = NULL;
	GgitSignature* _tmp58_ = NULL;
	GgitSignature* _tmp59_ = NULL;
	GError * _inner_error_ = NULL;
#line 189 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 189 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository.vala"
	g_return_val_if_fail (env != NULL, NULL);
#line 189 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository.vala"
	g_return_val_if_fail (envname != NULL, NULL);
#line 191 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository.vala"
	user = NULL;
#line 192 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository.vala"
	email = NULL;
#line 193 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository.vala"
	date = NULL;
#line 195 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository.vala"
	_tmp0_ = envname;
#line 195 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository.vala"
	_tmp1_ = string_to_string (_tmp0_);
#line 195 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository.vala"
	_tmp2_ = g_strconcat ("GIT_", _tmp1_, "_NAME", NULL);
#line 195 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository.vala"
	nameenv = _tmp2_;
#line 196 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository.vala"
	_tmp3_ = envname;
#line 196 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository.vala"
	_tmp4_ = string_to_string (_tmp3_);
#line 196 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository.vala"
	_tmp5_ = g_strconcat ("GIT_", _tmp4_, "_EMAIL", NULL);
#line 196 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository.vala"
	emailenv = _tmp5_;
#line 197 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository.vala"
	_tmp6_ = envname;
#line 197 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository.vala"
	_tmp7_ = string_to_string (_tmp6_);
#line 197 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository.vala"
	_tmp8_ = g_strconcat ("GIT_", _tmp7_, "_DATE", NULL);
#line 197 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository.vala"
	dateenv = _tmp8_;
#line 199 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository.vala"
	_tmp9_ = env;
#line 199 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository.vala"
	_tmp10_ = nameenv;
#line 199 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository.vala"
	_tmp11_ = gee_map_has_key (_tmp9_, _tmp10_);
#line 199 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository.vala"
	if (_tmp11_) {
#line 1151 "gitg-repository.c"
		GeeMap* _tmp12_ = NULL;
		const gchar* _tmp13_ = NULL;
		gpointer _tmp14_ = NULL;
#line 201 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository.vala"
		_tmp12_ = env;
#line 201 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository.vala"
		_tmp13_ = nameenv;
#line 201 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository.vala"
		_tmp14_ = gee_map_get (_tmp12_, _tmp13_);
#line 201 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository.vala"
		_g_free0 (user);
#line 201 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository.vala"
		user = (gchar*) _tmp14_;
#line 1165 "gitg-repository.c"
	}
#line 204 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository.vala"
	_tmp15_ = env;
#line 204 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository.vala"
	_tmp16_ = emailenv;
#line 204 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository.vala"
	_tmp17_ = gee_map_has_key (_tmp15_, _tmp16_);
#line 204 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository.vala"
	if (_tmp17_) {
#line 1175 "gitg-repository.c"
		GeeMap* _tmp18_ = NULL;
		const gchar* _tmp19_ = NULL;
		gpointer _tmp20_ = NULL;
#line 206 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository.vala"
		_tmp18_ = env;
#line 206 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository.vala"
		_tmp19_ = emailenv;
#line 206 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository.vala"
		_tmp20_ = gee_map_get (_tmp18_, _tmp19_);
#line 206 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository.vala"
		_g_free0 (email);
#line 206 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository.vala"
		email = (gchar*) _tmp20_;
#line 1189 "gitg-repository.c"
	}
#line 209 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository.vala"
	_tmp21_ = env;
#line 209 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository.vala"
	_tmp22_ = dateenv;
#line 209 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository.vala"
	_tmp23_ = gee_map_has_key (_tmp21_, _tmp22_);
#line 209 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository.vala"
	if (_tmp23_) {
#line 1199 "gitg-repository.c"
		{
			GDateTime* _tmp24_ = NULL;
			GeeMap* _tmp25_ = NULL;
			const gchar* _tmp26_ = NULL;
			gpointer _tmp27_ = NULL;
			gchar* _tmp28_ = NULL;
			GDateTime* _tmp29_ = NULL;
			GDateTime* _tmp30_ = NULL;
			GDateTime* _tmp31_ = NULL;
#line 213 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository.vala"
			_tmp25_ = env;
#line 213 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository.vala"
			_tmp26_ = dateenv;
#line 213 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository.vala"
			_tmp27_ = gee_map_get (_tmp25_, _tmp26_);
#line 213 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository.vala"
			_tmp28_ = (gchar*) _tmp27_;
#line 213 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository.vala"
			_tmp29_ = gitg_date_parse (_tmp28_, &_inner_error_);
#line 213 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository.vala"
			_tmp30_ = _tmp29_;
#line 213 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository.vala"
			_g_free0 (_tmp28_);
#line 213 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository.vala"
			_tmp24_ = _tmp30_;
#line 213 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository.vala"
			if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1227 "gitg-repository.c"
				goto __catch55_g_error;
			}
#line 213 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository.vala"
			_tmp31_ = _tmp24_;
#line 213 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository.vala"
			_tmp24_ = NULL;
#line 213 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository.vala"
			_g_date_time_unref0 (date);
#line 213 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository.vala"
			date = _tmp31_;
#line 211 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository.vala"
			_g_date_time_unref0 (_tmp24_);
#line 1240 "gitg-repository.c"
		}
		goto __finally55;
		__catch55_g_error:
		{
#line 211 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository.vala"
			g_clear_error (&_inner_error_);
#line 211 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository.vala"
			_inner_error_ = NULL;
#line 1249 "gitg-repository.c"
		}
		__finally55:
#line 211 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 211 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository.vala"
			g_propagate_error (error, _inner_error_);
#line 211 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository.vala"
			_g_free0 (dateenv);
#line 211 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository.vala"
			_g_free0 (emailenv);
#line 211 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository.vala"
			_g_free0 (nameenv);
#line 211 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository.vala"
			_g_date_time_unref0 (date);
#line 211 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository.vala"
			_g_free0 (email);
#line 211 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository.vala"
			_g_free0 (user);
#line 211 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository.vala"
			return NULL;
#line 1270 "gitg-repository.c"
		}
	}
#line 218 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository.vala"
	_tmp32_ = date;
#line 218 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository.vala"
	if (_tmp32_ == NULL) {
#line 1277 "gitg-repository.c"
		GDateTime* _tmp33_ = NULL;
#line 220 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository.vala"
		_tmp33_ = g_date_time_new_now_local ();
#line 220 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository.vala"
		_g_date_time_unref0 (date);
#line 220 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository.vala"
		date = _tmp33_;
#line 1285 "gitg-repository.c"
	}
#line 223 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository.vala"
	_tmp35_ = ggit_repository_get_config ((GgitRepository*) self, &_inner_error_);
#line 223 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository.vala"
	_tmp34_ = _tmp35_;
#line 223 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 223 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository.vala"
		g_propagate_error (error, _inner_error_);
#line 223 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository.vala"
		_g_free0 (dateenv);
#line 223 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository.vala"
		_g_free0 (emailenv);
#line 223 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository.vala"
		_g_free0 (nameenv);
#line 223 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository.vala"
		_g_date_time_unref0 (date);
#line 223 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository.vala"
		_g_free0 (email);
#line 223 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository.vala"
		_g_free0 (user);
#line 223 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository.vala"
		return NULL;
#line 1309 "gitg-repository.c"
	}
#line 223 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository.vala"
	_tmp36_ = _tmp34_;
#line 223 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository.vala"
	_tmp34_ = NULL;
#line 223 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository.vala"
	_tmp37_ = _tmp36_;
#line 223 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository.vala"
	_tmp38_ = ggit_config_snapshot (_tmp37_, &_inner_error_);
#line 223 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository.vala"
	_tmp39_ = _tmp38_;
#line 223 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository.vala"
	_g_object_unref0 (_tmp37_);
#line 223 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository.vala"
	conf = _tmp39_;
#line 223 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 223 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository.vala"
		g_propagate_error (error, _inner_error_);
#line 223 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository.vala"
		_g_object_unref0 (_tmp34_);
#line 223 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository.vala"
		_g_free0 (dateenv);
#line 223 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository.vala"
		_g_free0 (emailenv);
#line 223 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository.vala"
		_g_free0 (nameenv);
#line 223 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository.vala"
		_g_date_time_unref0 (date);
#line 223 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository.vala"
		_g_free0 (email);
#line 223 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository.vala"
		_g_free0 (user);
#line 223 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository.vala"
		return NULL;
#line 1345 "gitg-repository.c"
	}
#line 225 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository.vala"
	_tmp40_ = user;
#line 225 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository.vala"
	if (_tmp40_ == NULL) {
#line 1351 "gitg-repository.c"
		{
			const gchar* _tmp41_ = NULL;
			GgitConfig* _tmp42_ = NULL;
			const gchar* _tmp43_ = NULL;
			gchar* _tmp44_ = NULL;
#line 229 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository.vala"
			_tmp42_ = conf;
#line 229 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository.vala"
			_tmp43_ = ggit_config_get_string (_tmp42_, "user.name", &_inner_error_);
#line 229 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository.vala"
			_tmp41_ = _tmp43_;
#line 229 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository.vala"
			if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1365 "gitg-repository.c"
				goto __catch56_g_error;
			}
#line 229 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository.vala"
			_tmp44_ = g_strdup (_tmp41_);
#line 229 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository.vala"
			_g_free0 (user);
#line 229 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository.vala"
			user = _tmp44_;
#line 1374 "gitg-repository.c"
		}
		goto __finally56;
		__catch56_g_error:
		{
#line 227 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository.vala"
			g_clear_error (&_inner_error_);
#line 227 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository.vala"
			_inner_error_ = NULL;
#line 1383 "gitg-repository.c"
		}
		__finally56:
#line 227 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 227 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository.vala"
			g_propagate_error (error, _inner_error_);
#line 227 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository.vala"
			_g_object_unref0 (conf);
#line 227 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository.vala"
			_g_object_unref0 (_tmp34_);
#line 227 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository.vala"
			_g_free0 (dateenv);
#line 227 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository.vala"
			_g_free0 (emailenv);
#line 227 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository.vala"
			_g_free0 (nameenv);
#line 227 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository.vala"
			_g_date_time_unref0 (date);
#line 227 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository.vala"
			_g_free0 (email);
#line 227 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository.vala"
			_g_free0 (user);
#line 227 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository.vala"
			return NULL;
#line 1408 "gitg-repository.c"
		}
	}
#line 233 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository.vala"
	_tmp45_ = email;
#line 233 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository.vala"
	if (_tmp45_ == NULL) {
#line 1415 "gitg-repository.c"
		{
			const gchar* _tmp46_ = NULL;
			GgitConfig* _tmp47_ = NULL;
			const gchar* _tmp48_ = NULL;
			gchar* _tmp49_ = NULL;
#line 237 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository.vala"
			_tmp47_ = conf;
#line 237 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository.vala"
			_tmp48_ = ggit_config_get_string (_tmp47_, "user.email", &_inner_error_);
#line 237 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository.vala"
			_tmp46_ = _tmp48_;
#line 237 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository.vala"
			if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1429 "gitg-repository.c"
				goto __catch57_g_error;
			}
#line 237 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository.vala"
			_tmp49_ = g_strdup (_tmp46_);
#line 237 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository.vala"
			_g_free0 (email);
#line 237 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository.vala"
			email = _tmp49_;
#line 1438 "gitg-repository.c"
		}
		goto __finally57;
		__catch57_g_error:
		{
#line 235 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository.vala"
			g_clear_error (&_inner_error_);
#line 235 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository.vala"
			_inner_error_ = NULL;
#line 1447 "gitg-repository.c"
		}
		__finally57:
#line 235 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 235 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository.vala"
			g_propagate_error (error, _inner_error_);
#line 235 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository.vala"
			_g_object_unref0 (conf);
#line 235 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository.vala"
			_g_object_unref0 (_tmp34_);
#line 235 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository.vala"
			_g_free0 (dateenv);
#line 235 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository.vala"
			_g_free0 (emailenv);
#line 235 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository.vala"
			_g_free0 (nameenv);
#line 235 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository.vala"
			_g_date_time_unref0 (date);
#line 235 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository.vala"
			_g_free0 (email);
#line 235 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository.vala"
			_g_free0 (user);
#line 235 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository.vala"
			return NULL;
#line 1472 "gitg-repository.c"
		}
	}
#line 241 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository.vala"
	_tmp51_ = user;
#line 241 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository.vala"
	if (_tmp51_ != NULL) {
#line 1479 "gitg-repository.c"
		const gchar* _tmp52_ = NULL;
#line 241 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository.vala"
		_tmp52_ = user;
#line 241 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository.vala"
		_tmp50_ = _tmp52_;
#line 1485 "gitg-repository.c"
	} else {
#line 241 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository.vala"
		_tmp50_ = "";
#line 1489 "gitg-repository.c"
	}
#line 242 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository.vala"
	_tmp54_ = email;
#line 242 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository.vala"
	if (_tmp54_ != NULL) {
#line 1495 "gitg-repository.c"
		const gchar* _tmp55_ = NULL;
#line 242 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository.vala"
		_tmp55_ = email;
#line 242 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository.vala"
		_tmp53_ = _tmp55_;
#line 1501 "gitg-repository.c"
	} else {
#line 242 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository.vala"
		_tmp53_ = "";
#line 1505 "gitg-repository.c"
	}
#line 241 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository.vala"
	_tmp57_ = date;
#line 241 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository.vala"
	_tmp58_ = ggit_signature_new (_tmp50_, _tmp53_, _tmp57_, &_inner_error_);
#line 241 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository.vala"
	_tmp56_ = _tmp58_;
#line 241 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 241 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository.vala"
		g_propagate_error (error, _inner_error_);
#line 241 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository.vala"
		_g_object_unref0 (conf);
#line 241 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository.vala"
		_g_object_unref0 (_tmp34_);
#line 241 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository.vala"
		_g_free0 (dateenv);
#line 241 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository.vala"
		_g_free0 (emailenv);
#line 241 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository.vala"
		_g_free0 (nameenv);
#line 241 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository.vala"
		_g_date_time_unref0 (date);
#line 241 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository.vala"
		_g_free0 (email);
#line 241 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository.vala"
		_g_free0 (user);
#line 241 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository.vala"
		return NULL;
#line 1535 "gitg-repository.c"
	}
#line 241 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository.vala"
	_tmp59_ = _tmp56_;
#line 241 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository.vala"
	_tmp56_ = NULL;
#line 241 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository.vala"
	result = _tmp59_;
#line 241 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository.vala"
	_g_object_unref0 (_tmp56_);
#line 241 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository.vala"
	_g_object_unref0 (conf);
#line 241 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository.vala"
	_g_object_unref0 (_tmp34_);
#line 241 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository.vala"
	_g_free0 (dateenv);
#line 241 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository.vala"
	_g_free0 (emailenv);
#line 241 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository.vala"
	_g_free0 (nameenv);
#line 241 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository.vala"
	_g_date_time_unref0 (date);
#line 241 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository.vala"
	_g_free0 (email);
#line 241 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository.vala"
	_g_free0 (user);
#line 241 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository.vala"
	return result;
#line 1563 "gitg-repository.c"
}


gchar* gitg_repository_get_name (GitgRepository* self) {
	gchar* result;
	GFile* _tmp0_ = NULL;
	GFile* _tmp1_ = NULL;
	GFile* _tmp2_ = NULL;
	GFile* _tmp3_ = NULL;
	gboolean _tmp4_ = FALSE;
	GFile* f = NULL;
	GFile* _tmp9_ = NULL;
	gchar* _tmp10_ = NULL;
	GFile* _tmp11_ = NULL;
#line 30 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 32 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository.vala"
	g_object_get ((GgitRepository*) self, "workdir", &_tmp1_, NULL);
#line 32 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository.vala"
	_tmp2_ = _tmp1_;
#line 32 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository.vala"
	_tmp3_ = _tmp2_;
#line 32 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository.vala"
	_tmp4_ = _tmp3_ != NULL;
#line 32 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository.vala"
	_g_object_unref0 (_tmp3_);
#line 32 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository.vala"
	if (_tmp4_) {
#line 1592 "gitg-repository.c"
		GFile* _tmp5_ = NULL;
		GFile* _tmp6_ = NULL;
#line 32 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository.vala"
		g_object_get ((GgitRepository*) self, "workdir", &_tmp5_, NULL);
#line 32 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository.vala"
		_tmp6_ = _tmp5_;
#line 32 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository.vala"
		_g_object_unref0 (_tmp0_);
#line 32 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository.vala"
		_tmp0_ = _tmp6_;
#line 1603 "gitg-repository.c"
	} else {
		GFile* _tmp7_ = NULL;
		GFile* _tmp8_ = NULL;
#line 32 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository.vala"
		_tmp7_ = ggit_repository_get_location ((GgitRepository*) self);
#line 32 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository.vala"
		_tmp8_ = _tmp7_;
#line 32 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository.vala"
		_g_object_unref0 (_tmp0_);
#line 32 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository.vala"
		_tmp0_ = _tmp8_;
#line 1615 "gitg-repository.c"
	}
#line 32 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository.vala"
	_tmp9_ = _g_object_ref0 (_tmp0_);
#line 32 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository.vala"
	f = _tmp9_;
#line 33 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository.vala"
	_tmp11_ = f;
#line 33 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository.vala"
	if (_tmp11_ != NULL) {
#line 1625 "gitg-repository.c"
		GFile* _tmp12_ = NULL;
		gchar* _tmp13_ = NULL;
#line 33 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository.vala"
		_tmp12_ = f;
#line 33 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository.vala"
		_tmp13_ = g_file_get_basename (_tmp12_);
#line 33 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository.vala"
		_g_free0 (_tmp10_);
#line 33 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository.vala"
		_tmp10_ = _tmp13_;
#line 1636 "gitg-repository.c"
	} else {
#line 33 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository.vala"
		_g_free0 (_tmp10_);
#line 33 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository.vala"
		_tmp10_ = NULL;
#line 1642 "gitg-repository.c"
	}
#line 33 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository.vala"
	result = _tmp10_;
#line 33 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository.vala"
	_g_object_unref0 (f);
#line 33 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository.vala"
	_g_object_unref0 (_tmp0_);
#line 33 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository.vala"
	return result;
#line 1652 "gitg-repository.c"
}


GitgStage* gitg_repository_get_stage (GitgRepository* self) {
	GitgStage* result;
	GitgStage* _tmp0_ = NULL;
	GitgStage* _tmp2_ = NULL;
	GitgStage* _tmp3_ = NULL;
#line 178 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 180 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository.vala"
	_tmp0_ = self->priv->d_stage;
#line 180 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository.vala"
	if (_tmp0_ == NULL) {
#line 1667 "gitg-repository.c"
		GitgStage* _tmp1_ = NULL;
#line 182 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository.vala"
		_tmp1_ = gitg_stage_new (self);
#line 182 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository.vala"
		_g_object_unref0 (self->priv->d_stage);
#line 182 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository.vala"
		self->priv->d_stage = _tmp1_;
#line 1675 "gitg-repository.c"
	}
#line 185 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository.vala"
	_tmp2_ = self->priv->d_stage;
#line 185 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository.vala"
	_tmp3_ = _g_object_ref0 (_tmp2_);
#line 185 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository.vala"
	result = _tmp3_;
#line 185 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository.vala"
	return result;
#line 1685 "gitg-repository.c"
}


static void gitg_repository_class_init (GitgRepositoryClass * klass) {
#line 23 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository.vala"
	gitg_repository_parent_class = g_type_class_peek_parent (klass);
#line 23 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository.vala"
	g_type_class_add_private (klass, sizeof (GitgRepositoryPrivate));
#line 23 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository.vala"
	G_OBJECT_CLASS (klass)->get_property = _vala_gitg_repository_get_property;
#line 23 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository.vala"
	G_OBJECT_CLASS (klass)->finalize = gitg_repository_finalize;
#line 23 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), GITG_REPOSITORY_NAME, g_param_spec_string ("name", "name", "name", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
#line 23 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), GITG_REPOSITORY_STAGE, g_param_spec_object ("stage", "stage", "stage", GITG_TYPE_STAGE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
#line 1702 "gitg-repository.c"
}


static void gitg_repository_instance_init (GitgRepository * self) {
#line 23 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository.vala"
	self->priv = GITG_REPOSITORY_GET_PRIVATE (self);
#line 1709 "gitg-repository.c"
}


static void gitg_repository_finalize (GObject* obj) {
	GitgRepository * self;
#line 23 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GITG_TYPE_REPOSITORY, GitgRepository);
#line 25 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository.vala"
	_g_hash_table_unref0 (self->priv->d_refs);
#line 26 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository.vala"
	_g_object_unref0 (self->priv->d_stage);
#line 23 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository.vala"
	G_OBJECT_CLASS (gitg_repository_parent_class)->finalize (obj);
#line 1723 "gitg-repository.c"
}


GType gitg_repository_get_type (void) {
	static volatile gsize gitg_repository_type_id__volatile = 0;
	if (g_once_init_enter (&gitg_repository_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (GitgRepositoryClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) gitg_repository_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GitgRepository), 0, (GInstanceInitFunc) gitg_repository_instance_init, NULL };
		GType gitg_repository_type_id;
		gitg_repository_type_id = g_type_register_static (ggit_repository_get_type (), "GitgRepository", &g_define_type_info, 0);
		g_once_init_leave (&gitg_repository_type_id__volatile, gitg_repository_type_id);
	}
	return gitg_repository_type_id__volatile;
}


static void _vala_gitg_repository_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	GitgRepository * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GITG_TYPE_REPOSITORY, GitgRepository);
#line 23 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository.vala"
	switch (property_id) {
#line 23 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository.vala"
		case GITG_REPOSITORY_NAME:
#line 23 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository.vala"
		g_value_take_string (value, gitg_repository_get_name (self));
#line 23 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository.vala"
		break;
#line 23 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository.vala"
		case GITG_REPOSITORY_STAGE:
#line 23 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository.vala"
		g_value_take_object (value, gitg_repository_get_stage (self));
#line 23 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository.vala"
		break;
#line 1756 "gitg-repository.c"
		default:
#line 23 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 23 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository.vala"
		break;
#line 1762 "gitg-repository.c"
	}
}



