#include "config.h"

#include <glib.h>
#include <string.h>
#ifdef HAVE_UNISTD_H
#include <unistd.h>
#endif
#include <stdlib.h>

/* Test GChecksum by computing the checksums of every initial
 * substring of this string, calling g_checksum_update with chunks of
 * every possible size. That is, first it computes the checksums of
 * "", then "T". Then it computes the checksums of "Th", first by
 * feeding the GChecksum 1 letter a time, then 2. Then it does "The",
 * first feeding it one letter at a time, then 2, then 3. Etc.
 *
 * MD5, SHA1, and SHA256 all use a 64-byte buffer internally; this
 * string is intentionally more than twice that length.
 */

#define FIXED_STR               "The quick brown fox jumps over the lazy dog. Jackdaws love my big sphinx of quartz. Pack my box with five dozen liquor jugs. How razorback-jumping frogs can level six piqued gymnasts!"
#define FIXED_LEN               (strlen (FIXED_STR))

const char *MD5_sums[] = {
  "d41d8cd98f00b204e9800998ecf8427e",
  "b9ece18c950afbfa6b0fdbfa4ff731d3",
  "eeeb9a8eb45dd351d9ec0eb4acce66ce",
  "a4704fd35f0308287f2937ba3eccf5fe",
  "02edd93949f6d3c57d9822691b59f649",
  "6131a51747610d0ae4e86c3a3416788c",
  "8c871099d54c09d4099fa7a0e77c9113",
  "bbb9873bad399cd1cc0d5e336ca5beee",
  "b9b926544b8ecd5c3ef553a87170b726",
  "912d57cea222bc1730dd531b9d6afbb6",
  "03c729679ca3252a4735c4148b7c11e3",
  "d7027ce01f22eb9d2bb32d9a153a7e29",
  "e05e6a516c92259691cf9194dfdeff92",
  "dd1ac3c70b6f51dd545cdf64053209d4",
  "caa1e1e79c65480a48cf08a38ac1d87d",
  "5aa207e85988921b8733912c4f526c80",
  "b0e45b65d9e1d88169c40dc47605e2d9",
  "e4b6d6fabe9dfcbe83a51d19df5f0ac3",
  "168534eca593b6cef86aea9081f0f5bf",
  "a2004f37730b9445670a738fa0fc9ee5",
  "c4314972a672ded8759cafdca9af3238",
  "29dcbbf4add427ccba06d3c37ad44aa9",
  "d0312d0e9e2d8c063d95a06fbbba9cb1",
  "770fd972e360cb8538ce6a880741936e",
  "8e53cb84ef3d981a86fbb69b24827c46",
  "83de97cab1f553eb3acc22866a4f6942",
  "a2829f93d701f36d808d0a698dcebf02",
  "efcead92aba26426db84b75413f17c10",
  "60a0732774106c2348eb576596668eb9",
  "d44f138aa2f39488c03391771eea258c",
  "f85199fa76594dfb190fab5dfe42a769",
  "cd4c02f190df2372cb703994dd84e881",
  "566cb723d4fb7a7dd38163532fe760b7",
  "4433001bd59da157c18b09f6c10d4163",
  "b76b517e01f5b708af50af906adb2dac",
  "0f611396bcfe9ab7666c45ebd37e59ba",
  "4c6606c2117565959048d356c1d7f6cc",
  "5f7f3f510b8a8f0a5e1d6193c6c7f3af",
  "542560ce828579cfe777aa165b4d1bed",
  "171e092149d366acca00d1cd783e61cd",
  "4ed8b5a69f7c329f498320947db666f2",
  "eb4c251a5abb3c59d306276ba2dc644d",
  "2b6e07526e77047d7935681efc3b9f90",
  "9e107d9d372bb6826bd81d3542a419d6",
  "e4d909c290d0fb1ca068ffaddf22cbd0",
  "1c6d98786bea70b9c34ce7f33201120c",
  "bdda04a65a37f97d3ac3be6b0d5f58ea",
  "954c69b280f0b5eed4b36eb714d26f82",
  "e5fad54e00d29bf5b1671b3d351624e9",
  "1a0b3d4eec1bd869af85945f60ff19c3",
  "055031167bd9f17448623653eb4b27ed",
  "4ca7c851615ea3abc43b5e1df410b84a",
  "774873408e0032f8c56106dc28d489e2",
  "fc44cc8ad9ff4aef8a4187688cb65378",
  "b939f1b04b296ac8ff8261876ae86704",
  "de9362af59e6e23688a243f909e9fdbd",
  "6827a93d7492d3da381d7b45f2a0b94f",
  "459ade91c05ca5f8bfdc8c3f6014ce04",
  "55b143ec7d943b04666010e165d753e0",
  "04ad29c207b52f46fd50f208744d936d",
  "8d26f6529919e3d3e33b5e147e96bd8c",
  "de98a267f5acd95c52bf439be075f360",
  "4a8a2b0f0cc485c957992c6c9865b33d",
  "566f00c9d7ac74a1daeb2925de2aca23",
  "6ebee39c52840729c65d815fbdb9e9c7",
  "7dc322a68ec5881e78cb718a3ca9a557",
  "b00112c2c7844e0c6c0cab1fdc7a12ab",
  "6f78ec779e96448daa9675bf06a0dbe3",
  "8bba94005e06aefd071ed8a5c1b89068",
  "220316718ce3875281be580a731ef0a1",
  "7dd175908a4fce0e510287a9f884ef1d",
  "030d864e63a6b67e11084f27ac5a422f",
  "cad084c9d6c71aa60c414b3df22e4ef2",
  "a10296630814335017df32f94b5202ff",
  "de23bdf63d07cc75716e1e303df0677c",
  "9718898182f2ba3a4428d9e357f5788e",
  "9dfc12c4b82dcf727fc6599a0696a48c",
  "6cca243870d308ffe8ae51993258e9ef",
  "6b425096ac7743989c9744ff45ea027f",
  "742a87784ffd6e2b0697aabf6b453309",
  "b9b7f74d898d1fe768777bd7fb7844e7",
  "4717614d82c1df37d608111953c75912",
  "43298b7db8498f89b9aa1bcb410a8ed2",
  "1b3621f615f0861d672d406257f5a97b",
  "9ef3e55a2eb9d5d41f9f850cc86f8fea",
  "3ec2cbcec99a048d9410c64a61796b0f",
  "e75f9f48ac684c1c49a256df39ac118b",
  "3518518b7b3b87f298d0518ccab65534",
  "d936105bf33a89e00fe8ed8711b732d3",
  "70858151e61f8862decb044c2050ae40",
  "81491684aa39d20b064ceff099a3175b",
  "bd73078b5a0a3a6d40fb1376347d64a6",
  "9da1f6dc1bc2ffb5ccafa14a04ff5f84",
  "a5c9c51a8981234ef59a969e3ad147ef",
  "c105573b4d5ef469c7867094b4e589e1",
  "d479c97efb06a112534196e257192c4a",
  "fc7b07eb35cc515c1beb93aaa4e51a64",
  "83470666e83e382a35d97f406f79eb70",
  "e2ecf716fa93c1e1764a8e584cbffe04",
  "534a7c131ee92bd5c9105cd293a9fa6e",
  "5afea20e81c95d55e70bb0805158d207",
  "8bb0ebc08bd51a0f62808c76005d5d33",
  "c689312f4c99858ba414b63b61408f7b",
  "cf1636f7d96fae80a428db4dbd93450d",
  "963b816a27e6432c8200f35c11cb3d18",
  "2dcd8661e650a8efe99642df35e1c0a4",
  "2f6207c7ae99db3da286ebdb98b10f60",
  "b515b746e01836e24966ff679f9dde6b",
  "5b53b6ca7982077b891b03ae9546984d",
  "4c57e9d52f8e782b44304f2d4613456d",
  "7f28eb1a0f03dd38c73da46973299d00",
  "997d1c07005040126addd2dbecc623fc",
  "817dbe3e415b05eca731e27ca792adbc",
  "ebffcb6fd54cfc146afe9485884b540e",
  "2d6394332758bd5411eada08d85af3d6",
  "27e0d08eda3a775290e0962483fa5ec8",
  "d444cd632037609ccb972ce79009b16e",
  "31c0453b13e1dd83f6ea55b7be54da15",
  "aa95999a313b3794d7902a751ee77c05",
  "cd30f6386d09f62f49537b2d23ea713e",
  "149a308e31876049d76b7393512451d6",
  "d0d4a7c2254d9f8c18668c103a3d7f82",
  "1f822faa98bc97d382fb28019730daf3",
  "a59e31843f29f63c8ec857084fd91161",
  "e871798ecb332a9a082ab69d747c624d",
  "dba105cfd9294cbc4269096d9c682b89",
  "c9cbdc59fb3afff3051b33788d1e946a",
  "890247b165402b325ac88212b21e4e42",
  "777c5b13c598663f136be27451b5379a",
  "888e851163704b4fed2d9b82e51aff16",
  "3069f2cddd3a17dd655c61372def9c0d",
  "39ae3b6ae2e9ecf5f0c25eff8d52ddef",
  "058dcd07dc12be85774e7f72587bfe43",
  "522c5460f239de773cdbcefb4d55b129",
  "c6b5babfeaae6d7bb86c1c2b64fa1b56",
  "fffa674d8c9bcb251c0ab3cf9d7aec89",
  "7aabad234a1f9f05ef6c5fb6ddc15b0a",
  "9b3ca93cfa10b081de65516d67170e3b",
  "1990bf44ba11b087af262e017d8c823e",
  "072e4bc6ef0ee5d9e7c56dafb9f65088",
  "e2825a9231a65676a7b79b648fd94fcb",
  "ab864a28e6eac29000429a5536fd9cf9",
  "decfbab07f8d11187365c385f12d038b",
  "1f0dd358531e06187d33964d0e0e115f",
  "acdf4cc64f0c62013621d6ebc69687d2",
  "6827965643e24616e892e5636f1265c9",
  "2daed5786790d38ede194d351b383d46",
  "eb05cb49a9e01e2c0a1329c2d1859394",
  "83065746806dbca73e787939d359e74c",
  "0a318bc9d7e2d4d03a96e755fd2214f6",
  "85421302d14c37029512ab3e848c4498",
  "02ee794a181044b80588bd14f76ea4dd",
  "abeca493fed89cd65ed112e069a695c1",
  "e5828e0a11268c9baaaac24bd46d1e15",
  "e0a8b89702312967460ad9940aa108d5",
  "6e5c8f2aacd19e70d15be253369cdfc4",
  "eabc6ce71e74b5b48150ceda5a916948",
  "5c263ad8e8dc1fd66e9b35daf7f74c48",
  "030b2b56e20c53b75191369104b9509a",
  "1225f4418731a8e7944d1366efd89234",
  "9085ba0fe1c64c3dce45708de32c3440",
  "49efb746a4938e7da19ecb3bb2c8e1d3",
  "833095be66f1f7b5942a817846c97ed5",
  "28f9f64eba29e57a7bd4bc0840aedf90",
  "9b5984b93bd951a70dea62942634c009",
  "ddb73667065d5ab761612be590e339e5",
  "59c4b46e73c2679610b7a4e9b3a04bc1",
  "fcc2a983de8f0ebb193864e0c60a00a6",
  "af8f1f4bb88555d688508eb9f3c876ac",
  "814e087171d6a45ac4fb4a110e889a38",
  "733130f693a1c3a24703052717330807",
  "b319f375927ed3f197a26c1112df86ae",
  "ace1c7e7c2ffcfe31a042d2b9ae00905",
  "5231c151c22b31180e900647fd5097ed",
  "07e7238f4f3d8b3a279a2d9f78fa8b08",
  "208b1f437aac92a96eef5ec9ca5d53da",
  "3a675752c5faa15bd61c63499684c570",
  "efa1debf8fb84e142c83c0dcf221d247",
  "d940ea701a781a4ff62a99d831c2286a",
  "d88294e690a6375d22b12fcc88bebb56",
  "f209ebcae30e147ccd9e42d32cfe33b4",
  "fbf1e18620fe5a9c40a65cbbd50af177",
  "4e682a50db552d15bfe109a1147f6770",
  "407b72260377f77f8e63e13dc09bda2c"
};

const char *SHA1_sums[] = {
  "da39a3ee5e6b4b0d3255bfef95601890afd80709",
  "c2c53d66948214258a26ca9ca845d7ac0c17f8e7",
  "6929e765f6bd128088cdf81ba4805d3a84da4e5e",
  "93ef0dd827103681fcee453b78be2ff14e1a261d",
  "9f7ed32a201bab6d11f7be88b9335973d93de3f5",
  "a2b847dd0e90bca83b418103baa63c67c85b5a30",
  "ee4801c9d009963ac6dda49b100f0d9a9f3983b2",
  "0dab89aa7606af6df94d1c3f8872ca98440ce299",
  "2eb3456b1b4fb96df1309eff21b02814663f939a",
  "30b59bc6c7c1622283a23950f2984bc5cd4fdd51",
  "4d39faadbf264f3fb59268228994276c36fc3172",
  "8312b76dd9300bcbbd9c5148461949f31f593bdc",
  "0d12bfd71a11c686cf53adaacf0bec05c557e768",
  "ca150c0c3372de80daa720b7d4081022b7befbe4",
  "d2ac2275af550efdde0aca4713835f3480498387",
  "07bb8c8ec36e16d57141fbf95fb8478a668b451f",
  "6ad802395de4400a9892c9f65868879bee5d1bf6",
  "569c7018c812f0cc51c093dbc026baebaab1eb22",
  "b8cfd76b506e7aaeb55c3d4e73e8868df8c4dfb1",
  "c519c1a06cdbeb2bc499e22137fb48683858b345",
  "3e3436a073e72c5300cdca6ce5c321e49dfc412e",
  "e2b72fb64787db45dc11bca1f194bef40b5be347",
  "52f4aaab2d5f9bc918700c517253e5bd6981ba95",
  "001233b5471e0bfa33f8133cf3cc3b97351033a5",
  "b2cc1f24e2599121adf86c5161dfe43fd5486985",
  "743e27565bb39d4cf6cdf7b19450f94ef12b2206",
  "6b57e81439c46aca165e5eacd44c0829670c9bb5",
  "4bbe681b61206e8689fce488662e7be67053ad03",
  "332ffb34a55ebf0b01beb604bca729887fd4c047",
  "b09b432ae19ca6971bb28a3705c9be3b02ec388f",
  "051605798e587fd98b428b88077d015494978bda",
  "33d579648c883c1b3a2ba91b7d4efd79d2d04e65",
  "d035de80a23137cd473991fea53b6b1b1f22e57d",
  "4ed82184201c1063c9f89d83b01d277e2db0847c",
  "1477d62ad76e1d543380ce2f4253a701fe039af2",
  "df72568859f54940e93ba5ace28430d38e4ab10f",
  "65ebceacd76a51d7076728d8ecbfcb1a4014fe3d",
  "0f5f0f1c642e616224d356a835ed3d054935608a",
  "caa9daf50b65b3739eb9a88547c516d89b72ac11",
  "1e9c81970164a681a35993d773e1d55d328ed64b",
  "8aefdcfcbaa21522fb39162d7507492e47b30f25",
  "a374c23022eea446300e1b3303272bdb8f6cfab3",
  "f2f38c31109f8a9421f301e9d554193bc4274a32",
  "2fd4e1c67a2d28fced849ee1bb76e7391b93eb12",
  "408d94384216f890ff7a0c3528e8bed1e0b01621",
  "22b759d30862cc7c7eb3ce9616a9d4e853b1e14d",
  "97e2821bba8dbd62f7823b7ecf095dad5d152371",
  "190c9e3674d72f3abfa027a38a425de21ea124a5",
  "8a9f1acbeb7dea1bdb61c0e5885043caa84c3812",
  "8431fa593176872aea33d2ece77fff42f22c409b",
  "08efef7adec17bd8d97f24cc373bfeab4b602d7a",
  "669f7e46d635f02a355635d9a09bf3bf2936bcf8",
  "695ed476d76f489707db6862a6411973d0207558",
  "084ef870fa0d4674d8488040a3d147235cfcb50d",
  "2a7d533528fcdaa6795ece88ab526b3e077f4f52",
  "4546fb23d600a7e358edf7033eef05af19b4fb1f",
  "59c3623fbc8c29341481a7fead82ef6b3aa43d93",
  "806b2e0c9be4502325b23d20f085b6d8dd8f559b",
  "113382ddaeee3a9880b3328b4240ae9e750be3cd",
  "543bef2867245f702b77470bfe08350cff1090ab",
  "977eb8d9219bae5415e13656113e30d66c2f5b45",
  "58153daaa0ec2e5f3e96879a33aee162f0c1283c",
  "6663fde567230f1d0247dc7ea3144b3aedac160e",
  "b418a310c03a4795b9ed4577c876b9dc50c18481",
  "75c2add8fd09dedee1f2728426f5e94f9860d062",
  "3f188f1a66fd317b645ea7eecebcae844bba9944",
  "049296261ba622294ec83fbe8f5cb0d2cc3c475e",
  "c60fe6fe0ea55fb34b3b5e740400c495e305597b",
  "64df347932a61deb5ed0e41e811d24cdf745c7a8",
  "eaaf91d87507541a572b693cd53cb31a4ff3ac2b",
  "712424206790276862399340047ca6d6028ab2e0",
  "2cc40cd0dd42274998746980844a8df708a3af94",
  "da0ba0bed525b2a41d906aaf078f7da4c53bfad4",
  "ee16dc82f66d8f069d83b76f1c433d658367dd27",
  "64fe9ccff8f5235dd72a85e6c7676bc091f34038",
  "20e9001f77c5454f9b9a9fa681f40067e4e1b8c2",
  "40cce478fceb688eea9d9385f00acfc73ecb2f9d",
  "21955259821de3bf9de7c8708d7a4d037d244c92",
  "b922eb3c6a86c38717535220cbafffe3032803a3",
  "be386c5615669fb19a05101d90df850569a366a1",
  "c733de72b09be501a6d8555a51bab2ca9d65b203",
  "740eaaab9d5ac5a9854260b09a1127c520b7b27c",
  "0b3e8e2cf27e492dfb0bfbe9b8d6a3b2e2bc17f9",
  "2516ba614aced5f991fc2f67e66fa90f3dec756f",
  "5abe738e94964292a2bd38e6cf048138bb593fe4",
  "1c5d0b73e977edfe89b447bfca585e8826b5783a",
  "e3096837858dc2247961a29fb59164d5e39d8cd1",
  "9a6d5ce05968464a6c00426a5d18595e5e0c2534",
  "e74f03f5e56d5a9926c6f6351fd8131242a84ef1",
  "573b84daad0e7149c3b128f65d75120095a1d3c5",
  "5facae19039c0444d188729f5eeaa58440b55d7a",
  "e617e14b9abc583b5e31b9ee315217cf52e7053f",
  "62bbd3fc168a7bbd4703fb1778d72214115dc200",
  "f9fc375d30b5626eced981d4ba80d2fcf6fba368",
  "01227f21040de0e7be4979604d23aaeb2d220d50",
  "1e53d5126a6f21a5cd9945ce4ae79a856d1c2aa6",
  "def7d9867c9ed2bcf49984cbe78066456175afa2",
  "2e1fc20df269fd7c6894c61c01f6fe0518029d38",
  "5d6c196729f7c0eb0850bd9093d0a018b62168ba",
  "062b7865763fd8cd0ad6079ec51a97c1bc35f88c",
  "4630931b71697d8ffbe6154c45be34251811e205",
  "a09166918a47fbda6c96df9a83f2e3b0df9057dd",
  "036e1c39411e8eb6fa3d616fcad19f92188de807",
  "8e6aee80cbffd0c0a3895a29bb029f57e1d76aec",
  "483a716335fd7a07acb9a8fdf759add85cd55ffb",
  "b1b1d87b55275de0f3b9c1a759ec6b543282cd5b",
  "cded9ffcab1c2fc873af9650ae35004160b39410",
  "37cc453cada7173368bfd3ed7c86c053557e5926",
  "8538eda858022257c393f2b7d72291b2a133f452",
  "d68841c1696583e487cc09a4e01a27afc4753bb9",
  "c29fa22be5cbc683d781ce42d325830b4337a62f",
  "28863c5a458f53c87559603b6bdb2e890ff002da",
  "5e4e15446aeee7ea6989e2502b20b1278ee81768",
  "25cf8915d7e4510f14f83d5317e6535d6e473bfb",
  "3e602c716c72f31569c1ead4ca6b8781d15f9866",
  "67e03a7960ccb911c4394671aec77d22f07cb495",
  "e2b3f1d1f69d2b555083899700cadb4a971349b5",
  "6c423e4662e730b3885e3375ee6d914612d5867e",
  "1694013c7d8caf3b3c577c8024ef1c58f94b7955",
  "91630edf6358ff0411a23f0a95ffa693bae1323b",
  "028454e0ff1e27ebd16cae59b2da633d377204c7",
  "0d07cb105767718dcaf998f307d4a97a38b35dea",
  "23c3569fc657d3a4b1bdde834df0c8f6ffacab11",
  "73c30d2754cfd13d6ac47ef28af974bfb021a121",
  "055890aeb6273f7a6ab5176722418048a03d3461",
  "3b89112c4fdc7e3fb8dded5157ae95c6afb68da3",
  "7cb3cfae1db1575b52d02afd3d12f27fbfd6b56c",
  "a310e3d7c808c74a9a2dd611d0bd6eda1f5f5340",
  "f329178028da5004aabd83549936ea9728326736",
  "5578dbecf4f35c97fc8762721ae16e010e42330a",
  "14020d1fc290f5a4c1feb06d970b395aa2d60518",
  "a1b2ffe5722b3d68d3dfbd1d3135c98681f1b480",
  "f3b3996a94517365815ba8bfd31306483c453afb",
  "cba0a45d7202f78c1e1ec5f150a1361df0565553",
  "dbe1feeba6cebaa82465ff34ac85324eb99bbd96",
  "067fac1d8369638e135bebaa5fc24648efe539a4",
  "18983e0eba9f797a5602dacb9e3a1fdb1b0e5b8c",
  "9f5445a4bbfd237564917d8749986798d61964c1",
  "79025990785dd192d5732f072e29a37728a05109",
  "a7caf5831836aef6ac5e6726a05f807ac20bbebb",
  "23027cde1334d6db48868b8dadb94cd027b9b7bb",
  "d0b280d64748bfc59a7da25bf640aa2d5462266e",
  "8a9c5dac4ddf028916e6feef81ec0cb670f1e713",
  "3790e9a57245215e68c06879cfb3d49ddf511f11",
  "a5004ed91303ead3670260a0e682726c42cee57c",
  "23e829a6706142d16305cc8f7f8c8b9bd8ffc040",
  "7e592d0d2c566b32b7c1e44b3413354cfae15e4e",
  "2e7a1685959b20ba75ddbce3db38798fc18becab",
  "82218944dfd3501a3d4705c5132ad06506372a0f",
  "ef4930e12ae3838d6059cf4990c8a0c2f6669c59",
  "574f7a6ca7a130635f84701294f347ce26d2d586",
  "5c91c2f83ca9daa19786263acd958bff2c79ca44",
  "65d838dfb75cda0055db5fb03f12008ede246a3f",
  "3c29ee4da5392eb1bdc9eb39068ab6a870d0c16a",
  "f17a673f3438bc7d8e0b0b22ccf20e4b868f0ad7",
  "653bf84319d61c7b41ad67b7648c8ee8571b6a16",
  "3187b6d0e15a37687fa6a8683d54e2fc5c3a13da",
  "4c29e4987613d1b30fdeff0a6af7a91b3be543f2",
  "ee68df44ba84a65ec112d289100ecf978485c7d0",
  "59283ef51d65bf7f7b7f430059aea19533f780b4",
  "7694f04e3be4bea0e35f95d4728fd65cc9ef46a7",
  "dcca8b27811f93142ec2bc14762593193ea69147",
  "20115938f5b50616fca15cc1816b28423c2e016b",
  "07b7e2a3f9733cbff1035533d0f2ba66008266b6",
  "cd2d04dd8bd78ac250a2adebede35802ad117110",
  "06e86e3d4a3f735c915a770fdff73ca8bc610476",
  "3014039565f5e568630f7e463c35475bdbe697c9",
  "eb729c4de8839c4123d0eb24d1d35886286ffff0",
  "c990f68c512ecc7c23ec6ff428d51300d6425dc2",
  "f3df0f4508b4cfe7e720f830f560c4e10f900703",
  "43ff171136ab1855eb37721075a9208c1de3ad20",
  "5d487b6bd25daa126e8edcb23f70a87ce4f7a27f",
  "84f6f72a57317242849131eb3c6aac28cb01abd3",
  "fd583ad477087f488eacd4ca243f1c93f5dac09b",
  "ef3cb487cb03dfde3a33b592c24dff439ce9b783",
  "7bd47a7efc8448f750163b07c812654bfadbe91d",
  "b9de6e1facedee977ccd4b30aea8fe957a0ae09a",
  "4ae009c0577ce4d0c87dcd743de9039ef050210f",
  "04280ea8afacc8b46982710da67a835b92275625",
  "ba7939b877ef0c1f066f0f6944b8c834f96fb67c",
  "bd735f759f8c653a215f2e9d2cc1d8a248a25567",
  "e9c70b7ab18d0b07580b80f2d92c43b11be5f71e",
  "795c10dada7dd963603073be205325324a1dc205",
  "8802f1d217906250585b75187b1ebfbb5c6cbcae"
};

const char *SHA256_sums[] = {
  "e3b0c44298fc1c149afbf4c8996fb92427ae41e4649b934ca495991b7852b855",
  "e632b7095b0bf32c260fa4c539e9fd7b852d0de454e9be26f24d0d6f91d069d3",
  "3bff939c10f4d9bc21c6944606bcb81901cbad80fc6801b257fd8aa127881687",
  "b344d80e24a3679999fa964450b34bc24d1578a35509f934c1418b0a20d21a67",
  "103c5169871d49be7a2ebf9e6fe4720244cbf1fdbccdbfaca489898ea069504c",
  "5845d549b3465df3c1fe755ccd99a9252858b448fa85fbd29139c3a33418a9ba",
  "2363ecd70a265e2233d2b8b0a703bcd6aa71dbf47a8716fcdb4b35ac4fded6c7",
  "883dbdc815a382a8ac863a990b4a33b601acfce6286df588b1e10416ca9934c1",
  "10ae0f24c936bc39be215f80c343c6e870f640fd56b0aeb842c3cd49a4e6dfa3",
  "3ba62773d07dd21b5712a1c221207bf2f46e459d862e7b7062b3b9e0073bbb1e",
  "1a90011d5a17cbd702ea49cddd28190439dfeec1710e0efe52315e034ef449bc",
  "030b6b1f71e51020e7b34f753d26741e7ed7c5cac3324b4fb237bf7f190326a1",
  "a83b8899ae591254330a059b8c5c5a0d61b8a5cb1e20cd43cf62ea950861a108",
  "8536a46b036db54a1f68389081f4c5dfb36c005ca655c0d005ade052e074fefc",
  "3b6052bcafcb593a2b44229d6418f3638a1040ede220a06186948e0bc2378e10",
  "9bc94b608c3636f6dbd12a7a08e586f2529c1910465cf764e5a2a16260a15c3b",
  "1b0b70a113cd4065b095bae73fba840f3b93912e89dd535f7f795912e9b307d6",
  "33a753c1d23f6a539b55c5c35dc0174ae048bbe517c701f3959495d509b862c1",
  "99159403f98a4d80adb6234c336029f32c17efdc70f1d412b7e6008d6623f3fd",
  "5cac4f980fedc3d3f1f99b4be3472c9b30d56523e632d151237ec9309048bda9",
  "b29d66e56ed90cce9b0165c43fedec612b60a071974d8be4513e18580d55b5bd",
  "60985d1eccaf8f3b95df873307d4727bc7af67dedaca6ea3d00d7e80dbb9d95c",
  "0ec4cdc3ab31a48025746379b070b1af6b152e6dd1eefe8a16d1855c85711d72",
  "76169b1e79ed4d640a78d664fdaced5035e7e0f116d7f044169763763a73d6b2",
  "cebf42910d175773a31cd23fc7c08eaddba11c267105e51688728efd6152f798",
  "8df831769cd51e4f57808343603e97c1ea44fcab46bb595a5000b9ad1d03bd70",
  "4e866f068eb39bb4465a3185badc58f8be565b3cbe0d8e79d0c893dd92ca99ae",
  "4a7b18fd0454f18d0ad320d8cf874e0466490e327bc3ca3beb13b1cb0fb01fff",
  "a5e86ccb68457b2e8e5591e3c132ed5f824480ab3b34e8b798b1b4e955cc2bad",
  "6c007ec72ab6d8bd1e7e2b90ab06095d38d042c172100b5364687985cccb71d5",
  "588f6b03a29d124ef050bc1e46bb60cd983e3d75bff45b6f1438cb58baaf1a9b",
  "ce32c090e5e13b6e5967e71e0d0025ca61fb6bcd54502221e354535ee7504fbe",
  "5f48828a7ecafc69180e8e9607b277b3dd17e53acc043412a06d8f170711c74b",
  "2d79fab9bb7d5b49e4c7eb28c14334f9d014129ce43d1252636b23ecaa569771",
  "acbe47d52e08dc6ae67b0bc249c6fe92c2fea7cb5d168d089bdb4e5f012a70dd",
  "177264d66f016c32fc7a4bf3d6a18fe64f3b92aa25dee9c3b84e6e2d3dba2467",
  "41555a329cd561031b7f79aa7ffe614aa341fa4c8f67be9d3169ca02ac513951",
  "6c450daf0a44317b850ab800b2986e3bfa19b118d82de07331c59b4461e08bb4",
  "72a0280b4079082c4823f72d5847038ca4b3d689b8d4de7f4b8565ca5cc59ad0",
  "e79df309e6b0e98a1b677e5d47765063170fd0fbe136d305230dca2ca1ade525",
  "119ef8154ecb9f78200ab9a95930877811261da37f9cad9e533ad34a57275fad",
  "fd535438ba7bc96dc5aae8b19059fc4307c0e2df4b252dd0d4d10dedd3116fd9",
  "677b9fdbe2bd79af033c224b32803a77dd284885f8655aff914ac63fb65c0a70",
  "d7a8fbb307d7809469ca9abcb0082e4f8d5651e46d3cdb762d02d0bf37c9e592",
  "ef537f25c895bfa782526529a9b63d97aa631564d5d789c2b765448c8635fb6c",
  "88e197dce3e2562b9fb62bfdfb92c525328742af370fa2cd7c7bafaefb38f09c",
  "6e186b825513e046ba1d030f5bd31caa27a486bab8933e3799e8fc8c7a0be919",
  "ffe66f70564e2ef5b55cc4083aa1bbc24169c799a624d98182f99b8a7c950a82",
  "381ba8d74f62ef53fe4d22511c9d7c9f182d719e8073a5ab0201f91676a2ee86",
  "0147a26010960f5db71fcfa15c6f9278f2556905aa9fce122bbd5fe787e3d934",
  "fb736023fbce2dd88d6eeffa02dc975f5b3cfa0d2c0641382ace3cf92975bda8",
  "7c17ff3bf15c19d9a78f5c3f60dc38fab533ece520c8b8c73fcb0fba670c76b3",
  "e32271566d6a71b90285b5d00447d1f27737d56bc14b17efea026c78e27af416",
  "6867916bb6e48ee4f3b3a9eb4630233ec89fcf3722ea429ef300139d74f1f18a",
  "5a0e44a7c154b01f19a6cf5d83d8ea556d17ba1ffeb05bfcacdb7c477dd1c912",
  "0e9bc14d279f681c01eca319b7c22bf6e313186865a4d2111712f29ecc0223bf",
  "1be2cb604f04f8538e1ab595dcceccf0b838041e72a4dfde8df53d84fc841828",
  "0415d70cae1ca48b070e789748e8f3982a209a0c4b8070e2d3a26f729f04b0a6",
  "0e29d748b4cca4b372d587ab8164361aa127664635f956fbbdf076c36ffb0c9b",
  "8b0ccd3d72a10e396b16b67980f31823972b7114059d0d780b7c6c1d11aaab73",
  "7105f8ae45fcb1a1829053f98681b526616e1d6028d1f72a6a0cea1e079c2aaf",
  "5ab206331d14b2216b02eb0a58388e8209ffb396bc54eb22a47634cf236a03b9",
  "71daf2e02b4b542a8064567793b62fed41f2241dd284163b15d02d279910e1d6",
  "795a664f3ecfa5003b7d18e8ac44d88ed49a8ad731238e381f76cc72451e5d49",
  "0d01316239b68e707e8079f02588bba156906aa0a8b328a2103f3dbe79464272",
  "53798a699aaf9b5992322e27a7c48802ff41d04acc52c1e6657fdee037f9c0b0",
  "250676ab47b392eaeb3bd8f7640c676e5a9fcfed22dc08948601c68d7eb867e5",
  "c8c295b3179d555b5e04c82f8834b031d4dcb5df9409081e6e9b23be4d1aeb93",
  "a6265afb2182630750a70887a35072908c048d5f9c831a2155da1887f1dd7709",
  "78ba265740cc1335d27530a52dc456668c9475250d83f3e1c3041ab3d0856338",
  "490b607d2009507689d5ce40f964e9b5c56ee54d13d99666eec256439a5d7691",
  "012c3b2137fbb69e1b1457499923622d7a6639c3fcfd0c1889de9f1ae9a5224c",
  "47f57d4c0eef68f4b14a02295da342bba8be6ddf901ed4ae1eaf7c3306672593",
  "33eea677868305f597087e15be83723efd51e1f55342dac47afb604579fa0f74",
  "f9aab1fa5ed80cd385cf625ec808339d819bd1faee979c3ee008db68db19e6bc",
  "1e6279781c1a757c9cd3aaf2665c0c1d235e514065f57dff455256896313c5ae",
  "fcad8c2b8ab78e1eb313f9a77b85e29ed86d4468d78e845fe7b197cff28889a0",
  "0cc46a7fba1d7b1e7a7c6c438352fdde342c573550eac5a177e38d0cfd854b91",
  "7d64ff1a21b7194e2a34f718bf536f4fbb636ea2d50b9de9423c1a64da67a566",
  "624097dd2a64d12dbd7a9d15d58b6a31a8c11e0be67f20afd388e61ab316d6d5",
  "c10ed525d528079a6ac6e6ebc51bb439a48df167c6860da2dcd8ef5a101a4bf9",
  "b9ce9b34346f2d83dc60927231c14d1af0b1a915514d610cbdd69a8928ae1b57",
  "4a3194983f551da64720e60b91e0bfcca2c5f7277b97ceb813b6665cbecf5078",
  "cac95b35edebc00cb109d4726befb06adbadec365e102f8c9c024fec2efedd93",
  "bd284ce312ff8f71a8fffd5737733c72dee0199eb5d9dea29875b02fe7dec138",
  "888f4d527281b7ca77fb63651ea8c28850d62f38d6918a178bc7de7ecd61aca1",
  "50839952e08506f523696a35e758eed06d7fce0a8e4c079242bd15b476dc2632",
  "ce6b0b2e2494ba591909f5971d4a326c395f47d45ab2389fc5980a8d7c160373",
  "328524b5f7c5de2b6fda754cd634480d2ae9953514e208d93c7b0493de3c376f",
  "00e6bbca7e9f230b903d0029a603831688e37e141d283a88ff65f8a8de711214",
  "e9419c75509f476ecd71c0ce5de42b13b70665182d470dc6b9389992e71ca610",
  "bc93bf4ac98f5e62a180219b7cae5fe4b1a33700d1abd8769310f1b9c458052e",
  "b59cbe76a3a993a8a5e93e7fae2277a99c52b27570f8cec0fc27c6407b87a863",
  "7b977d99df79f3c123a551339a3584e1dbf8c6b220489c94e8b5ef241a2f4f32",
  "42da1a65ef28c00d30b63128ad839782daf8437da50eaedf9e40c05daa324030",
  "27b7b244d0a284afc02b21ddf8818d4934bf7d4a96db6c9be02b9a29f1d3e877",
  "69e8ebc88995bfb9af4938fac297e7cc87f516d91ee3db9c385051aa67bfa291",
  "e97ec334ea0e600801845a004cf943282716e537d2fb41edd3252ecc604cb868",
  "61ddc6c83fcded7492a0b4e6682a2ec54ea79bd832ffacebd13eec490ae9c513",
  "b1b2e4d6d5f02ab694d8be129dbf9f7fb345190927fd2732ab24e395ef877a95",
  "036d3ac977186da97d849ae8706f573bae36822a83a8b820b0b09bfa7a4fde52",
  "244dd1e7818cc1fc0b1790e5bdd79df79720b5ca4b30ddfbc6e03d2fa80edf24",
  "025dd4c8ae7d9f3aec6b2e3014eda38ec54898c67de9ee68578ec7cc8254c345",
  "e29858f925c90e19c49336f52a8acf57e7a0f10fbf1b0254ec9926afc77d34dd",
  "e6ece3c684d5874497b83f6b486f0dddef4377f914e19ea717b82426d6ca37e3",
  "952c6da8834e0c4c127269a6e69c59a23af9e35ed70577715979075324776eb0",
  "675a0a83882910ca29d9a4b72e278afa307a2661bee3f28dee7faa7db73dde73",
  "4102eada32bbc31c13f1fbf2f039bb7a46bdb3589e9bb3915046de72c0c2ead1",
  "305793f522114ca65e243f80b82199425286a07585deff0d132223506c54c48a",
  "c666ec59da13eae8361c08bae009f114641bb3bed6f6c88c69c888ab9b9bd2d7",
  "115ad98815bdfbc2e9aa0922a63c530f2f49bb36bf339345694b6cfadc5a25bd",
  "1186297e299b427c8ce24e20670156fe85eb9102f8ed7104154fbd10ad28b49a",
  "2d02d02abca735d371fa9fbe2ec1fcf5c02a8eb5186140b849d13d5667c8588b",
  "c8357ae61f0c6107d48ffd35b791f2a96c36d9004acbf97a7a6fe1941096e74c",
  "e2f783571644ff40bb649ee1a6c7481e288eae50bd9621c638102c1222f02695",
  "b057d8b05d77dfd016c7820ee32b3dcf8c0af73f79a003a68f7b344bff5f9489",
  "f98a7811608e9f78df7c1dcc6765ad672d907ab49e3ab756b6ad2ff392ae3cb0",
  "06727bbca9d6e47cbd4e2f61b313627cf0489c5f84850dfb45cb496f11e0d880",
  "62e011d19bbb328c57808bb4dcb1fd25551a642df179615559a654e91b233afb",
  "18811c3a1798f207c75d895a6deb4b2ee05a27749e5d4dab02f5299f8f62e43a",
  "a2eec6a9e819ca9ae6accd714273210cad3a98ea104661b841b8b18fd695115a",
  "b745658efb45b83211abaffe3af0e5fd3769866d154194c9078da9491f793bae",
  "bef6454bcf2dd622f73ab849166a95f56be540ff05cc2b79412f40c60cfec3b3",
  "13f42a4a6df75f6b09a53eff4a92b824b8212ce99b54169774958debe92ba00f",
  "f6addf5f0a754434e6767535ee8cd12a57d3c78eb5925d421e43870ddc0c4b02",
  "abbd74e4444bcf0a33da28cd9b74483d19c07c0c84c7a217ed1d8d143da44c4c",
  "18c5fb1bfd33fc27a0b7799eb14d502e8b59acd5da0be6f9a7fbabd96608c61d",
  "91a32360bd0152180990285fd7cb3145207d33f866c9d99e7f8bb7331a12d03a",
  "3324ebb8bfd51c9ac3f3994a56b7e0c0106d9d938c147edb391a4bf812d6afb1",
  "914e88337910ee43d63f77d91502eebb35ae38ac6138bd7af4d879dbb730ac85",
  "bc73865737be6195981507338ef06ec2a5f34d3f12580b4f89d5e28ef8283969",
  "0b41f57008120081011a2ba580d8cff17f9c1f3b2e811359cd3ecfa9b36dc5e9",
  "a1702789897f4e641bf00d505549c6dc9df9daf904f3267e0cb583c7fb49e832",
  "70737787a53182c78152e845e0d803171d27105c7ef9407b48ae51280b0b1ed3",
  "683a017524f641b4c38c26db0df5046fbc38e30fbbe7fb7a6804e2e039c9d353",
  "8bbd8c3f3c6911a3e73ba7a480f902a95fdf4c8a7c554b68e7330e4914481f15",
  "66e62f07828e8a8a6ce821cb29fe34f2ec551d4422b593380e5209ee4a3a3e57",
  "2aa054e91da4874329ac8946922323c8d5b114b4ddd714f54cb1fb069dc56646",
  "47db1856215834b20d70031695491a4a90416bac8d231646bba8754585f67d08",
  "eab539981a22c36e481b71d2c828b848b9b127963d7b5eb56c4903f5cf004296",
  "cf43ef0749885e4108f8fc2774a840264980e4f2be51d1c803bbb90965745034",
  "fd6847b7d5ea924beb8e7d43d0e87d4866f9744629f2768cf32e7f37efd23253",
  "1c3d53f1a7fe78c34a4c33331126375e57f4f8f732d39e0ff550fb717e683724",
  "f03b454c7bf5ddfe083798a85ac46bc671ef76b381b969ab4f333c74397693ab",
  "0c7255ee15ceac49e1281447b159ed1ccb8fa09d3d002fe3337c80f75a247b86",
  "4c69c21e1afa642423a660359e058c8d6a2dae61c1083b7dea46471ebf24f0da",
  "b984e785026dabfa52ece12495df98bf80ba831ea316c08fc4b39c5fc00b50ed",
  "40b33b1a89820917e19e95bf5abae2121b8f200c826a3559440010d2863a5acd",
  "053de20a192f3205f46e3f68d8b9926abcf64df55d01cf166e7f8e8c8d042487",
  "ababd9164d854d8a7b56fc4e6980dbafcd5aa017f5e2b5777a6e6e47460fc716",
  "f3982fa10d2353163d644ab33e2c5af7264c0c9c8b14cd88d91331b5d01ae3c7",
  "0d7c2df609dc5c44677d62b8839576b98ec78fa8b5913add17b7e9cfaa6aa75d",
  "3b86e1a3a4e3cf19734b693cc3d9b24d4173b5e8ace1be3daa303755ce8d5737",
  "dfcdb86a6ec326f0f4c8b167b5945979a5cf3a2ef20970c47b46ddd47f8fd6d1",
  "e2a696a14922cdeb99abe04a66576e65142be3b0e53cf0c0f05c86acf63bc83a",
  "780646dc52688aead41076d4906e17b42eb5593565f179a6bb5135143d40d03d",
  "847ed344db2cdbfb7f69f9b2c9a5359e13df72c2485345a80fa9b114ec7c8c03",
  "a4f5b2a505437424c3382e2d534ed2fdb55af631c5b211871f2e62acb5dd722f",
  "e6e8883f5c8d840d7895afac181c6d9fb154672fb2c7ba9757ca8528242bef64",
  "c89e7de64979fcbf929148c7b44322047e820219854600e88f7a7ce805971c38",
  "591555d8d3936620ebb6be7549ea9eaafa9e6a562b9ebbbf4c04eb4f926d5060",
  "2ec1da3a8252e21834db7c90077b12547f70890b853b5b269a38f74b421f3a4f",
  "3b05f141c3855409941c6596a92ea7a3ab59764bda3cdcc6812060a5e5d1f48c",
  "82b21ff095df092358450698e7a534453105014f3b227a210cb5d523191570e8",
  "229da5c29efe0885663587fe0080862ef52e7504ca64f5d6ff1c26f5a7b1c0c7",
  "cd3c1d86961be993a150c1126a958ef14a3e47ef21507492ffdee8b089774505",
  "e346ecc2f3e8cbcbbead67341edb971f2a9e152f8c1e086693dce431d9e14335",
  "5e5c06dc93c409e935b87373f2647f57a951118851b226f908751bcafb496b2a",
  "2f5ded0589de3ef9f5e5b05df0a19b02fcee0e686900c5eb9e3153ba3ccdf685",
  "6a0335f78e0fea8e4cdf747d6464f2de78e659b9de5be37ccf8f81f1e775ca79",
  "8adfeb35e7d07f4aece0f8b4b282a303e45b11c9b4f9b1798cbcf8cf0dc5f48a",
  "94dc98b89a5b498d7c7eb0fb0524af296d0181e7a4dac82c3bd7ce147019b52d",
  "4b2dae26d837294c81e00c6c28692235a9ea046bc8038ea78ce1819cb5f54be4",
  "77d9e99e3a956c9b52742b498b8811cb721ad798866d36d269b4b554a707e63a",
  "652082a8998da5439cb5e695104febfa81d3d3a0bb4dfd49120b82e350b48f6f",
  "43bf07481f0bc237e1ed2ce2b0b3cca1989f9bdbbc7cf1e78879984ff927b3e1",
  "648f7216f324f0a46648d757a21dc25c9382c64a095ea95b62aed37596bdf842",
  "34c3d02b75da5d2739bb8d4916110469e1b854a8104aeec7ccfef52a02f234e1",
  "0d0b8d475cb50a40e2cb999757106f4576c5b69176df4c30e1c4659de1468ff8",
  "63d7e84cef1bc8c74ebdf53fe795766f0fd32a9c6246586f8217010db1c2c9f5",
  "99525cf2ec889a1628576099f34ece6d60de03fa85ade70a3d0913033934dc1f",
  "8aa3e3cd4d678c9623caebac79ecd62fdcd15de5960c7fbffc3ab8e77788109a",
  "c71259d6ad975ada31990fb7b3aa958248bd88d3563b581959acf4f18310f266",
  "df3a0c35d5345d6d792415c1310bd4589cdf68bac96ed599d6bb0c1545ffc86c"
};

const gchar *SHA512_sums[] = {
  "cf83e1357eefb8bdf1542850d66d8007d620e4050b5715dc83f4a921d36ce9ce47d0d13c5d85f2b0ff8318d2877eec2f63b931bd47417a81a538327af927da3e",
  "b2396a002fe7aec008808687d7cbacb340b7f7a090008382f3c95870f6fb10415f61f5737c102d4bfec58fe525407ea2001e761dab1da8a501d9523921f0ec21",
  "11ee0d7b40a7a4dd95f63b8c2a9a36b77daee5ca7d46fb5cb7f871db29650ce9c78306ec1fa9c4075ad0615a7f9e63697dd05cf79cedcdecc82cade38ce7638a",
  "d1eb8fca18f1ed13c254f228435ba23ba203b42d6fb38bf84aaae54760a3964e671149b5d10317a0d3ecdcd0021053e6c596fb0b05c33214cfd5455d325ab53e",
  "a4b96da738e2cf6a3d127a0ec33725a6953aa44140ad820415aab4ab3d2baf67d7c260b36d3c6d479e85cb3b0d00b54a555e41993519eeb594cb7796eb9aecec",
  "c9401760fc70ce01607f7d635a8b71ff2985d543ac715e772c2252967537772392eeb9884af7a8685b099628df73650b05b5511997eafd0627c8a47d5f16cbf5",
  "f8243bcab27b16f47c58d10a486775e02eae948cbb650ff22e68e501e41b78a0784abfe67b2992d5acd0d5ee4b18e495870e1189e4e9f256066fb1e28149a97d",
  "dd8519e311bff211839edb8a822b6434e15d2c4e3beeb529d43646f7fcc710b393f4f7a6c928e660817e3fd70b280e9e7128a6d3b0a431f4f4dbef4b1527f35e",
  "c643d169d3e822e42f2b60d2bf48b36d6bf1d8d8bbd0c18fb00fa4fca79faa6f0d3633a0ce7a2fd62fa332712a45feeedbfd4c5cbdc30f743979aec79fdf6286",
  "bbedb9d77e386908fbce019fed3f8237b6c95b13137948844d68347116d2caf7a495a9f34af79cd762bba0190e1900afe3e922b5162ff77f265ccbd275718183",
  "b6084d61c87ea222d8f7506fad7b7250741f34ad8a075df75c18a31ef380385587474991c3256cd8e464c0594d45c6d1505ac5fd50289731089f86bc1bf4cd5b",
  "4f4fbc4b5702df96d75ef959d5aeb32a7c74dfc14358d79a473e92bc16f4848262409f35fbb2d169ce7b7f16cc9f5d661860c6393c0ad2a2b25907e177324573",
  "1548bfb55f25295008b7f6e11cfab72bd7b4525902897747b585e94c7dc4b9baaca57032e2139df5fc8fbfd5f82115327db42ee15b87052f679de6a586eef4b5",
  "51020dc906ee7a3fb202099269dfbdfc01e2a8477f474db279edc23b90da683de99b7c0c5367086508a89a5c76ad1ea8ed05456ddab592a5135497e92f12348b",
  "a7a3e5d22ab9ec75d7e15aed5742d4c83569279f2f9c61076ebd9ca13f3c8842642df2ee03f81646ac1dbddd29a53ef816a350e662977c73b3a051a56df01965",
  "c5c60fce714297d6ea30f078756b33b11bed89e69513ed900a91885c14141184bb32b65936cddd3432ace744bdab8b0fc46b0542cbad0d96726c5325ab6b148a",
  "29e6100e1107481303663798fa0195a4f56cd410f52087a9b877c742fdadb293473d91b3ad3a6606a75f3b8787fefa68e94f1129bad7c77f6df251fd5b82d96e",
  "bc26056e51dd3ee0747b21ba6fe7467a1256b81a595d4165e33b13810a0807b9c04b98e444aed600afff7bea013e362657090b41a10652d5d9dc8ce766f4ce7a",
  "40c4a4640176132297ff0b5db944e86e0fcdc823ea2e3d30265f9889edff943b63839451d783bbd853653956ae6e9763534270539deb4bb77d814fba5f56a879",
  "015e6d23e760f612cca616c54f110cb12dd54213f1e046c7607081372402eff4936b379296ed549236020afb37bd3e728a044a4243754f095498c98bc24f77e0",
  "55af8ef14b57edd35334323adac3fe07e7f4de338c05877f2cc94a11da5b4291e2d4c10f1ba7e1c01b20648e8c8dde2f3df22aaa3bcbcc888e3796b1118e6679",
  "aece539289caee7baa30fb7915464d12d4d2929acfcf0e12b1f81d76be8967a83b051801bdeb38a62eda5bad70cb98391d8d6767ff3f78900c18e26d9c829331",
  "bf08cdc2b15698e4cb5f7ec837a7fa3630a0acac52d866b9ecf7e10083d4913bd46afdc91216f922fbae5b6e58116e9fdbde2f41dd32a0dd57bddb0455a305fc",
  "5049280393cab13415d832fc7ac370e99dd413fdb7a71c213baaa98f8c45f84f892757d1b9ab6a181c84ba880b528768f32d907e89f4e0e003838c4f4f005024",
  "8d81d423f7c11167a3f016489758ccf4fcb45aa1c916566352f5a0a94ea565d8120c868cf93b38e2f41b16a350fa607edaa288017f541ba36b45b55262efcadd",
  "4b4c254dd0bc5c4a1a70900bc9eea84c852e11ac3d16f87f1d3aaff0478e46ee58c264d4aea58d2ce1b08e84bd7bbbf032e99521f60fcec637abdb243977dd7c",
  "afc85167cf33d21418e021a4946801b91bc103c8b2d4a53e01b2a237c293915615b9f2504d117399a4eec2578683c91304a608745db331a2dd7dfa9ccf7352ef",
  "a435a6f9d0bc4b66e3b62becfb3ea1cbee93b78707847e9219bc62327d9d8aedb48b765e99f5d6b334bf76aacb879d796b998b855bf6ee7db826ac16e4da693f",
  "bab93872f631b5dd2be09ef4aa1c80ab92f0f3c0593c901a46a04fd2a19e8cc36fa827380da7fc663aa79e2421a6256b5b7106b15823ae49e674950b94747883",
  "815fdc6d15a1ab485f274638d92442af5ad5db11200b67180bc29dcf70e0598255503431e13c7e6dea4488402f112c4574ca93df4b8b0e07f28ce3d5ff64393f",
  "ad6f2a6ac5dfc9ed273c1e18f2d16c14221843ff9c2092a30108ddc127cc43c3252f821d599a5d0bb3e66eb40b59d3537ff5a90f3356f78b7075bd9a671bb30c",
  "b13effea3bd3444f360ae4aaca1fd334b23a46a9d8ad64bd88de51589b80a745f794456e612921be4f4e819cf2f7661241bcb2b19afa9917ad87802008243f8c",
  "afea68e278d0da3a9f07d0591dee8acee064de85ff63644f2da7e92947e4c73fa7ad2db9b2d2bb1d0b27fe16cfd274d3b230d7fc89c3159be40a8e5d2ef1fc5d",
  "ca148b59a34ca4c558ccce905d557babdfa9eb8264097cc50f230d3853b5139838b52d888937e0d1de33a9c6bbd11fdfb0eebb7f805d2c090f0c4aeede00df49",
  "a73db6aeeaa8ec452aad71bc56da4467d4530f67ede3cde54bbab5081e732c76ea550220125fdaf4fe874c448fd7e6400f5e1a80c3ab4f733bbeac0172a833e0",
  "282a28dad323190b3d2f11035cca91fdeee4a7b0c5606e28786055c5ad96dc03ea7b05dcbad19a653fa073aaac50d5170e5de5eaf266a3fde2e59ae4ad94f2f6",
  "240b9cd3ac60c56da080baf790e882eca4ea75644c5967ed8266d0f1946847f0e3e243bf1189df20c990c94683d15ec6e903ede830e57e0727ef7e4066a97b0b",
  "2c247a65e8b946837e79fe8a0918a997e50766b967e0d9d14f354bbd58a9db4a7672e92649a49fb2289035a14ed0892d7592a1d269b672a4ec8867c3d346aea2",
  "d7c26aead784f5ff1e87045fb9137ebea95f06498da0c2a1e9ee8793fad537b1b41090e57f30acfe43594b4c6f0184d924890ee67d92615abaa3bd2624f236b1",
  "4b29f8d8420e499011e18d64c1e90446c8ab2927dd774b022fbacd7552a888fe48a172679562e69838099b6761610325d587ecd4c94a8d55e1b3ec44f5207736",
  "3e5a0fd20cefab3b91f0e57f2f874601305e6781c154baf4c8e6a4e09557cb404df189b0b6a8cdb655d59ed88fccf29e6459950841c739106f0a7731e17a1053",
  "f07aa6f2f93be5a8122f0ad8d659ff66488f4fcfbda7f77b2f56eee4223497a1b31a93d66d251159dac5ccc343a15a85f73e5814eb7d9baeeead010ba751222e",
  "edbddb6c20b0f7d250c1dc453898b0b110c819754348e8b2fde6889dd680bec51c686ba81a52963b4a716def84b3f3f4e911191c3d6c73cc7f9e060cfe05173b",
  "07e547d9586f6a73f73fbac0435ed76951218fb7d0c8d788a309d785436bbb642e93a252a954f23912547d1e8a3b5ed6e1bfd7097821233fa0538f3db854fee6",
  "91ea1245f20d46ae9a037a989f54f1f790f0a47607eeb8a14d12890cea77a1bbc6c7ed9cf205e67b7f2b8fd4c7dfd3a7a8617e45f3c463d481c7e586c39ac1ed",
  "5e1e2c9fd51c753fe537e43c1982035b2a86c641d22a98677af89f442bda95a509a35c4fc2861ee4ca5eea20e6450902ecd116a95976b96ec37d0f58be6f84cd",
  "162930d5e90bee1c86b56fffe4bafafeee94815d343bc4184f87f3ded2fa4fc44c981199d0331c79e41eb1e2008bee02639e9a0764b9c39e00a8cbcca6f43979",
  "1216c818be9f2bc1bd993d29b6931a400d474ee439e5824c879e1030206d4698daff0f51977c8e701d8ffd2d0cf9a300c7f1ae547d93058695ac034fed20c3d7",
  "4039837b00e37ff43c29585971a68f89414a6951aeba2ae692e6ece11a6a3e58b9d2bad15176c918aef644a576a4dd4497cd22884067f27fadef262e79ec8a9f",
  "9d7c27566c55459b1a183f2698eb5ced70a298a73e10072deedc3a200e0a391d7e5fcf6a802aa12cb469cf70f928f01960df1e8d7471c0b8ab3c572403a30098",
  "b733d09fbc2b5266f4d113e1f260994f58771ac555145ae33f737ae814adf91738f37b3a982e6071d226846261c6f1440655d167c5ce04df4eba23f62a661996",
  "e94f8fac70a3b7a4c0d29946e7c6433d29a749cd8f165938e8b13dadc0901b198ff6b4395c2ac802083dce48422ec3aa455d612bb379bcb0e9ff5216418acf6d",
  "0039c0e979793cfa23748b7cf7a2e3982eba9aef9a301575d50f332fe20a960f300511460b6ae7645ba9b656416aa781e833ebbeb6ba9bbe5f7f643c9a156d59",
  "cee648b7c0b14c531a64e6026e97adfa8d2b71f1c89985a7bac502b552eb4986bf2dcccbbe6e68040818232398d70508f90d37ec6576d216b733a7b52de78bd6",
  "f96caca679e2776a8933ccfaf848f58ed1de564fcbce00ddccdbf7bdf9819f1fb06574c34323009cdb5b0ef430d90e08e4da17953d34b72bd87373de840b0299",
  "7c2522efaf0251854ed9d68aed3ee646553401f87c162719b602c676d5f2f45391f7fb8d2619d3e20055435cbaa78defd51dbd95e5c351420dd62e2f53cc77d5",
  "ae7572c1f8f8e89c48ea25401f79942b8cb1a0316409f29c957ac0de9b3edec509dd29baee2cbbd7fbfb81dcda750ce59d1ceed9234f4edca8194656f00831c9",
  "2fbd6b7ad16da77fd307b4cd712ed70d4a21313f966fda3b6f60d73dd3cab0aaaa6c9455fc4a5103f99d80fb0490a8310c603bdbb6b925ccb14c87b1e9c2ceb7",
  "3cebd0bde4ac281151020e3c944e40dc3ca9203fd8af0bd2009ded0ec50566c53f630aaca6ddd40041b1c0e6e77df43b503e37c9fe913711c03a10ef3785d54d",
  "3ede082cea90fb909f21a299c1bd39494f44e9f4f614cc69d080482d12c39c6082748f7253fe9ed80cd85f09a11db35f68b453981269f4cda03728d936ac2e97",
  "b60bb7fb62fcb4e673dc4c5b8c5c8ec3a9c31569f6b3425043cbe7814508373c5a07fad5d27c090ba61de97a1a3596370c77feac711af76c80f7795004de81b4",
  "e7a60093f04ca5cca156ed165bb2b4cf7cc0bc538240fd121bea824f7ea309a362d1e5deb15550fe7ae56e533f99f290c5a570913e537605c53dbb525284cf54",
  "e4d0de74f09f714ed7b97667f4c462f3b4b7802b1cd6698fd7d1ad97c0eb09bc39fda853f1fcca9570767738e576215bfd7ee76ac72d1da5280b582296329f24",
  "f02f601c2c27fd84b75a643c8ee26e6d4421140f75d2af30709e621ef198e05615bd6b568a4f67c70f9fe898c7cd3026e3379dafb01d969dacb20049d62c4682",
  "291aea713e6c8567bfaae8fa6b2711557320ffeb44ad3ded077abffde0bfec8fc9c6cb86aab677a4d99b6e150408b7a8d4bac9c876c9335e07cc25ab49162767",
  "139f3f4d4009be42ae62422718bc65ae0c416916b6761b5c2a80b2b55be51cd243eeac5caee9b2bbee20f3e55a91365b86199d3fc0557db3db979219f5839bdd",
  "187249bab389e589bef61e903e2c7e016d94cb0ca2491d07fe4bf2e0484ae5640145de666e0cfb577d4d60953fb9ac75db0c07dad4e3f7dfa1bc30619c88cdfb",
  "bef11c0d3c5267ddfecacfee56913fb60679ea346470f6d045b48535df4a56be6edd3a57ee9c48045f8a321b4fed4cf613474220764998526541b5ae401cb1d0",
  "c40ccf026171ba822e721e2ba3862cbbfd8331db99f4f580bd0388ba75f2f89b929a1ec80fc19945c0ef79fbd5b92de0cd772418ffd0c8147e1306680a9663b5",
  "7c35d4fd4a95464d5191a3f5e9f3edb8893c66d5891dee0a53038a2222432a6ee88d3f887e1348beab0008472f8df84d178da7c584a00d2db43c1535203da390",
  "e2de986a6b5c8ef705c59a8eda38e1855e6896e948cbdbd6042d934341a4777645d39cd8969f53415ab900138fad8a8543bc87c7371d32bc9c97566d0774aba8",
  "b13c9913ec130f5bf2e40adc283a96ae4903d71782279cb8794e926abc82937e01a2cff494f4d168506341b492642dd0c04a657e016f9d8d8b57b20465aeff72",
  "38e89130fabdcea2f555f71ea2094005cff7e039b4a7421a7b40d56c457705e857908ec53bfe463ece568d75f75ad959868d78c5baa7cae309ffea4cfeacb380",
  "ceabf765aeed49868054c62e3bbc2c00b5368d3714b7c96649b2edb26f0b6640c69b8a04097dbcdb9664cf426f0efab7ecd8269e3cac7ee8b8784424c3389d0a",
  "eac764653fe8bdf0a6f876f8c27cb9dd6b986974a405e383c840f2fa359640a580905ac37753040b8801a0ae6835d3d0d9295e9ca40bbcad903a2ece091bb547",
  "a5f601eda3c483432c8b34af1ca5a5b2ed75801936ec4bed7570bda19cd4a79b2c1f24e505df4ab2b91c43028555358b44f6246062ab1f60687a98c49c5a4ccb",
  "254efa3bd9575a0fc856d53f8542c0cc64cbf4891b1b3ee97060d596a51ff8471d0186868af59ca50d73b8f509352c146757a5bd86f59ebcec6ee4db2fa2fded",
  "b439ae6bf400df4edaea40570cf2e6478b031355a0491f94cc213b345f0794db6773cf3779e300dcf12d42a24662a9668ecbb79c87f888454354c440366f0f1d",
  "f99d86d1ea7a5dde3fae3baab3f6603b7805d6818f44b724902836bc857cad8bd9f8626cfdfaff8d76b86dad3f69bde28abbe78a0dab090e6c501166343d99bc",
  "5b3f6a33c7f9e80d98c0d16f18ed989acb2c723e3f84b929f07cd9eab4a9a20e736aa12ad9808daf69310c61c2e63db15904703a9fd4e3ac74933e55772ebbdf",
  "1d9e66a96556fcbaca8ef242da4dcdd83d1339369bdfa9d2af0c1940396d43adc302cfde629bdd0b5ae5d8f995a558597ef11bb04bc818e807dc5b0ac0d7a730",
  "3b9279b07e9574821d827cf1985039948c26329ea5767138b06b2e91b01ad64475dc88985e5f1c664655343237d97fb884e700819b61e1cf12b7ecac38207c1a",
  "5631f6bcaeb487bf843cf54e12cff6d72ab5f1786bad51d9e90ead7f340387b2a271cb85aa417a0898b6a9e4f33eac155e5224152051ca21fef4f6e0b1c76a49",
  "5994362806cad2c71fa69291840f5798365b238cb710aa7515c36d059e96009bfdb41155d8f9ca008b7b536ebe1c1e49b401b5334a75a4cf8e7891f3907a864f",
  "bfa6a6ae5248a4668d4dcc50b1022c76d04e6aab799a77f2641e34a8df9f30a4a0fb29de6bde727d6941adf32775c2739eb4d2ad7575661a0010ed957deed45b",
  "830c371d35a9590bfc897ec2d49ed52ac1df87dcb1664eec4fa4ef13bcc80b4f8cdd9cfb29ffb32e01d3e35b44094dd43a1df0081d1435b7298a2ea729453c86",
  "f0fd5c15bcbfa9041e1c53754ff0b5972930be7fee568fef02de68becd088303e4dd6da8a204bb569f0d7c73e0c478816e77cac412681ecabc3a371d5afe4b56",
  "b29b5852cb2d3523aa98d0ec3f94813187c2dc0993d35be9f6247810d35bf4aacb6ee5f993fccfc8c9d7d9524ffa8c01ae2042510d3ac950ee62315235fd3afe",
  "1064a5e41eb6faa80f2aba180fe59c3b0f237c43d608b235382a9b22057f4d6ac91a316c4582bfafd4ea04ecc427eca886860240d88ba8af9508064e71eaa52a",
  "5574086049660e7cd1d2cd4b774758df61e8499ad2a25295322639035aa4bfa29fd1e33a438e74ebe79fd0dd17a90cc0f88e9282ff5fb2205c155094057bd27e",
  "07c40b39525c7c8afbba33afb909f538aeb400286488e77cdbc195a7d135dec54d419aed450b44d7ac3b05878365d35fdef5651d6d30c2d81c5b8fb106fc3334",
  "2174d552a8786edd25c3d6bcedbce5fa84a80801845ac338df4bb28f6ac51f6ac9023365bbe9b21ddd568a4465ca6ea8da356286f5b2ea627a67d8833880f78a",
  "5e6ca770fa9cee048a8951e4598df26d4379111b12b62743cbae5b4b19c198e9095df55efb7f478955f3ac8e060e501a709818165b8f3c73909ea2d58227412a",
  "d52feecbf5c9a9fd6097cfa06ecac142cad3421e7dab3a04ef8dbcba16e21e1a9fdf2c3fcca1f510815e194e71c45f71635427fea15f7945ccde0131452acdc6",
  "1bdb98a3f797482f004e98597553cc763aec2f2896f9fb0f7fc679702eb043849b6ba3984f4ed304db6cfc82ba222215b9b5dd991b6ceff53dd1f8e67759af92",
  "fb5606b7f39828a91c0ec5ffb0ecff985179c612f3c5098065d696ddbf525c8a44514b8bf05b9dd0d396420ea3bf106a0bc9d08b929d44ecb83796d146eb09fd",
  "3dff123b608bfec0b02118a569b55b80f7317de4bad125a9f897a5ddfff0ca8a1382e9a72afc79ae80f2cfe59e7712f4713e68663e3cdfa0d23f5fd848354523",
  "d47d6576adb48d7bebac60fbde84c92bca384318e21ddc8073ad423bf2b7cb7b9939ffa0b304cd6a522186a813acf0ca8eeae6b7a01755e92662f4fa3df0de71",
  "293e7812e9fd6f39f9a81e11f858f6743e4e31553b7251edf6aea5dfada1afde12bc1578572347007484fc0e591c1fde72c254c960cedbb8eaa7ac85aac3eb7a",
  "1227a9c0d52a20f00d7f085e95416b3671ddfcf5b73dfd7caf7c64cf19b95d8b762a0a578600e6af971f3b97a10d7bfaa685460a9beb92942c706c547cf813cb",
  "15e2c21af9d9209606e728b4ad464c108b7e386d21da4344ecdfd03cc5827432d161b14ddeb621be6c2861ff7547e011c63c490f3d809aefac7ae5162cc6d655",
  "c54c0de631c7998fb2da9d3ad2f0f8a87a5f658c292ff1e76443f19a8d51e34e0465063e49086d9c891dc79cb2bc08a9611b108ff928093e6b8c985d14cdb281",
  "33b2ff02a79184ef6639867bb72bdaf0c93740c36e1b5e26a0f3db94d2af7bdc323af8b10fdaa57caa08b2ba5e17f4236753e657dbc158bae140b71955bbe120",
  "0462f7739cdd8690faefe555246466bedf67b7b9b7a9694ea92c28a4af4180f42cdd7839d7db5c1f8baaa6c6340b9efcab31a8c62674ff3db8f1cca965011230",
  "b3f4a7006181556befd5251a56543f14e9aa479699749f949d038020111bd305a679a83dcf66e66460b970da6cccd67f1f3f4c4da99d4e52d9ee34dcad7176c0",
  "bcd2deaa39624795411746e1e33101b7e44e1e9bbec7ae104f0308c6a24dfc89271a43a547a6484194dac6ab6614e974be6990ae3d8d11bbe65d27ea68ffc144",
  "b2700cab398bca05a23850a5f393ef9c71eb9cead13036e93b66cb2cdb288f00e0dfe35e1a16f1039abdc7e1d7393ed3df3eda7e75e8d0de28c6ff68066b907e",
  "3e99f7ef52ae5b3eb4bafe745a7bc6170b5c4a0f61f5a0dc0294254a1e87543fac10f46ebdc29a1e8ef5ae715636e0aedc578b5560ba55365eb4c28b226682ad",
  "e2e67d7cb85acfb52791fce61b08d79df6f90a92dc8e0cf26b5bddf3a7deb5ce6c23a9098cb066ba065e6991a66d9449dc9166417ef86001f48b45d7718bd124",
  "a038eb72223e8fbcf4040ea988b53f8aeac0b6029a85d44182c4742bd5e9e454e3470c19ba2dfdae71c2f1f31bbf543e704e0cfa55e98772c9cc056882031bad",
  "82a1d1c2764f32dd54d242b26d82a559301375e74dfdc149bdb2a3c27b2fe2645d85b2aa8e6a892a846b157bf3119c6079b3512239043de0bb77eb0612ca6dd8",
  "3d04e36beac7a7d845655bb52da45d80f7862fd989c256b09d6cbf654c946b8b40b0432ea43a6b60864b1addda95501518609b690265d969ee909f07f8a02f97",
  "e37d5080c16d8a2ad752796482a570759f69d9274f6b55d11ffa4b3b14350edc3dff02f83fb360086a5d53b7ad68020ec781e22a05f3984afed3002743f1e3ec",
  "b3133139eefd7742f993815f8171c611209b2e76900e753517c6eb6b6482ce8f98c7a2a7e02e5cf08680115884733ebe72a7cde5604aff31e00b4d82b5fc6ca6",
  "b5ec00879e0c890d570c4ed0e93b32e92579df18350835db4333318e52675b54b18ff156195c9808547ab72ea36a6dfdaf478a9360668baea162ed2d665ab54e",
  "1d892e3482147fb943b8029fe2c4b8e5a711a06993d6d5b3ef66e691b2aa72ce2668c501af83f94203a40b4c37465cede2dc127b7a2dfd5e300453ecca177a39",
  "ebe5dae73d7539eee9b5b281cfc36b39a749f40a7e43d7508d8fc535d3b3bc9c51bf2815b63e04ca26c4225b099cead47f37c5524e5379de221e49c59d870f2b",
  "67477cf7b6f426399073619c6dbb7cb0958e8e7b41e2c3591b5a716c69aaf13ff37d53d5d8baa93dcbdef3c7fc800a0c379767ce09f714983991d3568e3265cd",
  "8417261aacd1ecf031d17fad6a4ae726250f62b6ef4986fdb532086b2c2fa8afea21739eb9e949662d7512c11bc5cbb558f9ccf3bf4e69b9285964edbe0d5a96",
  "bc667649dd008529a9d5fa3e8bde8420786e00a63e3481976811b2e9b395df6edc6eb6182be7d91cc92e6a4dae309456a5b3ba6754c1203a50b38d287ad7ca7f",
  "bcfe7aa19ae72582d859539c050dc53f18442ccaf1a08415464a669b72503b45bdb13553653ccd20399b74069f3260d43a80d6f91dced3cf09bc72b32f05ab89",
  "7d3b8dc4f5dafee652db9f134111fe3d7be1383491c308a24de6d19c85f3ed3b28543e78a360f1c7dc90ecc3f4c0731293e3523372a554af290b3e5720abacb3",
  "3af3fd8d186ded54088d93099079679f30b33b472ad9c45a1ef56f66f55d324a8ac19971f7e5b585c4355fae0f5bc32437376bfa240976975f4b9a8bbee7897f",
  "cbe6405ce8db3c3fcc956d76def5bb3199fbafa808cab6ee399af30998b36f0c82620e9ff9d48636157aefc92e1a4526e646c885c66f4a0a7617f4bb51da5e5c",
  "4b29415c4bf027830612f3a83db423949535d6b7d036a5adce3ebe824ba200037f517de8953c000d5d2481209948f4d4b8cf90d799347b90e79c6f0593169ada",
  "b0cc887af7da5630f9d9771f9c8cc8539526f045c340e08e65d6fdc97d20577d57b192c4672bfc6dfca5c800933ff2fa07d160cabea90d28ead54c05c3b7a37e",
  "04bcf2550faa52348d1cfcd971ee0bb7f639d68a19c3305a109fe012e66ecbdf44c57ea0788edec16630e42247da4a3fc2e7eba13e760bd4d401bc19f09071d0",
  "3a9c39158f01951db962e4d7decd60cb250f14e041c1ff88205f6c9b5daad930d2affaa896f8bbf586cfa81506c8cfeb31405b9eb1c9be6ab8b2829408219b0e",
  "b2fac91e5eade54d6100b7fc4cfe42fce3e22dbdf51bd613f4e8a3496ab6101159cb2e559aa4d0d650209f2eec6a02f63f15483b899dd4e5e933273b31139dab",
  "5c5568e3ad468eec55a92ba557a57ac03a6235fecf1cfb55c09796afe3e927f8f9801d1d07b2df4060470bb11b09f83f34c5122eb887d9a94c0f5f145fb9e56e",
  "bdab9cac7cb2ab91d14950a32e0a62c668dd91e2b8754193d146ea8672d29222c6ed5c2ea60f0a7851eb7277ee7f9cedc0489f892adde2a04ca80e038135f198",
  "af3ea76bbbcaf5774bc4958b07568c837f948a5daf8a560c5755149a70614dcb64faff186217799b7589225076f2758b8cc0d84c075a1c752a09a826004bbe76",
  "3b50e163d5ba96a2e7e3329340fde381a535af02fc517168a7d6d4195cf272e61768a1f3e5d45868597bb32c49380f4ba21e788c92fc6114729a44b4706ebca4",
  "37dd3a8ad218aa44b07878828283301cf39da589111e5fb65298002c3a7b9f013c36128fe66f93ea72dad5d99ff42d774ae999f1e8d84d3c1fb61d78f478c329",
  "670b50a1f26c26febdb8fa31e1bc9f03afe3f725bd7deefb465070de06777de9ae55479d271961265624bb25c685b48e42e72601f52391986f2b97203d983797",
  "5e2c8d428816d02642bb094f9bcb0d8a3e48108c4549fa1bb7347d0d15a3d37bbc3af5ce8f9279616dcc802f142dc0e246dc76fc182c103747f5225da8cc4841",
  "8e2e77fdc06eb9324f7b1d858ce6442263d880caf256bf9d62970f1ad765e81bb6a95a5bdc88fa87b37007872443952b85448ad4dbcf7ff012e2b1d44f53f699",
  "8937de9272ae5f8a1ccece91f5cccf118904a5e7fd21edc9d077a6a1d312e621f4cd96f4a950b74f2f481985495c4fdbb8500c2386aba7d133486931195a06ea",
  "cdc9687c2404ecd21f1f9b7fbb272fed78ade6ad8547024dcbf931258a3f3045b0d644ec402d2bd13ac7e3c883c94800ef001b797c9e5dfebce8aa44f24829dd",
  "5719bee028987d23eaf51350467f153e9d440c51e1266038b4ebbcd573ac74b79008566646075e2a1a2b5a6b3a1404450cca32b0fd29dfe2f7cc7e2f4585d07c",
  "2eda00c8cf9efdd46f79b95e177cb98b1d566526ec12829ff82da0a78dc047e68d6f0e776715df6fd9aed5df4168b9e33aa015552105fa0a21e8cb038d28be1b",
  "d372e62ba258d701eb7fba23617d7967e5190f8114cefee27284744952f1da02e1e8de8c9dd7a9bff520a7061a18dbe99ebf33342670644129ac8190135dde78",
  "5c3a473fd13763eaea52dc52e5eb6ac7e5df5c35ea8812e8be7d41293ea8ebea66bb76d8cf58680c3859f350c98b4ad6771b8c6e4cffec4622fd3ce5ad87216b",
  "d206f0f3af96718772e2362df47e0f65085033820e1eed17ada51a8c880f41e0cc4b539363fe414ffdafc87cb95053a447f154567cacb94a56faf26423614973",
  "933d85bb2e7a3b8bf7437ed6fcc52202d6d797a466c21bc50c74c348dc6a8e06535e8aa9fb2c309e6cb947709992f816dd89f99205909198743848d13803713b",
  "e76363cd6d53d7610f4955df2acfc305337f6e3dbbfa2be6c11ac0f486149ec402dacabe810ef305fb4fa06054b03aa06cd9d512149eb52e443de3f9d442395e",
  "a3e64c7cad5a7aee65dc47c3fbbd0f52289b118eee07e43e5b997d3d71577995b906a37bc4e5688b5d36e26602276e242e49bfad1f786b927ccedb627fd61401",
  "7cea74c5c65aa40575672969dab244911275c73ede90543b3e19da85a038065dd971329c8c7dc23eb260bc9e5df9e6f4e4f29f6d6ffc9fac51d2d8175f7f4342",
  "a4ae36fc9c75d72384ca96cfbf5dd3d55750ff1dbbfe01d71088fc86b955faf48cd6a9bd45a8ac7d429ea4eb94a5108998f05b1c69f506f8d429e415678b35f5",
  "7f27474f5ecc49c4cc5c8835a408c2137c3063402e893b6fa8435158892f7cf4066ed695053bea7c394ef3877821956a89d94632b32286ad65f6b0c6b3397f6a",
  "5d868eb076cbe09c47cf570d3aef8facea44af0898a11b8500161d0f6e402a9112ea2e41e28bbea388c9234529b5fae5ef74631c044df7c218efa5d82efb78e3",
  "6cec12204ee0972baeeaffca5c912647af39291a7e2b81664e562ad12a2b17fd4e092cdb1197aa9f1330a0a7c8bcc7f623069d325b21b14a5803515a61dd0fb3",
  "fd3393f5c582297309610f427cb14001df921bcfb0a771f37a51e6166a2fe143ca7fd329fccc47ab5766056caa4dbfa9da5f221a4ca054644cbfa939df491e3e",
  "9917e3cf093607bc286cffc60269af690f4eb9f704107c906627cf3259de31d923f696628e730283b51513890ccd90c40f4bc2cb762980b7531810bd2a333882",
  "95522c31784f34aea08529a4a09a283b30085cbab3843babf96f0b45f406c9b3a76b6373635074428b23e17f4977e9fcd065b44a9161a26b7fe66fd5391d6d78",
  "91778a52ce45d4b77f1d91e3cdb38464ac16c880b28916733a31367a3b2015082017f767267bafaa1ae769611f05bb6b60c307fb080cdd4bf2892704e5aa1af3",
  "09a1466f07160ca2da1f999236a7cc016c9be9a5f66abe80ee2694df708d58d5b572cd9c2dbedff202b940d874938caad417183e71012b77e446afb3832b809d",
  "1227c21bc6e15c7bf0aec79febae2e8787b97c33c3d96c2b2fac1a43fcb841576cc4c806aec038534cbf0476cf90fedc70eca44339523904e37020c14cbf2151",
  "2ed90b58e8009fafd9c7dd299547bcdea69a6c72d4af00be9a5f5d81422cfe6f275a00af7579291fba526ea0d872620f72321b5a712e08849493024422d3009e",
  "64a10ff891e361e3a7919614152053bfbce6b02c8241f6551550cf704203833c538d879c8631d04656f0e67963b8b56ff546fe9a7f1ee073f0fb92259a702328",
  "d4bcc92ceeeb193aae5f673d444275bc2b400116c48c8e70e5fdc19606982f574823171a6590d377399ebbff7ea66c643998b0b9a3ede9c82acef9ec4232356c",
  "407d968198d56fefb39af30c26d7af2d32231c388ae8f9d68eee68a5a491be488f21ac41c2cdbd2e5a6ca5cad398662477c070d6954e8bf2447b39b471019f0b",
  "38c7a0ebfefee5d4809fdb78d07626d1fbcc7a398fed72a94623c819b8320c2744de1249d5f4fd8a40da86489d9b4c4370c8dd64cb31f072b79159a2403666be",
  "36d93692644eb4a082a92e6c12ac7cd91f8b064b79f6f484f40c2ba4a1071516ab4134351661f23794199e60193dae637615eb03fa3d3d988710d0dc67a2ff3e",
  "05e6f04cc9fb24de203d06a65911276d3408def644d0eaabea8daa3f05924faf79e8d14161a94e1eb2cf28dfecc9dcc63aa6f820ca28a8b6a7677f9e6f89bc5a",
  "b5bdf2b8009369341985a4d6920b7dd0b2bfd088968050b208d3eeef95e2444abc88227de54866c419bbfe008a91de2c6ec7f028cf7161a7335f929b09005f3c",
  "d57d75ec354a3ae54aabd4a0e4c1d352426031ae401cbd6d18d5de72cddad32822f057a9aea2f64d7531540832a8fd37498f27ecac24cf70783d8ae7dbae16da",
  "9eb628ff8258d6eb5ba260cbc7f66a32d0d35f72eb7d7f70614c0c4d6ba72f8bb7204f8ee704493fc798a74de6659378ba0627b8b8a88630d4220375a5906a6e",
  "d992753f9de4963cf53679d6612de1987725bb9608fe23cfd6506c4d07b1efbb4bddbad542a5f4194e6d4744bf6c3eccdddabbc04d01197f2ad84c35bf885896",
  "6689fd5d94a7dcb6b20bcda530db758c5d373ebfbc0f57808b95a14f45326478a0cad7a0d6ebd22f8c70e39f41f7b9610ab9b475785b93807e16059ab5dda7bf",
  "93893c6b57bcec91f2d19c8668c5b59b6c5a66492b71770e914ff30489a6efa7f030fd42bd342d8202ce9df99c0a5ed56e1e4ab06ae0ed6d359e3b140076d5bd",
  "76ca602812d40fed5cef33b7310e7b8bb5a5de549fc63219f5dabb3cc8ca70658151417e2fc041d6fa05484321be2f57bca1d0300be701031646aab039125fbc",
  "0c71f03a2b3ad8765aacb895f6a19de92fbf77b0e40a61622888c2886bb5bbb8c3b4ebe4e6abae661e4f0b72aae10753d890aab9d18941fdf18078b77f187d31",
  "8e2d159af8fae54ca736e3f3412d7de329631db7bb561dc0e82266c50958f22fdd7ef8181ce62e9632f7443608c1d3405503af23c804083e1058c6118bd8a52e",
  "83be1fa27282e68590c15074ac8443f9f53e064ff8c5c2d65304266eab1d998fb23f180f3811c5ec5cbc88597e037f5a7b908eba287dcdbab5ae473e65325611",
  "681f00cf54a854e4b2d26dfd264ea4f0695360d0f23c82a024e0403775925b2f2f9f1aed94f123a5a683241c73d4e9b6abb7473787eb48dfefbbb54d0d122a71",
  "4ba62bdeee45a2f100f7d7e62482913cc64b3a8fda4c1e833568d98403d0d6a9a788d3980fcb3a9b62599403012014b3f2926e264d83c4167f9f99a1f29a9e2a",
  "a40d8ae569c4a15e542d0fc9a2270b1e253a5757bf64f3769ec2c0e6a2b8f82d8934c1cc0450c1cce806b6b876de1fbafcb2e06ec4519edea2fdab9a6f54ddad",
  "5430372627c0d0f0e6ed0550b77a4256640c1de9da96c7faa7606c7c1b0cbc6ab793bfd279b505bdce09b46cb7f5d73217bdc0a18240541656ee9888999c3339",
  "c9d0a880ded82409ac942823379d65acfc1b11e54fd44cf0d4569eb204e372bb10d4d111915de64163031dc533715b29f14a6f910a3d58662bd13768e31c2aad",
  "a326708cd8da2fab8f4b7870dda03800446f520532638ed7bf8177c509c53a65ec3127730ab2f02d3f911927d1f265d147bb53ec5cc0dfebdb68d0f50eb2aff3",
  "ea381acd65980fd5eb1e8cb5b25ccae38afcfb9fa1308014bbcc96d9b80255cc8ea8225f4c6fc2477b7af3aa2c61228a9d7a6be1bd92b8687ca25b0f912757d0",
  "42255ddad4f1c30ad42e85752bc3685fff22da82dd8ca85f7616112acf2c4644d40330b7e7bd4707c8094d1034cae77a503cbe20d0bbf2519bed7a758817bfae",
  "9da644c289075656b5339317f7100d954b49e67e6c3f981451bf7982c52f003016470c781fa0af61a965fc0ae50f1bbc8d94ffe91e10dc09f27dbe5b1fc2827c"
};

typedef struct {
  GChecksumType  checksum_type;
  const gchar   *sum;
  int            length;
} ChecksumTest;

static void
test_checksum (gconstpointer d)
{
  const ChecksumTest *test = d;
  GChecksum *checksum;
  GChecksum *checksum2;
  const char *p;
  int chunk_length;

  for (chunk_length = MIN (test->length, 1); chunk_length < test->length; chunk_length++)
    {
      checksum = g_checksum_new (test->checksum_type);
      for (p = FIXED_STR; p < FIXED_STR + test->length; p += chunk_length)
	{
	  g_checksum_update (checksum, (const guchar *)p,
			     MIN (chunk_length, test->length - (p - FIXED_STR)));
	}
      checksum2 = g_checksum_copy (checksum);
      g_assert_cmpstr (g_checksum_get_string (checksum), ==, test->sum);
      g_checksum_free (checksum);

      g_assert_cmpstr (g_checksum_get_string (checksum2), ==, test->sum);
      g_checksum_free (checksum2);
    }
}

static gint
hexval (const gchar c)
{
  switch (c)
    {
     case '0':
     case '1':
     case '2':
     case '3':
     case '4':
     case '5':
     case '6':
     case '7':
     case '8':
     case '9':
       return c - '0';
     case 'a':
     case 'b':
     case 'c':
     case 'd':
     case 'e':
     case 'f':
       return 10 + c - 'a';
     default:
       return 0;
    }
}

static guint8 *
sum_to_digest (const gchar *sum, gsize *len)
{
  gsize l;
  guint8 *digest;
  gint i;

  g_assert (strlen (sum) % 2 == 0);
  l = strlen (sum) / 2;

  digest = g_malloc (l);
  for (i = 0; i < l; i++)
    digest[i] = (hexval(sum[2*i]) << 4) + hexval(sum[2*i+1]);

  *len = l;
  return digest;
}

static void
test_checksum_reset (gconstpointer d)
{
  const ChecksumTest *test = d;
  GChecksum *checksum;
  const char *p;
  int chunk_length;
  guint8 *digest;
  guint8 *digest2;
  gsize len, len2;

  checksum = g_checksum_new (test->checksum_type);

  for (chunk_length = MIN (test->length, 1); chunk_length < test->length; chunk_length++)
    {
      for (p = FIXED_STR; p < FIXED_STR + test->length; p += chunk_length)
	{
	  g_checksum_update (checksum, (const guchar *)p,
			     MIN (chunk_length, test->length - (p - FIXED_STR)));
	}

      len2 = g_checksum_type_get_length (test->checksum_type);
      digest = sum_to_digest (test->sum, &len);
      g_assert_cmpint (len, ==, len2);
      digest2 = g_malloc (len2);
      g_checksum_get_digest (checksum, digest2, &len2);
      g_assert_cmpint (len, ==, len2);
      g_assert (memcmp (digest, digest2, len) == 0);
      g_free (digest);
      g_free (digest2);

      g_checksum_reset (checksum);
    }

  g_checksum_free (checksum);
}

typedef struct {
  GChecksumType   checksum_type;
  const gchar   **sums;
} ChecksumComputeTest;

static void
test_checksum_string (gconstpointer d)
{
  const ChecksumComputeTest *test = d;
  int length;
  gchar *checksum;

  for (length = 0; length <= FIXED_LEN; length++)
    {
      checksum = g_compute_checksum_for_string (test->checksum_type,
                                                FIXED_STR,
                                                length);
      g_assert_cmpstr (checksum, ==, test->sums[length]);
      g_free (checksum);
    }

  checksum = g_compute_checksum_for_string (test->checksum_type,
                                            FIXED_STR,
                                            -1);
  g_assert_cmpstr (checksum, ==, test->sums[FIXED_LEN]);
  g_free (checksum);
}

static void
test_checksum_bytes (gconstpointer d)
{
  const ChecksumComputeTest *test = d;
  GBytes *input;
  int length;
  gchar *checksum;

  for (length = 0; length <= FIXED_LEN; length++)
    {
      input = g_bytes_new_static (FIXED_STR, length);
      checksum = g_compute_checksum_for_bytes (test->checksum_type, input);
      g_bytes_unref (input);

      g_assert_cmpstr (checksum, ==, test->sums[length]);
      g_free (checksum);
    }
}

static void
add_checksum_test (GChecksumType  type,
                   const char    *type_name,
                   const char    *sum,
                   gint           length)
{
  ChecksumTest *test;
  gchar *path;

  test = g_new0 (ChecksumTest, 1);
  test->checksum_type = type;
  test->sum = sum;
  test->length = length;

  path = g_strdup_printf ("/checksum/%s/%d", type_name, length);
  g_test_add_data_func (path, test, test_checksum);
  g_free (path);

  path = g_strdup_printf ("/checksum/%s/reset/%d", type_name, length);
  g_test_add_data_func_full (path, test, test_checksum_reset, g_free);
  g_free (path);
}

static void
add_checksum_string_test (GChecksumType   type,
                          const gchar    *type_name,
                          const gchar   **sums)
{
  ChecksumComputeTest *test;
  gchar *path;

  test = g_new0 (ChecksumComputeTest, 1);
  test->checksum_type = type;
  test->sums = sums;

  path = g_strdup_printf ("/checksum/%s/string", type_name);
  g_test_add_data_func_full (path, test, test_checksum_string, g_free);
  g_free (path);
}

static void
add_checksum_bytes_test (GChecksumType   type,
                          const gchar    *type_name,
                          const gchar   **sums)
{
  ChecksumComputeTest *test;
  gchar *path;

  test = g_new0 (ChecksumComputeTest, 1);
  test->checksum_type = type;
  test->sums = sums;

  path = g_strdup_printf ("/checksum/%s/bytes", type_name);
  g_test_add_data_func_full (path, test, test_checksum_bytes, g_free);
  g_free (path);
}

static void
test_unsupported (void)
{
  g_assert_cmpint (g_checksum_type_get_length (20), ==, -1);
  g_assert (g_checksum_new (20) == NULL);
}

int
main (int argc, char *argv[])
{
  int length;

  g_test_init (&argc, &argv, NULL);

  g_test_add_func ("/checksum/unsupported", test_unsupported);

  for (length = 0; length <= FIXED_LEN; length++)
    add_checksum_test (G_CHECKSUM_MD5, "MD5", MD5_sums[length], length);
  add_checksum_string_test (G_CHECKSUM_MD5, "MD5", MD5_sums);
  add_checksum_bytes_test (G_CHECKSUM_MD5, "MD5", MD5_sums);

  for (length = 0; length <= FIXED_LEN; length++)
    add_checksum_test (G_CHECKSUM_SHA1, "SHA1", SHA1_sums[length], length);
  add_checksum_string_test (G_CHECKSUM_SHA1, "SHA1", SHA1_sums);
  add_checksum_bytes_test (G_CHECKSUM_SHA1, "SHA1", SHA1_sums);

  for (length = 0; length <= FIXED_LEN; length++)
    add_checksum_test (G_CHECKSUM_SHA256, "SHA256", SHA256_sums[length], length);
  add_checksum_string_test (G_CHECKSUM_SHA256, "SHA256", SHA256_sums);
  add_checksum_bytes_test (G_CHECKSUM_SHA256, "SHA256", SHA256_sums);

  for (length = 0; length <= FIXED_LEN; length++)
    add_checksum_test (G_CHECKSUM_SHA512, "SHA512", SHA512_sums[length], length);
  add_checksum_string_test (G_CHECKSUM_SHA512, "SHA512", SHA512_sums);
  add_checksum_bytes_test (G_CHECKSUM_SHA512, "SHA512", SHA512_sums);

  return g_test_run ();
}
