// -*- c++ -*-
// Generated by gtkmmproc -- DO NOT MODIFY!
#ifndef _GIOMM_SOCKET_H
#define _GIOMM_SOCKET_H


#include <glibmm.h>

// -*- Mode: C++; indent-tabs-mode: nil; c-basic-offset: 2 -*-

/* Copyright (C) 2009 Jonathon Jongsma
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <glibmm/object.h>
#include <giomm/initable.h>
#include <giomm/socketconnectable.h>
#include <giomm/socketaddress.h>
#include <giomm/enums.h>


#ifndef DOXYGEN_SHOULD_SKIP_THIS
typedef struct _GSocket GSocket;
typedef struct _GSocketClass GSocketClass;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Gio
{ class Socket_Class; } // namespace Gio
namespace Gio
{

/** @addtogroup giommEnums Enums and Flags */

/**
 * @ingroup giommEnums
 */
enum SocketType
{
  SOCKET_TYPE_INVALID,
  SOCKET_TYPE_STREAM,
  SOCKET_TYPE_DATAGRAM,
  SOCKET_TYPE_SEQPACKET
};

} // namespace Gio


#ifndef DOXYGEN_SHOULD_SKIP_THIS
namespace Glib
{

template <>
class Value<Gio::SocketType> : public Glib::Value_Enum<Gio::SocketType>
{
public:
  static GType value_type() G_GNUC_CONST;
};

} // namespace Glib
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Gio
{

/**
 * @ingroup giommEnums
 */
enum SocketProtocol
{
  SOCKET_PROTOCOL_UNKNOWN = -1,
  SOCKET_PROTOCOL_DEFAULT = 0,
  SOCKET_PROTOCOL_TCP = 6,
  SOCKET_PROTOCOL_UDP = 17,
  SOCKET_PROTOCOL_SCTP = 132
};

} // namespace Gio


#ifndef DOXYGEN_SHOULD_SKIP_THIS
namespace Glib
{

template <>
class Value<Gio::SocketProtocol> : public Glib::Value_Enum<Gio::SocketProtocol>
{
public:
  static GType value_type() G_GNUC_CONST;
};

} // namespace Glib
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Gio
{

/**
 * @ingroup giommEnums
 */
enum SocketMsgFlags
{
  SOCKET_MSG_NONE,
  SOCKET_MSG_OOB,
  SOCKET_MSG_PEEK = SOCKET_MSG_OOB,
  SOCKET_MSG_DONTROUTE = SOCKET_MSG_OOB
};

} // namespace Gio


#ifndef DOXYGEN_SHOULD_SKIP_THIS
namespace Glib
{

template <>
class Value<Gio::SocketMsgFlags> : public Glib::Value_Enum<Gio::SocketMsgFlags>
{
public:
  static GType value_type() G_GNUC_CONST;
};

} // namespace Glib
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Gio
{


/** Low-level socket object
 *
 * A Socket is a low-level networking primitive. It is a more or less direct
 * mapping of the BSD socket API in a portable GObject based API. It supports
 * both the UNIX socket implementations and winsock2 on Windows.
 *
 * Socket is the platform independent base upon which the higher level network
 * primitives are based. Applications are not typically meant to use it
 * directly, but rather through classes like SocketClient, SocketService and
 * SocketConnection. However there may be cases where direct use of Socket is
 * useful.
 *
 * (FIXME: update this doc for giomm)
 * Socket implements the Initable interface, so if it is manually constructed by
 * e.g. g_object_new() you must call g_initable_init() and check the results
 * before using the object. This is done automatically in g_socket_new() and
 * g_socket_new_from_fd(), so these functions can return NULL.
 *
 * Sockets operate in two general modes, blocking or non-blocking. When in
 * blocking mode all operations block until the requested operation is finished
 * or there is an error. In non-blocking mode all calls that would block return
 * immediately with a G_IO_ERROR_WOULD_BLOCK error. To know when a call would
 * successfully run you can call condition_check(), or condition_wait(). You can
 * also use create_source() and attach it to a Glib::MainContext to get
 * callbacks when I/O is possible. Note that all sockets are always set to non
 * blocking mode in the system, and blocking mode is emulated in Socket.
 *
 * When working in non-blocking mode applications should always be able to
 * handle getting a G_IO_ERROR_WOULD_BLOCK error even when some other function
 * said that I/O was possible. This can easily happen in case of a race
 * condition in the application, but it can also happen for other reasons. For
 * instance, on Windows a socket is always seen as writable until a write
 * returns G_IO_ERROR_WOULD_BLOCK.
 *
 * Sockets can be either connection oriented or datagram based. For connection
 * oriented types you must first establish a connection by either connecting to
 * an address or accepting a connection from another address. For connectionless
 * socket types the target/source address is specified or received in each I/O
 * operation.
 *
 * All socket file descriptors are set to be close-on-exec.
 *
 * Note that creating a Socket causes the signal SIGPIPE to be ignored for the
 * remainder of the program. If you are writing a command-line utility that uses
 * Socket, you may need to take into account the fact that your program will not
 * automatically be killed if it tries to write to stdout after it has been
 * closed.
 *
 * @newin2p22
 */

class Socket : public Glib::Object,
    public Initable
{
  
#ifndef DOXYGEN_SHOULD_SKIP_THIS

public:
  typedef Socket CppObjectType;
  typedef Socket_Class CppClassType;
  typedef GSocket BaseObjectType;
  typedef GSocketClass BaseClassType;

private:  friend class Socket_Class;
  static CppClassType socket_class_;

private:
  // noncopyable
  Socket(const Socket&);
  Socket& operator=(const Socket&);

protected:
  explicit Socket(const Glib::ConstructParams& construct_params);
  explicit Socket(GSocket* castitem);

#endif /* DOXYGEN_SHOULD_SKIP_THIS */

public:
  virtual ~Socket();

#ifndef DOXYGEN_SHOULD_SKIP_THIS
  static GType get_type()      G_GNUC_CONST;


  static GType get_base_type() G_GNUC_CONST;
#endif

  ///Provides access to the underlying C GObject.
  GSocket*       gobj()       { return reinterpret_cast<GSocket*>(gobject_); }

  ///Provides access to the underlying C GObject.
  const GSocket* gobj() const { return reinterpret_cast<GSocket*>(gobject_); }

  ///Provides access to the underlying C instance. The caller is responsible for unrefing it. Use when directly setting fields in structs.
  GSocket* gobj_copy();

private:

  
  // FIXME: figure out initable constructors

public:

  
  /** When a socket is created it is attached to an address family, but it
   * doesn't have an address in this family. g_socket_bind() assigns the
   * address (sometimes called name) of the socket.
   * 
   * It is generally required to bind to a local address before you can
   * receive connections. (See g_socket_listen() and g_socket_accept() ).
   * 
   * If @a allow_reuse is <tt>true</tt> this allows the bind call to succeed in some
   * situation where it would otherwise return a IO_ERROR_ADDRESS_IN_USE
   * error. The main example is for a TCP server socket where there are
   * outstanding connections in the WAIT state, which are generally safe
   * to ignore. However, setting it to <tt>true</tt> doesn't mean the call will
   * succeed if there is a socket actively bound to the address.
   * 
   * In general, pass <tt>true</tt> if the socket will be used to accept connections,
   * otherwise pass <tt>false</tt>.
   * @param address A SocketAddress specifying the local address.
   * @param allow_reuse Whether to allow reusing this address.
   * @return <tt>true</tt> on success, <tt>false</tt> on error.
   * 
   * @newin2p22.
   */
#ifdef GLIBMM_EXCEPTIONS_ENABLED
  void bind(const Glib::RefPtr<SocketAddress>& address, bool allow_reuse);
#else
  void bind(const Glib::RefPtr<SocketAddress>& address, bool allow_reuse, std::auto_ptr<Glib::Error>& error);
#endif //GLIBMM_EXCEPTIONS_ENABLED

  
  /** Marks the socket as a server socket, i.e.\ a socket that is used
   * to accept incoming requests using g_socket_accept().
   * 
   * Before calling this the socket must be bound to a local address using
   * g_socket_bind().
   * @return <tt>true</tt> on success, <tt>false</tt> on error.
   * 
   * @newin2p22.
   */
#ifdef GLIBMM_EXCEPTIONS_ENABLED
  void listen();
#else
  void listen(std::auto_ptr<Glib::Error>& error);
#endif //GLIBMM_EXCEPTIONS_ENABLED

  
  /** Accept incoming connections on a connection-based socket. This removes
   * the first outstanding connection request from the listening socket and
   * creates a Socket object for it.
   * 
   * The @a socket must be bound to a local address with g_socket_bind() and
   * must be listening for incoming connections (g_socket_listen()).
   * 
   * If there are no outstanding connections then the operation will block
   * or return IO_ERROR_WOULD_BLOCK if non-blocking I/O is enabled.
   * To be notified of an incoming connection, wait for the IO_IN condition.
   * @return A new Socket, or <tt>0</tt> on error.
   * Free the returned object with Glib::object_unref().
   * 
   * @newin2p22.
   */
#ifdef GLIBMM_EXCEPTIONS_ENABLED
  Glib::RefPtr<Socket> accept(const Glib::RefPtr<Cancellable>& cancellable);
#else
  Glib::RefPtr<Socket> accept(const Glib::RefPtr<Cancellable>& cancellable, std::auto_ptr<Glib::Error>& error);
#endif //GLIBMM_EXCEPTIONS_ENABLED

#ifdef GLIBMM_EXCEPTIONS_ENABLED
  Glib::RefPtr<Socket> accept();
#else
  Glib::RefPtr<Socket> accept(std::auto_ptr<Glib::Error>& error);
#endif //GLIBMM_EXCEPTIONS_ENABLED

  
  /** Connect the socket to the specified remote address.
   * 
   * For connection oriented socket this generally means we attempt to make
   * a connection to the @a address. For a connection-less socket it sets
   * the default address for g_socket_send() and discards all incoming datagrams
   * from other sources.
   * 
   * Generally connection oriented sockets can only connect once, but connection-less
   * sockets can connect multiple times to change the default address.
   * 
   * If the connect call needs to do network I/O it will block, unless
   * non-blocking I/O is enabled. Then IO_ERROR_PENDING is returned
   * and the user can be notified of the connection finishing by waiting
   * for the G_IO_OUT condition. The result of the connection can then be
   * checked with Glib::socket_check_pending_error().
   * @param address A SocketAddress specifying the remote address.
   * @return <tt>true</tt> if connected, <tt>false</tt> on error.
   * 
   * @newin2p22.
   */
#ifdef GLIBMM_EXCEPTIONS_ENABLED
  void connect(const Glib::RefPtr<SocketAddress>& address, const Glib::RefPtr<Cancellable>& cancellable);
#else
  void connect(const Glib::RefPtr<SocketAddress>& address, const Glib::RefPtr<Cancellable>& cancellable, std::auto_ptr<Glib::Error>& error);
#endif //GLIBMM_EXCEPTIONS_ENABLED

#ifdef GLIBMM_EXCEPTIONS_ENABLED
  void connect(const Glib::RefPtr<SocketAddress>& address);
#else
  void connect(const Glib::RefPtr<SocketAddress>& address, std::auto_ptr<Glib::Error>& error);
#endif //GLIBMM_EXCEPTIONS_ENABLED

  // FIXME: it doesn't really seem like this is a proper use of exceptions...
  
#ifdef GLIBMM_EXCEPTIONS_ENABLED
  void check_connect_result();
#else
  void check_connect_result(std::auto_ptr<Glib::Error>& error);
#endif //GLIBMM_EXCEPTIONS_ENABLED


  // TODO: std::string overload?
  
  /** Receive data (up to @a size bytes) from a socket. This is mainly used by
   * connection oriented sockets, it is identical to g_socket_receive_from()
   * with @a address set to <tt>0</tt>.
   * 
   * If a message is too long to fit in @a buffer, excess bytes may be discarded
   * depending on the type of socket the message is received from.
   * 
   * If the socket is in blocking mode the call will block until there is
   * some data to receive or there is an error. If there is no data available
   * and the socket is in non-blocking mode a IO_ERROR_WOULD_BLOCK error
   * will be returned. To be notified of available data, wait for the IO_IN
   * condition.
   * 
   * On error -1 is returned and @a error is set accordingly.
   * @param buffer A buffer to read data into (which should be at least count bytes long).
   * @param size The number of bytes that will be read from the stream.
   * @return Number of bytes read, or -1 on error
   * 
   * @newin2p22.
   */
#ifdef GLIBMM_EXCEPTIONS_ENABLED
  gssize receive(char* buffer, gsize size, const Glib::RefPtr<Cancellable>& cancellable);
#else
  gssize receive(char* buffer, gsize size, const Glib::RefPtr<Cancellable>& cancellable, std::auto_ptr<Glib::Error>& error);
#endif //GLIBMM_EXCEPTIONS_ENABLED

#ifdef GLIBMM_EXCEPTIONS_ENABLED
  gssize receive(char* buffer, gsize size);
#else
  gssize receive(char* buffer, gsize size, std::auto_ptr<Glib::Error>& error);
#endif //GLIBMM_EXCEPTIONS_ENABLED

  // TODO: std::string overload?
  // TODO: need to do manually?
  //_WRAP_METHOD(gssize receive_from(Glib::RefPtr<SocketAddress>& address, char* buffer, gsize size), g_socket_receive_from, errthrow)
  // TODO: wrap receive_message -- figure out this GInputVector thing
  // TODO: std::string overload?

  
  /** Tries to send @a size bytes from @a buffer on the socket. This is mainly used by
   * connection oriented sockets, it is identical to g_socket_send_to()
   * with @a address set to <tt>0</tt>.
   * 
   * If the socket is in blocking mode the call will block until there is
   * space for the data in the socket queue. If there is no space available
   * and the socket is in non-blocking mode a IO_ERROR_WOULD_BLOCK error
   * will be returned. To be notified of available space, wait for the IO_OUT
   * condition.
   * 
   * Note that on Windows you can't rely on a IO_OUT condition
   * not producing a IO_ERROR_WOULD_BLOCK error, as this is how Winsock
   * write notification works. However, robust apps should always be able to
   * handle this since it can easily appear in other cases too.
   * 
   * On error -1 is returned and @a error is set accordingly.
   * @param buffer The buffer containing the data to send.
   * @param size The number of bytes to send.
   * @return Number of bytes read, or -1 on error
   * 
   * @newin2p22.
   */
#ifdef GLIBMM_EXCEPTIONS_ENABLED
  gssize send(const gchar* buffer, gsize size, const Glib::RefPtr<Cancellable>& cancellable);
#else
  gssize send(const gchar* buffer, gsize size, const Glib::RefPtr<Cancellable>& cancellable, std::auto_ptr<Glib::Error>& error);
#endif //GLIBMM_EXCEPTIONS_ENABLED

#ifdef GLIBMM_EXCEPTIONS_ENABLED
  gssize send(const gchar* buffer, gsize size);
#else
  gssize send(const gchar* buffer, gsize size, std::auto_ptr<Glib::Error>& error);
#endif //GLIBMM_EXCEPTIONS_ENABLED

  // TODO: std::string overload?
  
  /** Send data to @a address on @a socket.  This is the most complicated and
   * fully-featured version of this call. For easier use, see
   * g_socket_send() and g_socket_send_to().
   * 
   * If @a address is <tt>0</tt> then the message is sent to the default receiver
   * (set by g_socket_connect()).
   * 
   *  @a vector must point to an array of OutputVector structs and
   *  @a num_vectors must be the length of this array.  These structs
   * describe the buffers that the sent data will be gathered from.
   * If @a num_vector is -1, then @a vector is assumed to be terminated
   * by a OutputVector with a <tt>0</tt> buffer pointer.
   * 
   * 
   *  @a messages, if non-<tt>0</tt>, is taken to point to an array of @a num_messages
   * SocketControlMessage instances. These correspond to the control
   * messages to be sent on the socket.
   * If @a num_messages is -1 then @a messages is treated as a <tt>0</tt>-terminated
   * array.
   * 
   *  @a flags modify how the message sent. The commonly available arguments
   * for this is available in the SocketMsgFlags enum, but the
   * values there are the same as the system values, and the flags
   * are passed in as-is, so you can pass in system specific flags too.
   * 
   * If the socket is in blocking mode the call will block until there is
   * space for the data in the socket queue. If there is no space available
   * and the socket is in non-blocking mode a IO_ERROR_WOULD_BLOCK error
   * will be returned. To be notified of available space, wait for the IO_OUT
   * condition.
   * 
   * Note that on Windows you can't rely on a IO_OUT condition
   * not producing a IO_ERROR_WOULD_BLOCK error, as this is how Winsock
   * write notification works. However, robust apps should always be able to
   * handle this since it can easily appear in other cases too.
   * 
   * On error -1 is returned and @a error is set accordingly.
   * @param address A SocketAddress, or <tt>0</tt>.
   * @param vectors An array of OutputVector structs.
   * @param num_vectors The number of elements in @a vectors, or -1.
   * @param messages A pointer to an array of SocketControlMessages, or
   * <tt>0</tt>.
   * @param num_messages Number of elements in @a messages, or -1.
   * @param flags An int containing SocketMsgFlags flags.
   * @return Number of bytes read, or -1 on error
   * 
   * @newin2p22.
   */
#ifdef GLIBMM_EXCEPTIONS_ENABLED
  gssize send_to(const Glib::RefPtr<SocketAddress>& address, const char* buffer, gsize size, const Glib::RefPtr<Cancellable>& cancellable);
#else
  gssize send_to(const Glib::RefPtr<SocketAddress>& address, const char* buffer, gsize size, const Glib::RefPtr<Cancellable>& cancellable, std::auto_ptr<Glib::Error>& error);
#endif //GLIBMM_EXCEPTIONS_ENABLED

#ifdef GLIBMM_EXCEPTIONS_ENABLED
  gssize send_to(const Glib::RefPtr<SocketAddress>& address, const char* buffer, gsize size);
#else
  gssize send_to(const Glib::RefPtr<SocketAddress>& address, const char* buffer, gsize size, std::auto_ptr<Glib::Error>& error);
#endif //GLIBMM_EXCEPTIONS_ENABLED

  // TODO: wrap send_message -- figure out this GOutputVector thing
  
  /** Closes the socket, shutting down any active connection.
   * 
   * Closing a socket does not wait for all outstanding I/O operations to finish,
   * so the caller should not rely on them to be guaranteed to complete even
   * if the close returns with no error.
   * 
   * Once the socket is closed, all other operations will return IO_ERROR_CLOSED.
   * Closing a stream multiple times will not return an error.
   * 
   * Sockets will be automatically closed when the last reference
   * is dropped, but you might want to call this function to make sure
   * resources are released as early as possible.
   * @return <tt>true</tt> on success, <tt>false</tt> on error
   * 
   * @newin2p22.
   */
#ifdef GLIBMM_EXCEPTIONS_ENABLED
  void close();
#else
  void close(std::auto_ptr<Glib::Error>& error);
#endif //GLIBMM_EXCEPTIONS_ENABLED

  
  /** Checks whether a socket is closed.
   * @return <tt>true</tt> if socket is closed, <tt>false</tt> otherwise
   * 
   * @newin2p22.
   */
  bool is_closed();
  
#ifdef GLIBMM_EXCEPTIONS_ENABLED
  void shutdown(bool shutdown_read, bool shutdown_write);
#else
  void shutdown(bool shutdown_read, bool shutdown_write, std::auto_ptr<Glib::Error>& error);
#endif //GLIBMM_EXCEPTIONS_ENABLED

  
  /** Check whether the socket is connected. This is only useful for
   * connection-oriented sockets.
   * @return <tt>true</tt> if socket is connected, <tt>false</tt> otherwise.
   * 
   * @newin2p22.
   */
  bool is_connected();

  // TODO: non-cancellable version
  // This won't work because Glib::Source is abstract, and Glib::IOSource has no
  // constructor that takes a GSource*
//#m4 __CONVERSION(`GSource*',`Glib::RefPtr<Glib::Source>',`Glib::RefPtr<Glib::Source>(new ::Glib::Source($3))')
  //_WRAP_METHOD(Glib::RefPtr<Glib::Source> create_source(Glib::IOCondition condition, const Glib::RefPtr<Cancellable>& cancellable), g_socket_create_source)
  
  /** Checks on the readiness of @a socket to perform operations.  The
   * operations specified in @a condition are checked for and masked
   * against the currently-satisfied conditions on @a socket.  The result
   * is returned.
   * 
   * It is meaningless to specify IO_ERR or IO_HUP in condition;
   * these conditions will always be set in the output if they are true.
   * 
   * This call never blocks.
   * @param condition A IOCondition mask to check.
   * @return The @a GIOCondition mask of the current state
   * 
   * @newin2p22.
   */
  Glib::IOCondition condition_check(Glib::IOCondition condition);

  
  /** Waits for @a condition to become true on @a socket.  When the condition
   * becomes true, <tt>true</tt> is returned.
   * 
   * If @a cancellable is cancelled before the condition becomes true then
   * <tt>false</tt> is returned and @a error, if non-<tt>0</tt>, is set to IO_ERROR_CANCELLED.
   * @param condition A IOCondition mask to wait for.
   * @param cancellable A Cancellable, or <tt>0</tt>.
   * @return <tt>true</tt> if the condition was met, <tt>false</tt> otherwise
   * 
   * @newin2p22.
   */
#ifdef GLIBMM_EXCEPTIONS_ENABLED
  void condition_wait(Glib::IOCondition condition, const Glib::RefPtr<Cancellable>& cancellable);
#else
  void condition_wait(Glib::IOCondition condition, const Glib::RefPtr<Cancellable>& cancellable, std::auto_ptr<Glib::Error>& error);
#endif //GLIBMM_EXCEPTIONS_ENABLED

#ifdef GLIBMM_EXCEPTIONS_ENABLED
  void condition_wait(Glib::IOCondition condition);
#else
  void condition_wait(Glib::IOCondition condition, std::auto_ptr<Glib::Error>& error);
#endif //GLIBMM_EXCEPTIONS_ENABLED

  
  /** Sets the maximum number of outstanding connections allowed
   * when listening on this socket. If more clients than this are
   * connecting to the socket and the application is not handling them
   * on time then the new connections will be refused.
   * 
   * @newin2p22
   * @param backlog The maximum number of pending connections.
   */
  void set_listen_backlog(int backlog);
  
  /** Gets the listen backlog setting of the socket. For details on this,
   * see g_socket_set_listen_backlog().
   * @return The maximum number of pending connections.
   * 
   * @newin2p22.
   */
  int get_listen_backlog() const;
  
  /** Sets the blocking mode of the socket. In blocking mode
   * all operations block until they succeed or there is an error. In
   * non-blocking mode all functions return results immediately or
   * with a IO_ERROR_WOULD_BLOCK error.
   * 
   * All sockets are created in blocking mode. However, note that the
   * platform level socket is always non-blocking, and blocking mode
   * is a GSocket level feature.
   * 
   * @newin2p22
   * @param blocking Whether to use blocking I/O or not.
   */
  void set_blocking(bool blocking);
  
  /** Gets the blocking mode of the socket. For details on blocking I/O,
   * see g_socket_set_blocking().
   * @return <tt>true</tt> if blocking I/O is used, <tt>false</tt> otherwise.
   * 
   * @newin2p22.
   */
  bool get_blocking() const;
  
  /** Setting @a keepalive to <tt>true</tt> enables the sending of periodic ping requests
   * on idle connections in order to keep the connection alive. This is only
   * useful for connection oriented sockets. The exact period used between
   * each ping is system and protocol dependent.
   * 
   * Sending keepalive requests like this has a few disadvantages. For instance,
   * it uses more network bandwidth, and it makes your application more sensitive
   * to temporary outages in the network (i.e. if a cable is pulled your otherwise
   * idle connection could be terminated, whereas otherwise it would survive unless
   * actually used before the cable was reinserted). However, it is sometimes
   * useful to ensure that connections are eventually terminated if e.g. the
   * remote side is disconnected, so as to avoid leaking resources forever.
   * 
   * @newin2p22
   * @param keepalive Whether to use try to keep the connection alive or not.
   */
  void set_keepalive(bool keepalive);
  
  /** Gets the keepalive mode of the socket. For details on this,
   * see g_socket_set_keepalive().
   * @return <tt>true</tt> if keepalive is active, <tt>false</tt> otherwise.
   * 
   * @newin2p22.
   */
  bool get_keepalive() const;
  
  /** Gets the socket family of the socket.
   * @return A SocketFamily
   * 
   * @newin2p22.
   */
  SocketFamily get_family() const;
  
  /** Returns: the file descriptor of the socket.
   * @return The file descriptor of the socket.
   * 
   * @newin2p22.
   */
  int get_fd() const;
  
  /** Try to get the local address of a bound socket. This is only
   * useful if the socket has been bound to a local address.
   * @return A SocketAddress or <tt>0</tt> on error.
   * 
   * @newin2p22.
   */
#ifdef GLIBMM_EXCEPTIONS_ENABLED
  Glib::RefPtr<SocketAddress> get_local_address() const;
#else
  Glib::RefPtr<SocketAddress> get_local_address(std::auto_ptr<Glib::Error>& error) const;
#endif //GLIBMM_EXCEPTIONS_ENABLED

  
  /** Try to get the remove address of a connected socket. This is only
   * useful for connection oriented sockets that have been connected.
   * @return A SocketAddress or <tt>0</tt> on error.
   * 
   * @newin2p22.
   */
#ifdef GLIBMM_EXCEPTIONS_ENABLED
  Glib::RefPtr<SocketAddress> get_remote_address() const;
#else
  Glib::RefPtr<SocketAddress> get_remote_address(std::auto_ptr<Glib::Error>& error) const;
#endif //GLIBMM_EXCEPTIONS_ENABLED

  
  SocketProtocol get_protocol() const;
  
  /** Gets the socket type of the socket.
   * @return A SocketType
   * 
   * @newin2p22.
   */
  SocketType get_socket_type() const;
  
  bool speaks_ipv4() const;

  #ifdef GLIBMM_PROPERTIES_ENABLED
/** Whether or not I/O on this socket is blocking.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy<bool> property_blocking() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** Whether or not I/O on this socket is blocking.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<bool> property_blocking() const;
#endif //#GLIBMM_PROPERTIES_ENABLED

  #ifdef GLIBMM_PROPERTIES_ENABLED
/** The sockets address family.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<SocketFamily> property_family() const;
#endif //#GLIBMM_PROPERTIES_ENABLED


  #ifdef GLIBMM_PROPERTIES_ENABLED
/** The sockets file descriptor.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<int> property_fd() const;
#endif //#GLIBMM_PROPERTIES_ENABLED


  #ifdef GLIBMM_PROPERTIES_ENABLED
/** Keep connection alive by sending periodic pings.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy<bool> property_keepalive() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** Keep connection alive by sending periodic pings.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<bool> property_keepalive() const;
#endif //#GLIBMM_PROPERTIES_ENABLED

  #ifdef GLIBMM_PROPERTIES_ENABLED
/** Outstanding connections in the listen queue.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy<int> property_listen_backlog() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** Outstanding connections in the listen queue.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<int> property_listen_backlog() const;
#endif //#GLIBMM_PROPERTIES_ENABLED

  #ifdef GLIBMM_PROPERTIES_ENABLED
/** The local address the socket is bound to.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< Glib::RefPtr<SocketAddress> > property_local_address() const;
#endif //#GLIBMM_PROPERTIES_ENABLED


  #ifdef GLIBMM_PROPERTIES_ENABLED
/** The remote address the socket is connected to.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< Glib::RefPtr<SocketAddress> > property_remote_address() const;
#endif //#GLIBMM_PROPERTIES_ENABLED


  #ifdef GLIBMM_PROPERTIES_ENABLED
/** The id of the protocol to use
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<SocketProtocol> property_protocol() const;
#endif //#GLIBMM_PROPERTIES_ENABLED


  #ifdef GLIBMM_PROPERTIES_ENABLED
/** The sockets type.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<SocketType> property_type() const;
#endif //#GLIBMM_PROPERTIES_ENABLED


public:

public:
  //C++ methods used to invoke GTK+ virtual functions:
#ifdef GLIBMM_VFUNCS_ENABLED
#endif //GLIBMM_VFUNCS_ENABLED

protected:
  //GTK+ Virtual Functions (override these to change behaviour):
#ifdef GLIBMM_VFUNCS_ENABLED
#endif //GLIBMM_VFUNCS_ENABLED

  //Default Signal Handlers::
#ifdef GLIBMM_DEFAULT_SIGNAL_HANDLERS_ENABLED
#endif //GLIBMM_DEFAULT_SIGNAL_HANDLERS_ENABLED


};

} // namespace Gio


namespace Glib
{
  /** A Glib::wrap() method for this object.
   * 
   * @param object The C instance.
   * @param take_copy False if the result should take ownership of the C instance. True if it should take a new copy or ref.
   * @result A C++ instance that wraps this C instance.
   *
   * @relates Gio::Socket
   */
  Glib::RefPtr<Gio::Socket> wrap(GSocket* object, bool take_copy = false);
}


#endif /* _GIOMM_SOCKET_H */

