/* Glom
 *
 * Copyright (C) 2001-2004 Murray Cumming
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public
 * License along with this program; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

#ifndef GLOM_UTILITY_WIDGETS_ENTRY_GLOM_H
#define GLOM_UTILITY_WIDGETS_ENTRY_GLOM_H

#include <gtkmm.h>
#include "../data_structure/field.h"
#include <libglademm.h>

class App_Glom;

class EntryGlom
: public Gtk::Entry
{
public:
  explicit EntryGlom(BaseObjectType* cobject, const Glib::RefPtr<Gnome::Glade::Xml>& refGlade);
  explicit EntryGlom(Field::glom_field_type glom_type = Field::TYPE_TEXT);
  virtual ~EntryGlom();

  void set_glom_type(Field::glom_field_type glom_type);
 
  //Override this so we can store the text to compare later.
  //This is not virtual, so you must not use it via Gtk::Entry.
  void set_text(const Glib::ustring& text); //override

  /** Set the text from a Gnome::Gda::Value.
   */
  void set_value(const Gnome::Gda::Value& value);

  Gnome::Gda::Value get_value() const;

  typedef sigc::signal<void> type_signal_edited;
  type_signal_edited signal_edited();

  typedef sigc::signal<void> type_signal_user_requested_layout;
  type_signal_user_requested_layout signal_user_requested_layout(); 

protected:

  //Overrides of default signal handlers:
  virtual void on_changed(); //From Gtk::Entry.
  virtual void on_activate(); //From Gtk::Entry.
  virtual bool on_focus_out_event(GdkEventFocus* event); //From Gtk::Widget
  virtual void on_insert_text(const Glib::ustring& text, int* position); //From Gtk::Editable

  virtual void check_for_change();

  virtual void setup_menu();
  virtual bool on_button_press_event(GdkEventButton *event); //override
  virtual void on_menupopup_activate_layout();

  virtual App_Glom* get_application();

  type_signal_edited m_signal_edited;
  type_signal_user_requested_layout m_signal_user_requested_layout;

  Glib::ustring m_old_text;
  Field::glom_field_type m_glom_type; //Store the type so we can validate the text accordingly.

  Gtk::Menu* m_pMenuPopup;
  Glib::RefPtr<Gtk::ActionGroup> m_refActionGroup;
  Glib::RefPtr<Gtk::UIManager> m_refUIManager;
  Glib::RefPtr<Gtk::Action> m_refContextLayout;
};

#endif //GLOM_UTILITY_WIDGETS_ENTRY_GLOM_H

