/*
 *  GMF: The GNOME Media Framework
 *
 *  Copyright (C) 1999 Elliot Lee
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Library General Public
 *  License as published by the Free Software Foundation; either
 *  version 2 of the License, or (at your option) any later version.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Library General Public License for more details.
 *
 *  You should have received a copy of the GNU Library General Public
 *  License along with this library; if not, write to the Free
 *  Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 *  Author: Elliot Lee <sopwith@redhat.com>
 *
 */

#ifndef GNOME_GENERICFACTORY_H
#define GNOME_GENERICFACTORY_H 1

#include <libgnorba/gnorba.h>

/* GtkObject GnomeGenericFactory */
#define GNOME_TYPE_GENERIC_FACTORY	(gnome_generic_factory_get_type())
#define GNOME_GENERIC_FACTORY(obj)	(GTK_CHECK_CAST((obj), GNOME_TYPE_GENERIC_FACTORY, GnomeGenericFactory))
#define GNOME_GENERIC_FACTORY_CLASS(klass) (GTK_CHECK_CLASS_CAST((klass), GNOME_TYPE_GENERIC_FACTORY, GnomeGenericFactoryClass))
#define GNOME_IS_GENERIC_FACTORY(obj) (GTK_CHECK_TYPE((obj), GNOME_TYPE_GENERIC_FACTORY))
#define GNOME_IS_GENERIC_FACTORY_CLASS(klass) (GTK_CHECK_CLASS_TYPE((klass), GNOME_TYPE_GENERIC_FACTORY))

typedef struct {
  GtkObject object;
  POA_GNOME_GenericFactory servant;
  gpointer self;
  CORBA_Object corba_object;
  PortableServer_POA poa;
  gchar *goad_id;
} GnomeGenericFactory;

typedef struct {
  GtkObjectClass klass;

  void (*supports)(GnomeGenericFactory *factory,
		   const char *obj_goad_id,
		   gboolean *retval);
  void (*create_object)(GnomeGenericFactory *factory, const char *obj_goad_id,
			const GNOME_stringlist *params, CORBA_Object *retval);
} GnomeGenericFactoryClass;

GtkType gnome_generic_factory_get_type (void);
GtkObject *gnome_generic_factory_new(const char *goad_id);

#endif /* GMF_FILTER_H */
