/* properties.c -- properties dialog box and session management for character
 * picker applet. Much of this is adapted from modemlights/properties.c
 */

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "charpick.h"
#include <egg-screen-help.h>

static void
set_atk_relation (GtkWidget *label, GtkWidget *widget)
{
  AtkObject *atk_widget;
  AtkObject *atk_label;
  AtkRelationSet *relation_set;
  AtkRelation *relation;
  AtkObject *targets[1];

  atk_widget = gtk_widget_get_accessible (widget);
  atk_label = gtk_widget_get_accessible (label);
  
  /* set label-for relation */
  gtk_label_set_mnemonic_widget (GTK_LABEL (label), widget);	

  /* return if gail is not loaded */
  if (GTK_IS_ACCESSIBLE (atk_widget) == FALSE)
    return;

  /* set label-by relation */
  relation_set = atk_object_ref_relation_set (atk_widget);
  targets[0] = atk_label;
  relation = atk_relation_new (targets, 1, ATK_RELATION_LABELLED_BY);
  atk_relation_set_add (relation_set, relation);
  g_object_unref (G_OBJECT (relation)); 
}

static gchar *
run_edit_dialog (gchar *string, gchar *title)
{
	GtkWidget *dialog;
	GtkWidget *dbox;
	GtkWidget *vbox, *hbox;
	GtkWidget *entry;
	GtkWidget *label;
	gint retval;
	gchar *new;
	
	dialog = gtk_dialog_new_with_buttons (_(title), NULL,
							    GTK_DIALOG_DESTROY_WITH_PARENT |
							    GTK_DIALOG_MODAL, 
							    GTK_STOCK_CANCEL, GTK_RESPONSE_CANCEL,
							    GTK_STOCK_OK, GTK_RESPONSE_OK,
							    NULL);

	gtk_dialog_set_default_response (GTK_DIALOG (dialog), GTK_RESPONSE_OK);
	gtk_container_set_border_width (GTK_CONTAINER (dialog), 5);
	gtk_dialog_set_has_separator (GTK_DIALOG (dialog), FALSE);

	dbox = GTK_DIALOG (dialog)->vbox;
	
	vbox = gtk_vbox_new (FALSE, 12);
	gtk_box_pack_start (GTK_BOX (dbox), vbox, TRUE, TRUE, 0);
	gtk_container_set_border_width (GTK_CONTAINER (vbox), 5);
	
	hbox = gtk_hbox_new (FALSE, 12);
	gtk_box_pack_start (GTK_BOX (vbox), hbox, TRUE, TRUE, 0);
	
	label = gtk_label_new_with_mnemonic (_("_Palette:"));
	gtk_box_pack_start (GTK_BOX (hbox), label, FALSE, FALSE, 0);
		
	entry = gtk_entry_new ();
	gtk_label_set_mnemonic_widget (GTK_LABEL (label), entry);
	gtk_entry_set_activates_default (GTK_ENTRY (entry), TRUE);
	gtk_box_pack_start (GTK_BOX (hbox), entry, TRUE, TRUE, 0);
	if (string)
		gtk_entry_set_text (GTK_ENTRY (entry), string);
	gtk_widget_show_all (dialog);
	retval = gtk_dialog_run (GTK_DIALOG (dialog));
	
	if (retval != GTK_RESPONSE_OK) {
		gtk_widget_destroy (dialog);
		return NULL;
	}
	
	new = gtk_editable_get_chars (GTK_EDITABLE (entry), 0, -1);
	gtk_widget_destroy (dialog);
	
	if (!new || (strlen(new)==0))
		return NULL;
	return new;
}

static void
add_palette (GtkButton *buttonk, charpick_data *curr_data)
{
	GList *list = curr_data->chartable;
	gchar *new;
	GtkTreeModel *model;
	GtkTreeIter iter;
	GtkTreeSelection *selection;
	GtkTreePath *path;
		
	new = run_edit_dialog (NULL, _("Add Palette"));
	if (!new)
		return;
		
	list = g_list_append (list, new);
	save_chartable (curr_data);
  	populate_menu (curr_data);
  	
  	model = gtk_tree_view_get_model (GTK_TREE_VIEW (curr_data->pref_tree));
  	gtk_list_store_append (GTK_LIST_STORE (model), &iter);
	gtk_list_store_set (GTK_LIST_STORE (model), &iter, 0, new, 1, new, -1);
	selection = gtk_tree_view_get_selection (GTK_TREE_VIEW (curr_data->pref_tree));
	gtk_tree_selection_select_iter (selection, &iter);
	path = gtk_tree_model_get_path (model, &iter);
	gtk_tree_view_scroll_to_cell (GTK_TREE_VIEW (curr_data->pref_tree), path,
						  NULL, FALSE, 0.0, 0.0);
	gtk_tree_path_free (path);
}

static void
edit_palette (GtkButton *button, charpick_data *curr_data)
{
	GtkTreeSelection *selection;
	GtkTreeIter iter;
	GtkTreeModel *model;
	gchar *charlist, *new;
	GList *list;

	selection = gtk_tree_view_get_selection (GTK_TREE_VIEW (curr_data->pref_tree));
	
	if (!gtk_tree_selection_get_selected (selection, &model, &iter))
		return;
		
	gtk_tree_model_get (model, &iter, 1, &charlist, -1);
	
	new = run_edit_dialog (charlist, _("Edit Palette"));
	if (!new || (g_ascii_strcasecmp (new, charlist) == 0))
		return;
		
	list = g_list_find (curr_data->chartable, charlist);
	list->data = new;
	save_chartable (curr_data);
  	populate_menu (curr_data);
	gtk_list_store_set (GTK_LIST_STORE (model), &iter, 0, new, 1, new, -1);
	
	if (g_ascii_strcasecmp (curr_data->charlist, charlist) == 0) {
		curr_data->charlist = new;
		build_table (curr_data);
	}
	g_free (charlist);
	
}

static void
delete_palette (GtkButton *button, charpick_data *curr_data)
{
	GtkTreeSelection *selection;
	GtkTreeIter iter, next;
	GtkTreeModel *model;
	gchar *charlist;
	
	selection = gtk_tree_view_get_selection (GTK_TREE_VIEW (curr_data->pref_tree));
	
	if (!gtk_tree_selection_get_selected (selection, &model, &iter))
		return;
		
	gtk_tree_model_get (model, &iter, 1, &charlist, -1);
	
	curr_data->chartable = g_list_remove (curr_data->chartable, charlist);
	
	if (g_ascii_strcasecmp (curr_data->charlist, charlist) == 0) {
		curr_data->charlist = curr_data->chartable->data;
		build_table (curr_data);
	}
	g_free (charlist);
	
	save_chartable (curr_data);
  	populate_menu (curr_data);
  	
  	gtk_widget_grab_focus (curr_data->pref_tree);
  	next = iter;
	if (gtk_tree_model_iter_next (model, &next) )
		gtk_tree_selection_select_iter (selection, &next);
	else {
		GtkTreePath *path;
		path = gtk_tree_model_get_path (model, &iter);
		gtk_tree_path_prev (path);
		gtk_tree_selection_select_path (selection, path);
		gtk_tree_path_free (path);
	}
	gtk_list_store_remove (GTK_LIST_STORE (model), &iter);

}

static GtkWidget *
create_palettes_tree (charpick_data *curr_data, GtkWidget *label)
{
	GtkWidget *scrolled;
	GtkWidget *tree;
	GtkListStore *model;
	GtkCellRenderer *cell;
	GtkTreeViewColumn *column;
	GList *list = curr_data->chartable;
	
	scrolled = gtk_scrolled_window_new(NULL,NULL);
	gtk_scrolled_window_set_policy(GTK_SCROLLED_WINDOW(scrolled),
						GTK_POLICY_AUTOMATIC,
						GTK_POLICY_AUTOMATIC);
	
	model = gtk_list_store_new (2, G_TYPE_STRING, G_TYPE_POINTER);
	tree = gtk_tree_view_new_with_model (GTK_TREE_MODEL (model));
	curr_data->pref_tree = tree;
	gtk_label_set_mnemonic_widget (GTK_LABEL (label), tree);
	gtk_container_add (GTK_CONTAINER (scrolled), tree);
	g_object_unref (G_OBJECT (model));
	cell = gtk_cell_renderer_text_new ();
  	column = gtk_tree_view_column_new_with_attributes ("hello",
						    	   cell,
						     	   "text", 0,
						     	   NULL);
	gtk_tree_view_append_column (GTK_TREE_VIEW (tree), column);
        gtk_tree_view_set_headers_visible (GTK_TREE_VIEW (tree), FALSE);
        
        while (list) {
        	GtkTreeIter iter;
        	gchar *charlist = list->data;
        	
        	gtk_list_store_append (GTK_LIST_STORE (model), &iter);
		gtk_list_store_set (GTK_LIST_STORE (model), &iter, 0, charlist, 1, charlist, -1);
        
        	list = g_list_next (list);
        }

	return scrolled;

}

static GtkWidget *
create_hig_catagory (GtkWidget *main_box, gchar *title)
{
	GtkWidget *vbox, *vbox2, *hbox;
	GtkWidget *label;
	gchar *tmp;
		
	vbox = gtk_vbox_new (FALSE, 6);
	gtk_box_pack_start (GTK_BOX (main_box), vbox, TRUE, TRUE, 0);

	tmp = g_strdup_printf ("<b>%s</b>", title);
	label = gtk_label_new (NULL);
	gtk_misc_set_alignment (GTK_MISC (label), 0.0, 0.5);
	gtk_label_set_markup (GTK_LABEL (label), tmp);
	g_free (tmp);
	gtk_box_pack_start (GTK_BOX (vbox), label, FALSE, FALSE, 0);

	hbox = gtk_hbox_new (FALSE, 0);
	gtk_box_pack_start (GTK_BOX (vbox), hbox, TRUE, TRUE, 0);
	
	label = gtk_label_new ("    ");
	gtk_box_pack_start (GTK_BOX (hbox), label, FALSE, FALSE, 0);
	
	vbox2 = gtk_vbox_new (FALSE, 6);
	gtk_box_pack_start (GTK_BOX (hbox), vbox2, TRUE, TRUE, 0);

	return vbox2;
		
}

static void default_chars_frame_create(charpick_data *curr_data)
{
  GtkWidget *dialog = curr_data->propwindow;
  GtkWidget *dbox, *vbox, *vbox1, *vbox2, *vbox3;
  GtkWidget *hbox;
  GtkWidget *label;
  GtkWidget *scrolled;
  GtkWidget *button;

  dbox = GTK_DIALOG (dialog)->vbox;

  vbox = gtk_vbox_new (FALSE, 18);
  gtk_container_set_border_width (GTK_CONTAINER (vbox), 5);
  gtk_box_pack_start (GTK_BOX (dbox), vbox, TRUE, TRUE, 0);

  vbox1 = create_hig_catagory (vbox, _("Character Palette")); 
  
  vbox3 = gtk_vbox_new (FALSE, 6);
  gtk_box_pack_start (GTK_BOX (vbox1), vbox3, TRUE, TRUE, 0);
  
  label = gtk_label_new_with_mnemonic(_("Pal_ettes:"));
  gtk_box_pack_start(GTK_BOX(vbox3), label, FALSE, FALSE, 0);
  gtk_misc_set_alignment (GTK_MISC (label), 0.0, 0.5);
  gtk_widget_show(label);
	  
  hbox = gtk_hbox_new (FALSE, 12);
  gtk_box_pack_start (GTK_BOX (vbox3), hbox, TRUE, TRUE, 0); 
  scrolled = create_palettes_tree (curr_data, label);
  gtk_box_pack_start (GTK_BOX (hbox), scrolled, TRUE, TRUE, 0);
  
  vbox2 = gtk_vbox_new (FALSE, 6);
  gtk_box_pack_start (GTK_BOX (hbox), vbox2, FALSE, FALSE, 0);
  button = gtk_button_new_from_stock (GTK_STOCK_ADD);
  gtk_box_pack_start (GTK_BOX (vbox2), button, FALSE, FALSE, 0);
  g_signal_connect (G_OBJECT (button), "clicked",
  			     G_CALLBACK (add_palette), curr_data);
  button = gtk_button_new_from_stock (GTK_STOCK_PROPERTIES);
  gtk_box_pack_start (GTK_BOX (vbox2), button, FALSE, FALSE, 0);
  g_signal_connect (G_OBJECT (button), "clicked",
  			     G_CALLBACK (edit_palette), curr_data);
  button = gtk_button_new_from_stock (GTK_STOCK_DELETE);
  gtk_box_pack_start (GTK_BOX (vbox2), button, FALSE, FALSE, 0);
  g_signal_connect (G_OBJECT (button), "clicked",
  			     G_CALLBACK (delete_palette), curr_data);
   
  return;
}

static void
phelp_cb (GtkDialog *dialog, gint tab, gpointer data)
{
  GError *error = NULL;

  egg_help_display_on_screen (
		"char-palette", "charpick-prefs",
		gtk_window_get_screen (GTK_WINDOW (dialog)),
		&error);

  if (error) { /* FIXME: the user needs to see this */
    g_warning ("help error: %s\n", error->message);
    g_error_free (error);
    error = NULL;
  }
}

static void
response_cb (GtkDialog *dialog, gint id, gpointer data)
{
  charpick_data *curr_data = data;

  if(id == GTK_RESPONSE_HELP){
    phelp_cb (dialog,id,data);
    return;
  }
  
  gtk_widget_destroy (curr_data->propwindow);
  curr_data->propwindow = NULL;
  
}

void
show_preferences_dialog (BonoboUIComponent *uic,
			 charpick_data     *curr_data,
			 const gchar       *verbname)
{
  if (curr_data->propwindow) {
    gtk_window_set_screen (GTK_WINDOW (curr_data->propwindow),
			   gtk_widget_get_screen (curr_data->applet));
    gtk_window_present (GTK_WINDOW (curr_data->propwindow));
    return;
  }

  curr_data->propwindow = gtk_dialog_new_with_buttons (_("Character Palette Preferences"), 
  					    NULL,
					    GTK_DIALOG_DESTROY_WITH_PARENT,
					    GTK_STOCK_CLOSE, GTK_RESPONSE_CLOSE,
					    GTK_STOCK_HELP, GTK_RESPONSE_HELP,
					    NULL);
  gtk_window_set_screen (GTK_WINDOW (curr_data->propwindow),
			 gtk_widget_get_screen (curr_data->applet));
  gtk_window_set_default_size (GTK_WINDOW (curr_data->propwindow), 350, 350);
  gtk_container_set_border_width (GTK_CONTAINER (curr_data->propwindow), 5);
  gtk_dialog_set_default_response (GTK_DIALOG (curr_data->propwindow), GTK_RESPONSE_CLOSE);
  gtk_dialog_set_has_separator (GTK_DIALOG (curr_data->propwindow), FALSE);

  default_chars_frame_create(curr_data);
  g_signal_connect (G_OBJECT (curr_data->propwindow), "response",
  		    G_CALLBACK (response_cb), curr_data);
  		    
  gtk_widget_show_all (curr_data->propwindow);
}
