/* spice-display.c generated by valac 0.26.1, the Vala compiler
 * generated from spice-display.vala, do not modify */

/* This file is part of GNOME Boxes. License: LGPLv2+*/

#include <glib.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include <gdk-pixbuf/gdk-pixbuf.h>
#include <libcommon.h>
#include <stdlib.h>
#include <string.h>
#include <spice-client.h>
#include <spice-widget.h>
#include <glib/gi18n-lib.h>
#include <config.h>
#include <gio/gio.h>
#include <libxml/uri.h>


#define BOXES_TYPE_IPROPERTIES_PROVIDER (boxes_iproperties_provider_get_type ())
#define BOXES_IPROPERTIES_PROVIDER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), BOXES_TYPE_IPROPERTIES_PROVIDER, BoxesIPropertiesProvider))
#define BOXES_IS_IPROPERTIES_PROVIDER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), BOXES_TYPE_IPROPERTIES_PROVIDER))
#define BOXES_IPROPERTIES_PROVIDER_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), BOXES_TYPE_IPROPERTIES_PROVIDER, BoxesIPropertiesProviderIface))

typedef struct _BoxesIPropertiesProvider BoxesIPropertiesProvider;
typedef struct _BoxesIPropertiesProviderIface BoxesIPropertiesProviderIface;

#define BOXES_TYPE_PROPERTIES_PAGE (boxes_properties_page_get_type ())

#define TYPE_PROPERTY_CREATION_FLAG (property_creation_flag_get_type ())

#define BOXES_TYPE_PROPERTY (boxes_property_get_type ())
#define BOXES_PROPERTY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), BOXES_TYPE_PROPERTY, BoxesProperty))
#define BOXES_PROPERTY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), BOXES_TYPE_PROPERTY, BoxesPropertyClass))
#define BOXES_IS_PROPERTY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), BOXES_TYPE_PROPERTY))
#define BOXES_IS_PROPERTY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), BOXES_TYPE_PROPERTY))
#define BOXES_PROPERTY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), BOXES_TYPE_PROPERTY, BoxesPropertyClass))

typedef struct _BoxesProperty BoxesProperty;
typedef struct _BoxesPropertyClass BoxesPropertyClass;

#define BOXES_TYPE_DISPLAY (boxes_display_get_type ())
#define BOXES_DISPLAY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), BOXES_TYPE_DISPLAY, BoxesDisplay))
#define BOXES_DISPLAY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), BOXES_TYPE_DISPLAY, BoxesDisplayClass))
#define BOXES_IS_DISPLAY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), BOXES_TYPE_DISPLAY))
#define BOXES_IS_DISPLAY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), BOXES_TYPE_DISPLAY))
#define BOXES_DISPLAY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), BOXES_TYPE_DISPLAY, BoxesDisplayClass))

typedef struct _BoxesDisplay BoxesDisplay;
typedef struct _BoxesDisplayClass BoxesDisplayClass;
typedef struct _BoxesDisplayPrivate BoxesDisplayPrivate;

#define BOXES_TYPE_SPICE_DISPLAY (boxes_spice_display_get_type ())
#define BOXES_SPICE_DISPLAY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), BOXES_TYPE_SPICE_DISPLAY, BoxesSpiceDisplay))
#define BOXES_SPICE_DISPLAY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), BOXES_TYPE_SPICE_DISPLAY, BoxesSpiceDisplayClass))
#define BOXES_IS_SPICE_DISPLAY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), BOXES_TYPE_SPICE_DISPLAY))
#define BOXES_IS_SPICE_DISPLAY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), BOXES_TYPE_SPICE_DISPLAY))
#define BOXES_SPICE_DISPLAY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), BOXES_TYPE_SPICE_DISPLAY, BoxesSpiceDisplayClass))

typedef struct _BoxesSpiceDisplay BoxesSpiceDisplay;
typedef struct _BoxesSpiceDisplayClass BoxesSpiceDisplayClass;
typedef struct _BoxesSpiceDisplayPrivate BoxesSpiceDisplayPrivate;

#define BOXES_TYPE_COLLECTION_ITEM (boxes_collection_item_get_type ())
#define BOXES_COLLECTION_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), BOXES_TYPE_COLLECTION_ITEM, BoxesCollectionItem))
#define BOXES_COLLECTION_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), BOXES_TYPE_COLLECTION_ITEM, BoxesCollectionItemClass))
#define BOXES_IS_COLLECTION_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), BOXES_TYPE_COLLECTION_ITEM))
#define BOXES_IS_COLLECTION_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), BOXES_TYPE_COLLECTION_ITEM))
#define BOXES_COLLECTION_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), BOXES_TYPE_COLLECTION_ITEM, BoxesCollectionItemClass))

typedef struct _BoxesCollectionItem BoxesCollectionItem;
typedef struct _BoxesCollectionItemClass BoxesCollectionItemClass;

#define BOXES_TYPE_MACHINE (boxes_machine_get_type ())
#define BOXES_MACHINE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), BOXES_TYPE_MACHINE, BoxesMachine))
#define BOXES_MACHINE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), BOXES_TYPE_MACHINE, BoxesMachineClass))
#define BOXES_IS_MACHINE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), BOXES_TYPE_MACHINE))
#define BOXES_IS_MACHINE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), BOXES_TYPE_MACHINE))
#define BOXES_MACHINE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), BOXES_TYPE_MACHINE, BoxesMachineClass))

typedef struct _BoxesMachine BoxesMachine;
typedef struct _BoxesMachineClass BoxesMachineClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define BOXES_TYPE_UI (boxes_ui_get_type ())
#define BOXES_UI(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), BOXES_TYPE_UI, BoxesUI))
#define BOXES_IS_UI(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), BOXES_TYPE_UI))
#define BOXES_UI_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), BOXES_TYPE_UI, BoxesUIIface))

typedef struct _BoxesUI BoxesUI;
typedef struct _BoxesUIIface BoxesUIIface;

#define BOXES_TYPE_UI_STATE (boxes_ui_state_get_type ())
#define _g_free0(var) (var = (g_free (var), NULL))
#define __vala_SpiceUsbDevice_free0(var) ((var == NULL) ? NULL : (var = (_vala_SpiceUsbDevice_free (var), NULL)))
#define _g_ptr_array_unref0(var) ((var == NULL) ? NULL : (var = (g_ptr_array_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _Block64Data Block64Data;
typedef struct _Block65Data Block65Data;
typedef struct _Block66Data Block66Data;
typedef struct _Block67Data Block67Data;
typedef struct _Block68Data Block68Data;
#define __g_list_free__g_object_unref0_0(var) ((var == NULL) ? NULL : (var = (_g_list_free__g_object_unref0_ (var), NULL)))
#define _xmlFreeURI0(var) ((var == NULL) ? NULL : (var = (xmlFreeURI (var), NULL)))

typedef enum  {
	BOXES_PROPERTIES_PAGE_LOGIN,
	BOXES_PROPERTIES_PAGE_SYSTEM,
	BOXES_PROPERTIES_PAGE_DISPLAY,
	BOXES_PROPERTIES_PAGE_DEVICES,
	BOXES_PROPERTIES_PAGE_SNAPSHOTS,
	BOXES_PROPERTIES_PAGE_LAST
} BoxesPropertiesPage;

typedef enum  {
	PROPERTY_CREATION_FLAG_NONE = 1 << 0,
	PROPERTY_CREATION_FLAG_NO_USB = 1 << 1
} PropertyCreationFlag;

struct _BoxesIPropertiesProviderIface {
	GTypeInterface parent_iface;
	GList* (*get_properties) (BoxesIPropertiesProvider* self, BoxesPropertiesPage page, PropertyCreationFlag* flags);
};

struct _BoxesDisplay {
	GObject parent_instance;
	BoxesDisplayPrivate * priv;
	gboolean connected;
	GHashTable* displays;
};

struct _BoxesDisplayClass {
	GObjectClass parent_class;
	GtkWidget* (*get_display) (BoxesDisplay* self, gint n);
	GdkPixbuf* (*get_pixbuf) (BoxesDisplay* self, gint n, GError** error);
	void (*set_enable_inputs) (BoxesDisplay* self, GtkWidget* widget, gboolean enable);
	void (*set_enable_audio) (BoxesDisplay* self, gboolean enable);
	gboolean (*should_keep_alive) (BoxesDisplay* self);
	void (*connect_it) (BoxesDisplay* self, GError** error);
	void (*disconnect_it) (BoxesDisplay* self);
	void (*collect_logs) (BoxesDisplay* self, GString* builder);
	GList* (*get_properties) (BoxesDisplay* self, BoxesPropertiesPage page, PropertyCreationFlag* flags);
	const gchar* (*get_protocol) (BoxesDisplay* self);
	gchar* (*get_uri) (BoxesDisplay* self);
};

struct _BoxesSpiceDisplay {
	BoxesDisplay parent_instance;
	BoxesSpiceDisplayPrivate * priv;
};

struct _BoxesSpiceDisplayClass {
	BoxesDisplayClass parent_class;
};

struct _BoxesSpiceDisplayPrivate {
	BoxesMachine* machine;
	SpiceSession* session;
	SpiceGtkSession* gtk_session;
	SpiceAudio* audio;
	gulong channel_new_id;
	gulong channel_destroy_id;
	BoxesBoxConfigSyncProperty* display_sync_properties;
	gint display_sync_properties_length1;
	gint _display_sync_properties_size_;
	BoxesBoxConfigSyncProperty* gtk_session_sync_properties;
	gint gtk_session_sync_properties_length1;
	gint _gtk_session_sync_properties_size_;
	gboolean closed;
	gboolean _resize_guest;
	SpiceMainChannel* main_channel;
	gulong main_event_id;
	gulong main_mouse_mode_id;
};

typedef enum  {
	BOXES_UI_STATE_NONE,
	BOXES_UI_STATE_COLLECTION,
	BOXES_UI_STATE_CREDS,
	BOXES_UI_STATE_DISPLAY,
	BOXES_UI_STATE_WIZARD,
	BOXES_UI_STATE_PROPERTIES
} BoxesUIState;

struct _BoxesUIIface {
	GTypeInterface parent_iface;
	BoxesUIState (*get_previous_ui_state) (BoxesUI* self);
	void (*set_previous_ui_state) (BoxesUI* self, BoxesUIState value);
	BoxesUIState (*get_ui_state) (BoxesUI* self);
	void (*set_ui_state) (BoxesUI* self, BoxesUIState value);
};

struct _Block64Data {
	int _ref_count_;
	BoxesSpiceDisplay* self;
	SpiceDisplay* display;
};

struct _Block65Data {
	int _ref_count_;
	BoxesSpiceDisplay* self;
	BoxesProperty* usb_property;
};

struct _Block66Data {
	int _ref_count_;
	Block65Data * _data65_;
	SpiceUsbDeviceManager* manager;
};

struct _Block67Data {
	int _ref_count_;
	GPtrArray* self;
	GCompareFunc compare_func;
};

struct _Block68Data {
	int _ref_count_;
	Block66Data * _data66_;
	SpiceUsbDevice* dev;
	GtkSwitch* dev_toggle;
};


static gpointer boxes_spice_display_parent_class = NULL;

GType boxes_properties_page_get_type (void) G_GNUC_CONST;
GType property_creation_flag_get_type (void) G_GNUC_CONST;
GType boxes_property_get_type (void) G_GNUC_CONST;
GType boxes_iproperties_provider_get_type (void) G_GNUC_CONST;
GType boxes_display_get_type (void) G_GNUC_CONST;
GType boxes_spice_display_get_type (void) G_GNUC_CONST;
GType boxes_collection_item_get_type (void) G_GNUC_CONST;
GType boxes_machine_get_type (void) G_GNUC_CONST;
#define BOXES_SPICE_DISPLAY_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), BOXES_TYPE_SPICE_DISPLAY, BoxesSpiceDisplayPrivate))
enum  {
	BOXES_SPICE_DISPLAY_DUMMY_PROPERTY,
	BOXES_SPICE_DISPLAY_PROTOCOL,
	BOXES_SPICE_DISPLAY_URI,
	BOXES_SPICE_DISPLAY_CA_CERT,
	BOXES_SPICE_DISPLAY_RESIZE_GUEST
};
static void boxes_spice_display_main_cleanup (BoxesSpiceDisplay* self);
static void _vala_BoxesBoxConfigSyncProperty_array_free (BoxesBoxConfigSyncProperty* array, gint array_length);
static void boxes_spice_display_ui_state_changed (BoxesSpiceDisplay* self);
GType boxes_ui_state_get_type (void) G_GNUC_CONST;
GType boxes_ui_get_type (void) G_GNUC_CONST;
BoxesUIState boxes_ui_get_ui_state (BoxesUI* self);
GtkWidget* boxes_display_get_display (BoxesDisplay* self, gint n);
gboolean boxes_spice_display_get_resize_guest (BoxesSpiceDisplay* self);
static gchar* boxes_spice_display_get_box_name (BoxesSpiceDisplay* self);
BoxesBoxConfig* boxes_display_get_config (BoxesDisplay* self);
BoxesSpiceDisplay* boxes_spice_display_new (BoxesMachine* machine, BoxesBoxConfig* config, const gchar* host, gint port, gint tls_port, const gchar* host_subject);
BoxesSpiceDisplay* boxes_spice_display_construct (GType object_type, BoxesMachine* machine, BoxesBoxConfig* config, const gchar* host, gint port, gint tls_port, const gchar* host_subject);
BoxesDisplay* boxes_display_construct (GType object_type);
static void _boxes_spice_display_ui_state_changed_g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self);
void boxes_display_set_config (BoxesDisplay* self, BoxesBoxConfig* value);
BoxesSpiceDisplay* boxes_spice_display_new_with_uri (BoxesMachine* machine, BoxesBoxConfig* config, const gchar* uri);
BoxesSpiceDisplay* boxes_spice_display_construct_with_uri (GType object_type, BoxesMachine* machine, BoxesBoxConfig* config, const gchar* uri);
static GtkWidget* boxes_spice_display_real_get_display (BoxesDisplay* base, gint n);
static void ___lambda103_ (BoxesSpiceDisplay* self, gint status);
void boxes_display_set_mouse_grabbed (BoxesDisplay* self, gboolean value);
static void ____lambda103__spice_display_mouse_grab (SpiceDisplay* _sender, gint grabbed, gpointer self);
static gboolean boxes_spice_display_has_usb_device_connected (BoxesSpiceDisplay* self);
static SpiceUsbDevice* _vala_SpiceUsbDevice_copy (SpiceUsbDevice* self);
static void _vala_SpiceUsbDevice_free (SpiceUsbDevice* self);
static gboolean boxes_spice_display_real_should_keep_alive (BoxesDisplay* base);
static void boxes_spice_display_real_set_enable_audio (BoxesDisplay* base, gboolean enable);
static void boxes_spice_display_real_set_enable_inputs (BoxesDisplay* base, GtkWidget* widget, gboolean enable);
static GdkPixbuf* boxes_spice_display_real_get_pixbuf (BoxesDisplay* base, gint n, GError** error);
static void boxes_spice_display_real_collect_logs (BoxesDisplay* base, GString* builder);
gchar* boxes_display_get_uri (BoxesDisplay* self);
static void boxes_spice_display_real_connect_it (BoxesDisplay* base, GError** error);
static void ___lambda104_ (BoxesSpiceDisplay* self, SpiceChannel* channel);
static void boxes_spice_display_main_event (BoxesSpiceDisplay* self, SpiceChannelEvent event);
static void _boxes_spice_display_main_event_spice_channel_channel_event (SpiceChannel* _sender, SpiceChannelEvent event, gpointer self);
static void ___lambda105_ (BoxesSpiceDisplay* self);
void boxes_display_set_can_grab_mouse (BoxesDisplay* self, gboolean value);
static void ____lambda105__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self);
static Block64Data* block64_data_ref (Block64Data* _data64_);
static void block64_data_unref (void * _userdata_);
void boxes_display_access_start (BoxesDisplay* self);
static void ___lambda106_ (Block64Data* _data64_);
static void ____lambda106__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self);
static void ____lambda104__spice_session_channel_new (SpiceSession* _sender, SpiceChannel* channel, gpointer self);
static void ___lambda107_ (BoxesSpiceDisplay* self, SpiceChannel* channel);
void boxes_display_access_finish (BoxesDisplay* self);
static void ____lambda107__spice_session_channel_destroy (SpiceSession* _sender, SpiceChannel* channel, gpointer self);
const gchar* boxes_display_get_password (BoxesDisplay* self);
static void boxes_spice_display_real_disconnect_it (BoxesDisplay* base);
void boxes_display_set_need_password (BoxesDisplay* self, gboolean value);
static GList* boxes_spice_display_real_get_properties (BoxesDisplay* base, BoxesPropertiesPage page, PropertyCreationFlag* flags);
BoxesProperty* boxes_iproperties_provider_add_property (BoxesIPropertiesProvider* self, GList** list, const gchar* name, GtkWidget* widget, GtkWidget* extra_widget);
static Block65Data* block65_data_ref (Block65Data* _data65_);
static void block65_data_unref (void * _userdata_);
static Block66Data* block66_data_ref (Block66Data* _data66_);
static void block66_data_unref (void * _userdata_);
static Block67Data* block67_data_ref (Block67Data* _data67_);
static void block67_data_unref (void * _userdata_);
static gint ___lambda1__gcompare_data_func (gconstpointer a, gconstpointer b, gpointer self);
static gint ______lambda108_ (SpiceUsbDevice* a, SpiceUsbDevice* b);
static gint _______lambda108__gcompare_func (gconstpointer a, gconstpointer b);
static Block68Data* block68_data_ref (Block68Data* _data68_);
static void block68_data_unref (void * _userdata_);
static void _________lambda109_ (Block68Data* _data68_);
static void ___lambda110_ (Block68Data* _data68_, GObject* obj, GAsyncResult* res);
static void ____lambda110__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self);
static void __________lambda109__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self);
static void ______lambda111_ (Block66Data* _data66_, SpiceUsbDeviceManager* manager, SpiceUsbDevice* dev);
static void _______lambda111__spice_usb_device_manager_device_added (SpiceUsbDeviceManager* _sender, SpiceUsbDevice* device, gpointer self);
static void ______lambda112_ (Block66Data* _data66_, SpiceUsbDeviceManager* manager, SpiceUsbDevice* dev);
static gboolean __lambda113_ (Block66Data* _data66_);
static gboolean ___lambda113__gsource_func (gpointer self);
static void _______lambda112__spice_usb_device_manager_device_removed (SpiceUsbDeviceManager* _sender, SpiceUsbDevice* device, gpointer self);
static void _g_object_unref0_ (gpointer var);
static void _g_list_free__g_object_unref0_ (GList* self);
GByteArray* boxes_spice_display_get_ca_cert (BoxesSpiceDisplay* self);
void boxes_spice_display_set_ca_cert (BoxesSpiceDisplay* self, GByteArray* value);
void boxes_spice_display_set_resize_guest (BoxesSpiceDisplay* self, gboolean value);
static GObject * boxes_spice_display_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties);
static void _boxes_spice_display____lambda114_ (BoxesSpiceDisplay* self, SpiceUsbDevice* dev, GError* err);
static void __boxes_spice_display____lambda114__spice_usb_device_manager_auto_connect_failed (SpiceUsbDeviceManager* _sender, SpiceUsbDevice* device, GError* _error_, gpointer self);
static void _boxes_spice_display____lambda115_ (BoxesSpiceDisplay* self, SpiceUsbDevice* dev, GError* err);
static void __boxes_spice_display____lambda115__spice_usb_device_manager_device_error (SpiceUsbDeviceManager* _sender, SpiceUsbDevice* device, GError* _error_, gpointer self);
static void _boxes_spice_display___lambda116_ (BoxesSpiceDisplay* self);
static void __boxes_spice_display___lambda116__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self);
static void boxes_spice_display_finalize (GObject* obj);
const gchar* boxes_display_get_protocol (BoxesDisplay* self);
static void _vala_boxes_spice_display_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_boxes_spice_display_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
void spice_validate_uri (const gchar* uri_as_text, gint** port, gint** tls_port, GError** error);
static gint* _int_dup (gint* self);


static void _vala_BoxesBoxConfigSyncProperty_array_free (BoxesBoxConfigSyncProperty* array, gint array_length) {
#line 17 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	if (array != NULL) {
#line 340 "spice-display.c"
		int i;
#line 17 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
		for (i = 0; i < array_length; i = i + 1) {
#line 17 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
			boxes_box_config_sync_property_destroy (&array[i]);
#line 346 "spice-display.c"
		}
	}
#line 17 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	g_free (array);
#line 351 "spice-display.c"
}


static void boxes_spice_display_ui_state_changed (BoxesSpiceDisplay* self) {
	BoxesMachine* _tmp0_ = NULL;
	BoxesUIState _tmp1_ = 0;
	BoxesUIState _tmp2_ = 0;
#line 22 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	g_return_if_fail (self != NULL);
#line 24 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	_tmp0_ = self->priv->machine;
#line 24 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	_tmp1_ = boxes_ui_get_ui_state ((BoxesUI*) _tmp0_);
#line 24 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	_tmp2_ = _tmp1_;
#line 24 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	if (_tmp2_ == BOXES_UI_STATE_DISPLAY) {
#line 369 "spice-display.c"
		SpiceDisplay* display = NULL;
		GtkWidget* _tmp3_ = NULL;
		SpiceDisplay* _tmp4_ = NULL;
		SpiceDisplay* _tmp5_ = NULL;
		gboolean _tmp6_ = FALSE;
#line 26 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
		_tmp3_ = boxes_display_get_display ((BoxesDisplay*) self, 0);
#line 26 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
		_tmp4_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp3_, spice_display_get_type ()) ? ((SpiceDisplay*) _tmp3_) : NULL;
#line 26 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
		if (_tmp4_ == NULL) {
#line 26 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
			_g_object_unref0 (_tmp3_);
#line 383 "spice-display.c"
		}
#line 26 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
		display = _tmp4_;
#line 27 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
		_tmp5_ = display;
#line 27 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
		_tmp6_ = self->priv->_resize_guest;
#line 27 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
		g_object_set (_tmp5_, "resize-guest", _tmp6_, NULL);
#line 24 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
		_g_object_unref0 (display);
#line 395 "spice-display.c"
	}
}


static gchar* boxes_spice_display_get_box_name (BoxesSpiceDisplay* self) {
	gchar* result = NULL;
	gchar* _tmp0_ = NULL;
	BoxesBoxConfig* _tmp1_ = NULL;
	BoxesBoxConfig* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	gchar* _tmp4_ = NULL;
	gchar* _tmp7_ = NULL;
#line 31 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 33 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	_tmp1_ = boxes_display_get_config ((BoxesDisplay*) self);
#line 33 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	_tmp2_ = _tmp1_;
#line 33 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	_tmp3_ = boxes_box_config_get_last_seen_name (_tmp2_);
#line 33 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	_tmp4_ = _tmp3_;
#line 33 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	_tmp0_ = _tmp4_;
#line 33 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	if (_tmp0_ == NULL) {
#line 422 "spice-display.c"
		const gchar* _tmp5_ = NULL;
		gchar* _tmp6_ = NULL;
#line 33 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
		_tmp5_ = _ ("Unknown");
#line 33 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
		_tmp6_ = g_strdup (_tmp5_);
#line 33 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
		_g_free0 (_tmp0_);
#line 33 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
		_tmp0_ = _tmp6_;
#line 433 "spice-display.c"
	}
#line 33 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	_tmp7_ = _tmp0_;
#line 33 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	_tmp0_ = NULL;
#line 33 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	result = _tmp7_;
#line 33 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	_g_free0 (_tmp0_);
#line 33 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	return result;
#line 445 "spice-display.c"
}


static gpointer _g_object_ref0 (gpointer self) {
#line 82 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	return self ? g_object_ref (self) : NULL;
#line 452 "spice-display.c"
}


static void boxes_spice_display_main_cleanup (BoxesSpiceDisplay* self) {
	SpiceMainChannel* _tmp0_ = NULL;
	GObject* o = NULL;
	SpiceMainChannel* _tmp1_ = NULL;
	GObject* _tmp2_ = NULL;
	GObject* _tmp3_ = NULL;
	gulong _tmp4_ = 0UL;
	GObject* _tmp5_ = NULL;
	gulong _tmp6_ = 0UL;
#line 78 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	g_return_if_fail (self != NULL);
#line 79 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	_tmp0_ = self->priv->main_channel;
#line 79 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	if (_tmp0_ == NULL) {
#line 80 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
		return;
#line 473 "spice-display.c"
	}
#line 82 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	_tmp1_ = self->priv->main_channel;
#line 82 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	_tmp2_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp1_, G_TYPE_OBJECT) ? ((GObject*) _tmp1_) : NULL);
#line 82 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	o = _tmp2_;
#line 83 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	_tmp3_ = o;
#line 83 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	_tmp4_ = self->priv->main_event_id;
#line 83 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	g_signal_handler_disconnect (_tmp3_, _tmp4_);
#line 84 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	self->priv->main_event_id = (gulong) 0;
#line 85 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	_tmp5_ = o;
#line 85 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	_tmp6_ = self->priv->main_mouse_mode_id;
#line 85 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	g_signal_handler_disconnect (_tmp5_, _tmp6_);
#line 86 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	self->priv->main_mouse_mode_id = (gulong) 0;
#line 87 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	_g_object_unref0 (self->priv->main_channel);
#line 87 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	self->priv->main_channel = NULL;
#line 78 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	_g_object_unref0 (o);
#line 503 "spice-display.c"
}


static void _boxes_spice_display_ui_state_changed_g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self) {
#line 97 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	boxes_spice_display_ui_state_changed ((BoxesSpiceDisplay*) self);
#line 510 "spice-display.c"
}


BoxesSpiceDisplay* boxes_spice_display_construct (GType object_type, BoxesMachine* machine, BoxesBoxConfig* config, const gchar* host, gint port, gint tls_port, const gchar* host_subject) {
	BoxesSpiceDisplay * self = NULL;
	gint _tmp0_ = 0;
	gint _tmp1_ = 0;
	BoxesMachine* _tmp2_ = NULL;
	BoxesMachine* _tmp3_ = NULL;
	BoxesBoxConfig* _tmp4_ = NULL;
	SpiceSession* _tmp5_ = NULL;
	const gchar* _tmp6_ = NULL;
	gint _tmp7_ = 0;
	gint _tmp12_ = 0;
	const gchar* _tmp17_ = NULL;
#line 94 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	g_return_val_if_fail (machine != NULL, NULL);
#line 94 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	g_return_val_if_fail (config != NULL, NULL);
#line 94 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	g_return_val_if_fail (host != NULL, NULL);
#line 94 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	_tmp0_ = port;
#line 94 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	_tmp1_ = tls_port;
#line 94 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	g_return_val_if_fail ((_tmp0_ != 0) || (_tmp1_ != 0), NULL);
#line 94 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	self = (BoxesSpiceDisplay*) boxes_display_construct (object_type);
#line 96 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	_tmp2_ = machine;
#line 96 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	self->priv->machine = _tmp2_;
#line 97 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	_tmp3_ = machine;
#line 97 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	g_signal_connect_object ((GObject*) _tmp3_, "notify::ui-state", (GCallback) _boxes_spice_display_ui_state_changed_g_object_notify, self, 0);
#line 99 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	_tmp4_ = config;
#line 99 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	boxes_display_set_config ((BoxesDisplay*) self, _tmp4_);
#line 101 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	_tmp5_ = self->priv->session;
#line 101 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	_tmp6_ = host;
#line 101 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	g_object_set (_tmp5_, "host", _tmp6_, NULL);
#line 102 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	_tmp7_ = port;
#line 102 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	if (_tmp7_ != 0) {
#line 562 "spice-display.c"
		SpiceSession* _tmp8_ = NULL;
		gint _tmp9_ = 0;
		gchar* _tmp10_ = NULL;
		gchar* _tmp11_ = NULL;
#line 103 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
		_tmp8_ = self->priv->session;
#line 103 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
		_tmp9_ = port;
#line 103 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
		_tmp10_ = g_strdup_printf ("%i", _tmp9_);
#line 103 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
		_tmp11_ = _tmp10_;
#line 103 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
		g_object_set (_tmp8_, "port", _tmp11_, NULL);
#line 103 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
		_g_free0 (_tmp11_);
#line 579 "spice-display.c"
	}
#line 105 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	_tmp12_ = tls_port;
#line 105 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	if (_tmp12_ != 0) {
#line 585 "spice-display.c"
		SpiceSession* _tmp13_ = NULL;
		gint _tmp14_ = 0;
		gchar* _tmp15_ = NULL;
		gchar* _tmp16_ = NULL;
#line 106 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
		_tmp13_ = self->priv->session;
#line 106 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
		_tmp14_ = tls_port;
#line 106 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
		_tmp15_ = g_strdup_printf ("%i", _tmp14_);
#line 106 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
		_tmp16_ = _tmp15_;
#line 106 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
		g_object_set (_tmp13_, "tls-port", _tmp16_, NULL);
#line 106 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
		_g_free0 (_tmp16_);
#line 602 "spice-display.c"
	}
#line 112 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	_tmp17_ = host_subject;
#line 112 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	if (_tmp17_ != NULL) {
#line 608 "spice-display.c"
		SpiceSession* _tmp18_ = NULL;
		const gchar* _tmp19_ = NULL;
#line 113 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
		_tmp18_ = self->priv->session;
#line 113 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
		_tmp19_ = host_subject;
#line 113 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
		g_object_set (_tmp18_, "cert-subject", _tmp19_, NULL);
#line 617 "spice-display.c"
	} else {
		SpiceSession* _tmp20_ = NULL;
		const gchar* _tmp21_ = NULL;
#line 115 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
		_tmp20_ = self->priv->session;
#line 115 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
		_tmp21_ = g_getenv ("BOXES_SPICE_HOST_SUBJECT");
#line 115 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
		g_object_set (_tmp20_, "cert-subject", _tmp21_, NULL);
#line 627 "spice-display.c"
	}
#line 94 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	return self;
#line 631 "spice-display.c"
}


BoxesSpiceDisplay* boxes_spice_display_new (BoxesMachine* machine, BoxesBoxConfig* config, const gchar* host, gint port, gint tls_port, const gchar* host_subject) {
#line 94 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	return boxes_spice_display_construct (BOXES_TYPE_SPICE_DISPLAY, machine, config, host, port, tls_port, host_subject);
#line 638 "spice-display.c"
}


BoxesSpiceDisplay* boxes_spice_display_construct_with_uri (GType object_type, BoxesMachine* machine, BoxesBoxConfig* config, const gchar* uri) {
	BoxesSpiceDisplay * self = NULL;
	BoxesMachine* _tmp0_ = NULL;
	BoxesMachine* _tmp1_ = NULL;
	BoxesBoxConfig* _tmp2_ = NULL;
	SpiceSession* _tmp3_ = NULL;
	const gchar* _tmp4_ = NULL;
#line 118 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	g_return_val_if_fail (machine != NULL, NULL);
#line 118 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	g_return_val_if_fail (config != NULL, NULL);
#line 118 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	g_return_val_if_fail (uri != NULL, NULL);
#line 118 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	self = (BoxesSpiceDisplay*) boxes_display_construct (object_type);
#line 119 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	_tmp0_ = machine;
#line 119 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	self->priv->machine = _tmp0_;
#line 120 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	_tmp1_ = machine;
#line 120 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	g_signal_connect_object ((GObject*) _tmp1_, "notify::ui-state", (GCallback) _boxes_spice_display_ui_state_changed_g_object_notify, self, 0);
#line 122 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	_tmp2_ = config;
#line 122 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	boxes_display_set_config ((BoxesDisplay*) self, _tmp2_);
#line 124 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	_tmp3_ = self->priv->session;
#line 124 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	_tmp4_ = uri;
#line 124 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	g_object_set (_tmp3_, "uri", _tmp4_, NULL);
#line 118 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	return self;
#line 677 "spice-display.c"
}


BoxesSpiceDisplay* boxes_spice_display_new_with_uri (BoxesMachine* machine, BoxesBoxConfig* config, const gchar* uri) {
#line 118 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	return boxes_spice_display_construct_with_uri (BOXES_TYPE_SPICE_DISPLAY, machine, config, uri);
#line 684 "spice-display.c"
}


static void ___lambda103_ (BoxesSpiceDisplay* self, gint status) {
	gint _tmp0_ = 0;
#line 134 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	_tmp0_ = status;
#line 134 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	boxes_display_set_mouse_grabbed ((BoxesDisplay*) self, _tmp0_ != 0);
#line 694 "spice-display.c"
}


static void ____lambda103__spice_display_mouse_grab (SpiceDisplay* _sender, gint grabbed, gpointer self) {
#line 133 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	___lambda103_ ((BoxesSpiceDisplay*) self, grabbed);
#line 701 "spice-display.c"
}


static GtkWidget* boxes_spice_display_real_get_display (BoxesDisplay* base, gint n) {
	BoxesSpiceDisplay * self;
	GtkWidget* result = NULL;
	SpiceDisplay* display = NULL;
	GHashTable* _tmp0_ = NULL;
	gint _tmp1_ = 0;
	gconstpointer _tmp2_ = NULL;
	GtkWidget* _tmp3_ = NULL;
	SpiceDisplay* _tmp4_ = NULL;
	SpiceDisplay* _tmp5_ = NULL;
#line 127 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	self = (BoxesSpiceDisplay*) base;
#line 128 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	_tmp0_ = ((BoxesDisplay*) self)->displays;
#line 128 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	_tmp1_ = n;
#line 128 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	_tmp2_ = g_hash_table_lookup (_tmp0_, (gpointer) ((gintptr) _tmp1_));
#line 128 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	_tmp3_ = (GtkWidget*) _tmp2_;
#line 128 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	_tmp4_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp3_, spice_display_get_type ()) ? ((SpiceDisplay*) _tmp3_) : NULL);
#line 128 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	display = _tmp4_;
#line 130 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	_tmp5_ = display;
#line 130 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	if (_tmp5_ == NULL) {
#line 733 "spice-display.c"
		SpiceSession* _tmp6_ = NULL;
		gint _tmp7_ = 0;
		SpiceDisplay* _tmp8_ = NULL;
		SpiceDisplay* _tmp9_ = NULL;
		BoxesBoxConfig* _tmp10_ = NULL;
		BoxesBoxConfig* _tmp11_ = NULL;
		BoxesBoxConfigSyncProperty* _tmp12_ = NULL;
		gint _tmp12__length1 = 0;
		SpiceDisplay* _tmp13_ = NULL;
		SpiceDisplay* _tmp14_ = NULL;
		GObjectClass* _tmp15_ = NULL;
		GParamSpec* _tmp16_ = NULL;
		GHashTable* _tmp18_ = NULL;
		gint _tmp19_ = 0;
		SpiceDisplay* _tmp20_ = NULL;
		GtkWidget* _tmp21_ = NULL;
#line 131 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
		_tmp6_ = self->priv->session;
#line 131 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
		_tmp7_ = n;
#line 131 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
		_tmp8_ = spice_display_new (_tmp6_, _tmp7_);
#line 131 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
		g_object_ref_sink (_tmp8_);
#line 131 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
		_g_object_unref0 (display);
#line 131 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
		display = _tmp8_;
#line 133 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
		_tmp9_ = display;
#line 133 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
		g_signal_connect_object (_tmp9_, "mouse-grab", (GCallback) ____lambda103__spice_display_mouse_grab, self, 0);
#line 136 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
		_tmp10_ = boxes_display_get_config ((BoxesDisplay*) self);
#line 136 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
		_tmp11_ = _tmp10_;
#line 136 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
		_tmp12_ = self->priv->display_sync_properties;
#line 136 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
		_tmp12__length1 = self->priv->display_sync_properties_length1;
#line 136 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
		boxes_box_config_sync_properties (_tmp11_, (GObject*) self, _tmp12_, _tmp12__length1);
#line 137 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
		_tmp13_ = display;
#line 137 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
		g_object_set (_tmp13_, "scaling", TRUE, NULL);
#line 138 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
		_tmp14_ = display;
#line 138 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
		_tmp15_ = G_OBJECT_GET_CLASS ((GObject*) _tmp14_);
#line 138 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
		_tmp16_ = g_object_class_find_property (_tmp15_, "only-downscale");
#line 138 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
		if (_tmp16_ != NULL) {
#line 788 "spice-display.c"
			SpiceDisplay* _tmp17_ = NULL;
#line 139 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
			_tmp17_ = display;
#line 139 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
			g_object_set ((GObject*) _tmp17_, "only-downscale", TRUE, NULL);
#line 794 "spice-display.c"
		}
#line 141 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
		_tmp18_ = ((BoxesDisplay*) self)->displays;
#line 141 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
		_tmp19_ = n;
#line 141 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
		_tmp20_ = display;
#line 141 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
		_tmp21_ = _g_object_ref0 ((GtkWidget*) _tmp20_);
#line 141 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
		g_hash_table_replace (_tmp18_, (gpointer) ((gintptr) _tmp19_), _tmp21_);
#line 806 "spice-display.c"
	}
#line 144 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	result = (GtkWidget*) display;
#line 144 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	return result;
#line 812 "spice-display.c"
}


static gint g_ptr_array_get_length (GPtrArray* self) {
	gint result;
	guint _tmp0_ = 0U;
#line 4407 "/usr/share/vala-0.26/vapi/glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, 0);
#line 4407 "/usr/share/vala-0.26/vapi/glib-2.0.vapi"
	_tmp0_ = self->len;
#line 4407 "/usr/share/vala-0.26/vapi/glib-2.0.vapi"
	result = (gint) _tmp0_;
#line 4407 "/usr/share/vala-0.26/vapi/glib-2.0.vapi"
	return result;
#line 827 "spice-display.c"
}


static void g_ptr_array_set_length (GPtrArray* self, gint value) {
	gint _tmp0_ = 0;
#line 4408 "/usr/share/vala-0.26/vapi/glib-2.0.vapi"
	g_return_if_fail (self != NULL);
#line 4408 "/usr/share/vala-0.26/vapi/glib-2.0.vapi"
	_tmp0_ = value;
#line 4408 "/usr/share/vala-0.26/vapi/glib-2.0.vapi"
	g_ptr_array_set_size (self, _tmp0_);
#line 839 "spice-display.c"
}


static SpiceUsbDevice* _vala_SpiceUsbDevice_copy (SpiceUsbDevice* self) {
#line 152 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	return g_boxed_copy (spice_usb_device_get_type (), self);
#line 846 "spice-display.c"
}


static gpointer __vala_SpiceUsbDevice_copy0 (gpointer self) {
#line 152 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	return self ? _vala_SpiceUsbDevice_copy (self) : NULL;
#line 853 "spice-display.c"
}


static void _vala_SpiceUsbDevice_free (SpiceUsbDevice* self) {
#line 154 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	g_boxed_free (spice_usb_device_get_type (), self);
#line 860 "spice-display.c"
}


static gboolean boxes_spice_display_has_usb_device_connected (BoxesSpiceDisplay* self) {
	gboolean result = FALSE;
	GError * _inner_error_ = NULL;
#line 147 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 869 "spice-display.c"
	{
		SpiceUsbDeviceManager* manager = NULL;
		SpiceSession* _tmp0_ = NULL;
		SpiceUsbDeviceManager* _tmp1_ = NULL;
		SpiceUsbDeviceManager* _tmp2_ = NULL;
		GPtrArray* devs = NULL;
		SpiceUsbDeviceManager* _tmp3_ = NULL;
		GPtrArray* _tmp4_ = NULL;
#line 149 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
		_tmp0_ = self->priv->session;
#line 149 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
		_tmp1_ = spice_usb_device_manager_get (_tmp0_, &_inner_error_);
#line 149 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
		_tmp2_ = _g_object_ref0 (_tmp1_);
#line 149 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
		manager = _tmp2_;
#line 149 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 888 "spice-display.c"
			goto __catch70_g_error;
		}
#line 150 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
		_tmp3_ = manager;
#line 150 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
		_tmp4_ = spice_usb_device_manager_get_devices (_tmp3_);
#line 150 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
		devs = _tmp4_;
#line 897 "spice-display.c"
		{
			gint i = 0;
#line 151 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
			i = 0;
#line 902 "spice-display.c"
			{
				gboolean _tmp5_ = FALSE;
#line 151 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
				_tmp5_ = TRUE;
#line 151 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
				while (TRUE) {
#line 909 "spice-display.c"
					gint _tmp7_ = 0;
					GPtrArray* _tmp8_ = NULL;
					gint _tmp9_ = 0;
					gint _tmp10_ = 0;
					SpiceUsbDevice* dev = NULL;
					GPtrArray* _tmp11_ = NULL;
					gint _tmp12_ = 0;
					gconstpointer _tmp13_ = NULL;
					SpiceUsbDevice* _tmp14_ = NULL;
					SpiceUsbDeviceManager* _tmp15_ = NULL;
					SpiceUsbDevice* _tmp16_ = NULL;
					gboolean _tmp17_ = FALSE;
#line 151 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
					if (!_tmp5_) {
#line 924 "spice-display.c"
						gint _tmp6_ = 0;
#line 151 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
						_tmp6_ = i;
#line 151 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
						i = _tmp6_ + 1;
#line 930 "spice-display.c"
					}
#line 151 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
					_tmp5_ = FALSE;
#line 151 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
					_tmp7_ = i;
#line 151 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
					_tmp8_ = devs;
#line 151 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
					_tmp9_ = g_ptr_array_get_length (_tmp8_);
#line 151 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
					_tmp10_ = _tmp9_;
#line 151 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
					if (!(_tmp7_ < _tmp10_)) {
#line 151 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
						break;
#line 946 "spice-display.c"
					}
#line 152 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
					_tmp11_ = devs;
#line 152 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
					_tmp12_ = i;
#line 152 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
					_tmp13_ = g_ptr_array_index (_tmp11_, (guint) _tmp12_);
#line 152 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
					_tmp14_ = __vala_SpiceUsbDevice_copy0 ((SpiceUsbDevice*) _tmp13_);
#line 152 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
					dev = _tmp14_;
#line 153 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
					_tmp15_ = manager;
#line 153 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
					_tmp16_ = dev;
#line 153 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
					_tmp17_ = spice_usb_device_manager_is_device_connected (_tmp15_, _tmp16_);
#line 153 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
					if (_tmp17_) {
#line 154 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
						result = TRUE;
#line 154 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
						__vala_SpiceUsbDevice_free0 (dev);
#line 154 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
						_g_ptr_array_unref0 (devs);
#line 154 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
						_g_object_unref0 (manager);
#line 154 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
						return result;
#line 976 "spice-display.c"
					}
#line 151 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
					__vala_SpiceUsbDevice_free0 (dev);
#line 980 "spice-display.c"
				}
			}
		}
#line 148 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
		_g_ptr_array_unref0 (devs);
#line 148 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
		_g_object_unref0 (manager);
#line 988 "spice-display.c"
	}
	goto __finally70;
	__catch70_g_error:
	{
		GError* _error_ = NULL;
#line 148 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
		_error_ = _inner_error_;
#line 148 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
		_inner_error_ = NULL;
#line 148 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
		_g_error_free0 (_error_);
#line 1000 "spice-display.c"
	}
	__finally70:
#line 148 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 148 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 148 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
		g_clear_error (&_inner_error_);
#line 148 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
		return FALSE;
#line 1011 "spice-display.c"
	}
#line 158 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	result = FALSE;
#line 158 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	return result;
#line 1017 "spice-display.c"
}


static gboolean boxes_spice_display_real_should_keep_alive (BoxesDisplay* base) {
	BoxesSpiceDisplay * self;
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
#line 161 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	self = (BoxesSpiceDisplay*) base;
#line 162 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	_tmp1_ = self->priv->closed;
#line 162 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	if (!_tmp1_) {
#line 1032 "spice-display.c"
		gboolean _tmp2_ = FALSE;
#line 162 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
		_tmp2_ = boxes_spice_display_has_usb_device_connected (self);
#line 162 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
		_tmp0_ = _tmp2_;
#line 1038 "spice-display.c"
	} else {
#line 162 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
		_tmp0_ = FALSE;
#line 1042 "spice-display.c"
	}
#line 162 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	result = _tmp0_;
#line 162 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	return result;
#line 1048 "spice-display.c"
}


static void boxes_spice_display_real_set_enable_audio (BoxesDisplay* base, gboolean enable) {
	BoxesSpiceDisplay * self;
	SpiceSession* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
#line 165 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	self = (BoxesSpiceDisplay*) base;
#line 166 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	_tmp0_ = self->priv->session;
#line 166 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	_tmp1_ = enable;
#line 166 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	g_object_set (_tmp0_, "enable-audio", _tmp1_, NULL);
#line 1064 "spice-display.c"
}


static void boxes_spice_display_real_set_enable_inputs (BoxesDisplay* base, GtkWidget* widget, gboolean enable) {
	BoxesSpiceDisplay * self;
	GtkWidget* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
#line 169 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	self = (BoxesSpiceDisplay*) base;
#line 169 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	g_return_if_fail (widget != NULL);
#line 170 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	_tmp0_ = widget;
#line 170 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	_tmp1_ = enable;
#line 170 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	g_object_set (G_TYPE_CHECK_INSTANCE_TYPE (_tmp0_, spice_display_get_type ()) ? ((SpiceDisplay*) _tmp0_) : NULL, "disable-inputs", !_tmp1_, NULL);
#line 1082 "spice-display.c"
}


static GdkPixbuf* boxes_spice_display_real_get_pixbuf (BoxesDisplay* base, gint n, GError** error) {
	BoxesSpiceDisplay * self;
	GdkPixbuf* result = NULL;
	SpiceDisplay* display = NULL;
	gint _tmp0_ = 0;
	GtkWidget* _tmp1_ = NULL;
	SpiceDisplay* _tmp2_ = NULL;
	SpiceDisplay* _tmp3_ = NULL;
	gboolean _tmp4_ = FALSE;
	gboolean _tmp5_ = FALSE;
	SpiceDisplay* _tmp6_ = NULL;
	GdkPixbuf* _tmp7_ = NULL;
#line 173 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	self = (BoxesSpiceDisplay*) base;
#line 174 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	_tmp0_ = n;
#line 174 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	_tmp1_ = boxes_display_get_display ((BoxesDisplay*) self, _tmp0_);
#line 174 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	_tmp2_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp1_, spice_display_get_type ()) ? ((SpiceDisplay*) _tmp1_) : NULL;
#line 174 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	if (_tmp2_ == NULL) {
#line 174 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
		_g_object_unref0 (_tmp1_);
#line 1110 "spice-display.c"
	}
#line 174 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	display = _tmp2_;
#line 176 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	_tmp3_ = display;
#line 176 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	g_object_get (_tmp3_, "ready", &_tmp4_, NULL);
#line 176 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	_tmp5_ = _tmp4_;
#line 176 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	if (!_tmp5_) {
#line 177 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
		result = NULL;
#line 177 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
		_g_object_unref0 (display);
#line 177 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
		return result;
#line 1128 "spice-display.c"
	}
#line 179 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	_tmp6_ = display;
#line 179 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	_tmp7_ = spice_display_get_pixbuf (_tmp6_);
#line 179 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	result = _tmp7_;
#line 179 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	_g_object_unref0 (display);
#line 179 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	return result;
#line 1140 "spice-display.c"
}


static void boxes_spice_display_real_collect_logs (BoxesDisplay* base, GString* builder) {
	BoxesSpiceDisplay * self;
	GString* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	const gchar* _tmp4_ = NULL;
	gboolean _tmp5_ = FALSE;
	GString* _tmp6_ = NULL;
	SpiceGtkSession* _tmp7_ = NULL;
	SpiceMainChannel* _tmp18_ = NULL;
	GError * _inner_error_ = NULL;
#line 182 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	self = (BoxesSpiceDisplay*) base;
#line 182 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	g_return_if_fail (builder != NULL);
#line 183 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	_tmp0_ = builder;
#line 183 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	_tmp1_ = boxes_display_get_uri ((BoxesDisplay*) self);
#line 183 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	_tmp2_ = _tmp1_;
#line 183 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	_tmp3_ = _tmp2_;
#line 183 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	g_string_append_printf (_tmp0_, "URI: %s\n", _tmp3_);
#line 183 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	_g_free0 (_tmp3_);
#line 184 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	_tmp5_ = self->priv->_resize_guest;
#line 184 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	if (_tmp5_) {
#line 184 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
		_tmp4_ = "yes";
#line 1178 "spice-display.c"
	} else {
#line 184 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
		_tmp4_ = "no";
#line 1182 "spice-display.c"
	}
#line 184 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	_tmp6_ = builder;
#line 184 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	g_string_append_printf (_tmp6_, "Auto resize guest: %s\n", _tmp4_);
#line 185 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	_tmp7_ = self->priv->gtk_session;
#line 185 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	if (_tmp7_ != NULL) {
#line 1192 "spice-display.c"
		const gchar* _tmp8_ = NULL;
		SpiceGtkSession* _tmp9_ = NULL;
		gboolean _tmp10_ = FALSE;
		gboolean _tmp11_ = FALSE;
		GString* _tmp12_ = NULL;
		const gchar* _tmp13_ = NULL;
		SpiceGtkSession* _tmp14_ = NULL;
		gboolean _tmp15_ = FALSE;
		gboolean _tmp16_ = FALSE;
		GString* _tmp17_ = NULL;
#line 186 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
		_tmp9_ = self->priv->gtk_session;
#line 186 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
		g_object_get (_tmp9_, "auto-usbredir", &_tmp10_, NULL);
#line 186 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
		_tmp11_ = _tmp10_;
#line 186 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
		if (_tmp11_) {
#line 186 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
			_tmp8_ = "yes";
#line 1213 "spice-display.c"
		} else {
#line 186 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
			_tmp8_ = "no";
#line 1217 "spice-display.c"
		}
#line 186 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
		_tmp12_ = builder;
#line 186 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
		g_string_append_printf (_tmp12_, "Auto redirect USB: %s\n", _tmp8_);
#line 187 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
		_tmp14_ = self->priv->gtk_session;
#line 187 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
		g_object_get (_tmp14_, "auto-clipboard", &_tmp15_, NULL);
#line 187 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
		_tmp16_ = _tmp15_;
#line 187 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
		if (_tmp16_) {
#line 187 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
			_tmp13_ = "yes";
#line 1233 "spice-display.c"
		} else {
#line 187 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
			_tmp13_ = "no";
#line 1237 "spice-display.c"
		}
#line 187 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
		_tmp17_ = builder;
#line 187 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
		g_string_append_printf (_tmp17_, "Auto clipboard sync: %s\n", _tmp13_);
#line 1243 "spice-display.c"
	}
#line 189 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	_tmp18_ = self->priv->main_channel;
#line 189 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	if (_tmp18_ != NULL) {
#line 1249 "spice-display.c"
		GString* _tmp19_ = NULL;
		const gchar* _tmp20_ = NULL;
		const gchar* _tmp21_ = NULL;
		SpiceMainChannel* _tmp22_ = NULL;
		gint _tmp23_ = 0;
		gint _tmp24_ = 0;
		GString* _tmp25_ = NULL;
		const gchar* _tmp26_ = NULL;
		SpiceMainChannel* _tmp27_ = NULL;
		gboolean _tmp28_ = FALSE;
		gboolean _tmp29_ = FALSE;
		GString* _tmp30_ = NULL;
#line 190 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
		_tmp19_ = builder;
#line 190 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
		_tmp20_ = spice_util_get_version_string ();
#line 190 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
		g_string_append_printf (_tmp19_, "Spice-gtk version %s\n", _tmp20_);
#line 191 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
		_tmp22_ = self->priv->main_channel;
#line 191 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
		g_object_get (_tmp22_, "mouse-mode", &_tmp23_, NULL);
#line 191 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
		_tmp24_ = _tmp23_;
#line 191 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
		if (_tmp24_ == 1) {
#line 191 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
			_tmp21_ = "server";
#line 1278 "spice-display.c"
		} else {
#line 191 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
			_tmp21_ = "client";
#line 1282 "spice-display.c"
		}
#line 191 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
		_tmp25_ = builder;
#line 191 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
		g_string_append_printf (_tmp25_, "Mouse mode: %s\n", _tmp21_);
#line 192 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
		_tmp27_ = self->priv->main_channel;
#line 192 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
		g_object_get (_tmp27_, "agent-connected", &_tmp28_, NULL);
#line 192 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
		_tmp29_ = _tmp28_;
#line 192 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
		if (_tmp29_) {
#line 192 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
			_tmp26_ = "connected";
#line 1298 "spice-display.c"
		} else {
#line 192 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
			_tmp26_ = "disconnected";
#line 1302 "spice-display.c"
		}
#line 192 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
		_tmp30_ = builder;
#line 192 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
		g_string_append_printf (_tmp30_, "Agent: %s\n", _tmp26_);
#line 1308 "spice-display.c"
	}
	{
		SpiceUsbDeviceManager* manager = NULL;
		SpiceSession* _tmp31_ = NULL;
		SpiceUsbDeviceManager* _tmp32_ = NULL;
		SpiceUsbDeviceManager* _tmp33_ = NULL;
		GPtrArray* devs = NULL;
		SpiceUsbDeviceManager* _tmp34_ = NULL;
		GPtrArray* _tmp35_ = NULL;
#line 196 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
		_tmp31_ = self->priv->session;
#line 196 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
		_tmp32_ = spice_usb_device_manager_get (_tmp31_, &_inner_error_);
#line 196 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
		_tmp33_ = _g_object_ref0 (_tmp32_);
#line 196 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
		manager = _tmp33_;
#line 196 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1328 "spice-display.c"
			goto __catch71_g_error;
		}
#line 197 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
		_tmp34_ = manager;
#line 197 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
		_tmp35_ = spice_usb_device_manager_get_devices (_tmp34_);
#line 197 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
		devs = _tmp35_;
#line 1337 "spice-display.c"
		{
			gint i = 0;
#line 198 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
			i = 0;
#line 1342 "spice-display.c"
			{
				gboolean _tmp36_ = FALSE;
#line 198 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
				_tmp36_ = TRUE;
#line 198 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
				while (TRUE) {
#line 1349 "spice-display.c"
					gint _tmp38_ = 0;
					GPtrArray* _tmp39_ = NULL;
					gint _tmp40_ = 0;
					gint _tmp41_ = 0;
					SpiceUsbDevice* dev = NULL;
					GPtrArray* _tmp42_ = NULL;
					gint _tmp43_ = 0;
					gconstpointer _tmp44_ = NULL;
					SpiceUsbDevice* _tmp45_ = NULL;
					SpiceUsbDeviceManager* _tmp46_ = NULL;
					SpiceUsbDevice* _tmp47_ = NULL;
					gboolean _tmp48_ = FALSE;
#line 198 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
					if (!_tmp36_) {
#line 1364 "spice-display.c"
						gint _tmp37_ = 0;
#line 198 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
						_tmp37_ = i;
#line 198 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
						i = _tmp37_ + 1;
#line 1370 "spice-display.c"
					}
#line 198 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
					_tmp36_ = FALSE;
#line 198 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
					_tmp38_ = i;
#line 198 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
					_tmp39_ = devs;
#line 198 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
					_tmp40_ = g_ptr_array_get_length (_tmp39_);
#line 198 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
					_tmp41_ = _tmp40_;
#line 198 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
					if (!(_tmp38_ < _tmp41_)) {
#line 198 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
						break;
#line 1386 "spice-display.c"
					}
#line 199 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
					_tmp42_ = devs;
#line 199 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
					_tmp43_ = i;
#line 199 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
					_tmp44_ = g_ptr_array_index (_tmp42_, (guint) _tmp43_);
#line 199 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
					_tmp45_ = __vala_SpiceUsbDevice_copy0 ((SpiceUsbDevice*) _tmp44_);
#line 199 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
					dev = _tmp45_;
#line 200 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
					_tmp46_ = manager;
#line 200 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
					_tmp47_ = dev;
#line 200 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
					_tmp48_ = spice_usb_device_manager_is_device_connected (_tmp46_, _tmp47_);
#line 200 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
					if (_tmp48_) {
#line 1406 "spice-display.c"
						GString* _tmp49_ = NULL;
						SpiceUsbDevice* _tmp50_ = NULL;
						gchar* _tmp51_ = NULL;
						gchar* _tmp52_ = NULL;
#line 201 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
						_tmp49_ = builder;
#line 201 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
						_tmp50_ = dev;
#line 201 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
						_tmp51_ = spice_usb_device_get_description (_tmp50_, "%s %s %s at %d-%d");
#line 201 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
						_tmp52_ = _tmp51_;
#line 201 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
						g_string_append_printf (_tmp49_, "USB device redirected: %s\n", _tmp52_);
#line 201 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
						_g_free0 (_tmp52_);
#line 1423 "spice-display.c"
					}
#line 198 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
					__vala_SpiceUsbDevice_free0 (dev);
#line 1427 "spice-display.c"
				}
			}
		}
#line 195 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
		_g_ptr_array_unref0 (devs);
#line 195 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
		_g_object_unref0 (manager);
#line 1435 "spice-display.c"
	}
	goto __finally71;
	__catch71_g_error:
	{
		GError* _error_ = NULL;
#line 195 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
		_error_ = _inner_error_;
#line 195 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
		_inner_error_ = NULL;
#line 195 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
		_g_error_free0 (_error_);
#line 1447 "spice-display.c"
	}
	__finally71:
#line 195 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 195 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 195 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
		g_clear_error (&_inner_error_);
#line 195 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
		return;
#line 1458 "spice-display.c"
	}
}


static void _boxes_spice_display_main_event_spice_channel_channel_event (SpiceChannel* _sender, SpiceChannelEvent event, gpointer self) {
#line 222 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	boxes_spice_display_main_event ((BoxesSpiceDisplay*) self, event);
#line 1466 "spice-display.c"
}


static void ___lambda105_ (BoxesSpiceDisplay* self) {
	SpiceMainChannel* _tmp0_ = NULL;
	gint _tmp1_ = 0;
	gint _tmp2_ = 0;
#line 224 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	_tmp0_ = self->priv->main_channel;
#line 224 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	g_object_get (_tmp0_, "mouse-mode", &_tmp1_, NULL);
#line 224 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	_tmp2_ = _tmp1_;
#line 224 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	boxes_display_set_can_grab_mouse ((BoxesDisplay*) self, _tmp2_ != 2);
#line 1482 "spice-display.c"
}


static void ____lambda105__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self) {
#line 223 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	___lambda105_ ((BoxesSpiceDisplay*) self);
#line 1489 "spice-display.c"
}


static Block64Data* block64_data_ref (Block64Data* _data64_) {
#line 229 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	g_atomic_int_inc (&_data64_->_ref_count_);
#line 229 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	return _data64_;
#line 1498 "spice-display.c"
}


static void block64_data_unref (void * _userdata_) {
	Block64Data* _data64_;
	_data64_ = (Block64Data*) _userdata_;
#line 229 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	if (g_atomic_int_dec_and_test (&_data64_->_ref_count_)) {
#line 1507 "spice-display.c"
		BoxesSpiceDisplay* self;
#line 229 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
		self = _data64_->self;
#line 229 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
		_g_object_unref0 (_data64_->display);
#line 229 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
		_g_object_unref0 (self);
#line 229 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
		g_slice_free (Block64Data, _data64_);
#line 1517 "spice-display.c"
	}
}


static void ___lambda106_ (Block64Data* _data64_) {
	BoxesSpiceDisplay* self;
	SpiceDisplay* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
#line 235 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	self = _data64_->self;
#line 236 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	_tmp0_ = _data64_->display;
#line 236 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	g_object_get (_tmp0_, "ready", &_tmp1_, NULL);
#line 236 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	_tmp2_ = _tmp1_;
#line 236 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	if (_tmp2_) {
#line 1537 "spice-display.c"
		SpiceDisplay* _tmp3_ = NULL;
		gint _tmp4_ = 0;
		gint _tmp5_ = 0;
#line 237 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
		_tmp3_ = _data64_->display;
#line 237 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
		g_object_get (_tmp3_, "channel-id", &_tmp4_, NULL);
#line 237 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
		_tmp5_ = _tmp4_;
#line 237 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
		g_signal_emit_by_name ((BoxesDisplay*) self, "show", _tmp5_);
#line 1549 "spice-display.c"
	} else {
		SpiceDisplay* _tmp6_ = NULL;
		gint _tmp7_ = 0;
		gint _tmp8_ = 0;
#line 239 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
		_tmp6_ = _data64_->display;
#line 239 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
		g_object_get (_tmp6_, "channel-id", &_tmp7_, NULL);
#line 239 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
		_tmp8_ = _tmp7_;
#line 239 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
		g_signal_emit_by_name ((BoxesDisplay*) self, "hide", _tmp8_);
#line 1562 "spice-display.c"
	}
}


static void ____lambda106__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self) {
#line 235 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	___lambda106_ (self);
#line 1570 "spice-display.c"
}


static void ___lambda104_ (BoxesSpiceDisplay* self, SpiceChannel* channel) {
	gint id = 0;
	SpiceChannel* _tmp0_ = NULL;
	gint _tmp1_ = 0;
	gint _tmp2_ = 0;
	SpiceChannel* _tmp3_ = NULL;
	SpiceChannel* _tmp13_ = NULL;
#line 217 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	g_return_if_fail (channel != NULL);
#line 218 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	_tmp0_ = channel;
#line 218 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	g_object_get (_tmp0_, "channel-id", &_tmp1_, NULL);
#line 218 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	_tmp2_ = _tmp1_;
#line 218 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	id = _tmp2_;
#line 220 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	_tmp3_ = channel;
#line 220 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp3_, spice_main_channel_get_type ())) {
#line 1595 "spice-display.c"
		SpiceChannel* _tmp4_ = NULL;
		SpiceMainChannel* _tmp5_ = NULL;
		SpiceMainChannel* _tmp6_ = NULL;
		gulong _tmp7_ = 0UL;
		SpiceMainChannel* _tmp8_ = NULL;
		gulong _tmp9_ = 0UL;
		SpiceMainChannel* _tmp10_ = NULL;
		gint _tmp11_ = 0;
		gint _tmp12_ = 0;
#line 221 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
		_tmp4_ = channel;
#line 221 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
		_tmp5_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp4_, spice_main_channel_get_type ()) ? ((SpiceMainChannel*) _tmp4_) : NULL);
#line 221 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
		_g_object_unref0 (self->priv->main_channel);
#line 221 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
		self->priv->main_channel = _tmp5_;
#line 222 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
		_tmp6_ = self->priv->main_channel;
#line 222 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
		_tmp7_ = g_signal_connect_object ((SpiceChannel*) _tmp6_, "channel-event", (GCallback) _boxes_spice_display_main_event_spice_channel_channel_event, self, 0);
#line 222 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
		self->priv->main_event_id = _tmp7_;
#line 223 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
		_tmp8_ = self->priv->main_channel;
#line 223 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
		_tmp9_ = g_signal_connect_object ((GObject*) _tmp8_, "notify::mouse-mode", (GCallback) ____lambda105__g_object_notify, self, 0);
#line 223 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
		self->priv->main_mouse_mode_id = _tmp9_;
#line 226 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
		_tmp10_ = self->priv->main_channel;
#line 226 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
		g_object_get (_tmp10_, "mouse-mode", &_tmp11_, NULL);
#line 226 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
		_tmp12_ = _tmp11_;
#line 226 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
		boxes_display_set_can_grab_mouse ((BoxesDisplay*) self, _tmp12_ != 2);
#line 1633 "spice-display.c"
	}
#line 229 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	_tmp13_ = channel;
#line 229 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp13_, spice_display_channel_get_type ())) {
#line 1639 "spice-display.c"
		Block64Data* _data64_;
		gint _tmp14_ = 0;
		gint _tmp15_ = 0;
		GtkWidget* _tmp16_ = NULL;
		SpiceDisplay* _tmp17_ = NULL;
		SpiceDisplay* _tmp18_ = NULL;
#line 229 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
		_data64_ = g_slice_new0 (Block64Data);
#line 229 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
		_data64_->_ref_count_ = 1;
#line 229 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
		_data64_->self = g_object_ref (self);
#line 230 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
		_tmp14_ = id;
#line 230 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
		if (_tmp14_ != 0) {
#line 231 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
			block64_data_unref (_data64_);
#line 231 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
			_data64_ = NULL;
#line 231 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
			return;
#line 1662 "spice-display.c"
		}
#line 233 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
		boxes_display_access_start ((BoxesDisplay*) self);
#line 234 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
		_tmp15_ = id;
#line 234 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
		_tmp16_ = boxes_display_get_display ((BoxesDisplay*) self, _tmp15_);
#line 234 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
		_tmp17_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp16_, spice_display_get_type ()) ? ((SpiceDisplay*) _tmp16_) : NULL;
#line 234 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
		if (_tmp17_ == NULL) {
#line 234 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
			_g_object_unref0 (_tmp16_);
#line 1676 "spice-display.c"
		}
#line 234 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
		_data64_->display = _tmp17_;
#line 235 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
		_tmp18_ = _data64_->display;
#line 235 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
		g_signal_connect_data ((GObject*) _tmp18_, "notify::ready", (GCallback) ____lambda106__g_object_notify, block64_data_ref (_data64_), (GClosureNotify) block64_data_unref, 0);
#line 229 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
		block64_data_unref (_data64_);
#line 229 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
		_data64_ = NULL;
#line 1688 "spice-display.c"
	}
}


static void ____lambda104__spice_session_channel_new (SpiceSession* _sender, SpiceChannel* channel, gpointer self) {
#line 217 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	___lambda104_ ((BoxesSpiceDisplay*) self, channel);
#line 1696 "spice-display.c"
}


static void ___lambda107_ (BoxesSpiceDisplay* self, SpiceChannel* channel) {
	SpiceChannel* _tmp0_ = NULL;
#line 245 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	g_return_if_fail (channel != NULL);
#line 246 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	_tmp0_ = channel;
#line 246 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp0_, spice_display_channel_get_type ())) {
#line 1708 "spice-display.c"
		SpiceDisplayChannel* display = NULL;
		SpiceChannel* _tmp1_ = NULL;
		SpiceDisplayChannel* _tmp2_ = NULL;
		SpiceDisplayChannel* _tmp3_ = NULL;
		gint _tmp4_ = 0;
		gint _tmp5_ = 0;
#line 247 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
		_tmp1_ = channel;
#line 247 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
		_tmp2_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp1_, spice_display_channel_get_type ()) ? ((SpiceDisplayChannel*) _tmp1_) : NULL);
#line 247 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
		display = _tmp2_;
#line 248 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
		_tmp3_ = display;
#line 248 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
		g_object_get ((SpiceChannel*) _tmp3_, "channel-id", &_tmp4_, NULL);
#line 248 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
		_tmp5_ = _tmp4_;
#line 248 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
		g_signal_emit_by_name ((BoxesDisplay*) self, "hide", _tmp5_);
#line 249 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
		boxes_display_access_finish ((BoxesDisplay*) self);
#line 246 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
		_g_object_unref0 (display);
#line 1733 "spice-display.c"
	}
}


static void ____lambda107__spice_session_channel_destroy (SpiceSession* _sender, SpiceChannel* channel, gpointer self) {
#line 245 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	___lambda107_ ((BoxesSpiceDisplay*) self, channel);
#line 1741 "spice-display.c"
}


static void boxes_spice_display_real_connect_it (BoxesDisplay* base, GError** error) {
	BoxesSpiceDisplay * self;
	gboolean _tmp0_ = FALSE;
	gulong _tmp1_ = 0UL;
	gulong _tmp4_ = 0UL;
	SpiceSession* _tmp7_ = NULL;
	const gchar* _tmp8_ = NULL;
	const gchar* _tmp9_ = NULL;
	SpiceSession* _tmp10_ = NULL;
#line 207 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	self = (BoxesSpiceDisplay*) base;
#line 209 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	_tmp0_ = ((BoxesDisplay*) self)->connected;
#line 209 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	if (_tmp0_) {
#line 210 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
		return;
#line 1762 "spice-display.c"
	}
#line 211 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	((BoxesDisplay*) self)->connected = TRUE;
#line 213 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	boxes_spice_display_main_cleanup (self);
#line 216 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	_tmp1_ = self->priv->channel_new_id;
#line 216 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	if (_tmp1_ == ((gulong) 0)) {
#line 1772 "spice-display.c"
		SpiceSession* _tmp2_ = NULL;
		gulong _tmp3_ = 0UL;
#line 217 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
		_tmp2_ = self->priv->session;
#line 217 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
		_tmp3_ = g_signal_connect_object (_tmp2_, "channel-new", (GCallback) ____lambda104__spice_session_channel_new, self, 0);
#line 217 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
		self->priv->channel_new_id = _tmp3_;
#line 1781 "spice-display.c"
	}
#line 244 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	_tmp4_ = self->priv->channel_destroy_id;
#line 244 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	if (_tmp4_ == ((gulong) 0)) {
#line 1787 "spice-display.c"
		SpiceSession* _tmp5_ = NULL;
		gulong _tmp6_ = 0UL;
#line 245 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
		_tmp5_ = self->priv->session;
#line 245 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
		_tmp6_ = g_signal_connect_object (_tmp5_, "channel-destroy", (GCallback) ____lambda107__spice_session_channel_destroy, self, 0);
#line 245 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
		self->priv->channel_destroy_id = _tmp6_;
#line 1796 "spice-display.c"
	}
#line 253 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	_tmp7_ = self->priv->session;
#line 253 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	_tmp8_ = boxes_display_get_password ((BoxesDisplay*) self);
#line 253 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	_tmp9_ = _tmp8_;
#line 253 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	g_object_set (_tmp7_, "password", _tmp9_, NULL);
#line 254 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	_tmp10_ = self->priv->session;
#line 254 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	spice_session_connect (_tmp10_);
#line 1810 "spice-display.c"
}


static void boxes_spice_display_real_disconnect_it (BoxesDisplay* base) {
	BoxesSpiceDisplay * self;
	SpiceSession* _tmp0_ = NULL;
#line 257 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	self = (BoxesSpiceDisplay*) base;
#line 258 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	_tmp0_ = self->priv->session;
#line 258 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	spice_session_disconnect (_tmp0_);
#line 1823 "spice-display.c"
}


static void boxes_spice_display_main_event (BoxesSpiceDisplay* self, SpiceChannelEvent event) {
	SpiceChannelEvent _tmp0_ = 0;
#line 261 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	g_return_if_fail (self != NULL);
#line 262 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	_tmp0_ = event;
#line 262 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	switch (_tmp0_) {
#line 262 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
		case SPICE_CHANNEL_CLOSED:
#line 1837 "spice-display.c"
		{
#line 264 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
			self->priv->closed = TRUE;
#line 265 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
			g_signal_emit_by_name ((BoxesDisplay*) self, "disconnected", FALSE);
#line 266 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
			break;
#line 1845 "spice-display.c"
		}
#line 262 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
		case SPICE_CHANNEL_ERROR_AUTH:
#line 1849 "spice-display.c"
		{
#line 269 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
			boxes_display_set_need_password ((BoxesDisplay*) self, TRUE);
#line 270 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
			break;
#line 1855 "spice-display.c"
		}
#line 262 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
		case SPICE_CHANNEL_ERROR_CONNECT:
#line 262 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
		case SPICE_CHANNEL_ERROR_TLS:
#line 262 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
		case SPICE_CHANNEL_ERROR_LINK:
#line 262 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
		case SPICE_CHANNEL_ERROR_IO:
#line 1865 "spice-display.c"
		{
			SpiceChannelEvent _tmp1_ = 0;
#line 276 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
			_tmp1_ = event;
#line 276 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
			g_debug ("spice-display.vala:276: main SPICE channel error: %d", (gint) _tmp1_);
#line 277 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
			self->priv->closed = TRUE;
#line 278 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
			g_signal_emit_by_name ((BoxesDisplay*) self, "disconnected", TRUE);
#line 279 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
			break;
#line 1878 "spice-display.c"
		}
		default:
		{
			SpiceChannelEvent _tmp2_ = 0;
#line 282 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
			_tmp2_ = event;
#line 282 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
			g_debug ("spice-display.vala:282: unhandled main SPICE channel event: %d", (gint) _tmp2_);
#line 283 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
			break;
#line 1889 "spice-display.c"
		}
	}
}


static Block65Data* block65_data_ref (Block65Data* _data65_) {
#line 306 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	g_atomic_int_inc (&_data65_->_ref_count_);
#line 306 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	return _data65_;
#line 1900 "spice-display.c"
}


static void block65_data_unref (void * _userdata_) {
	Block65Data* _data65_;
	_data65_ = (Block65Data*) _userdata_;
#line 306 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	if (g_atomic_int_dec_and_test (&_data65_->_ref_count_)) {
#line 1909 "spice-display.c"
		BoxesSpiceDisplay* self;
#line 306 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
		self = _data65_->self;
#line 306 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
		_g_object_unref0 (_data65_->usb_property);
#line 306 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
		_g_object_unref0 (self);
#line 306 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
		g_slice_free (Block65Data, _data65_);
#line 1919 "spice-display.c"
	}
}


static Block66Data* block66_data_ref (Block66Data* _data66_) {
#line 315 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	g_atomic_int_inc (&_data66_->_ref_count_);
#line 315 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	return _data66_;
#line 1929 "spice-display.c"
}


static void block66_data_unref (void * _userdata_) {
	Block66Data* _data66_;
	_data66_ = (Block66Data*) _userdata_;
#line 315 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	if (g_atomic_int_dec_and_test (&_data66_->_ref_count_)) {
#line 1938 "spice-display.c"
		BoxesSpiceDisplay* self;
#line 315 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
		self = _data66_->_data65_->self;
#line 315 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
		_g_object_unref0 (_data66_->manager);
#line 315 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
		block65_data_unref (_data66_->_data65_);
#line 315 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
		_data66_->_data65_ = NULL;
#line 315 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
		g_slice_free (Block66Data, _data66_);
#line 1950 "spice-display.c"
	}
}


static Block67Data* block67_data_ref (Block67Data* _data67_) {
#line 4391 "/usr/share/vala-0.26/vapi/glib-2.0.vapi"
	g_atomic_int_inc (&_data67_->_ref_count_);
#line 4391 "/usr/share/vala-0.26/vapi/glib-2.0.vapi"
	return _data67_;
#line 1960 "spice-display.c"
}


static void block67_data_unref (void * _userdata_) {
	Block67Data* _data67_;
	_data67_ = (Block67Data*) _userdata_;
#line 4391 "/usr/share/vala-0.26/vapi/glib-2.0.vapi"
	if (g_atomic_int_dec_and_test (&_data67_->_ref_count_)) {
#line 1969 "spice-display.c"
		GPtrArray* self;
#line 4391 "/usr/share/vala-0.26/vapi/glib-2.0.vapi"
		self = _data67_->self;
#line 4391 "/usr/share/vala-0.26/vapi/glib-2.0.vapi"
		_g_ptr_array_unref0 (self);
#line 4391 "/usr/share/vala-0.26/vapi/glib-2.0.vapi"
		g_slice_free (Block67Data, _data67_);
#line 1977 "spice-display.c"
	}
}


static gint __lambda1_ (Block67Data* _data67_, gconstpointer** a, gconstpointer** b) {
	GPtrArray* self;
	gint result = 0;
	GCompareFunc _tmp0_ = NULL;
	gconstpointer** _tmp1_ = NULL;
	gconstpointer** _tmp2_ = NULL;
	gint _tmp3_ = 0;
#line 4392 "/usr/share/vala-0.26/vapi/glib-2.0.vapi"
	self = _data67_->self;
#line 4393 "/usr/share/vala-0.26/vapi/glib-2.0.vapi"
	_tmp0_ = _data67_->compare_func;
#line 4393 "/usr/share/vala-0.26/vapi/glib-2.0.vapi"
	_tmp1_ = a;
#line 4393 "/usr/share/vala-0.26/vapi/glib-2.0.vapi"
	_tmp2_ = b;
#line 4393 "/usr/share/vala-0.26/vapi/glib-2.0.vapi"
	_tmp3_ = _tmp0_ ((gconstpointer**) (*_tmp1_), (gconstpointer**) (*_tmp2_));
#line 4393 "/usr/share/vala-0.26/vapi/glib-2.0.vapi"
	result = _tmp3_;
#line 4393 "/usr/share/vala-0.26/vapi/glib-2.0.vapi"
	return result;
#line 2003 "spice-display.c"
}


static gint ___lambda1__gcompare_data_func (gconstpointer a, gconstpointer b, gpointer self) {
	gint result;
	result = __lambda1_ (self, a, b);
#line 4392 "/usr/share/vala-0.26/vapi/glib-2.0.vapi"
	return result;
#line 2012 "spice-display.c"
}


static void vala_g_ptr_array_sort (GPtrArray* self, GCompareFunc compare_func) {
	Block67Data* _data67_;
	GCompareFunc _tmp0_ = NULL;
#line 4391 "/usr/share/vala-0.26/vapi/glib-2.0.vapi"
	g_return_if_fail (self != NULL);
#line 4391 "/usr/share/vala-0.26/vapi/glib-2.0.vapi"
	_data67_ = g_slice_new0 (Block67Data);
#line 4391 "/usr/share/vala-0.26/vapi/glib-2.0.vapi"
	_data67_->_ref_count_ = 1;
#line 4391 "/usr/share/vala-0.26/vapi/glib-2.0.vapi"
	_data67_->self = g_ptr_array_ref (self);
#line 4391 "/usr/share/vala-0.26/vapi/glib-2.0.vapi"
	_tmp0_ = compare_func;
#line 4391 "/usr/share/vala-0.26/vapi/glib-2.0.vapi"
	_data67_->compare_func = _tmp0_;
#line 4392 "/usr/share/vala-0.26/vapi/glib-2.0.vapi"
	g_ptr_array_sort_with_data (self, ___lambda1__gcompare_data_func, _data67_);
#line 4391 "/usr/share/vala-0.26/vapi/glib-2.0.vapi"
	block67_data_unref (_data67_);
#line 4391 "/usr/share/vala-0.26/vapi/glib-2.0.vapi"
	_data67_ = NULL;
#line 2037 "spice-display.c"
}


static gint ______lambda108_ (SpiceUsbDevice* a, SpiceUsbDevice* b) {
	gint result = 0;
	gchar* str_a = NULL;
	SpiceUsbDevice* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	gchar* str_b = NULL;
	SpiceUsbDevice* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	GCompareFunc _tmp4_ = NULL;
	gint _tmp5_ = 0;
#line 318 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	g_return_val_if_fail (a != NULL, 0);
#line 318 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	g_return_val_if_fail (b != NULL, 0);
#line 319 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	_tmp0_ = a;
#line 319 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	_tmp1_ = spice_usb_device_get_description (_tmp0_, "    %1$s %2$s");
#line 319 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	str_a = _tmp1_;
#line 320 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	_tmp2_ = b;
#line 320 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	_tmp3_ = spice_usb_device_get_description (_tmp2_, "    %1$s %2$s");
#line 320 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	str_b = _tmp3_;
#line 322 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	_tmp4_ = g_strcmp0;
#line 322 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	_tmp5_ = _tmp4_ (str_a, str_b);
#line 322 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	result = _tmp5_;
#line 322 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	_g_free0 (str_b);
#line 322 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	_g_free0 (str_a);
#line 322 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	return result;
#line 2079 "spice-display.c"
}


static gint _______lambda108__gcompare_func (gconstpointer a, gconstpointer b) {
	gint result;
	result = ______lambda108_ ((SpiceUsbDevice*) a, (SpiceUsbDevice*) b);
#line 318 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	return result;
#line 2088 "spice-display.c"
}


static Block68Data* block68_data_ref (Block68Data* _data68_) {
#line 324 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	g_atomic_int_inc (&_data68_->_ref_count_);
#line 324 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	return _data68_;
#line 2097 "spice-display.c"
}


static void block68_data_unref (void * _userdata_) {
	Block68Data* _data68_;
	_data68_ = (Block68Data*) _userdata_;
#line 324 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	if (g_atomic_int_dec_and_test (&_data68_->_ref_count_)) {
#line 2106 "spice-display.c"
		BoxesSpiceDisplay* self;
#line 324 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
		self = _data68_->_data66_->_data65_->self;
#line 324 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
		_g_object_unref0 (_data68_->dev_toggle);
#line 324 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
		__vala_SpiceUsbDevice_free0 (_data68_->dev);
#line 324 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
		block66_data_unref (_data68_->_data66_);
#line 324 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
		_data68_->_data66_ = NULL;
#line 324 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
		g_slice_free (Block68Data, _data68_);
#line 2120 "spice-display.c"
	}
}


static void ___lambda110_ (Block68Data* _data68_, GObject* obj, GAsyncResult* res) {
	Block66Data* _data66_;
	Block65Data* _data65_;
	BoxesSpiceDisplay* self;
	GError * _inner_error_ = NULL;
#line 338 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	_data66_ = _data68_->_data66_;
#line 338 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	_data65_ = _data66_->_data65_;
#line 338 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	self = _data65_->self;
#line 338 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	g_return_if_fail (res != NULL);
#line 2138 "spice-display.c"
	{
		SpiceUsbDeviceManager* _tmp0_ = NULL;
		GAsyncResult* _tmp1_ = NULL;
#line 340 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
		_tmp0_ = _data66_->manager;
#line 340 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
		_tmp1_ = res;
#line 340 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
		spice_usb_device_manager_connect_device_finish (_tmp0_, _tmp1_, &_inner_error_);
#line 340 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 2150 "spice-display.c"
			goto __catch73_g_error;
		}
	}
	goto __finally73;
	__catch73_g_error:
	{
		GError* err = NULL;
		GtkSwitch* _tmp2_ = NULL;
		gchar* device_desc = NULL;
		SpiceUsbDevice* _tmp3_ = NULL;
		gchar* _tmp4_ = NULL;
		gchar* box_name = NULL;
		gchar* _tmp5_ = NULL;
		gchar* msg = NULL;
		const gchar* _tmp6_ = NULL;
		gchar* _tmp7_ = NULL;
		const gchar* _tmp8_ = NULL;
		const gchar* _tmp9_ = NULL;
		const gchar* _tmp10_ = NULL;
		gchar* _tmp11_ = NULL;
		gchar* _tmp12_ = NULL;
		const gchar* _tmp13_ = NULL;
		const gchar* _tmp14_ = NULL;
		GError* _tmp15_ = NULL;
		const gchar* _tmp16_ = NULL;
#line 339 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
		err = _inner_error_;
#line 339 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
		_inner_error_ = NULL;
#line 342 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
		_tmp2_ = _data68_->dev_toggle;
#line 342 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
		gtk_switch_set_active (_tmp2_, FALSE);
#line 343 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
		_tmp3_ = _data68_->dev;
#line 343 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
		_tmp4_ = spice_usb_device_get_description (_tmp3_, "%1$s %2$s");
#line 343 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
		device_desc = _tmp4_;
#line 344 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
		_tmp5_ = boxes_spice_display_get_box_name (self);
#line 344 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
		box_name = _tmp5_;
#line 345 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
		_tmp6_ = _ ("Redirection of USB device '%s' for '%s' failed");
#line 345 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
		_tmp7_ = g_strdup (_tmp6_);
#line 345 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
		msg = _tmp7_;
#line 346 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
		_tmp8_ = msg;
#line 346 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
		_tmp9_ = device_desc;
#line 346 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
		_tmp10_ = box_name;
#line 346 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
		_tmp11_ = g_strdup_printf (_tmp8_, _tmp9_, _tmp10_);
#line 346 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
		_tmp12_ = _tmp11_;
#line 346 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
		g_signal_emit_by_name ((BoxesDisplay*) self, "got-error", _tmp12_);
#line 346 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
		_g_free0 (_tmp12_);
#line 347 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
		_tmp13_ = device_desc;
#line 347 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
		_tmp14_ = box_name;
#line 347 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
		_tmp15_ = err;
#line 347 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
		_tmp16_ = _tmp15_->message;
#line 347 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
		g_debug ("spice-display.vala:347: Error connecting %s to %s: %s", _tmp13_, _tmp14_, _tmp16_);
#line 339 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
		_g_free0 (msg);
#line 339 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
		_g_free0 (box_name);
#line 339 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
		_g_free0 (device_desc);
#line 339 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
		_g_error_free0 (err);
#line 2232 "spice-display.c"
	}
	__finally73:
#line 339 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 339 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 339 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
		g_clear_error (&_inner_error_);
#line 339 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
		return;
#line 2243 "spice-display.c"
	}
}


static void ____lambda110__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self) {
#line 338 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	___lambda110_ (self, source_object, res);
#line 338 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	block68_data_unref (self);
#line 2253 "spice-display.c"
}


static void _________lambda109_ (Block68Data* _data68_) {
	Block66Data* _data66_;
	Block65Data* _data65_;
	BoxesSpiceDisplay* self;
	GtkSwitch* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
#line 336 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	_data66_ = _data68_->_data66_;
#line 336 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	_data65_ = _data66_->_data65_;
#line 336 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	self = _data65_->self;
#line 337 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	_tmp0_ = _data68_->dev_toggle;
#line 337 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	_tmp1_ = gtk_switch_get_active (_tmp0_);
#line 337 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	_tmp2_ = _tmp1_;
#line 337 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	if (_tmp2_) {
#line 2278 "spice-display.c"
		SpiceUsbDeviceManager* _tmp3_ = NULL;
		SpiceUsbDevice* _tmp4_ = NULL;
#line 338 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
		_tmp3_ = _data66_->manager;
#line 338 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
		_tmp4_ = _data68_->dev;
#line 338 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
		spice_usb_device_manager_connect_device_async (_tmp3_, _tmp4_, NULL, ____lambda110__gasync_ready_callback, block68_data_ref (_data68_));
#line 2287 "spice-display.c"
	} else {
		SpiceUsbDeviceManager* _tmp5_ = NULL;
		SpiceUsbDevice* _tmp6_ = NULL;
#line 353 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
		_tmp5_ = _data66_->manager;
#line 353 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
		_tmp6_ = _data68_->dev;
#line 353 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
		spice_usb_device_manager_disconnect_device (_tmp5_, _tmp6_);
#line 2297 "spice-display.c"
	}
}


static void __________lambda109__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self) {
#line 336 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	_________lambda109_ (self);
#line 2305 "spice-display.c"
}


static void ______lambda111_ (Block66Data* _data66_, SpiceUsbDeviceManager* manager, SpiceUsbDevice* dev) {
	Block65Data* _data65_;
	BoxesSpiceDisplay* self;
	BoxesProperty* _tmp0_ = NULL;
#line 357 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	_data65_ = _data66_->_data65_;
#line 357 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	self = _data65_->self;
#line 357 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	g_return_if_fail (manager != NULL);
#line 357 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	g_return_if_fail (dev != NULL);
#line 358 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	_tmp0_ = _data65_->usb_property;
#line 358 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	g_signal_emit_by_name (_tmp0_, "refresh-properties");
#line 2325 "spice-display.c"
}


static void _______lambda111__spice_usb_device_manager_device_added (SpiceUsbDeviceManager* _sender, SpiceUsbDevice* device, gpointer self) {
#line 357 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	______lambda111_ (self, _sender, device);
#line 2332 "spice-display.c"
}


static gboolean __lambda113_ (Block66Data* _data66_) {
	Block65Data* _data65_;
	BoxesSpiceDisplay* self;
	gboolean result = FALSE;
	BoxesProperty* _tmp0_ = NULL;
#line 361 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	_data65_ = _data66_->_data65_;
#line 361 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	self = _data65_->self;
#line 366 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	_tmp0_ = _data65_->usb_property;
#line 366 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	g_signal_emit_by_name (_tmp0_, "refresh-properties");
#line 367 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	result = FALSE;
#line 367 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	return result;
#line 2353 "spice-display.c"
}


static gboolean ___lambda113__gsource_func (gpointer self) {
	gboolean result;
	result = __lambda113_ (self);
#line 361 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	return result;
#line 2362 "spice-display.c"
}


static void ______lambda112_ (Block66Data* _data66_, SpiceUsbDeviceManager* manager, SpiceUsbDevice* dev) {
	Block65Data* _data65_;
	BoxesSpiceDisplay* self;
#line 360 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	_data65_ = _data66_->_data65_;
#line 360 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	self = _data65_->self;
#line 360 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	g_return_if_fail (manager != NULL);
#line 360 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	g_return_if_fail (dev != NULL);
#line 361 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	g_idle_add_full (G_PRIORITY_DEFAULT_IDLE, ___lambda113__gsource_func, block66_data_ref (_data66_), block66_data_unref);
#line 2379 "spice-display.c"
}


static void _______lambda112__spice_usb_device_manager_device_removed (SpiceUsbDeviceManager* _sender, SpiceUsbDevice* device, gpointer self) {
#line 360 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	______lambda112_ (self, _sender, device);
#line 2386 "spice-display.c"
}


static void _g_object_unref0_ (gpointer var) {
#line 315 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
#line 2393 "spice-display.c"
}


static void _g_list_free__g_object_unref0_ (GList* self) {
#line 315 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	g_list_foreach (self, (GFunc) _g_object_unref0_, NULL);
#line 315 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	g_list_free (self);
#line 2402 "spice-display.c"
}


static GList* boxes_spice_display_real_get_properties (BoxesDisplay* base, BoxesPropertiesPage page, PropertyCreationFlag* flags) {
	BoxesSpiceDisplay * self;
	GList* result = NULL;
	GList* list = NULL;
	BoxesPropertiesPage _tmp0_ = 0;
	GError * _inner_error_ = NULL;
#line 287 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	self = (BoxesSpiceDisplay*) base;
#line 288 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	list = NULL;
#line 290 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	_tmp0_ = page;
#line 290 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	switch (_tmp0_) {
#line 290 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
		case BOXES_PROPERTIES_PAGE_DISPLAY:
#line 2422 "spice-display.c"
		{
			GtkSwitch* toggle = NULL;
			GtkSwitch* _tmp1_ = NULL;
			SpiceGtkSession* _tmp2_ = NULL;
			GtkSwitch* _tmp3_ = NULL;
			GtkSwitch* _tmp4_ = NULL;
			const gchar* _tmp5_ = NULL;
			GtkSwitch* _tmp6_ = NULL;
			BoxesProperty* _tmp7_ = NULL;
			BoxesProperty* _tmp8_ = NULL;
			GtkSwitch* _tmp9_ = NULL;
			GtkSwitch* _tmp10_ = NULL;
			GtkSwitch* _tmp11_ = NULL;
			const gchar* _tmp12_ = NULL;
			GtkSwitch* _tmp13_ = NULL;
			BoxesProperty* _tmp14_ = NULL;
			BoxesProperty* _tmp15_ = NULL;
#line 292 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
			_tmp1_ = (GtkSwitch*) gtk_switch_new ();
#line 292 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
			g_object_ref_sink (_tmp1_);
#line 292 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
			toggle = _tmp1_;
#line 293 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
			_tmp2_ = self->priv->gtk_session;
#line 293 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
			_tmp3_ = toggle;
#line 293 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
			g_object_bind_property_with_closures ((GObject*) _tmp2_, "auto-clipboard", (GObject*) _tmp3_, "active", G_BINDING_BIDIRECTIONAL | G_BINDING_SYNC_CREATE, (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, NULL)), (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, NULL)));
#line 295 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
			_tmp4_ = toggle;
#line 295 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
			gtk_widget_set_halign ((GtkWidget*) _tmp4_, GTK_ALIGN_START);
#line 296 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
			_tmp5_ = _ ("Share clipboard");
#line 296 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
			_tmp6_ = toggle;
#line 296 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
			_tmp7_ = boxes_iproperties_provider_add_property ((BoxesIPropertiesProvider*) self, &list, _tmp5_, (GtkWidget*) _tmp6_, NULL);
#line 296 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
			_tmp8_ = _tmp7_;
#line 296 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
			_g_object_unref0 (_tmp8_);
#line 298 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
			_tmp9_ = (GtkSwitch*) gtk_switch_new ();
#line 298 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
			g_object_ref_sink (_tmp9_);
#line 298 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
			_g_object_unref0 (toggle);
#line 298 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
			toggle = _tmp9_;
#line 299 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
			_tmp10_ = toggle;
#line 299 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
			g_object_bind_property_with_closures ((GObject*) self, "resize-guest", (GObject*) _tmp10_, "active", G_BINDING_BIDIRECTIONAL | G_BINDING_SYNC_CREATE, (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, NULL)), (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, NULL)));
#line 301 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
			_tmp11_ = toggle;
#line 301 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
			gtk_widget_set_halign ((GtkWidget*) _tmp11_, GTK_ALIGN_START);
#line 302 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
			_tmp12_ = _ ("Resize guest");
#line 302 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
			_tmp13_ = toggle;
#line 302 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
			_tmp14_ = boxes_iproperties_provider_add_property ((BoxesIPropertiesProvider*) self, &list, _tmp12_, (GtkWidget*) _tmp13_, NULL);
#line 302 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
			_tmp15_ = _tmp14_;
#line 302 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
			_g_object_unref0 (_tmp15_);
#line 303 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
			_g_object_unref0 (toggle);
#line 303 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
			break;
#line 2496 "spice-display.c"
		}
#line 290 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
		case BOXES_PROPERTIES_PAGE_DEVICES:
#line 2500 "spice-display.c"
		{
			gboolean _tmp16_ = FALSE;
			PropertyCreationFlag _tmp17_ = 0;
#line 306 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
			_tmp17_ = *flags;
#line 306 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
			if (!((_tmp17_ & PROPERTY_CREATION_FLAG_NO_USB) == PROPERTY_CREATION_FLAG_NO_USB)) {
#line 306 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
				_tmp16_ = HAVE_USBREDIR;
#line 2510 "spice-display.c"
			} else {
#line 306 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
				_tmp16_ = FALSE;
#line 2514 "spice-display.c"
			}
#line 306 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
			if (_tmp16_) {
#line 2518 "spice-display.c"
				Block65Data* _data65_;
				GtkSwitch* toggle = NULL;
				GtkSwitch* _tmp18_ = NULL;
				SpiceGtkSession* _tmp19_ = NULL;
				GtkSwitch* _tmp20_ = NULL;
				GtkSwitch* _tmp21_ = NULL;
				const gchar* _tmp22_ = NULL;
				GtkSwitch* _tmp23_ = NULL;
				BoxesProperty* _tmp24_ = NULL;
				gboolean _tmp25_ = FALSE;
#line 306 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
				_data65_ = g_slice_new0 (Block65Data);
#line 306 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
				_data65_->_ref_count_ = 1;
#line 306 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
				_data65_->self = g_object_ref (self);
#line 307 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
				_tmp18_ = (GtkSwitch*) gtk_switch_new ();
#line 307 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
				g_object_ref_sink (_tmp18_);
#line 307 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
				toggle = _tmp18_;
#line 308 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
				_tmp19_ = self->priv->gtk_session;
#line 308 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
				_tmp20_ = toggle;
#line 308 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
				g_object_bind_property_with_closures ((GObject*) _tmp19_, "auto-usbredir", (GObject*) _tmp20_, "active", G_BINDING_BIDIRECTIONAL | G_BINDING_SYNC_CREATE, (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, NULL)), (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, NULL)));
#line 310 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
				_tmp21_ = toggle;
#line 310 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
				gtk_widget_set_halign ((GtkWidget*) _tmp21_, GTK_ALIGN_START);
#line 311 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
				_tmp22_ = _ ("Redirect new USB devices");
#line 311 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
				_tmp23_ = toggle;
#line 311 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
				_tmp24_ = boxes_iproperties_provider_add_property ((BoxesIPropertiesProvider*) self, &list, _tmp22_, (GtkWidget*) _tmp23_, NULL);
#line 311 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
				_data65_->usb_property = _tmp24_;
#line 313 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
				_tmp25_ = ((BoxesDisplay*) self)->connected;
#line 313 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
				if (_tmp25_) {
#line 2563 "spice-display.c"
					gboolean found_dev = FALSE;
#line 314 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
					found_dev = FALSE;
#line 2567 "spice-display.c"
					{
						Block66Data* _data66_;
						SpiceSession* _tmp26_ = NULL;
						SpiceUsbDeviceManager* _tmp27_ = NULL;
						SpiceUsbDeviceManager* _tmp28_ = NULL;
						GPtrArray* devs = NULL;
						SpiceUsbDeviceManager* _tmp29_ = NULL;
						GPtrArray* _tmp30_ = NULL;
						GPtrArray* _tmp31_ = NULL;
						SpiceUsbDeviceManager* _tmp61_ = NULL;
						SpiceUsbDeviceManager* _tmp62_ = NULL;
#line 315 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
						_data66_ = g_slice_new0 (Block66Data);
#line 315 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
						_data66_->_ref_count_ = 1;
#line 315 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
						_data66_->_data65_ = block65_data_ref (_data65_);
#line 316 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
						_tmp26_ = self->priv->session;
#line 316 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
						_tmp27_ = spice_usb_device_manager_get (_tmp26_, &_inner_error_);
#line 316 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
						_tmp28_ = _g_object_ref0 (_tmp27_);
#line 316 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
						_data66_->manager = _tmp28_;
#line 316 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
						if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 316 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
							block66_data_unref (_data66_);
#line 316 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
							_data66_ = NULL;
#line 2599 "spice-display.c"
							goto __catch72_g_error;
						}
#line 317 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
						_tmp29_ = _data66_->manager;
#line 317 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
						_tmp30_ = spice_usb_device_manager_get_devices (_tmp29_);
#line 317 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
						devs = _tmp30_;
#line 318 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
						_tmp31_ = devs;
#line 318 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
						vala_g_ptr_array_sort (_tmp31_, _______lambda108__gcompare_func);
#line 2612 "spice-display.c"
						{
							gint i = 0;
#line 324 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
							i = 0;
#line 2617 "spice-display.c"
							{
								gboolean _tmp32_ = FALSE;
#line 324 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
								_tmp32_ = TRUE;
#line 324 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
								while (TRUE) {
#line 2624 "spice-display.c"
									Block68Data* _data68_;
									gint _tmp34_ = 0;
									GPtrArray* _tmp35_ = NULL;
									gint _tmp36_ = 0;
									gint _tmp37_ = 0;
									GPtrArray* _tmp38_ = NULL;
									gint _tmp39_ = 0;
									gconstpointer _tmp40_ = NULL;
									SpiceUsbDevice* _tmp41_ = NULL;
									GtkSwitch* _tmp42_ = NULL;
									GtkSwitch* _tmp43_ = NULL;
									gboolean _tmp44_ = FALSE;
									SpiceUsbDevice* _tmp50_ = NULL;
									gchar* _tmp51_ = NULL;
									gchar* _tmp52_ = NULL;
									GtkSwitch* _tmp53_ = NULL;
									BoxesProperty* _tmp54_ = NULL;
									BoxesProperty* _tmp55_ = NULL;
									GtkSwitch* _tmp56_ = NULL;
									SpiceUsbDeviceManager* _tmp57_ = NULL;
									SpiceUsbDevice* _tmp58_ = NULL;
									gboolean _tmp59_ = FALSE;
									GtkSwitch* _tmp60_ = NULL;
#line 324 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
									_data68_ = g_slice_new0 (Block68Data);
#line 324 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
									_data68_->_ref_count_ = 1;
#line 324 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
									_data68_->_data66_ = block66_data_ref (_data66_);
#line 324 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
									if (!_tmp32_) {
#line 2656 "spice-display.c"
										gint _tmp33_ = 0;
#line 324 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
										_tmp33_ = i;
#line 324 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
										i = _tmp33_ + 1;
#line 2662 "spice-display.c"
									}
#line 324 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
									_tmp32_ = FALSE;
#line 324 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
									_tmp34_ = i;
#line 324 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
									_tmp35_ = devs;
#line 324 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
									_tmp36_ = g_ptr_array_get_length (_tmp35_);
#line 324 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
									_tmp37_ = _tmp36_;
#line 324 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
									if (!(_tmp34_ < _tmp37_)) {
#line 324 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
										block68_data_unref (_data68_);
#line 324 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
										_data68_ = NULL;
#line 324 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
										break;
#line 2682 "spice-display.c"
									}
#line 325 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
									_tmp38_ = devs;
#line 325 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
									_tmp39_ = i;
#line 325 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
									_tmp40_ = g_ptr_array_index (_tmp38_, (guint) _tmp39_);
#line 325 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
									_tmp41_ = __vala_SpiceUsbDevice_copy0 ((SpiceUsbDevice*) _tmp40_);
#line 325 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
									_data68_->dev = _tmp41_;
#line 327 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
									_tmp42_ = (GtkSwitch*) gtk_switch_new ();
#line 327 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
									g_object_ref_sink (_tmp42_);
#line 327 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
									_data68_->dev_toggle = _tmp42_;
#line 328 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
									_tmp43_ = _data68_->dev_toggle;
#line 328 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
									gtk_widget_set_halign ((GtkWidget*) _tmp43_, GTK_ALIGN_START);
#line 330 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
									_tmp44_ = found_dev;
#line 330 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
									if (!_tmp44_) {
#line 2708 "spice-display.c"
										const gchar* _tmp45_ = NULL;
										GtkLabel* _tmp46_ = NULL;
										GtkLabel* _tmp47_ = NULL;
										BoxesProperty* _tmp48_ = NULL;
										BoxesProperty* _tmp49_ = NULL;
#line 331 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
										_tmp45_ = _ ("USB devices");
#line 331 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
										_tmp46_ = (GtkLabel*) gtk_label_new ("");
#line 331 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
										g_object_ref_sink (_tmp46_);
#line 331 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
										_tmp47_ = _tmp46_;
#line 331 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
										_tmp48_ = boxes_iproperties_provider_add_property ((BoxesIPropertiesProvider*) self, &list, _tmp45_, (GtkWidget*) _tmp47_, NULL);
#line 331 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
										_tmp49_ = _tmp48_;
#line 331 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
										_g_object_unref0 (_tmp49_);
#line 331 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
										_g_object_unref0 (_tmp47_);
#line 2730 "spice-display.c"
									}
#line 332 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
									found_dev = TRUE;
#line 333 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
									_tmp50_ = _data68_->dev;
#line 333 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
									_tmp51_ = spice_usb_device_get_description (_tmp50_, "    %1$s %2$s");
#line 333 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
									_tmp52_ = _tmp51_;
#line 333 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
									_tmp53_ = _data68_->dev_toggle;
#line 333 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
									_tmp54_ = boxes_iproperties_provider_add_property ((BoxesIPropertiesProvider*) self, &list, _tmp52_, (GtkWidget*) _tmp53_, NULL);
#line 333 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
									_tmp55_ = _tmp54_;
#line 333 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
									_g_object_unref0 (_tmp55_);
#line 333 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
									_g_free0 (_tmp52_);
#line 334 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
									_tmp56_ = _data68_->dev_toggle;
#line 334 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
									_tmp57_ = _data66_->manager;
#line 334 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
									_tmp58_ = _data68_->dev;
#line 334 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
									_tmp59_ = spice_usb_device_manager_is_device_connected (_tmp57_, _tmp58_);
#line 334 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
									gtk_switch_set_active (_tmp56_, _tmp59_);
#line 336 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
									_tmp60_ = _data68_->dev_toggle;
#line 336 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
									g_signal_connect_data ((GObject*) _tmp60_, "notify::active", (GCallback) __________lambda109__g_object_notify, block68_data_ref (_data68_), (GClosureNotify) block68_data_unref, 0);
#line 324 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
									block68_data_unref (_data68_);
#line 324 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
									_data68_ = NULL;
#line 2768 "spice-display.c"
								}
							}
						}
#line 357 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
						_tmp61_ = _data66_->manager;
#line 357 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
						g_signal_connect_data (_tmp61_, "device-added", (GCallback) _______lambda111__spice_usb_device_manager_device_added, block66_data_ref (_data66_), (GClosureNotify) block66_data_unref, 0);
#line 360 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
						_tmp62_ = _data66_->manager;
#line 360 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
						g_signal_connect_data (_tmp62_, "device-removed", (GCallback) _______lambda112__spice_usb_device_manager_device_removed, block66_data_ref (_data66_), (GClosureNotify) block66_data_unref, 0);
#line 315 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
						_g_ptr_array_unref0 (devs);
#line 315 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
						block66_data_unref (_data66_);
#line 315 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
						_data66_ = NULL;
#line 2786 "spice-display.c"
					}
					goto __finally72;
					__catch72_g_error:
					{
						GError* _error_ = NULL;
#line 315 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
						_error_ = _inner_error_;
#line 315 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
						_inner_error_ = NULL;
#line 315 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
						_g_error_free0 (_error_);
#line 2798 "spice-display.c"
					}
					__finally72:
#line 315 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
					if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 315 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
						_g_object_unref0 (toggle);
#line 315 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
						block65_data_unref (_data65_);
#line 315 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
						_data65_ = NULL;
#line 315 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
						__g_list_free__g_object_unref0_0 (list);
#line 315 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 315 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
						g_clear_error (&_inner_error_);
#line 315 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
						return NULL;
#line 2817 "spice-display.c"
					}
				}
#line 306 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
				_g_object_unref0 (toggle);
#line 306 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
				block65_data_unref (_data65_);
#line 306 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
				_data65_ = NULL;
#line 2826 "spice-display.c"
			}
#line 374 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
			break;
#line 2830 "spice-display.c"
		}
		default:
#line 290 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
		break;
#line 2835 "spice-display.c"
	}
#line 377 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	result = list;
#line 377 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	return result;
#line 2841 "spice-display.c"
}


static const gchar* boxes_spice_display_real_get_protocol (BoxesDisplay* base) {
	const gchar* result;
	BoxesSpiceDisplay* self;
#line 6 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	self = (BoxesSpiceDisplay*) base;
#line 6 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	result = "SPICE";
#line 6 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	return result;
#line 2854 "spice-display.c"
}


static gchar* boxes_spice_display_real_get_uri (BoxesDisplay* base) {
	gchar* result;
	BoxesSpiceDisplay* self;
	SpiceSession* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
#line 7 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	self = (BoxesSpiceDisplay*) base;
#line 7 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	_tmp0_ = self->priv->session;
#line 7 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	g_object_get (_tmp0_, "uri", &_tmp1_, NULL);
#line 7 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	_tmp2_ = _tmp1_;
#line 7 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	result = _tmp2_;
#line 7 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	return result;
#line 2876 "spice-display.c"
}


GByteArray* boxes_spice_display_get_ca_cert (BoxesSpiceDisplay* self) {
	GByteArray* result;
	SpiceSession* _tmp0_ = NULL;
	GByteArray* _tmp1_ = NULL;
	GByteArray* _tmp2_ = NULL;
#line 8 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 8 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	_tmp0_ = self->priv->session;
#line 8 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	g_object_get (_tmp0_, "ca", &_tmp1_, NULL);
#line 8 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	_tmp2_ = _tmp1_;
#line 8 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	result = _tmp2_;
#line 8 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	return result;
#line 2897 "spice-display.c"
}


void boxes_spice_display_set_ca_cert (BoxesSpiceDisplay* self, GByteArray* value) {
	SpiceSession* _tmp0_ = NULL;
	GByteArray* _tmp1_ = NULL;
#line 8 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	g_return_if_fail (self != NULL);
#line 8 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	_tmp0_ = self->priv->session;
#line 8 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	_tmp1_ = value;
#line 8 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	g_object_set (_tmp0_, "ca", _tmp1_, NULL);
#line 8 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	g_object_notify ((GObject *) self, "ca-cert");
#line 2914 "spice-display.c"
}


gboolean boxes_spice_display_get_resize_guest (BoxesSpiceDisplay* self) {
	gboolean result;
	gboolean _tmp0_ = FALSE;
#line 21 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 21 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	_tmp0_ = self->priv->_resize_guest;
#line 21 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	result = _tmp0_;
#line 21 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	return result;
#line 2929 "spice-display.c"
}


void boxes_spice_display_set_resize_guest (BoxesSpiceDisplay* self, gboolean value) {
	gboolean _tmp0_ = FALSE;
#line 21 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	g_return_if_fail (self != NULL);
#line 21 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	_tmp0_ = value;
#line 21 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	self->priv->_resize_guest = _tmp0_;
#line 21 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	g_object_notify ((GObject *) self, "resize-guest");
#line 2943 "spice-display.c"
}


static void _boxes_spice_display____lambda114_ (BoxesSpiceDisplay* self, SpiceUsbDevice* dev, GError* err) {
	gchar* device_description = NULL;
	SpiceUsbDevice* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	gchar* box_name = NULL;
	gchar* _tmp2_ = NULL;
	const gchar* _tmp3_ = NULL;
	const gchar* _tmp4_ = NULL;
	const gchar* _tmp5_ = NULL;
	gchar* _tmp6_ = NULL;
	gchar* _tmp7_ = NULL;
	const gchar* _tmp8_ = NULL;
	const gchar* _tmp9_ = NULL;
	GError* _tmp10_ = NULL;
	const gchar* _tmp11_ = NULL;
#line 52 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	g_return_if_fail (dev != NULL);
#line 53 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	_tmp0_ = dev;
#line 53 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	_tmp1_ = spice_usb_device_get_description (_tmp0_, "%1$s %2$s");
#line 53 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	device_description = _tmp1_;
#line 54 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	_tmp2_ = boxes_spice_display_get_box_name (self);
#line 54 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	box_name = _tmp2_;
#line 55 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	_tmp3_ = _ ("Automatic redirection of USB device '%s' for '%s' failed");
#line 55 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	_tmp4_ = device_description;
#line 55 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	_tmp5_ = box_name;
#line 55 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	_tmp6_ = g_strdup_printf (_tmp3_, _tmp4_, _tmp5_);
#line 55 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	_tmp7_ = _tmp6_;
#line 55 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	g_signal_emit_by_name ((BoxesDisplay*) self, "got-error", _tmp7_);
#line 55 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	_g_free0 (_tmp7_);
#line 57 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	_tmp8_ = device_description;
#line 57 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	_tmp9_ = box_name;
#line 57 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	_tmp10_ = err;
#line 57 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	_tmp11_ = _tmp10_->message;
#line 57 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	g_debug ("spice-display.vala:57: Error auto-connecting %s for %s: %s", _tmp8_, _tmp9_, _tmp11_);
#line 52 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	_g_free0 (box_name);
#line 52 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	_g_free0 (device_description);
#line 3002 "spice-display.c"
}


static void __boxes_spice_display____lambda114__spice_usb_device_manager_auto_connect_failed (SpiceUsbDeviceManager* _sender, SpiceUsbDevice* device, GError* _error_, gpointer self) {
#line 52 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	_boxes_spice_display____lambda114_ ((BoxesSpiceDisplay*) self, device, _error_);
#line 3009 "spice-display.c"
}


static void _boxes_spice_display____lambda115_ (BoxesSpiceDisplay* self, SpiceUsbDevice* dev, GError* err) {
	gchar* device_description = NULL;
	SpiceUsbDevice* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	gchar* box_name = NULL;
	gchar* _tmp2_ = NULL;
	const gchar* _tmp3_ = NULL;
	const gchar* _tmp4_ = NULL;
	const gchar* _tmp5_ = NULL;
	gchar* _tmp6_ = NULL;
	gchar* _tmp7_ = NULL;
	const gchar* _tmp8_ = NULL;
	const gchar* _tmp9_ = NULL;
	GError* _tmp10_ = NULL;
	const gchar* _tmp11_ = NULL;
#line 60 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	g_return_if_fail (dev != NULL);
#line 61 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	_tmp0_ = dev;
#line 61 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	_tmp1_ = spice_usb_device_get_description (_tmp0_, "%1$s %2$s");
#line 61 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	device_description = _tmp1_;
#line 62 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	_tmp2_ = boxes_spice_display_get_box_name (self);
#line 62 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	box_name = _tmp2_;
#line 63 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	_tmp3_ = _ ("Redirection of USB device '%s' for '%s' failed");
#line 63 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	_tmp4_ = device_description;
#line 63 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	_tmp5_ = box_name;
#line 63 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	_tmp6_ = g_strdup_printf (_tmp3_, _tmp4_, _tmp5_);
#line 63 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	_tmp7_ = _tmp6_;
#line 63 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	g_signal_emit_by_name ((BoxesDisplay*) self, "got-error", _tmp7_);
#line 63 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	_g_free0 (_tmp7_);
#line 64 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	_tmp8_ = device_description;
#line 64 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	_tmp9_ = box_name;
#line 64 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	_tmp10_ = err;
#line 64 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	_tmp11_ = _tmp10_->message;
#line 64 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	g_debug ("spice-display.vala:64: Error connecting %s to %s: %s", _tmp8_, _tmp9_, _tmp11_);
#line 60 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	_g_free0 (box_name);
#line 60 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	_g_free0 (device_description);
#line 3068 "spice-display.c"
}


static void __boxes_spice_display____lambda115__spice_usb_device_manager_device_error (SpiceUsbDeviceManager* _sender, SpiceUsbDevice* device, GError* _error_, gpointer self) {
#line 60 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	_boxes_spice_display____lambda115_ ((BoxesSpiceDisplay*) self, device, _error_);
#line 3075 "spice-display.c"
}


static void _boxes_spice_display___lambda116_ (BoxesSpiceDisplay* self) {
	BoxesBoxConfig* _tmp0_ = NULL;
	BoxesBoxConfig* _tmp1_ = NULL;
	SpiceGtkSession* _tmp2_ = NULL;
	BoxesBoxConfigSyncProperty* _tmp3_ = NULL;
	gint _tmp3__length1 = 0;
#line 70 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	_tmp0_ = boxes_display_get_config ((BoxesDisplay*) self);
#line 70 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	_tmp1_ = _tmp0_;
#line 70 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	_tmp2_ = self->priv->gtk_session;
#line 70 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	_tmp3_ = self->priv->gtk_session_sync_properties;
#line 70 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	_tmp3__length1 = self->priv->gtk_session_sync_properties_length1;
#line 70 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	boxes_box_config_sync_properties (_tmp1_, (GObject*) _tmp2_, _tmp3_, _tmp3__length1);
#line 3097 "spice-display.c"
}


static void __boxes_spice_display___lambda116__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self) {
#line 69 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	_boxes_spice_display___lambda116_ ((BoxesSpiceDisplay*) self);
#line 3104 "spice-display.c"
}


static GObject * boxes_spice_display_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties) {
	GObject * obj;
	GObjectClass * parent_class;
	BoxesSpiceDisplay * self;
	gchar* _tmp0_ = NULL;
	GValue _tmp1_ = {0};
	BoxesBoxConfigSyncProperty _tmp2_ = {0};
	BoxesBoxConfigSyncProperty* _tmp3_ = NULL;
	gchar* _tmp4_ = NULL;
	GValue _tmp5_ = {0};
	BoxesBoxConfigSyncProperty _tmp6_ = {0};
	gchar* _tmp7_ = NULL;
	GValue _tmp8_ = {0};
	BoxesBoxConfigSyncProperty _tmp9_ = {0};
	BoxesBoxConfigSyncProperty* _tmp10_ = NULL;
	SpiceSession* _tmp11_ = NULL;
	SpiceSession* _tmp12_ = NULL;
	SpiceAudio* _tmp13_ = NULL;
	SpiceSession* _tmp14_ = NULL;
	SpiceGtkSession* _tmp15_ = NULL;
	GError * _inner_error_ = NULL;
#line 36 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	parent_class = G_OBJECT_CLASS (boxes_spice_display_parent_class);
#line 36 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
#line 36 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, BOXES_TYPE_SPICE_DISPLAY, BoxesSpiceDisplay);
#line 37 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	_tmp0_ = g_strdup ("resize-guest");
#line 37 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	g_value_init (&_tmp1_, G_TYPE_BOOLEAN);
#line 37 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	g_value_set_boolean (&_tmp1_, TRUE);
#line 37 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	memset (&_tmp2_, 0, sizeof (BoxesBoxConfigSyncProperty));
#line 37 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	_g_free0 (_tmp2_.name);
#line 37 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	_tmp2_.name = _tmp0_;
#line 37 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	G_IS_VALUE (&_tmp2_.default_value) ? (g_value_unset (&_tmp2_.default_value), NULL) : NULL;
#line 37 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	_tmp2_.default_value = _tmp1_;
#line 37 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	_tmp3_ = g_new0 (BoxesBoxConfigSyncProperty, 1);
#line 37 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	_tmp3_[0] = _tmp2_;
#line 37 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	self->priv->display_sync_properties = (_vala_BoxesBoxConfigSyncProperty_array_free (self->priv->display_sync_properties, self->priv->display_sync_properties_length1), NULL);
#line 37 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	self->priv->display_sync_properties = _tmp3_;
#line 37 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	self->priv->display_sync_properties_length1 = 1;
#line 37 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	self->priv->_display_sync_properties_size_ = self->priv->display_sync_properties_length1;
#line 41 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	_tmp4_ = g_strdup ("auto-clipboard");
#line 41 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	g_value_init (&_tmp5_, G_TYPE_BOOLEAN);
#line 41 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	g_value_set_boolean (&_tmp5_, TRUE);
#line 41 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	memset (&_tmp6_, 0, sizeof (BoxesBoxConfigSyncProperty));
#line 41 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	_g_free0 (_tmp6_.name);
#line 41 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	_tmp6_.name = _tmp4_;
#line 41 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	G_IS_VALUE (&_tmp6_.default_value) ? (g_value_unset (&_tmp6_.default_value), NULL) : NULL;
#line 41 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	_tmp6_.default_value = _tmp5_;
#line 41 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	_tmp7_ = g_strdup ("auto-usbredir");
#line 41 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	g_value_init (&_tmp8_, G_TYPE_BOOLEAN);
#line 41 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	g_value_set_boolean (&_tmp8_, FALSE);
#line 41 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	memset (&_tmp9_, 0, sizeof (BoxesBoxConfigSyncProperty));
#line 41 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	_g_free0 (_tmp9_.name);
#line 41 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	_tmp9_.name = _tmp7_;
#line 41 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	G_IS_VALUE (&_tmp9_.default_value) ? (g_value_unset (&_tmp9_.default_value), NULL) : NULL;
#line 41 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	_tmp9_.default_value = _tmp8_;
#line 41 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	_tmp10_ = g_new0 (BoxesBoxConfigSyncProperty, 2);
#line 41 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	_tmp10_[0] = _tmp6_;
#line 41 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	_tmp10_[1] = _tmp9_;
#line 41 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	self->priv->gtk_session_sync_properties = (_vala_BoxesBoxConfigSyncProperty_array_free (self->priv->gtk_session_sync_properties, self->priv->gtk_session_sync_properties_length1), NULL);
#line 41 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	self->priv->gtk_session_sync_properties = _tmp10_;
#line 41 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	self->priv->gtk_session_sync_properties_length1 = 2;
#line 41 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	self->priv->_gtk_session_sync_properties_size_ = self->priv->gtk_session_sync_properties_length1;
#line 46 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	boxes_display_set_need_password ((BoxesDisplay*) self, FALSE);
#line 47 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	_tmp11_ = spice_session_new ();
#line 47 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	_g_object_unref0 (self->priv->session);
#line 47 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	self->priv->session = _tmp11_;
#line 48 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	_tmp12_ = self->priv->session;
#line 48 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	_tmp13_ = spice_audio_get (_tmp12_, NULL);
#line 48 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	self->priv->audio = _tmp13_;
#line 49 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	_tmp14_ = self->priv->session;
#line 49 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	_tmp15_ = spice_gtk_session_get (_tmp14_);
#line 49 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	self->priv->gtk_session = _tmp15_;
#line 3229 "spice-display.c"
	{
		SpiceUsbDeviceManager* manager = NULL;
		SpiceSession* _tmp16_ = NULL;
		SpiceUsbDeviceManager* _tmp17_ = NULL;
		SpiceUsbDeviceManager* _tmp18_ = NULL;
		SpiceUsbDeviceManager* _tmp19_ = NULL;
		SpiceUsbDeviceManager* _tmp20_ = NULL;
#line 51 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
		_tmp16_ = self->priv->session;
#line 51 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
		_tmp17_ = spice_usb_device_manager_get (_tmp16_, &_inner_error_);
#line 51 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
		_tmp18_ = _g_object_ref0 (_tmp17_);
#line 51 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
		manager = _tmp18_;
#line 51 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 3247 "spice-display.c"
			goto __catch74_g_error;
		}
#line 52 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
		_tmp19_ = manager;
#line 52 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
		g_signal_connect_object (_tmp19_, "auto-connect-failed", (GCallback) __boxes_spice_display____lambda114__spice_usb_device_manager_auto_connect_failed, self, 0);
#line 60 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
		_tmp20_ = manager;
#line 60 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
		g_signal_connect_object (_tmp20_, "device-error", (GCallback) __boxes_spice_display____lambda115__spice_usb_device_manager_device_error, self, 0);
#line 50 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
		_g_object_unref0 (manager);
#line 3260 "spice-display.c"
	}
	goto __finally74;
	__catch74_g_error:
	{
		GError* _error_ = NULL;
#line 50 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
		_error_ = _inner_error_;
#line 50 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
		_inner_error_ = NULL;
#line 50 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
		_g_error_free0 (_error_);
#line 3272 "spice-display.c"
	}
	__finally74:
#line 50 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 50 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 50 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
		g_clear_error (&_inner_error_);
#line 3281 "spice-display.c"
	}
#line 69 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	g_signal_connect_object ((GObject*) self, "notify::config", (GCallback) __boxes_spice_display___lambda116__g_object_notify, self, 0);
#line 36 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	return obj;
#line 3287 "spice-display.c"
}


static void boxes_spice_display_class_init (BoxesSpiceDisplayClass * klass) {
#line 5 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	boxes_spice_display_parent_class = g_type_class_peek_parent (klass);
#line 5 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	g_type_class_add_private (klass, sizeof (BoxesSpiceDisplayPrivate));
#line 5 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	((BoxesDisplayClass *) klass)->get_display = boxes_spice_display_real_get_display;
#line 5 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	((BoxesDisplayClass *) klass)->should_keep_alive = boxes_spice_display_real_should_keep_alive;
#line 5 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	((BoxesDisplayClass *) klass)->set_enable_audio = boxes_spice_display_real_set_enable_audio;
#line 5 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	((BoxesDisplayClass *) klass)->set_enable_inputs = boxes_spice_display_real_set_enable_inputs;
#line 5 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	((BoxesDisplayClass *) klass)->get_pixbuf = boxes_spice_display_real_get_pixbuf;
#line 5 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	((BoxesDisplayClass *) klass)->collect_logs = boxes_spice_display_real_collect_logs;
#line 5 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	((BoxesDisplayClass *) klass)->connect_it = boxes_spice_display_real_connect_it;
#line 5 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	((BoxesDisplayClass *) klass)->disconnect_it = boxes_spice_display_real_disconnect_it;
#line 5 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	((BoxesDisplayClass *) klass)->get_properties = boxes_spice_display_real_get_properties;
#line 5 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	BOXES_DISPLAY_CLASS (klass)->get_protocol = boxes_spice_display_real_get_protocol;
#line 5 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	BOXES_DISPLAY_CLASS (klass)->get_uri = boxes_spice_display_real_get_uri;
#line 5 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	G_OBJECT_CLASS (klass)->get_property = _vala_boxes_spice_display_get_property;
#line 5 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	G_OBJECT_CLASS (klass)->set_property = _vala_boxes_spice_display_set_property;
#line 5 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	G_OBJECT_CLASS (klass)->constructor = boxes_spice_display_constructor;
#line 5 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	G_OBJECT_CLASS (klass)->finalize = boxes_spice_display_finalize;
#line 5 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), BOXES_SPICE_DISPLAY_PROTOCOL, g_param_spec_string ("protocol", "protocol", "protocol", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
#line 5 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), BOXES_SPICE_DISPLAY_URI, g_param_spec_string ("uri", "uri", "uri", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
#line 5 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), BOXES_SPICE_DISPLAY_CA_CERT, g_param_spec_boxed ("ca-cert", "ca-cert", "ca-cert", G_TYPE_BYTE_ARRAY, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 5 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), BOXES_SPICE_DISPLAY_RESIZE_GUEST, g_param_spec_boolean ("resize-guest", "resize-guest", "resize-guest", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 3334 "spice-display.c"
}


static void boxes_spice_display_instance_init (BoxesSpiceDisplay * self) {
#line 5 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	self->priv = BOXES_SPICE_DISPLAY_GET_PRIVATE (self);
#line 3341 "spice-display.c"
}


static void boxes_spice_display_finalize (GObject* obj) {
	BoxesSpiceDisplay * self;
#line 5 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, BOXES_TYPE_SPICE_DISPLAY, BoxesSpiceDisplay);
#line 91 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	boxes_spice_display_main_cleanup (self);
#line 12 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	_g_object_unref0 (self->priv->session);
#line 17 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	self->priv->display_sync_properties = (_vala_BoxesBoxConfigSyncProperty_array_free (self->priv->display_sync_properties, self->priv->display_sync_properties_length1), NULL);
#line 18 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	self->priv->gtk_session_sync_properties = (_vala_BoxesBoxConfigSyncProperty_array_free (self->priv->gtk_session_sync_properties, self->priv->gtk_session_sync_properties_length1), NULL);
#line 74 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	_g_object_unref0 (self->priv->main_channel);
#line 5 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	G_OBJECT_CLASS (boxes_spice_display_parent_class)->finalize (obj);
#line 3361 "spice-display.c"
}


GType boxes_spice_display_get_type (void) {
	static volatile gsize boxes_spice_display_type_id__volatile = 0;
	if (g_once_init_enter (&boxes_spice_display_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (BoxesSpiceDisplayClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) boxes_spice_display_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (BoxesSpiceDisplay), 0, (GInstanceInitFunc) boxes_spice_display_instance_init, NULL };
		GType boxes_spice_display_type_id;
		boxes_spice_display_type_id = g_type_register_static (BOXES_TYPE_DISPLAY, "BoxesSpiceDisplay", &g_define_type_info, 0);
		g_once_init_leave (&boxes_spice_display_type_id__volatile, boxes_spice_display_type_id);
	}
	return boxes_spice_display_type_id__volatile;
}


static void _vala_boxes_spice_display_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	BoxesSpiceDisplay * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, BOXES_TYPE_SPICE_DISPLAY, BoxesSpiceDisplay);
#line 5 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	switch (property_id) {
#line 5 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
		case BOXES_SPICE_DISPLAY_PROTOCOL:
#line 5 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
		g_value_set_string (value, boxes_display_get_protocol ((BoxesDisplay*) self));
#line 5 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
		break;
#line 5 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
		case BOXES_SPICE_DISPLAY_URI:
#line 5 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
		g_value_take_string (value, boxes_display_get_uri ((BoxesDisplay*) self));
#line 5 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
		break;
#line 5 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
		case BOXES_SPICE_DISPLAY_CA_CERT:
#line 5 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
		g_value_take_boxed (value, boxes_spice_display_get_ca_cert (self));
#line 5 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
		break;
#line 5 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
		case BOXES_SPICE_DISPLAY_RESIZE_GUEST:
#line 5 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
		g_value_set_boolean (value, boxes_spice_display_get_resize_guest (self));
#line 5 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
		break;
#line 3406 "spice-display.c"
		default:
#line 5 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 5 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
		break;
#line 3412 "spice-display.c"
	}
}


static void _vala_boxes_spice_display_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	BoxesSpiceDisplay * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, BOXES_TYPE_SPICE_DISPLAY, BoxesSpiceDisplay);
#line 5 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	switch (property_id) {
#line 5 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
		case BOXES_SPICE_DISPLAY_CA_CERT:
#line 5 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
		boxes_spice_display_set_ca_cert (self, g_value_get_boxed (value));
#line 5 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
		break;
#line 5 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
		case BOXES_SPICE_DISPLAY_RESIZE_GUEST:
#line 5 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
		boxes_spice_display_set_resize_guest (self, g_value_get_boolean (value));
#line 5 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
		break;
#line 3434 "spice-display.c"
		default:
#line 5 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 5 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
		break;
#line 3440 "spice-display.c"
	}
}


static gint* _int_dup (gint* self) {
	gint* dup;
#line 390 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	dup = g_new0 (gint, 1);
#line 390 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	memcpy (dup, self, sizeof (gint));
#line 390 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	return dup;
#line 3453 "spice-display.c"
}


static gpointer __int_dup0 (gpointer self) {
#line 390 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	return self ? _int_dup (self) : NULL;
#line 3460 "spice-display.c"
}


void spice_validate_uri (const gchar* uri_as_text, gint** port, gint** tls_port, GError** error) {
	gint* _vala_port = NULL;
	gint* _vala_tls_port = NULL;
	xmlURI* uri = NULL;
	const gchar* _tmp0_ = NULL;
	xmlURI* _tmp1_ = NULL;
	xmlURI* _tmp2_ = NULL;
	gint _tmp5_ = 0;
	gint* _tmp6_ = NULL;
	xmlURI* _tmp7_ = NULL;
	gint _tmp8_ = 0;
	gint* _tmp9_ = NULL;
	const gchar* _tmp10_ = NULL;
	xmlURI* _tmp11_ = NULL;
	const gchar* _tmp12_ = NULL;
	gchar* query_str = NULL;
	gchar* _tmp15_ = NULL;
	const gchar* _tmp16_ = NULL;
	gboolean _tmp40_ = FALSE;
	gint* _tmp41_ = NULL;
	GError * _inner_error_ = NULL;
#line 382 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	g_return_if_fail (uri_as_text != NULL);
#line 385 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	_tmp0_ = uri_as_text;
#line 385 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	_tmp1_ = xmlParseURI (_tmp0_);
#line 385 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	uri = _tmp1_;
#line 387 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	_tmp2_ = uri;
#line 387 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	if (_tmp2_ == NULL) {
#line 3497 "spice-display.c"
		const gchar* _tmp3_ = NULL;
		GError* _tmp4_ = NULL;
#line 388 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
		_tmp3_ = _ ("Invalid URI");
#line 388 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
		_tmp4_ = g_error_new_literal (BOXES_ERROR, BOXES_ERROR_INVALID, _tmp3_);
#line 388 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
		_inner_error_ = _tmp4_;
#line 388 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
		if (_inner_error_->domain == BOXES_ERROR) {
#line 388 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
			g_propagate_error (error, _inner_error_);
#line 388 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
			_xmlFreeURI0 (uri);
#line 388 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
			return;
#line 3514 "spice-display.c"
		} else {
#line 388 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
			_xmlFreeURI0 (uri);
#line 388 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 388 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
			g_clear_error (&_inner_error_);
#line 388 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
			return;
#line 3524 "spice-display.c"
		}
	}
#line 390 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	_tmp5_ = 0;
#line 390 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	_tmp6_ = __int_dup0 (&_tmp5_);
#line 390 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	_g_free0 (_vala_tls_port);
#line 390 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	_vala_tls_port = _tmp6_;
#line 391 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	_tmp7_ = uri;
#line 391 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	_tmp8_ = _tmp7_->port;
#line 391 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	_tmp9_ = __int_dup0 (&_tmp8_);
#line 391 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	_g_free0 (_vala_port);
#line 391 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	_vala_port = _tmp9_;
#line 392 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	_tmp11_ = uri;
#line 392 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	_tmp12_ = _tmp11_->query_raw;
#line 392 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	_tmp10_ = _tmp12_;
#line 392 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	if (_tmp10_ == NULL) {
#line 3553 "spice-display.c"
		xmlURI* _tmp13_ = NULL;
		const gchar* _tmp14_ = NULL;
#line 392 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
		_tmp13_ = uri;
#line 392 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
		_tmp14_ = _tmp13_->query;
#line 392 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
		_tmp10_ = _tmp14_;
#line 3562 "spice-display.c"
	}
#line 392 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	_tmp15_ = g_strdup (_tmp10_);
#line 392 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	query_str = _tmp15_;
#line 394 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	_tmp16_ = query_str;
#line 394 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	if (_tmp16_ != NULL) {
#line 3572 "spice-display.c"
		BoxesQuery* query = NULL;
		const gchar* _tmp17_ = NULL;
		BoxesQuery* _tmp18_ = NULL;
		BoxesQuery* _tmp19_ = NULL;
		gchar* _tmp20_ = NULL;
		gchar* _tmp21_ = NULL;
		gboolean _tmp22_ = FALSE;
		BoxesQuery* _tmp31_ = NULL;
		gchar* _tmp32_ = NULL;
		gchar* _tmp33_ = NULL;
		gboolean _tmp34_ = FALSE;
#line 395 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
		_tmp17_ = query_str;
#line 395 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
		_tmp18_ = boxes_query_new (_tmp17_);
#line 395 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
		query = _tmp18_;
#line 396 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
		_tmp19_ = query;
#line 396 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
		_tmp20_ = boxes_query_get (_tmp19_, "port");
#line 396 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
		_tmp21_ = _tmp20_;
#line 396 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
		_tmp22_ = _tmp21_ != NULL;
#line 396 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
		_g_free0 (_tmp21_);
#line 396 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
		if (_tmp22_) {
#line 3602 "spice-display.c"
			gint* _tmp23_ = NULL;
			BoxesQuery* _tmp26_ = NULL;
			gchar* _tmp27_ = NULL;
			gchar* _tmp28_ = NULL;
			gint _tmp29_ = 0;
			gint* _tmp30_ = NULL;
#line 397 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
			_tmp23_ = _vala_port;
#line 397 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
			if ((*_tmp23_) > 0) {
#line 3613 "spice-display.c"
				const gchar* _tmp24_ = NULL;
				GError* _tmp25_ = NULL;
#line 398 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
				_tmp24_ = _ ("The port must be specified once");
#line 398 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
				_tmp25_ = g_error_new_literal (BOXES_ERROR, BOXES_ERROR_INVALID, _tmp24_);
#line 398 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
				_inner_error_ = _tmp25_;
#line 398 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
				if (_inner_error_->domain == BOXES_ERROR) {
#line 398 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
					g_propagate_error (error, _inner_error_);
#line 398 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
					_g_object_unref0 (query);
#line 398 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
					_g_free0 (query_str);
#line 398 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
					_xmlFreeURI0 (uri);
#line 398 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
					return;
#line 3634 "spice-display.c"
				} else {
#line 398 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
					_g_object_unref0 (query);
#line 398 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
					_g_free0 (query_str);
#line 398 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
					_xmlFreeURI0 (uri);
#line 398 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 398 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
					g_clear_error (&_inner_error_);
#line 398 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
					return;
#line 3648 "spice-display.c"
				}
			}
#line 399 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
			_tmp26_ = query;
#line 399 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
			_tmp27_ = boxes_query_get (_tmp26_, "port");
#line 399 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
			_tmp28_ = _tmp27_;
#line 399 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
			_tmp29_ = atoi (_tmp28_);
#line 399 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
			_tmp30_ = __int_dup0 (&_tmp29_);
#line 399 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
			_g_free0 (_vala_port);
#line 399 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
			_vala_port = _tmp30_;
#line 399 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
			_g_free0 (_tmp28_);
#line 3667 "spice-display.c"
		}
#line 402 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
		_tmp31_ = query;
#line 402 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
		_tmp32_ = boxes_query_get (_tmp31_, "tls-port");
#line 402 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
		_tmp33_ = _tmp32_;
#line 402 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
		_tmp34_ = _tmp33_ != NULL;
#line 402 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
		_g_free0 (_tmp33_);
#line 402 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
		if (_tmp34_) {
#line 3681 "spice-display.c"
			BoxesQuery* _tmp35_ = NULL;
			gchar* _tmp36_ = NULL;
			gchar* _tmp37_ = NULL;
			gint _tmp38_ = 0;
			gint* _tmp39_ = NULL;
#line 403 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
			_tmp35_ = query;
#line 403 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
			_tmp36_ = boxes_query_get (_tmp35_, "tls-port");
#line 403 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
			_tmp37_ = _tmp36_;
#line 403 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
			_tmp38_ = atoi (_tmp37_);
#line 403 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
			_tmp39_ = __int_dup0 (&_tmp38_);
#line 403 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
			_g_free0 (_vala_tls_port);
#line 403 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
			_vala_tls_port = _tmp39_;
#line 403 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
			_g_free0 (_tmp37_);
#line 3703 "spice-display.c"
		}
#line 394 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
		_g_object_unref0 (query);
#line 3707 "spice-display.c"
	}
#line 406 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	_tmp41_ = _vala_port;
#line 406 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	if ((*_tmp41_) <= 0) {
#line 3713 "spice-display.c"
		gint* _tmp42_ = NULL;
#line 406 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
		_tmp42_ = _vala_tls_port;
#line 406 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
		_tmp40_ = (*_tmp42_) <= 0;
#line 3719 "spice-display.c"
	} else {
#line 406 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
		_tmp40_ = FALSE;
#line 3723 "spice-display.c"
	}
#line 406 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	if (_tmp40_) {
#line 3727 "spice-display.c"
		const gchar* _tmp43_ = NULL;
		GError* _tmp44_ = NULL;
#line 407 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
		_tmp43_ = _ ("Missing port in Spice URI");
#line 407 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
		_tmp44_ = g_error_new_literal (BOXES_ERROR, BOXES_ERROR_INVALID, _tmp43_);
#line 407 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
		_inner_error_ = _tmp44_;
#line 407 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
		if (_inner_error_->domain == BOXES_ERROR) {
#line 407 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
			g_propagate_error (error, _inner_error_);
#line 407 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
			_g_free0 (query_str);
#line 407 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
			_xmlFreeURI0 (uri);
#line 407 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
			return;
#line 3746 "spice-display.c"
		} else {
#line 407 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
			_g_free0 (query_str);
#line 407 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
			_xmlFreeURI0 (uri);
#line 407 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 407 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
			g_clear_error (&_inner_error_);
#line 407 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
			return;
#line 3758 "spice-display.c"
		}
	}
#line 382 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	_g_free0 (query_str);
#line 382 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	_xmlFreeURI0 (uri);
#line 382 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	if (port) {
#line 382 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
		*port = _vala_port;
#line 3769 "spice-display.c"
	} else {
#line 382 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
		_g_free0 (_vala_port);
#line 3773 "spice-display.c"
	}
#line 382 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	if (tls_port) {
#line 382 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
		*tls_port = _vala_tls_port;
#line 3779 "spice-display.c"
	} else {
#line 382 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
		_g_free0 (_vala_tls_port);
#line 3783 "spice-display.c"
	}
}



