/* util-app.c generated by valac 0.39.5, the Vala compiler
 * generated from util-app.vala, do not modify */

/* This file is part of GNOME Boxes. License: LGPLv2+*/

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <gtk/gtk.h>
#include <gio/gio.h>
#include <gdk-pixbuf/gdk-pixbuf.h>
#include <gdk/gdk.h>
#include <libcommon.h>
#include <libxml/parser.h>
#include <libxml/tree.h>
#include <libxml/xpath.h>
#include <osinfo/osinfo.h>
#include <libvirt-gobject/libvirt-gobject.h>
#include <libvirt-gconfig/libvirt-gconfig.h>
#include <config.h>
#include <sys/socket.h>
#include <errno.h>
#include <netinet/in.h>
#include <linux/if.h>
#include <sys/ioctl.h>
#include <glib/gi18n-lib.h>
#include <glib/gstdio.h>
#include <unistd.h>
#include <cairo.h>
#include <float.h>
#include <math.h>
#include <libgd/gd.h>

#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _xmlFreeParserCtxt0(var) ((var == NULL) ? NULL : (var = (xmlFreeParserCtxt (var), NULL)))
#define _xmlXPathFreeContext0(var) ((var == NULL) ? NULL : (var = (xmlXPathFreeContext (var), NULL)))
#define __vala_GVirStoragePoolInfo_free0(var) ((var == NULL) ? NULL : (var = (_vala_GVirStoragePoolInfo_free (var), NULL)))
typedef struct _BoxesEnsureStoragePoolData BoxesEnsureStoragePoolData;
typedef struct _BoxesGetSystemVirtConnectionData BoxesGetSystemVirtConnectionData;
typedef struct _BoxesCheckSelinuxContextDefaultData BoxesCheckSelinuxContextDefaultData;
typedef struct _BoxesCheckLibvirtKvmData BoxesCheckLibvirtKvmData;
typedef struct _BoxesCheckCpuVtCapabilityData BoxesCheckCpuVtCapabilityData;
typedef struct _BoxesCheckModuleKvmLoadedData BoxesCheckModuleKvmLoadedData;
typedef struct _BoxesCheckStoragePoolData BoxesCheckStoragePoolData;
typedef struct _Block84Data Block84Data;

#define BOXES_TYPE_CPU_ARCH_COMPATIBILITY (boxes_cpu_arch_compatibility_get_type ())

#define BOXES_FDO_TYPE_TIMEDATE1 (boxes_fdo_timedate1_get_type ())
#define BOXES_FDO_TIMEDATE1(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), BOXES_FDO_TYPE_TIMEDATE1, BoxesFdotimedate1))
#define BOXES_FDO_IS_TIMEDATE1(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), BOXES_FDO_TYPE_TIMEDATE1))
#define BOXES_FDO_TIMEDATE1_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), BOXES_FDO_TYPE_TIMEDATE1, BoxesFdotimedate1Iface))

typedef struct _BoxesFdotimedate1 BoxesFdotimedate1;
typedef struct _BoxesFdotimedate1Iface BoxesFdotimedate1Iface;

#define BOXES_FDO_TYPE_TIMEDATE1_PROXY (boxes_fdo_timedate1_proxy_get_type ())
typedef GDBusProxy BoxesFdotimedate1Proxy;
typedef GDBusProxyClass BoxesFdotimedate1ProxyClass;
typedef struct _BoxesMoveConfigsFromCacheData BoxesMoveConfigsFromCacheData;
#define __g_list_free__g_object_unref0_0(var) ((var == NULL) ? NULL : (var = (_g_list_free__g_object_unref0_ (var), NULL)))
typedef struct _BoxesMoveConfigFromCacheData BoxesMoveConfigFromCacheData;
#define _cairo_destroy0(var) ((var == NULL) ? NULL : (var = (cairo_destroy (var), NULL)))
#define _cairo_surface_destroy0(var) ((var == NULL) ? NULL : (var = (cairo_surface_destroy (var), NULL)))

struct _BoxesEnsureStoragePoolData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	GAsyncReadyCallback _callback_;
	gboolean _task_complete_;
	GVirConnection* connection;
	GVirStoragePool* result;
	GVirStoragePool* pool;
	GVirStoragePool* _tmp0_;
	GVirStoragePool* _tmp1_;
	GVirConfigStoragePool* config;
	GVirConfigStoragePool* _tmp2_;
	GVirStoragePool* _tmp3_;
	GVirConfigStoragePool* _tmp4_;
	GVirStoragePool* _tmp5_;
	GVirStoragePool* _tmp6_;
	GVirStoragePool* _tmp7_;
	gchar* pool_path;
	gchar* _tmp8_;
	const gchar* _tmp9_;
	GVirStoragePoolInfo* _tmp10_;
	GVirStoragePool* _tmp11_;
	GVirStoragePoolInfo* _tmp12_;
	GVirStoragePoolState _tmp13_;
	GVirStoragePool* _tmp14_;
	GVirStoragePool* _tmp15_;
	GVirStoragePool* _tmp16_;
	GError * _inner_error_;
};

struct _BoxesGetSystemVirtConnectionData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	GAsyncReadyCallback _callback_;
	gboolean _task_complete_;
	GVirConnection* result;
	GVirConnection* _tmp0_;
	GVirConnection* _tmp1_;
	GVirConnection* _tmp2_;
	GVirConnection* _tmp3_;
	GVirConnection* _tmp4_;
	GVirConnection* _tmp5_;
	GVirConnection* _tmp6_;
	GVirConnection* _tmp7_;
	GVirConnection* _tmp8_;
	GError * _inner_error_;
};

struct _BoxesCheckSelinuxContextDefaultData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	GAsyncReadyCallback _callback_;
	gboolean _task_complete_;
	gchar* diagnosis;
	gboolean result;
	gchar* _tmp0_;
	gchar* standard_output;
	gchar** argv;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gchar** _tmp6_;
	gint argv_length1;
	gint _argv_size_;
	gchar** _tmp7_;
	gint _tmp7__length1;
	gchar* _tmp8_;
	const gchar* _tmp9_;
	gint _tmp10_;
	gint _tmp11_;
	gchar** _tmp12_;
	gint _tmp12__length1;
	gchar* _tmp13_;
	gchar* _tmp14_;
	gchar** _tmp15_;
	gint _tmp15__length1;
	gchar* _tmp16_;
	gchar* _tmp17_;
	gchar* _tmp18_;
	GError* _error_;
	gchar* _tmp19_;
	GError* _vala1__error_;
	GError* _tmp20_;
	const gchar* _tmp21_;
	GError * _inner_error_;
};

struct _BoxesCheckLibvirtKvmData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	GAsyncReadyCallback _callback_;
	gboolean _task_complete_;
	gboolean result;
	gchar* standard_output;
	gchar** argv;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar** _tmp2_;
	gint argv_length1;
	gint _argv_size_;
	gchar** _tmp3_;
	gint _tmp3__length1;
	gchar* _tmp4_;
	gchar* kvm;
	const gchar* _tmp5_;
	gchar* _tmp6_;
	const gchar* _tmp7_;
	gint _tmp8_;
	gint _tmp9_;
	GError* _error_;
	GError* _vala1__error_;
	GError* _tmp10_;
	const gchar* _tmp11_;
	GError * _inner_error_;
};

struct _BoxesCheckCpuVtCapabilityData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	GAsyncReadyCallback _callback_;
	gboolean _task_complete_;
	gboolean result;
	gboolean _result_;
	GFile* file;
	GFile* _tmp0_;
	GFileInputStream* _tmp1_;
	GFile* _tmp2_;
	GFileInputStream* _tmp3_;
	GDataInputStream* stream;
	GDataInputStream* _tmp4_;
	gchar* line;
	gchar* _tmp5_;
	GDataInputStream* _tmp6_;
	gchar* _tmp7_;
	gchar* _tmp8_;
	const gchar* _tmp9_;
	const gchar* _tmp10_;
	gboolean _tmp11_;
	gboolean _tmp12_;
	GError* _error_;
	GError* _tmp13_;
	const gchar* _tmp14_;
	gboolean _tmp15_;
	gchar* _tmp16_;
	gchar* _tmp17_;
	gchar* _tmp18_;
	gchar* _tmp19_;
	GError * _inner_error_;
};

struct _BoxesCheckModuleKvmLoadedData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	GAsyncReadyCallback _callback_;
	gboolean _task_complete_;
	gboolean result;
	gboolean _result_;
	GFile* file;
	GFile* _tmp0_;
	GFileInputStream* _tmp1_;
	GFile* _tmp2_;
	GFileInputStream* _tmp3_;
	GDataInputStream* stream;
	GDataInputStream* _tmp4_;
	gchar* line;
	gchar* _tmp5_;
	GDataInputStream* _tmp6_;
	gchar* _tmp7_;
	gchar* _tmp8_;
	const gchar* _tmp9_;
	const gchar* _tmp10_;
	gboolean _tmp11_;
	gboolean _tmp12_;
	GError* _error_;
	GError* _tmp13_;
	const gchar* _tmp14_;
	gboolean _tmp15_;
	gchar* _tmp16_;
	gchar* _tmp17_;
	gchar* _tmp18_;
	gchar* _tmp19_;
	GError * _inner_error_;
};

struct _BoxesCheckStoragePoolData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	GAsyncReadyCallback _callback_;
	gboolean _task_complete_;
	gchar* diagnosis;
	gboolean result;
	gchar* pool_path;
	gchar* _tmp0_;
	gchar* standard_output;
	gchar** argv;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar** _tmp4_;
	gint argv_length1;
	gint _argv_size_;
	gchar** _tmp5_;
	gint _tmp5__length1;
	gchar* _tmp6_;
	gchar* _tmp7_;
	const gchar* _tmp8_;
	gchar* _tmp9_;
	gchar* _tmp10_;
	GError* _error_;
	GError* _tmp11_;
	const gchar* _tmp12_;
	gchar* _tmp13_;
	const gchar* _tmp14_;
	const gchar* _tmp15_;
	gchar* _tmp16_;
	const gchar* _tmp17_;
	const gchar* _tmp18_;
	gchar* _tmp19_;
	const gchar* _tmp20_;
	const gchar* _tmp21_;
	gchar* _tmp22_;
	GError * _inner_error_;
};

struct _Block84Data {
	int _ref_count_;
	GtkWidget* widget;
};

typedef enum  {
	BOXES_CPU_ARCH_COMPATIBILITY_INCOMPATIBLE = -1,
	BOXES_CPU_ARCH_COMPATIBILITY_IDENTICAL = 0,
	BOXES_CPU_ARCH_COMPATIBILITY_COMPATIBLE = 1,
	BOXES_CPU_ARCH_COMPATIBILITY_COMPATIBLE_DIFF_WORDSIZE = 2
} BoxesCPUArchCompatibility;

struct _BoxesFdotimedate1Iface {
	GTypeInterface parent_iface;
	gchar* (*get_timezone) (BoxesFdotimedate1* self);
	void (*set_timezone) (BoxesFdotimedate1* self, const gchar* value);
};

struct _BoxesMoveConfigsFromCacheData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	GAsyncReadyCallback _callback_;
	gboolean _task_complete_;
};

struct _BoxesMoveConfigFromCacheData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	GAsyncReadyCallback _callback_;
	gboolean _task_complete_;
	gchar* config_name;
	gchar* path;
	gchar* _tmp0_;
	GFile* cache_dir;
	const gchar* _tmp1_;
	GFile* _tmp2_;
	gchar* config_path;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	GFileEnumerator* enumerator;
	GFile* _tmp7_;
	GFileEnumerator* _tmp8_;
	GList* files;
	GFileEnumerator* _tmp9_;
	GList* _tmp10_;
	GList* _tmp11_;
	GList* _tmp12_;
	GList* info_collection;
	GList* info_it;
	GFileInfo* _tmp13_;
	GFileInfo* info;
	GFile* _tmp14_;
	gchar* _tmp15_;
	gchar* _tmp16_;
	GFileInfo* _tmp17_;
	const gchar* _tmp18_;
	gchar* _tmp19_;
	GFile* cache_file;
	const gchar* _tmp20_;
	GFile* _tmp21_;
	const gchar* _tmp22_;
	GFileInfo* _tmp23_;
	const gchar* _tmp24_;
	gchar* _tmp25_;
	GFile* config_file;
	const gchar* _tmp26_;
	GFile* _tmp27_;
	GFile* _tmp28_;
	GFile* _tmp29_;
	GFile* _tmp30_;
	gchar* _tmp31_;
	gchar* _tmp32_;
	GFile* _tmp33_;
	gchar* _tmp34_;
	gchar* _tmp35_;
	GFile* _tmp36_;
	GError* _error_;
	GError* _vala1__error_;
	GError* _tmp37_;
	const gchar* _tmp38_;
	GError * _inner_error_;
};


extern gboolean boxes_libvirt_bridge_net_checked;
gboolean boxes_libvirt_bridge_net_checked = FALSE;
extern gboolean boxes_libvirt_bridge_net_available;
gboolean boxes_libvirt_bridge_net_available = FALSE;
extern GVirConnection* boxes_system_virt_connection;
GVirConnection* boxes_system_virt_connection = NULL;

GtkCssProvider* boxes_load_css (const gchar* css);
GdkPixbuf* boxes_load_asset (const gchar* asset,
                             GError** error);
GtkBuilder* boxes_load_ui (const gchar* ui);
void boxes_get_color (const gchar* desc,
                      GdkRGBA* result);
gchar* boxes_extract_xpath (const gchar* xmldoc,
                            const gchar* xpath,
                            gboolean required,
                            GError** error);
void boxes_widget_remove (GtkWidget* widget);
OsinfoDevice* boxes_find_device_by_prop (OsinfoDeviceList* devices,
                                         const gchar* prop_name,
                                         const gchar* prop_value);
GtkImage* boxes_get_os_logo (OsinfoOs* os,
                             gint size);
void boxes_fetch_os_logo (GtkImage* image,
                          OsinfoOs* os,
                          gint size);
gchar* boxes_get_logo_path (OsinfoOs* os,
                            gchar** extensions,
                            int extensions_length1);
static void boxes_ensure_storage_pool_data_free (gpointer _data);
static void boxes_ensure_storage_pool_async_ready_wrapper (GObject *source_object,
                                                    GAsyncResult *res,
                                                    void *user_data);
void boxes_ensure_storage_pool (GVirConnection* connection,
                                GAsyncReadyCallback _callback_,
                                gpointer _user_data_);
GVirStoragePool* boxes_ensure_storage_pool_finish (GAsyncResult* _res_,
                                                   GError** error);
static gboolean boxes_ensure_storage_pool_co (BoxesEnsureStoragePoolData* _data_);
GVirStoragePool* boxes_get_storage_pool (GVirConnection* connection);
GVirConfigStoragePool* boxes_vm_configurator_get_pool_config (GError** error);
static void boxes_ensure_storage_pool_ready (GObject* source_object,
                                      GAsyncResult* _res_,
                                      gpointer _user_data_);
static void _vala_GVirStoragePoolInfo_free (GVirStoragePoolInfo* self);
GVirStorageVol* boxes_get_storage_volume (GVirConnection* connection,
                                          GVirDomain* domain);
gboolean boxes_is_libvirt_bridge_net_available (void);
static void boxes_get_system_virt_connection_data_free (gpointer _data);
static void boxes_get_system_virt_connection_async_ready_wrapper (GObject *source_object,
                                                           GAsyncResult *res,
                                                           void *user_data);
void boxes_get_system_virt_connection (GAsyncReadyCallback _callback_,
                                       gpointer _user_data_);
GVirConnection* boxes_get_system_virt_connection_finish (GAsyncResult* _res_,
                                                         GError** error);
static gboolean boxes_get_system_virt_connection_co (BoxesGetSystemVirtConnectionData* _data_);
static void boxes_get_system_virt_connection_ready (GObject* source_object,
                                             GAsyncResult* _res_,
                                             gpointer _user_data_);
static void boxes_check_selinux_context_default_data_free (gpointer _data);
static void boxes_check_selinux_context_default_async_ready_wrapper (GObject *source_object,
                                                              GAsyncResult *res,
                                                              void *user_data);
void boxes_check_selinux_context_default (GAsyncReadyCallback _callback_,
                                          gpointer _user_data_);
gboolean boxes_check_selinux_context_default_finish (GAsyncResult* _res_,
                                                     gchar* * diagnosis);
static gboolean boxes_check_selinux_context_default_co (BoxesCheckSelinuxContextDefaultData* _data_);
static void boxes_check_selinux_context_default_ready (GObject* source_object,
                                                GAsyncResult* _res_,
                                                gpointer _user_data_);
static void boxes_check_libvirt_kvm_data_free (gpointer _data);
static void boxes_check_libvirt_kvm_async_ready_wrapper (GObject *source_object,
                                                  GAsyncResult *res,
                                                  void *user_data);
void boxes_check_libvirt_kvm (GAsyncReadyCallback _callback_,
                              gpointer _user_data_);
gboolean boxes_check_libvirt_kvm_finish (GAsyncResult* _res_);
static gboolean boxes_check_libvirt_kvm_co (BoxesCheckLibvirtKvmData* _data_);
static void boxes_check_libvirt_kvm_ready (GObject* source_object,
                                    GAsyncResult* _res_,
                                    gpointer _user_data_);
static void boxes_check_cpu_vt_capability_data_free (gpointer _data);
static void boxes_check_cpu_vt_capability_async_ready_wrapper (GObject *source_object,
                                                        GAsyncResult *res,
                                                        void *user_data);
void boxes_check_cpu_vt_capability (GAsyncReadyCallback _callback_,
                                    gpointer _user_data_);
gboolean boxes_check_cpu_vt_capability_finish (GAsyncResult* _res_);
static gboolean boxes_check_cpu_vt_capability_co (BoxesCheckCpuVtCapabilityData* _data_);
static void boxes_check_cpu_vt_capability_ready (GObject* source_object,
                                          GAsyncResult* _res_,
                                          gpointer _user_data_);
static void boxes_check_module_kvm_loaded_data_free (gpointer _data);
static void boxes_check_module_kvm_loaded_async_ready_wrapper (GObject *source_object,
                                                        GAsyncResult *res,
                                                        void *user_data);
void boxes_check_module_kvm_loaded (GAsyncReadyCallback _callback_,
                                    gpointer _user_data_);
gboolean boxes_check_module_kvm_loaded_finish (GAsyncResult* _res_);
static gboolean boxes_check_module_kvm_loaded_co (BoxesCheckModuleKvmLoadedData* _data_);
static void boxes_check_module_kvm_loaded_ready (GObject* source_object,
                                          GAsyncResult* _res_,
                                          gpointer _user_data_);
static void boxes_check_storage_pool_data_free (gpointer _data);
static void boxes_check_storage_pool_async_ready_wrapper (GObject *source_object,
                                                   GAsyncResult *res,
                                                   void *user_data);
void boxes_check_storage_pool (GAsyncReadyCallback _callback_,
                               gpointer _user_data_);
gboolean boxes_check_storage_pool_finish (GAsyncResult* _res_,
                                          gchar* * diagnosis);
static gboolean boxes_check_storage_pool_co (BoxesCheckStoragePoolData* _data_);
static void boxes_check_storage_pool_ready (GObject* source_object,
                                     GAsyncResult* _res_,
                                     gpointer _user_data_);
GdkPixbuf* boxes_remove_alpha (GdkPixbuf* pixbuf);
static guint8* _vala_array_dup5 (guint8* self,
                          int length);
void boxes_draw_as_css_box (GtkWidget* widget);
static Block84Data* block84_data_ref (Block84Data* _data84_);
static void block84_data_unref (void * _userdata_);
static gboolean __lambda135_ (Block84Data* _data84_,
                       cairo_t* cr);
static gboolean ___lambda135__gtk_widget_draw (GtkWidget* _sender,
                                        cairo_t* cr,
                                        gpointer self);
GType boxes_cpu_arch_compatibility_get_type (void) G_GNUC_CONST;
BoxesCPUArchCompatibility boxes_compare_cpu_architectures (const gchar* arch1,
                                                           const gchar* arch2);
GType boxes_fdo_timedate1_get_type (void) G_GNUC_CONST;
GType boxes_fdo_timedate1_proxy_get_type (void) G_GNUC_CONST;
guint boxes_fdo_timedate1_register_object (void* object,
                                           GDBusConnection* connection,
                                           const gchar* path,
                                           GError** error);
gchar* boxes_fdo_timedate1_get_timezone (BoxesFdotimedate1* self);
void boxes_fdo_timedate1_set_timezone (BoxesFdotimedate1* self,
                                       const gchar* value);
static void boxes_fdo_timedate1_proxy_g_signal (GDBusProxy* proxy,
                                         const gchar* sender_name,
                                         const gchar* signal_name,
                                         GVariant* parameters);
static gchar* boxes_fdo_timedate1_dbus_proxy_get_timezone (BoxesFdotimedate1* self);
static void boxes_fdo_timedate1_dbus_proxy_set_timezone (BoxesFdotimedate1* self,
                                                  const gchar* value);
static void boxes_fdo_timedate1_proxy_boxes_fdo_timedate1_interface_init (BoxesFdotimedate1Iface* iface);
static void boxes_fdo_timedate1_dbus_interface_method_call (GDBusConnection* connection,
                                                     const gchar* sender,
                                                     const gchar* object_path,
                                                     const gchar* interface_name,
                                                     const gchar* method_name,
                                                     GVariant* parameters,
                                                     GDBusMethodInvocation* invocation,
                                                     gpointer user_data);
static GVariant* boxes_fdo_timedate1_dbus_interface_get_property (GDBusConnection* connection,
                                                           const gchar* sender,
                                                           const gchar* object_path,
                                                           const gchar* interface_name,
                                                           const gchar* property_name,
                                                           GError** error,
                                                           gpointer user_data);
static GVariant* _dbus_boxes_fdo_timedate1_get_timezone (BoxesFdotimedate1* self);
static gboolean boxes_fdo_timedate1_dbus_interface_set_property (GDBusConnection* connection,
                                                          const gchar* sender,
                                                          const gchar* object_path,
                                                          const gchar* interface_name,
                                                          const gchar* property_name,
                                                          GVariant* value,
                                                          GError** error,
                                                          gpointer user_data);
static void _dbus_boxes_fdo_timedate1_set_timezone (BoxesFdotimedate1* self,
                                             GVariant* _value);
static void _boxes_fdo_timedate1_unregister_object (gpointer user_data);
gchar* boxes_get_timezone (void);
gchar* boxes_get_timezone_from_systemd (GError** error);
gchar* boxes_get_timezone_from_linux (GError** error);
#define BOXES_TZ_FILE "/etc/localtime"
static void boxes_move_configs_from_cache_data_free (gpointer _data);
static void boxes_move_configs_from_cache_async_ready_wrapper (GObject *source_object,
                                                        GAsyncResult *res,
                                                        void *user_data);
void boxes_move_configs_from_cache (GAsyncReadyCallback _callback_,
                                    gpointer _user_data_);
void boxes_move_configs_from_cache_finish (GAsyncResult* _res_);
static gboolean boxes_move_configs_from_cache_co (BoxesMoveConfigsFromCacheData* _data_);
void boxes_move_config_from_cache (const gchar* config_name,
                                   GAsyncReadyCallback _callback_,
                                   gpointer _user_data_);
void boxes_move_config_from_cache_finish (GAsyncResult* _res_);
static void boxes_move_configs_from_cache_ready (GObject* source_object,
                                          GAsyncResult* _res_,
                                          gpointer _user_data_);
static void boxes_move_config_from_cache_data_free (gpointer _data);
static void boxes_move_config_from_cache_async_ready_wrapper (GObject *source_object,
                                                       GAsyncResult *res,
                                                       void *user_data);
static gboolean boxes_move_config_from_cache_co (BoxesMoveConfigFromCacheData* _data_);
static void boxes_move_config_from_cache_ready (GObject* source_object,
                                         GAsyncResult* _res_,
                                         gpointer _user_data_);
static void _g_object_unref0_ (gpointer var);
static inline void _g_list_free__g_object_unref0_ (GList* self);
void uuid_generate (guchar* uuid);
void uuid_unparse (guchar* uuid,
                   guchar* output);
gchar* boxes_uuid_generate (void);
GIcon* boxes_create_symbolic_emblem (const gchar* name);
GdkPixbuf* boxes_paint_empty_frame (gint width,
                                    gint height,
                                    gdouble radius,
                                    GdkRGBA* border_color,
                                    GdkRGBA* bg_color);
void boxes_paint_frame_background (cairo_t* cr,
                                   gint width,
                                   gint height,
                                   gdouble radius);
void boxes_paint_frame_border (cairo_t* cr,
                               gint width,
                               gint height,
                               gdouble radius);
void boxes_rounded_rectangle (cairo_t* cr,
                              gdouble x,
                              gdouble y,
                              gdouble width,
                              gdouble height,
                              gdouble radius);
static void _vala_array_destroy (gpointer array,
                          gint array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gint array_length,
                       GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);

static GRegex* _tmp_regex_0 = NULL;
static GRegex* _tmp_regex_1 = NULL;
static const GDBusMethodInfo * const _boxes_fdo_timedate1_dbus_method_info[] = {NULL};
static const GDBusSignalInfo * const _boxes_fdo_timedate1_dbus_signal_info[] = {NULL};
static const GDBusPropertyInfo _boxes_fdo_timedate1_dbus_property_info_timezone = {-1, "Timezone", "s", G_DBUS_PROPERTY_INFO_FLAGS_READABLE | G_DBUS_PROPERTY_INFO_FLAGS_WRITABLE};
static const GDBusPropertyInfo * const _boxes_fdo_timedate1_dbus_property_info[] = {&_boxes_fdo_timedate1_dbus_property_info_timezone, NULL};
static const GDBusInterfaceInfo _boxes_fdo_timedate1_dbus_interface_info = {-1, "org.freedesktop.timedate1", (GDBusMethodInfo **) (&_boxes_fdo_timedate1_dbus_method_info), (GDBusSignalInfo **) (&_boxes_fdo_timedate1_dbus_signal_info), (GDBusPropertyInfo **) (&_boxes_fdo_timedate1_dbus_property_info)};
static const GDBusInterfaceVTable _boxes_fdo_timedate1_dbus_interface_vtable = {boxes_fdo_timedate1_dbus_interface_method_call, boxes_fdo_timedate1_dbus_interface_get_property, boxes_fdo_timedate1_dbus_interface_set_property};

GtkCssProvider*
boxes_load_css (const gchar* css)
{
	GtkCssProvider* result = NULL;
	GtkCssProvider* provider = NULL;
	GtkCssProvider* _tmp0_;
	GError * _inner_error_ = NULL;
#line 8 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
	g_return_val_if_fail (css != NULL, NULL);
#line 9 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
	_tmp0_ = gtk_css_provider_new ();
#line 9 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
	provider = _tmp0_;
#line 658 "util-app.c"
	{
		GFile* file = NULL;
		gchar* _tmp1_;
		gchar* _tmp2_;
		GFile* _tmp3_;
		GFile* _tmp4_;
#line 11 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
		_tmp1_ = g_strconcat ("resource:///org/gnome/Boxes/", css, NULL);
#line 11 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
		_tmp2_ = _tmp1_;
#line 11 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
		_tmp3_ = g_file_new_for_uri (_tmp2_);
#line 11 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
		_tmp4_ = _tmp3_;
#line 11 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
		_g_free0 (_tmp2_);
#line 11 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
		file = _tmp4_;
#line 12 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
		gtk_css_provider_load_from_file (provider, file, &_inner_error_);
#line 12 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 12 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
			_g_object_unref0 (file);
#line 683 "util-app.c"
			goto __catch98_g_error;
		}
#line 10 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
		_g_object_unref0 (file);
#line 688 "util-app.c"
	}
	goto __finally98;
	__catch98_g_error:
	{
		GError* e = NULL;
		GError* _tmp5_;
		const gchar* _tmp6_;
#line 10 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
		e = _inner_error_;
#line 10 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
		_inner_error_ = NULL;
#line 14 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
		_tmp5_ = e;
#line 14 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
		_tmp6_ = _tmp5_->message;
#line 14 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
		g_warning ("util-app.vala:14: loading css: %s", _tmp6_);
#line 10 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
		_g_error_free0 (e);
#line 708 "util-app.c"
	}
	__finally98:
#line 10 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 10 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
		_g_object_unref0 (provider);
#line 10 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 10 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
		g_clear_error (&_inner_error_);
#line 10 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
		return NULL;
#line 721 "util-app.c"
	}
#line 16 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
	result = provider;
#line 16 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
	return result;
#line 727 "util-app.c"
}


GdkPixbuf*
boxes_load_asset (const gchar* asset,
                  GError** error)
{
	GdkPixbuf* result = NULL;
	GdkPixbuf* _tmp0_ = NULL;
	gchar* _tmp1_;
	gchar* _tmp2_;
	GdkPixbuf* _tmp3_;
	GdkPixbuf* _tmp4_;
	GdkPixbuf* _tmp5_;
	GError * _inner_error_ = NULL;
#line 19 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
	g_return_val_if_fail (asset != NULL, NULL);
#line 20 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
	_tmp1_ = g_strconcat ("/org/gnome/Boxes/icons/", asset, NULL);
#line 20 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
	_tmp2_ = _tmp1_;
#line 20 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
	_tmp3_ = gdk_pixbuf_new_from_resource (_tmp2_, &_inner_error_);
#line 20 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
	_tmp4_ = _tmp3_;
#line 20 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
	_g_free0 (_tmp2_);
#line 20 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
	_tmp0_ = _tmp4_;
#line 20 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 20 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
		g_propagate_error (error, _inner_error_);
#line 20 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
		return NULL;
#line 763 "util-app.c"
	}
#line 20 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
	_tmp5_ = _tmp0_;
#line 20 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
	_tmp0_ = NULL;
#line 20 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
	result = _tmp5_;
#line 20 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
	_g_object_unref0 (_tmp0_);
#line 20 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
	return result;
#line 775 "util-app.c"
}


GtkBuilder*
boxes_load_ui (const gchar* ui)
{
	GtkBuilder* result = NULL;
	GtkBuilder* builder = NULL;
	GtkBuilder* _tmp0_;
	GError * _inner_error_ = NULL;
#line 23 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
	g_return_val_if_fail (ui != NULL, NULL);
#line 24 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
	_tmp0_ = gtk_builder_new ();
#line 24 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
	builder = _tmp0_;
#line 792 "util-app.c"
	{
		gchar* _tmp1_;
		gchar* _tmp2_;
#line 26 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
		_tmp1_ = g_strconcat ("/org/gnome/Boxes/ui/", ui, NULL, NULL);
#line 26 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
		_tmp2_ = _tmp1_;
#line 26 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
		gtk_builder_add_from_resource (builder, _tmp2_, &_inner_error_);
#line 26 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
		_g_free0 (_tmp2_);
#line 26 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 806 "util-app.c"
			goto __catch99_g_error;
		}
	}
	goto __finally99;
	__catch99_g_error:
	{
		GError* e = NULL;
		const gchar* _tmp3_;
#line 25 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
		e = _inner_error_;
#line 25 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
		_inner_error_ = NULL;
#line 28 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
		_tmp3_ = e->message;
#line 28 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
		g_error ("util-app.vala:28: Failed to load UI file '%s': %s", ui, _tmp3_);
#line 25 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
		_g_error_free0 (e);
#line 825 "util-app.c"
	}
	__finally99:
#line 25 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 25 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
		_g_object_unref0 (builder);
#line 25 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 25 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
		g_clear_error (&_inner_error_);
#line 25 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
		return NULL;
#line 838 "util-app.c"
	}
#line 30 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
	result = builder;
#line 30 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
	return result;
#line 844 "util-app.c"
}


void
boxes_get_color (const gchar* desc,
                 GdkRGBA* result)
{
	GdkRGBA color = {0};
#line 33 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
	g_return_if_fail (desc != NULL);
#line 34 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
	memset (&color, 0, sizeof (GdkRGBA));
#line 35 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
	gdk_rgba_parse (&color, desc);
#line 36 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
	*result = color;
#line 36 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
	return;
#line 863 "util-app.c"
}


gchar*
boxes_extract_xpath (const gchar* xmldoc,
                     const gchar* xpath,
                     gboolean required,
                     GError** error)
{
	gchar* result = NULL;
	xmlParserCtxt* parser = NULL;
	xmlParserCtxt* _tmp0_;
	xmlDoc* doc = NULL;
	xmlParserCtxt* _tmp1_;
	xmlDoc* _tmp2_;
	xmlDoc* _tmp3_;
	xmlXPathContext* ctxt = NULL;
	xmlDoc* _tmp5_;
	xmlXPathContext* _tmp6_;
	xmlXPathObject* obj = NULL;
	xmlXPathContext* _tmp7_;
	xmlXPathObject* _tmp8_;
	gboolean _tmp9_ = FALSE;
	xmlXPathObject* _tmp10_;
	xmlXPathObject* _tmp17_;
	xmlXPathObjectType _tmp18_;
	xmlXPathObject* _tmp23_;
	const gchar* _tmp24_;
	gchar* _tmp25_;
	GError * _inner_error_ = NULL;
#line 39 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
	g_return_val_if_fail (xmldoc != NULL, NULL);
#line 39 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
	g_return_val_if_fail (xpath != NULL, NULL);
#line 40 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
	_tmp0_ = xmlNewParserCtxt ();
#line 40 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
	parser = _tmp0_;
#line 41 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
	_tmp1_ = parser;
#line 41 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
	_tmp2_ = xmlCtxtReadDoc (_tmp1_, (xmlChar*) xmldoc, "doc.xml", NULL, 0);
#line 41 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
	doc = _tmp2_;
#line 43 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
	_tmp3_ = doc;
#line 43 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
	if (_tmp3_ == NULL) {
#line 912 "util-app.c"
		GError* _tmp4_;
#line 44 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
		_tmp4_ = g_error_new_literal (BOXES_ERROR, BOXES_ERROR_INVALID, "Can't parse XML doc");
#line 44 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
		_inner_error_ = _tmp4_;
#line 44 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
		if (_inner_error_->domain == BOXES_ERROR) {
#line 44 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
			g_propagate_error (error, _inner_error_);
#line 44 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
			_xmlFreeParserCtxt0 (parser);
#line 44 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
			return NULL;
#line 926 "util-app.c"
		} else {
#line 44 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
			_xmlFreeParserCtxt0 (parser);
#line 44 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 44 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
			g_clear_error (&_inner_error_);
#line 44 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
			return NULL;
#line 936 "util-app.c"
		}
	}
#line 46 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
	_tmp5_ = doc;
#line 46 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
	_tmp6_ = xmlXPathNewContext (_tmp5_);
#line 46 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
	ctxt = _tmp6_;
#line 47 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
	_tmp7_ = ctxt;
#line 47 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
	_tmp8_ = xmlXPathEval ((xmlChar*) xpath, _tmp7_);
#line 47 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
	obj = _tmp8_;
#line 48 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
	_tmp10_ = obj;
#line 48 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
	if (_tmp10_ == NULL) {
#line 48 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
		_tmp9_ = TRUE;
#line 957 "util-app.c"
	} else {
		xmlXPathObject* _tmp11_;
		const gchar* _tmp12_;
#line 48 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
		_tmp11_ = obj;
#line 48 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
		_tmp12_ = _tmp11_->stringval;
#line 48 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
		_tmp9_ = _tmp12_ == NULL;
#line 967 "util-app.c"
	}
#line 48 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
	if (_tmp9_) {
#line 49 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
		if (required) {
#line 973 "util-app.c"
			gchar* _tmp13_;
			gchar* _tmp14_;
			GError* _tmp15_;
			GError* _tmp16_;
#line 50 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
			_tmp13_ = g_strconcat ("Failed to extract xpath ", xpath, NULL);
#line 50 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
			_tmp14_ = _tmp13_;
#line 50 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
			_tmp15_ = g_error_new_literal (BOXES_ERROR, BOXES_ERROR_INVALID, _tmp14_);
#line 50 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
			_tmp16_ = _tmp15_;
#line 50 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
			_g_free0 (_tmp14_);
#line 50 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
			_inner_error_ = _tmp16_;
#line 50 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
			if (_inner_error_->domain == BOXES_ERROR) {
#line 50 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
				g_propagate_error (error, _inner_error_);
#line 50 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
				_xmlXPathFreeContext0 (ctxt);
#line 50 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
				_xmlFreeParserCtxt0 (parser);
#line 50 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
				return NULL;
#line 1000 "util-app.c"
			} else {
#line 50 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
				_xmlXPathFreeContext0 (ctxt);
#line 50 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
				_xmlFreeParserCtxt0 (parser);
#line 50 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 50 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
				g_clear_error (&_inner_error_);
#line 50 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
				return NULL;
#line 1012 "util-app.c"
			}
		} else {
#line 52 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
			result = NULL;
#line 52 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
			_xmlXPathFreeContext0 (ctxt);
#line 52 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
			_xmlFreeParserCtxt0 (parser);
#line 52 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
			return result;
#line 1023 "util-app.c"
		}
	}
#line 55 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
	_tmp17_ = obj;
#line 55 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
	_tmp18_ = _tmp17_->type;
#line 55 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
	if (_tmp18_ != XPATH_STRING) {
#line 1032 "util-app.c"
		gchar* _tmp19_;
		gchar* _tmp20_;
		GError* _tmp21_;
		GError* _tmp22_;
#line 56 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
		_tmp19_ = g_strconcat ("Failed to extract xpath ", xpath, NULL);
#line 56 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
		_tmp20_ = _tmp19_;
#line 56 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
		_tmp21_ = g_error_new_literal (BOXES_ERROR, BOXES_ERROR_INVALID, _tmp20_);
#line 56 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
		_tmp22_ = _tmp21_;
#line 56 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
		_g_free0 (_tmp20_);
#line 56 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
		_inner_error_ = _tmp22_;
#line 56 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
		if (_inner_error_->domain == BOXES_ERROR) {
#line 56 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
			g_propagate_error (error, _inner_error_);
#line 56 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
			_xmlXPathFreeContext0 (ctxt);
#line 56 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
			_xmlFreeParserCtxt0 (parser);
#line 56 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
			return NULL;
#line 1059 "util-app.c"
		} else {
#line 56 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
			_xmlXPathFreeContext0 (ctxt);
#line 56 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
			_xmlFreeParserCtxt0 (parser);
#line 56 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 56 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
			g_clear_error (&_inner_error_);
#line 56 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
			return NULL;
#line 1071 "util-app.c"
		}
	}
#line 58 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
	_tmp23_ = obj;
#line 58 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
	_tmp24_ = _tmp23_->stringval;
#line 58 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
	_tmp25_ = g_strdup (_tmp24_);
#line 58 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
	result = _tmp25_;
#line 58 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
	_xmlXPathFreeContext0 (ctxt);
#line 58 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
	_xmlFreeParserCtxt0 (parser);
#line 58 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
	return result;
#line 1088 "util-app.c"
}


static gpointer
_g_object_ref0 (gpointer self)
{
#line 62 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
	return self ? g_object_ref (self) : NULL;
#line 1097 "util-app.c"
}


void
boxes_widget_remove (GtkWidget* widget)
{
	GtkContainer* container = NULL;
	GtkContainer* _tmp0_;
	GtkContainer* _tmp1_;
	GtkContainer* _tmp2_;
	GtkContainer* _tmp3_;
#line 61 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
	g_return_if_fail (widget != NULL);
#line 62 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
	_tmp0_ = gtk_widget_get_parent (widget);
#line 62 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
	_tmp1_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp0_, gtk_container_get_type ()) ? ((GtkContainer*) _tmp0_) : NULL);
#line 62 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
	container = _tmp1_;
#line 64 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
	_tmp2_ = container;
#line 64 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
	if (_tmp2_ == NULL) {
#line 65 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
		_g_object_unref0 (container);
#line 65 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
		return;
#line 1125 "util-app.c"
	}
#line 67 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
	_tmp3_ = container;
#line 67 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
	gtk_container_remove (_tmp3_, widget);
#line 61 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
	_g_object_unref0 (container);
#line 1133 "util-app.c"
}


OsinfoDevice*
boxes_find_device_by_prop (OsinfoDeviceList* devices,
                           const gchar* prop_name,
                           const gchar* prop_value)
{
	OsinfoDevice* result = NULL;
	OsinfoFilter* filter = NULL;
	OsinfoFilter* _tmp0_;
	OsinfoFilter* _tmp1_;
	OsinfoList* filtered = NULL;
	OsinfoFilter* _tmp2_;
	OsinfoList* _tmp3_;
	OsinfoList* _tmp4_;
#line 70 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
	g_return_val_if_fail (devices != NULL, NULL);
#line 70 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
	g_return_val_if_fail (prop_name != NULL, NULL);
#line 70 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
	g_return_val_if_fail (prop_value != NULL, NULL);
#line 71 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
	_tmp0_ = osinfo_filter_new ();
#line 71 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
	filter = _tmp0_;
#line 72 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
	_tmp1_ = filter;
#line 72 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
	osinfo_filter_add_constraint (_tmp1_, prop_name, prop_value);
#line 74 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
	_tmp2_ = filter;
#line 74 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
	_tmp3_ = osinfo_list_new_filtered (G_TYPE_CHECK_INSTANCE_TYPE (devices, osinfo_list_get_type ()) ? ((OsinfoList*) devices) : NULL, _tmp2_);
#line 74 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
	filtered = _tmp3_;
#line 75 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
	_tmp4_ = filtered;
#line 75 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
	if (osinfo_list_get_length (_tmp4_) > 0) {
#line 1174 "util-app.c"
		OsinfoList* _tmp5_;
		OsinfoEntity* _tmp6_;
		OsinfoDevice* _tmp7_;
#line 76 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
		_tmp5_ = filtered;
#line 76 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
		_tmp6_ = osinfo_list_get_nth (_tmp5_, 0);
#line 76 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
		_tmp7_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp6_, osinfo_device_get_type ()) ? ((OsinfoDevice*) _tmp6_) : NULL);
#line 76 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
		result = _tmp7_;
#line 76 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
		_g_object_unref0 (filtered);
#line 76 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
		_g_object_unref0 (filter);
#line 76 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
		return result;
#line 1192 "util-app.c"
	} else {
#line 78 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
		result = NULL;
#line 78 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
		_g_object_unref0 (filtered);
#line 78 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
		_g_object_unref0 (filter);
#line 78 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
		return result;
#line 1202 "util-app.c"
	}
#line 70 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
	_g_object_unref0 (filtered);
#line 70 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
	_g_object_unref0 (filter);
#line 1208 "util-app.c"
}


GtkImage*
boxes_get_os_logo (OsinfoOs* os,
                   gint size)
{
	GtkImage* result = NULL;
	GtkImage* image = NULL;
	GtkImage* _tmp0_;
	GtkImage* _tmp1_;
#line 82 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
	_tmp0_ = (GtkImage*) gtk_image_new_from_icon_name ("media-optical", (GtkIconSize) 0);
#line 82 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
	g_object_ref_sink (_tmp0_);
#line 82 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
	image = _tmp0_;
#line 83 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
	_tmp1_ = image;
#line 83 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
	gtk_image_set_pixel_size (_tmp1_, size);
#line 85 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
	if (os != NULL) {
#line 1232 "util-app.c"
		GtkImage* _tmp2_;
#line 86 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
		_tmp2_ = image;
#line 86 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
		boxes_fetch_os_logo (_tmp2_, os, size);
#line 1238 "util-app.c"
	}
#line 88 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
	result = image;
#line 88 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
	return result;
#line 1244 "util-app.c"
}


void
boxes_fetch_os_logo (GtkImage* image,
                     OsinfoOs* os,
                     gint size)
{
	gchar* path = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar** _tmp3_;
	gchar** _tmp4_;
	gint _tmp4__length1;
	gchar* _tmp5_;
	gchar* _tmp6_;
	const gchar* _tmp7_;
	GError * _inner_error_ = NULL;
#line 91 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
	g_return_if_fail (image != NULL);
#line 91 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
	g_return_if_fail (os != NULL);
#line 92 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
	_tmp0_ = g_strdup (".svg");
#line 92 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
	_tmp1_ = g_strdup (".png");
#line 92 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
	_tmp2_ = g_strdup (".jpg");
#line 92 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
	_tmp3_ = g_new0 (gchar*, 3 + 1);
#line 92 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
	_tmp3_[0] = _tmp0_;
#line 92 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
	_tmp3_[1] = _tmp1_;
#line 92 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
	_tmp3_[2] = _tmp2_;
#line 92 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
	_tmp4_ = _tmp3_;
#line 92 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
	_tmp4__length1 = 3;
#line 92 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
	_tmp5_ = boxes_get_logo_path (os, _tmp4_, 3);
#line 92 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
	_tmp6_ = _tmp5_;
#line 92 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
	_tmp4_ = (_vala_array_free (_tmp4_, _tmp4__length1, (GDestroyNotify) g_free), NULL);
#line 92 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
	path = _tmp6_;
#line 94 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
	_tmp7_ = path;
#line 94 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
	if (_tmp7_ == NULL) {
#line 95 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
		_g_free0 (path);
#line 95 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
		return;
#line 1302 "util-app.c"
	}
	{
		GdkPixbuf* pixbuf = NULL;
		const gchar* _tmp8_;
		GdkPixbuf* _tmp9_;
		GdkPixbuf* _tmp10_;
#line 98 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
		_tmp8_ = path;
#line 98 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
		_tmp9_ = gdk_pixbuf_new_from_file_at_size (_tmp8_, size, -1, &_inner_error_);
#line 98 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
		pixbuf = _tmp9_;
#line 98 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1317 "util-app.c"
			goto __catch100_g_error;
		}
#line 99 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
		_tmp10_ = pixbuf;
#line 99 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
		gtk_image_set_from_pixbuf (image, _tmp10_);
#line 97 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
		_g_object_unref0 (pixbuf);
#line 1326 "util-app.c"
	}
	goto __finally100;
	__catch100_g_error:
	{
		GError* _error_ = NULL;
		const gchar* _tmp11_;
		GError* _tmp12_;
		const gchar* _tmp13_;
#line 97 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
		_error_ = _inner_error_;
#line 97 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
		_inner_error_ = NULL;
#line 101 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
		_tmp11_ = path;
#line 101 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
		_tmp12_ = _error_;
#line 101 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
		_tmp13_ = _tmp12_->message;
#line 101 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
		g_warning ("util-app.vala:101: Error loading logo file '%s': %s", _tmp11_, _tmp13_);
#line 97 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
		_g_error_free0 (_error_);
#line 1349 "util-app.c"
	}
	__finally100:
#line 97 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 97 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
		_g_free0 (path);
#line 97 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 97 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
		g_clear_error (&_inner_error_);
#line 97 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
		return;
#line 1362 "util-app.c"
	}
#line 91 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
	_g_free0 (path);
#line 1366 "util-app.c"
}


static void
boxes_ensure_storage_pool_data_free (gpointer _data)
{
	BoxesEnsureStoragePoolData* _data_;
	_data_ = _data;
#line 535 "/home/fborges/checkout/gnome-boxes/src/libvirt-machine.vala"
	_g_object_unref0 (_data_->connection);
#line 535 "/home/fborges/checkout/gnome-boxes/src/libvirt-machine.vala"
	_g_object_unref0 (_data_->result);
#line 535 "/home/fborges/checkout/gnome-boxes/src/libvirt-machine.vala"
	g_slice_free (BoxesEnsureStoragePoolData, _data_);
#line 1381 "util-app.c"
}


static void
boxes_ensure_storage_pool_async_ready_wrapper (GObject *source_object,
                                               GAsyncResult *res,
                                               void *user_data)
{
	BoxesEnsureStoragePoolData* _task_data_;
#line 535 "/home/fborges/checkout/gnome-boxes/src/libvirt-machine.vala"
	_task_data_ = g_task_get_task_data (G_TASK (res));
#line 535 "/home/fborges/checkout/gnome-boxes/src/libvirt-machine.vala"
	if (_task_data_->_callback_ != NULL) {
#line 535 "/home/fborges/checkout/gnome-boxes/src/libvirt-machine.vala"
		_task_data_->_callback_ (source_object, res, user_data);
#line 1397 "util-app.c"
	}
#line 535 "/home/fborges/checkout/gnome-boxes/src/libvirt-machine.vala"
	_task_data_->_task_complete_ = TRUE;
#line 1401 "util-app.c"
}


void
boxes_ensure_storage_pool (GVirConnection* connection,
                           GAsyncReadyCallback _callback_,
                           gpointer _user_data_)
{
	BoxesEnsureStoragePoolData* _data_;
	GVirConnection* _tmp0_;
#line 535 "/home/fborges/checkout/gnome-boxes/src/libvirt-machine.vala"
	_data_ = g_slice_new0 (BoxesEnsureStoragePoolData);
#line 535 "/home/fborges/checkout/gnome-boxes/src/libvirt-machine.vala"
	_data_->_callback_ = _callback_;
#line 535 "/home/fborges/checkout/gnome-boxes/src/libvirt-machine.vala"
	_data_->_async_result = g_task_new (NULL, NULL, boxes_ensure_storage_pool_async_ready_wrapper, _user_data_);
#line 535 "/home/fborges/checkout/gnome-boxes/src/libvirt-machine.vala"
	if (_callback_ == NULL) {
#line 535 "/home/fborges/checkout/gnome-boxes/src/libvirt-machine.vala"
		_data_->_task_complete_ = TRUE;
#line 1422 "util-app.c"
	}
#line 535 "/home/fborges/checkout/gnome-boxes/src/libvirt-machine.vala"
	g_task_set_task_data (_data_->_async_result, _data_, boxes_ensure_storage_pool_data_free);
#line 535 "/home/fborges/checkout/gnome-boxes/src/libvirt-machine.vala"
	_tmp0_ = _g_object_ref0 (connection);
#line 535 "/home/fborges/checkout/gnome-boxes/src/libvirt-machine.vala"
	_g_object_unref0 (_data_->connection);
#line 535 "/home/fborges/checkout/gnome-boxes/src/libvirt-machine.vala"
	_data_->connection = _tmp0_;
#line 535 "/home/fborges/checkout/gnome-boxes/src/libvirt-machine.vala"
	boxes_ensure_storage_pool_co (_data_);
#line 1434 "util-app.c"
}


GVirStoragePool*
boxes_ensure_storage_pool_finish (GAsyncResult* _res_,
                                  GError** error)
{
	GVirStoragePool* result;
	BoxesEnsureStoragePoolData* _data_;
#line 535 "/home/fborges/checkout/gnome-boxes/src/libvirt-machine.vala"
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
#line 535 "/home/fborges/checkout/gnome-boxes/src/libvirt-machine.vala"
	if (NULL == _data_) {
#line 535 "/home/fborges/checkout/gnome-boxes/src/libvirt-machine.vala"
		return NULL;
#line 1450 "util-app.c"
	}
#line 535 "/home/fborges/checkout/gnome-boxes/src/libvirt-machine.vala"
	result = _data_->result;
#line 535 "/home/fborges/checkout/gnome-boxes/src/libvirt-machine.vala"
	_data_->result = NULL;
#line 535 "/home/fborges/checkout/gnome-boxes/src/libvirt-machine.vala"
	return result;
#line 1458 "util-app.c"
}


static void
boxes_ensure_storage_pool_ready (GObject* source_object,
                                 GAsyncResult* _res_,
                                 gpointer _user_data_)
{
	BoxesEnsureStoragePoolData* _data_;
#line 111 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
	_data_ = _user_data_;
#line 111 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
	_data_->_source_object_ = source_object;
#line 111 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
	_data_->_res_ = _res_;
#line 111 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
	_data_->_task_complete_ = TRUE;
#line 111 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
	boxes_ensure_storage_pool_co (_data_);
#line 1478 "util-app.c"
}


static void
_vala_GVirStoragePoolInfo_free (GVirStoragePoolInfo* self)
{
#line 120 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
	g_boxed_free (gvir_storage_pool_info_get_type (), self);
#line 1487 "util-app.c"
}


static gboolean
boxes_ensure_storage_pool_co (BoxesEnsureStoragePoolData* _data_)
{
#line 105 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
	switch (_data_->_state_) {
#line 105 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
		case 0:
#line 1498 "util-app.c"
		goto _state_0;
#line 105 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
		case 1:
#line 1502 "util-app.c"
		goto _state_1;
#line 105 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
		case 2:
#line 1506 "util-app.c"
		goto _state_2;
#line 105 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
		case 3:
#line 1510 "util-app.c"
		goto _state_3;
		default:
#line 105 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
		g_assert_not_reached ();
#line 1515 "util-app.c"
	}
	_state_0:
#line 106 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
	_data_->_tmp0_ = boxes_get_storage_pool (_data_->connection);
#line 106 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
	_data_->pool = _data_->_tmp0_;
#line 107 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
	_data_->_tmp1_ = _data_->pool;
#line 107 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
	if (_data_->_tmp1_ == NULL) {
#line 108 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
		g_debug ("util-app.vala:108: Creating storage pool..");
#line 109 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
		_data_->_tmp2_ = boxes_vm_configurator_get_pool_config (&_data_->_inner_error_);
#line 109 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
		_data_->config = _data_->_tmp2_;
#line 109 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
		if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
#line 109 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
			g_task_return_error (_data_->_async_result, _data_->_inner_error_);
#line 109 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
			_g_object_unref0 (_data_->pool);
#line 109 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
			g_object_unref (_data_->_async_result);
#line 109 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
			return FALSE;
#line 1542 "util-app.c"
		}
#line 110 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
		_data_->_tmp4_ = _data_->config;
#line 110 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
		_data_->_tmp5_ = gvir_connection_create_storage_pool (_data_->connection, _data_->_tmp4_, (guint) 0, &_data_->_inner_error_);
#line 110 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
		_data_->_tmp3_ = _data_->_tmp5_;
#line 110 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
		if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
#line 110 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
			g_task_return_error (_data_->_async_result, _data_->_inner_error_);
#line 110 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
			_g_object_unref0 (_data_->config);
#line 110 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
			_g_object_unref0 (_data_->pool);
#line 110 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
			g_object_unref (_data_->_async_result);
#line 110 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
			return FALSE;
#line 1562 "util-app.c"
		}
#line 110 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
		_data_->_tmp6_ = _data_->_tmp3_;
#line 110 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
		_data_->_tmp3_ = NULL;
#line 110 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
		_g_object_unref0 (_data_->pool);
#line 110 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
		_data_->pool = _data_->_tmp6_;
#line 111 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
		_data_->_tmp7_ = _data_->pool;
#line 111 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
		_data_->_state_ = 1;
#line 111 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
		gvir_storage_pool_build_async (_data_->_tmp7_, (guint) 0, NULL, boxes_ensure_storage_pool_ready, _data_);
#line 111 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
		return FALSE;
#line 1580 "util-app.c"
		_state_1:
#line 111 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
		gvir_storage_pool_build_finish (_data_->_tmp7_, _data_->_res_, &_data_->_inner_error_);
#line 111 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
		if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
#line 111 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
			g_task_return_error (_data_->_async_result, _data_->_inner_error_);
#line 111 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
			_g_object_unref0 (_data_->_tmp3_);
#line 111 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
			_g_object_unref0 (_data_->config);
#line 111 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
			_g_object_unref0 (_data_->pool);
#line 111 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
			g_object_unref (_data_->_async_result);
#line 111 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
			return FALSE;
#line 1598 "util-app.c"
		}
#line 112 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
		g_debug ("util-app.vala:112: Created storage pool.");
#line 107 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
		_g_object_unref0 (_data_->_tmp3_);
#line 107 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
		_g_object_unref0 (_data_->config);
#line 1606 "util-app.c"
	}
#line 116 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
	_data_->_tmp8_ = boxes_get_user_pkgdata ("images");
#line 116 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
	_data_->pool_path = _data_->_tmp8_;
#line 117 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
	_data_->_tmp9_ = _data_->pool_path;
#line 117 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
	boxes_ensure_directory (_data_->_tmp9_);
#line 119 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
	_data_->_tmp11_ = _data_->pool;
#line 119 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
	_data_->_tmp12_ = gvir_storage_pool_get_info (_data_->_tmp11_, &_data_->_inner_error_);
#line 119 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
	_data_->_tmp10_ = _data_->_tmp12_;
#line 119 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
	if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
#line 119 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
		g_task_return_error (_data_->_async_result, _data_->_inner_error_);
#line 119 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
		_g_free0 (_data_->pool_path);
#line 119 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
		_g_object_unref0 (_data_->pool);
#line 119 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
		g_object_unref (_data_->_async_result);
#line 119 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
		return FALSE;
#line 1634 "util-app.c"
	}
#line 119 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
	_data_->_tmp13_ = _data_->_tmp10_->state;
#line 119 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
	if (_data_->_tmp13_ == GVIR_STORAGE_POOL_STATE_INACTIVE) {
#line 120 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
		_data_->_tmp14_ = _data_->pool;
#line 120 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
		_data_->_state_ = 2;
#line 120 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
		gvir_storage_pool_start_async (_data_->_tmp14_, (guint) 0, NULL, boxes_ensure_storage_pool_ready, _data_);
#line 120 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
		return FALSE;
#line 1648 "util-app.c"
		_state_2:
#line 120 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
		gvir_storage_pool_start_finish (_data_->_tmp14_, _data_->_res_, &_data_->_inner_error_);
#line 120 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
		if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
#line 120 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
			g_task_return_error (_data_->_async_result, _data_->_inner_error_);
#line 120 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
			__vala_GVirStoragePoolInfo_free0 (_data_->_tmp10_);
#line 120 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
			_g_free0 (_data_->pool_path);
#line 120 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
			_g_object_unref0 (_data_->pool);
#line 120 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
			g_object_unref (_data_->_async_result);
#line 120 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
			return FALSE;
#line 1666 "util-app.c"
		}
	}
#line 121 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
	_data_->_tmp15_ = _data_->pool;
#line 121 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
	_data_->_state_ = 3;
#line 121 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
	gvir_storage_pool_refresh_async (_data_->_tmp15_, NULL, boxes_ensure_storage_pool_ready, _data_);
#line 121 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
	return FALSE;
#line 1677 "util-app.c"
	_state_3:
#line 121 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
	gvir_storage_pool_refresh_finish (_data_->_tmp15_, _data_->_res_, &_data_->_inner_error_);
#line 121 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
	if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
#line 121 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
		g_task_return_error (_data_->_async_result, _data_->_inner_error_);
#line 121 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
		__vala_GVirStoragePoolInfo_free0 (_data_->_tmp10_);
#line 121 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
		_g_free0 (_data_->pool_path);
#line 121 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
		_g_object_unref0 (_data_->pool);
#line 121 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
		g_object_unref (_data_->_async_result);
#line 121 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
		return FALSE;
#line 1695 "util-app.c"
	}
#line 122 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
	_data_->_tmp16_ = _data_->pool;
#line 122 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
	gvir_storage_pool_set_autostart (_data_->_tmp16_, TRUE, &_data_->_inner_error_);
#line 122 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
	if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
#line 122 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
		g_task_return_error (_data_->_async_result, _data_->_inner_error_);
#line 122 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
		__vala_GVirStoragePoolInfo_free0 (_data_->_tmp10_);
#line 122 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
		_g_free0 (_data_->pool_path);
#line 122 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
		_g_object_unref0 (_data_->pool);
#line 122 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
		g_object_unref (_data_->_async_result);
#line 122 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
		return FALSE;
#line 1715 "util-app.c"
	}
#line 124 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
	_data_->result = _data_->pool;
#line 124 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
	__vala_GVirStoragePoolInfo_free0 (_data_->_tmp10_);
#line 124 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
	_g_free0 (_data_->pool_path);
#line 124 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
#line 124 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
	if (_data_->_state_ != 0) {
#line 124 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
		while (_data_->_task_complete_ != TRUE) {
#line 124 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
#line 1731 "util-app.c"
		}
	}
#line 124 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
	g_object_unref (_data_->_async_result);
#line 124 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
	return FALSE;
#line 1738 "util-app.c"
}


GVirStoragePool*
boxes_get_storage_pool (GVirConnection* connection)
{
	GVirStoragePool* result = NULL;
	GVirStoragePool* _tmp0_;
#line 127 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
	g_return_val_if_fail (connection != NULL, NULL);
#line 128 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
	_tmp0_ = gvir_connection_find_storage_pool_by_name (connection, PACKAGE_TARNAME);
#line 128 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
	result = _tmp0_;
#line 128 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
	return result;
#line 1755 "util-app.c"
}


GVirStorageVol*
boxes_get_storage_volume (GVirConnection* connection,
                          GVirDomain* domain)
{
	GVirStorageVol* result = NULL;
	GVirStoragePool* pool = NULL;
	GVirStoragePool* _tmp0_;
	GVirStoragePool* _tmp1_;
	GVirStoragePool* _tmp2_;
	const gchar* _tmp3_;
	GVirStorageVol* _tmp4_;
#line 131 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
	g_return_val_if_fail (connection != NULL, NULL);
#line 131 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
	g_return_val_if_fail (domain != NULL, NULL);
#line 132 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
	_tmp0_ = boxes_get_storage_pool (connection);
#line 132 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
	pool = _tmp0_;
#line 133 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
	_tmp1_ = pool;
#line 133 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
	if (_tmp1_ == NULL) {
#line 135 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
		result = NULL;
#line 135 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
		_g_object_unref0 (pool);
#line 135 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
		return result;
#line 1788 "util-app.c"
	}
#line 137 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
	_tmp2_ = pool;
#line 137 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
	_tmp3_ = gvir_domain_get_name (domain);
#line 137 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
	_tmp4_ = gvir_storage_pool_get_volume (_tmp2_, _tmp3_);
#line 137 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
	result = _tmp4_;
#line 137 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
	_g_object_unref0 (pool);
#line 137 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
	return result;
#line 1802 "util-app.c"
}


static gchar
string_get (const gchar* self,
            glong index)
{
	gchar result = '\0';
	gchar _tmp0_;
#line 1124 "/home/fborges/jhbuild/install/share/vala-0.40/vapi/glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, '\0');
#line 1125 "/home/fborges/jhbuild/install/share/vala-0.40/vapi/glib-2.0.vapi"
	_tmp0_ = ((gchar*) self)[index];
#line 1125 "/home/fborges/jhbuild/install/share/vala-0.40/vapi/glib-2.0.vapi"
	result = _tmp0_;
#line 1125 "/home/fborges/jhbuild/install/share/vala-0.40/vapi/glib-2.0.vapi"
	return result;
#line 1820 "util-app.c"
}


gboolean
boxes_is_libvirt_bridge_net_available (void)
{
	gboolean result = FALSE;
	gboolean _tmp0_;
	gboolean _tmp33_;
	GError * _inner_error_ = NULL;
#line 144 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
	_tmp0_ = boxes_libvirt_bridge_net_checked;
#line 144 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
	if (_tmp0_) {
#line 1835 "util-app.c"
		gboolean _tmp1_;
#line 145 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
		_tmp1_ = boxes_libvirt_bridge_net_available;
#line 145 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
		result = _tmp1_;
#line 145 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
		return result;
#line 1843 "util-app.c"
	}
	{
		gint sock = 0;
		gint _tmp2_;
		struct ifreq req = {0};
		gchar* if_name = NULL;
		gchar* _tmp5_;
		gboolean _tmp16_ = FALSE;
		gint _tmp17_;
		GFile* file = NULL;
		GFile* _tmp21_;
		guint8* contents = NULL;
		gint contents_length1 = 0;
		gint _contents_size_ = 0;
		guint8* _tmp29_;
		gint _tmp29__length1;
#line 149 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
		sock = socket (AF_INET, SOCK_STREAM, 0);
#line 150 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
		_tmp2_ = sock;
#line 150 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
		if (_tmp2_ < 0) {
#line 1866 "util-app.c"
			gint _tmp3_;
			GError* _tmp4_;
#line 151 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
			_tmp3_ = errno;
#line 151 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
			_tmp4_ = g_error_new ((GQuark) G_IO_ERROR, g_io_error_from_errno (_tmp3_), "Failed to create a socket");
#line 151 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
			_inner_error_ = (GError*) _tmp4_;
#line 1875 "util-app.c"
			goto __catch101_g_error;
		}
#line 155 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
		memset (&req, 0, sizeof (struct ifreq));
#line 156 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
		_tmp5_ = g_strdup ("virbr0");
#line 156 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
		if_name = _tmp5_;
#line 1884 "util-app.c"
		{
			gint i = 0;
#line 157 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
			i = 0;
#line 1889 "util-app.c"
			{
				gboolean _tmp6_ = FALSE;
#line 157 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
				_tmp6_ = TRUE;
#line 157 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
				while (TRUE) {
#line 1896 "util-app.c"
					gint _tmp8_;
					const gchar* _tmp9_;
					gint _tmp10_;
					gint _tmp11_;
					gint _tmp12_;
					const gchar* _tmp13_;
					gint _tmp14_;
					gchar _tmp15_;
#line 157 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
					if (!_tmp6_) {
#line 1907 "util-app.c"
						gint _tmp7_;
#line 157 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
						_tmp7_ = i;
#line 157 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
						i = _tmp7_ + 1;
#line 1913 "util-app.c"
					}
#line 157 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
					_tmp6_ = FALSE;
#line 157 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
					_tmp8_ = i;
#line 157 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
					_tmp9_ = if_name;
#line 157 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
					_tmp10_ = strlen (_tmp9_);
#line 157 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
					_tmp11_ = _tmp10_;
#line 157 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
					if (!(_tmp8_ <= _tmp11_)) {
#line 157 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
						break;
#line 1929 "util-app.c"
					}
#line 158 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
					_tmp12_ = i;
#line 158 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
					_tmp13_ = if_name;
#line 158 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
					_tmp14_ = i;
#line 158 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
					req.ifr_name[_tmp12_] = (gchar) string_get (_tmp13_, (glong) _tmp14_);
#line 158 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
					_tmp15_ = req.ifr_name[_tmp12_];
#line 1941 "util-app.c"
				}
			}
		}
#line 160 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
		_tmp17_ = sock;
#line 160 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
		if (ioctl (_tmp17_, SIOCGIFFLAGS, &req) < 0) {
#line 160 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
			_tmp16_ = TRUE;
#line 1951 "util-app.c"
		} else {
			struct ifreq _tmp18_;
			gshort _tmp19_;
#line 161 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
			_tmp18_ = req;
#line 161 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
			_tmp19_ = _tmp18_.ifr_flags;
#line 161 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
			_tmp16_ = !((_tmp19_ & IFF_UP) == IFF_UP);
#line 1961 "util-app.c"
		}
#line 160 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
		if (_tmp16_) {
#line 1965 "util-app.c"
			const gchar* _tmp20_;
#line 162 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
			_tmp20_ = if_name;
#line 162 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
			g_debug ("util-app.vala:162: Interface '%s' is either not available or not up.", _tmp20_);
#line 164 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
			result = FALSE;
#line 164 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
			_g_free0 (if_name);
#line 164 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
			 (&req);
#line 164 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
			return result;
#line 1979 "util-app.c"
		}
#line 168 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
		_tmp21_ = g_file_new_for_path ("/etc/qemu/bridge.conf");
#line 168 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
		file = _tmp21_;
#line 1985 "util-app.c"
		{
			GFile* _tmp22_;
			guint8* _tmp23_ = NULL;
			gsize _tmp24_;
#line 171 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
			_tmp22_ = file;
#line 171 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
			g_file_load_contents (_tmp22_, NULL, &_tmp23_, &_tmp24_, NULL, &_inner_error_);
#line 171 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
			contents = (g_free (contents), NULL);
#line 171 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
			contents = _tmp23_;
#line 171 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
			contents_length1 = _tmp24_;
#line 171 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
			_contents_size_ = contents_length1;
#line 171 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
			if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 171 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
				if (g_error_matches (_inner_error_, G_IO_ERROR, G_IO_ERROR_NOT_FOUND)) {
#line 2006 "util-app.c"
					goto __catch102_g_io_error_not_found;
				}
				goto __finally102;
			}
		}
		goto __finally102;
		__catch102_g_io_error_not_found:
		{
			GError* _error_ = NULL;
			GFile* _tmp25_;
			GFile* _tmp26_;
			guint8* _tmp27_ = NULL;
			gsize _tmp28_;
#line 170 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
			_error_ = _inner_error_;
#line 170 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
			_inner_error_ = NULL;
#line 173 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
			_tmp25_ = g_file_new_for_path ("/etc/qemu-kvm/bridge.conf");
#line 173 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
			_g_object_unref0 (file);
#line 173 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
			file = _tmp25_;
#line 174 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
			_tmp26_ = file;
#line 174 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
			g_file_load_contents (_tmp26_, NULL, &_tmp27_, &_tmp28_, NULL, &_inner_error_);
#line 174 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
			contents = (g_free (contents), NULL);
#line 174 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
			contents = _tmp27_;
#line 174 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
			contents_length1 = _tmp28_;
#line 174 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
			_contents_size_ = contents_length1;
#line 174 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
			if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 174 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
				_g_error_free0 (_error_);
#line 2046 "util-app.c"
				goto __finally102;
			}
#line 170 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
			_g_error_free0 (_error_);
#line 2051 "util-app.c"
		}
		__finally102:
#line 170 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 170 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
			contents = (g_free (contents), NULL);
#line 170 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
			_g_object_unref0 (file);
#line 170 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
			_g_free0 (if_name);
#line 170 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
			 (&req);
#line 2064 "util-app.c"
			goto __catch101_g_error;
		}
#line 177 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
		_tmp29_ = contents;
#line 177 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
		_tmp29__length1 = contents_length1;
#line 177 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
		boxes_libvirt_bridge_net_available = g_regex_match_simple ("(?m)^allow.*virbr0", (const gchar*) _tmp29_, 0, 0);
#line 147 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
		contents = (g_free (contents), NULL);
#line 147 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
		_g_object_unref0 (file);
#line 147 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
		_g_free0 (if_name);
#line 147 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
		 (&req);
#line 2081 "util-app.c"
	}
	goto __finally101;
	__catch101_g_error:
	{
		GError* _error_ = NULL;
		GError* _tmp30_;
		const gchar* _tmp31_;
#line 147 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
		_error_ = _inner_error_;
#line 147 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
		_inner_error_ = NULL;
#line 179 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
		_tmp30_ = _error_;
#line 179 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
		_tmp31_ = _tmp30_->message;
#line 179 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
		g_debug ("util-app.vala:179: %s", _tmp31_);
#line 181 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
		boxes_libvirt_bridge_net_available = FALSE;
#line 147 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
		_g_error_free0 (_error_);
#line 2103 "util-app.c"
	}
	__finally101:
#line 147 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 2108 "util-app.c"
		gboolean _tmp32_ = FALSE;
#line 147 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 147 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
		g_clear_error (&_inner_error_);
#line 147 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
		return _tmp32_;
#line 2116 "util-app.c"
	}
#line 184 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
	boxes_libvirt_bridge_net_checked = TRUE;
#line 186 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
	_tmp33_ = boxes_libvirt_bridge_net_available;
#line 186 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
	result = _tmp33_;
#line 186 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
	return result;
#line 2126 "util-app.c"
}


static void
boxes_get_system_virt_connection_data_free (gpointer _data)
{
	BoxesGetSystemVirtConnectionData* _data_;
	_data_ = _data;
#line 535 "/home/fborges/checkout/gnome-boxes/src/libvirt-machine.vala"
	_g_object_unref0 (_data_->result);
#line 535 "/home/fborges/checkout/gnome-boxes/src/libvirt-machine.vala"
	g_slice_free (BoxesGetSystemVirtConnectionData, _data_);
#line 2139 "util-app.c"
}


static void
boxes_get_system_virt_connection_async_ready_wrapper (GObject *source_object,
                                                      GAsyncResult *res,
                                                      void *user_data)
{
	BoxesGetSystemVirtConnectionData* _task_data_;
#line 535 "/home/fborges/checkout/gnome-boxes/src/libvirt-machine.vala"
	_task_data_ = g_task_get_task_data (G_TASK (res));
#line 535 "/home/fborges/checkout/gnome-boxes/src/libvirt-machine.vala"
	if (_task_data_->_callback_ != NULL) {
#line 535 "/home/fborges/checkout/gnome-boxes/src/libvirt-machine.vala"
		_task_data_->_callback_ (source_object, res, user_data);
#line 2155 "util-app.c"
	}
#line 535 "/home/fborges/checkout/gnome-boxes/src/libvirt-machine.vala"
	_task_data_->_task_complete_ = TRUE;
#line 2159 "util-app.c"
}


void
boxes_get_system_virt_connection (GAsyncReadyCallback _callback_,
                                  gpointer _user_data_)
{
	BoxesGetSystemVirtConnectionData* _data_;
#line 535 "/home/fborges/checkout/gnome-boxes/src/libvirt-machine.vala"
	_data_ = g_slice_new0 (BoxesGetSystemVirtConnectionData);
#line 535 "/home/fborges/checkout/gnome-boxes/src/libvirt-machine.vala"
	_data_->_callback_ = _callback_;
#line 535 "/home/fborges/checkout/gnome-boxes/src/libvirt-machine.vala"
	_data_->_async_result = g_task_new (NULL, NULL, boxes_get_system_virt_connection_async_ready_wrapper, _user_data_);
#line 535 "/home/fborges/checkout/gnome-boxes/src/libvirt-machine.vala"
	if (_callback_ == NULL) {
#line 535 "/home/fborges/checkout/gnome-boxes/src/libvirt-machine.vala"
		_data_->_task_complete_ = TRUE;
#line 2178 "util-app.c"
	}
#line 535 "/home/fborges/checkout/gnome-boxes/src/libvirt-machine.vala"
	g_task_set_task_data (_data_->_async_result, _data_, boxes_get_system_virt_connection_data_free);
#line 535 "/home/fborges/checkout/gnome-boxes/src/libvirt-machine.vala"
	boxes_get_system_virt_connection_co (_data_);
#line 2184 "util-app.c"
}


GVirConnection*
boxes_get_system_virt_connection_finish (GAsyncResult* _res_,
                                         GError** error)
{
	GVirConnection* result;
	BoxesGetSystemVirtConnectionData* _data_;
#line 535 "/home/fborges/checkout/gnome-boxes/src/libvirt-machine.vala"
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
#line 535 "/home/fborges/checkout/gnome-boxes/src/libvirt-machine.vala"
	if (NULL == _data_) {
#line 535 "/home/fborges/checkout/gnome-boxes/src/libvirt-machine.vala"
		return NULL;
#line 2200 "util-app.c"
	}
#line 535 "/home/fborges/checkout/gnome-boxes/src/libvirt-machine.vala"
	result = _data_->result;
#line 535 "/home/fborges/checkout/gnome-boxes/src/libvirt-machine.vala"
	_data_->result = NULL;
#line 535 "/home/fborges/checkout/gnome-boxes/src/libvirt-machine.vala"
	return result;
#line 2208 "util-app.c"
}


static void
boxes_get_system_virt_connection_ready (GObject* source_object,
                                        GAsyncResult* _res_,
                                        gpointer _user_data_)
{
	BoxesGetSystemVirtConnectionData* _data_;
#line 197 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
	_data_ = _user_data_;
#line 197 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
	_data_->_source_object_ = source_object;
#line 197 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
	_data_->_res_ = _res_;
#line 197 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
	_data_->_task_complete_ = TRUE;
#line 197 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
	boxes_get_system_virt_connection_co (_data_);
#line 2228 "util-app.c"
}


static gboolean
boxes_get_system_virt_connection_co (BoxesGetSystemVirtConnectionData* _data_)
{
#line 191 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
	switch (_data_->_state_) {
#line 191 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
		case 0:
#line 2239 "util-app.c"
		goto _state_0;
#line 191 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
		case 1:
#line 2243 "util-app.c"
		goto _state_1;
#line 191 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
		case 2:
#line 2247 "util-app.c"
		goto _state_2;
#line 191 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
		case 3:
#line 2251 "util-app.c"
		goto _state_3;
		default:
#line 191 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
		g_assert_not_reached ();
#line 2256 "util-app.c"
	}
	_state_0:
#line 192 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
	_data_->_tmp0_ = boxes_system_virt_connection;
#line 192 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
	if (_data_->_tmp0_ != NULL) {
#line 193 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
		_data_->_tmp1_ = boxes_system_virt_connection;
#line 193 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
		_data_->_tmp2_ = _g_object_ref0 (_data_->_tmp1_);
#line 193 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
		_data_->result = _data_->_tmp2_;
#line 193 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
		g_task_return_pointer (_data_->_async_result, _data_, NULL);
#line 193 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
		if (_data_->_state_ != 0) {
#line 193 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
			while (_data_->_task_complete_ != TRUE) {
#line 193 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
				g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
#line 2277 "util-app.c"
			}
		}
#line 193 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
		g_object_unref (_data_->_async_result);
#line 193 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
		return FALSE;
#line 2284 "util-app.c"
	}
#line 195 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
	_data_->_tmp3_ = gvir_connection_new ("qemu+unix:///system");
#line 195 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
	_g_object_unref0 (boxes_system_virt_connection);
#line 195 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
	boxes_system_virt_connection = _data_->_tmp3_;
#line 197 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
	_data_->_tmp4_ = boxes_system_virt_connection;
#line 197 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
	_data_->_state_ = 1;
#line 197 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
	gvir_connection_open_read_only_async (_data_->_tmp4_, NULL, boxes_get_system_virt_connection_ready, _data_);
#line 197 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
	return FALSE;
#line 2300 "util-app.c"
	_state_1:
#line 197 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
	gvir_connection_open_read_only_finish (_data_->_tmp4_, _data_->_res_, &_data_->_inner_error_);
#line 197 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
	if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
#line 197 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
		g_task_return_error (_data_->_async_result, _data_->_inner_error_);
#line 197 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
		g_object_unref (_data_->_async_result);
#line 197 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
		return FALSE;
#line 2312 "util-app.c"
	}
#line 199 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
	g_debug ("util-app.vala:199: Connected to system libvirt, now fetching domains..");
#line 200 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
	_data_->_tmp5_ = boxes_system_virt_connection;
#line 200 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
	_data_->_state_ = 2;
#line 200 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
	gvir_connection_fetch_domains_async (_data_->_tmp5_, NULL, boxes_get_system_virt_connection_ready, _data_);
#line 200 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
	return FALSE;
#line 2324 "util-app.c"
	_state_2:
#line 200 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
	gvir_connection_fetch_domains_finish (_data_->_tmp5_, _data_->_res_, &_data_->_inner_error_);
#line 200 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
	if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
#line 200 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
		g_task_return_error (_data_->_async_result, _data_->_inner_error_);
#line 200 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
		g_object_unref (_data_->_async_result);
#line 200 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
		return FALSE;
#line 2336 "util-app.c"
	}
#line 201 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
	_data_->_tmp6_ = boxes_system_virt_connection;
#line 201 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
	_data_->_state_ = 3;
#line 201 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
	gvir_connection_fetch_networks_async (_data_->_tmp6_, NULL, boxes_get_system_virt_connection_ready, _data_);
#line 201 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
	return FALSE;
#line 2346 "util-app.c"
	_state_3:
#line 201 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
	gvir_connection_fetch_networks_finish (_data_->_tmp6_, _data_->_res_, &_data_->_inner_error_);
#line 201 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
	if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
#line 201 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
		g_task_return_error (_data_->_async_result, _data_->_inner_error_);
#line 201 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
		g_object_unref (_data_->_async_result);
#line 201 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
		return FALSE;
#line 2358 "util-app.c"
	}
#line 203 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
	_data_->_tmp7_ = boxes_system_virt_connection;
#line 203 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
	_data_->_tmp8_ = _g_object_ref0 (_data_->_tmp7_);
#line 203 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
	_data_->result = _data_->_tmp8_;
#line 203 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
#line 203 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
	if (_data_->_state_ != 0) {
#line 203 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
		while (_data_->_task_complete_ != TRUE) {
#line 203 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
#line 2374 "util-app.c"
		}
	}
#line 203 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
	g_object_unref (_data_->_async_result);
#line 203 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
	return FALSE;
#line 2381 "util-app.c"
}


gchar*
boxes_get_logo_path (OsinfoOs* os,
                     gchar** extensions,
                     int extensions_length1)
{
	gchar* result = NULL;
	gchar* path = NULL;
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	GFile* file = NULL;
	const gchar* _tmp7_;
	GFile* _tmp8_;
	GFile* _tmp9_;
	GFile* _tmp18_;
#line 206 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
	g_return_val_if_fail (os != NULL, NULL);
#line 207 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
	if (extensions_length1 == 0) {
#line 208 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
		result = NULL;
#line 208 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
		return result;
#line 2412 "util-app.c"
	}
#line 210 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
	_tmp0_ = osinfo_product_get_short_id ((OsinfoProduct*) os);
#line 210 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
	_tmp1_ = _tmp0_;
#line 210 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
	_tmp2_ = extensions[0];
#line 210 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
	_tmp3_ = g_strconcat (_tmp1_, _tmp2_, NULL);
#line 210 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
	_tmp4_ = _tmp3_;
#line 210 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
	_tmp5_ = boxes_get_pixmap (_tmp4_);
#line 210 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
	_tmp6_ = _tmp5_;
#line 210 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
	_g_free0 (_tmp4_);
#line 210 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
	path = _tmp6_;
#line 211 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
	_tmp7_ = path;
#line 211 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
	_tmp8_ = g_file_new_for_path (_tmp7_);
#line 211 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
	file = _tmp8_;
#line 212 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
	_tmp9_ = file;
#line 212 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
	if (!g_file_query_exists (_tmp9_, NULL)) {
#line 2442 "util-app.c"
		const gchar* _tmp10_;
		const gchar* _tmp11_;
		const gchar* _tmp12_;
		gchar* _tmp13_;
		gchar* _tmp14_;
		gchar* _tmp15_;
		const gchar* _tmp16_;
		GFile* _tmp17_;
#line 213 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
		_tmp10_ = osinfo_os_get_distro (os);
#line 213 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
		_tmp11_ = _tmp10_;
#line 213 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
		_tmp12_ = extensions[0];
#line 213 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
		_tmp13_ = g_strconcat (_tmp11_, _tmp12_, NULL);
#line 213 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
		_tmp14_ = _tmp13_;
#line 213 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
		_tmp15_ = boxes_get_pixmap (_tmp14_);
#line 213 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
		_g_free0 (path);
#line 213 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
		path = _tmp15_;
#line 213 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
		_g_free0 (_tmp14_);
#line 214 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
		_tmp16_ = path;
#line 214 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
		_tmp17_ = g_file_new_for_path (_tmp16_);
#line 214 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
		_g_object_unref0 (file);
#line 214 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
		file = _tmp17_;
#line 2477 "util-app.c"
	}
#line 217 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
	_tmp18_ = file;
#line 217 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
	if (g_file_query_exists (_tmp18_, NULL)) {
#line 218 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
		result = path;
#line 218 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
		_g_object_unref0 (file);
#line 218 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
		return result;
#line 2489 "util-app.c"
	} else {
		gchar* _tmp19_;
#line 220 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
		_tmp19_ = boxes_get_logo_path (os, extensions + 1, extensions_length1 - 1);
#line 220 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
		result = _tmp19_;
#line 220 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
		_g_object_unref0 (file);
#line 220 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
		_g_free0 (path);
#line 220 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
		return result;
#line 2502 "util-app.c"
	}
#line 206 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
	_g_object_unref0 (file);
#line 206 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
	_g_free0 (path);
#line 2508 "util-app.c"
}


static void
boxes_check_selinux_context_default_data_free (gpointer _data)
{
	BoxesCheckSelinuxContextDefaultData* _data_;
	_data_ = _data;
#line 535 "/home/fborges/checkout/gnome-boxes/src/libvirt-machine.vala"
	g_slice_free (BoxesCheckSelinuxContextDefaultData, _data_);
#line 2519 "util-app.c"
}


static void
boxes_check_selinux_context_default_async_ready_wrapper (GObject *source_object,
                                                         GAsyncResult *res,
                                                         void *user_data)
{
	BoxesCheckSelinuxContextDefaultData* _task_data_;
#line 535 "/home/fborges/checkout/gnome-boxes/src/libvirt-machine.vala"
	_task_data_ = g_task_get_task_data (G_TASK (res));
#line 535 "/home/fborges/checkout/gnome-boxes/src/libvirt-machine.vala"
	if (_task_data_->_callback_ != NULL) {
#line 535 "/home/fborges/checkout/gnome-boxes/src/libvirt-machine.vala"
		_task_data_->_callback_ (source_object, res, user_data);
#line 2535 "util-app.c"
	}
#line 535 "/home/fborges/checkout/gnome-boxes/src/libvirt-machine.vala"
	_task_data_->_task_complete_ = TRUE;
#line 2539 "util-app.c"
}


void
boxes_check_selinux_context_default (GAsyncReadyCallback _callback_,
                                     gpointer _user_data_)
{
	BoxesCheckSelinuxContextDefaultData* _data_;
#line 535 "/home/fborges/checkout/gnome-boxes/src/libvirt-machine.vala"
	_data_ = g_slice_new0 (BoxesCheckSelinuxContextDefaultData);
#line 535 "/home/fborges/checkout/gnome-boxes/src/libvirt-machine.vala"
	_data_->_callback_ = _callback_;
#line 535 "/home/fborges/checkout/gnome-boxes/src/libvirt-machine.vala"
	_data_->_async_result = g_task_new (NULL, NULL, boxes_check_selinux_context_default_async_ready_wrapper, _user_data_);
#line 535 "/home/fborges/checkout/gnome-boxes/src/libvirt-machine.vala"
	if (_callback_ == NULL) {
#line 535 "/home/fborges/checkout/gnome-boxes/src/libvirt-machine.vala"
		_data_->_task_complete_ = TRUE;
#line 2558 "util-app.c"
	}
#line 535 "/home/fborges/checkout/gnome-boxes/src/libvirt-machine.vala"
	g_task_set_task_data (_data_->_async_result, _data_, boxes_check_selinux_context_default_data_free);
#line 535 "/home/fborges/checkout/gnome-boxes/src/libvirt-machine.vala"
	boxes_check_selinux_context_default_co (_data_);
#line 2564 "util-app.c"
}


gboolean
boxes_check_selinux_context_default_finish (GAsyncResult* _res_,
                                            gchar* * diagnosis)
{
	gboolean result;
	BoxesCheckSelinuxContextDefaultData* _data_;
#line 535 "/home/fborges/checkout/gnome-boxes/src/libvirt-machine.vala"
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
#line 535 "/home/fborges/checkout/gnome-boxes/src/libvirt-machine.vala"
	if (diagnosis) {
#line 535 "/home/fborges/checkout/gnome-boxes/src/libvirt-machine.vala"
		*diagnosis = _data_->diagnosis;
#line 2580 "util-app.c"
	} else {
#line 535 "/home/fborges/checkout/gnome-boxes/src/libvirt-machine.vala"
		_g_free0 (_data_->diagnosis);
#line 2584 "util-app.c"
	}
#line 535 "/home/fborges/checkout/gnome-boxes/src/libvirt-machine.vala"
	_data_->diagnosis = NULL;
#line 535 "/home/fborges/checkout/gnome-boxes/src/libvirt-machine.vala"
	result = _data_->result;
#line 535 "/home/fborges/checkout/gnome-boxes/src/libvirt-machine.vala"
	return result;
#line 2592 "util-app.c"
}


static void
boxes_check_selinux_context_default_ready (GObject* source_object,
                                           GAsyncResult* _res_,
                                           gpointer _user_data_)
{
	BoxesCheckSelinuxContextDefaultData* _data_;
#line 235 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
	_data_ = _user_data_;
#line 235 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
	_data_->_source_object_ = source_object;
#line 235 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
	_data_->_res_ = _res_;
#line 235 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
	_data_->_task_complete_ = TRUE;
#line 235 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
	boxes_check_selinux_context_default_co (_data_);
#line 2612 "util-app.c"
}


static gchar*
_vala_g_strjoinv (const gchar* separator,
                  gchar** str_array,
                  int str_array_length1)
{
	gchar* result = NULL;
	gboolean _tmp0_ = FALSE;
#line 1092 "/home/fborges/jhbuild/install/share/vala-0.40/vapi/glib-2.0.vapi"
	if (separator == NULL) {
#line 1093 "/home/fborges/jhbuild/install/share/vala-0.40/vapi/glib-2.0.vapi"
		separator = "";
#line 2627 "util-app.c"
	}
#line 1095 "/home/fborges/jhbuild/install/share/vala-0.40/vapi/glib-2.0.vapi"
	if (str_array != NULL) {
#line 2631 "util-app.c"
		gboolean _tmp1_ = FALSE;
#line 1095 "/home/fborges/jhbuild/install/share/vala-0.40/vapi/glib-2.0.vapi"
		if (str_array_length1 > 0) {
#line 1095 "/home/fborges/jhbuild/install/share/vala-0.40/vapi/glib-2.0.vapi"
			_tmp1_ = TRUE;
#line 2637 "util-app.c"
		} else {
			gboolean _tmp2_ = FALSE;
#line 1095 "/home/fborges/jhbuild/install/share/vala-0.40/vapi/glib-2.0.vapi"
			if (str_array_length1 == -1) {
#line 2642 "util-app.c"
				const gchar* _tmp3_;
#line 1095 "/home/fborges/jhbuild/install/share/vala-0.40/vapi/glib-2.0.vapi"
				_tmp3_ = str_array[0];
#line 1095 "/home/fborges/jhbuild/install/share/vala-0.40/vapi/glib-2.0.vapi"
				_tmp2_ = _tmp3_ != NULL;
#line 2648 "util-app.c"
			} else {
#line 1095 "/home/fborges/jhbuild/install/share/vala-0.40/vapi/glib-2.0.vapi"
				_tmp2_ = FALSE;
#line 2652 "util-app.c"
			}
#line 1095 "/home/fborges/jhbuild/install/share/vala-0.40/vapi/glib-2.0.vapi"
			_tmp1_ = _tmp2_;
#line 2656 "util-app.c"
		}
#line 1095 "/home/fborges/jhbuild/install/share/vala-0.40/vapi/glib-2.0.vapi"
		_tmp0_ = _tmp1_;
#line 2660 "util-app.c"
	} else {
#line 1095 "/home/fborges/jhbuild/install/share/vala-0.40/vapi/glib-2.0.vapi"
		_tmp0_ = FALSE;
#line 2664 "util-app.c"
	}
#line 1095 "/home/fborges/jhbuild/install/share/vala-0.40/vapi/glib-2.0.vapi"
	if (_tmp0_) {
#line 2668 "util-app.c"
		gint i = 0;
		gsize len = 0UL;
		gint _tmp20_;
		gint _tmp22_;
		gint _tmp23_;
		gsize _tmp24_;
		gint _tmp25_;
		gint _tmp26_;
		gint _tmp27_;
		const gchar* res = NULL;
		gsize _tmp28_;
		void* _tmp29_;
		void* ptr = NULL;
		const gchar* _tmp30_;
		const gchar* _tmp31_;
		void* _tmp32_;
		const gchar* _tmp45_;
#line 1097 "/home/fborges/jhbuild/install/share/vala-0.40/vapi/glib-2.0.vapi"
		len = (gsize) 1;
#line 2688 "util-app.c"
		{
			gboolean _tmp4_ = FALSE;
#line 1098 "/home/fborges/jhbuild/install/share/vala-0.40/vapi/glib-2.0.vapi"
			i = 0;
#line 1098 "/home/fborges/jhbuild/install/share/vala-0.40/vapi/glib-2.0.vapi"
			_tmp4_ = TRUE;
#line 1098 "/home/fborges/jhbuild/install/share/vala-0.40/vapi/glib-2.0.vapi"
			while (TRUE) {
#line 2697 "util-app.c"
				gboolean _tmp6_ = FALSE;
				gboolean _tmp7_ = FALSE;
				gint _tmp12_ = 0;
				gint _tmp13_;
				const gchar* _tmp14_;
				gsize _tmp19_;
#line 1098 "/home/fborges/jhbuild/install/share/vala-0.40/vapi/glib-2.0.vapi"
				if (!_tmp4_) {
#line 2706 "util-app.c"
					gint _tmp5_;
#line 1098 "/home/fborges/jhbuild/install/share/vala-0.40/vapi/glib-2.0.vapi"
					_tmp5_ = i;
#line 1098 "/home/fborges/jhbuild/install/share/vala-0.40/vapi/glib-2.0.vapi"
					i = _tmp5_ + 1;
#line 2712 "util-app.c"
				}
#line 1098 "/home/fborges/jhbuild/install/share/vala-0.40/vapi/glib-2.0.vapi"
				_tmp4_ = FALSE;
#line 1098 "/home/fborges/jhbuild/install/share/vala-0.40/vapi/glib-2.0.vapi"
				if (str_array_length1 != -1) {
#line 2718 "util-app.c"
					gint _tmp8_;
#line 1098 "/home/fborges/jhbuild/install/share/vala-0.40/vapi/glib-2.0.vapi"
					_tmp8_ = i;
#line 1098 "/home/fborges/jhbuild/install/share/vala-0.40/vapi/glib-2.0.vapi"
					_tmp7_ = _tmp8_ < str_array_length1;
#line 2724 "util-app.c"
				} else {
#line 1098 "/home/fborges/jhbuild/install/share/vala-0.40/vapi/glib-2.0.vapi"
					_tmp7_ = FALSE;
#line 2728 "util-app.c"
				}
#line 1098 "/home/fborges/jhbuild/install/share/vala-0.40/vapi/glib-2.0.vapi"
				if (_tmp7_) {
#line 1098 "/home/fborges/jhbuild/install/share/vala-0.40/vapi/glib-2.0.vapi"
					_tmp6_ = TRUE;
#line 2734 "util-app.c"
				} else {
					gboolean _tmp9_ = FALSE;
#line 1098 "/home/fborges/jhbuild/install/share/vala-0.40/vapi/glib-2.0.vapi"
					if (str_array_length1 == -1) {
#line 2739 "util-app.c"
						gint _tmp10_;
						const gchar* _tmp11_;
#line 1098 "/home/fborges/jhbuild/install/share/vala-0.40/vapi/glib-2.0.vapi"
						_tmp10_ = i;
#line 1098 "/home/fborges/jhbuild/install/share/vala-0.40/vapi/glib-2.0.vapi"
						_tmp11_ = str_array[_tmp10_];
#line 1098 "/home/fborges/jhbuild/install/share/vala-0.40/vapi/glib-2.0.vapi"
						_tmp9_ = _tmp11_ != NULL;
#line 2748 "util-app.c"
					} else {
#line 1098 "/home/fborges/jhbuild/install/share/vala-0.40/vapi/glib-2.0.vapi"
						_tmp9_ = FALSE;
#line 2752 "util-app.c"
					}
#line 1098 "/home/fborges/jhbuild/install/share/vala-0.40/vapi/glib-2.0.vapi"
					_tmp6_ = _tmp9_;
#line 2756 "util-app.c"
				}
#line 1098 "/home/fborges/jhbuild/install/share/vala-0.40/vapi/glib-2.0.vapi"
				if (!_tmp6_) {
#line 1098 "/home/fborges/jhbuild/install/share/vala-0.40/vapi/glib-2.0.vapi"
					break;
#line 2762 "util-app.c"
				}
#line 1099 "/home/fborges/jhbuild/install/share/vala-0.40/vapi/glib-2.0.vapi"
				_tmp13_ = i;
#line 1099 "/home/fborges/jhbuild/install/share/vala-0.40/vapi/glib-2.0.vapi"
				_tmp14_ = str_array[_tmp13_];
#line 1099 "/home/fborges/jhbuild/install/share/vala-0.40/vapi/glib-2.0.vapi"
				if (_tmp14_ != NULL) {
#line 2770 "util-app.c"
					gint _tmp15_;
					const gchar* _tmp16_;
					gint _tmp17_;
					gint _tmp18_;
#line 1099 "/home/fborges/jhbuild/install/share/vala-0.40/vapi/glib-2.0.vapi"
					_tmp15_ = i;
#line 1099 "/home/fborges/jhbuild/install/share/vala-0.40/vapi/glib-2.0.vapi"
					_tmp16_ = str_array[_tmp15_];
#line 1099 "/home/fborges/jhbuild/install/share/vala-0.40/vapi/glib-2.0.vapi"
					_tmp17_ = strlen ((const gchar*) _tmp16_);
#line 1099 "/home/fborges/jhbuild/install/share/vala-0.40/vapi/glib-2.0.vapi"
					_tmp18_ = _tmp17_;
#line 1099 "/home/fborges/jhbuild/install/share/vala-0.40/vapi/glib-2.0.vapi"
					_tmp12_ = _tmp18_;
#line 2785 "util-app.c"
				} else {
#line 1099 "/home/fborges/jhbuild/install/share/vala-0.40/vapi/glib-2.0.vapi"
					_tmp12_ = 0;
#line 2789 "util-app.c"
				}
#line 1099 "/home/fborges/jhbuild/install/share/vala-0.40/vapi/glib-2.0.vapi"
				_tmp19_ = len;
#line 1099 "/home/fborges/jhbuild/install/share/vala-0.40/vapi/glib-2.0.vapi"
				len = _tmp19_ + _tmp12_;
#line 2795 "util-app.c"
			}
		}
#line 1101 "/home/fborges/jhbuild/install/share/vala-0.40/vapi/glib-2.0.vapi"
		_tmp20_ = i;
#line 1101 "/home/fborges/jhbuild/install/share/vala-0.40/vapi/glib-2.0.vapi"
		if (_tmp20_ == 0) {
#line 2802 "util-app.c"
			gchar* _tmp21_;
#line 1102 "/home/fborges/jhbuild/install/share/vala-0.40/vapi/glib-2.0.vapi"
			_tmp21_ = g_strdup ("");
#line 1102 "/home/fborges/jhbuild/install/share/vala-0.40/vapi/glib-2.0.vapi"
			result = _tmp21_;
#line 1102 "/home/fborges/jhbuild/install/share/vala-0.40/vapi/glib-2.0.vapi"
			return result;
#line 2810 "util-app.c"
		}
#line 1104 "/home/fborges/jhbuild/install/share/vala-0.40/vapi/glib-2.0.vapi"
		_tmp22_ = i;
#line 1104 "/home/fborges/jhbuild/install/share/vala-0.40/vapi/glib-2.0.vapi"
		str_array_length1 = _tmp22_;
#line 1104 "/home/fborges/jhbuild/install/share/vala-0.40/vapi/glib-2.0.vapi"
		_tmp23_ = str_array_length1;
#line 1105 "/home/fborges/jhbuild/install/share/vala-0.40/vapi/glib-2.0.vapi"
		_tmp24_ = len;
#line 1105 "/home/fborges/jhbuild/install/share/vala-0.40/vapi/glib-2.0.vapi"
		_tmp25_ = strlen ((const gchar*) separator);
#line 1105 "/home/fborges/jhbuild/install/share/vala-0.40/vapi/glib-2.0.vapi"
		_tmp26_ = _tmp25_;
#line 1105 "/home/fborges/jhbuild/install/share/vala-0.40/vapi/glib-2.0.vapi"
		_tmp27_ = i;
#line 1105 "/home/fborges/jhbuild/install/share/vala-0.40/vapi/glib-2.0.vapi"
		len = _tmp24_ + (_tmp26_ * (_tmp27_ - 1));
#line 1107 "/home/fborges/jhbuild/install/share/vala-0.40/vapi/glib-2.0.vapi"
		_tmp28_ = len;
#line 1107 "/home/fborges/jhbuild/install/share/vala-0.40/vapi/glib-2.0.vapi"
		_tmp29_ = g_malloc (_tmp28_);
#line 1107 "/home/fborges/jhbuild/install/share/vala-0.40/vapi/glib-2.0.vapi"
		res = _tmp29_;
#line 1108 "/home/fborges/jhbuild/install/share/vala-0.40/vapi/glib-2.0.vapi"
		_tmp30_ = res;
#line 1108 "/home/fborges/jhbuild/install/share/vala-0.40/vapi/glib-2.0.vapi"
		_tmp31_ = str_array[0];
#line 1108 "/home/fborges/jhbuild/install/share/vala-0.40/vapi/glib-2.0.vapi"
		_tmp32_ = g_stpcpy ((void*) _tmp30_, (const gchar*) _tmp31_);
#line 1108 "/home/fborges/jhbuild/install/share/vala-0.40/vapi/glib-2.0.vapi"
		ptr = _tmp32_;
#line 2842 "util-app.c"
		{
			gboolean _tmp33_ = FALSE;
#line 1109 "/home/fborges/jhbuild/install/share/vala-0.40/vapi/glib-2.0.vapi"
			i = 1;
#line 1109 "/home/fborges/jhbuild/install/share/vala-0.40/vapi/glib-2.0.vapi"
			_tmp33_ = TRUE;
#line 1109 "/home/fborges/jhbuild/install/share/vala-0.40/vapi/glib-2.0.vapi"
			while (TRUE) {
#line 2851 "util-app.c"
				gint _tmp35_;
				void* _tmp36_;
				void* _tmp37_;
				const gchar* _tmp38_ = NULL;
				gint _tmp39_;
				const gchar* _tmp40_;
				void* _tmp43_;
				void* _tmp44_;
#line 1109 "/home/fborges/jhbuild/install/share/vala-0.40/vapi/glib-2.0.vapi"
				if (!_tmp33_) {
#line 2862 "util-app.c"
					gint _tmp34_;
#line 1109 "/home/fborges/jhbuild/install/share/vala-0.40/vapi/glib-2.0.vapi"
					_tmp34_ = i;
#line 1109 "/home/fborges/jhbuild/install/share/vala-0.40/vapi/glib-2.0.vapi"
					i = _tmp34_ + 1;
#line 2868 "util-app.c"
				}
#line 1109 "/home/fborges/jhbuild/install/share/vala-0.40/vapi/glib-2.0.vapi"
				_tmp33_ = FALSE;
#line 1109 "/home/fborges/jhbuild/install/share/vala-0.40/vapi/glib-2.0.vapi"
				_tmp35_ = i;
#line 1109 "/home/fborges/jhbuild/install/share/vala-0.40/vapi/glib-2.0.vapi"
				if (!(_tmp35_ < str_array_length1)) {
#line 1109 "/home/fborges/jhbuild/install/share/vala-0.40/vapi/glib-2.0.vapi"
					break;
#line 2878 "util-app.c"
				}
#line 1110 "/home/fborges/jhbuild/install/share/vala-0.40/vapi/glib-2.0.vapi"
				_tmp36_ = ptr;
#line 1110 "/home/fborges/jhbuild/install/share/vala-0.40/vapi/glib-2.0.vapi"
				_tmp37_ = g_stpcpy (_tmp36_, (const gchar*) separator);
#line 1110 "/home/fborges/jhbuild/install/share/vala-0.40/vapi/glib-2.0.vapi"
				ptr = _tmp37_;
#line 1111 "/home/fborges/jhbuild/install/share/vala-0.40/vapi/glib-2.0.vapi"
				_tmp39_ = i;
#line 1111 "/home/fborges/jhbuild/install/share/vala-0.40/vapi/glib-2.0.vapi"
				_tmp40_ = str_array[_tmp39_];
#line 1111 "/home/fborges/jhbuild/install/share/vala-0.40/vapi/glib-2.0.vapi"
				if (_tmp40_ != NULL) {
#line 2892 "util-app.c"
					gint _tmp41_;
					const gchar* _tmp42_;
#line 1111 "/home/fborges/jhbuild/install/share/vala-0.40/vapi/glib-2.0.vapi"
					_tmp41_ = i;
#line 1111 "/home/fborges/jhbuild/install/share/vala-0.40/vapi/glib-2.0.vapi"
					_tmp42_ = str_array[_tmp41_];
#line 1111 "/home/fborges/jhbuild/install/share/vala-0.40/vapi/glib-2.0.vapi"
					_tmp38_ = (const gchar*) _tmp42_;
#line 2901 "util-app.c"
				} else {
#line 1111 "/home/fborges/jhbuild/install/share/vala-0.40/vapi/glib-2.0.vapi"
					_tmp38_ = "";
#line 2905 "util-app.c"
				}
#line 1111 "/home/fborges/jhbuild/install/share/vala-0.40/vapi/glib-2.0.vapi"
				_tmp43_ = ptr;
#line 1111 "/home/fborges/jhbuild/install/share/vala-0.40/vapi/glib-2.0.vapi"
				_tmp44_ = g_stpcpy (_tmp43_, _tmp38_);
#line 1111 "/home/fborges/jhbuild/install/share/vala-0.40/vapi/glib-2.0.vapi"
				ptr = _tmp44_;
#line 2913 "util-app.c"
			}
		}
#line 1114 "/home/fborges/jhbuild/install/share/vala-0.40/vapi/glib-2.0.vapi"
		_tmp45_ = res;
#line 1114 "/home/fborges/jhbuild/install/share/vala-0.40/vapi/glib-2.0.vapi"
		res = NULL;
#line 1114 "/home/fborges/jhbuild/install/share/vala-0.40/vapi/glib-2.0.vapi"
		result = (gchar*) _tmp45_;
#line 1114 "/home/fborges/jhbuild/install/share/vala-0.40/vapi/glib-2.0.vapi"
		return result;
#line 2924 "util-app.c"
	} else {
		gchar* _tmp46_;
#line 1116 "/home/fborges/jhbuild/install/share/vala-0.40/vapi/glib-2.0.vapi"
		_tmp46_ = g_strdup ("");
#line 1116 "/home/fborges/jhbuild/install/share/vala-0.40/vapi/glib-2.0.vapi"
		result = _tmp46_;
#line 1116 "/home/fborges/jhbuild/install/share/vala-0.40/vapi/glib-2.0.vapi"
		return result;
#line 2933 "util-app.c"
	}
}


static gboolean
boxes_check_selinux_context_default_co (BoxesCheckSelinuxContextDefaultData* _data_)
{
#line 223 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
	switch (_data_->_state_) {
#line 223 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
		case 0:
#line 2945 "util-app.c"
		goto _state_0;
#line 223 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
		case 1:
#line 2949 "util-app.c"
		goto _state_1;
		default:
#line 223 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
		g_assert_not_reached ();
#line 2954 "util-app.c"
	}
	_state_0:
#line 224 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
	_data_->_tmp0_ = g_strdup ("");
#line 224 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
	_g_free0 (_data_->diagnosis);
#line 224 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
	_data_->diagnosis = _data_->_tmp0_;
#line 2963 "util-app.c"
	{
#line 229 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
		_data_->_tmp1_ = g_strdup ("restorecon");
#line 229 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
		_data_->_tmp2_ = g_strdup ("-nrv");
#line 229 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
		_data_->_tmp3_ = boxes_get_user_pkgconfig (NULL);
#line 229 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
		_data_->_tmp4_ = boxes_get_user_pkgdata (NULL);
#line 229 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
		_data_->_tmp5_ = boxes_get_user_pkgcache (NULL);
#line 229 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
		_data_->_tmp6_ = g_new0 (gchar*, 5 + 1);
#line 229 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
		_data_->_tmp6_[0] = _data_->_tmp1_;
#line 229 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
		_data_->_tmp6_[1] = _data_->_tmp2_;
#line 229 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
		_data_->_tmp6_[2] = _data_->_tmp3_;
#line 229 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
		_data_->_tmp6_[3] = _data_->_tmp4_;
#line 229 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
		_data_->_tmp6_[4] = _data_->_tmp5_;
#line 229 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
		_data_->argv = _data_->_tmp6_;
#line 229 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
		_data_->argv_length1 = 5;
#line 229 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
		_data_->_argv_size_ = _data_->argv_length1;
#line 235 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
		_data_->_tmp7_ = _data_->argv;
#line 235 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
		_data_->_tmp7__length1 = _data_->argv_length1;
#line 235 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
		_data_->_tmp8_ = NULL;
#line 235 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
		_data_->_state_ = 1;
#line 235 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
		boxes_exec (_data_->_tmp7_, _data_->_tmp7__length1, NULL, boxes_check_selinux_context_default_ready, _data_);
#line 235 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
		return FALSE;
#line 3005 "util-app.c"
		_state_1:
#line 235 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
		boxes_exec_finish (_data_->_res_, &_data_->_tmp8_, NULL, &_data_->_inner_error_);
#line 235 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
		_g_free0 (_data_->standard_output);
#line 235 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
		_data_->standard_output = _data_->_tmp8_;
#line 235 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
		if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
#line 235 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
			_data_->argv = (_vala_array_free (_data_->argv, _data_->argv_length1, (GDestroyNotify) g_free), NULL);
#line 235 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
			_g_free0 (_data_->standard_output);
#line 235 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
			if (g_error_matches (_data_->_inner_error_, G_SPAWN_ERROR, G_SPAWN_ERROR_NOEXEC)) {
#line 3021 "util-app.c"
				goto __catch103_g_spawn_error_noexec;
			}
			goto __catch103_g_error;
		}
#line 237 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
		_data_->_tmp9_ = _data_->standard_output;
#line 237 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
		_data_->_tmp10_ = strlen (_data_->_tmp9_);
#line 237 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
		_data_->_tmp11_ = _data_->_tmp10_;
#line 237 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
		if (_data_->_tmp11_ == 0) {
#line 238 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
			_data_->result = TRUE;
#line 238 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
			_data_->argv = (_vala_array_free (_data_->argv, _data_->argv_length1, (GDestroyNotify) g_free), NULL);
#line 238 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
			_g_free0 (_data_->standard_output);
#line 238 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
			g_task_return_pointer (_data_->_async_result, _data_, NULL);
#line 238 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
			if (_data_->_state_ != 0) {
#line 238 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
				while (_data_->_task_complete_ != TRUE) {
#line 238 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
					g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
#line 3048 "util-app.c"
				}
			}
#line 238 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
			g_object_unref (_data_->_async_result);
#line 238 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
			return FALSE;
#line 3055 "util-app.c"
		}
#line 240 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
		_data_->_tmp12_ = _data_->argv;
#line 240 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
		_data_->_tmp12__length1 = _data_->argv_length1;
#line 240 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
		_data_->_tmp13_ = g_strdup ("-r");
#line 240 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
		_g_free0 (_data_->_tmp12_[1]);
#line 240 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
		_data_->_tmp12_[1] = _data_->_tmp13_;
#line 240 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
		_data_->_tmp14_ = _data_->_tmp12_[1];
#line 242 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
		_data_->_tmp15_ = _data_->argv;
#line 242 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
		_data_->_tmp15__length1 = _data_->argv_length1;
#line 242 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
		_data_->_tmp16_ = _vala_g_strjoinv (" ", _data_->_tmp15_, _data_->_tmp15__length1);
#line 242 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
		_data_->_tmp17_ = _data_->_tmp16_;
#line 242 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
		_data_->_tmp18_ = g_strdup_printf (_ ("Your SELinux context looks incorrect, you can try to fix it by running" \
":\n" \
"%s"), _data_->_tmp17_);
#line 242 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
		_g_free0 (_data_->diagnosis);
#line 242 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
		_data_->diagnosis = _data_->_tmp18_;
#line 242 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
		_g_free0 (_data_->_tmp17_);
#line 243 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
		_data_->result = FALSE;
#line 243 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
		_data_->argv = (_vala_array_free (_data_->argv, _data_->argv_length1, (GDestroyNotify) g_free), NULL);
#line 243 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
		_g_free0 (_data_->standard_output);
#line 243 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
		g_task_return_pointer (_data_->_async_result, _data_, NULL);
#line 243 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
		if (_data_->_state_ != 0) {
#line 243 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
			while (_data_->_task_complete_ != TRUE) {
#line 243 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
				g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
#line 3099 "util-app.c"
			}
		}
#line 243 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
		g_object_unref (_data_->_async_result);
#line 243 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
		return FALSE;
#line 3106 "util-app.c"
	}
	goto __finally103;
	__catch103_g_spawn_error_noexec:
	{
#line 226 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
		_data_->_error_ = _data_->_inner_error_;
#line 226 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
		_data_->_inner_error_ = NULL;
#line 246 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
		_data_->_tmp19_ = g_strdup (_ ("SELinux not installed?"));
#line 246 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
		_g_free0 (_data_->diagnosis);
#line 246 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
		_data_->diagnosis = _data_->_tmp19_;
#line 247 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
		_data_->result = TRUE;
#line 247 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
		_g_error_free0 (_data_->_error_);
#line 247 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
		g_task_return_pointer (_data_->_async_result, _data_, NULL);
#line 247 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
		if (_data_->_state_ != 0) {
#line 247 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
			while (_data_->_task_complete_ != TRUE) {
#line 247 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
				g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
#line 3133 "util-app.c"
			}
		}
#line 247 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
		g_object_unref (_data_->_async_result);
#line 247 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
		return FALSE;
#line 3140 "util-app.c"
	}
	goto __finally103;
	__catch103_g_error:
	{
#line 226 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
		_data_->_vala1__error_ = _data_->_inner_error_;
#line 226 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
		_data_->_inner_error_ = NULL;
#line 250 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
		_data_->_tmp20_ = _data_->_vala1__error_;
#line 250 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
		_data_->_tmp21_ = _data_->_tmp20_->message;
#line 250 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
		g_warning ("util-app.vala:250: %s", _data_->_tmp21_);
#line 226 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
		_g_error_free0 (_data_->_vala1__error_);
#line 3157 "util-app.c"
	}
	__finally103:
#line 226 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
	if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
#line 226 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
#line 226 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
		g_clear_error (&_data_->_inner_error_);
#line 226 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
		g_object_unref (_data_->_async_result);
#line 226 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
		return FALSE;
#line 3170 "util-app.c"
	}
#line 253 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
	_data_->result = FALSE;
#line 253 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
#line 253 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
	if (_data_->_state_ != 0) {
#line 253 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
		while (_data_->_task_complete_ != TRUE) {
#line 253 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
#line 3182 "util-app.c"
		}
	}
#line 253 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
	g_object_unref (_data_->_async_result);
#line 253 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
	return FALSE;
#line 3189 "util-app.c"
}


static void
boxes_check_libvirt_kvm_data_free (gpointer _data)
{
	BoxesCheckLibvirtKvmData* _data_;
	_data_ = _data;
#line 535 "/home/fborges/checkout/gnome-boxes/src/libvirt-machine.vala"
	g_slice_free (BoxesCheckLibvirtKvmData, _data_);
#line 3200 "util-app.c"
}


static void
boxes_check_libvirt_kvm_async_ready_wrapper (GObject *source_object,
                                             GAsyncResult *res,
                                             void *user_data)
{
	BoxesCheckLibvirtKvmData* _task_data_;
#line 535 "/home/fborges/checkout/gnome-boxes/src/libvirt-machine.vala"
	_task_data_ = g_task_get_task_data (G_TASK (res));
#line 535 "/home/fborges/checkout/gnome-boxes/src/libvirt-machine.vala"
	if (_task_data_->_callback_ != NULL) {
#line 535 "/home/fborges/checkout/gnome-boxes/src/libvirt-machine.vala"
		_task_data_->_callback_ (source_object, res, user_data);
#line 3216 "util-app.c"
	}
#line 535 "/home/fborges/checkout/gnome-boxes/src/libvirt-machine.vala"
	_task_data_->_task_complete_ = TRUE;
#line 3220 "util-app.c"
}


void
boxes_check_libvirt_kvm (GAsyncReadyCallback _callback_,
                         gpointer _user_data_)
{
	BoxesCheckLibvirtKvmData* _data_;
#line 535 "/home/fborges/checkout/gnome-boxes/src/libvirt-machine.vala"
	_data_ = g_slice_new0 (BoxesCheckLibvirtKvmData);
#line 535 "/home/fborges/checkout/gnome-boxes/src/libvirt-machine.vala"
	_data_->_callback_ = _callback_;
#line 535 "/home/fborges/checkout/gnome-boxes/src/libvirt-machine.vala"
	_data_->_async_result = g_task_new (NULL, NULL, boxes_check_libvirt_kvm_async_ready_wrapper, _user_data_);
#line 535 "/home/fborges/checkout/gnome-boxes/src/libvirt-machine.vala"
	if (_callback_ == NULL) {
#line 535 "/home/fborges/checkout/gnome-boxes/src/libvirt-machine.vala"
		_data_->_task_complete_ = TRUE;
#line 3239 "util-app.c"
	}
#line 535 "/home/fborges/checkout/gnome-boxes/src/libvirt-machine.vala"
	g_task_set_task_data (_data_->_async_result, _data_, boxes_check_libvirt_kvm_data_free);
#line 535 "/home/fborges/checkout/gnome-boxes/src/libvirt-machine.vala"
	boxes_check_libvirt_kvm_co (_data_);
#line 3245 "util-app.c"
}


gboolean
boxes_check_libvirt_kvm_finish (GAsyncResult* _res_)
{
	gboolean result;
	BoxesCheckLibvirtKvmData* _data_;
#line 535 "/home/fborges/checkout/gnome-boxes/src/libvirt-machine.vala"
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
#line 535 "/home/fborges/checkout/gnome-boxes/src/libvirt-machine.vala"
	result = _data_->result;
#line 535 "/home/fborges/checkout/gnome-boxes/src/libvirt-machine.vala"
	return result;
#line 3260 "util-app.c"
}


static void
boxes_check_libvirt_kvm_ready (GObject* source_object,
                               GAsyncResult* _res_,
                               gpointer _user_data_)
{
	BoxesCheckLibvirtKvmData* _data_;
#line 262 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
	_data_ = _user_data_;
#line 262 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
	_data_->_source_object_ = source_object;
#line 262 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
	_data_->_res_ = _res_;
#line 262 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
	_data_->_task_complete_ = TRUE;
#line 262 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
	boxes_check_libvirt_kvm_co (_data_);
#line 3280 "util-app.c"
}


static gboolean
boxes_check_libvirt_kvm_co (BoxesCheckLibvirtKvmData* _data_)
{
#line 256 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
	switch (_data_->_state_) {
#line 256 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
		case 0:
#line 3291 "util-app.c"
		goto _state_0;
#line 256 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
		case 1:
#line 3295 "util-app.c"
		goto _state_1;
		default:
#line 256 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
		g_assert_not_reached ();
#line 3300 "util-app.c"
	}
	_state_0:
	{
#line 260 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
		_data_->_tmp0_ = g_strdup ("virsh");
#line 260 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
		_data_->_tmp1_ = g_strdup ("capabilities");
#line 260 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
		_data_->_tmp2_ = g_new0 (gchar*, 2 + 1);
#line 260 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
		_data_->_tmp2_[0] = _data_->_tmp0_;
#line 260 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
		_data_->_tmp2_[1] = _data_->_tmp1_;
#line 260 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
		_data_->argv = _data_->_tmp2_;
#line 260 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
		_data_->argv_length1 = 2;
#line 260 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
		_data_->_argv_size_ = _data_->argv_length1;
#line 262 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
		_data_->_tmp3_ = _data_->argv;
#line 262 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
		_data_->_tmp3__length1 = _data_->argv_length1;
#line 262 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
		_data_->_tmp4_ = NULL;
#line 262 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
		_data_->_state_ = 1;
#line 262 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
		boxes_exec (_data_->_tmp3_, _data_->_tmp3__length1, NULL, boxes_check_libvirt_kvm_ready, _data_);
#line 262 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
		return FALSE;
#line 3332 "util-app.c"
		_state_1:
#line 262 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
		boxes_exec_finish (_data_->_res_, &_data_->_tmp4_, NULL, &_data_->_inner_error_);
#line 262 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
		_g_free0 (_data_->standard_output);
#line 262 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
		_data_->standard_output = _data_->_tmp4_;
#line 262 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
		if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
#line 262 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
			_data_->argv = (_vala_array_free (_data_->argv, _data_->argv_length1, (GDestroyNotify) g_free), NULL);
#line 262 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
			_g_free0 (_data_->standard_output);
#line 262 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
			if (g_error_matches (_data_->_inner_error_, G_SPAWN_ERROR, G_SPAWN_ERROR_NOEXEC)) {
#line 3348 "util-app.c"
				goto __catch104_g_spawn_error_noexec;
			}
			goto __catch104_g_error;
		}
#line 263 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
		_data_->_tmp5_ = _data_->standard_output;
#line 263 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
		_data_->_tmp6_ = boxes_extract_xpath (_data_->_tmp5_, "string(/capabilities/guest[os_type='hvm']/arch/domain[@type='kvm']/emu" \
"lator)", FALSE, &_data_->_inner_error_);
#line 263 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
		_data_->kvm = _data_->_tmp6_;
#line 263 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
		if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
#line 263 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
			_data_->argv = (_vala_array_free (_data_->argv, _data_->argv_length1, (GDestroyNotify) g_free), NULL);
#line 263 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
			_g_free0 (_data_->standard_output);
#line 263 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
			if (g_error_matches (_data_->_inner_error_, G_SPAWN_ERROR, G_SPAWN_ERROR_NOEXEC)) {
#line 3367 "util-app.c"
				goto __catch104_g_spawn_error_noexec;
			}
			goto __catch104_g_error;
		}
#line 265 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
		_data_->_tmp7_ = _data_->kvm;
#line 265 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
		_data_->_tmp8_ = strlen (_data_->_tmp7_);
#line 265 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
		_data_->_tmp9_ = _data_->_tmp8_;
#line 265 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
		_data_->result = _data_->_tmp9_ != 0;
#line 265 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
		_g_free0 (_data_->kvm);
#line 265 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
		_data_->argv = (_vala_array_free (_data_->argv, _data_->argv_length1, (GDestroyNotify) g_free), NULL);
#line 265 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
		_g_free0 (_data_->standard_output);
#line 265 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
		g_task_return_pointer (_data_->_async_result, _data_, NULL);
#line 265 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
		if (_data_->_state_ != 0) {
#line 265 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
			while (_data_->_task_complete_ != TRUE) {
#line 265 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
				g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
#line 3394 "util-app.c"
			}
		}
#line 265 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
		g_object_unref (_data_->_async_result);
#line 265 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
		return FALSE;
#line 3401 "util-app.c"
	}
	goto __finally104;
	__catch104_g_spawn_error_noexec:
	{
#line 257 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
		_data_->_error_ = _data_->_inner_error_;
#line 257 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
		_data_->_inner_error_ = NULL;
#line 268 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
		g_critical ("util-app.vala:268: libvirt is not installed correctly");
#line 257 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
		_g_error_free0 (_data_->_error_);
#line 3414 "util-app.c"
	}
	goto __finally104;
	__catch104_g_error:
	{
#line 257 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
		_data_->_vala1__error_ = _data_->_inner_error_;
#line 257 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
		_data_->_inner_error_ = NULL;
#line 270 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
		_data_->_tmp10_ = _data_->_vala1__error_;
#line 270 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
		_data_->_tmp11_ = _data_->_tmp10_->message;
#line 270 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
		g_warning ("util-app.vala:270: %s", _data_->_tmp11_);
#line 257 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
		_g_error_free0 (_data_->_vala1__error_);
#line 3431 "util-app.c"
	}
	__finally104:
#line 257 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
	if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
#line 257 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
#line 257 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
		g_clear_error (&_data_->_inner_error_);
#line 257 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
		g_object_unref (_data_->_async_result);
#line 257 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
		return FALSE;
#line 3444 "util-app.c"
	}
#line 273 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
	_data_->result = FALSE;
#line 273 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
#line 273 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
	if (_data_->_state_ != 0) {
#line 273 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
		while (_data_->_task_complete_ != TRUE) {
#line 273 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
#line 3456 "util-app.c"
		}
	}
#line 273 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
	g_object_unref (_data_->_async_result);
#line 273 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
	return FALSE;
#line 3463 "util-app.c"
}


static void
boxes_check_cpu_vt_capability_data_free (gpointer _data)
{
	BoxesCheckCpuVtCapabilityData* _data_;
	_data_ = _data;
#line 535 "/home/fborges/checkout/gnome-boxes/src/libvirt-machine.vala"
	g_slice_free (BoxesCheckCpuVtCapabilityData, _data_);
#line 3474 "util-app.c"
}


static void
boxes_check_cpu_vt_capability_async_ready_wrapper (GObject *source_object,
                                                   GAsyncResult *res,
                                                   void *user_data)
{
	BoxesCheckCpuVtCapabilityData* _task_data_;
#line 535 "/home/fborges/checkout/gnome-boxes/src/libvirt-machine.vala"
	_task_data_ = g_task_get_task_data (G_TASK (res));
#line 535 "/home/fborges/checkout/gnome-boxes/src/libvirt-machine.vala"
	if (_task_data_->_callback_ != NULL) {
#line 535 "/home/fborges/checkout/gnome-boxes/src/libvirt-machine.vala"
		_task_data_->_callback_ (source_object, res, user_data);
#line 3490 "util-app.c"
	}
#line 535 "/home/fborges/checkout/gnome-boxes/src/libvirt-machine.vala"
	_task_data_->_task_complete_ = TRUE;
#line 3494 "util-app.c"
}


void
boxes_check_cpu_vt_capability (GAsyncReadyCallback _callback_,
                               gpointer _user_data_)
{
	BoxesCheckCpuVtCapabilityData* _data_;
#line 535 "/home/fborges/checkout/gnome-boxes/src/libvirt-machine.vala"
	_data_ = g_slice_new0 (BoxesCheckCpuVtCapabilityData);
#line 535 "/home/fborges/checkout/gnome-boxes/src/libvirt-machine.vala"
	_data_->_callback_ = _callback_;
#line 535 "/home/fborges/checkout/gnome-boxes/src/libvirt-machine.vala"
	_data_->_async_result = g_task_new (NULL, NULL, boxes_check_cpu_vt_capability_async_ready_wrapper, _user_data_);
#line 535 "/home/fborges/checkout/gnome-boxes/src/libvirt-machine.vala"
	if (_callback_ == NULL) {
#line 535 "/home/fborges/checkout/gnome-boxes/src/libvirt-machine.vala"
		_data_->_task_complete_ = TRUE;
#line 3513 "util-app.c"
	}
#line 535 "/home/fborges/checkout/gnome-boxes/src/libvirt-machine.vala"
	g_task_set_task_data (_data_->_async_result, _data_, boxes_check_cpu_vt_capability_data_free);
#line 535 "/home/fborges/checkout/gnome-boxes/src/libvirt-machine.vala"
	boxes_check_cpu_vt_capability_co (_data_);
#line 3519 "util-app.c"
}


gboolean
boxes_check_cpu_vt_capability_finish (GAsyncResult* _res_)
{
	gboolean result;
	BoxesCheckCpuVtCapabilityData* _data_;
#line 535 "/home/fborges/checkout/gnome-boxes/src/libvirt-machine.vala"
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
#line 535 "/home/fborges/checkout/gnome-boxes/src/libvirt-machine.vala"
	result = _data_->result;
#line 535 "/home/fborges/checkout/gnome-boxes/src/libvirt-machine.vala"
	return result;
#line 3534 "util-app.c"
}


static void
boxes_check_cpu_vt_capability_ready (GObject* source_object,
                                     GAsyncResult* _res_,
                                     gpointer _user_data_)
{
	BoxesCheckCpuVtCapabilityData* _data_;
#line 283 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
	_data_ = _user_data_;
#line 283 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
	_data_->_source_object_ = source_object;
#line 283 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
	_data_->_res_ = _res_;
#line 283 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
	_data_->_task_complete_ = TRUE;
#line 283 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
	boxes_check_cpu_vt_capability_co (_data_);
#line 3554 "util-app.c"
}


static inline GRegex*
_thread_safe_regex_init (GRegex** re,
                         const gchar * pattern,
                         GRegexMatchFlags match_options)
{
#line 284 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
	if (g_once_init_enter ((volatile gsize*) re)) {
#line 284 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
		GRegex* val = g_regex_new (pattern, match_options, 0, NULL);
#line 284 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
		g_once_init_leave ((volatile gsize*) re, (gsize) val);
#line 3569 "util-app.c"
	}
#line 284 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
	return *re;
#line 3573 "util-app.c"
}


static gboolean
boxes_check_cpu_vt_capability_co (BoxesCheckCpuVtCapabilityData* _data_)
{
#line 276 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
	switch (_data_->_state_) {
#line 276 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
		case 0:
#line 3584 "util-app.c"
		goto _state_0;
#line 276 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
		case 1:
#line 3588 "util-app.c"
		goto _state_1;
		default:
#line 276 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
		g_assert_not_reached ();
#line 3593 "util-app.c"
	}
	_state_0:
#line 277 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
	_data_->_result_ = FALSE;
#line 278 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
	_data_->_tmp0_ = g_file_new_for_path ("/proc/cpuinfo");
#line 278 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
	_data_->file = _data_->_tmp0_;
#line 3602 "util-app.c"
	{
#line 281 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
		_data_->_tmp2_ = _data_->file;
#line 281 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
		_data_->_tmp3_ = g_file_read (_data_->_tmp2_, NULL, &_data_->_inner_error_);
#line 281 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
		_data_->_tmp1_ = _data_->_tmp3_;
#line 281 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
		if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
#line 3612 "util-app.c"
			goto __catch105_g_error;
		}
#line 281 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
		_data_->_tmp4_ = g_data_input_stream_new ((GInputStream*) _data_->_tmp1_);
#line 281 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
		_data_->stream = _data_->_tmp4_;
#line 282 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
		_data_->line = NULL;
#line 283 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
		while (TRUE) {
#line 283 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
			_data_->_tmp6_ = _data_->stream;
#line 283 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
			_data_->_state_ = 1;
#line 283 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
			g_data_input_stream_read_line_async (_data_->_tmp6_, G_PRIORITY_DEFAULT, NULL, boxes_check_cpu_vt_capability_ready, _data_);
#line 283 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
			return FALSE;
#line 3631 "util-app.c"
			_state_1:
#line 283 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
			_data_->_tmp7_ = g_data_input_stream_read_line_finish (_data_->_tmp6_, _data_->_res_, NULL, &_data_->_inner_error_);
#line 283 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
			_data_->_tmp5_ = _data_->_tmp7_;
#line 283 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
			if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
#line 283 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
				_g_free0 (_data_->line);
#line 283 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
				_g_object_unref0 (_data_->stream);
#line 283 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
				_g_object_unref0 (_data_->_tmp1_);
#line 3645 "util-app.c"
				goto __catch105_g_error;
			}
#line 283 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
			_data_->_tmp8_ = _data_->_tmp5_;
#line 283 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
			_data_->_tmp5_ = NULL;
#line 283 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
			_g_free0 (_data_->line);
#line 283 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
			_data_->line = _data_->_tmp8_;
#line 283 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
			_data_->_tmp9_ = _data_->line;
#line 283 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
			if (!(_data_->_tmp9_ != NULL)) {
#line 283 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
				_g_free0 (_data_->_tmp5_);
#line 283 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
				break;
#line 3664 "util-app.c"
			}
#line 284 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
			_data_->_tmp10_ = _data_->line;
#line 284 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
			_data_->_tmp11_ = g_regex_match (_thread_safe_regex_init (&_tmp_regex_0, "^flags.*(vmx|svm)", 0), _data_->_tmp10_, 0, NULL);
#line 284 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
			_data_->_result_ = _data_->_tmp11_;
#line 285 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
			_data_->_tmp12_ = _data_->_result_;
#line 285 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
			if (_data_->_tmp12_) {
#line 286 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
				_g_free0 (_data_->_tmp5_);
#line 286 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
				break;
#line 3680 "util-app.c"
			}
#line 283 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
			_g_free0 (_data_->_tmp5_);
#line 3684 "util-app.c"
		}
#line 280 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
		_g_free0 (_data_->line);
#line 280 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
		_g_object_unref0 (_data_->stream);
#line 280 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
		_g_object_unref0 (_data_->_tmp1_);
#line 3692 "util-app.c"
	}
	goto __finally105;
	__catch105_g_error:
	{
#line 280 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
		_data_->_error_ = _data_->_inner_error_;
#line 280 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
		_data_->_inner_error_ = NULL;
#line 289 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
		_data_->_tmp13_ = _data_->_error_;
#line 289 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
		_data_->_tmp14_ = _data_->_tmp13_->message;
#line 289 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
		g_warning ("util-app.vala:289: Failed to read file /proc/cpuinfo: %s", _data_->_tmp14_);
#line 280 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
		_g_error_free0 (_data_->_error_);
#line 3709 "util-app.c"
	}
	__finally105:
#line 280 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
	if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
#line 280 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
		_g_object_unref0 (_data_->file);
#line 280 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
#line 280 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
		g_clear_error (&_data_->_inner_error_);
#line 280 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
		g_object_unref (_data_->_async_result);
#line 280 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
		return FALSE;
#line 3724 "util-app.c"
	}
#line 292 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
	_data_->_tmp15_ = _data_->_result_;
#line 292 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
	_data_->_tmp16_ = boxes_yes_no (_data_->_tmp15_);
#line 292 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
	_data_->_tmp17_ = _data_->_tmp16_;
#line 292 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
	_data_->_tmp18_ = g_strconcat ("check_cpu_vt_capability: ", _data_->_tmp17_, NULL);
#line 292 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
	_data_->_tmp19_ = _data_->_tmp18_;
#line 292 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
	g_debug ("util-app.vala:292: %s", _data_->_tmp19_);
#line 292 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
	_g_free0 (_data_->_tmp19_);
#line 292 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
	_g_free0 (_data_->_tmp17_);
#line 293 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
	_data_->result = _data_->_result_;
#line 293 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
	_g_object_unref0 (_data_->file);
#line 293 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
#line 293 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
	if (_data_->_state_ != 0) {
#line 293 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
		while (_data_->_task_complete_ != TRUE) {
#line 293 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
#line 3754 "util-app.c"
		}
	}
#line 293 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
	g_object_unref (_data_->_async_result);
#line 293 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
	return FALSE;
#line 3761 "util-app.c"
}


static void
boxes_check_module_kvm_loaded_data_free (gpointer _data)
{
	BoxesCheckModuleKvmLoadedData* _data_;
	_data_ = _data;
#line 535 "/home/fborges/checkout/gnome-boxes/src/libvirt-machine.vala"
	g_slice_free (BoxesCheckModuleKvmLoadedData, _data_);
#line 3772 "util-app.c"
}


static void
boxes_check_module_kvm_loaded_async_ready_wrapper (GObject *source_object,
                                                   GAsyncResult *res,
                                                   void *user_data)
{
	BoxesCheckModuleKvmLoadedData* _task_data_;
#line 535 "/home/fborges/checkout/gnome-boxes/src/libvirt-machine.vala"
	_task_data_ = g_task_get_task_data (G_TASK (res));
#line 535 "/home/fborges/checkout/gnome-boxes/src/libvirt-machine.vala"
	if (_task_data_->_callback_ != NULL) {
#line 535 "/home/fborges/checkout/gnome-boxes/src/libvirt-machine.vala"
		_task_data_->_callback_ (source_object, res, user_data);
#line 3788 "util-app.c"
	}
#line 535 "/home/fborges/checkout/gnome-boxes/src/libvirt-machine.vala"
	_task_data_->_task_complete_ = TRUE;
#line 3792 "util-app.c"
}


void
boxes_check_module_kvm_loaded (GAsyncReadyCallback _callback_,
                               gpointer _user_data_)
{
	BoxesCheckModuleKvmLoadedData* _data_;
#line 535 "/home/fborges/checkout/gnome-boxes/src/libvirt-machine.vala"
	_data_ = g_slice_new0 (BoxesCheckModuleKvmLoadedData);
#line 535 "/home/fborges/checkout/gnome-boxes/src/libvirt-machine.vala"
	_data_->_callback_ = _callback_;
#line 535 "/home/fborges/checkout/gnome-boxes/src/libvirt-machine.vala"
	_data_->_async_result = g_task_new (NULL, NULL, boxes_check_module_kvm_loaded_async_ready_wrapper, _user_data_);
#line 535 "/home/fborges/checkout/gnome-boxes/src/libvirt-machine.vala"
	if (_callback_ == NULL) {
#line 535 "/home/fborges/checkout/gnome-boxes/src/libvirt-machine.vala"
		_data_->_task_complete_ = TRUE;
#line 3811 "util-app.c"
	}
#line 535 "/home/fborges/checkout/gnome-boxes/src/libvirt-machine.vala"
	g_task_set_task_data (_data_->_async_result, _data_, boxes_check_module_kvm_loaded_data_free);
#line 535 "/home/fborges/checkout/gnome-boxes/src/libvirt-machine.vala"
	boxes_check_module_kvm_loaded_co (_data_);
#line 3817 "util-app.c"
}


gboolean
boxes_check_module_kvm_loaded_finish (GAsyncResult* _res_)
{
	gboolean result;
	BoxesCheckModuleKvmLoadedData* _data_;
#line 535 "/home/fborges/checkout/gnome-boxes/src/libvirt-machine.vala"
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
#line 535 "/home/fborges/checkout/gnome-boxes/src/libvirt-machine.vala"
	result = _data_->result;
#line 535 "/home/fborges/checkout/gnome-boxes/src/libvirt-machine.vala"
	return result;
#line 3832 "util-app.c"
}


static void
boxes_check_module_kvm_loaded_ready (GObject* source_object,
                                     GAsyncResult* _res_,
                                     gpointer _user_data_)
{
	BoxesCheckModuleKvmLoadedData* _data_;
#line 303 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
	_data_ = _user_data_;
#line 303 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
	_data_->_source_object_ = source_object;
#line 303 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
	_data_->_res_ = _res_;
#line 303 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
	_data_->_task_complete_ = TRUE;
#line 303 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
	boxes_check_module_kvm_loaded_co (_data_);
#line 3852 "util-app.c"
}


static gboolean
boxes_check_module_kvm_loaded_co (BoxesCheckModuleKvmLoadedData* _data_)
{
#line 296 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
	switch (_data_->_state_) {
#line 296 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
		case 0:
#line 3863 "util-app.c"
		goto _state_0;
#line 296 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
		case 1:
#line 3867 "util-app.c"
		goto _state_1;
		default:
#line 296 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
		g_assert_not_reached ();
#line 3872 "util-app.c"
	}
	_state_0:
#line 297 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
	_data_->_result_ = FALSE;
#line 298 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
	_data_->_tmp0_ = g_file_new_for_path ("/proc/modules");
#line 298 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
	_data_->file = _data_->_tmp0_;
#line 3881 "util-app.c"
	{
#line 301 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
		_data_->_tmp2_ = _data_->file;
#line 301 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
		_data_->_tmp3_ = g_file_read (_data_->_tmp2_, NULL, &_data_->_inner_error_);
#line 301 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
		_data_->_tmp1_ = _data_->_tmp3_;
#line 301 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
		if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
#line 3891 "util-app.c"
			goto __catch106_g_error;
		}
#line 301 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
		_data_->_tmp4_ = g_data_input_stream_new ((GInputStream*) _data_->_tmp1_);
#line 301 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
		_data_->stream = _data_->_tmp4_;
#line 302 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
		_data_->line = NULL;
#line 303 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
		while (TRUE) {
#line 303 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
			_data_->_tmp6_ = _data_->stream;
#line 303 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
			_data_->_state_ = 1;
#line 303 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
			g_data_input_stream_read_line_async (_data_->_tmp6_, G_PRIORITY_DEFAULT, NULL, boxes_check_module_kvm_loaded_ready, _data_);
#line 303 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
			return FALSE;
#line 3910 "util-app.c"
			_state_1:
#line 303 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
			_data_->_tmp7_ = g_data_input_stream_read_line_finish (_data_->_tmp6_, _data_->_res_, NULL, &_data_->_inner_error_);
#line 303 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
			_data_->_tmp5_ = _data_->_tmp7_;
#line 303 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
			if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
#line 303 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
				_g_free0 (_data_->line);
#line 303 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
				_g_object_unref0 (_data_->stream);
#line 303 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
				_g_object_unref0 (_data_->_tmp1_);
#line 3924 "util-app.c"
				goto __catch106_g_error;
			}
#line 303 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
			_data_->_tmp8_ = _data_->_tmp5_;
#line 303 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
			_data_->_tmp5_ = NULL;
#line 303 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
			_g_free0 (_data_->line);
#line 303 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
			_data_->line = _data_->_tmp8_;
#line 303 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
			_data_->_tmp9_ = _data_->line;
#line 303 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
			if (!(_data_->_tmp9_ != NULL)) {
#line 303 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
				_g_free0 (_data_->_tmp5_);
#line 303 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
				break;
#line 3943 "util-app.c"
			}
#line 304 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
			_data_->_tmp10_ = _data_->line;
#line 304 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
			_data_->_tmp11_ = g_regex_match (_thread_safe_regex_init (&_tmp_regex_1, "^(kvm_intel|kvm_amd)", 0), _data_->_tmp10_, 0, NULL);
#line 304 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
			_data_->_result_ = _data_->_tmp11_;
#line 305 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
			_data_->_tmp12_ = _data_->_result_;
#line 305 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
			if (_data_->_tmp12_) {
#line 306 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
				_g_free0 (_data_->_tmp5_);
#line 306 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
				break;
#line 3959 "util-app.c"
			}
#line 303 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
			_g_free0 (_data_->_tmp5_);
#line 3963 "util-app.c"
		}
#line 300 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
		_g_free0 (_data_->line);
#line 300 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
		_g_object_unref0 (_data_->stream);
#line 300 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
		_g_object_unref0 (_data_->_tmp1_);
#line 3971 "util-app.c"
	}
	goto __finally106;
	__catch106_g_error:
	{
#line 300 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
		_data_->_error_ = _data_->_inner_error_;
#line 300 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
		_data_->_inner_error_ = NULL;
#line 309 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
		_data_->_tmp13_ = _data_->_error_;
#line 309 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
		_data_->_tmp14_ = _data_->_tmp13_->message;
#line 309 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
		g_warning ("util-app.vala:309: Failed to read file /proc/modules: %s", _data_->_tmp14_);
#line 300 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
		_g_error_free0 (_data_->_error_);
#line 3988 "util-app.c"
	}
	__finally106:
#line 300 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
	if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
#line 300 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
		_g_object_unref0 (_data_->file);
#line 300 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
#line 300 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
		g_clear_error (&_data_->_inner_error_);
#line 300 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
		g_object_unref (_data_->_async_result);
#line 300 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
		return FALSE;
#line 4003 "util-app.c"
	}
#line 312 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
	_data_->_tmp15_ = _data_->_result_;
#line 312 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
	_data_->_tmp16_ = boxes_yes_no (_data_->_tmp15_);
#line 312 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
	_data_->_tmp17_ = _data_->_tmp16_;
#line 312 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
	_data_->_tmp18_ = g_strconcat ("check_module_kvm_loaded: ", _data_->_tmp17_, NULL);
#line 312 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
	_data_->_tmp19_ = _data_->_tmp18_;
#line 312 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
	g_debug ("util-app.vala:312: %s", _data_->_tmp19_);
#line 312 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
	_g_free0 (_data_->_tmp19_);
#line 312 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
	_g_free0 (_data_->_tmp17_);
#line 313 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
	_data_->result = _data_->_result_;
#line 313 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
	_g_object_unref0 (_data_->file);
#line 313 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
#line 313 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
	if (_data_->_state_ != 0) {
#line 313 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
		while (_data_->_task_complete_ != TRUE) {
#line 313 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
#line 4033 "util-app.c"
		}
	}
#line 313 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
	g_object_unref (_data_->_async_result);
#line 313 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
	return FALSE;
#line 4040 "util-app.c"
}


static void
boxes_check_storage_pool_data_free (gpointer _data)
{
	BoxesCheckStoragePoolData* _data_;
	_data_ = _data;
#line 535 "/home/fborges/checkout/gnome-boxes/src/libvirt-machine.vala"
	g_slice_free (BoxesCheckStoragePoolData, _data_);
#line 4051 "util-app.c"
}


static void
boxes_check_storage_pool_async_ready_wrapper (GObject *source_object,
                                              GAsyncResult *res,
                                              void *user_data)
{
	BoxesCheckStoragePoolData* _task_data_;
#line 535 "/home/fborges/checkout/gnome-boxes/src/libvirt-machine.vala"
	_task_data_ = g_task_get_task_data (G_TASK (res));
#line 535 "/home/fborges/checkout/gnome-boxes/src/libvirt-machine.vala"
	if (_task_data_->_callback_ != NULL) {
#line 535 "/home/fborges/checkout/gnome-boxes/src/libvirt-machine.vala"
		_task_data_->_callback_ (source_object, res, user_data);
#line 4067 "util-app.c"
	}
#line 535 "/home/fborges/checkout/gnome-boxes/src/libvirt-machine.vala"
	_task_data_->_task_complete_ = TRUE;
#line 4071 "util-app.c"
}


void
boxes_check_storage_pool (GAsyncReadyCallback _callback_,
                          gpointer _user_data_)
{
	BoxesCheckStoragePoolData* _data_;
#line 535 "/home/fborges/checkout/gnome-boxes/src/libvirt-machine.vala"
	_data_ = g_slice_new0 (BoxesCheckStoragePoolData);
#line 535 "/home/fborges/checkout/gnome-boxes/src/libvirt-machine.vala"
	_data_->_callback_ = _callback_;
#line 535 "/home/fborges/checkout/gnome-boxes/src/libvirt-machine.vala"
	_data_->_async_result = g_task_new (NULL, NULL, boxes_check_storage_pool_async_ready_wrapper, _user_data_);
#line 535 "/home/fborges/checkout/gnome-boxes/src/libvirt-machine.vala"
	if (_callback_ == NULL) {
#line 535 "/home/fborges/checkout/gnome-boxes/src/libvirt-machine.vala"
		_data_->_task_complete_ = TRUE;
#line 4090 "util-app.c"
	}
#line 535 "/home/fborges/checkout/gnome-boxes/src/libvirt-machine.vala"
	g_task_set_task_data (_data_->_async_result, _data_, boxes_check_storage_pool_data_free);
#line 535 "/home/fborges/checkout/gnome-boxes/src/libvirt-machine.vala"
	boxes_check_storage_pool_co (_data_);
#line 4096 "util-app.c"
}


gboolean
boxes_check_storage_pool_finish (GAsyncResult* _res_,
                                 gchar* * diagnosis)
{
	gboolean result;
	BoxesCheckStoragePoolData* _data_;
#line 535 "/home/fborges/checkout/gnome-boxes/src/libvirt-machine.vala"
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
#line 535 "/home/fborges/checkout/gnome-boxes/src/libvirt-machine.vala"
	if (diagnosis) {
#line 535 "/home/fborges/checkout/gnome-boxes/src/libvirt-machine.vala"
		*diagnosis = _data_->diagnosis;
#line 4112 "util-app.c"
	} else {
#line 535 "/home/fborges/checkout/gnome-boxes/src/libvirt-machine.vala"
		_g_free0 (_data_->diagnosis);
#line 4116 "util-app.c"
	}
#line 535 "/home/fborges/checkout/gnome-boxes/src/libvirt-machine.vala"
	_data_->diagnosis = NULL;
#line 535 "/home/fborges/checkout/gnome-boxes/src/libvirt-machine.vala"
	result = _data_->result;
#line 535 "/home/fborges/checkout/gnome-boxes/src/libvirt-machine.vala"
	return result;
#line 4124 "util-app.c"
}


static void
boxes_check_storage_pool_ready (GObject* source_object,
                                GAsyncResult* _res_,
                                gpointer _user_data_)
{
	BoxesCheckStoragePoolData* _data_;
#line 324 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
	_data_ = _user_data_;
#line 324 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
	_data_->_source_object_ = source_object;
#line 324 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
	_data_->_res_ = _res_;
#line 324 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
	_data_->_task_complete_ = TRUE;
#line 324 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
	boxes_check_storage_pool_co (_data_);
#line 4144 "util-app.c"
}


static gboolean
boxes_check_storage_pool_co (BoxesCheckStoragePoolData* _data_)
{
#line 316 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
	switch (_data_->_state_) {
#line 316 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
		case 0:
#line 4155 "util-app.c"
		goto _state_0;
#line 316 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
		case 1:
#line 4159 "util-app.c"
		goto _state_1;
		default:
#line 316 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
		g_assert_not_reached ();
#line 4164 "util-app.c"
	}
	_state_0:
#line 318 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
	_data_->_tmp0_ = g_strdup ("");
#line 318 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
	_g_free0 (_data_->diagnosis);
#line 318 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
	_data_->diagnosis = _data_->_tmp0_;
#line 4173 "util-app.c"
	{
#line 322 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
		_data_->_tmp1_ = g_strdup ("virsh");
#line 322 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
		_data_->_tmp2_ = g_strdup ("pool-dumpxml");
#line 322 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
		_data_->_tmp3_ = g_strdup (PACKAGE_TARNAME);
#line 322 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
		_data_->_tmp4_ = g_new0 (gchar*, 3 + 1);
#line 322 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
		_data_->_tmp4_[0] = _data_->_tmp1_;
#line 322 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
		_data_->_tmp4_[1] = _data_->_tmp2_;
#line 322 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
		_data_->_tmp4_[2] = _data_->_tmp3_;
#line 322 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
		_data_->argv = _data_->_tmp4_;
#line 322 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
		_data_->argv_length1 = 3;
#line 322 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
		_data_->_argv_size_ = _data_->argv_length1;
#line 324 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
		_data_->_tmp5_ = _data_->argv;
#line 324 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
		_data_->_tmp5__length1 = _data_->argv_length1;
#line 324 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
		_data_->_tmp6_ = NULL;
#line 324 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
		_data_->_state_ = 1;
#line 324 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
		boxes_exec (_data_->_tmp5_, _data_->_tmp5__length1, NULL, boxes_check_storage_pool_ready, _data_);
#line 324 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
		return FALSE;
#line 4207 "util-app.c"
		_state_1:
#line 324 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
		boxes_exec_finish (_data_->_res_, &_data_->_tmp6_, NULL, &_data_->_inner_error_);
#line 324 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
		_g_free0 (_data_->standard_output);
#line 324 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
		_data_->standard_output = _data_->_tmp6_;
#line 324 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
		if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
#line 324 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
			_data_->argv = (_vala_array_free (_data_->argv, _data_->argv_length1, (GDestroyNotify) g_free), NULL);
#line 324 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
			_g_free0 (_data_->standard_output);
#line 4221 "util-app.c"
			goto __catch107_g_error;
		}
#line 325 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
		_data_->_tmp8_ = _data_->standard_output;
#line 325 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
		_data_->_tmp9_ = boxes_extract_xpath (_data_->_tmp8_, "string(/pool[@type='dir']/target/path)", FALSE, &_data_->_inner_error_);
#line 325 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
		_data_->_tmp7_ = _data_->_tmp9_;
#line 325 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
		if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
#line 325 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
			_data_->argv = (_vala_array_free (_data_->argv, _data_->argv_length1, (GDestroyNotify) g_free), NULL);
#line 325 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
			_g_free0 (_data_->standard_output);
#line 4236 "util-app.c"
			goto __catch107_g_error;
		}
#line 325 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
		_data_->_tmp10_ = _data_->_tmp7_;
#line 325 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
		_data_->_tmp7_ = NULL;
#line 325 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
		_g_free0 (_data_->pool_path);
#line 325 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
		_data_->pool_path = _data_->_tmp10_;
#line 319 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
		_g_free0 (_data_->_tmp7_);
#line 319 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
		_data_->argv = (_vala_array_free (_data_->argv, _data_->argv_length1, (GDestroyNotify) g_free), NULL);
#line 319 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
		_g_free0 (_data_->standard_output);
#line 4253 "util-app.c"
	}
	goto __finally107;
	__catch107_g_error:
	{
#line 319 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
		_data_->_error_ = _data_->_inner_error_;
#line 319 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
		_data_->_inner_error_ = NULL;
#line 327 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
		_data_->_tmp11_ = _data_->_error_;
#line 327 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
		_data_->_tmp12_ = _data_->_tmp11_->message;
#line 327 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
		g_debug ("util-app.vala:327: %s", _data_->_tmp12_);
#line 328 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
		_data_->_tmp13_ = g_strdup (_ ("Could not get “gnome-boxes” storage pool information from libvirt. Mak" \
"e sure “virsh -c qemu:///session pool-dumpxml gnome-boxes” is working."));
#line 328 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
		_g_free0 (_data_->diagnosis);
#line 328 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
		_data_->diagnosis = _data_->_tmp13_;
#line 329 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
		_data_->result = FALSE;
#line 329 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
		_g_error_free0 (_data_->_error_);
#line 329 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
		_g_free0 (_data_->pool_path);
#line 329 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
		g_task_return_pointer (_data_->_async_result, _data_, NULL);
#line 329 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
		if (_data_->_state_ != 0) {
#line 329 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
			while (_data_->_task_complete_ != TRUE) {
#line 329 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
				g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
#line 4288 "util-app.c"
			}
		}
#line 329 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
		g_object_unref (_data_->_async_result);
#line 329 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
		return FALSE;
#line 4295 "util-app.c"
	}
	__finally107:
#line 319 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
	if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
#line 319 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
		_g_free0 (_data_->pool_path);
#line 319 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
#line 319 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
		g_clear_error (&_data_->_inner_error_);
#line 319 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
		g_object_unref (_data_->_async_result);
#line 319 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
		return FALSE;
#line 4310 "util-app.c"
	}
#line 332 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
	_data_->_tmp14_ = _data_->pool_path;
#line 332 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
	if (!g_file_test (_data_->_tmp14_, G_FILE_TEST_EXISTS)) {
#line 333 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
		_data_->_tmp15_ = _data_->pool_path;
#line 333 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
		_data_->_tmp16_ = g_strdup_printf (_ ("%s is known to libvirt as GNOME Boxes’s storage pool but this director" \
"y does not exist"), _data_->_tmp15_);
#line 333 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
		_g_free0 (_data_->diagnosis);
#line 333 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
		_data_->diagnosis = _data_->_tmp16_;
#line 334 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
		_data_->result = FALSE;
#line 334 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
		_g_free0 (_data_->pool_path);
#line 334 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
		g_task_return_pointer (_data_->_async_result, _data_, NULL);
#line 334 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
		if (_data_->_state_ != 0) {
#line 334 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
			while (_data_->_task_complete_ != TRUE) {
#line 334 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
				g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
#line 4336 "util-app.c"
			}
		}
#line 334 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
		g_object_unref (_data_->_async_result);
#line 334 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
		return FALSE;
#line 4343 "util-app.c"
	}
#line 336 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
	_data_->_tmp17_ = _data_->pool_path;
#line 336 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
	if (!g_file_test (_data_->_tmp17_, G_FILE_TEST_IS_DIR)) {
#line 337 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
		_data_->_tmp18_ = _data_->pool_path;
#line 337 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
		_data_->_tmp19_ = g_strdup_printf (_ ("%s is known to libvirt as GNOME Boxes’s storage pool but is not a dire" \
"ctory"), _data_->_tmp18_);
#line 337 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
		_g_free0 (_data_->diagnosis);
#line 337 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
		_data_->diagnosis = _data_->_tmp19_;
#line 338 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
		_data_->result = FALSE;
#line 338 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
		_g_free0 (_data_->pool_path);
#line 338 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
		g_task_return_pointer (_data_->_async_result, _data_, NULL);
#line 338 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
		if (_data_->_state_ != 0) {
#line 338 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
			while (_data_->_task_complete_ != TRUE) {
#line 338 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
				g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
#line 4369 "util-app.c"
			}
		}
#line 338 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
		g_object_unref (_data_->_async_result);
#line 338 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
		return FALSE;
#line 4376 "util-app.c"
	}
#line 340 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
	_data_->_tmp20_ = _data_->pool_path;
#line 340 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
	if (access (_data_->_tmp20_, (R_OK | W_OK) | X_OK) != 0) {
#line 341 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
		_data_->_tmp21_ = _data_->pool_path;
#line 341 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
		_data_->_tmp22_ = g_strdup_printf (_ ("%s is known to libvirt as GNOME Boxes’s storage pool but is not user-r" \
"eadable/writable"), _data_->_tmp21_);
#line 341 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
		_g_free0 (_data_->diagnosis);
#line 341 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
		_data_->diagnosis = _data_->_tmp22_;
#line 342 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
		_data_->result = FALSE;
#line 342 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
		_g_free0 (_data_->pool_path);
#line 342 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
		g_task_return_pointer (_data_->_async_result, _data_, NULL);
#line 342 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
		if (_data_->_state_ != 0) {
#line 342 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
			while (_data_->_task_complete_ != TRUE) {
#line 342 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
				g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
#line 4402 "util-app.c"
			}
		}
#line 342 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
		g_object_unref (_data_->_async_result);
#line 342 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
		return FALSE;
#line 4409 "util-app.c"
	}
#line 345 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
	_data_->result = TRUE;
#line 345 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
	_g_free0 (_data_->pool_path);
#line 345 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
#line 345 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
	if (_data_->_state_ != 0) {
#line 345 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
		while (_data_->_task_complete_ != TRUE) {
#line 345 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
#line 4423 "util-app.c"
		}
	}
#line 345 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
	g_object_unref (_data_->_async_result);
#line 345 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
	return FALSE;
#line 4430 "util-app.c"
}


static guint8*
_vala_array_dup5 (guint8* self,
                  int length)
{
#line 378 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
	return g_memdup (self, length * sizeof (guint8));
#line 4440 "util-app.c"
}


GdkPixbuf*
boxes_remove_alpha (GdkPixbuf* pixbuf)
{
	GdkPixbuf* result = NULL;
#line 351 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
	static const guint8 ALPHA_TRESHOLD = (guint8) 50;
#line 4450 "util-app.c"
	gboolean _tmp0_ = FALSE;
	gint width = 0;
	gint height = 0;
	gint rowstride = 0;
	guint8* orig_pixels = NULL;
	guint8* _tmp1_;
	gint orig_pixels_length1;
	gint _orig_pixels_size_;
	guint8* pixels = NULL;
	gint _tmp2_;
	gint _tmp3_;
	guint8* _tmp4_;
	gint pixels_length1;
	gint _pixels_size_;
	guint8* _tmp50_;
	gint _tmp50__length1;
	guint8* _tmp51_;
	gint _tmp51__length1;
	gint _tmp52_;
	gint _tmp53_;
	gint _tmp54_;
	GdkPixbuf* _tmp55_;
#line 350 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
	g_return_val_if_fail (pixbuf != NULL, NULL);
#line 353 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
	if (gdk_pixbuf_get_n_channels (pixbuf) == 4) {
#line 353 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
		_tmp0_ = gdk_pixbuf_get_bits_per_sample (pixbuf) == 8;
#line 4479 "util-app.c"
	} else {
#line 353 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
		_tmp0_ = FALSE;
#line 4483 "util-app.c"
	}
#line 353 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
	g_return_val_if_fail (_tmp0_, pixbuf);
#line 355 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
	width = gdk_pixbuf_get_width (pixbuf);
#line 356 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
	height = gdk_pixbuf_get_height (pixbuf);
#line 357 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
	rowstride = gdk_pixbuf_get_rowstride (pixbuf);
#line 358 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
	_tmp1_ = gdk_pixbuf_get_pixels (pixbuf);
#line 358 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
	orig_pixels = _tmp1_;
#line 358 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
	orig_pixels_length1 = -1;
#line 358 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
	_orig_pixels_size_ = orig_pixels_length1;
#line 359 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
	_tmp2_ = rowstride;
#line 359 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
	_tmp3_ = height;
#line 359 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
	_tmp4_ = g_new0 (guint8, _tmp2_ * _tmp3_);
#line 359 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
	pixels = _tmp4_;
#line 359 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
	pixels_length1 = _tmp2_ * _tmp3_;
#line 359 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
	_pixels_size_ = pixels_length1;
#line 4513 "util-app.c"
	{
		gint i = 0;
#line 361 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
		i = 0;
#line 4518 "util-app.c"
		{
			gboolean _tmp5_ = FALSE;
#line 361 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
			_tmp5_ = TRUE;
#line 361 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
			while (TRUE) {
#line 4525 "util-app.c"
				gint _tmp7_;
				gint _tmp8_;
#line 361 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
				if (!_tmp5_) {
#line 4530 "util-app.c"
					gint _tmp6_;
#line 361 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
					_tmp6_ = i;
#line 361 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
					i = _tmp6_ + 1;
#line 4536 "util-app.c"
				}
#line 361 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
				_tmp5_ = FALSE;
#line 361 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
				_tmp7_ = i;
#line 361 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
				_tmp8_ = height;
#line 361 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
				if (!(_tmp7_ < _tmp8_)) {
#line 361 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
					break;
#line 4548 "util-app.c"
				}
				{
					gint j = 0;
					gint k = 0;
#line 362 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
					j = 0;
#line 362 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
					k = 0;
#line 4557 "util-app.c"
					{
						gboolean _tmp9_ = FALSE;
#line 362 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
						_tmp9_ = TRUE;
#line 362 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
						while (TRUE) {
#line 4564 "util-app.c"
							gint _tmp12_;
							gint _tmp13_;
							gint orig_index = 0;
							gint _tmp14_;
							gint _tmp15_;
							gint _tmp16_;
							gint index = 0;
							gint _tmp17_;
							gint _tmp18_;
							gint _tmp19_;
							guint8* _tmp20_;
							gint _tmp20__length1;
							gint _tmp21_;
							guint8 _tmp22_;
#line 362 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
							if (!_tmp9_) {
#line 4581 "util-app.c"
								gint _tmp10_;
								gint _tmp11_;
#line 362 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
								_tmp10_ = j;
#line 362 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
								j = _tmp10_ + 4;
#line 362 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
								_tmp11_ = k;
#line 362 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
								k = _tmp11_ + 3;
#line 4592 "util-app.c"
							}
#line 362 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
							_tmp9_ = FALSE;
#line 362 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
							_tmp12_ = j;
#line 362 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
							_tmp13_ = width;
#line 362 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
							if (!(_tmp12_ < (_tmp13_ * 4))) {
#line 362 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
								break;
#line 4604 "util-app.c"
							}
#line 363 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
							_tmp14_ = rowstride;
#line 363 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
							_tmp15_ = i;
#line 363 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
							_tmp16_ = j;
#line 363 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
							orig_index = (_tmp14_ * _tmp15_) + _tmp16_;
#line 364 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
							_tmp17_ = rowstride;
#line 364 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
							_tmp18_ = i;
#line 364 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
							_tmp19_ = k;
#line 364 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
							index = (_tmp17_ * _tmp18_) + _tmp19_;
#line 366 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
							_tmp20_ = orig_pixels;
#line 366 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
							_tmp20__length1 = orig_pixels_length1;
#line 366 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
							_tmp21_ = orig_index;
#line 366 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
							_tmp22_ = _tmp20_[_tmp21_ + 3];
#line 366 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
							if (_tmp22_ < ALPHA_TRESHOLD) {
#line 4632 "util-app.c"
								guint8* _tmp23_;
								gint _tmp23__length1;
								gint _tmp24_;
								guint8 _tmp25_;
								guint8* _tmp26_;
								gint _tmp26__length1;
								gint _tmp27_;
								guint8 _tmp28_;
								guint8* _tmp29_;
								gint _tmp29__length1;
								gint _tmp30_;
								guint8 _tmp31_;
#line 367 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
								_tmp23_ = pixels;
#line 367 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
								_tmp23__length1 = pixels_length1;
#line 367 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
								_tmp24_ = index;
#line 367 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
								_tmp23_[_tmp24_] = (guint8) 0xFF;
#line 367 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
								_tmp25_ = _tmp23_[_tmp24_];
#line 368 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
								_tmp26_ = pixels;
#line 368 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
								_tmp26__length1 = pixels_length1;
#line 368 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
								_tmp27_ = index;
#line 368 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
								_tmp26_[_tmp27_ + 1] = (guint8) 0xFF;
#line 368 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
								_tmp28_ = _tmp26_[_tmp27_ + 1];
#line 369 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
								_tmp29_ = pixels;
#line 369 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
								_tmp29__length1 = pixels_length1;
#line 369 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
								_tmp30_ = index;
#line 369 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
								_tmp29_[_tmp30_ + 2] = (guint8) 0xFF;
#line 369 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
								_tmp31_ = _tmp29_[_tmp30_ + 2];
#line 4675 "util-app.c"
							} else {
								guint8* _tmp32_;
								gint _tmp32__length1;
								gint _tmp33_;
								guint8* _tmp34_;
								gint _tmp34__length1;
								gint _tmp35_;
								guint8 _tmp36_;
								guint8 _tmp37_;
								guint8* _tmp38_;
								gint _tmp38__length1;
								gint _tmp39_;
								guint8* _tmp40_;
								gint _tmp40__length1;
								gint _tmp41_;
								guint8 _tmp42_;
								guint8 _tmp43_;
								guint8* _tmp44_;
								gint _tmp44__length1;
								gint _tmp45_;
								guint8* _tmp46_;
								gint _tmp46__length1;
								gint _tmp47_;
								guint8 _tmp48_;
								guint8 _tmp49_;
#line 371 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
								_tmp32_ = pixels;
#line 371 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
								_tmp32__length1 = pixels_length1;
#line 371 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
								_tmp33_ = index;
#line 371 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
								_tmp34_ = orig_pixels;
#line 371 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
								_tmp34__length1 = orig_pixels_length1;
#line 371 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
								_tmp35_ = orig_index;
#line 371 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
								_tmp36_ = _tmp34_[_tmp35_];
#line 371 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
								_tmp32_[_tmp33_] = _tmp36_;
#line 371 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
								_tmp37_ = _tmp32_[_tmp33_];
#line 372 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
								_tmp38_ = pixels;
#line 372 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
								_tmp38__length1 = pixels_length1;
#line 372 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
								_tmp39_ = index;
#line 372 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
								_tmp40_ = orig_pixels;
#line 372 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
								_tmp40__length1 = orig_pixels_length1;
#line 372 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
								_tmp41_ = orig_index;
#line 372 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
								_tmp42_ = _tmp40_[_tmp41_ + 1];
#line 372 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
								_tmp38_[_tmp39_ + 1] = _tmp42_;
#line 372 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
								_tmp43_ = _tmp38_[_tmp39_ + 1];
#line 373 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
								_tmp44_ = pixels;
#line 373 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
								_tmp44__length1 = pixels_length1;
#line 373 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
								_tmp45_ = index;
#line 373 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
								_tmp46_ = orig_pixels;
#line 373 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
								_tmp46__length1 = orig_pixels_length1;
#line 373 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
								_tmp47_ = orig_index;
#line 373 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
								_tmp48_ = _tmp46_[_tmp47_ + 2];
#line 373 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
								_tmp44_[_tmp45_ + 2] = _tmp48_;
#line 373 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
								_tmp49_ = _tmp44_[_tmp45_ + 2];
#line 4755 "util-app.c"
							}
						}
					}
				}
			}
		}
	}
#line 378 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
	_tmp50_ = pixels;
#line 378 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
	_tmp50__length1 = pixels_length1;
#line 378 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
	_tmp51_ = (_tmp50_ != NULL) ? _vala_array_dup5 (_tmp50_, _tmp50__length1) : ((gpointer) _tmp50_);
#line 378 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
	_tmp51__length1 = _tmp50__length1;
#line 378 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
	_tmp52_ = width;
#line 378 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
	_tmp53_ = height;
#line 378 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
	_tmp54_ = rowstride;
#line 378 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
	_tmp55_ = gdk_pixbuf_new_from_data (_tmp51_, gdk_pixbuf_get_colorspace (pixbuf), FALSE, 8, _tmp52_, _tmp53_, _tmp54_, NULL, NULL);
#line 378 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
	result = _tmp55_;
#line 378 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
	pixels = (g_free (pixels), NULL);
#line 378 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
	return result;
#line 4785 "util-app.c"
}


static Block84Data*
block84_data_ref (Block84Data* _data84_)
{
#line 388 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
	g_atomic_int_inc (&_data84_->_ref_count_);
#line 388 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
	return _data84_;
#line 4796 "util-app.c"
}


static void
block84_data_unref (void * _userdata_)
{
	Block84Data* _data84_;
	_data84_ = (Block84Data*) _userdata_;
#line 388 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
	if (g_atomic_int_dec_and_test (&_data84_->_ref_count_)) {
#line 388 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
		_g_object_unref0 (_data84_->widget);
#line 388 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
		g_slice_free (Block84Data, _data84_);
#line 4811 "util-app.c"
	}
}


static gboolean
__lambda135_ (Block84Data* _data84_,
              cairo_t* cr)
{
	gboolean result = FALSE;
	GtkStyleContext* context = NULL;
	GtkStyleContext* _tmp0_;
	GtkStyleContext* _tmp1_;
	GtkAllocation allocation = {0};
	GtkAllocation _tmp2_ = {0};
	GtkAllocation _tmp3_;
	gint _tmp4_;
	GtkAllocation _tmp5_;
	gint _tmp6_;
	GtkAllocation _tmp7_;
	gint _tmp8_;
	GtkAllocation _tmp9_;
	gint _tmp10_;
#line 389 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
	g_return_val_if_fail (cr != NULL, FALSE);
#line 390 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
	_tmp0_ = gtk_widget_get_style_context (_data84_->widget);
#line 390 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
	_tmp1_ = _g_object_ref0 (_tmp0_);
#line 390 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
	context = _tmp1_;
#line 392 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
	gtk_widget_get_allocation (_data84_->widget, &_tmp2_);
#line 392 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
	allocation = _tmp2_;
#line 393 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
	_tmp3_ = allocation;
#line 393 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
	_tmp4_ = _tmp3_.width;
#line 393 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
	_tmp5_ = allocation;
#line 393 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
	_tmp6_ = _tmp5_.height;
#line 393 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
	gtk_render_background (context, cr, (gdouble) 0, (gdouble) 0, (gdouble) _tmp4_, (gdouble) _tmp6_);
#line 396 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
	_tmp7_ = allocation;
#line 396 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
	_tmp8_ = _tmp7_.width;
#line 396 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
	_tmp9_ = allocation;
#line 396 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
	_tmp10_ = _tmp9_.height;
#line 396 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
	gtk_render_frame (context, cr, (gdouble) 0, (gdouble) 0, (gdouble) _tmp8_, (gdouble) _tmp10_);
#line 399 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
	result = FALSE;
#line 399 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
	_g_object_unref0 (context);
#line 399 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
	return result;
#line 4872 "util-app.c"
}


static gboolean
___lambda135__gtk_widget_draw (GtkWidget* _sender,
                               cairo_t* cr,
                               gpointer self)
{
	gboolean result;
	result = __lambda135_ (self, cr);
#line 389 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
	return result;
#line 4885 "util-app.c"
}


void
boxes_draw_as_css_box (GtkWidget* widget)
{
	Block84Data* _data84_;
	GtkWidget* _tmp0_;
#line 388 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
	g_return_if_fail (widget != NULL);
#line 388 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
	_data84_ = g_slice_new0 (Block84Data);
#line 388 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
	_data84_->_ref_count_ = 1;
#line 388 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
	_tmp0_ = _g_object_ref0 (widget);
#line 388 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
	_g_object_unref0 (_data84_->widget);
#line 388 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
	_data84_->widget = _tmp0_;
#line 389 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
	g_signal_connect_data (_data84_->widget, "draw", (GCallback) ___lambda135__gtk_widget_draw, block84_data_ref (_data84_), (GClosureNotify) block84_data_unref, 0);
#line 388 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
	block84_data_unref (_data84_);
#line 388 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
	_data84_ = NULL;
#line 4912 "util-app.c"
}


GType
boxes_cpu_arch_compatibility_get_type (void)
{
	static volatile gsize boxes_cpu_arch_compatibility_type_id__volatile = 0;
	if (g_once_init_enter (&boxes_cpu_arch_compatibility_type_id__volatile)) {
		static const GEnumValue values[] = {{BOXES_CPU_ARCH_COMPATIBILITY_INCOMPATIBLE, "BOXES_CPU_ARCH_COMPATIBILITY_INCOMPATIBLE", "incompatible"}, {BOXES_CPU_ARCH_COMPATIBILITY_IDENTICAL, "BOXES_CPU_ARCH_COMPATIBILITY_IDENTICAL", "identical"}, {BOXES_CPU_ARCH_COMPATIBILITY_COMPATIBLE, "BOXES_CPU_ARCH_COMPATIBILITY_COMPATIBLE", "compatible"}, {BOXES_CPU_ARCH_COMPATIBILITY_COMPATIBLE_DIFF_WORDSIZE, "BOXES_CPU_ARCH_COMPATIBILITY_COMPATIBLE_DIFF_WORDSIZE", "compatible-diff-wordsize"}, {0, NULL, NULL}};
		GType boxes_cpu_arch_compatibility_type_id;
		boxes_cpu_arch_compatibility_type_id = g_enum_register_static ("BoxesCPUArchCompatibility", values);
		g_once_init_leave (&boxes_cpu_arch_compatibility_type_id__volatile, boxes_cpu_arch_compatibility_type_id);
	}
	return boxes_cpu_arch_compatibility_type_id__volatile;
}


BoxesCPUArchCompatibility
boxes_compare_cpu_architectures (const gchar* arch1,
                                 const gchar* arch2)
{
	BoxesCPUArchCompatibility result = 0;
	const gchar* _tmp0_;
	GQuark _tmp2_ = 0U;
#line 414 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
	static GQuark _tmp1_label0 = 0;
#line 414 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
	static GQuark _tmp1_label1 = 0;
#line 414 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
	static GQuark _tmp1_label2 = 0;
#line 414 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
	static GQuark _tmp1_label3 = 0;
#line 414 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
	static GQuark _tmp1_label4 = 0;
#line 413 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
	g_return_val_if_fail (arch1 != NULL, 0);
#line 413 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
	g_return_val_if_fail (arch2 != NULL, 0);
#line 414 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
	_tmp0_ = arch2;
#line 414 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
	_tmp2_ = (NULL == _tmp0_) ? 0 : g_quark_from_string (_tmp0_);
#line 414 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
	if (_tmp2_ == ((0 != _tmp1_label0) ? _tmp1_label0 : (_tmp1_label0 = g_quark_from_static_string ("i386")))) {
#line 414 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
		switch (0) {
#line 4959 "util-app.c"
			default:
			{
				const gchar* _tmp3_;
				GQuark _tmp5_ = 0U;
#line 416 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
				static GQuark _tmp4_label0 = 0;
#line 416 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
				static GQuark _tmp4_label1 = 0;
#line 416 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
				static GQuark _tmp4_label2 = 0;
#line 416 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
				static GQuark _tmp4_label3 = 0;
#line 416 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
				static GQuark _tmp4_label4 = 0;
#line 416 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
				_tmp3_ = arch1;
#line 416 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
				_tmp5_ = (NULL == _tmp3_) ? 0 : g_quark_from_string (_tmp3_);
#line 416 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
				if (_tmp5_ == ((0 != _tmp4_label0) ? _tmp4_label0 : (_tmp4_label0 = g_quark_from_static_string ("i386")))) {
#line 416 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
					switch (0) {
#line 4982 "util-app.c"
						default:
						{
#line 418 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
							result = BOXES_CPU_ARCH_COMPATIBILITY_IDENTICAL;
#line 418 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
							return result;
#line 4989 "util-app.c"
						}
					}
				} else if (((_tmp5_ == ((0 != _tmp4_label1) ? _tmp4_label1 : (_tmp4_label1 = g_quark_from_static_string ("i486")))) || (_tmp5_ == ((0 != _tmp4_label2) ? _tmp4_label2 : (_tmp4_label2 = g_quark_from_static_string ("i586"))))) || (_tmp5_ == ((0 != _tmp4_label3) ? _tmp4_label3 : (_tmp4_label3 = g_quark_from_static_string ("i686"))))) {
#line 416 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
					switch (0) {
#line 4995 "util-app.c"
						default:
						{
#line 422 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
							result = BOXES_CPU_ARCH_COMPATIBILITY_COMPATIBLE;
#line 422 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
							return result;
#line 5002 "util-app.c"
						}
					}
				} else if (_tmp5_ == ((0 != _tmp4_label4) ? _tmp4_label4 : (_tmp4_label4 = g_quark_from_static_string ("x86_64")))) {
#line 416 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
					switch (0) {
#line 5008 "util-app.c"
						default:
						{
#line 424 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
							result = BOXES_CPU_ARCH_COMPATIBILITY_COMPATIBLE_DIFF_WORDSIZE;
#line 424 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
							return result;
#line 5015 "util-app.c"
						}
					}
				} else {
#line 416 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
					switch (0) {
#line 5021 "util-app.c"
						default:
						{
#line 426 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
							result = BOXES_CPU_ARCH_COMPATIBILITY_INCOMPATIBLE;
#line 426 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
							return result;
#line 5028 "util-app.c"
						}
					}
				}
			}
		}
	} else if (_tmp2_ == ((0 != _tmp1_label1) ? _tmp1_label1 : (_tmp1_label1 = g_quark_from_static_string ("i486")))) {
#line 414 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
		switch (0) {
#line 5037 "util-app.c"
			default:
			{
				const gchar* _tmp6_;
				GQuark _tmp8_ = 0U;
#line 429 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
				static GQuark _tmp7_label0 = 0;
#line 429 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
				static GQuark _tmp7_label1 = 0;
#line 429 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
				static GQuark _tmp7_label2 = 0;
#line 429 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
				static GQuark _tmp7_label3 = 0;
#line 429 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
				_tmp6_ = arch1;
#line 429 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
				_tmp8_ = (NULL == _tmp6_) ? 0 : g_quark_from_string (_tmp6_);
#line 429 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
				if (_tmp8_ == ((0 != _tmp7_label0) ? _tmp7_label0 : (_tmp7_label0 = g_quark_from_static_string ("i486")))) {
#line 429 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
					switch (0) {
#line 5058 "util-app.c"
						default:
						{
#line 431 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
							result = BOXES_CPU_ARCH_COMPATIBILITY_IDENTICAL;
#line 431 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
							return result;
#line 5065 "util-app.c"
						}
					}
				} else if ((_tmp8_ == ((0 != _tmp7_label1) ? _tmp7_label1 : (_tmp7_label1 = g_quark_from_static_string ("i586")))) || (_tmp8_ == ((0 != _tmp7_label2) ? _tmp7_label2 : (_tmp7_label2 = g_quark_from_static_string ("i686"))))) {
#line 429 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
					switch (0) {
#line 5071 "util-app.c"
						default:
						{
#line 434 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
							result = BOXES_CPU_ARCH_COMPATIBILITY_COMPATIBLE;
#line 434 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
							return result;
#line 5078 "util-app.c"
						}
					}
				} else if (_tmp8_ == ((0 != _tmp7_label3) ? _tmp7_label3 : (_tmp7_label3 = g_quark_from_static_string ("x86_64")))) {
#line 429 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
					switch (0) {
#line 5084 "util-app.c"
						default:
						{
#line 436 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
							result = BOXES_CPU_ARCH_COMPATIBILITY_COMPATIBLE_DIFF_WORDSIZE;
#line 436 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
							return result;
#line 5091 "util-app.c"
						}
					}
				} else {
#line 429 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
					switch (0) {
#line 5097 "util-app.c"
						default:
						{
#line 438 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
							result = BOXES_CPU_ARCH_COMPATIBILITY_INCOMPATIBLE;
#line 438 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
							return result;
#line 5104 "util-app.c"
						}
					}
				}
			}
		}
	} else if (_tmp2_ == ((0 != _tmp1_label2) ? _tmp1_label2 : (_tmp1_label2 = g_quark_from_static_string ("i586")))) {
#line 414 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
		switch (0) {
#line 5113 "util-app.c"
			default:
			{
				const gchar* _tmp9_;
				GQuark _tmp11_ = 0U;
#line 441 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
				static GQuark _tmp10_label0 = 0;
#line 441 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
				static GQuark _tmp10_label1 = 0;
#line 441 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
				static GQuark _tmp10_label2 = 0;
#line 441 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
				_tmp9_ = arch1;
#line 441 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
				_tmp11_ = (NULL == _tmp9_) ? 0 : g_quark_from_string (_tmp9_);
#line 441 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
				if (_tmp11_ == ((0 != _tmp10_label0) ? _tmp10_label0 : (_tmp10_label0 = g_quark_from_static_string ("i586")))) {
#line 441 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
					switch (0) {
#line 5132 "util-app.c"
						default:
						{
#line 443 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
							result = BOXES_CPU_ARCH_COMPATIBILITY_IDENTICAL;
#line 443 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
							return result;
#line 5139 "util-app.c"
						}
					}
				} else if (_tmp11_ == ((0 != _tmp10_label1) ? _tmp10_label1 : (_tmp10_label1 = g_quark_from_static_string ("i686")))) {
#line 441 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
					switch (0) {
#line 5145 "util-app.c"
						default:
						{
#line 445 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
							result = BOXES_CPU_ARCH_COMPATIBILITY_COMPATIBLE;
#line 445 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
							return result;
#line 5152 "util-app.c"
						}
					}
				} else if (_tmp11_ == ((0 != _tmp10_label2) ? _tmp10_label2 : (_tmp10_label2 = g_quark_from_static_string ("x86_64")))) {
#line 441 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
					switch (0) {
#line 5158 "util-app.c"
						default:
						{
#line 447 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
							result = BOXES_CPU_ARCH_COMPATIBILITY_COMPATIBLE_DIFF_WORDSIZE;
#line 447 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
							return result;
#line 5165 "util-app.c"
						}
					}
				} else {
#line 441 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
					switch (0) {
#line 5171 "util-app.c"
						default:
						{
#line 449 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
							result = BOXES_CPU_ARCH_COMPATIBILITY_INCOMPATIBLE;
#line 449 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
							return result;
#line 5178 "util-app.c"
						}
					}
				}
			}
		}
	} else if (_tmp2_ == ((0 != _tmp1_label3) ? _tmp1_label3 : (_tmp1_label3 = g_quark_from_static_string ("i686")))) {
#line 414 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
		switch (0) {
#line 5187 "util-app.c"
			default:
			{
				const gchar* _tmp12_;
				GQuark _tmp14_ = 0U;
#line 452 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
				static GQuark _tmp13_label0 = 0;
#line 452 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
				static GQuark _tmp13_label1 = 0;
#line 452 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
				_tmp12_ = arch1;
#line 452 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
				_tmp14_ = (NULL == _tmp12_) ? 0 : g_quark_from_string (_tmp12_);
#line 452 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
				if (_tmp14_ == ((0 != _tmp13_label0) ? _tmp13_label0 : (_tmp13_label0 = g_quark_from_static_string ("i686")))) {
#line 452 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
					switch (0) {
#line 5204 "util-app.c"
						default:
						{
#line 454 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
							result = BOXES_CPU_ARCH_COMPATIBILITY_IDENTICAL;
#line 454 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
							return result;
#line 5211 "util-app.c"
						}
					}
				} else if (_tmp14_ == ((0 != _tmp13_label1) ? _tmp13_label1 : (_tmp13_label1 = g_quark_from_static_string ("x86_64")))) {
#line 452 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
					switch (0) {
#line 5217 "util-app.c"
						default:
						{
#line 456 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
							result = BOXES_CPU_ARCH_COMPATIBILITY_COMPATIBLE_DIFF_WORDSIZE;
#line 456 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
							return result;
#line 5224 "util-app.c"
						}
					}
				} else {
#line 452 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
					switch (0) {
#line 5230 "util-app.c"
						default:
						{
#line 458 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
							result = BOXES_CPU_ARCH_COMPATIBILITY_INCOMPATIBLE;
#line 458 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
							return result;
#line 5237 "util-app.c"
						}
					}
				}
			}
		}
	} else if (_tmp2_ == ((0 != _tmp1_label4) ? _tmp1_label4 : (_tmp1_label4 = g_quark_from_static_string ("x86_64")))) {
#line 414 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
		switch (0) {
#line 5246 "util-app.c"
			default:
			{
				const gchar* _tmp15_;
				GQuark _tmp17_ = 0U;
#line 461 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
				static GQuark _tmp16_label0 = 0;
#line 461 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
				_tmp15_ = arch1;
#line 461 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
				_tmp17_ = (NULL == _tmp15_) ? 0 : g_quark_from_string (_tmp15_);
#line 461 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
				if (_tmp17_ == ((0 != _tmp16_label0) ? _tmp16_label0 : (_tmp16_label0 = g_quark_from_static_string ("x86_64")))) {
#line 461 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
					switch (0) {
#line 5261 "util-app.c"
						default:
						{
#line 463 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
							result = BOXES_CPU_ARCH_COMPATIBILITY_IDENTICAL;
#line 463 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
							return result;
#line 5268 "util-app.c"
						}
					}
				} else {
#line 461 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
					switch (0) {
#line 5274 "util-app.c"
						default:
						{
#line 465 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
							result = BOXES_CPU_ARCH_COMPATIBILITY_INCOMPATIBLE;
#line 465 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
							return result;
#line 5281 "util-app.c"
						}
					}
				}
			}
		}
	} else if (_tmp2_ == g_quark_from_string (OSINFO_ARCHITECTURE_ALL)) {
#line 414 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
		switch (0) {
#line 5290 "util-app.c"
			default:
			{
#line 468 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
				result = BOXES_CPU_ARCH_COMPATIBILITY_COMPATIBLE;
#line 468 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
				return result;
#line 5297 "util-app.c"
			}
		}
	} else {
#line 414 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
		switch (0) {
#line 5303 "util-app.c"
			default:
			{
				const gchar* _tmp18_;
				GQuark _tmp20_ = 0U;
#line 470 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
				_tmp18_ = arch1;
#line 470 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
				_tmp20_ = (NULL == _tmp18_) ? 0 : g_quark_from_string (_tmp18_);
#line 470 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
				if (_tmp20_ == g_quark_from_string (OSINFO_ARCHITECTURE_ALL)) {
#line 470 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
					switch (0) {
#line 5316 "util-app.c"
						default:
						{
#line 472 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
							result = BOXES_CPU_ARCH_COMPATIBILITY_IDENTICAL;
#line 472 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
							return result;
#line 5323 "util-app.c"
						}
					}
				} else {
#line 470 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
					switch (0) {
#line 5329 "util-app.c"
						default:
						{
#line 474 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
							result = BOXES_CPU_ARCH_COMPATIBILITY_INCOMPATIBLE;
#line 474 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
							return result;
#line 5336 "util-app.c"
						}
					}
				}
			}
		}
	}
}


gchar*
boxes_fdo_timedate1_get_timezone (BoxesFdotimedate1* self)
{
#line 481 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 481 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
	return BOXES_FDO_TIMEDATE1_GET_INTERFACE (self)->get_timezone (self);
#line 5353 "util-app.c"
}


void
boxes_fdo_timedate1_set_timezone (BoxesFdotimedate1* self,
                                  const gchar* value)
{
#line 481 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
	g_return_if_fail (self != NULL);
#line 481 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
	BOXES_FDO_TIMEDATE1_GET_INTERFACE (self)->set_timezone (self, value);
#line 5365 "util-app.c"
}


static void
boxes_fdo_timedate1_base_init (BoxesFdotimedate1Iface * iface)
{
#line 480 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
	static gboolean initialized = FALSE;
#line 480 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
	if (!initialized) {
#line 480 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
		initialized = TRUE;
#line 5378 "util-app.c"
	}
}


GType
boxes_fdo_timedate1_get_type (void)
{
	static volatile gsize boxes_fdo_timedate1_type_id__volatile = 0;
	if (g_once_init_enter (&boxes_fdo_timedate1_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (BoxesFdotimedate1Iface), (GBaseInitFunc) boxes_fdo_timedate1_base_init, (GBaseFinalizeFunc) NULL, (GClassInitFunc) NULL, (GClassFinalizeFunc) NULL, NULL, 0, 0, (GInstanceInitFunc) NULL, NULL };
		GType boxes_fdo_timedate1_type_id;
		boxes_fdo_timedate1_type_id = g_type_register_static (G_TYPE_INTERFACE, "BoxesFdotimedate1", &g_define_type_info, 0);
		g_type_interface_add_prerequisite (boxes_fdo_timedate1_type_id, G_TYPE_OBJECT);
		g_type_set_qdata (boxes_fdo_timedate1_type_id, g_quark_from_static_string ("vala-dbus-proxy-type"), (void*) boxes_fdo_timedate1_proxy_get_type);
		g_type_set_qdata (boxes_fdo_timedate1_type_id, g_quark_from_static_string ("vala-dbus-interface-name"), "org.freedesktop.timedate1");
		g_type_set_qdata (boxes_fdo_timedate1_type_id, g_quark_from_static_string ("vala-dbus-interface-info"), (void*) (&_boxes_fdo_timedate1_dbus_interface_info));
		g_type_set_qdata (boxes_fdo_timedate1_type_id, g_quark_from_static_string ("vala-dbus-register-object"), (void*) boxes_fdo_timedate1_register_object);
		g_once_init_leave (&boxes_fdo_timedate1_type_id__volatile, boxes_fdo_timedate1_type_id);
	}
	return boxes_fdo_timedate1_type_id__volatile;
}


G_DEFINE_TYPE_EXTENDED (BoxesFdotimedate1Proxy, boxes_fdo_timedate1_proxy, G_TYPE_DBUS_PROXY, 0, G_IMPLEMENT_INTERFACE (BOXES_FDO_TYPE_TIMEDATE1, boxes_fdo_timedate1_proxy_boxes_fdo_timedate1_interface_init) )
static void
boxes_fdo_timedate1_proxy_class_init (BoxesFdotimedate1ProxyClass* klass)
{
#line 535 "/home/fborges/checkout/gnome-boxes/src/libvirt-machine.vala"
	G_DBUS_PROXY_CLASS (klass)->g_signal = boxes_fdo_timedate1_proxy_g_signal;
#line 5408 "util-app.c"
}


static void
boxes_fdo_timedate1_proxy_g_signal (GDBusProxy* proxy,
                                    const gchar* sender_name,
                                    const gchar* signal_name,
                                    GVariant* parameters)
{
}


static void
boxes_fdo_timedate1_proxy_init (BoxesFdotimedate1Proxy* self)
{
}


static gchar*
boxes_fdo_timedate1_dbus_proxy_get_timezone (BoxesFdotimedate1* self)
{
	GVariant *_inner_reply;
	gchar* _result;
#line 535 "/home/fborges/checkout/gnome-boxes/src/libvirt-machine.vala"
	_inner_reply = g_dbus_proxy_get_cached_property ((GDBusProxy *) self, "Timezone");
#line 535 "/home/fborges/checkout/gnome-boxes/src/libvirt-machine.vala"
	if (!_inner_reply) {
#line 5436 "util-app.c"
		GVariant *_arguments;
		GVariant *_reply;
		GVariantBuilder _arguments_builder;
#line 535 "/home/fborges/checkout/gnome-boxes/src/libvirt-machine.vala"
		g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
#line 535 "/home/fborges/checkout/gnome-boxes/src/libvirt-machine.vala"
		g_variant_builder_add_value (&_arguments_builder, g_variant_new_string ("org.freedesktop.timedate1"));
#line 535 "/home/fborges/checkout/gnome-boxes/src/libvirt-machine.vala"
		g_variant_builder_add_value (&_arguments_builder, g_variant_new_string ("Timezone"));
#line 535 "/home/fborges/checkout/gnome-boxes/src/libvirt-machine.vala"
		_arguments = g_variant_builder_end (&_arguments_builder);
#line 535 "/home/fborges/checkout/gnome-boxes/src/libvirt-machine.vala"
		_reply = g_dbus_proxy_call_sync ((GDBusProxy *) self, "org.freedesktop.DBus.Properties.Get", _arguments, G_DBUS_CALL_FLAGS_NONE, -1, NULL, NULL);
#line 535 "/home/fborges/checkout/gnome-boxes/src/libvirt-machine.vala"
		if (!_reply) {
#line 535 "/home/fborges/checkout/gnome-boxes/src/libvirt-machine.vala"
			return NULL;
#line 5454 "util-app.c"
		}
#line 535 "/home/fborges/checkout/gnome-boxes/src/libvirt-machine.vala"
		g_variant_get (_reply, "(v)", &_inner_reply);
#line 535 "/home/fborges/checkout/gnome-boxes/src/libvirt-machine.vala"
		g_variant_unref (_reply);
#line 5460 "util-app.c"
	}
#line 535 "/home/fborges/checkout/gnome-boxes/src/libvirt-machine.vala"
	_result = g_variant_dup_string (_inner_reply, NULL);
#line 535 "/home/fborges/checkout/gnome-boxes/src/libvirt-machine.vala"
	g_variant_unref (_inner_reply);
#line 535 "/home/fborges/checkout/gnome-boxes/src/libvirt-machine.vala"
	return _result;
#line 5468 "util-app.c"
}


static void
boxes_fdo_timedate1_dbus_proxy_set_timezone (BoxesFdotimedate1* self,
                                             const gchar* value)
{
	GVariant *_arguments;
	GVariant *_reply;
	GVariantBuilder _arguments_builder;
#line 535 "/home/fborges/checkout/gnome-boxes/src/libvirt-machine.vala"
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
#line 535 "/home/fborges/checkout/gnome-boxes/src/libvirt-machine.vala"
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_string ("org.freedesktop.timedate1"));
#line 535 "/home/fborges/checkout/gnome-boxes/src/libvirt-machine.vala"
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_string ("Timezone"));
#line 535 "/home/fborges/checkout/gnome-boxes/src/libvirt-machine.vala"
	g_variant_builder_open (&_arguments_builder, G_VARIANT_TYPE_VARIANT);
#line 535 "/home/fborges/checkout/gnome-boxes/src/libvirt-machine.vala"
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_string (value));
#line 535 "/home/fborges/checkout/gnome-boxes/src/libvirt-machine.vala"
	g_variant_builder_close (&_arguments_builder);
#line 535 "/home/fborges/checkout/gnome-boxes/src/libvirt-machine.vala"
	_arguments = g_variant_builder_end (&_arguments_builder);
#line 535 "/home/fborges/checkout/gnome-boxes/src/libvirt-machine.vala"
	_reply = g_dbus_proxy_call_sync ((GDBusProxy *) self, "org.freedesktop.DBus.Properties.Set", _arguments, G_DBUS_CALL_FLAGS_NONE, -1, NULL, NULL);
#line 535 "/home/fborges/checkout/gnome-boxes/src/libvirt-machine.vala"
	if (!_reply) {
#line 535 "/home/fborges/checkout/gnome-boxes/src/libvirt-machine.vala"
		return;
#line 5499 "util-app.c"
	}
#line 535 "/home/fborges/checkout/gnome-boxes/src/libvirt-machine.vala"
	g_variant_unref (_reply);
#line 5503 "util-app.c"
}


static void
boxes_fdo_timedate1_proxy_boxes_fdo_timedate1_interface_init (BoxesFdotimedate1Iface* iface)
{
#line 535 "/home/fborges/checkout/gnome-boxes/src/libvirt-machine.vala"
	iface->get_timezone = boxes_fdo_timedate1_dbus_proxy_get_timezone;
#line 535 "/home/fborges/checkout/gnome-boxes/src/libvirt-machine.vala"
	iface->set_timezone = boxes_fdo_timedate1_dbus_proxy_set_timezone;
#line 5514 "util-app.c"
}


static void
boxes_fdo_timedate1_dbus_interface_method_call (GDBusConnection* connection,
                                                const gchar* sender,
                                                const gchar* object_path,
                                                const gchar* interface_name,
                                                const gchar* method_name,
                                                GVariant* parameters,
                                                GDBusMethodInvocation* invocation,
                                                gpointer user_data)
{
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
#line 535 "/home/fborges/checkout/gnome-boxes/src/libvirt-machine.vala"
	g_object_unref (invocation);
#line 5534 "util-app.c"
}


static GVariant*
_dbus_boxes_fdo_timedate1_get_timezone (BoxesFdotimedate1* self)
{
	gchar* result;
	GVariant* _reply;
#line 535 "/home/fborges/checkout/gnome-boxes/src/libvirt-machine.vala"
	result = boxes_fdo_timedate1_get_timezone (self);
#line 535 "/home/fborges/checkout/gnome-boxes/src/libvirt-machine.vala"
	_reply = g_variant_new_string (result);
#line 535 "/home/fborges/checkout/gnome-boxes/src/libvirt-machine.vala"
	_g_free0 (result);
#line 535 "/home/fborges/checkout/gnome-boxes/src/libvirt-machine.vala"
	return _reply;
#line 5551 "util-app.c"
}


static GVariant*
boxes_fdo_timedate1_dbus_interface_get_property (GDBusConnection* connection,
                                                 const gchar* sender,
                                                 const gchar* object_path,
                                                 const gchar* interface_name,
                                                 const gchar* property_name,
                                                 GError** error,
                                                 gpointer user_data)
{
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
#line 535 "/home/fborges/checkout/gnome-boxes/src/libvirt-machine.vala"
	if (strcmp (property_name, "Timezone") == 0) {
#line 535 "/home/fborges/checkout/gnome-boxes/src/libvirt-machine.vala"
		return _dbus_boxes_fdo_timedate1_get_timezone (object);
#line 5572 "util-app.c"
	}
#line 535 "/home/fborges/checkout/gnome-boxes/src/libvirt-machine.vala"
	return NULL;
#line 5576 "util-app.c"
}


static void
_dbus_boxes_fdo_timedate1_set_timezone (BoxesFdotimedate1* self,
                                        GVariant* _value)
{
	gchar* value = NULL;
#line 535 "/home/fborges/checkout/gnome-boxes/src/libvirt-machine.vala"
	value = g_variant_dup_string (_value, NULL);
#line 535 "/home/fborges/checkout/gnome-boxes/src/libvirt-machine.vala"
	boxes_fdo_timedate1_set_timezone (self, value);
#line 535 "/home/fborges/checkout/gnome-boxes/src/libvirt-machine.vala"
	_g_free0 (value);
#line 5591 "util-app.c"
}


static gboolean
boxes_fdo_timedate1_dbus_interface_set_property (GDBusConnection* connection,
                                                 const gchar* sender,
                                                 const gchar* object_path,
                                                 const gchar* interface_name,
                                                 const gchar* property_name,
                                                 GVariant* value,
                                                 GError** error,
                                                 gpointer user_data)
{
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
#line 535 "/home/fborges/checkout/gnome-boxes/src/libvirt-machine.vala"
	if (strcmp (property_name, "Timezone") == 0) {
#line 535 "/home/fborges/checkout/gnome-boxes/src/libvirt-machine.vala"
		_dbus_boxes_fdo_timedate1_set_timezone (object, value);
#line 535 "/home/fborges/checkout/gnome-boxes/src/libvirt-machine.vala"
		return TRUE;
#line 5615 "util-app.c"
	}
#line 535 "/home/fborges/checkout/gnome-boxes/src/libvirt-machine.vala"
	return FALSE;
#line 5619 "util-app.c"
}


guint
boxes_fdo_timedate1_register_object (gpointer object,
                                     GDBusConnection* connection,
                                     const gchar* path,
                                     GError** error)
{
	guint result;
	gpointer *data;
#line 535 "/home/fborges/checkout/gnome-boxes/src/libvirt-machine.vala"
	data = g_new (gpointer, 3);
#line 535 "/home/fborges/checkout/gnome-boxes/src/libvirt-machine.vala"
	data[0] = g_object_ref (object);
#line 535 "/home/fborges/checkout/gnome-boxes/src/libvirt-machine.vala"
	data[1] = g_object_ref (connection);
#line 535 "/home/fborges/checkout/gnome-boxes/src/libvirt-machine.vala"
	data[2] = g_strdup (path);
#line 535 "/home/fborges/checkout/gnome-boxes/src/libvirt-machine.vala"
	result = g_dbus_connection_register_object (connection, path, (GDBusInterfaceInfo *) (&_boxes_fdo_timedate1_dbus_interface_info), &_boxes_fdo_timedate1_dbus_interface_vtable, data, _boxes_fdo_timedate1_unregister_object, error);
#line 535 "/home/fborges/checkout/gnome-boxes/src/libvirt-machine.vala"
	if (!result) {
#line 535 "/home/fborges/checkout/gnome-boxes/src/libvirt-machine.vala"
		return 0;
#line 5645 "util-app.c"
	}
#line 535 "/home/fborges/checkout/gnome-boxes/src/libvirt-machine.vala"
	return result;
#line 5649 "util-app.c"
}


static void
_boxes_fdo_timedate1_unregister_object (gpointer user_data)
{
	gpointer* data;
	data = user_data;
#line 535 "/home/fborges/checkout/gnome-boxes/src/libvirt-machine.vala"
	g_object_unref (data[0]);
#line 535 "/home/fborges/checkout/gnome-boxes/src/libvirt-machine.vala"
	g_object_unref (data[1]);
#line 535 "/home/fborges/checkout/gnome-boxes/src/libvirt-machine.vala"
	g_free (data[2]);
#line 535 "/home/fborges/checkout/gnome-boxes/src/libvirt-machine.vala"
	g_free (data);
#line 5666 "util-app.c"
}


gchar*
boxes_get_timezone (void)
{
	gchar* result = NULL;
	GError * _inner_error_ = NULL;
	{
		gchar* _tmp0_ = NULL;
		gchar* _tmp1_;
		gchar* _tmp2_;
#line 486 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
		_tmp1_ = boxes_get_timezone_from_systemd (&_inner_error_);
#line 486 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
		_tmp0_ = _tmp1_;
#line 486 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 5685 "util-app.c"
			goto __catch108_g_error;
		}
#line 486 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
		_tmp2_ = _tmp0_;
#line 486 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
		_tmp0_ = NULL;
#line 486 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
		result = _tmp2_;
#line 486 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
		_g_free0 (_tmp0_);
#line 486 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
		return result;
#line 5698 "util-app.c"
	}
	goto __finally108;
	__catch108_g_error:
	{
		GError* e = NULL;
		GError* _tmp3_;
		const gchar* _tmp4_;
#line 485 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
		e = _inner_error_;
#line 485 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
		_inner_error_ = NULL;
#line 489 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
		_tmp3_ = e;
#line 489 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
		_tmp4_ = _tmp3_->message;
#line 489 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
		g_debug ("util-app.vala:489: Failed to get timezone from systemd: %s", _tmp4_);
#line 5716 "util-app.c"
		{
			gchar* _tmp5_ = NULL;
			gchar* _tmp6_;
			gchar* _tmp7_;
#line 491 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
			_tmp6_ = boxes_get_timezone_from_linux (&_inner_error_);
#line 491 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
			_tmp5_ = _tmp6_;
#line 491 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
			if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 5727 "util-app.c"
				goto __catch109_g_error;
			}
#line 491 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
			_tmp7_ = _tmp5_;
#line 491 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
			_tmp5_ = NULL;
#line 491 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
			result = _tmp7_;
#line 491 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
			_g_free0 (_tmp5_);
#line 491 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
			_g_error_free0 (e);
#line 491 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
			return result;
#line 5742 "util-app.c"
		}
		goto __finally109;
		__catch109_g_error:
		{
			GError* e = NULL;
			GError* _tmp8_;
			const gchar* _tmp9_;
#line 490 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
			e = _inner_error_;
#line 490 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
			_inner_error_ = NULL;
#line 493 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
			_tmp8_ = e;
#line 493 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
			_tmp9_ = _tmp8_->message;
#line 493 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
			g_warning ("util-app.vala:493: Failed to find system timezone: %s", _tmp9_);
#line 495 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
			result = NULL;
#line 495 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
			_g_error_free0 (e);
#line 495 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
			_g_error_free0 (e);
#line 495 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
			return result;
#line 5768 "util-app.c"
		}
		__finally109:
#line 490 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
		_g_error_free0 (e);
#line 490 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
		_g_error_free0 (e);
#line 490 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
		g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 490 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
		g_clear_error (&_inner_error_);
#line 490 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
		return NULL;
#line 5781 "util-app.c"
	}
	__finally108:
#line 485 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 485 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
	g_clear_error (&_inner_error_);
#line 485 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
	return NULL;
#line 5790 "util-app.c"
}


gchar*
boxes_get_timezone_from_systemd (GError** error)
{
	gchar* result = NULL;
	BoxesFdotimedate1* timedate = NULL;
	BoxesFdotimedate1* _tmp0_;
	BoxesFdotimedate1* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gboolean _tmp5_;
	BoxesFdotimedate1* _tmp7_;
	gchar* _tmp8_;
	gchar* _tmp9_;
	GError * _inner_error_ = NULL;
#line 501 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
	_tmp0_ = g_initable_new (BOXES_FDO_TYPE_TIMEDATE1_PROXY, NULL, &_inner_error_, "g-flags", 0, "g-name", "org.freedesktop.timedate1", "g-bus-type", G_BUS_TYPE_SYSTEM, "g-object-path", "/org/freedesktop/timedate1", "g-interface-name", "org.freedesktop.timedate1", "g-interface-info", g_type_get_qdata (BOXES_FDO_TYPE_TIMEDATE1, g_quark_from_static_string ("vala-dbus-interface-info")), NULL);
#line 501 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
	timedate = (BoxesFdotimedate1*) _tmp0_;
#line 501 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 501 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
		g_propagate_error (error, _inner_error_);
#line 501 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
		return NULL;
#line 5819 "util-app.c"
	}
#line 504 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
	_tmp1_ = timedate;
#line 504 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
	_tmp2_ = boxes_fdo_timedate1_get_timezone (_tmp1_);
#line 504 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
	_tmp3_ = _tmp2_;
#line 504 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
	_tmp4_ = _tmp3_;
#line 504 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
	_tmp5_ = _tmp4_ == NULL;
#line 504 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
	_g_free0 (_tmp4_);
#line 504 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
	if (_tmp5_) {
#line 5835 "util-app.c"
		GError* _tmp6_;
#line 505 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
		_tmp6_ = g_error_new_literal (BOXES_ERROR, BOXES_ERROR_INVALID, "Failed to get timezone from systemd");
#line 505 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
		_inner_error_ = _tmp6_;
#line 505 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
		g_propagate_error (error, _inner_error_);
#line 505 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
		_g_object_unref0 (timedate);
#line 505 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
		return NULL;
#line 5847 "util-app.c"
	}
#line 507 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
	_tmp7_ = timedate;
#line 507 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
	_tmp8_ = boxes_fdo_timedate1_get_timezone (_tmp7_);
#line 507 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
	_tmp9_ = _tmp8_;
#line 507 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
	result = _tmp9_;
#line 507 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
	_g_object_unref0 (timedate);
#line 507 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
	return result;
#line 5861 "util-app.c"
}


gchar*
boxes_get_timezone_from_linux (GError** error)
{
	gchar* result = NULL;
	GFile* file = NULL;
	GFile* _tmp0_;
	GFileInfo* info = NULL;
	GFileInfo* _tmp2_;
	gchar* target = NULL;
	GFileInfo* _tmp3_;
	const gchar* _tmp4_;
	gchar* _tmp5_;
	const gchar* _tmp6_;
	gchar** tokens = NULL;
	const gchar* _tmp8_;
	gchar** _tmp9_;
	gchar** _tmp10_;
	gint tokens_length1;
	gint _tokens_size_;
	gboolean _tmp11_ = FALSE;
	gchar** _tmp12_;
	gint _tmp12__length1;
	gchar** _tmp16_;
	gint _tmp16__length1;
	const gchar* _tmp17_;
	gchar* _tmp18_;
	GError * _inner_error_ = NULL;
#line 513 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
	_tmp0_ = g_file_new_for_path (BOXES_TZ_FILE);
#line 513 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
	file = _tmp0_;
#line 514 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
	if (!g_file_query_exists (file, NULL)) {
#line 5898 "util-app.c"
		GError* _tmp1_;
#line 515 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
		_tmp1_ = g_error_new (BOXES_ERROR, BOXES_ERROR_INVALID, "Timezone file not found in expected location '%s'", BOXES_TZ_FILE);
#line 515 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
		_inner_error_ = _tmp1_;
#line 515 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
		g_propagate_error (error, _inner_error_);
#line 515 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
		_g_object_unref0 (file);
#line 515 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
		return NULL;
#line 5910 "util-app.c"
	}
#line 517 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
	_tmp2_ = g_file_query_info (file, G_FILE_ATTRIBUTE_STANDARD_SYMLINK_TARGET, G_FILE_QUERY_INFO_NOFOLLOW_SYMLINKS, NULL, &_inner_error_);
#line 517 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
	info = _tmp2_;
#line 517 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 517 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
		g_propagate_error (error, _inner_error_);
#line 517 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
		_g_object_unref0 (file);
#line 517 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
		return NULL;
#line 5924 "util-app.c"
	}
#line 518 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
	_tmp3_ = info;
#line 518 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
	_tmp4_ = g_file_info_get_symlink_target (_tmp3_);
#line 518 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
	_tmp5_ = g_strdup (_tmp4_);
#line 518 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
	target = _tmp5_;
#line 519 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
	_tmp6_ = target;
#line 519 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
	if (_tmp6_ == NULL) {
#line 5938 "util-app.c"
		GError* _tmp7_;
#line 520 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
		_tmp7_ = g_error_new (BOXES_ERROR, BOXES_ERROR_INVALID, "Timezone file '%s' is expected to be a symlink", BOXES_TZ_FILE);
#line 520 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
		_inner_error_ = _tmp7_;
#line 520 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
		g_propagate_error (error, _inner_error_);
#line 520 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
		_g_free0 (target);
#line 520 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
		_g_object_unref0 (info);
#line 520 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
		_g_object_unref0 (file);
#line 520 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
		return NULL;
#line 5954 "util-app.c"
	}
#line 522 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
	_tmp8_ = target;
#line 522 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
	_tmp10_ = _tmp9_ = g_strsplit (_tmp8_, "zoneinfo/", 0);
#line 522 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
	tokens = _tmp10_;
#line 522 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
	tokens_length1 = _vala_array_length (_tmp9_);
#line 522 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
	_tokens_size_ = tokens_length1;
#line 523 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
	_tmp12_ = tokens;
#line 523 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
	_tmp12__length1 = tokens_length1;
#line 523 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
	if (_tmp12_ == NULL) {
#line 523 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
		_tmp11_ = TRUE;
#line 5974 "util-app.c"
	} else {
		gchar** _tmp13_;
		gint _tmp13__length1;
#line 523 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
		_tmp13_ = tokens;
#line 523 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
		_tmp13__length1 = tokens_length1;
#line 523 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
		_tmp11_ = _tmp13__length1 < 2;
#line 5984 "util-app.c"
	}
#line 523 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
	if (_tmp11_) {
#line 5988 "util-app.c"
		const gchar* _tmp14_;
		GError* _tmp15_;
#line 524 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
		_tmp14_ = target;
#line 524 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
		_tmp15_ = g_error_new (BOXES_ERROR, BOXES_ERROR_INVALID, "Timezone file in unexpected location '%s'", _tmp14_);
#line 524 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
		_inner_error_ = _tmp15_;
#line 524 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
		g_propagate_error (error, _inner_error_);
#line 524 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
		tokens = (_vala_array_free (tokens, tokens_length1, (GDestroyNotify) g_free), NULL);
#line 524 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
		_g_free0 (target);
#line 524 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
		_g_object_unref0 (info);
#line 524 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
		_g_object_unref0 (file);
#line 524 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
		return NULL;
#line 6009 "util-app.c"
	}
#line 526 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
	_tmp16_ = tokens;
#line 526 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
	_tmp16__length1 = tokens_length1;
#line 526 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
	_tmp17_ = _tmp16_[1];
#line 526 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
	_tmp18_ = g_strdup (_tmp17_);
#line 526 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
	result = _tmp18_;
#line 526 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
	tokens = (_vala_array_free (tokens, tokens_length1, (GDestroyNotify) g_free), NULL);
#line 526 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
	_g_free0 (target);
#line 526 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
	_g_object_unref0 (info);
#line 526 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
	_g_object_unref0 (file);
#line 526 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
	return result;
#line 6031 "util-app.c"
}


static void
boxes_move_configs_from_cache_data_free (gpointer _data)
{
	BoxesMoveConfigsFromCacheData* _data_;
	_data_ = _data;
#line 535 "/home/fborges/checkout/gnome-boxes/src/libvirt-machine.vala"
	g_slice_free (BoxesMoveConfigsFromCacheData, _data_);
#line 6042 "util-app.c"
}


static void
boxes_move_configs_from_cache_async_ready_wrapper (GObject *source_object,
                                                   GAsyncResult *res,
                                                   void *user_data)
{
	BoxesMoveConfigsFromCacheData* _task_data_;
#line 535 "/home/fborges/checkout/gnome-boxes/src/libvirt-machine.vala"
	_task_data_ = g_task_get_task_data (G_TASK (res));
#line 535 "/home/fborges/checkout/gnome-boxes/src/libvirt-machine.vala"
	if (_task_data_->_callback_ != NULL) {
#line 535 "/home/fborges/checkout/gnome-boxes/src/libvirt-machine.vala"
		_task_data_->_callback_ (source_object, res, user_data);
#line 6058 "util-app.c"
	}
#line 535 "/home/fborges/checkout/gnome-boxes/src/libvirt-machine.vala"
	_task_data_->_task_complete_ = TRUE;
#line 6062 "util-app.c"
}


void
boxes_move_configs_from_cache (GAsyncReadyCallback _callback_,
                               gpointer _user_data_)
{
	BoxesMoveConfigsFromCacheData* _data_;
#line 535 "/home/fborges/checkout/gnome-boxes/src/libvirt-machine.vala"
	_data_ = g_slice_new0 (BoxesMoveConfigsFromCacheData);
#line 535 "/home/fborges/checkout/gnome-boxes/src/libvirt-machine.vala"
	_data_->_callback_ = _callback_;
#line 535 "/home/fborges/checkout/gnome-boxes/src/libvirt-machine.vala"
	_data_->_async_result = g_task_new (NULL, NULL, boxes_move_configs_from_cache_async_ready_wrapper, _user_data_);
#line 535 "/home/fborges/checkout/gnome-boxes/src/libvirt-machine.vala"
	if (_callback_ == NULL) {
#line 535 "/home/fborges/checkout/gnome-boxes/src/libvirt-machine.vala"
		_data_->_task_complete_ = TRUE;
#line 6081 "util-app.c"
	}
#line 535 "/home/fborges/checkout/gnome-boxes/src/libvirt-machine.vala"
	g_task_set_task_data (_data_->_async_result, _data_, boxes_move_configs_from_cache_data_free);
#line 535 "/home/fborges/checkout/gnome-boxes/src/libvirt-machine.vala"
	boxes_move_configs_from_cache_co (_data_);
#line 6087 "util-app.c"
}


void
boxes_move_configs_from_cache_finish (GAsyncResult* _res_)
{
	BoxesMoveConfigsFromCacheData* _data_;
#line 535 "/home/fborges/checkout/gnome-boxes/src/libvirt-machine.vala"
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
#line 6097 "util-app.c"
}


static void
boxes_move_configs_from_cache_ready (GObject* source_object,
                                     GAsyncResult* _res_,
                                     gpointer _user_data_)
{
	BoxesMoveConfigsFromCacheData* _data_;
#line 531 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
	_data_ = _user_data_;
#line 531 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
	_data_->_source_object_ = source_object;
#line 531 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
	_data_->_res_ = _res_;
#line 531 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
	_data_->_task_complete_ = TRUE;
#line 531 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
	boxes_move_configs_from_cache_co (_data_);
#line 6117 "util-app.c"
}


static gboolean
boxes_move_configs_from_cache_co (BoxesMoveConfigsFromCacheData* _data_)
{
#line 530 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
	switch (_data_->_state_) {
#line 530 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
		case 0:
#line 6128 "util-app.c"
		goto _state_0;
#line 530 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
		case 1:
#line 6132 "util-app.c"
		goto _state_1;
#line 530 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
		case 2:
#line 6136 "util-app.c"
		goto _state_2;
		default:
#line 530 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
		g_assert_not_reached ();
#line 6141 "util-app.c"
	}
	_state_0:
#line 531 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
	_data_->_state_ = 1;
#line 531 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
	boxes_move_config_from_cache ("unattended", boxes_move_configs_from_cache_ready, _data_);
#line 531 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
	return FALSE;
#line 6150 "util-app.c"
	_state_1:
#line 531 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
	boxes_move_config_from_cache_finish (_data_->_res_);
#line 532 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
	_data_->_state_ = 2;
#line 532 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
	boxes_move_config_from_cache ("sources", boxes_move_configs_from_cache_ready, _data_);
#line 532 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
	return FALSE;
#line 6160 "util-app.c"
	_state_2:
#line 532 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
	boxes_move_config_from_cache_finish (_data_->_res_);
#line 530 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
#line 530 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
	if (_data_->_state_ != 0) {
#line 530 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
		while (_data_->_task_complete_ != TRUE) {
#line 530 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
#line 6172 "util-app.c"
		}
	}
#line 530 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
	g_object_unref (_data_->_async_result);
#line 530 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
	return FALSE;
#line 6179 "util-app.c"
}


static void
boxes_move_config_from_cache_data_free (gpointer _data)
{
	BoxesMoveConfigFromCacheData* _data_;
	_data_ = _data;
#line 535 "/home/fborges/checkout/gnome-boxes/src/libvirt-machine.vala"
	_g_free0 (_data_->config_name);
#line 535 "/home/fborges/checkout/gnome-boxes/src/libvirt-machine.vala"
	g_slice_free (BoxesMoveConfigFromCacheData, _data_);
#line 6192 "util-app.c"
}


static void
boxes_move_config_from_cache_async_ready_wrapper (GObject *source_object,
                                                  GAsyncResult *res,
                                                  void *user_data)
{
	BoxesMoveConfigFromCacheData* _task_data_;
#line 535 "/home/fborges/checkout/gnome-boxes/src/libvirt-machine.vala"
	_task_data_ = g_task_get_task_data (G_TASK (res));
#line 535 "/home/fborges/checkout/gnome-boxes/src/libvirt-machine.vala"
	if (_task_data_->_callback_ != NULL) {
#line 535 "/home/fborges/checkout/gnome-boxes/src/libvirt-machine.vala"
		_task_data_->_callback_ (source_object, res, user_data);
#line 6208 "util-app.c"
	}
#line 535 "/home/fborges/checkout/gnome-boxes/src/libvirt-machine.vala"
	_task_data_->_task_complete_ = TRUE;
#line 6212 "util-app.c"
}


void
boxes_move_config_from_cache (const gchar* config_name,
                              GAsyncReadyCallback _callback_,
                              gpointer _user_data_)
{
	BoxesMoveConfigFromCacheData* _data_;
	gchar* _tmp0_;
#line 535 "/home/fborges/checkout/gnome-boxes/src/libvirt-machine.vala"
	_data_ = g_slice_new0 (BoxesMoveConfigFromCacheData);
#line 535 "/home/fborges/checkout/gnome-boxes/src/libvirt-machine.vala"
	_data_->_callback_ = _callback_;
#line 535 "/home/fborges/checkout/gnome-boxes/src/libvirt-machine.vala"
	_data_->_async_result = g_task_new (NULL, NULL, boxes_move_config_from_cache_async_ready_wrapper, _user_data_);
#line 535 "/home/fborges/checkout/gnome-boxes/src/libvirt-machine.vala"
	if (_callback_ == NULL) {
#line 535 "/home/fborges/checkout/gnome-boxes/src/libvirt-machine.vala"
		_data_->_task_complete_ = TRUE;
#line 6233 "util-app.c"
	}
#line 535 "/home/fborges/checkout/gnome-boxes/src/libvirt-machine.vala"
	g_task_set_task_data (_data_->_async_result, _data_, boxes_move_config_from_cache_data_free);
#line 535 "/home/fborges/checkout/gnome-boxes/src/libvirt-machine.vala"
	_tmp0_ = g_strdup (config_name);
#line 535 "/home/fborges/checkout/gnome-boxes/src/libvirt-machine.vala"
	_g_free0 (_data_->config_name);
#line 535 "/home/fborges/checkout/gnome-boxes/src/libvirt-machine.vala"
	_data_->config_name = _tmp0_;
#line 535 "/home/fborges/checkout/gnome-boxes/src/libvirt-machine.vala"
	boxes_move_config_from_cache_co (_data_);
#line 6245 "util-app.c"
}


void
boxes_move_config_from_cache_finish (GAsyncResult* _res_)
{
	BoxesMoveConfigFromCacheData* _data_;
#line 535 "/home/fborges/checkout/gnome-boxes/src/libvirt-machine.vala"
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
#line 6255 "util-app.c"
}


static void
boxes_move_config_from_cache_ready (GObject* source_object,
                                    GAsyncResult* _res_,
                                    gpointer _user_data_)
{
	BoxesMoveConfigFromCacheData* _data_;
#line 541 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
	_data_ = _user_data_;
#line 541 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
	_data_->_source_object_ = source_object;
#line 541 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
	_data_->_res_ = _res_;
#line 541 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
	_data_->_task_complete_ = TRUE;
#line 541 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
	boxes_move_config_from_cache_co (_data_);
#line 6275 "util-app.c"
}


static void
_g_object_unref0_ (gpointer var)
{
#line 545 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
#line 6284 "util-app.c"
}


static inline void
_g_list_free__g_object_unref0_ (GList* self)
{
#line 545 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
	g_list_free_full (self, (GDestroyNotify) _g_object_unref0_);
#line 6293 "util-app.c"
}


static gboolean
boxes_move_config_from_cache_co (BoxesMoveConfigFromCacheData* _data_)
{
#line 535 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
	switch (_data_->_state_) {
#line 535 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
		case 0:
#line 6304 "util-app.c"
		goto _state_0;
#line 535 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
		case 1:
#line 6308 "util-app.c"
		goto _state_1;
#line 535 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
		case 2:
#line 6312 "util-app.c"
		goto _state_2;
#line 535 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
		case 3:
#line 6316 "util-app.c"
		goto _state_3;
		default:
#line 535 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
		g_assert_not_reached ();
#line 6321 "util-app.c"
	}
	_state_0:
#line 536 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
	_data_->_tmp0_ = boxes_get_cache (_data_->config_name, NULL);
#line 536 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
	_data_->path = _data_->_tmp0_;
#line 537 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
	_data_->_tmp1_ = _data_->path;
#line 537 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
	_data_->_tmp2_ = g_file_new_for_path (_data_->_tmp1_);
#line 537 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
	_data_->cache_dir = _data_->_tmp2_;
#line 538 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
	_data_->_tmp3_ = boxes_get_user_pkgconfig (NULL);
#line 538 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
	_data_->_tmp4_ = _data_->_tmp3_;
#line 538 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
	_data_->_tmp5_ = g_build_filename (_data_->_tmp4_, _data_->config_name, NULL);
#line 538 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
	_data_->_tmp6_ = _data_->_tmp5_;
#line 538 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
	_g_free0 (_data_->_tmp4_);
#line 538 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
	_data_->config_path = _data_->_tmp6_;
#line 6346 "util-app.c"
	{
#line 541 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
		_data_->_tmp7_ = _data_->cache_dir;
#line 541 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
		_data_->_state_ = 1;
#line 541 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
		g_file_enumerate_children_async (_data_->_tmp7_, G_FILE_ATTRIBUTE_STANDARD_NAME, 0, G_PRIORITY_DEFAULT, NULL, boxes_move_config_from_cache_ready, _data_);
#line 541 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
		return FALSE;
#line 6356 "util-app.c"
		_state_1:
#line 541 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
		_data_->_tmp8_ = g_file_enumerate_children_finish (_data_->_tmp7_, _data_->_res_, &_data_->_inner_error_);
#line 541 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
		_data_->enumerator = _data_->_tmp8_;
#line 541 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
		if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
#line 541 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
			if (g_error_matches (_data_->_inner_error_, G_IO_ERROR, G_IO_ERROR_NOT_FOUND)) {
#line 6366 "util-app.c"
				goto __catch110_g_io_error_not_found;
			}
			goto __catch110_g_error;
		}
#line 542 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
		while (TRUE) {
#line 543 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
			_data_->_tmp9_ = _data_->enumerator;
#line 543 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
			_data_->_state_ = 2;
#line 543 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
			g_file_enumerator_next_files_async (_data_->_tmp9_, 10, G_PRIORITY_DEFAULT, NULL, boxes_move_config_from_cache_ready, _data_);
#line 543 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
			return FALSE;
#line 6381 "util-app.c"
			_state_2:
#line 543 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
			_data_->_tmp10_ = g_file_enumerator_next_files_finish (_data_->_tmp9_, _data_->_res_, &_data_->_inner_error_);
#line 543 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
			_data_->files = _data_->_tmp10_;
#line 543 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
			if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
#line 543 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
				_g_object_unref0 (_data_->enumerator);
#line 543 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
				if (g_error_matches (_data_->_inner_error_, G_IO_ERROR, G_IO_ERROR_NOT_FOUND)) {
#line 6393 "util-app.c"
					goto __catch110_g_io_error_not_found;
				}
				goto __catch110_g_error;
			}
#line 544 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
			_data_->_tmp11_ = _data_->files;
#line 544 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
			if (_data_->_tmp11_ == NULL) {
#line 545 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
				__g_list_free__g_object_unref0_0 (_data_->files);
#line 545 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
				break;
#line 6406 "util-app.c"
			}
#line 547 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
			_data_->_tmp12_ = _data_->files;
#line 6410 "util-app.c"
			{
#line 547 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
				_data_->info_collection = _data_->_tmp12_;
#line 547 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
				for (_data_->info_it = _data_->info_collection; _data_->info_it != NULL; _data_->info_it = _data_->info_it->next) {
#line 547 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
					_data_->_tmp13_ = _g_object_ref0 ((GFileInfo*) _data_->info_it->data);
#line 547 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
					_data_->info = _data_->_tmp13_;
#line 6420 "util-app.c"
					{
#line 548 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
						_data_->_tmp14_ = _data_->cache_dir;
#line 548 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
						_data_->_tmp15_ = g_file_get_path (_data_->_tmp14_);
#line 548 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
						_data_->_tmp16_ = _data_->_tmp15_;
#line 548 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
						_data_->_tmp17_ = _data_->info;
#line 548 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
						_data_->_tmp18_ = g_file_info_get_name (_data_->_tmp17_);
#line 548 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
						_data_->_tmp19_ = g_build_filename (_data_->_tmp16_, _data_->_tmp18_, NULL);
#line 548 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
						_g_free0 (_data_->path);
#line 548 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
						_data_->path = _data_->_tmp19_;
#line 548 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
						_g_free0 (_data_->_tmp16_);
#line 549 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
						_data_->_tmp20_ = _data_->path;
#line 549 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
						_data_->_tmp21_ = g_file_new_for_path (_data_->_tmp20_);
#line 549 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
						_data_->cache_file = _data_->_tmp21_;
#line 550 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
						_data_->_tmp22_ = _data_->config_path;
#line 550 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
						_data_->_tmp23_ = _data_->info;
#line 550 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
						_data_->_tmp24_ = g_file_info_get_name (_data_->_tmp23_);
#line 550 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
						_data_->_tmp25_ = g_build_filename (_data_->_tmp22_, _data_->_tmp24_, NULL);
#line 550 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
						_g_free0 (_data_->path);
#line 550 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
						_data_->path = _data_->_tmp25_;
#line 551 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
						_data_->_tmp26_ = _data_->path;
#line 551 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
						_data_->_tmp27_ = g_file_new_for_path (_data_->_tmp26_);
#line 551 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
						_data_->config_file = _data_->_tmp27_;
#line 553 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
						_data_->_tmp28_ = _data_->cache_file;
#line 553 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
						_data_->_tmp29_ = _data_->config_file;
#line 553 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
						g_file_move (_data_->_tmp28_, _data_->_tmp29_, G_FILE_COPY_OVERWRITE, NULL, NULL, NULL, &_data_->_inner_error_);
#line 553 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
						if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
#line 553 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
							_g_object_unref0 (_data_->config_file);
#line 553 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
							_g_object_unref0 (_data_->cache_file);
#line 553 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
							_g_object_unref0 (_data_->info);
#line 553 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
							__g_list_free__g_object_unref0_0 (_data_->files);
#line 553 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
							_g_object_unref0 (_data_->enumerator);
#line 553 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
							if (g_error_matches (_data_->_inner_error_, G_IO_ERROR, G_IO_ERROR_NOT_FOUND)) {
#line 6484 "util-app.c"
								goto __catch110_g_io_error_not_found;
							}
							goto __catch110_g_error;
						}
#line 554 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
						_data_->_tmp30_ = _data_->cache_file;
#line 554 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
						_data_->_tmp31_ = g_file_get_path (_data_->_tmp30_);
#line 554 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
						_data_->_tmp32_ = _data_->_tmp31_;
#line 554 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
						_data_->_tmp33_ = _data_->config_file;
#line 554 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
						_data_->_tmp34_ = g_file_get_path (_data_->_tmp33_);
#line 554 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
						_data_->_tmp35_ = _data_->_tmp34_;
#line 554 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
						g_debug ("util-app.vala:554: moved %s to %s", _data_->_tmp32_, _data_->_tmp35_);
#line 554 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
						_g_free0 (_data_->_tmp35_);
#line 554 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
						_g_free0 (_data_->_tmp32_);
#line 547 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
						_g_object_unref0 (_data_->config_file);
#line 547 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
						_g_object_unref0 (_data_->cache_file);
#line 547 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
						_g_object_unref0 (_data_->info);
#line 6513 "util-app.c"
					}
				}
			}
#line 542 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
			__g_list_free__g_object_unref0_0 (_data_->files);
#line 6519 "util-app.c"
		}
#line 558 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
		_data_->_tmp36_ = _data_->cache_dir;
#line 558 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
		_data_->_state_ = 3;
#line 558 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
		g_file_delete_async (_data_->_tmp36_, G_PRIORITY_DEFAULT, NULL, boxes_move_config_from_cache_ready, _data_);
#line 558 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
		return FALSE;
#line 6529 "util-app.c"
		_state_3:
#line 558 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
		g_file_delete_finish (_data_->_tmp36_, _data_->_res_, &_data_->_inner_error_);
#line 558 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
		if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
#line 558 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
			_g_object_unref0 (_data_->enumerator);
#line 558 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
			if (g_error_matches (_data_->_inner_error_, G_IO_ERROR, G_IO_ERROR_NOT_FOUND)) {
#line 6539 "util-app.c"
				goto __catch110_g_io_error_not_found;
			}
			goto __catch110_g_error;
		}
#line 540 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
		_g_object_unref0 (_data_->enumerator);
#line 6546 "util-app.c"
	}
	goto __finally110;
	__catch110_g_io_error_not_found:
	{
#line 540 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
		_data_->_error_ = _data_->_inner_error_;
#line 540 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
		_data_->_inner_error_ = NULL;
#line 540 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
		_g_error_free0 (_data_->_error_);
#line 6557 "util-app.c"
	}
	goto __finally110;
	__catch110_g_error:
	{
#line 540 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
		_data_->_vala1__error_ = _data_->_inner_error_;
#line 540 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
		_data_->_inner_error_ = NULL;
#line 562 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
		_data_->_tmp37_ = _data_->_vala1__error_;
#line 562 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
		_data_->_tmp38_ = _data_->_tmp37_->message;
#line 562 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
		g_warning ("util-app.vala:562: %s", _data_->_tmp38_);
#line 540 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
		_g_error_free0 (_data_->_vala1__error_);
#line 6574 "util-app.c"
	}
	__finally110:
#line 540 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
	if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
#line 540 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
		_g_free0 (_data_->config_path);
#line 540 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
		_g_object_unref0 (_data_->cache_dir);
#line 540 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
		_g_free0 (_data_->path);
#line 540 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
#line 540 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
		g_clear_error (&_data_->_inner_error_);
#line 540 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
		g_object_unref (_data_->_async_result);
#line 540 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
		return FALSE;
#line 6593 "util-app.c"
	}
#line 535 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
	_g_free0 (_data_->config_path);
#line 535 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
	_g_object_unref0 (_data_->cache_dir);
#line 535 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
	_g_free0 (_data_->path);
#line 535 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
#line 535 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
	if (_data_->_state_ != 0) {
#line 535 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
		while (_data_->_task_complete_ != TRUE) {
#line 535 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
#line 6609 "util-app.c"
		}
	}
#line 535 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
	g_object_unref (_data_->_async_result);
#line 535 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
	return FALSE;
#line 6616 "util-app.c"
}


gchar*
boxes_uuid_generate (void)
{
	gchar* result = NULL;
	guchar* udn = NULL;
	guchar* _tmp0_;
	gint udn_length1;
	gint _udn_size_;
	guchar* id = NULL;
	guchar* _tmp1_;
	gint id_length1;
	gint _id_size_;
	gchar* _tmp2_;
#line 575 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
	_tmp0_ = g_new0 (guchar, 50);
#line 575 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
	udn = _tmp0_;
#line 575 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
	udn_length1 = 50;
#line 575 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
	_udn_size_ = udn_length1;
#line 576 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
	_tmp1_ = g_new0 (guchar, 16);
#line 576 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
	id = _tmp1_;
#line 576 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
	id_length1 = 16;
#line 576 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
	_id_size_ = id_length1;
#line 578 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
	uuid_generate (id);
#line 579 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
	uuid_unparse (id, udn);
#line 581 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
	_tmp2_ = g_strdup ((const gchar*) udn);
#line 581 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
	result = _tmp2_;
#line 581 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
	id = (g_free (id), NULL);
#line 581 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
	udn = (g_free (udn), NULL);
#line 581 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
	return result;
#line 6663 "util-app.c"
}


GIcon*
boxes_create_symbolic_emblem (const gchar* name)
{
	GIcon* result = NULL;
	GIcon* pix = NULL;
	GIcon* _tmp0_;
	GIcon* _tmp1_;
#line 585 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
	g_return_val_if_fail (name != NULL, NULL);
#line 586 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
	_tmp0_ = gd_create_symbolic_icon (name, 128);
#line 586 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
	pix = _tmp0_;
#line 588 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
	_tmp1_ = pix;
#line 588 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
	if (_tmp1_ == NULL) {
#line 6684 "util-app.c"
		GThemedIcon* _tmp2_;
#line 589 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
		_tmp2_ = (GThemedIcon*) g_themed_icon_new (name);
#line 589 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
		_g_object_unref0 (pix);
#line 589 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
		pix = (GIcon*) _tmp2_;
#line 6692 "util-app.c"
	}
#line 591 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
	result = pix;
#line 591 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
	return result;
#line 6698 "util-app.c"
}


GdkPixbuf*
boxes_paint_empty_frame (gint width,
                         gint height,
                         gdouble radius,
                         GdkRGBA* border_color,
                         GdkRGBA* bg_color)
{
	GdkPixbuf* result = NULL;
	cairo_surface_t* surface = NULL;
	cairo_surface_t* _tmp0_;
	cairo_t* cr = NULL;
	cairo_surface_t* _tmp1_;
	cairo_t* _tmp2_;
	cairo_t* _tmp9_;
	GdkRGBA _tmp10_;
	gdouble _tmp11_;
	GdkRGBA _tmp12_;
	gdouble _tmp13_;
	GdkRGBA _tmp14_;
	gdouble _tmp15_;
	GdkRGBA _tmp16_;
	gdouble _tmp17_;
	cairo_t* _tmp18_;
	cairo_surface_t* _tmp19_;
	GdkPixbuf* _tmp20_;
#line 594 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
	g_return_val_if_fail (border_color != NULL, NULL);
#line 595 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
	_tmp0_ = cairo_image_surface_create (CAIRO_FORMAT_ARGB32, width, height);
#line 595 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
	surface = _tmp0_;
#line 596 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
	_tmp1_ = surface;
#line 596 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
	_tmp2_ = cairo_create (_tmp1_);
#line 596 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
	cr = _tmp2_;
#line 598 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
	if (bg_color != NULL) {
#line 6741 "util-app.c"
		cairo_t* _tmp3_;
		gdouble _tmp4_;
		gdouble _tmp5_;
		gdouble _tmp6_;
		gdouble _tmp7_;
		cairo_t* _tmp8_;
#line 599 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
		_tmp3_ = cr;
#line 599 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
		_tmp4_ = (*bg_color).red;
#line 599 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
		_tmp5_ = (*bg_color).green;
#line 599 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
		_tmp6_ = (*bg_color).blue;
#line 599 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
		_tmp7_ = (*bg_color).alpha;
#line 599 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
		cairo_set_source_rgba (_tmp3_, _tmp4_, _tmp5_, _tmp6_, _tmp7_);
#line 600 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
		_tmp8_ = cr;
#line 600 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
		boxes_paint_frame_background (_tmp8_, width, height, radius);
#line 6764 "util-app.c"
	}
#line 603 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
	_tmp9_ = cr;
#line 603 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
	_tmp10_ = *border_color;
#line 603 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
	_tmp11_ = _tmp10_.red;
#line 603 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
	_tmp12_ = *border_color;
#line 603 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
	_tmp13_ = _tmp12_.green;
#line 603 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
	_tmp14_ = *border_color;
#line 603 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
	_tmp15_ = _tmp14_.blue;
#line 603 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
	_tmp16_ = *border_color;
#line 603 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
	_tmp17_ = _tmp16_.alpha;
#line 603 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
	cairo_set_source_rgba (_tmp9_, _tmp11_, _tmp13_, _tmp15_, _tmp17_);
#line 604 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
	_tmp18_ = cr;
#line 604 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
	boxes_paint_frame_border (_tmp18_, width, height, radius);
#line 606 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
	_tmp19_ = surface;
#line 606 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
	_tmp20_ = gdk_pixbuf_get_from_surface (_tmp19_, 0, 0, width, height);
#line 606 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
	result = _tmp20_;
#line 606 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
	_cairo_destroy0 (cr);
#line 606 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
	_cairo_surface_destroy0 (surface);
#line 606 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
	return result;
#line 6802 "util-app.c"
}


void
boxes_paint_frame_background (cairo_t* cr,
                              gint width,
                              gint height,
                              gdouble radius)
{
#line 609 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
	g_return_if_fail (cr != NULL);
#line 610 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
	boxes_rounded_rectangle (cr, 0.5, 0.5, (gdouble) (width - 1), (gdouble) (height - 1), radius);
#line 611 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
	cairo_fill (cr);
#line 6818 "util-app.c"
}


void
boxes_paint_frame_border (cairo_t* cr,
                          gint width,
                          gint height,
                          gdouble radius)
{
#line 614 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
	g_return_if_fail (cr != NULL);
#line 615 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
	cairo_set_line_width (cr, 1.0);
#line 617 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
	boxes_rounded_rectangle (cr, 0.5, 0.5, (gdouble) (width - 1), (gdouble) (height - 1), radius);
#line 618 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
	cairo_stroke (cr);
#line 6836 "util-app.c"
}


void
boxes_rounded_rectangle (cairo_t* cr,
                         gdouble x,
                         gdouble y,
                         gdouble width,
                         gdouble height,
                         gdouble radius)
{
#line 622 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
	static const gdouble ARC_0 = (gdouble) 0;
#line 623 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
	static const gdouble ARC_1 = G_PI * 0.5;
#line 624 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
	static const gdouble ARC_2 = G_PI;
#line 625 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
	static const gdouble ARC_3 = G_PI * 1.5;
#line 621 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
	g_return_if_fail (cr != NULL);
#line 627 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
	cairo_new_sub_path (cr);
#line 628 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
	cairo_arc (cr, (x + width) - radius, y + radius, radius, ARC_3, ARC_0);
#line 629 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
	cairo_arc (cr, (x + width) - radius, (y + height) - radius, radius, ARC_0, ARC_1);
#line 630 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
	cairo_arc (cr, x + radius, (y + height) - radius, radius, ARC_1, ARC_2);
#line 631 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
	cairo_arc (cr, x + radius, y + radius, radius, ARC_2, ARC_3);
#line 632 "/home/fborges/checkout/gnome-boxes/src/util-app.vala"
	cairo_close_path (cr);
#line 6870 "util-app.c"
}


static void
_vala_array_destroy (gpointer array,
                     gint array_length,
                     GDestroyNotify destroy_func)
{
#line 535 "/home/fborges/checkout/gnome-boxes/src/libvirt-machine.vala"
	if ((array != NULL) && (destroy_func != NULL)) {
#line 6881 "util-app.c"
		int i;
#line 535 "/home/fborges/checkout/gnome-boxes/src/libvirt-machine.vala"
		for (i = 0; i < array_length; i = i + 1) {
#line 535 "/home/fborges/checkout/gnome-boxes/src/libvirt-machine.vala"
			if (((gpointer*) array)[i] != NULL) {
#line 535 "/home/fborges/checkout/gnome-boxes/src/libvirt-machine.vala"
				destroy_func (((gpointer*) array)[i]);
#line 6889 "util-app.c"
			}
		}
	}
}


static void
_vala_array_free (gpointer array,
                  gint array_length,
                  GDestroyNotify destroy_func)
{
#line 535 "/home/fborges/checkout/gnome-boxes/src/libvirt-machine.vala"
	_vala_array_destroy (array, array_length, destroy_func);
#line 535 "/home/fborges/checkout/gnome-boxes/src/libvirt-machine.vala"
	g_free (array);
#line 6905 "util-app.c"
}


static gint
_vala_array_length (gpointer array)
{
	int length;
	length = 0;
#line 535 "/home/fborges/checkout/gnome-boxes/src/libvirt-machine.vala"
	if (array) {
#line 535 "/home/fborges/checkout/gnome-boxes/src/libvirt-machine.vala"
		while (((gpointer*) array)[length]) {
#line 535 "/home/fborges/checkout/gnome-boxes/src/libvirt-machine.vala"
			length++;
#line 6920 "util-app.c"
		}
	}
#line 535 "/home/fborges/checkout/gnome-boxes/src/libvirt-machine.vala"
	return length;
#line 6925 "util-app.c"
}



