/* vnc-display.c generated by valac 0.39.5, the Vala compiler
 * generated from vnc-display.vala, do not modify */

/* This file is part of GNOME Boxes. License: LGPLv2+*/

#include <glib.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include <gdk-pixbuf/gdk-pixbuf.h>
#include <libcommon.h>
#include <stdlib.h>
#include <string.h>
#include <gtk-vnc.h>
#include <libxml/uri.h>
#include <float.h>
#include <math.h>
#include <cairo.h>


#define BOXES_TYPE_IPROPERTIES_PROVIDER (boxes_iproperties_provider_get_type ())
#define BOXES_IPROPERTIES_PROVIDER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), BOXES_TYPE_IPROPERTIES_PROVIDER, BoxesIPropertiesProvider))
#define BOXES_IS_IPROPERTIES_PROVIDER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), BOXES_TYPE_IPROPERTIES_PROVIDER))
#define BOXES_IPROPERTIES_PROVIDER_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), BOXES_TYPE_IPROPERTIES_PROVIDER, BoxesIPropertiesProviderIface))

typedef struct _BoxesIPropertiesProvider BoxesIPropertiesProvider;
typedef struct _BoxesIPropertiesProviderIface BoxesIPropertiesProviderIface;

#define BOXES_TYPE_PROPERTIES_PAGE (boxes_properties_page_get_type ())

#define BOXES_TYPE_PROPERTY (boxes_property_get_type ())
#define BOXES_PROPERTY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), BOXES_TYPE_PROPERTY, BoxesProperty))
#define BOXES_PROPERTY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), BOXES_TYPE_PROPERTY, BoxesPropertyClass))
#define BOXES_IS_PROPERTY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), BOXES_TYPE_PROPERTY))
#define BOXES_IS_PROPERTY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), BOXES_TYPE_PROPERTY))
#define BOXES_PROPERTY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), BOXES_TYPE_PROPERTY, BoxesPropertyClass))

typedef struct _BoxesProperty BoxesProperty;
typedef struct _BoxesPropertyClass BoxesPropertyClass;

#define BOXES_TYPE_DISPLAY (boxes_display_get_type ())
#define BOXES_DISPLAY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), BOXES_TYPE_DISPLAY, BoxesDisplay))
#define BOXES_DISPLAY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), BOXES_TYPE_DISPLAY, BoxesDisplayClass))
#define BOXES_IS_DISPLAY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), BOXES_TYPE_DISPLAY))
#define BOXES_IS_DISPLAY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), BOXES_TYPE_DISPLAY))
#define BOXES_DISPLAY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), BOXES_TYPE_DISPLAY, BoxesDisplayClass))

typedef struct _BoxesDisplay BoxesDisplay;
typedef struct _BoxesDisplayClass BoxesDisplayClass;
typedef struct _BoxesDisplayPrivate BoxesDisplayPrivate;

#define BOXES_TYPE_VNC_DISPLAY (boxes_vnc_display_get_type ())
#define BOXES_VNC_DISPLAY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), BOXES_TYPE_VNC_DISPLAY, BoxesVncDisplay))
#define BOXES_VNC_DISPLAY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), BOXES_TYPE_VNC_DISPLAY, BoxesVncDisplayClass))
#define BOXES_IS_VNC_DISPLAY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), BOXES_TYPE_VNC_DISPLAY))
#define BOXES_IS_VNC_DISPLAY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), BOXES_TYPE_VNC_DISPLAY))
#define BOXES_VNC_DISPLAY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), BOXES_TYPE_VNC_DISPLAY, BoxesVncDisplayClass))

typedef struct _BoxesVncDisplay BoxesVncDisplay;
typedef struct _BoxesVncDisplayClass BoxesVncDisplayClass;
typedef struct _BoxesVncDisplayPrivate BoxesVncDisplayPrivate;
enum  {
	BOXES_VNC_DISPLAY_0_PROPERTY,
	BOXES_VNC_DISPLAY_PROTOCOL_PROPERTY,
	BOXES_VNC_DISPLAY_URI_PROPERTY,
	BOXES_VNC_DISPLAY_NUM_PROPERTIES
};
static GParamSpec* boxes_vnc_display_properties[BOXES_VNC_DISPLAY_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _xmlFreeURI0(var) ((var == NULL) ? NULL : (var = (xmlFreeURI (var), NULL)))
#define __g_list_free__g_object_unref0_0(var) ((var == NULL) ? NULL : (var = (_g_list_free__g_object_unref0_ (var), NULL)))

typedef enum  {
	BOXES_PROPERTIES_PAGE_GENERAL,
	BOXES_PROPERTIES_PAGE_SYSTEM,
	BOXES_PROPERTIES_PAGE_DEVICES,
	BOXES_PROPERTIES_PAGE_SNAPSHOTS,
	BOXES_PROPERTIES_PAGE_LAST
} BoxesPropertiesPage;

struct _BoxesIPropertiesProviderIface {
	GTypeInterface parent_iface;
	GList* (*get_properties) (BoxesIPropertiesProvider* self, BoxesPropertiesPage page);
};

typedef gint (*BoxesDisplayOpenFDFunc) (void* user_data);
struct _BoxesDisplay {
	GObject parent_instance;
	BoxesDisplayPrivate * priv;
	gboolean connected;
	GHashTable* displays;
};

struct _BoxesDisplayClass {
	GObjectClass parent_class;
	GtkWidget* (*get_display) (BoxesDisplay* self, gint n);
	GdkPixbuf* (*get_pixbuf) (BoxesDisplay* self, gint n, GError** error);
	void (*set_enable_audio) (BoxesDisplay* self, gboolean enable);
	gboolean (*should_keep_alive) (BoxesDisplay* self);
	void (*connect_it) (BoxesDisplay* self, BoxesDisplayOpenFDFunc open_fd, void* open_fd_target, GDestroyNotify open_fd_target_destroy_notify, GError** error);
	void (*disconnect_it) (BoxesDisplay* self);
	void (*collect_logs) (BoxesDisplay* self, GString* builder);
	void (*transfer_files) (BoxesDisplay* self, GList* uris);
	void (*send_keys) (BoxesDisplay* self, guint* keyvals, int keyvals_length1);
	GList* (*get_properties) (BoxesDisplay* self, BoxesPropertiesPage page);
	const gchar* (*get_protocol) (BoxesDisplay* self);
	gchar* (*get_uri) (BoxesDisplay* self);
	gboolean (*get_can_transfer_files) (BoxesDisplay* self);
};

struct _BoxesVncDisplay {
	BoxesDisplay parent_instance;
	BoxesVncDisplayPrivate * priv;
};

struct _BoxesVncDisplayClass {
	BoxesDisplayClass parent_class;
};

struct _BoxesVncDisplayPrivate {
	VncDisplay* display;
	gchar* host;
	gint port;
	GtkWindow* window;
	BoxesBoxConfigSavedProperty* saved_properties;
	gint saved_properties_length1;
	gint _saved_properties_size_;
};


static gpointer boxes_vnc_display_parent_class = NULL;

GType boxes_properties_page_get_type (void) G_GNUC_CONST;
GType boxes_property_get_type (void) G_GNUC_CONST;
GType boxes_iproperties_provider_get_type (void) G_GNUC_CONST;
GType boxes_display_get_type (void) G_GNUC_CONST;
GType boxes_vnc_display_get_type (void) G_GNUC_CONST;
#define BOXES_VNC_DISPLAY_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), BOXES_TYPE_VNC_DISPLAY, BoxesVncDisplayPrivate))
static void _vala_BoxesBoxConfigSavedProperty_array_free (BoxesBoxConfigSavedProperty * array,
                                                   gint array_length);
BoxesVncDisplay* boxes_vnc_display_new (BoxesBoxConfig* config,
                                        const gchar* host,
                                        gint port);
BoxesVncDisplay* boxes_vnc_display_construct (GType object_type,
                                              BoxesBoxConfig* config,
                                              const gchar* host,
                                              gint port);
BoxesDisplay* boxes_display_construct (GType object_type);
void boxes_display_set_config (BoxesDisplay* self,
                               BoxesBoxConfig* value);
BoxesVncDisplay* boxes_vnc_display_new_with_uri (BoxesBoxConfig* config,
                                                 const gchar* _uri,
                                                 GError** error);
BoxesVncDisplay* boxes_vnc_display_construct_with_uri (GType object_type,
                                                       BoxesBoxConfig* config,
                                                       const gchar* _uri,
                                                       GError** error);
static GtkWidget* boxes_vnc_display_real_get_display (BoxesDisplay* base,
                                               gint n);
static void boxes_vnc_display_real_set_enable_audio (BoxesDisplay* base,
                                              gboolean enable);
static GdkPixbuf* boxes_vnc_display_real_get_pixbuf (BoxesDisplay* base,
                                              gint n,
                                              GError** error);
static void boxes_vnc_display_real_connect_it (BoxesDisplay* base,
                                        BoxesDisplayOpenFDFunc open_fd,
                                        void* open_fd_target,
                                        GDestroyNotify open_fd_target_destroy_notify,
                                        GError** error);
const gchar* boxes_display_get_username (BoxesDisplay* self);
const gchar* boxes_display_get_password (BoxesDisplay* self);
static void boxes_vnc_display_real_disconnect_it (BoxesDisplay* base);
static GList* boxes_vnc_display_real_get_properties (BoxesDisplay* base,
                                              BoxesPropertiesPage page);
static void _g_object_unref0_ (gpointer var);
static inline void _g_list_free__g_object_unref0_ (GList* self);
static void boxes_vnc_display_real_send_keys (BoxesDisplay* base,
                                       guint* keyvals,
                                       int keyvals_length1);
void boxes_vnc_display_scale (BoxesVncDisplay* self);
static GObject * boxes_vnc_display_constructor (GType type,
                                         guint n_construct_properties,
                                         GObjectConstructParam * construct_properties);
void boxes_display_set_need_password (BoxesDisplay* self,
                                      gboolean value);
static void _boxes_vnc_display___lambda97_ (BoxesVncDisplay* self);
void boxes_display_access_start (BoxesDisplay* self);
static void __boxes_vnc_display___lambda97__vnc_display_vnc_initialized (VncDisplay* _sender,
                                                                  gpointer self);
static void _boxes_vnc_display___lambda98_ (BoxesVncDisplay* self);
void boxes_display_access_finish (BoxesDisplay* self);
static void __boxes_vnc_display___lambda98__vnc_display_vnc_disconnected (VncDisplay* _sender,
                                                                   gpointer self);
static void _boxes_vnc_display___lambda99_ (BoxesVncDisplay* self);
void boxes_display_set_need_username (BoxesDisplay* self,
                                      gboolean value);
static void __boxes_vnc_display___lambda99__vnc_display_vnc_auth_failure (VncDisplay* _sender,
                                                                   const gchar* object,
                                                                   gpointer self);
static void _boxes_vnc_display___lambda100_ (BoxesVncDisplay* self);
static void __boxes_vnc_display___lambda100__vnc_display_vnc_auth_unsupported (VncDisplay* _sender,
                                                                        guint object,
                                                                        gpointer self);
static void _boxes_vnc_display___lambda101_ (BoxesVncDisplay* self,
                                      GValueArray* creds);
const gchar* vnc_display_credential_to_string (VncDisplayCredential self);
static void __boxes_vnc_display___lambda101__vnc_display_vnc_auth_credential (VncDisplay* _sender,
                                                                       GValueArray* credList,
                                                                       gpointer self);
static void _boxes_vnc_display_scale_gtk_widget_size_allocate (GtkWidget* _sender,
                                                        GtkAllocation* allocation,
                                                        gpointer self);
static void boxes_vnc_display_finalize (GObject * obj);
const gchar* boxes_display_get_protocol (BoxesDisplay* self);
gchar* boxes_display_get_uri (BoxesDisplay* self);
static void _vala_boxes_vnc_display_get_property (GObject * object,
                                           guint property_id,
                                           GValue * value,
                                           GParamSpec * pspec);


static void
_vala_BoxesBoxConfigSavedProperty_array_free (BoxesBoxConfigSavedProperty * array,
                                              gint array_length)
{
#line 12 "/home/fborges/checkout/gnome-boxes/src/vnc-display.vala"
	if (array != NULL) {
#line 229 "vnc-display.c"
		int i;
#line 12 "/home/fborges/checkout/gnome-boxes/src/vnc-display.vala"
		for (i = 0; i < array_length; i = i + 1) {
#line 12 "/home/fborges/checkout/gnome-boxes/src/vnc-display.vala"
			boxes_box_config_saved_property_destroy (&array[i]);
#line 235 "vnc-display.c"
		}
	}
#line 12 "/home/fborges/checkout/gnome-boxes/src/vnc-display.vala"
	g_free (array);
#line 240 "vnc-display.c"
}


BoxesVncDisplay*
boxes_vnc_display_construct (GType object_type,
                             BoxesBoxConfig* config,
                             const gchar* host,
                             gint port)
{
	BoxesVncDisplay * self = NULL;
	gchar* _tmp0_;
	VncDisplay* _tmp1_;
	BoxesBoxConfigSavedProperty* _tmp2_;
	gint _tmp2__length1;
#line 79 "/home/fborges/checkout/gnome-boxes/src/vnc-display.vala"
	g_return_val_if_fail (config != NULL, NULL);
#line 79 "/home/fborges/checkout/gnome-boxes/src/vnc-display.vala"
	g_return_val_if_fail (host != NULL, NULL);
#line 79 "/home/fborges/checkout/gnome-boxes/src/vnc-display.vala"
	self = (BoxesVncDisplay*) boxes_display_construct (object_type);
#line 80 "/home/fborges/checkout/gnome-boxes/src/vnc-display.vala"
	boxes_display_set_config ((BoxesDisplay*) self, config);
#line 82 "/home/fborges/checkout/gnome-boxes/src/vnc-display.vala"
	_tmp0_ = g_strdup (host);
#line 82 "/home/fborges/checkout/gnome-boxes/src/vnc-display.vala"
	_g_free0 (self->priv->host);
#line 82 "/home/fborges/checkout/gnome-boxes/src/vnc-display.vala"
	self->priv->host = _tmp0_;
#line 83 "/home/fborges/checkout/gnome-boxes/src/vnc-display.vala"
	self->priv->port = port;
#line 85 "/home/fborges/checkout/gnome-boxes/src/vnc-display.vala"
	_tmp1_ = self->priv->display;
#line 85 "/home/fborges/checkout/gnome-boxes/src/vnc-display.vala"
	_tmp2_ = self->priv->saved_properties;
#line 85 "/home/fborges/checkout/gnome-boxes/src/vnc-display.vala"
	_tmp2__length1 = self->priv->saved_properties_length1;
#line 85 "/home/fborges/checkout/gnome-boxes/src/vnc-display.vala"
	boxes_box_config_save_properties (config, (GObject*) _tmp1_, _tmp2_, _tmp2__length1);
#line 79 "/home/fborges/checkout/gnome-boxes/src/vnc-display.vala"
	return self;
#line 281 "vnc-display.c"
}


BoxesVncDisplay*
boxes_vnc_display_new (BoxesBoxConfig* config,
                       const gchar* host,
                       gint port)
{
#line 79 "/home/fborges/checkout/gnome-boxes/src/vnc-display.vala"
	return boxes_vnc_display_construct (BOXES_TYPE_VNC_DISPLAY, config, host, port);
#line 292 "vnc-display.c"
}


BoxesVncDisplay*
boxes_vnc_display_construct_with_uri (GType object_type,
                                      BoxesBoxConfig* config,
                                      const gchar* _uri,
                                      GError** error)
{
	BoxesVncDisplay * self = NULL;
	xmlURI* uri = NULL;
	xmlURI* _tmp0_;
	xmlURI* _tmp1_;
	const gchar* _tmp2_;
	xmlURI* _tmp4_;
	const gchar* _tmp5_;
	xmlURI* _tmp7_;
	const gchar* _tmp8_;
	gchar* _tmp9_;
	gint _tmp10_ = 0;
	xmlURI* _tmp11_;
	gint _tmp12_;
	VncDisplay* _tmp15_;
	BoxesBoxConfigSavedProperty* _tmp16_;
	gint _tmp16__length1;
	GError * _inner_error_ = NULL;
#line 88 "/home/fborges/checkout/gnome-boxes/src/vnc-display.vala"
	g_return_val_if_fail (config != NULL, NULL);
#line 88 "/home/fborges/checkout/gnome-boxes/src/vnc-display.vala"
	g_return_val_if_fail (_uri != NULL, NULL);
#line 88 "/home/fborges/checkout/gnome-boxes/src/vnc-display.vala"
	self = (BoxesVncDisplay*) boxes_display_construct (object_type);
#line 89 "/home/fborges/checkout/gnome-boxes/src/vnc-display.vala"
	boxes_display_set_config ((BoxesDisplay*) self, config);
#line 91 "/home/fborges/checkout/gnome-boxes/src/vnc-display.vala"
	_tmp0_ = xmlParseURI (_uri);
#line 91 "/home/fborges/checkout/gnome-boxes/src/vnc-display.vala"
	uri = _tmp0_;
#line 93 "/home/fborges/checkout/gnome-boxes/src/vnc-display.vala"
	_tmp1_ = uri;
#line 93 "/home/fborges/checkout/gnome-boxes/src/vnc-display.vala"
	_tmp2_ = _tmp1_->scheme;
#line 93 "/home/fborges/checkout/gnome-boxes/src/vnc-display.vala"
	if (g_strcmp0 (_tmp2_, "vnc") != 0) {
#line 337 "vnc-display.c"
		GError* _tmp3_;
#line 94 "/home/fborges/checkout/gnome-boxes/src/vnc-display.vala"
		_tmp3_ = g_error_new_literal (BOXES_ERROR, BOXES_ERROR_INVALID, "the URL is not vnc://");
#line 94 "/home/fborges/checkout/gnome-boxes/src/vnc-display.vala"
		_inner_error_ = _tmp3_;
#line 94 "/home/fborges/checkout/gnome-boxes/src/vnc-display.vala"
		if (_inner_error_->domain == BOXES_ERROR) {
#line 94 "/home/fborges/checkout/gnome-boxes/src/vnc-display.vala"
			g_propagate_error (error, _inner_error_);
#line 94 "/home/fborges/checkout/gnome-boxes/src/vnc-display.vala"
			_xmlFreeURI0 (uri);
#line 94 "/home/fborges/checkout/gnome-boxes/src/vnc-display.vala"
			_g_object_unref0 (self);
#line 94 "/home/fborges/checkout/gnome-boxes/src/vnc-display.vala"
			return NULL;
#line 353 "vnc-display.c"
		} else {
#line 94 "/home/fborges/checkout/gnome-boxes/src/vnc-display.vala"
			_xmlFreeURI0 (uri);
#line 94 "/home/fborges/checkout/gnome-boxes/src/vnc-display.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 94 "/home/fborges/checkout/gnome-boxes/src/vnc-display.vala"
			g_clear_error (&_inner_error_);
#line 94 "/home/fborges/checkout/gnome-boxes/src/vnc-display.vala"
			return NULL;
#line 363 "vnc-display.c"
		}
	}
#line 96 "/home/fborges/checkout/gnome-boxes/src/vnc-display.vala"
	_tmp4_ = uri;
#line 96 "/home/fborges/checkout/gnome-boxes/src/vnc-display.vala"
	_tmp5_ = _tmp4_->server;
#line 96 "/home/fborges/checkout/gnome-boxes/src/vnc-display.vala"
	if (_tmp5_ == NULL) {
#line 372 "vnc-display.c"
		GError* _tmp6_;
#line 97 "/home/fborges/checkout/gnome-boxes/src/vnc-display.vala"
		_tmp6_ = g_error_new_literal (BOXES_ERROR, BOXES_ERROR_INVALID, "the URL is missing a server");
#line 97 "/home/fborges/checkout/gnome-boxes/src/vnc-display.vala"
		_inner_error_ = _tmp6_;
#line 97 "/home/fborges/checkout/gnome-boxes/src/vnc-display.vala"
		if (_inner_error_->domain == BOXES_ERROR) {
#line 97 "/home/fborges/checkout/gnome-boxes/src/vnc-display.vala"
			g_propagate_error (error, _inner_error_);
#line 97 "/home/fborges/checkout/gnome-boxes/src/vnc-display.vala"
			_xmlFreeURI0 (uri);
#line 97 "/home/fborges/checkout/gnome-boxes/src/vnc-display.vala"
			_g_object_unref0 (self);
#line 97 "/home/fborges/checkout/gnome-boxes/src/vnc-display.vala"
			return NULL;
#line 388 "vnc-display.c"
		} else {
#line 97 "/home/fborges/checkout/gnome-boxes/src/vnc-display.vala"
			_xmlFreeURI0 (uri);
#line 97 "/home/fborges/checkout/gnome-boxes/src/vnc-display.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 97 "/home/fborges/checkout/gnome-boxes/src/vnc-display.vala"
			g_clear_error (&_inner_error_);
#line 97 "/home/fborges/checkout/gnome-boxes/src/vnc-display.vala"
			return NULL;
#line 398 "vnc-display.c"
		}
	}
#line 99 "/home/fborges/checkout/gnome-boxes/src/vnc-display.vala"
	_tmp7_ = uri;
#line 99 "/home/fborges/checkout/gnome-boxes/src/vnc-display.vala"
	_tmp8_ = _tmp7_->server;
#line 99 "/home/fborges/checkout/gnome-boxes/src/vnc-display.vala"
	_tmp9_ = g_strdup (_tmp8_);
#line 99 "/home/fborges/checkout/gnome-boxes/src/vnc-display.vala"
	_g_free0 (self->priv->host);
#line 99 "/home/fborges/checkout/gnome-boxes/src/vnc-display.vala"
	self->priv->host = _tmp9_;
#line 100 "/home/fborges/checkout/gnome-boxes/src/vnc-display.vala"
	_tmp11_ = uri;
#line 100 "/home/fborges/checkout/gnome-boxes/src/vnc-display.vala"
	_tmp12_ = _tmp11_->port;
#line 100 "/home/fborges/checkout/gnome-boxes/src/vnc-display.vala"
	if (_tmp12_ <= 0) {
#line 100 "/home/fborges/checkout/gnome-boxes/src/vnc-display.vala"
		_tmp10_ = 5900;
#line 419 "vnc-display.c"
	} else {
		xmlURI* _tmp13_;
		gint _tmp14_;
#line 100 "/home/fborges/checkout/gnome-boxes/src/vnc-display.vala"
		_tmp13_ = uri;
#line 100 "/home/fborges/checkout/gnome-boxes/src/vnc-display.vala"
		_tmp14_ = _tmp13_->port;
#line 100 "/home/fborges/checkout/gnome-boxes/src/vnc-display.vala"
		_tmp10_ = _tmp14_;
#line 429 "vnc-display.c"
	}
#line 100 "/home/fborges/checkout/gnome-boxes/src/vnc-display.vala"
	self->priv->port = _tmp10_;
#line 102 "/home/fborges/checkout/gnome-boxes/src/vnc-display.vala"
	_tmp15_ = self->priv->display;
#line 102 "/home/fborges/checkout/gnome-boxes/src/vnc-display.vala"
	_tmp16_ = self->priv->saved_properties;
#line 102 "/home/fborges/checkout/gnome-boxes/src/vnc-display.vala"
	_tmp16__length1 = self->priv->saved_properties_length1;
#line 102 "/home/fborges/checkout/gnome-boxes/src/vnc-display.vala"
	boxes_box_config_save_properties (config, (GObject*) _tmp15_, _tmp16_, _tmp16__length1);
#line 88 "/home/fborges/checkout/gnome-boxes/src/vnc-display.vala"
	_xmlFreeURI0 (uri);
#line 88 "/home/fborges/checkout/gnome-boxes/src/vnc-display.vala"
	return self;
#line 445 "vnc-display.c"
}


BoxesVncDisplay*
boxes_vnc_display_new_with_uri (BoxesBoxConfig* config,
                                const gchar* _uri,
                                GError** error)
{
#line 88 "/home/fborges/checkout/gnome-boxes/src/vnc-display.vala"
	return boxes_vnc_display_construct_with_uri (BOXES_TYPE_VNC_DISPLAY, config, _uri, error);
#line 456 "vnc-display.c"
}


static gpointer
_g_object_ref0 (gpointer self)
{
#line 108 "/home/fborges/checkout/gnome-boxes/src/vnc-display.vala"
	return self ? g_object_ref (self) : NULL;
#line 465 "vnc-display.c"
}


static GtkWidget*
boxes_vnc_display_real_get_display (BoxesDisplay* base,
                                    gint n)
{
	BoxesVncDisplay * self;
	GtkWidget* result = NULL;
	GtkWindow* _tmp0_;
	VncDisplay* _tmp1_;
	VncDisplay* _tmp2_;
	GtkWidget* _tmp3_;
#line 105 "/home/fborges/checkout/gnome-boxes/src/vnc-display.vala"
	self = (BoxesVncDisplay*) base;
#line 106 "/home/fborges/checkout/gnome-boxes/src/vnc-display.vala"
	_tmp0_ = self->priv->window;
#line 106 "/home/fborges/checkout/gnome-boxes/src/vnc-display.vala"
	_tmp1_ = self->priv->display;
#line 106 "/home/fborges/checkout/gnome-boxes/src/vnc-display.vala"
	gtk_container_remove ((GtkContainer*) _tmp0_, (GtkWidget*) _tmp1_);
#line 108 "/home/fborges/checkout/gnome-boxes/src/vnc-display.vala"
	_tmp2_ = self->priv->display;
#line 108 "/home/fborges/checkout/gnome-boxes/src/vnc-display.vala"
	_tmp3_ = _g_object_ref0 ((GtkWidget*) _tmp2_);
#line 108 "/home/fborges/checkout/gnome-boxes/src/vnc-display.vala"
	result = _tmp3_;
#line 108 "/home/fborges/checkout/gnome-boxes/src/vnc-display.vala"
	return result;
#line 495 "vnc-display.c"
}


static void
boxes_vnc_display_real_set_enable_audio (BoxesDisplay* base,
                                         gboolean enable)
{
	BoxesVncDisplay * self;
#line 111 "/home/fborges/checkout/gnome-boxes/src/vnc-display.vala"
	self = (BoxesVncDisplay*) base;
#line 506 "vnc-display.c"
}


static GdkPixbuf*
boxes_vnc_display_real_get_pixbuf (BoxesDisplay* base,
                                   gint n,
                                   GError** error)
{
	BoxesVncDisplay * self;
	GdkPixbuf* result = NULL;
	VncDisplay* _tmp0_;
	GdkPixbuf* _tmp1_;
#line 114 "/home/fborges/checkout/gnome-boxes/src/vnc-display.vala"
	self = (BoxesVncDisplay*) base;
#line 115 "/home/fborges/checkout/gnome-boxes/src/vnc-display.vala"
	_tmp0_ = self->priv->display;
#line 115 "/home/fborges/checkout/gnome-boxes/src/vnc-display.vala"
	_tmp1_ = vnc_display_get_pixbuf (_tmp0_);
#line 115 "/home/fborges/checkout/gnome-boxes/src/vnc-display.vala"
	result = _tmp1_;
#line 115 "/home/fborges/checkout/gnome-boxes/src/vnc-display.vala"
	return result;
#line 529 "vnc-display.c"
}


static void
boxes_vnc_display_real_connect_it (BoxesDisplay* base,
                                   BoxesDisplayOpenFDFunc open_fd,
                                   void* open_fd_target,
                                   GDestroyNotify open_fd_target_destroy_notify,
                                   GError** error)
{
	BoxesVncDisplay * self;
	gboolean _tmp0_;
	VncDisplay* _tmp1_;
	const gchar* _tmp2_;
	const gchar* _tmp3_;
	VncDisplay* _tmp4_;
	const gchar* _tmp5_;
	const gchar* _tmp6_;
	VncDisplay* _tmp7_;
#line 118 "/home/fborges/checkout/gnome-boxes/src/vnc-display.vala"
	self = (BoxesVncDisplay*) base;
#line 120 "/home/fborges/checkout/gnome-boxes/src/vnc-display.vala"
	_tmp0_ = ((BoxesDisplay*) self)->connected;
#line 120 "/home/fborges/checkout/gnome-boxes/src/vnc-display.vala"
	if (_tmp0_) {
#line 121 "/home/fborges/checkout/gnome-boxes/src/vnc-display.vala"
		(open_fd_target_destroy_notify == NULL) ? NULL : (open_fd_target_destroy_notify (open_fd_target), NULL);
#line 121 "/home/fborges/checkout/gnome-boxes/src/vnc-display.vala"
		open_fd = NULL;
#line 121 "/home/fborges/checkout/gnome-boxes/src/vnc-display.vala"
		open_fd_target = NULL;
#line 121 "/home/fborges/checkout/gnome-boxes/src/vnc-display.vala"
		open_fd_target_destroy_notify = NULL;
#line 121 "/home/fborges/checkout/gnome-boxes/src/vnc-display.vala"
		return;
#line 565 "vnc-display.c"
	}
#line 122 "/home/fborges/checkout/gnome-boxes/src/vnc-display.vala"
	((BoxesDisplay*) self)->connected = TRUE;
#line 125 "/home/fborges/checkout/gnome-boxes/src/vnc-display.vala"
	_tmp1_ = self->priv->display;
#line 125 "/home/fborges/checkout/gnome-boxes/src/vnc-display.vala"
	_tmp2_ = boxes_display_get_username ((BoxesDisplay*) self);
#line 125 "/home/fborges/checkout/gnome-boxes/src/vnc-display.vala"
	_tmp3_ = _tmp2_;
#line 125 "/home/fborges/checkout/gnome-boxes/src/vnc-display.vala"
	vnc_display_set_credential (_tmp1_, (gint) VNC_DISPLAY_CREDENTIAL_USERNAME, _tmp3_);
#line 126 "/home/fborges/checkout/gnome-boxes/src/vnc-display.vala"
	_tmp4_ = self->priv->display;
#line 126 "/home/fborges/checkout/gnome-boxes/src/vnc-display.vala"
	_tmp5_ = boxes_display_get_password ((BoxesDisplay*) self);
#line 126 "/home/fborges/checkout/gnome-boxes/src/vnc-display.vala"
	_tmp6_ = _tmp5_;
#line 126 "/home/fborges/checkout/gnome-boxes/src/vnc-display.vala"
	vnc_display_set_credential (_tmp4_, (gint) VNC_DISPLAY_CREDENTIAL_PASSWORD, _tmp6_);
#line 127 "/home/fborges/checkout/gnome-boxes/src/vnc-display.vala"
	_tmp7_ = self->priv->display;
#line 127 "/home/fborges/checkout/gnome-boxes/src/vnc-display.vala"
	vnc_display_set_credential (_tmp7_, (gint) VNC_DISPLAY_CREDENTIAL_CLIENTNAME, "boxes");
#line 129 "/home/fborges/checkout/gnome-boxes/src/vnc-display.vala"
	if (open_fd != NULL) {
#line 591 "vnc-display.c"
		gint fd = 0;
		VncDisplay* _tmp8_;
		gint _tmp9_;
		const gchar* _tmp10_;
#line 130 "/home/fborges/checkout/gnome-boxes/src/vnc-display.vala"
		fd = open_fd (open_fd_target);
#line 131 "/home/fborges/checkout/gnome-boxes/src/vnc-display.vala"
		_tmp8_ = self->priv->display;
#line 131 "/home/fborges/checkout/gnome-boxes/src/vnc-display.vala"
		_tmp9_ = fd;
#line 131 "/home/fborges/checkout/gnome-boxes/src/vnc-display.vala"
		_tmp10_ = self->priv->host;
#line 131 "/home/fborges/checkout/gnome-boxes/src/vnc-display.vala"
		vnc_display_open_fd_with_hostname (_tmp8_, _tmp9_, _tmp10_);
#line 606 "vnc-display.c"
	} else {
		VncDisplay* _tmp11_;
		const gchar* _tmp12_;
		gint _tmp13_;
		gchar* _tmp14_;
		gchar* _tmp15_;
#line 133 "/home/fborges/checkout/gnome-boxes/src/vnc-display.vala"
		_tmp11_ = self->priv->display;
#line 133 "/home/fborges/checkout/gnome-boxes/src/vnc-display.vala"
		_tmp12_ = self->priv->host;
#line 133 "/home/fborges/checkout/gnome-boxes/src/vnc-display.vala"
		_tmp13_ = self->priv->port;
#line 133 "/home/fborges/checkout/gnome-boxes/src/vnc-display.vala"
		_tmp14_ = g_strdup_printf ("%i", _tmp13_);
#line 133 "/home/fborges/checkout/gnome-boxes/src/vnc-display.vala"
		_tmp15_ = _tmp14_;
#line 133 "/home/fborges/checkout/gnome-boxes/src/vnc-display.vala"
		vnc_display_open_host (_tmp11_, _tmp12_, _tmp15_);
#line 133 "/home/fborges/checkout/gnome-boxes/src/vnc-display.vala"
		_g_free0 (_tmp15_);
#line 627 "vnc-display.c"
	}
#line 118 "/home/fborges/checkout/gnome-boxes/src/vnc-display.vala"
	(open_fd_target_destroy_notify == NULL) ? NULL : (open_fd_target_destroy_notify (open_fd_target), NULL);
#line 118 "/home/fborges/checkout/gnome-boxes/src/vnc-display.vala"
	open_fd = NULL;
#line 118 "/home/fborges/checkout/gnome-boxes/src/vnc-display.vala"
	open_fd_target = NULL;
#line 118 "/home/fborges/checkout/gnome-boxes/src/vnc-display.vala"
	open_fd_target_destroy_notify = NULL;
#line 637 "vnc-display.c"
}


static void
boxes_vnc_display_real_disconnect_it (BoxesDisplay* base)
{
	BoxesVncDisplay * self;
	VncDisplay* _tmp0_;
#line 136 "/home/fborges/checkout/gnome-boxes/src/vnc-display.vala"
	self = (BoxesVncDisplay*) base;
#line 137 "/home/fborges/checkout/gnome-boxes/src/vnc-display.vala"
	_tmp0_ = self->priv->display;
#line 137 "/home/fborges/checkout/gnome-boxes/src/vnc-display.vala"
	if (vnc_display_is_open (_tmp0_)) {
#line 652 "vnc-display.c"
		VncDisplay* _tmp1_;
#line 138 "/home/fborges/checkout/gnome-boxes/src/vnc-display.vala"
		_tmp1_ = self->priv->display;
#line 138 "/home/fborges/checkout/gnome-boxes/src/vnc-display.vala"
		vnc_display_close (_tmp1_);
#line 658 "vnc-display.c"
	}
}


static void
_g_object_unref0_ (gpointer var)
{
#line 141 "/home/fborges/checkout/gnome-boxes/src/vnc-display.vala"
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
#line 668 "vnc-display.c"
}


static inline void
_g_list_free__g_object_unref0_ (GList* self)
{
#line 141 "/home/fborges/checkout/gnome-boxes/src/vnc-display.vala"
	g_list_free_full (self, (GDestroyNotify) _g_object_unref0_);
#line 677 "vnc-display.c"
}


static GList*
boxes_vnc_display_real_get_properties (BoxesDisplay* base,
                                       BoxesPropertiesPage page)
{
	BoxesVncDisplay * self;
	GList* result = NULL;
	GList* list = NULL;
#line 141 "/home/fborges/checkout/gnome-boxes/src/vnc-display.vala"
	self = (BoxesVncDisplay*) base;
#line 142 "/home/fborges/checkout/gnome-boxes/src/vnc-display.vala"
	list = NULL;
#line 144 "/home/fborges/checkout/gnome-boxes/src/vnc-display.vala"
	result = list;
#line 144 "/home/fborges/checkout/gnome-boxes/src/vnc-display.vala"
	return result;
#line 696 "vnc-display.c"
}


static void
boxes_vnc_display_real_send_keys (BoxesDisplay* base,
                                  guint* keyvals,
                                  int keyvals_length1)
{
	BoxesVncDisplay * self;
	VncDisplay* _tmp0_;
#line 147 "/home/fborges/checkout/gnome-boxes/src/vnc-display.vala"
	self = (BoxesVncDisplay*) base;
#line 148 "/home/fborges/checkout/gnome-boxes/src/vnc-display.vala"
	_tmp0_ = self->priv->display;
#line 148 "/home/fborges/checkout/gnome-boxes/src/vnc-display.vala"
	vnc_display_send_keys (_tmp0_, keyvals, keyvals_length1);
#line 713 "vnc-display.c"
}


void
boxes_vnc_display_scale (BoxesVncDisplay* self)
{
	VncDisplay* _tmp0_;
	GtkAllocation alloc = {0};
	VncDisplay* _tmp1_;
	GtkContainer* _tmp2_;
	GtkAllocation _tmp3_ = {0};
	gdouble parent_aspect = 0.0;
	GtkAllocation _tmp4_;
	gint _tmp5_;
	GtkAllocation _tmp6_;
	gint _tmp7_;
	gdouble display_aspect = 0.0;
	VncDisplay* _tmp8_;
	VncDisplay* _tmp9_;
	GtkAllocation scaled = {0};
	GtkAllocation _tmp10_;
	gdouble _tmp11_;
	gdouble _tmp12_;
	VncDisplay* _tmp29_;
	GtkAllocation _tmp30_;
#line 151 "/home/fborges/checkout/gnome-boxes/src/vnc-display.vala"
	g_return_if_fail (self != NULL);
#line 152 "/home/fborges/checkout/gnome-boxes/src/vnc-display.vala"
	_tmp0_ = self->priv->display;
#line 152 "/home/fborges/checkout/gnome-boxes/src/vnc-display.vala"
	if (!vnc_display_is_open (_tmp0_)) {
#line 153 "/home/fborges/checkout/gnome-boxes/src/vnc-display.vala"
		return;
#line 747 "vnc-display.c"
	}
#line 157 "/home/fborges/checkout/gnome-boxes/src/vnc-display.vala"
	_tmp1_ = self->priv->display;
#line 157 "/home/fborges/checkout/gnome-boxes/src/vnc-display.vala"
	_tmp2_ = gtk_widget_get_parent ((GtkWidget*) _tmp1_);
#line 157 "/home/fborges/checkout/gnome-boxes/src/vnc-display.vala"
	gtk_widget_get_allocation ((GtkWidget*) _tmp2_, &_tmp3_);
#line 157 "/home/fborges/checkout/gnome-boxes/src/vnc-display.vala"
	alloc = _tmp3_;
#line 159 "/home/fborges/checkout/gnome-boxes/src/vnc-display.vala"
	_tmp4_ = alloc;
#line 159 "/home/fborges/checkout/gnome-boxes/src/vnc-display.vala"
	_tmp5_ = _tmp4_.width;
#line 159 "/home/fborges/checkout/gnome-boxes/src/vnc-display.vala"
	_tmp6_ = alloc;
#line 159 "/home/fborges/checkout/gnome-boxes/src/vnc-display.vala"
	_tmp7_ = _tmp6_.height;
#line 159 "/home/fborges/checkout/gnome-boxes/src/vnc-display.vala"
	parent_aspect = ((gdouble) _tmp5_) / ((gdouble) _tmp7_);
#line 160 "/home/fborges/checkout/gnome-boxes/src/vnc-display.vala"
	_tmp8_ = self->priv->display;
#line 160 "/home/fborges/checkout/gnome-boxes/src/vnc-display.vala"
	_tmp9_ = self->priv->display;
#line 160 "/home/fborges/checkout/gnome-boxes/src/vnc-display.vala"
	display_aspect = ((gdouble) vnc_display_get_width (_tmp8_)) / ((gdouble) vnc_display_get_height (_tmp9_));
#line 161 "/home/fborges/checkout/gnome-boxes/src/vnc-display.vala"
	_tmp10_ = alloc;
#line 161 "/home/fborges/checkout/gnome-boxes/src/vnc-display.vala"
	scaled = _tmp10_;
#line 162 "/home/fborges/checkout/gnome-boxes/src/vnc-display.vala"
	_tmp11_ = parent_aspect;
#line 162 "/home/fborges/checkout/gnome-boxes/src/vnc-display.vala"
	_tmp12_ = display_aspect;
#line 162 "/home/fborges/checkout/gnome-boxes/src/vnc-display.vala"
	if (_tmp11_ > _tmp12_) {
#line 783 "vnc-display.c"
		GtkAllocation _tmp13_;
		gint _tmp14_;
		gdouble _tmp15_;
		gint _tmp16_;
		GtkAllocation _tmp17_;
		gint _tmp18_;
		GtkAllocation _tmp19_;
		gint _tmp20_;
#line 163 "/home/fborges/checkout/gnome-boxes/src/vnc-display.vala"
		_tmp13_ = alloc;
#line 163 "/home/fborges/checkout/gnome-boxes/src/vnc-display.vala"
		_tmp14_ = _tmp13_.height;
#line 163 "/home/fborges/checkout/gnome-boxes/src/vnc-display.vala"
		_tmp15_ = display_aspect;
#line 163 "/home/fborges/checkout/gnome-boxes/src/vnc-display.vala"
		scaled.width = (gint) (_tmp14_ * _tmp15_);
#line 164 "/home/fborges/checkout/gnome-boxes/src/vnc-display.vala"
		_tmp16_ = scaled.x;
#line 164 "/home/fborges/checkout/gnome-boxes/src/vnc-display.vala"
		_tmp17_ = alloc;
#line 164 "/home/fborges/checkout/gnome-boxes/src/vnc-display.vala"
		_tmp18_ = _tmp17_.width;
#line 164 "/home/fborges/checkout/gnome-boxes/src/vnc-display.vala"
		_tmp19_ = scaled;
#line 164 "/home/fborges/checkout/gnome-boxes/src/vnc-display.vala"
		_tmp20_ = _tmp19_.width;
#line 164 "/home/fborges/checkout/gnome-boxes/src/vnc-display.vala"
		scaled.x = _tmp16_ + ((_tmp18_ - _tmp20_) / 2);
#line 812 "vnc-display.c"
	} else {
		GtkAllocation _tmp21_;
		gint _tmp22_;
		gdouble _tmp23_;
		gint _tmp24_;
		GtkAllocation _tmp25_;
		gint _tmp26_;
		GtkAllocation _tmp27_;
		gint _tmp28_;
#line 166 "/home/fborges/checkout/gnome-boxes/src/vnc-display.vala"
		_tmp21_ = alloc;
#line 166 "/home/fborges/checkout/gnome-boxes/src/vnc-display.vala"
		_tmp22_ = _tmp21_.width;
#line 166 "/home/fborges/checkout/gnome-boxes/src/vnc-display.vala"
		_tmp23_ = display_aspect;
#line 166 "/home/fborges/checkout/gnome-boxes/src/vnc-display.vala"
		scaled.height = (gint) (_tmp22_ / _tmp23_);
#line 167 "/home/fborges/checkout/gnome-boxes/src/vnc-display.vala"
		_tmp24_ = scaled.y;
#line 167 "/home/fborges/checkout/gnome-boxes/src/vnc-display.vala"
		_tmp25_ = alloc;
#line 167 "/home/fborges/checkout/gnome-boxes/src/vnc-display.vala"
		_tmp26_ = _tmp25_.height;
#line 167 "/home/fborges/checkout/gnome-boxes/src/vnc-display.vala"
		_tmp27_ = scaled;
#line 167 "/home/fborges/checkout/gnome-boxes/src/vnc-display.vala"
		_tmp28_ = _tmp27_.height;
#line 167 "/home/fborges/checkout/gnome-boxes/src/vnc-display.vala"
		scaled.y = _tmp24_ + ((_tmp26_ - _tmp28_) / 2);
#line 842 "vnc-display.c"
	}
#line 170 "/home/fborges/checkout/gnome-boxes/src/vnc-display.vala"
	_tmp29_ = self->priv->display;
#line 170 "/home/fborges/checkout/gnome-boxes/src/vnc-display.vala"
	_tmp30_ = scaled;
#line 170 "/home/fborges/checkout/gnome-boxes/src/vnc-display.vala"
	gtk_widget_size_allocate ((GtkWidget*) _tmp29_, &_tmp30_);
#line 850 "vnc-display.c"
}


static const gchar*
boxes_vnc_display_real_get_protocol (BoxesDisplay* base)
{
	const gchar* result;
	BoxesVncDisplay* self;
#line 6 "/home/fborges/checkout/gnome-boxes/src/vnc-display.vala"
	self = (BoxesVncDisplay*) base;
#line 6 "/home/fborges/checkout/gnome-boxes/src/vnc-display.vala"
	result = "VNC";
#line 6 "/home/fborges/checkout/gnome-boxes/src/vnc-display.vala"
	return result;
#line 865 "vnc-display.c"
}


static const gchar*
string_to_string (const gchar* self)
{
	const gchar* result = NULL;
#line 1456 "/home/fborges/jhbuild/install/share/vala-0.40/vapi/glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, NULL);
#line 1457 "/home/fborges/jhbuild/install/share/vala-0.40/vapi/glib-2.0.vapi"
	result = self;
#line 1457 "/home/fborges/jhbuild/install/share/vala-0.40/vapi/glib-2.0.vapi"
	return result;
#line 879 "vnc-display.c"
}


static gchar*
boxes_vnc_display_real_get_uri (BoxesDisplay* base)
{
	gchar* result;
	BoxesVncDisplay* self;
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	gint _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
#line 7 "/home/fborges/checkout/gnome-boxes/src/vnc-display.vala"
	self = (BoxesVncDisplay*) base;
#line 7 "/home/fborges/checkout/gnome-boxes/src/vnc-display.vala"
	_tmp0_ = self->priv->host;
#line 7 "/home/fborges/checkout/gnome-boxes/src/vnc-display.vala"
	_tmp1_ = string_to_string (_tmp0_);
#line 7 "/home/fborges/checkout/gnome-boxes/src/vnc-display.vala"
	_tmp2_ = self->priv->port;
#line 7 "/home/fborges/checkout/gnome-boxes/src/vnc-display.vala"
	_tmp3_ = g_strdup_printf ("%i", _tmp2_);
#line 7 "/home/fborges/checkout/gnome-boxes/src/vnc-display.vala"
	_tmp4_ = _tmp3_;
#line 7 "/home/fborges/checkout/gnome-boxes/src/vnc-display.vala"
	_tmp5_ = g_strconcat ("vnc://", _tmp1_, ":", _tmp4_, NULL);
#line 7 "/home/fborges/checkout/gnome-boxes/src/vnc-display.vala"
	_tmp6_ = _tmp5_;
#line 7 "/home/fborges/checkout/gnome-boxes/src/vnc-display.vala"
	_g_free0 (_tmp4_);
#line 7 "/home/fborges/checkout/gnome-boxes/src/vnc-display.vala"
	result = _tmp6_;
#line 7 "/home/fborges/checkout/gnome-boxes/src/vnc-display.vala"
	return result;
#line 917 "vnc-display.c"
}


static void
_boxes_vnc_display___lambda97_ (BoxesVncDisplay* self)
{
#line 33 "/home/fborges/checkout/gnome-boxes/src/vnc-display.vala"
	g_signal_emit_by_name ((BoxesDisplay*) self, "show", 0);
#line 34 "/home/fborges/checkout/gnome-boxes/src/vnc-display.vala"
	boxes_display_access_start ((BoxesDisplay*) self);
#line 928 "vnc-display.c"
}


static void
__boxes_vnc_display___lambda97__vnc_display_vnc_initialized (VncDisplay* _sender,
                                                             gpointer self)
{
#line 32 "/home/fborges/checkout/gnome-boxes/src/vnc-display.vala"
	_boxes_vnc_display___lambda97_ ((BoxesVncDisplay*) self);
#line 938 "vnc-display.c"
}


static void
_boxes_vnc_display___lambda98_ (BoxesVncDisplay* self)
{
#line 37 "/home/fborges/checkout/gnome-boxes/src/vnc-display.vala"
	g_signal_emit_by_name ((BoxesDisplay*) self, "hide", 0);
#line 38 "/home/fborges/checkout/gnome-boxes/src/vnc-display.vala"
	boxes_display_access_finish ((BoxesDisplay*) self);
#line 949 "vnc-display.c"
}


static void
__boxes_vnc_display___lambda98__vnc_display_vnc_disconnected (VncDisplay* _sender,
                                                              gpointer self)
{
#line 36 "/home/fborges/checkout/gnome-boxes/src/vnc-display.vala"
	_boxes_vnc_display___lambda98_ ((BoxesVncDisplay*) self);
#line 959 "vnc-display.c"
}


static void
_boxes_vnc_display___lambda99_ (BoxesVncDisplay* self)
{
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	const gchar* _tmp3_;
#line 42 "/home/fborges/checkout/gnome-boxes/src/vnc-display.vala"
	g_debug ("vnc-display.vala:42: auth failure");
#line 44 "/home/fborges/checkout/gnome-boxes/src/vnc-display.vala"
	_tmp0_ = boxes_display_get_password ((BoxesDisplay*) self);
#line 44 "/home/fborges/checkout/gnome-boxes/src/vnc-display.vala"
	_tmp1_ = _tmp0_;
#line 44 "/home/fborges/checkout/gnome-boxes/src/vnc-display.vala"
	boxes_display_set_need_password ((BoxesDisplay*) self, _tmp1_ != NULL);
#line 45 "/home/fborges/checkout/gnome-boxes/src/vnc-display.vala"
	_tmp2_ = boxes_display_get_username ((BoxesDisplay*) self);
#line 45 "/home/fborges/checkout/gnome-boxes/src/vnc-display.vala"
	_tmp3_ = _tmp2_;
#line 45 "/home/fborges/checkout/gnome-boxes/src/vnc-display.vala"
	boxes_display_set_need_username ((BoxesDisplay*) self, _tmp3_ != NULL);
#line 984 "vnc-display.c"
}


static void
__boxes_vnc_display___lambda99__vnc_display_vnc_auth_failure (VncDisplay* _sender,
                                                              const gchar* object,
                                                              gpointer self)
{
#line 41 "/home/fborges/checkout/gnome-boxes/src/vnc-display.vala"
	_boxes_vnc_display___lambda99_ ((BoxesVncDisplay*) self);
#line 995 "vnc-display.c"
}


static void
_boxes_vnc_display___lambda100_ (BoxesVncDisplay* self)
{
#line 48 "/home/fborges/checkout/gnome-boxes/src/vnc-display.vala"
	g_debug ("vnc-display.vala:48: auth unsupported");
#line 1004 "vnc-display.c"
}


static void
__boxes_vnc_display___lambda100__vnc_display_vnc_auth_unsupported (VncDisplay* _sender,
                                                                   guint object,
                                                                   gpointer self)
{
#line 47 "/home/fborges/checkout/gnome-boxes/src/vnc-display.vala"
	_boxes_vnc_display___lambda100_ ((BoxesVncDisplay*) self);
#line 1015 "vnc-display.c"
}


static void
_boxes_vnc_display___lambda101_ (BoxesVncDisplay* self,
                                 GValueArray* creds)
{
	VncDisplay* _tmp6_;
#line 51 "/home/fborges/checkout/gnome-boxes/src/vnc-display.vala"
	g_return_if_fail (creds != NULL);
#line 1026 "vnc-display.c"
	{
		GValueArray* cred_collection = NULL;
		guint cred_index = 0U;
#line 52 "/home/fborges/checkout/gnome-boxes/src/vnc-display.vala"
		cred_collection = creds;
#line 52 "/home/fborges/checkout/gnome-boxes/src/vnc-display.vala"
		for (cred_index = 0; cred_index < cred_collection->n_values; cred_index = cred_index + 1) {
#line 1034 "vnc-display.c"
			GValue cred = {0};
#line 52 "/home/fborges/checkout/gnome-boxes/src/vnc-display.vala"
			cred = *g_value_array_get_nth (cred_collection, cred_index);
#line 1038 "vnc-display.c"
			{
				VncDisplayCredential credential = 0;
				GValue _tmp0_;
				VncDisplayCredential _tmp1_;
#line 53 "/home/fborges/checkout/gnome-boxes/src/vnc-display.vala"
				_tmp0_ = cred;
#line 53 "/home/fborges/checkout/gnome-boxes/src/vnc-display.vala"
				credential = g_value_get_enum (&_tmp0_);
#line 55 "/home/fborges/checkout/gnome-boxes/src/vnc-display.vala"
				_tmp1_ = credential;
#line 55 "/home/fborges/checkout/gnome-boxes/src/vnc-display.vala"
				switch (_tmp1_) {
#line 55 "/home/fborges/checkout/gnome-boxes/src/vnc-display.vala"
					case VNC_DISPLAY_CREDENTIAL_USERNAME:
#line 1053 "vnc-display.c"
					{
#line 57 "/home/fborges/checkout/gnome-boxes/src/vnc-display.vala"
						boxes_display_set_need_username ((BoxesDisplay*) self, TRUE);
#line 58 "/home/fborges/checkout/gnome-boxes/src/vnc-display.vala"
						break;
#line 1059 "vnc-display.c"
					}
#line 55 "/home/fborges/checkout/gnome-boxes/src/vnc-display.vala"
					case VNC_DISPLAY_CREDENTIAL_PASSWORD:
#line 1063 "vnc-display.c"
					{
#line 61 "/home/fborges/checkout/gnome-boxes/src/vnc-display.vala"
						boxes_display_set_need_password ((BoxesDisplay*) self, TRUE);
#line 62 "/home/fborges/checkout/gnome-boxes/src/vnc-display.vala"
						break;
#line 1069 "vnc-display.c"
					}
#line 55 "/home/fborges/checkout/gnome-boxes/src/vnc-display.vala"
					case VNC_DISPLAY_CREDENTIAL_CLIENTNAME:
#line 1073 "vnc-display.c"
					{
#line 65 "/home/fborges/checkout/gnome-boxes/src/vnc-display.vala"
						break;
#line 1077 "vnc-display.c"
					}
					default:
					{
						VncDisplayCredential _tmp2_;
						GEnumValue* _tmp3_;
						gchar* _tmp4_;
						gchar* _tmp5_;
#line 68 "/home/fborges/checkout/gnome-boxes/src/vnc-display.vala"
						_tmp2_ = credential;
#line 68 "/home/fborges/checkout/gnome-boxes/src/vnc-display.vala"
						_tmp3_ = g_enum_get_value (g_type_class_ref (vnc_display_credential_get_type ()), _tmp2_);
#line 68 "/home/fborges/checkout/gnome-boxes/src/vnc-display.vala"
						_tmp4_ = g_strdup_printf ("Unsupported credential: %s", (_tmp3_ != NULL) ? _tmp3_->value_name : NULL);
#line 68 "/home/fborges/checkout/gnome-boxes/src/vnc-display.vala"
						_tmp5_ = _tmp4_;
#line 68 "/home/fborges/checkout/gnome-boxes/src/vnc-display.vala"
						g_debug ("vnc-display.vala:68: %s", _tmp5_);
#line 68 "/home/fborges/checkout/gnome-boxes/src/vnc-display.vala"
						_g_free0 (_tmp5_);
#line 69 "/home/fborges/checkout/gnome-boxes/src/vnc-display.vala"
						break;
#line 1099 "vnc-display.c"
					}
				}
			}
		}
	}
#line 73 "/home/fborges/checkout/gnome-boxes/src/vnc-display.vala"
	_tmp6_ = self->priv->display;
#line 73 "/home/fborges/checkout/gnome-boxes/src/vnc-display.vala"
	vnc_display_close (_tmp6_);
#line 1109 "vnc-display.c"
}


static void
__boxes_vnc_display___lambda101__vnc_display_vnc_auth_credential (VncDisplay* _sender,
                                                                  GValueArray* credList,
                                                                  gpointer self)
{
#line 51 "/home/fborges/checkout/gnome-boxes/src/vnc-display.vala"
	_boxes_vnc_display___lambda101_ ((BoxesVncDisplay*) self, credList);
#line 1120 "vnc-display.c"
}


static void
_boxes_vnc_display_scale_gtk_widget_size_allocate (GtkWidget* _sender,
                                                   GtkAllocation* allocation,
                                                   gpointer self)
{
#line 76 "/home/fborges/checkout/gnome-boxes/src/vnc-display.vala"
	boxes_vnc_display_scale ((BoxesVncDisplay*) self);
#line 1131 "vnc-display.c"
}


static GObject *
boxes_vnc_display_constructor (GType type,
                               guint n_construct_properties,
                               GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	BoxesVncDisplay * self;
	gchar* _tmp0_;
	GValue _tmp1_ = {0};
	BoxesBoxConfigSavedProperty _tmp2_ = {0};
	BoxesBoxConfigSavedProperty* _tmp3_;
	VncDisplay* _tmp4_;
	VncDisplay* _tmp5_;
	VncDisplay* _tmp6_;
	VncDisplay* _tmp7_;
	VncDisplay* _tmp8_;
	GtkWindow* _tmp9_;
	GtkWindow* _tmp10_;
	VncDisplay* _tmp11_;
	VncDisplay* _tmp12_;
	VncDisplay* _tmp13_;
	VncDisplay* _tmp14_;
	VncDisplay* _tmp15_;
	VncDisplay* _tmp16_;
	VncDisplay* _tmp17_;
	VncDisplay* _tmp18_;
#line 14 "/home/fborges/checkout/gnome-boxes/src/vnc-display.vala"
	parent_class = G_OBJECT_CLASS (boxes_vnc_display_parent_class);
#line 14 "/home/fborges/checkout/gnome-boxes/src/vnc-display.vala"
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
#line 14 "/home/fborges/checkout/gnome-boxes/src/vnc-display.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, BOXES_TYPE_VNC_DISPLAY, BoxesVncDisplay);
#line 15 "/home/fborges/checkout/gnome-boxes/src/vnc-display.vala"
	_tmp0_ = g_strdup ("read-only");
#line 15 "/home/fborges/checkout/gnome-boxes/src/vnc-display.vala"
	g_value_init (&_tmp1_, G_TYPE_BOOLEAN);
#line 15 "/home/fborges/checkout/gnome-boxes/src/vnc-display.vala"
	g_value_set_boolean (&_tmp1_, FALSE);
#line 15 "/home/fborges/checkout/gnome-boxes/src/vnc-display.vala"
	memset (&_tmp2_, 0, sizeof (BoxesBoxConfigSavedProperty));
#line 15 "/home/fborges/checkout/gnome-boxes/src/vnc-display.vala"
	_g_free0 (_tmp2_.name);
#line 15 "/home/fborges/checkout/gnome-boxes/src/vnc-display.vala"
	_tmp2_.name = _tmp0_;
#line 15 "/home/fborges/checkout/gnome-boxes/src/vnc-display.vala"
	G_IS_VALUE (&_tmp2_.default_value) ? (g_value_unset (&_tmp2_.default_value), NULL) : NULL;
#line 15 "/home/fborges/checkout/gnome-boxes/src/vnc-display.vala"
	_tmp2_.default_value = _tmp1_;
#line 15 "/home/fborges/checkout/gnome-boxes/src/vnc-display.vala"
	_tmp3_ = g_new0 (BoxesBoxConfigSavedProperty, 1);
#line 15 "/home/fborges/checkout/gnome-boxes/src/vnc-display.vala"
	_tmp3_[0] = _tmp2_;
#line 15 "/home/fborges/checkout/gnome-boxes/src/vnc-display.vala"
	self->priv->saved_properties = (_vala_BoxesBoxConfigSavedProperty_array_free (self->priv->saved_properties, self->priv->saved_properties_length1), NULL);
#line 15 "/home/fborges/checkout/gnome-boxes/src/vnc-display.vala"
	self->priv->saved_properties = _tmp3_;
#line 15 "/home/fborges/checkout/gnome-boxes/src/vnc-display.vala"
	self->priv->saved_properties_length1 = 1;
#line 15 "/home/fborges/checkout/gnome-boxes/src/vnc-display.vala"
	self->priv->_saved_properties_size_ = self->priv->saved_properties_length1;
#line 18 "/home/fborges/checkout/gnome-boxes/src/vnc-display.vala"
	boxes_display_set_need_password ((BoxesDisplay*) self, FALSE);
#line 20 "/home/fborges/checkout/gnome-boxes/src/vnc-display.vala"
	_tmp4_ = (VncDisplay*) vnc_display_new ();
#line 20 "/home/fborges/checkout/gnome-boxes/src/vnc-display.vala"
	g_object_ref_sink (_tmp4_);
#line 20 "/home/fborges/checkout/gnome-boxes/src/vnc-display.vala"
	_g_object_unref0 (self->priv->display);
#line 20 "/home/fborges/checkout/gnome-boxes/src/vnc-display.vala"
	self->priv->display = _tmp4_;
#line 21 "/home/fborges/checkout/gnome-boxes/src/vnc-display.vala"
	_tmp5_ = self->priv->display;
#line 21 "/home/fborges/checkout/gnome-boxes/src/vnc-display.vala"
	vnc_display_set_keyboard_grab (_tmp5_, TRUE);
#line 22 "/home/fborges/checkout/gnome-boxes/src/vnc-display.vala"
	_tmp6_ = self->priv->display;
#line 22 "/home/fborges/checkout/gnome-boxes/src/vnc-display.vala"
	vnc_display_set_pointer_grab (_tmp6_, TRUE);
#line 23 "/home/fborges/checkout/gnome-boxes/src/vnc-display.vala"
	_tmp7_ = self->priv->display;
#line 23 "/home/fborges/checkout/gnome-boxes/src/vnc-display.vala"
	vnc_display_set_force_size (_tmp7_, FALSE);
#line 24 "/home/fborges/checkout/gnome-boxes/src/vnc-display.vala"
	_tmp8_ = self->priv->display;
#line 24 "/home/fborges/checkout/gnome-boxes/src/vnc-display.vala"
	vnc_display_set_scaling (_tmp8_, TRUE);
#line 28 "/home/fborges/checkout/gnome-boxes/src/vnc-display.vala"
	_tmp9_ = (GtkWindow*) gtk_window_new (GTK_WINDOW_TOPLEVEL);
#line 28 "/home/fborges/checkout/gnome-boxes/src/vnc-display.vala"
	g_object_ref_sink (_tmp9_);
#line 28 "/home/fborges/checkout/gnome-boxes/src/vnc-display.vala"
	_g_object_unref0 (self->priv->window);
#line 28 "/home/fborges/checkout/gnome-boxes/src/vnc-display.vala"
	self->priv->window = _tmp9_;
#line 29 "/home/fborges/checkout/gnome-boxes/src/vnc-display.vala"
	_tmp10_ = self->priv->window;
#line 29 "/home/fborges/checkout/gnome-boxes/src/vnc-display.vala"
	_tmp11_ = self->priv->display;
#line 29 "/home/fborges/checkout/gnome-boxes/src/vnc-display.vala"
	gtk_container_add ((GtkContainer*) _tmp10_, (GtkWidget*) _tmp11_);
#line 30 "/home/fborges/checkout/gnome-boxes/src/vnc-display.vala"
	_tmp12_ = self->priv->display;
#line 30 "/home/fborges/checkout/gnome-boxes/src/vnc-display.vala"
	gtk_widget_realize ((GtkWidget*) _tmp12_);
#line 32 "/home/fborges/checkout/gnome-boxes/src/vnc-display.vala"
	_tmp13_ = self->priv->display;
#line 32 "/home/fborges/checkout/gnome-boxes/src/vnc-display.vala"
	g_signal_connect_object (_tmp13_, "vnc-initialized", (GCallback) __boxes_vnc_display___lambda97__vnc_display_vnc_initialized, self, 0);
#line 36 "/home/fborges/checkout/gnome-boxes/src/vnc-display.vala"
	_tmp14_ = self->priv->display;
#line 36 "/home/fborges/checkout/gnome-boxes/src/vnc-display.vala"
	g_signal_connect_object (_tmp14_, "vnc-disconnected", (GCallback) __boxes_vnc_display___lambda98__vnc_display_vnc_disconnected, self, 0);
#line 41 "/home/fborges/checkout/gnome-boxes/src/vnc-display.vala"
	_tmp15_ = self->priv->display;
#line 41 "/home/fborges/checkout/gnome-boxes/src/vnc-display.vala"
	g_signal_connect_object (_tmp15_, "vnc-auth-failure", (GCallback) __boxes_vnc_display___lambda99__vnc_display_vnc_auth_failure, self, 0);
#line 47 "/home/fborges/checkout/gnome-boxes/src/vnc-display.vala"
	_tmp16_ = self->priv->display;
#line 47 "/home/fborges/checkout/gnome-boxes/src/vnc-display.vala"
	g_signal_connect_object (_tmp16_, "vnc-auth-unsupported", (GCallback) __boxes_vnc_display___lambda100__vnc_display_vnc_auth_unsupported, self, 0);
#line 51 "/home/fborges/checkout/gnome-boxes/src/vnc-display.vala"
	_tmp17_ = self->priv->display;
#line 51 "/home/fborges/checkout/gnome-boxes/src/vnc-display.vala"
	g_signal_connect_object (_tmp17_, "vnc-auth-credential", (GCallback) __boxes_vnc_display___lambda101__vnc_display_vnc_auth_credential, self, 0);
#line 76 "/home/fborges/checkout/gnome-boxes/src/vnc-display.vala"
	_tmp18_ = self->priv->display;
#line 76 "/home/fborges/checkout/gnome-boxes/src/vnc-display.vala"
	g_signal_connect_object ((GtkWidget*) _tmp18_, "size-allocate", (GCallback) _boxes_vnc_display_scale_gtk_widget_size_allocate, self, 0);
#line 14 "/home/fborges/checkout/gnome-boxes/src/vnc-display.vala"
	return obj;
#line 1266 "vnc-display.c"
}


static void
boxes_vnc_display_class_init (BoxesVncDisplayClass * klass)
{
#line 5 "/home/fborges/checkout/gnome-boxes/src/vnc-display.vala"
	boxes_vnc_display_parent_class = g_type_class_peek_parent (klass);
#line 5 "/home/fborges/checkout/gnome-boxes/src/vnc-display.vala"
	g_type_class_add_private (klass, sizeof (BoxesVncDisplayPrivate));
#line 5 "/home/fborges/checkout/gnome-boxes/src/vnc-display.vala"
	((BoxesDisplayClass *) klass)->get_display = (GtkWidget* (*) (BoxesDisplay *, gint)) boxes_vnc_display_real_get_display;
#line 5 "/home/fborges/checkout/gnome-boxes/src/vnc-display.vala"
	((BoxesDisplayClass *) klass)->set_enable_audio = (void (*) (BoxesDisplay *, gboolean)) boxes_vnc_display_real_set_enable_audio;
#line 5 "/home/fborges/checkout/gnome-boxes/src/vnc-display.vala"
	((BoxesDisplayClass *) klass)->get_pixbuf = (GdkPixbuf* (*) (BoxesDisplay *, gint, GError**)) boxes_vnc_display_real_get_pixbuf;
#line 5 "/home/fborges/checkout/gnome-boxes/src/vnc-display.vala"
	((BoxesDisplayClass *) klass)->connect_it = (void (*) (BoxesDisplay *, BoxesDisplayOpenFDFunc, void*, GDestroyNotify, GError**)) boxes_vnc_display_real_connect_it;
#line 5 "/home/fborges/checkout/gnome-boxes/src/vnc-display.vala"
	((BoxesDisplayClass *) klass)->disconnect_it = (void (*) (BoxesDisplay *)) boxes_vnc_display_real_disconnect_it;
#line 5 "/home/fborges/checkout/gnome-boxes/src/vnc-display.vala"
	((BoxesDisplayClass *) klass)->get_properties = (GList* (*) (BoxesDisplay *, BoxesPropertiesPage)) boxes_vnc_display_real_get_properties;
#line 5 "/home/fborges/checkout/gnome-boxes/src/vnc-display.vala"
	((BoxesDisplayClass *) klass)->send_keys = (void (*) (BoxesDisplay *, guint*, int)) boxes_vnc_display_real_send_keys;
#line 5 "/home/fborges/checkout/gnome-boxes/src/vnc-display.vala"
	BOXES_DISPLAY_CLASS (klass)->get_protocol = boxes_vnc_display_real_get_protocol;
#line 5 "/home/fborges/checkout/gnome-boxes/src/vnc-display.vala"
	BOXES_DISPLAY_CLASS (klass)->get_uri = boxes_vnc_display_real_get_uri;
#line 5 "/home/fborges/checkout/gnome-boxes/src/vnc-display.vala"
	G_OBJECT_CLASS (klass)->get_property = _vala_boxes_vnc_display_get_property;
#line 5 "/home/fborges/checkout/gnome-boxes/src/vnc-display.vala"
	G_OBJECT_CLASS (klass)->constructor = boxes_vnc_display_constructor;
#line 5 "/home/fborges/checkout/gnome-boxes/src/vnc-display.vala"
	G_OBJECT_CLASS (klass)->finalize = boxes_vnc_display_finalize;
#line 5 "/home/fborges/checkout/gnome-boxes/src/vnc-display.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), BOXES_VNC_DISPLAY_PROTOCOL_PROPERTY, boxes_vnc_display_properties[BOXES_VNC_DISPLAY_PROTOCOL_PROPERTY] = g_param_spec_string ("protocol", "protocol", "protocol", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
#line 5 "/home/fborges/checkout/gnome-boxes/src/vnc-display.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), BOXES_VNC_DISPLAY_URI_PROPERTY, boxes_vnc_display_properties[BOXES_VNC_DISPLAY_URI_PROPERTY] = g_param_spec_string ("uri", "uri", "uri", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
#line 1305 "vnc-display.c"
}


static void
boxes_vnc_display_instance_init (BoxesVncDisplay * self)
{
#line 5 "/home/fborges/checkout/gnome-boxes/src/vnc-display.vala"
	self->priv = BOXES_VNC_DISPLAY_GET_PRIVATE (self);
#line 1314 "vnc-display.c"
}


static void
boxes_vnc_display_finalize (GObject * obj)
{
	BoxesVncDisplay * self;
#line 5 "/home/fborges/checkout/gnome-boxes/src/vnc-display.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, BOXES_TYPE_VNC_DISPLAY, BoxesVncDisplay);
#line 8 "/home/fborges/checkout/gnome-boxes/src/vnc-display.vala"
	_g_object_unref0 (self->priv->display);
#line 9 "/home/fborges/checkout/gnome-boxes/src/vnc-display.vala"
	_g_free0 (self->priv->host);
#line 11 "/home/fborges/checkout/gnome-boxes/src/vnc-display.vala"
	_g_object_unref0 (self->priv->window);
#line 12 "/home/fborges/checkout/gnome-boxes/src/vnc-display.vala"
	self->priv->saved_properties = (_vala_BoxesBoxConfigSavedProperty_array_free (self->priv->saved_properties, self->priv->saved_properties_length1), NULL);
#line 5 "/home/fborges/checkout/gnome-boxes/src/vnc-display.vala"
	G_OBJECT_CLASS (boxes_vnc_display_parent_class)->finalize (obj);
#line 1334 "vnc-display.c"
}


GType
boxes_vnc_display_get_type (void)
{
	static volatile gsize boxes_vnc_display_type_id__volatile = 0;
	if (g_once_init_enter (&boxes_vnc_display_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (BoxesVncDisplayClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) boxes_vnc_display_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (BoxesVncDisplay), 0, (GInstanceInitFunc) boxes_vnc_display_instance_init, NULL };
		GType boxes_vnc_display_type_id;
		boxes_vnc_display_type_id = g_type_register_static (BOXES_TYPE_DISPLAY, "BoxesVncDisplay", &g_define_type_info, 0);
		g_once_init_leave (&boxes_vnc_display_type_id__volatile, boxes_vnc_display_type_id);
	}
	return boxes_vnc_display_type_id__volatile;
}


static void
_vala_boxes_vnc_display_get_property (GObject * object,
                                      guint property_id,
                                      GValue * value,
                                      GParamSpec * pspec)
{
	BoxesVncDisplay * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, BOXES_TYPE_VNC_DISPLAY, BoxesVncDisplay);
#line 5 "/home/fborges/checkout/gnome-boxes/src/vnc-display.vala"
	switch (property_id) {
#line 5 "/home/fborges/checkout/gnome-boxes/src/vnc-display.vala"
		case BOXES_VNC_DISPLAY_PROTOCOL_PROPERTY:
#line 5 "/home/fborges/checkout/gnome-boxes/src/vnc-display.vala"
		g_value_set_string (value, boxes_display_get_protocol ((BoxesDisplay*) self));
#line 5 "/home/fborges/checkout/gnome-boxes/src/vnc-display.vala"
		break;
#line 5 "/home/fborges/checkout/gnome-boxes/src/vnc-display.vala"
		case BOXES_VNC_DISPLAY_URI_PROPERTY:
#line 5 "/home/fborges/checkout/gnome-boxes/src/vnc-display.vala"
		g_value_take_string (value, boxes_display_get_uri ((BoxesDisplay*) self));
#line 5 "/home/fborges/checkout/gnome-boxes/src/vnc-display.vala"
		break;
#line 1374 "vnc-display.c"
		default:
#line 5 "/home/fborges/checkout/gnome-boxes/src/vnc-display.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 5 "/home/fborges/checkout/gnome-boxes/src/vnc-display.vala"
		break;
#line 1380 "vnc-display.c"
	}
}



