/* util.c generated by valac 0.15.0, the Vala compiler
 * generated from util.vala, do not modify */

/* This file is part of GNOME Boxes. License: LGPLv2+*/

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <config.h>
#include <glib/gstdio.h>
#include <gio/gio.h>
#include <gdk/gdk.h>
#include <clutter/clutter.h>
#include <float.h>
#include <math.h>
#include <gtk/gtk.h>
#include <libxml/parser.h>
#include <libxml/tree.h>
#include <libxml/xpath.h>
#include <osinfo/osinfo.h>
#include <gobject/gvaluecollector.h>

#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _gtk_widget_path_unref0(var) ((var == NULL) ? NULL : (var = (gtk_widget_path_unref (var), NULL)))
typedef struct _Block19Data Block19Data;
#define _gtk_tree_path_free0(var) ((var == NULL) ? NULL : (var = (gtk_tree_path_free (var), NULL)))
typedef struct _Block20Data Block20Data;
typedef struct _BoxesOutputStreamWriteData BoxesOutputStreamWriteData;
#define _xmlFreeParserCtxt0(var) ((var == NULL) ? NULL : (var = (xmlFreeParserCtxt (var), NULL)))
#define _xmlXPathFreeContext0(var) ((var == NULL) ? NULL : (var = (xmlXPathFreeContext (var), NULL)))
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))
#define _g_type_class_unref0(var) ((var == NULL) ? NULL : (var = (g_type_class_unref (var), NULL)))

#define BOXES_TYPE_PAIR (boxes_pair_get_type ())
#define BOXES_PAIR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), BOXES_TYPE_PAIR, BoxesPair))
#define BOXES_PAIR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), BOXES_TYPE_PAIR, BoxesPairClass))
#define BOXES_IS_PAIR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), BOXES_TYPE_PAIR))
#define BOXES_IS_PAIR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), BOXES_TYPE_PAIR))
#define BOXES_PAIR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), BOXES_TYPE_PAIR, BoxesPairClass))

typedef struct _BoxesPair BoxesPair;
typedef struct _BoxesPairClass BoxesPairClass;
typedef struct _BoxesPairPrivate BoxesPairPrivate;
#define _t1_destroy_func0(var) (((var == NULL) || (t1_destroy_func == NULL)) ? NULL : (var = (t1_destroy_func (var), NULL)))
#define _t2_destroy_func0(var) (((var == NULL) || (t2_destroy_func == NULL)) ? NULL : (var = (t2_destroy_func (var), NULL)))
typedef struct _BoxesParamSpecPair BoxesParamSpecPair;

#define BOXES_TYPE_QUERY (boxes_query_get_type ())
#define BOXES_QUERY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), BOXES_TYPE_QUERY, BoxesQuery))
#define BOXES_QUERY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), BOXES_TYPE_QUERY, BoxesQueryClass))
#define BOXES_IS_QUERY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), BOXES_TYPE_QUERY))
#define BOXES_IS_QUERY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), BOXES_TYPE_QUERY))
#define BOXES_QUERY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), BOXES_TYPE_QUERY, BoxesQueryClass))

typedef struct _BoxesQuery BoxesQuery;
typedef struct _BoxesQueryClass BoxesQueryClass;
typedef struct _BoxesQueryPrivate BoxesQueryPrivate;
#define _g_hash_table_unref0(var) ((var == NULL) ? NULL : (var = (g_hash_table_unref (var), NULL)))

typedef enum  {
	BOXES_ERROR_INVALID
} BoxesError;
#define BOXES_ERROR boxes_error_quark ()
struct _Block19Data {
	int _ref_count_;
	GtkTreeView* tree_view;
};

struct _Block20Data {
	int _ref_count_;
	GtkIconView* icon_view;
};

struct _BoxesOutputStreamWriteData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	GOutputStream* stream;
	guint8* buffer;
	gint buffer_length1;
	guint8* _tmp0_;
	gint _tmp0__length1;
	gint length;
	gssize i;
	gssize _tmp1_;
	gint _tmp2_;
	GOutputStream* _tmp3_;
	guint8* _tmp4_;
	gint _tmp4__length1;
	gssize _tmp5_;
	gint _tmp6_;
	gssize _tmp7_;
	gssize _tmp8_;
	gssize _tmp9_;
	GError * _inner_error_;
};

struct _BoxesPair {
	GTypeInstance parent_instance;
	volatile int ref_count;
	BoxesPairPrivate * priv;
	gpointer first;
	gpointer second;
};

struct _BoxesPairClass {
	GTypeClass parent_class;
	void (*finalize) (BoxesPair *self);
};

struct _BoxesPairPrivate {
	GType t1_type;
	GBoxedCopyFunc t1_dup_func;
	GDestroyNotify t1_destroy_func;
	GType t2_type;
	GBoxedCopyFunc t2_dup_func;
	GDestroyNotify t2_destroy_func;
};

struct _BoxesParamSpecPair {
	GParamSpec parent_instance;
};

struct _BoxesQuery {
	GObject parent_instance;
	BoxesQueryPrivate * priv;
};

struct _BoxesQueryClass {
	GObjectClass parent_class;
};

struct _BoxesQueryPrivate {
	gchar* query;
	GHashTable* params;
};


static gpointer boxes_pair_parent_class = NULL;
static gpointer boxes_query_parent_class = NULL;

GQuark boxes_error_quark (void);
#define BOXES_F10_KEY ((guint) 0xffc7)
#define BOXES_F11_KEY ((guint) 0xffc8)
#define BOXES_F12_KEY ((guint) 0xffc9)
gchar* boxes_get_pkgdata (const gchar* file_name);
gchar* boxes_get_style (const gchar* file_name);
gchar* boxes_get_pixmap (const gchar* file_name);
gchar* boxes_get_unattended_dir (const gchar* file_name);
void boxes_ensure_directory (const gchar* dir);
gchar* boxes_get_user_unattended_dir (const gchar* file_name);
gchar* boxes_get_pkgconfig (const gchar* file_name);
gchar* boxes_get_pkgdata_source (const gchar* file_name);
gchar* boxes_get_pkgcache (const gchar* file_name);
gchar* boxes_get_user_pkgdata (const gchar* file_name);
gboolean boxes_has_pkgconfig_sources (void);
gchar* boxes_get_pkgconfig_source (const gchar* file_name);
void boxes_gdk_rgba_to_clutter_color (GdkRGBA* gdk_rgba, ClutterColor* result);
void boxes_get_boxes_bg_color (GdkRGBA* result);
void boxes_get_color (const gchar* desc, GdkColor* result);
void boxes_tree_view_activate_on_single_click (GtkTreeView* tree_view, gboolean should_activate);
static Block19Data* block19_data_ref (Block19Data* _data19_);
static void block19_data_unref (Block19Data* _data19_);
static gboolean ____lambda50_ (Block19Data* _data19_, GtkWidget* w, GdkEventButton* event);
static gboolean _____lambda50__gtk_widget_button_press_event (GtkWidget* _sender, GdkEventButton* event, gpointer self);
void boxes_icon_view_activate_on_single_click (GtkIconView* icon_view, gboolean should_activate);
static Block20Data* block20_data_ref (Block20Data* _data20_);
static void block20_data_unref (Block20Data* _data20_);
static gboolean ____lambda6_ (Block20Data* _data20_, GtkWidget* w, GdkEventButton* event);
static gboolean _____lambda6__gtk_widget_button_press_event (GtkWidget* _sender, GdkEventButton* event, gpointer self);
static void boxes_output_stream_write_data_free (gpointer _data);
static guint8* _vala_array_dup7 (guint8* self, int length);
void boxes_output_stream_write (GOutputStream* stream, guint8* buffer, int buffer_length1, GAsyncReadyCallback _callback_, gpointer _user_data_);
void boxes_output_stream_write_finish (GAsyncResult* _res_, GError** error);
static gboolean boxes_output_stream_write_co (BoxesOutputStreamWriteData* _data_);
static void boxes_output_stream_write_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
gchar* boxes_extract_xpath (const gchar* xmldoc, const gchar* xpath, gboolean required, GError** error);
gboolean boxes_keyfile_save (GKeyFile* key_file, const gchar* file_name, gboolean overwrite);
gchar* boxes_replace_regex (const gchar* str, const gchar* old, const gchar* replacement);
gchar* boxes_make_filename (const gchar* name);
void boxes_actor_add (ClutterActor* actor, ClutterContainer* container);
void boxes_actor_remove (ClutterActor* actor);
void boxes_actor_pin (ClutterActor* actor);
void boxes_actor_unpin (ClutterActor* actor);
OsinfoDevice* boxes_get_os_device_by_prop (OsinfoOs* os, const gchar* prop_name, const gchar* prop_value);
gint boxes_get_enum_value (const gchar* value_nick, GType enum_type);
static GEnumValue* _g_enum_value_dup (GEnumValue* self);
gpointer boxes_pair_ref (gpointer instance);
void boxes_pair_unref (gpointer instance);
GParamSpec* boxes_param_spec_pair (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void boxes_value_set_pair (GValue* value, gpointer v_object);
void boxes_value_take_pair (GValue* value, gpointer v_object);
gpointer boxes_value_get_pair (const GValue* value);
GType boxes_pair_get_type (void) G_GNUC_CONST;
#define BOXES_PAIR_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), BOXES_TYPE_PAIR, BoxesPairPrivate))
enum  {
	BOXES_PAIR_DUMMY_PROPERTY
};
BoxesPair* boxes_pair_new (GType t1_type, GBoxedCopyFunc t1_dup_func, GDestroyNotify t1_destroy_func, GType t2_type, GBoxedCopyFunc t2_dup_func, GDestroyNotify t2_destroy_func, gconstpointer first, gconstpointer second);
BoxesPair* boxes_pair_construct (GType object_type, GType t1_type, GBoxedCopyFunc t1_dup_func, GDestroyNotify t1_destroy_func, GType t2_type, GBoxedCopyFunc t2_dup_func, GDestroyNotify t2_destroy_func, gconstpointer first, gconstpointer second);
static void boxes_pair_finalize (BoxesPair* obj);
GType boxes_query_get_type (void) G_GNUC_CONST;
#define BOXES_QUERY_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), BOXES_TYPE_QUERY, BoxesQueryPrivate))
enum  {
	BOXES_QUERY_DUMMY_PROPERTY
};
BoxesQuery* boxes_query_new (const gchar* query);
BoxesQuery* boxes_query_construct (GType object_type, const gchar* query);
void boxes_query_parse (BoxesQuery* self);
gchar* boxes_query_get (BoxesQuery* self, const gchar* key);
static GObject * boxes_query_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties);
static void _g_free0_ (gpointer var);
static void boxes_query_finalize (GObject* obj);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);


GQuark boxes_error_quark (void) {
	return g_quark_from_static_string ("boxes_error-quark");
}


gchar* boxes_get_pkgdata (const gchar* file_name) {
	gchar* result = NULL;
	const gchar* _tmp0_;
	gchar* _tmp1_ = NULL;
	_tmp0_ = file_name;
	_tmp1_ = g_build_filename (DATADIR, PACKAGE_TARNAME, _tmp0_, NULL);
	result = _tmp1_;
	return result;
}


gchar* boxes_get_style (const gchar* file_name) {
	gchar* result = NULL;
	gchar* _tmp0_ = NULL;
	gchar* _tmp1_;
	const gchar* _tmp2_;
	gchar* _tmp3_ = NULL;
	gchar* _tmp4_;
	_tmp0_ = boxes_get_pkgdata (NULL);
	_tmp1_ = _tmp0_;
	_tmp2_ = file_name;
	_tmp3_ = g_build_filename (_tmp1_, "style", _tmp2_, NULL);
	_tmp4_ = _tmp3_;
	_g_free0 (_tmp1_);
	result = _tmp4_;
	return result;
}


gchar* boxes_get_pixmap (const gchar* file_name) {
	gchar* result = NULL;
	gchar* _tmp0_ = NULL;
	gchar* _tmp1_;
	const gchar* _tmp2_;
	gchar* _tmp3_ = NULL;
	gchar* _tmp4_;
	_tmp0_ = boxes_get_pkgdata (NULL);
	_tmp1_ = _tmp0_;
	_tmp2_ = file_name;
	_tmp3_ = g_build_filename (_tmp1_, "pixmaps", _tmp2_, NULL);
	_tmp4_ = _tmp3_;
	_g_free0 (_tmp1_);
	result = _tmp4_;
	return result;
}


gchar* boxes_get_unattended_dir (const gchar* file_name) {
	gchar* result = NULL;
	gchar* _tmp0_ = NULL;
	gchar* _tmp1_;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_;
	gchar* dir;
	const gchar* _tmp4_;
	gchar* _tmp5_ = NULL;
	_tmp0_ = boxes_get_pkgdata (NULL);
	_tmp1_ = _tmp0_;
	_tmp2_ = g_build_filename (_tmp1_, "unattended", NULL);
	_tmp3_ = _tmp2_;
	_g_free0 (_tmp1_);
	dir = _tmp3_;
	boxes_ensure_directory (dir);
	_tmp4_ = file_name;
	_tmp5_ = g_build_filename (dir, _tmp4_, NULL);
	result = _tmp5_;
	_g_free0 (dir);
	return result;
}


gchar* boxes_get_user_unattended_dir (const gchar* file_name) {
	gchar* result = NULL;
	gchar* _tmp0_ = NULL;
	gchar* _tmp1_;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_;
	gchar* dir;
	const gchar* _tmp4_;
	gchar* _tmp5_ = NULL;
	_tmp0_ = boxes_get_pkgconfig (NULL);
	_tmp1_ = _tmp0_;
	_tmp2_ = g_build_filename (_tmp1_, "unattended", NULL);
	_tmp3_ = _tmp2_;
	_g_free0 (_tmp1_);
	dir = _tmp3_;
	boxes_ensure_directory (dir);
	_tmp4_ = file_name;
	_tmp5_ = g_build_filename (dir, _tmp4_, NULL);
	result = _tmp5_;
	_g_free0 (dir);
	return result;
}


gchar* boxes_get_pkgdata_source (const gchar* file_name) {
	gchar* result = NULL;
	gchar* _tmp0_ = NULL;
	gchar* _tmp1_;
	const gchar* _tmp2_;
	gchar* _tmp3_ = NULL;
	gchar* _tmp4_;
	_tmp0_ = boxes_get_pkgdata (NULL);
	_tmp1_ = _tmp0_;
	_tmp2_ = file_name;
	_tmp3_ = g_build_filename (_tmp1_, "sources", _tmp2_, NULL);
	_tmp4_ = _tmp3_;
	_g_free0 (_tmp1_);
	result = _tmp4_;
	return result;
}


gchar* boxes_get_pkgcache (const gchar* file_name) {
	gchar* result = NULL;
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	gchar* dir;
	const gchar* _tmp2_;
	gchar* _tmp3_ = NULL;
	_tmp0_ = g_get_user_cache_dir ();
	_tmp1_ = g_build_filename (_tmp0_, PACKAGE_TARNAME, NULL);
	dir = _tmp1_;
	boxes_ensure_directory (dir);
	_tmp2_ = file_name;
	_tmp3_ = g_build_filename (dir, _tmp2_, NULL);
	result = _tmp3_;
	_g_free0 (dir);
	return result;
}


gchar* boxes_get_pkgconfig (const gchar* file_name) {
	gchar* result = NULL;
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	gchar* dir;
	const gchar* _tmp2_;
	gchar* _tmp3_ = NULL;
	_tmp0_ = g_get_user_config_dir ();
	_tmp1_ = g_build_filename (_tmp0_, PACKAGE_TARNAME, NULL);
	dir = _tmp1_;
	boxes_ensure_directory (dir);
	_tmp2_ = file_name;
	_tmp3_ = g_build_filename (dir, _tmp2_, NULL);
	result = _tmp3_;
	_g_free0 (dir);
	return result;
}


gchar* boxes_get_user_pkgdata (const gchar* file_name) {
	gchar* result = NULL;
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	gchar* dir;
	const gchar* _tmp2_;
	gchar* _tmp3_ = NULL;
	_tmp0_ = g_get_user_data_dir ();
	_tmp1_ = g_build_filename (_tmp0_, PACKAGE_TARNAME, NULL);
	dir = _tmp1_;
	boxes_ensure_directory (dir);
	_tmp2_ = file_name;
	_tmp3_ = g_build_filename (dir, _tmp2_, NULL);
	result = _tmp3_;
	_g_free0 (dir);
	return result;
}


gboolean boxes_has_pkgconfig_sources (void) {
	gboolean result = FALSE;
	gchar* _tmp0_ = NULL;
	gchar* _tmp1_;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_;
	gboolean _tmp4_ = FALSE;
	gboolean _tmp5_;
	_tmp0_ = boxes_get_pkgconfig (NULL);
	_tmp1_ = _tmp0_;
	_tmp2_ = g_build_filename (_tmp1_, "sources", NULL);
	_tmp3_ = _tmp2_;
	_tmp4_ = g_file_test (_tmp3_, G_FILE_TEST_IS_DIR);
	_tmp5_ = _tmp4_;
	_g_free0 (_tmp3_);
	_g_free0 (_tmp1_);
	result = _tmp5_;
	return result;
}


gchar* boxes_get_pkgconfig_source (const gchar* file_name) {
	gchar* result = NULL;
	gchar* _tmp0_ = NULL;
	gchar* _tmp1_;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_;
	gchar* dir;
	const gchar* _tmp4_;
	gchar* _tmp5_ = NULL;
	_tmp0_ = boxes_get_pkgconfig (NULL);
	_tmp1_ = _tmp0_;
	_tmp2_ = g_build_filename (_tmp1_, "sources", NULL);
	_tmp3_ = _tmp2_;
	_g_free0 (_tmp1_);
	dir = _tmp3_;
	boxes_ensure_directory (dir);
	_tmp4_ = file_name;
	_tmp5_ = g_build_filename (dir, _tmp4_, NULL);
	result = _tmp5_;
	_g_free0 (dir);
	return result;
}


void boxes_ensure_directory (const gchar* dir) {
	GError * _inner_error_ = NULL;
	g_return_if_fail (dir != NULL);
	{
		const gchar* _tmp0_;
		GFile* _tmp1_ = NULL;
		GFile* file;
		_tmp0_ = dir;
		_tmp1_ = g_file_new_for_path (_tmp0_);
		file = _tmp1_;
		g_file_make_directory_with_parents (file, NULL, &_inner_error_);
		if (_inner_error_ != NULL) {
			_g_object_unref0 (file);
			goto __catch35_g_error;
		}
		_g_object_unref0 (file);
	}
	goto __finally35;
	__catch35_g_error:
	{
		GError* _error_ = NULL;
		GError* _tmp2_;
		GError* _tmp3_;
		const gchar* _tmp4_;
		_error_ = _inner_error_;
		_inner_error_ = NULL;
		_tmp2_ = _error_;
		if (g_error_matches (_tmp2_, G_IO_ERROR, G_IO_ERROR_EXISTS)) {
			_g_error_free0 (_error_);
			return;
		}
		_tmp3_ = _error_;
		_tmp4_ = _tmp3_->message;
		g_warning ("util.vala:91: %s", _tmp4_);
		_g_error_free0 (_error_);
	}
	__finally35:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
}


void boxes_gdk_rgba_to_clutter_color (GdkRGBA* gdk_rgba, ClutterColor* result) {
	GdkRGBA _tmp0_;
	gdouble _tmp1_;
	gdouble _tmp2_ = 0.0;
	GdkRGBA _tmp3_;
	gdouble _tmp4_;
	gdouble _tmp5_ = 0.0;
	GdkRGBA _tmp6_;
	gdouble _tmp7_;
	gdouble _tmp8_ = 0.0;
	GdkRGBA _tmp9_;
	gdouble _tmp10_;
	gdouble _tmp11_ = 0.0;
	ClutterColor _tmp12_ = {0};
	ClutterColor color;
	g_return_if_fail (gdk_rgba != NULL);
	_tmp0_ = *gdk_rgba;
	_tmp1_ = _tmp0_.red;
	_tmp2_ = CLAMP (_tmp1_ * 255, (gdouble) 0, (gdouble) 255);
	_tmp3_ = *gdk_rgba;
	_tmp4_ = _tmp3_.green;
	_tmp5_ = CLAMP (_tmp4_ * 255, (gdouble) 0, (gdouble) 255);
	_tmp6_ = *gdk_rgba;
	_tmp7_ = _tmp6_.blue;
	_tmp8_ = CLAMP (_tmp7_ * 255, (gdouble) 0, (gdouble) 255);
	_tmp9_ = *gdk_rgba;
	_tmp10_ = _tmp9_.alpha;
	_tmp11_ = CLAMP (_tmp10_ * 255, (gdouble) 0, (gdouble) 255);
	_tmp12_.red = (guint8) _tmp2_;
	_tmp12_.green = (guint8) _tmp5_;
	_tmp12_.blue = (guint8) _tmp8_;
	_tmp12_.alpha = (guint8) _tmp11_;
	color = _tmp12_;
	*result = color;
	return;
}


void boxes_get_boxes_bg_color (GdkRGBA* result) {
	GtkStyleContext* _tmp0_;
	GtkStyleContext* style;
	GtkWidgetPath* _tmp1_;
	GtkWidgetPath* path;
	GdkRGBA _tmp2_ = {0};
	_tmp0_ = gtk_style_context_new ();
	style = _tmp0_;
	_tmp1_ = gtk_widget_path_new ();
	path = _tmp1_;
	gtk_widget_path_append_type (path, GTK_TYPE_WINDOW);
	gtk_style_context_set_path (style, path);
	gtk_style_context_add_class (style, "boxes-bg");
	gtk_style_context_get_background_color (style, 0, &_tmp2_);
	*result = _tmp2_;
	_gtk_widget_path_unref0 (path);
	_g_object_unref0 (style);
	return;
}


void boxes_get_color (const gchar* desc, GdkColor* result) {
	GdkColor color = {0};
	const gchar* _tmp0_;
	GdkColor _tmp1_ = {0};
	g_return_if_fail (desc != NULL);
	_tmp0_ = desc;
	gdk_color_parse (_tmp0_, &_tmp1_);
	color = _tmp1_;
	*result = color;
	return;
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static Block19Data* block19_data_ref (Block19Data* _data19_) {
	g_atomic_int_inc (&_data19_->_ref_count_);
	return _data19_;
}


static void block19_data_unref (Block19Data* _data19_) {
	if (g_atomic_int_dec_and_test (&_data19_->_ref_count_)) {
		_g_object_unref0 (_data19_->tree_view);
		g_slice_free (Block19Data, _data19_);
	}
}


static gboolean ____lambda50_ (Block19Data* _data19_, GtkWidget* w, GdkEventButton* event) {
	gboolean result = FALSE;
	GtkTreePath* path = NULL;
	GtkTreeViewColumn* column = NULL;
	gint x = 0;
	gint y = 0;
	gboolean _tmp0_ = FALSE;
	GdkEventButton _tmp1_;
	guint _tmp2_;
	gboolean _tmp5_;
	g_return_val_if_fail (w != NULL, FALSE);
	g_return_val_if_fail (event != NULL, FALSE);
	_tmp1_ = *event;
	_tmp2_ = _tmp1_.button;
	if (_tmp2_ == ((guint) 1)) {
		GdkEventButton _tmp3_;
		GdkEventType _tmp4_;
		_tmp3_ = *event;
		_tmp4_ = _tmp3_.type;
		_tmp0_ = _tmp4_ == GDK_BUTTON_PRESS;
	} else {
		_tmp0_ = FALSE;
	}
	_tmp5_ = _tmp0_;
	if (_tmp5_) {
		GtkTreeView* _tmp6_;
		GdkEventButton _tmp7_;
		gdouble _tmp8_;
		GdkEventButton _tmp9_;
		gdouble _tmp10_;
		GtkTreePath* _tmp11_ = NULL;
		GtkTreeViewColumn* _tmp12_ = NULL;
		gint _tmp13_ = 0;
		gint _tmp14_ = 0;
		GtkTreePath* _tmp15_;
		_tmp6_ = _data19_->tree_view;
		_tmp7_ = *event;
		_tmp8_ = _tmp7_.x;
		_tmp9_ = *event;
		_tmp10_ = _tmp9_.y;
		gtk_tree_view_get_path_at_pos (_tmp6_, (gint) _tmp8_, (gint) _tmp10_, &_tmp11_, &_tmp12_, &_tmp13_, &_tmp14_);
		_gtk_tree_path_free0 (path);
		path = _tmp11_;
		column = _tmp12_;
		x = _tmp13_;
		y = _tmp14_;
		_tmp15_ = path;
		if (_tmp15_ != NULL) {
			GtkTreeView* _tmp16_;
			GtkTreePath* _tmp17_;
			GtkTreeViewColumn* _tmp18_;
			_tmp16_ = _data19_->tree_view;
			_tmp17_ = path;
			_tmp18_ = column;
			gtk_tree_view_row_activated (_tmp16_, _tmp17_, _tmp18_);
		}
	}
	result = FALSE;
	_gtk_tree_path_free0 (path);
	return result;
}


static gboolean _____lambda50__gtk_widget_button_press_event (GtkWidget* _sender, GdkEventButton* event, gpointer self) {
	gboolean result;
	result = ____lambda50_ (self, _sender, event);
	return result;
}


void boxes_tree_view_activate_on_single_click (GtkTreeView* tree_view, gboolean should_activate) {
	Block19Data* _data19_;
	GtkTreeView* _tmp0_;
	GtkTreeView* _tmp1_;
	GtkTreeView* _tmp2_;
	gconstpointer _tmp3_ = NULL;
	gulong id;
	gboolean _tmp4_ = FALSE;
	gulong _tmp5_;
	gboolean _tmp7_;
	g_return_if_fail (tree_view != NULL);
	_data19_ = g_slice_new0 (Block19Data);
	_data19_->_ref_count_ = 1;
	_tmp0_ = tree_view;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	_data19_->tree_view = _tmp1_;
	_tmp2_ = _data19_->tree_view;
	_tmp3_ = g_object_get_data ((GObject*) _tmp2_, "boxes-tree-view-activate");
	id = GPOINTER_TO_UINT (_tmp3_);
	_tmp5_ = id;
	if (_tmp5_ != ((gulong) 0)) {
		gboolean _tmp6_;
		_tmp6_ = should_activate;
		_tmp4_ = _tmp6_ == FALSE;
	} else {
		_tmp4_ = FALSE;
	}
	_tmp7_ = _tmp4_;
	if (_tmp7_) {
		GtkTreeView* _tmp8_;
		gulong _tmp9_;
		GtkTreeView* _tmp10_;
		_tmp8_ = _data19_->tree_view;
		_tmp9_ = id;
		g_signal_handler_disconnect ((GObject*) _tmp8_, _tmp9_);
		_tmp10_ = _data19_->tree_view;
		g_object_set_data_full ((GObject*) _tmp10_, "boxes-tree-view-activate", GUINT_TO_POINTER ((gulong) 0), NULL);
	} else {
		gboolean _tmp11_ = FALSE;
		gulong _tmp12_;
		gboolean _tmp14_;
		_tmp12_ = id;
		if (_tmp12_ == ((gulong) 0)) {
			gboolean _tmp13_;
			_tmp13_ = should_activate;
			_tmp11_ = _tmp13_;
		} else {
			_tmp11_ = FALSE;
		}
		_tmp14_ = _tmp11_;
		if (_tmp14_) {
			GtkTreeView* _tmp15_;
			gulong _tmp16_ = 0UL;
			GtkTreeView* _tmp17_;
			gulong _tmp18_;
			_tmp15_ = _data19_->tree_view;
			_tmp16_ = g_signal_connect_data ((GtkWidget*) _tmp15_, "button-press-event", (GCallback) _____lambda50__gtk_widget_button_press_event, block19_data_ref (_data19_), (GClosureNotify) block19_data_unref, 0);
			id = _tmp16_;
			_tmp17_ = _data19_->tree_view;
			_tmp18_ = id;
			g_object_set_data_full ((GObject*) _tmp17_, "boxes-tree-view-activate", GUINT_TO_POINTER (_tmp18_), NULL);
		}
	}
	block19_data_unref (_data19_);
	_data19_ = NULL;
}


static Block20Data* block20_data_ref (Block20Data* _data20_) {
	g_atomic_int_inc (&_data20_->_ref_count_);
	return _data20_;
}


static void block20_data_unref (Block20Data* _data20_) {
	if (g_atomic_int_dec_and_test (&_data20_->_ref_count_)) {
		_g_object_unref0 (_data20_->icon_view);
		g_slice_free (Block20Data, _data20_);
	}
}


static gpointer _gtk_tree_path_copy0 (gpointer self) {
	return self ? gtk_tree_path_copy (self) : NULL;
}


static gboolean ____lambda6_ (Block20Data* _data20_, GtkWidget* w, GdkEventButton* event) {
	gboolean result = FALSE;
	GtkTreePath* path = NULL;
	gboolean _tmp0_ = FALSE;
	GdkEventButton _tmp1_;
	guint _tmp2_;
	gboolean _tmp5_;
	g_return_val_if_fail (w != NULL, FALSE);
	g_return_val_if_fail (event != NULL, FALSE);
	_tmp1_ = *event;
	_tmp2_ = _tmp1_.button;
	if (_tmp2_ == ((guint) 1)) {
		GdkEventButton _tmp3_;
		GdkEventType _tmp4_;
		_tmp3_ = *event;
		_tmp4_ = _tmp3_.type;
		_tmp0_ = _tmp4_ == GDK_BUTTON_PRESS;
	} else {
		_tmp0_ = FALSE;
	}
	_tmp5_ = _tmp0_;
	if (_tmp5_) {
		GtkIconView* _tmp6_;
		GdkEventButton _tmp7_;
		gdouble _tmp8_;
		GdkEventButton _tmp9_;
		gdouble _tmp10_;
		GtkTreePath* _tmp11_ = NULL;
		GtkTreePath* _tmp12_;
		GtkTreePath* _tmp13_;
		_tmp6_ = _data20_->icon_view;
		_tmp7_ = *event;
		_tmp8_ = _tmp7_.x;
		_tmp9_ = *event;
		_tmp10_ = _tmp9_.y;
		_tmp11_ = gtk_icon_view_get_path_at_pos (_tmp6_, (gint) _tmp8_, (gint) _tmp10_);
		_tmp12_ = _gtk_tree_path_copy0 (_tmp11_);
		_gtk_tree_path_free0 (path);
		path = _tmp12_;
		_tmp13_ = path;
		if (_tmp13_ != NULL) {
			GtkIconView* _tmp14_;
			GtkTreePath* _tmp15_;
			_tmp14_ = _data20_->icon_view;
			_tmp15_ = path;
			gtk_icon_view_item_activated (_tmp14_, _tmp15_);
		}
	}
	result = FALSE;
	_gtk_tree_path_free0 (path);
	return result;
}


static gboolean _____lambda6__gtk_widget_button_press_event (GtkWidget* _sender, GdkEventButton* event, gpointer self) {
	gboolean result;
	result = ____lambda6_ (self, _sender, event);
	return result;
}


void boxes_icon_view_activate_on_single_click (GtkIconView* icon_view, gboolean should_activate) {
	Block20Data* _data20_;
	GtkIconView* _tmp0_;
	GtkIconView* _tmp1_;
	GtkIconView* _tmp2_;
	gconstpointer _tmp3_ = NULL;
	gulong id;
	gboolean _tmp4_ = FALSE;
	gulong _tmp5_;
	gboolean _tmp7_;
	g_return_if_fail (icon_view != NULL);
	_data20_ = g_slice_new0 (Block20Data);
	_data20_->_ref_count_ = 1;
	_tmp0_ = icon_view;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	_data20_->icon_view = _tmp1_;
	_tmp2_ = _data20_->icon_view;
	_tmp3_ = g_object_get_data ((GObject*) _tmp2_, "boxes-icon-view-activate");
	id = GPOINTER_TO_UINT (_tmp3_);
	_tmp5_ = id;
	if (_tmp5_ != ((gulong) 0)) {
		gboolean _tmp6_;
		_tmp6_ = should_activate;
		_tmp4_ = _tmp6_ == FALSE;
	} else {
		_tmp4_ = FALSE;
	}
	_tmp7_ = _tmp4_;
	if (_tmp7_) {
		GtkIconView* _tmp8_;
		gulong _tmp9_;
		GtkIconView* _tmp10_;
		_tmp8_ = _data20_->icon_view;
		_tmp9_ = id;
		g_signal_handler_disconnect ((GObject*) _tmp8_, _tmp9_);
		_tmp10_ = _data20_->icon_view;
		g_object_set_data_full ((GObject*) _tmp10_, "boxes-icon-view-activate", GUINT_TO_POINTER ((gulong) 0), NULL);
	} else {
		gboolean _tmp11_ = FALSE;
		gulong _tmp12_;
		gboolean _tmp14_;
		_tmp12_ = id;
		if (_tmp12_ == ((gulong) 0)) {
			gboolean _tmp13_;
			_tmp13_ = should_activate;
			_tmp11_ = _tmp13_;
		} else {
			_tmp11_ = FALSE;
		}
		_tmp14_ = _tmp11_;
		if (_tmp14_) {
			GtkIconView* _tmp15_;
			gulong _tmp16_ = 0UL;
			GtkIconView* _tmp17_;
			gulong _tmp18_;
			_tmp15_ = _data20_->icon_view;
			_tmp16_ = g_signal_connect_data ((GtkWidget*) _tmp15_, "button-press-event", (GCallback) _____lambda6__gtk_widget_button_press_event, block20_data_ref (_data20_), (GClosureNotify) block20_data_unref, 0);
			id = _tmp16_;
			_tmp17_ = _data20_->icon_view;
			_tmp18_ = id;
			g_object_set_data_full ((GObject*) _tmp17_, "boxes-icon-view-activate", GUINT_TO_POINTER (_tmp18_), NULL);
		}
	}
	block20_data_unref (_data20_);
	_data20_ = NULL;
}


static void boxes_output_stream_write_data_free (gpointer _data) {
	BoxesOutputStreamWriteData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->stream);
	_data_->buffer = (g_free (_data_->buffer), NULL);
	g_slice_free (BoxesOutputStreamWriteData, _data_);
}


static guint8* _vala_array_dup7 (guint8* self, int length) {
	return g_memdup (self, length * sizeof (guint8));
}


void boxes_output_stream_write (GOutputStream* stream, guint8* buffer, int buffer_length1, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	BoxesOutputStreamWriteData* _data_;
	GOutputStream* _tmp0_;
	GOutputStream* _tmp1_;
	guint8* _tmp2_;
	gint _tmp2__length1;
	guint8* _tmp3_;
	gint _tmp3__length1;
	_data_ = g_slice_new0 (BoxesOutputStreamWriteData);
	_data_->_async_result = g_simple_async_result_new (g_object_newv (G_TYPE_OBJECT, 0, NULL), _callback_, _user_data_, boxes_output_stream_write);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, boxes_output_stream_write_data_free);
	_tmp0_ = stream;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	_data_->stream = _tmp1_;
	_tmp2_ = buffer;
	_tmp2__length1 = buffer_length1;
	_tmp3_ = (_tmp2_ != NULL) ? _vala_array_dup7 (_tmp2_, _tmp2__length1) : ((gpointer) _tmp2_);
	_tmp3__length1 = _tmp2__length1;
	_data_->buffer = _tmp3_;
	_data_->buffer_length1 = _tmp3__length1;
	boxes_output_stream_write_co (_data_);
}


void boxes_output_stream_write_finish (GAsyncResult* _res_, GError** error) {
	BoxesOutputStreamWriteData* _data_;
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
		return;
	}
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


static void boxes_output_stream_write_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	BoxesOutputStreamWriteData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	boxes_output_stream_write_co (_data_);
}


static gboolean boxes_output_stream_write_co (BoxesOutputStreamWriteData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = _data_->buffer;
	_data_->_tmp0__length1 = _data_->buffer_length1;
	_data_->length = _data_->_tmp0__length1;
	_data_->i = (gssize) 0;
	while (TRUE) {
		_data_->_tmp1_ = _data_->i;
		_data_->_tmp2_ = _data_->length;
		if (!(_data_->_tmp1_ < ((gssize) _data_->_tmp2_))) {
			break;
		}
		_data_->_tmp3_ = _data_->stream;
		_data_->_tmp4_ = _data_->buffer;
		_data_->_tmp4__length1 = _data_->buffer_length1;
		_data_->_tmp5_ = _data_->i;
		_data_->_tmp6_ = _data_->length;
		_data_->_state_ = 1;
		g_output_stream_write_async (_data_->_tmp3_, _data_->_tmp4_ + _data_->_tmp5_, (gsize) (_data_->_tmp6_ - _data_->_tmp5_), G_PRIORITY_DEFAULT, NULL, boxes_output_stream_write_ready, _data_);
		return FALSE;
		_state_1:
		_data_->_tmp7_ = 0L;
		_data_->_tmp7_ = g_output_stream_write_finish (_data_->_tmp3_, _data_->_res_, &_data_->_inner_error_);
		_data_->_tmp8_ = _data_->_tmp7_;
		if (_data_->_inner_error_ != NULL) {
			if (_data_->_inner_error_->domain == G_IO_ERROR) {
				g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
				g_error_free (_data_->_inner_error_);
				if (_data_->_state_ == 0) {
					g_simple_async_result_complete_in_idle (_data_->_async_result);
				} else {
					g_simple_async_result_complete (_data_->_async_result);
				}
				g_object_unref (_data_->_async_result);
				return FALSE;
			} else {
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
				g_clear_error (&_data_->_inner_error_);
				return FALSE;
			}
		}
		_data_->_tmp9_ = _data_->i;
		_data_->i = _data_->_tmp9_ + _data_->_tmp8_;
	}
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


gchar* boxes_extract_xpath (const gchar* xmldoc, const gchar* xpath, gboolean required, GError** error) {
	gchar* result = NULL;
	xmlParserCtxt* _tmp0_;
	xmlParserCtxt* parser;
	xmlParserCtxt* _tmp1_;
	const gchar* _tmp2_;
	xmlDoc* _tmp3_ = NULL;
	xmlDoc* doc;
	xmlDoc* _tmp4_;
	xmlDoc* _tmp6_;
	xmlXPathContext* _tmp7_;
	xmlXPathContext* ctxt;
	xmlXPathContext* _tmp8_;
	const gchar* _tmp9_;
	xmlXPathObject* _tmp10_ = NULL;
	xmlXPathObject* obj;
	gboolean _tmp11_ = FALSE;
	xmlXPathObject* _tmp12_;
	gboolean _tmp15_;
	xmlXPathObject* _tmp22_;
	xmlXPathObjectType _tmp23_;
	xmlXPathObject* _tmp29_;
	const gchar* _tmp30_;
	gchar* _tmp31_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (xmldoc != NULL, NULL);
	g_return_val_if_fail (xpath != NULL, NULL);
	_tmp0_ = xmlNewParserCtxt ();
	parser = _tmp0_;
	_tmp1_ = parser;
	_tmp2_ = xmldoc;
	_tmp3_ = xmlCtxtReadDoc (_tmp1_, _tmp2_, "doc.xml", NULL, 0);
	doc = _tmp3_;
	_tmp4_ = doc;
	if (_tmp4_ == NULL) {
		GError* _tmp5_;
		_tmp5_ = g_error_new_literal (BOXES_ERROR, BOXES_ERROR_INVALID, "Can't parse XML doc");
		_inner_error_ = _tmp5_;
		if (_inner_error_->domain == BOXES_ERROR) {
			g_propagate_error (error, _inner_error_);
			_xmlFreeParserCtxt0 (parser);
			return NULL;
		} else {
			_xmlFreeParserCtxt0 (parser);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	_tmp6_ = doc;
	_tmp7_ = xmlXPathNewContext (_tmp6_);
	ctxt = _tmp7_;
	_tmp8_ = ctxt;
	_tmp9_ = xpath;
	_tmp10_ = xmlXPathEval (_tmp9_, _tmp8_);
	obj = _tmp10_;
	_tmp12_ = obj;
	if (_tmp12_ == NULL) {
		_tmp11_ = TRUE;
	} else {
		xmlXPathObject* _tmp13_;
		const gchar* _tmp14_;
		_tmp13_ = obj;
		_tmp14_ = _tmp13_->stringval;
		_tmp11_ = _tmp14_ == NULL;
	}
	_tmp15_ = _tmp11_;
	if (_tmp15_) {
		gboolean _tmp16_;
		_tmp16_ = required;
		if (_tmp16_) {
			const gchar* _tmp17_;
			gchar* _tmp18_;
			gchar* _tmp19_;
			GError* _tmp20_;
			GError* _tmp21_;
			_tmp17_ = xpath;
			_tmp18_ = g_strconcat ("Failed to extract xpath ", _tmp17_, NULL);
			_tmp19_ = _tmp18_;
			_tmp20_ = g_error_new_literal (BOXES_ERROR, BOXES_ERROR_INVALID, _tmp19_);
			_tmp21_ = _tmp20_;
			_g_free0 (_tmp19_);
			_inner_error_ = _tmp21_;
			if (_inner_error_->domain == BOXES_ERROR) {
				g_propagate_error (error, _inner_error_);
				_xmlXPathFreeContext0 (ctxt);
				_xmlFreeParserCtxt0 (parser);
				return NULL;
			} else {
				_xmlXPathFreeContext0 (ctxt);
				_xmlFreeParserCtxt0 (parser);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return NULL;
			}
		} else {
			result = NULL;
			_xmlXPathFreeContext0 (ctxt);
			_xmlFreeParserCtxt0 (parser);
			return result;
		}
	}
	_tmp22_ = obj;
	_tmp23_ = _tmp22_->type;
	if (_tmp23_ != XPATH_STRING) {
		const gchar* _tmp24_;
		gchar* _tmp25_;
		gchar* _tmp26_;
		GError* _tmp27_;
		GError* _tmp28_;
		_tmp24_ = xpath;
		_tmp25_ = g_strconcat ("Failed to extract xpath ", _tmp24_, NULL);
		_tmp26_ = _tmp25_;
		_tmp27_ = g_error_new_literal (BOXES_ERROR, BOXES_ERROR_INVALID, _tmp26_);
		_tmp28_ = _tmp27_;
		_g_free0 (_tmp26_);
		_inner_error_ = _tmp28_;
		if (_inner_error_->domain == BOXES_ERROR) {
			g_propagate_error (error, _inner_error_);
			_xmlXPathFreeContext0 (ctxt);
			_xmlFreeParserCtxt0 (parser);
			return NULL;
		} else {
			_xmlXPathFreeContext0 (ctxt);
			_xmlFreeParserCtxt0 (parser);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	_tmp29_ = obj;
	_tmp30_ = _tmp29_->stringval;
	_tmp31_ = g_strdup (_tmp30_);
	result = _tmp31_;
	_xmlXPathFreeContext0 (ctxt);
	_xmlFreeParserCtxt0 (parser);
	return result;
}


gboolean boxes_keyfile_save (GKeyFile* key_file, const gchar* file_name, gboolean overwrite) {
	gboolean result = FALSE;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (key_file != NULL, FALSE);
	g_return_val_if_fail (file_name != NULL, FALSE);
	{
		const gchar* _tmp0_;
		GFile* _tmp1_ = NULL;
		GFile* file;
		GFile* _tmp2_;
		gboolean _tmp3_ = FALSE;
		GFile* _tmp6_;
		GFileOutputStream* _tmp7_ = NULL;
		GFileOutputStream* _tmp8_;
		GFileOutputStream* _tmp9_;
		GDataOutputStream* _tmp10_;
		GDataOutputStream* _tmp11_;
		GDataOutputStream* stream;
		GDataOutputStream* _tmp12_;
		GKeyFile* _tmp13_;
		gchar* _tmp14_ = NULL;
		gchar* _tmp15_;
		_tmp0_ = file_name;
		_tmp1_ = g_file_new_for_path (_tmp0_);
		file = _tmp1_;
		_tmp2_ = file;
		_tmp3_ = g_file_query_exists (_tmp2_, NULL);
		if (_tmp3_) {
			gboolean _tmp4_;
			_tmp4_ = overwrite;
			if (!_tmp4_) {
				result = FALSE;
				_g_object_unref0 (file);
				return result;
			} else {
				GFile* _tmp5_;
				_tmp5_ = file;
				g_file_delete (_tmp5_, NULL, &_inner_error_);
				if (_inner_error_ != NULL) {
					_g_object_unref0 (file);
					goto __catch36_g_error;
				}
			}
		}
		_tmp6_ = file;
		_tmp7_ = g_file_create (_tmp6_, G_FILE_CREATE_REPLACE_DESTINATION, NULL, &_inner_error_);
		_tmp8_ = _tmp7_;
		if (_inner_error_ != NULL) {
			_g_object_unref0 (file);
			goto __catch36_g_error;
		}
		_tmp9_ = _tmp8_;
		_tmp10_ = g_data_output_stream_new ((GOutputStream*) _tmp9_);
		_tmp11_ = _tmp10_;
		_g_object_unref0 (_tmp9_);
		stream = _tmp11_;
		_tmp12_ = stream;
		_tmp13_ = key_file;
		_tmp14_ = g_key_file_to_data (_tmp13_, NULL, NULL);
		_tmp15_ = _tmp14_;
		g_data_output_stream_put_string (_tmp12_, _tmp15_, NULL, &_inner_error_);
		_g_free0 (_tmp15_);
		if (_inner_error_ != NULL) {
			_g_object_unref0 (stream);
			_g_object_unref0 (file);
			goto __catch36_g_error;
		}
		result = TRUE;
		_g_object_unref0 (stream);
		_g_object_unref0 (file);
		return result;
	}
	goto __finally36;
	__catch36_g_error:
	{
		GError* _error_ = NULL;
		GError* _tmp16_;
		const gchar* _tmp17_;
		_error_ = _inner_error_;
		_inner_error_ = NULL;
		_tmp16_ = _error_;
		_tmp17_ = _tmp16_->message;
		g_warning ("util.vala:212: %s", _tmp17_);
		result = FALSE;
		_g_error_free0 (_error_);
		return result;
	}
	__finally36:
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
	g_clear_error (&_inner_error_);
	return FALSE;
}


gchar* boxes_replace_regex (const gchar* str, const gchar* old, const gchar* replacement) {
	gchar* result = NULL;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (str != NULL, NULL);
	g_return_val_if_fail (old != NULL, NULL);
	g_return_val_if_fail (replacement != NULL, NULL);
	{
		const gchar* _tmp0_;
		GRegex* _tmp1_;
		GRegex* regex;
		GRegex* _tmp2_;
		const gchar* _tmp3_;
		const gchar* _tmp4_;
		gchar* _tmp5_ = NULL;
		gchar* _tmp6_;
		_tmp0_ = old;
		_tmp1_ = g_regex_new (_tmp0_, 0, 0, &_inner_error_);
		regex = _tmp1_;
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == G_REGEX_ERROR) {
				goto __catch37_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
		_tmp2_ = regex;
		_tmp3_ = str;
		_tmp4_ = replacement;
		_tmp5_ = g_regex_replace_literal (_tmp2_, _tmp3_, (gssize) (-1), 0, _tmp4_, 0, &_inner_error_);
		_tmp6_ = _tmp5_;
		if (_inner_error_ != NULL) {
			_g_regex_unref0 (regex);
			if (_inner_error_->domain == G_REGEX_ERROR) {
				goto __catch37_g_regex_error;
			}
			_g_regex_unref0 (regex);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
		result = _tmp6_;
		_g_regex_unref0 (regex);
		return result;
	}
	goto __finally37;
	__catch37_g_regex_error:
	{
		GError* _error_ = NULL;
		GError* _tmp7_;
		const gchar* _tmp8_;
		const gchar* _tmp9_;
		gchar* _tmp10_;
		_error_ = _inner_error_;
		_inner_error_ = NULL;
		_tmp7_ = _error_;
		_tmp8_ = _tmp7_->message;
		g_critical ("util.vala:222: %s", _tmp8_);
		_tmp9_ = str;
		_tmp10_ = g_strdup (_tmp9_);
		result = _tmp10_;
		_g_error_free0 (_error_);
		return result;
	}
	__finally37:
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
	g_clear_error (&_inner_error_);
	return NULL;
}


gchar* boxes_make_filename (const gchar* name) {
	gchar* result = NULL;
	const gchar* _tmp0_;
	gchar* _tmp1_ = NULL;
	gchar* filename;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* tryname;
	g_return_val_if_fail (name != NULL, NULL);
	_tmp0_ = name;
	_tmp1_ = boxes_replace_regex (_tmp0_, "[\\\\/:()<>|?*]", "_");
	filename = _tmp1_;
	_tmp2_ = filename;
	_tmp3_ = g_strdup (_tmp2_);
	tryname = _tmp3_;
	{
		gint i;
		i = 0;
		{
			gboolean _tmp4_;
			_tmp4_ = TRUE;
			while (TRUE) {
				gboolean _tmp5_;
				const gchar* _tmp7_;
				gboolean _tmp8_ = FALSE;
				const gchar* _tmp9_;
				gint _tmp10_;
				gchar* _tmp11_ = NULL;
				_tmp5_ = _tmp4_;
				if (!_tmp5_) {
					gint _tmp6_;
					_tmp6_ = i;
					i = _tmp6_ + 1;
				}
				_tmp4_ = FALSE;
				_tmp7_ = tryname;
				_tmp8_ = g_file_test (_tmp7_, G_FILE_TEST_EXISTS);
				if (!_tmp8_) {
					break;
				}
				_tmp9_ = filename;
				_tmp10_ = i;
				_tmp11_ = g_strdup_printf ("%s-%d", _tmp9_, _tmp10_);
				_g_free0 (tryname);
				tryname = _tmp11_;
			}
		}
	}
	result = tryname;
	_g_free0 (filename);
	return result;
}


void boxes_actor_add (ClutterActor* actor, ClutterContainer* container) {
	ClutterActor* _tmp0_;
	ClutterActor* _tmp1_ = NULL;
	ClutterContainer* _tmp2_;
	ClutterActor* _tmp3_;
	ClutterContainer* _tmp4_;
	ClutterActor* _tmp5_;
	g_return_if_fail (actor != NULL);
	g_return_if_fail (container != NULL);
	_tmp0_ = actor;
	_tmp1_ = clutter_actor_get_parent (_tmp0_);
	_tmp2_ = container;
	if (_tmp1_ == CLUTTER_ACTOR (_tmp2_)) {
		return;
	}
	_tmp3_ = actor;
	boxes_actor_remove (_tmp3_);
	_tmp4_ = container;
	_tmp5_ = actor;
	clutter_container_add (_tmp4_, _tmp5_, NULL);
}


void boxes_actor_remove (ClutterActor* actor) {
	ClutterActor* _tmp0_;
	ClutterActor* _tmp1_ = NULL;
	ClutterContainer* _tmp2_;
	ClutterContainer* container;
	ClutterContainer* _tmp3_;
	ClutterContainer* _tmp4_;
	ClutterActor* _tmp5_;
	g_return_if_fail (actor != NULL);
	_tmp0_ = actor;
	_tmp1_ = clutter_actor_get_parent (_tmp0_);
	_tmp2_ = _g_object_ref0 (CLUTTER_IS_CONTAINER (_tmp1_) ? ((ClutterContainer*) _tmp1_) : NULL);
	container = _tmp2_;
	_tmp3_ = container;
	if (_tmp3_ == NULL) {
		_g_object_unref0 (container);
		return;
	}
	_tmp4_ = container;
	_tmp5_ = actor;
	clutter_container_remove (_tmp4_, _tmp5_, NULL);
	_g_object_unref0 (container);
}


void boxes_actor_pin (ClutterActor* actor) {
	ClutterActor* _tmp0_;
	ClutterActor* _tmp1_;
	ClutterGeometry _tmp2_ = {0};
	g_return_if_fail (actor != NULL);
	_tmp0_ = actor;
	_tmp1_ = actor;
	clutter_actor_get_geometry (_tmp1_, &_tmp2_);
	clutter_actor_set_geometry (_tmp0_, &_tmp2_);
}


void boxes_actor_unpin (ClutterActor* actor) {
	ClutterActor* _tmp0_;
	ClutterActor* _tmp1_;
	g_return_if_fail (actor != NULL);
	_tmp0_ = actor;
	clutter_actor_set_size (_tmp0_, (gfloat) (-1), (gfloat) (-1));
	_tmp1_ = actor;
	clutter_actor_set_position (_tmp1_, (gfloat) (-1), (gfloat) (-1));
}


OsinfoDevice* boxes_get_os_device_by_prop (OsinfoOs* os, const gchar* prop_name, const gchar* prop_value) {
	OsinfoDevice* result = NULL;
	OsinfoOs* _tmp0_;
	OsinfoFilter* _tmp1_;
	OsinfoFilter* filter;
	OsinfoFilter* _tmp2_;
	const gchar* _tmp3_;
	const gchar* _tmp4_;
	OsinfoOs* _tmp5_;
	OsinfoDeviceList* _tmp6_ = NULL;
	OsinfoDeviceList* _tmp7_;
	OsinfoFilter* _tmp8_;
	OsinfoDeviceList* _tmp9_ = NULL;
	OsinfoDeviceList* _tmp10_;
	OsinfoDeviceList* devices;
	OsinfoDevice* _tmp11_ = NULL;
	OsinfoDeviceList* _tmp12_;
	gint _tmp13_ = 0;
	OsinfoDevice* _tmp16_;
	OsinfoDevice* _tmp17_;
	g_return_val_if_fail (prop_name != NULL, NULL);
	g_return_val_if_fail (prop_value != NULL, NULL);
	_tmp0_ = os;
	if (_tmp0_ == NULL) {
		result = NULL;
		return result;
	}
	_tmp1_ = osinfo_filter_new ();
	filter = _tmp1_;
	_tmp2_ = filter;
	_tmp3_ = prop_name;
	_tmp4_ = prop_value;
	osinfo_filter_add_constraint (_tmp2_, _tmp3_, _tmp4_);
	_tmp5_ = os;
	_tmp6_ = osinfo_os_get_all_devices (_tmp5_, NULL);
	_tmp7_ = _tmp6_;
	_tmp8_ = filter;
	_tmp9_ = osinfo_devicelist_new_filtered (_tmp7_, _tmp8_);
	_tmp10_ = _tmp9_;
	_g_object_unref0 (_tmp7_);
	devices = _tmp10_;
	_tmp12_ = devices;
	_tmp13_ = osinfo_list_get_length ((OsinfoList*) _tmp12_);
	if (_tmp13_ > 0) {
		OsinfoDeviceList* _tmp14_;
		OsinfoEntity* _tmp15_ = NULL;
		_tmp14_ = devices;
		_tmp15_ = osinfo_list_get_nth ((OsinfoList*) _tmp14_, 0);
		_tmp11_ = OSINFO_IS_DEVICE (_tmp15_) ? ((OsinfoDevice*) _tmp15_) : NULL;
	} else {
		_tmp11_ = NULL;
	}
	_tmp16_ = _tmp11_;
	_tmp17_ = _g_object_ref0 (_tmp16_);
	result = _tmp17_;
	_g_object_unref0 (devices);
	_g_object_unref0 (filter);
	return result;
}


static GEnumValue* _g_enum_value_dup (GEnumValue* self) {
	GEnumValue* dup;
	dup = g_new0 (GEnumValue, 1);
	memcpy (dup, self, sizeof (GEnumValue));
	return dup;
}


static gpointer __g_enum_value_dup0 (gpointer self) {
	return self ? _g_enum_value_dup (self) : NULL;
}


gint boxes_get_enum_value (const gchar* value_nick, GType enum_type) {
	gint result = 0;
	GType _tmp0_;
	GTypeClass* _tmp1_ = NULL;
	GEnumClass* enum_class;
	const gchar* _tmp2_;
	GEnumValue* _tmp3_ = NULL;
	GEnumValue* _tmp4_;
	GEnumValue* val;
	gint _tmp5_;
	g_return_val_if_fail (value_nick != NULL, 0);
	_tmp0_ = enum_type;
	_tmp1_ = g_type_class_ref (_tmp0_);
	enum_class = (GEnumClass*) _tmp1_;
	_tmp2_ = value_nick;
	_tmp3_ = g_enum_get_value_by_nick (enum_class, _tmp2_);
	_tmp4_ = __g_enum_value_dup0 (_tmp3_);
	val = _tmp4_;
	g_return_val_if_fail (val != NULL, -1);
	_tmp5_ = (*val).value;
	result = _tmp5_;
	_g_free0 (val);
	_g_type_class_unref0 (enum_class);
	return result;
}


BoxesPair* boxes_pair_construct (GType object_type, GType t1_type, GBoxedCopyFunc t1_dup_func, GDestroyNotify t1_destroy_func, GType t2_type, GBoxedCopyFunc t2_dup_func, GDestroyNotify t2_destroy_func, gconstpointer first, gconstpointer second) {
	BoxesPair* self = NULL;
	gconstpointer _tmp0_;
	gpointer _tmp1_;
	gconstpointer _tmp2_;
	gpointer _tmp3_;
	self = (BoxesPair*) g_type_create_instance (object_type);
	self->priv->t1_type = t1_type;
	self->priv->t1_dup_func = t1_dup_func;
	self->priv->t1_destroy_func = t1_destroy_func;
	self->priv->t2_type = t2_type;
	self->priv->t2_dup_func = t2_dup_func;
	self->priv->t2_destroy_func = t2_destroy_func;
	_tmp0_ = first;
	_tmp1_ = ((_tmp0_ != NULL) && (t1_dup_func != NULL)) ? t1_dup_func ((gpointer) _tmp0_) : ((gpointer) _tmp0_);
	_t1_destroy_func0 (self->first);
	self->first = _tmp1_;
	_tmp2_ = second;
	_tmp3_ = ((_tmp2_ != NULL) && (t2_dup_func != NULL)) ? t2_dup_func ((gpointer) _tmp2_) : ((gpointer) _tmp2_);
	_t2_destroy_func0 (self->second);
	self->second = _tmp3_;
	return self;
}


BoxesPair* boxes_pair_new (GType t1_type, GBoxedCopyFunc t1_dup_func, GDestroyNotify t1_destroy_func, GType t2_type, GBoxedCopyFunc t2_dup_func, GDestroyNotify t2_destroy_func, gconstpointer first, gconstpointer second) {
	return boxes_pair_construct (BOXES_TYPE_PAIR, t1_type, t1_dup_func, t1_destroy_func, t2_type, t2_dup_func, t2_destroy_func, first, second);
}


static void boxes_value_pair_init (GValue* value) {
	value->data[0].v_pointer = NULL;
}


static void boxes_value_pair_free_value (GValue* value) {
	if (value->data[0].v_pointer) {
		boxes_pair_unref (value->data[0].v_pointer);
	}
}


static void boxes_value_pair_copy_value (const GValue* src_value, GValue* dest_value) {
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = boxes_pair_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}


static gpointer boxes_value_pair_peek_pointer (const GValue* value) {
	return value->data[0].v_pointer;
}


static gchar* boxes_value_pair_collect_value (GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	if (collect_values[0].v_pointer) {
		BoxesPair* object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = boxes_pair_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}


static gchar* boxes_value_pair_lcopy_value (const GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	BoxesPair** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = boxes_pair_ref (value->data[0].v_pointer);
	}
	return NULL;
}


GParamSpec* boxes_param_spec_pair (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) {
	BoxesParamSpecPair* spec;
	g_return_val_if_fail (g_type_is_a (object_type, BOXES_TYPE_PAIR), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}


gpointer boxes_value_get_pair (const GValue* value) {
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, BOXES_TYPE_PAIR), NULL);
	return value->data[0].v_pointer;
}


void boxes_value_set_pair (GValue* value, gpointer v_object) {
	BoxesPair* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, BOXES_TYPE_PAIR));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, BOXES_TYPE_PAIR));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		boxes_pair_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		boxes_pair_unref (old);
	}
}


void boxes_value_take_pair (GValue* value, gpointer v_object) {
	BoxesPair* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, BOXES_TYPE_PAIR));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, BOXES_TYPE_PAIR));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		boxes_pair_unref (old);
	}
}


static void boxes_pair_class_init (BoxesPairClass * klass) {
	boxes_pair_parent_class = g_type_class_peek_parent (klass);
	BOXES_PAIR_CLASS (klass)->finalize = boxes_pair_finalize;
	g_type_class_add_private (klass, sizeof (BoxesPairPrivate));
}


static void boxes_pair_instance_init (BoxesPair * self) {
	self->priv = BOXES_PAIR_GET_PRIVATE (self);
	self->ref_count = 1;
}


static void boxes_pair_finalize (BoxesPair* obj) {
	BoxesPair * self;
	self = BOXES_PAIR (obj);
	((self->first == NULL) || (self->priv->t1_destroy_func == NULL)) ? NULL : (self->first = (self->priv->t1_destroy_func (self->first), NULL));
	((self->second == NULL) || (self->priv->t2_destroy_func == NULL)) ? NULL : (self->second = (self->priv->t2_destroy_func (self->second), NULL));
}


GType boxes_pair_get_type (void) {
	static volatile gsize boxes_pair_type_id__volatile = 0;
	if (g_once_init_enter (&boxes_pair_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { boxes_value_pair_init, boxes_value_pair_free_value, boxes_value_pair_copy_value, boxes_value_pair_peek_pointer, "p", boxes_value_pair_collect_value, "p", boxes_value_pair_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (BoxesPairClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) boxes_pair_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (BoxesPair), 0, (GInstanceInitFunc) boxes_pair_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType boxes_pair_type_id;
		boxes_pair_type_id = g_type_register_fundamental (g_type_fundamental_next (), "BoxesPair", &g_define_type_info, &g_define_type_fundamental_info, 0);
		g_once_init_leave (&boxes_pair_type_id__volatile, boxes_pair_type_id);
	}
	return boxes_pair_type_id__volatile;
}


gpointer boxes_pair_ref (gpointer instance) {
	BoxesPair* self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}


void boxes_pair_unref (gpointer instance) {
	BoxesPair* self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		BOXES_PAIR_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}


BoxesQuery* boxes_query_construct (GType object_type, const gchar* query) {
	BoxesQuery * self = NULL;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	g_return_val_if_fail (query != NULL, NULL);
	self = (BoxesQuery*) g_object_new (object_type, NULL);
	_tmp0_ = query;
	_tmp1_ = g_strdup (_tmp0_);
	_g_free0 (self->priv->query);
	self->priv->query = _tmp1_;
	boxes_query_parse (self);
	return self;
}


BoxesQuery* boxes_query_new (const gchar* query) {
	return boxes_query_construct (BOXES_TYPE_QUERY, query);
}


void boxes_query_parse (BoxesQuery* self) {
	const gchar* _tmp0_;
	gchar** _tmp1_;
	gchar** _tmp2_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->query;
	_tmp2_ = _tmp1_ = g_strsplit (_tmp0_, "&", 0);
	{
		gchar** p_collection = NULL;
		gint p_collection_length1 = 0;
		gint _p_collection_size_ = 0;
		gint p_it = 0;
		p_collection = _tmp2_;
		p_collection_length1 = _vala_array_length (_tmp1_);
		for (p_it = 0; p_it < _vala_array_length (_tmp1_); p_it = p_it + 1) {
			gchar* _tmp3_;
			gchar* p = NULL;
			_tmp3_ = g_strdup (p_collection[p_it]);
			p = _tmp3_;
			{
				const gchar* _tmp4_;
				gchar** _tmp5_;
				gchar** _tmp6_ = NULL;
				gchar** pair;
				gint pair_length1;
				gint _pair_size_;
				gchar** _tmp7_;
				gint _tmp7__length1;
				GHashTable* _tmp8_;
				gchar** _tmp9_;
				gint _tmp9__length1;
				const gchar* _tmp10_;
				gchar* _tmp11_;
				gchar** _tmp12_;
				gint _tmp12__length1;
				const gchar* _tmp13_;
				gchar* _tmp14_;
				_tmp4_ = p;
				_tmp6_ = _tmp5_ = g_strsplit (_tmp4_, "=", 0);
				pair = _tmp6_;
				pair_length1 = _vala_array_length (_tmp5_);
				_pair_size_ = pair_length1;
				_tmp7_ = pair;
				_tmp7__length1 = pair_length1;
				if (_tmp7__length1 != 2) {
					pair = (_vala_array_free (pair, pair_length1, (GDestroyNotify) g_free), NULL);
					_g_free0 (p);
					continue;
				}
				_tmp8_ = self->priv->params;
				_tmp9_ = pair;
				_tmp9__length1 = pair_length1;
				_tmp10_ = _tmp9_[0];
				_tmp11_ = g_strdup (_tmp10_);
				_tmp12_ = pair;
				_tmp12__length1 = pair_length1;
				_tmp13_ = _tmp12_[1];
				_tmp14_ = g_strdup (_tmp13_);
				g_hash_table_insert (_tmp8_, _tmp11_, _tmp14_);
				pair = (_vala_array_free (pair, pair_length1, (GDestroyNotify) g_free), NULL);
				_g_free0 (p);
			}
		}
		p_collection = (_vala_array_free (p_collection, p_collection_length1, (GDestroyNotify) g_free), NULL);
	}
}


gchar* boxes_query_get (BoxesQuery* self, const gchar* key) {
	gchar* result = NULL;
	GHashTable* _tmp0_;
	const gchar* _tmp1_;
	gconstpointer _tmp2_ = NULL;
	gchar* _tmp3_;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (key != NULL, NULL);
	_tmp0_ = self->priv->params;
	_tmp1_ = key;
	_tmp2_ = g_hash_table_lookup (_tmp0_, _tmp1_);
	_tmp3_ = g_strdup ((const gchar*) _tmp2_);
	result = _tmp3_;
	return result;
}


static void _g_free0_ (gpointer var) {
	var = (g_free (var), NULL);
}


static GObject * boxes_query_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties) {
	GObject * obj;
	GObjectClass * parent_class;
	BoxesQuery * self;
	GHashFunc _tmp0_;
	GEqualFunc _tmp1_;
	GHashTable* _tmp2_;
	parent_class = G_OBJECT_CLASS (boxes_query_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = BOXES_QUERY (obj);
	_tmp0_ = g_str_hash;
	_tmp1_ = g_str_equal;
	_tmp2_ = g_hash_table_new_full (_tmp0_, _tmp1_, _g_free0_, _g_free0_);
	_g_hash_table_unref0 (self->priv->params);
	self->priv->params = _tmp2_;
	return obj;
}


static void boxes_query_class_init (BoxesQueryClass * klass) {
	boxes_query_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (BoxesQueryPrivate));
	G_OBJECT_CLASS (klass)->constructor = boxes_query_constructor;
	G_OBJECT_CLASS (klass)->finalize = boxes_query_finalize;
}


static void boxes_query_instance_init (BoxesQuery * self) {
	self->priv = BOXES_QUERY_GET_PRIVATE (self);
}


static void boxes_query_finalize (GObject* obj) {
	BoxesQuery * self;
	self = BOXES_QUERY (obj);
	_g_free0 (self->priv->query);
	_g_hash_table_unref0 (self->priv->params);
	G_OBJECT_CLASS (boxes_query_parent_class)->finalize (obj);
}


GType boxes_query_get_type (void) {
	static volatile gsize boxes_query_type_id__volatile = 0;
	if (g_once_init_enter (&boxes_query_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (BoxesQueryClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) boxes_query_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (BoxesQuery), 0, (GInstanceInitFunc) boxes_query_instance_init, NULL };
		GType boxes_query_type_id;
		boxes_query_type_id = g_type_register_static (G_TYPE_OBJECT, "BoxesQuery", &g_define_type_info, 0);
		g_once_init_leave (&boxes_query_type_id__volatile, boxes_query_type_id);
	}
	return boxes_query_type_id__volatile;
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static gint _vala_array_length (gpointer array) {
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}



