/* winxp-installer.c generated by valac 0.17.4.26-61532, the Vala compiler
 * generated from winxp-installer.vala, do not modify */

/* This file is part of GNOME Boxes. License: LGPLv2+*/
/* Automated installer media for Windows XP, 2000 and 2003*/

#include <glib.h>
#include <glib-object.h>
#include <libvirt-gconfig/libvirt-gconfig.h>
#include <gio/gio.h>
#include <stdlib.h>
#include <string.h>
#include <gtk/gtk.h>
#include <libcommon.h>
#include <osinfo/osinfo.h>
#include <glib/gi18n-lib.h>


#define BOXES_TYPE_INSTALLER_MEDIA (boxes_installer_media_get_type ())
#define BOXES_INSTALLER_MEDIA(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), BOXES_TYPE_INSTALLER_MEDIA, BoxesInstallerMedia))
#define BOXES_INSTALLER_MEDIA_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), BOXES_TYPE_INSTALLER_MEDIA, BoxesInstallerMediaClass))
#define BOXES_IS_INSTALLER_MEDIA(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), BOXES_TYPE_INSTALLER_MEDIA))
#define BOXES_IS_INSTALLER_MEDIA_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), BOXES_TYPE_INSTALLER_MEDIA))
#define BOXES_INSTALLER_MEDIA_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), BOXES_TYPE_INSTALLER_MEDIA, BoxesInstallerMediaClass))

typedef struct _BoxesInstallerMedia BoxesInstallerMedia;
typedef struct _BoxesInstallerMediaClass BoxesInstallerMediaClass;
typedef struct _BoxesInstallerMediaPrivate BoxesInstallerMediaPrivate;

#define BOXES_TYPE_UNATTENDED_INSTALLER (boxes_unattended_installer_get_type ())
#define BOXES_UNATTENDED_INSTALLER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), BOXES_TYPE_UNATTENDED_INSTALLER, BoxesUnattendedInstaller))
#define BOXES_UNATTENDED_INSTALLER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), BOXES_TYPE_UNATTENDED_INSTALLER, BoxesUnattendedInstallerClass))
#define BOXES_IS_UNATTENDED_INSTALLER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), BOXES_TYPE_UNATTENDED_INSTALLER))
#define BOXES_IS_UNATTENDED_INSTALLER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), BOXES_TYPE_UNATTENDED_INSTALLER))
#define BOXES_UNATTENDED_INSTALLER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), BOXES_TYPE_UNATTENDED_INSTALLER, BoxesUnattendedInstallerClass))

typedef struct _BoxesUnattendedInstaller BoxesUnattendedInstaller;
typedef struct _BoxesUnattendedInstallerClass BoxesUnattendedInstallerClass;
typedef struct _BoxesUnattendedInstallerPrivate BoxesUnattendedInstallerPrivate;

#define BOXES_TYPE_UNATTENDED_FILE (boxes_unattended_file_get_type ())
#define BOXES_UNATTENDED_FILE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), BOXES_TYPE_UNATTENDED_FILE, BoxesUnattendedFile))
#define BOXES_IS_UNATTENDED_FILE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), BOXES_TYPE_UNATTENDED_FILE))
#define BOXES_UNATTENDED_FILE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), BOXES_TYPE_UNATTENDED_FILE, BoxesUnattendedFileIface))

typedef struct _BoxesUnattendedFile BoxesUnattendedFile;
typedef struct _BoxesUnattendedFileIface BoxesUnattendedFileIface;

#define TYPE_AVATAR_FORMAT (avatar_format_get_type ())
#define AVATAR_FORMAT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_AVATAR_FORMAT, AvatarFormat))
#define AVATAR_FORMAT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_AVATAR_FORMAT, AvatarFormatClass))
#define IS_AVATAR_FORMAT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_AVATAR_FORMAT))
#define IS_AVATAR_FORMAT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_AVATAR_FORMAT))
#define AVATAR_FORMAT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_AVATAR_FORMAT, AvatarFormatClass))

typedef struct _AvatarFormat AvatarFormat;
typedef struct _AvatarFormatClass AvatarFormatClass;

#define BOXES_TYPE_WINDOWS_INSTALLER (boxes_windows_installer_get_type ())
#define BOXES_WINDOWS_INSTALLER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), BOXES_TYPE_WINDOWS_INSTALLER, BoxesWindowsInstaller))
#define BOXES_WINDOWS_INSTALLER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), BOXES_TYPE_WINDOWS_INSTALLER, BoxesWindowsInstallerClass))
#define BOXES_IS_WINDOWS_INSTALLER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), BOXES_TYPE_WINDOWS_INSTALLER))
#define BOXES_IS_WINDOWS_INSTALLER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), BOXES_TYPE_WINDOWS_INSTALLER))
#define BOXES_WINDOWS_INSTALLER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), BOXES_TYPE_WINDOWS_INSTALLER, BoxesWindowsInstallerClass))

typedef struct _BoxesWindowsInstaller BoxesWindowsInstaller;
typedef struct _BoxesWindowsInstallerClass BoxesWindowsInstallerClass;
typedef struct _BoxesWindowsInstallerPrivate BoxesWindowsInstallerPrivate;

#define BOXES_TYPE_WIN_XP_INSTALLER (boxes_win_xp_installer_get_type ())
#define BOXES_WIN_XP_INSTALLER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), BOXES_TYPE_WIN_XP_INSTALLER, BoxesWinXPInstaller))
#define BOXES_WIN_XP_INSTALLER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), BOXES_TYPE_WIN_XP_INSTALLER, BoxesWinXPInstallerClass))
#define BOXES_IS_WIN_XP_INSTALLER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), BOXES_TYPE_WIN_XP_INSTALLER))
#define BOXES_IS_WIN_XP_INSTALLER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), BOXES_TYPE_WIN_XP_INSTALLER))
#define BOXES_WIN_XP_INSTALLER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), BOXES_TYPE_WIN_XP_INSTALLER, BoxesWinXPInstallerClass))

typedef struct _BoxesWinXPInstaller BoxesWinXPInstaller;
typedef struct _BoxesWinXPInstallerClass BoxesWinXPInstallerClass;
typedef struct _BoxesWinXPInstallerPrivate BoxesWinXPInstallerPrivate;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _avatar_format_unref0(var) ((var == NULL) ? NULL : (var = (avatar_format_unref (var), NULL)))

#define BOXES_TYPE_UNATTENDED_TEXT_FILE (boxes_unattended_text_file_get_type ())
#define BOXES_UNATTENDED_TEXT_FILE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), BOXES_TYPE_UNATTENDED_TEXT_FILE, BoxesUnattendedTextFile))
#define BOXES_UNATTENDED_TEXT_FILE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), BOXES_TYPE_UNATTENDED_TEXT_FILE, BoxesUnattendedTextFileClass))
#define BOXES_IS_UNATTENDED_TEXT_FILE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), BOXES_TYPE_UNATTENDED_TEXT_FILE))
#define BOXES_IS_UNATTENDED_TEXT_FILE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), BOXES_TYPE_UNATTENDED_TEXT_FILE))
#define BOXES_UNATTENDED_TEXT_FILE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), BOXES_TYPE_UNATTENDED_TEXT_FILE, BoxesUnattendedTextFileClass))

typedef struct _BoxesUnattendedTextFile BoxesUnattendedTextFile;
typedef struct _BoxesUnattendedTextFileClass BoxesUnattendedTextFileClass;
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

struct _BoxesInstallerMedia {
	GObject parent_instance;
	BoxesInstallerMediaPrivate * priv;
	OsinfoOs* os;
	OsinfoResources* resources;
	OsinfoMedia* os_media;
	gchar* label;
	gchar* device_file;
	gchar* mount_point;
	gboolean from_image;
};

struct _BoxesInstallerMediaClass {
	GObjectClass parent_class;
	void (*set_direct_boot_params) (BoxesInstallerMedia* self, GVirConfigDomainOs* os);
	void (*prepare_for_installation) (BoxesInstallerMedia* self, const gchar* vm_name, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*prepare_for_installation_finish) (BoxesInstallerMedia* self, GAsyncResult* _res_, GError** error);
	void (*setup_domain_config) (BoxesInstallerMedia* self, GVirConfigDomain* domain);
	void (*populate_setup_vbox) (BoxesInstallerMedia* self, GtkVBox* setup_vbox);
	GList* (*get_vm_properties) (BoxesInstallerMedia* self);
	guint64 (*get_installed_size) (BoxesInstallerMedia* self);
	gboolean (*get_need_user_input_for_vm_creation) (BoxesInstallerMedia* self);
	gboolean (*get_user_data_for_vm_creation_available) (BoxesInstallerMedia* self);
};

struct _BoxesUnattendedFileIface {
	GTypeInterface parent_iface;
	void (*create) (BoxesUnattendedFile* self, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
	GFile* (*create_finish) (BoxesUnattendedFile* self, GAsyncResult* _res_, GError** error);
	const gchar* (*get_src_path) (BoxesUnattendedFile* self);
	void (*set_src_path) (BoxesUnattendedFile* self, const gchar* value);
	const gchar* (*get_dest_name) (BoxesUnattendedFile* self);
	void (*set_dest_name) (BoxesUnattendedFile* self, const gchar* value);
	BoxesUnattendedInstaller* (*get_installer) (BoxesUnattendedFile* self);
	void (*set_installer) (BoxesUnattendedFile* self, BoxesUnattendedInstaller* value);
};

struct _BoxesUnattendedInstaller {
	BoxesInstallerMedia parent_instance;
	BoxesUnattendedInstallerPrivate * priv;
	GDataStreamNewlineType newline_type;
	GFile* disk_file;
	GList* unattended_files;
	GtkTable* setup_table;
	GtkLabel* setup_label;
	GtkHBox* setup_hbox;
	GtkSwitch* express_toggle;
	GtkEntry* username_entry;
	GtkEntry* password_entry;
	gchar* timezone;
	gchar* lang;
	gchar* hostname;
	AvatarFormat* avatar_format;
};

struct _BoxesUnattendedInstallerClass {
	BoxesInstallerMediaClass parent_class;
	gchar* (*fill_unattended_data) (BoxesUnattendedInstaller* self, const gchar* data, GError** error);
	void (*setup_ui) (BoxesUnattendedInstaller* self);
	void (*clean_up) (BoxesUnattendedInstaller* self, GError** error);
	void (*prepare_direct_boot) (BoxesUnattendedInstaller* self, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*prepare_direct_boot_finish) (BoxesUnattendedInstaller* self, GAsyncResult* _res_, GError** error);
	GVirConfigDomainDisk* (*get_unattended_disk_config) (BoxesUnattendedInstaller* self);
};

struct _BoxesWindowsInstaller {
	BoxesUnattendedInstaller parent_instance;
	BoxesWindowsInstallerPrivate * priv;
};

struct _BoxesWindowsInstallerClass {
	BoxesUnattendedInstallerClass parent_class;
};

struct _BoxesWinXPInstaller {
	BoxesWindowsInstaller parent_instance;
	BoxesWinXPInstallerPrivate * priv;
};

struct _BoxesWinXPInstallerClass {
	BoxesWindowsInstallerClass parent_class;
};

struct _BoxesWinXPInstallerPrivate {
	GtkEntry* key_entry;
	gulong key_inserted_id;
};


static gpointer boxes_win_xp_installer_parent_class = NULL;
static GRegex* boxes_win_xp_installer_key_regex;
static GRegex* boxes_win_xp_installer_key_regex = NULL;
static GRegex* boxes_win_xp_installer_admin_pass_regex;
static GRegex* boxes_win_xp_installer_admin_pass_regex = NULL;

GType boxes_installer_media_get_type (void) G_GNUC_CONST;
GType boxes_unattended_installer_get_type (void) G_GNUC_CONST;
GType boxes_unattended_file_get_type (void) G_GNUC_CONST;
gpointer avatar_format_ref (gpointer instance);
void avatar_format_unref (gpointer instance);
GParamSpec* param_spec_avatar_format (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_avatar_format (GValue* value, gpointer v_object);
void value_take_avatar_format (GValue* value, gpointer v_object);
gpointer value_get_avatar_format (const GValue* value);
GType avatar_format_get_type (void) G_GNUC_CONST;
GType boxes_windows_installer_get_type (void) G_GNUC_CONST;
GType boxes_win_xp_installer_get_type (void) G_GNUC_CONST;
#define BOXES_WIN_XP_INSTALLER_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), BOXES_TYPE_WIN_XP_INSTALLER, BoxesWinXPInstallerPrivate))
enum  {
	BOXES_WIN_XP_INSTALLER_DUMMY_PROPERTY,
	BOXES_WIN_XP_INSTALLER_USER_DATA_FOR_VM_CREATION_AVAILABLE,
	BOXES_WIN_XP_INSTALLER_INSTALLED_SIZE
};
BoxesWinXPInstaller* boxes_win_xp_installer_new_from_media (BoxesInstallerMedia* media, GError** error);
BoxesWinXPInstaller* boxes_win_xp_installer_construct_from_media (GType object_type, BoxesInstallerMedia* media, GError** error);
AvatarFormat* avatar_format_new (const gchar* type, const gchar* extension, gboolean alpha, gint width, gint height);
AvatarFormat* avatar_format_construct (GType object_type, const gchar* type, const gchar* extension, gboolean alpha, gint width, gint height);
BoxesUnattendedInstaller* boxes_unattended_installer_construct_from_media (GType object_type, BoxesInstallerMedia* media, const gchar* unattended_src_path, const gchar* unattended_dest_name, AvatarFormat* avatar_format, GError** error);
void boxes_unattended_installer_add_unattended_file (BoxesUnattendedInstaller* self, BoxesUnattendedFile* file);
BoxesUnattendedTextFile* boxes_unattended_text_file_new (BoxesUnattendedInstaller* installer, const gchar* src_path, const gchar* dest_name);
BoxesUnattendedTextFile* boxes_unattended_text_file_construct (GType object_type, BoxesUnattendedInstaller* installer, const gchar* src_path, const gchar* dest_name);
GType boxes_unattended_text_file_get_type (void) G_GNUC_CONST;
static void boxes_win_xp_installer_real_setup_ui (BoxesUnattendedInstaller* base);
void boxes_unattended_installer_setup_ui (BoxesUnattendedInstaller* self);
GtkEntry* boxes_unattended_installer_create_input_entry (BoxesUnattendedInstaller* self, const gchar* text, gboolean mandatory, gboolean visibility);
static void boxes_win_xp_installer_on_key_text_inserted (BoxesWinXPInstaller* self, const gchar* text, gint text_length, gint* position);
static void _boxes_win_xp_installer_on_key_text_inserted_gtk_editable_insert_text (GtkEditable* _sender, const gchar* new_text, gint new_text_length, gint* position, gpointer self);
static gchar* boxes_win_xp_installer_real_fill_unattended_data (BoxesUnattendedInstaller* base, const gchar* data, GError** error);
gchar* boxes_unattended_installer_fill_unattended_data (BoxesUnattendedInstaller* self, const gchar* data, GError** error);
gchar* boxes_unattended_installer_get_password (BoxesUnattendedInstaller* self);
static gboolean _vala_uint_array_contains (guint* stack, int stack_length, guint needle);
BoxesWinXPInstaller* boxes_win_xp_installer_new (void);
BoxesWinXPInstaller* boxes_win_xp_installer_construct (GType object_type);
BoxesWindowsInstaller* boxes_windows_installer_construct (GType object_type);
gboolean boxes_installer_media_get_user_data_for_vm_creation_available (BoxesInstallerMedia* self);
gboolean boxes_unattended_installer_get_express_install (BoxesUnattendedInstaller* self);
static void boxes_win_xp_installer_finalize (GObject* obj);
guint64 boxes_installer_media_get_installed_size (BoxesInstallerMedia* self);
static void _vala_boxes_win_xp_installer_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);

static const guint BOXES_WIN_XP_INSTALLER_allowed_dash_positions[4] = {(guint) 5, (guint) 11, (guint) 17, (guint) 23};

BoxesWinXPInstaller* boxes_win_xp_installer_construct_from_media (GType object_type, BoxesInstallerMedia* media, GError** error) {
	BoxesWinXPInstaller * self = NULL;
	BoxesInstallerMedia* _tmp0_;
	OsinfoOs* _tmp1_;
	const gchar* _tmp2_;
	const gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_ = NULL;
	gchar* _tmp7_;
	gchar* unattended_source;
	AvatarFormat* _tmp8_;
	AvatarFormat* avatar_format;
	BoxesInstallerMedia* _tmp9_;
	const gchar* _tmp10_;
	BoxesInstallerMedia* _tmp11_;
	OsinfoOs* _tmp12_;
	const gchar* _tmp13_;
	const gchar* _tmp14_;
	gchar* _tmp15_;
	gchar* name;
	const gchar* _tmp16_;
	gchar* _tmp17_ = NULL;
	const gchar* _tmp18_;
	const gchar* _tmp19_;
	BoxesUnattendedTextFile* _tmp20_;
	BoxesUnattendedTextFile* _tmp21_;
	BoxesInstallerMedia* _tmp22_;
	OsinfoOs* _tmp23_;
	const gchar* _tmp24_;
	const gchar* _tmp25_;
	gchar* _tmp26_;
	const gchar* _tmp27_;
	gchar* _tmp28_ = NULL;
	const gchar* _tmp29_;
	const gchar* _tmp30_;
	BoxesUnattendedTextFile* _tmp31_;
	BoxesUnattendedTextFile* _tmp32_;
	GError * _inner_error_ = NULL;
#line 36 "/extra-data/checkout/gnome/gnome-boxes/src/winxp-installer.vala"
	g_return_val_if_fail (media != NULL, NULL);
#line 37 "/extra-data/checkout/gnome/gnome-boxes/src/winxp-installer.vala"
	_tmp0_ = media;
#line 37 "/extra-data/checkout/gnome/gnome-boxes/src/winxp-installer.vala"
	_tmp1_ = _tmp0_->os;
#line 37 "/extra-data/checkout/gnome/gnome-boxes/src/winxp-installer.vala"
	_tmp2_ = osinfo_product_get_short_id ((OsinfoProduct*) _tmp1_);
#line 37 "/extra-data/checkout/gnome/gnome-boxes/src/winxp-installer.vala"
	_tmp3_ = _tmp2_;
#line 37 "/extra-data/checkout/gnome/gnome-boxes/src/winxp-installer.vala"
	_tmp4_ = g_strconcat (_tmp3_, ".sif", NULL);
#line 37 "/extra-data/checkout/gnome/gnome-boxes/src/winxp-installer.vala"
	_tmp5_ = _tmp4_;
#line 37 "/extra-data/checkout/gnome/gnome-boxes/src/winxp-installer.vala"
	_tmp6_ = boxes_get_unattended (_tmp5_);
#line 37 "/extra-data/checkout/gnome/gnome-boxes/src/winxp-installer.vala"
	_tmp7_ = _tmp6_;
#line 37 "/extra-data/checkout/gnome/gnome-boxes/src/winxp-installer.vala"
	_g_free0 (_tmp5_);
#line 37 "/extra-data/checkout/gnome/gnome-boxes/src/winxp-installer.vala"
	unattended_source = _tmp7_;
#line 38 "/extra-data/checkout/gnome/gnome-boxes/src/winxp-installer.vala"
	_tmp8_ = avatar_format_new ("bmp", ".bmp", FALSE, 48, 48);
#line 38 "/extra-data/checkout/gnome/gnome-boxes/src/winxp-installer.vala"
	avatar_format = _tmp8_;
#line 39 "/extra-data/checkout/gnome/gnome-boxes/src/winxp-installer.vala"
	_tmp9_ = media;
#line 39 "/extra-data/checkout/gnome/gnome-boxes/src/winxp-installer.vala"
	_tmp10_ = unattended_source;
#line 39 "/extra-data/checkout/gnome/gnome-boxes/src/winxp-installer.vala"
	self = (BoxesWinXPInstaller*) boxes_unattended_installer_construct_from_media (object_type, _tmp9_, _tmp10_, "Winnt.sif", avatar_format, &_inner_error_);
#line 39 "/extra-data/checkout/gnome/gnome-boxes/src/winxp-installer.vala"
	if (_inner_error_ != NULL) {
#line 39 "/extra-data/checkout/gnome/gnome-boxes/src/winxp-installer.vala"
		g_propagate_error (error, _inner_error_);
#line 39 "/extra-data/checkout/gnome/gnome-boxes/src/winxp-installer.vala"
		_avatar_format_unref0 (avatar_format);
#line 39 "/extra-data/checkout/gnome/gnome-boxes/src/winxp-installer.vala"
		_g_free0 (unattended_source);
#line 39 "/extra-data/checkout/gnome/gnome-boxes/src/winxp-installer.vala"
		_g_object_unref0 (self);
#line 39 "/extra-data/checkout/gnome/gnome-boxes/src/winxp-installer.vala"
		return NULL;
#line 322 "winxp-installer.c"
	}
#line 41 "/extra-data/checkout/gnome/gnome-boxes/src/winxp-installer.vala"
	_tmp11_ = media;
#line 41 "/extra-data/checkout/gnome/gnome-boxes/src/winxp-installer.vala"
	_tmp12_ = _tmp11_->os;
#line 41 "/extra-data/checkout/gnome/gnome-boxes/src/winxp-installer.vala"
	_tmp13_ = osinfo_product_get_short_id ((OsinfoProduct*) _tmp12_);
#line 41 "/extra-data/checkout/gnome/gnome-boxes/src/winxp-installer.vala"
	_tmp14_ = _tmp13_;
#line 41 "/extra-data/checkout/gnome/gnome-boxes/src/winxp-installer.vala"
	_tmp15_ = g_strconcat (_tmp14_, ".cmd", NULL);
#line 41 "/extra-data/checkout/gnome/gnome-boxes/src/winxp-installer.vala"
	name = _tmp15_;
#line 42 "/extra-data/checkout/gnome/gnome-boxes/src/winxp-installer.vala"
	_tmp16_ = name;
#line 42 "/extra-data/checkout/gnome/gnome-boxes/src/winxp-installer.vala"
	_tmp17_ = boxes_get_unattended (_tmp16_);
#line 42 "/extra-data/checkout/gnome/gnome-boxes/src/winxp-installer.vala"
	_g_free0 (unattended_source);
#line 42 "/extra-data/checkout/gnome/gnome-boxes/src/winxp-installer.vala"
	unattended_source = _tmp17_;
#line 43 "/extra-data/checkout/gnome/gnome-boxes/src/winxp-installer.vala"
	_tmp18_ = unattended_source;
#line 43 "/extra-data/checkout/gnome/gnome-boxes/src/winxp-installer.vala"
	_tmp19_ = name;
#line 43 "/extra-data/checkout/gnome/gnome-boxes/src/winxp-installer.vala"
	_tmp20_ = boxes_unattended_text_file_new ((BoxesUnattendedInstaller*) self, _tmp18_, _tmp19_);
#line 43 "/extra-data/checkout/gnome/gnome-boxes/src/winxp-installer.vala"
	_tmp21_ = _tmp20_;
#line 43 "/extra-data/checkout/gnome/gnome-boxes/src/winxp-installer.vala"
	boxes_unattended_installer_add_unattended_file ((BoxesUnattendedInstaller*) self, (BoxesUnattendedFile*) _tmp21_);
#line 43 "/extra-data/checkout/gnome/gnome-boxes/src/winxp-installer.vala"
	_g_object_unref0 (_tmp21_);
#line 45 "/extra-data/checkout/gnome/gnome-boxes/src/winxp-installer.vala"
	_tmp22_ = media;
#line 45 "/extra-data/checkout/gnome/gnome-boxes/src/winxp-installer.vala"
	_tmp23_ = _tmp22_->os;
#line 45 "/extra-data/checkout/gnome/gnome-boxes/src/winxp-installer.vala"
	_tmp24_ = osinfo_product_get_short_id ((OsinfoProduct*) _tmp23_);
#line 45 "/extra-data/checkout/gnome/gnome-boxes/src/winxp-installer.vala"
	_tmp25_ = _tmp24_;
#line 45 "/extra-data/checkout/gnome/gnome-boxes/src/winxp-installer.vala"
	_tmp26_ = g_strconcat (_tmp25_, ".reg", NULL);
#line 45 "/extra-data/checkout/gnome/gnome-boxes/src/winxp-installer.vala"
	_g_free0 (name);
#line 45 "/extra-data/checkout/gnome/gnome-boxes/src/winxp-installer.vala"
	name = _tmp26_;
#line 46 "/extra-data/checkout/gnome/gnome-boxes/src/winxp-installer.vala"
	_tmp27_ = name;
#line 46 "/extra-data/checkout/gnome/gnome-boxes/src/winxp-installer.vala"
	_tmp28_ = boxes_get_unattended (_tmp27_);
#line 46 "/extra-data/checkout/gnome/gnome-boxes/src/winxp-installer.vala"
	_g_free0 (unattended_source);
#line 46 "/extra-data/checkout/gnome/gnome-boxes/src/winxp-installer.vala"
	unattended_source = _tmp28_;
#line 47 "/extra-data/checkout/gnome/gnome-boxes/src/winxp-installer.vala"
	_tmp29_ = unattended_source;
#line 47 "/extra-data/checkout/gnome/gnome-boxes/src/winxp-installer.vala"
	_tmp30_ = name;
#line 47 "/extra-data/checkout/gnome/gnome-boxes/src/winxp-installer.vala"
	_tmp31_ = boxes_unattended_text_file_new ((BoxesUnattendedInstaller*) self, _tmp29_, _tmp30_);
#line 47 "/extra-data/checkout/gnome/gnome-boxes/src/winxp-installer.vala"
	_tmp32_ = _tmp31_;
#line 47 "/extra-data/checkout/gnome/gnome-boxes/src/winxp-installer.vala"
	boxes_unattended_installer_add_unattended_file ((BoxesUnattendedInstaller*) self, (BoxesUnattendedFile*) _tmp32_);
#line 47 "/extra-data/checkout/gnome/gnome-boxes/src/winxp-installer.vala"
	_g_object_unref0 (_tmp32_);
#line 48 "/extra-data/checkout/gnome/gnome-boxes/src/winxp-installer.vala"
	((BoxesUnattendedInstaller*) self)->newline_type = G_DATA_STREAM_NEWLINE_TYPE_CR_LF;
#line 36 "/extra-data/checkout/gnome/gnome-boxes/src/winxp-installer.vala"
	_g_free0 (name);
#line 36 "/extra-data/checkout/gnome/gnome-boxes/src/winxp-installer.vala"
	_avatar_format_unref0 (avatar_format);
#line 36 "/extra-data/checkout/gnome/gnome-boxes/src/winxp-installer.vala"
	_g_free0 (unattended_source);
#line 36 "/extra-data/checkout/gnome/gnome-boxes/src/winxp-installer.vala"
	return self;
#line 400 "winxp-installer.c"
}


BoxesWinXPInstaller* boxes_win_xp_installer_new_from_media (BoxesInstallerMedia* media, GError** error) {
#line 36 "/extra-data/checkout/gnome/gnome-boxes/src/winxp-installer.vala"
	return boxes_win_xp_installer_construct_from_media (BOXES_TYPE_WIN_XP_INSTALLER, media, error);
#line 407 "winxp-installer.c"
}


static void _boxes_win_xp_installer_on_key_text_inserted_gtk_editable_insert_text (GtkEditable* _sender, const gchar* new_text, gint new_text_length, gint* position, gpointer self) {
#line 73 "/extra-data/checkout/gnome/gnome-boxes/src/winxp-installer.vala"
	boxes_win_xp_installer_on_key_text_inserted (self, new_text, new_text_length, position);
#line 414 "winxp-installer.c"
}


static void boxes_win_xp_installer_real_setup_ui (BoxesUnattendedInstaller* base) {
	BoxesWinXPInstaller * self;
	GtkTable* _tmp0_;
	GtkTable* _tmp1_;
	guint _tmp2_ = 0U;
	guint _tmp3_;
	GtkTable* _tmp4_;
	guint _tmp5_ = 0U;
	guint _tmp6_;
	GtkHBox* _tmp7_;
	GtkHBox* hbox;
	const gchar* _tmp8_ = NULL;
	GtkLabel* _tmp9_;
	GtkLabel* label;
	GtkEntry* _tmp10_ = NULL;
	GtkEntry* _tmp11_;
	GtkEntry* _tmp12_;
	GtkEntry* _tmp13_;
	GtkStyleContext* _tmp14_ = NULL;
	GtkEntry* _tmp15_;
	GtkTable* _tmp16_;
	GtkTable* _tmp17_;
	guint _tmp18_ = 0U;
	guint _tmp19_;
	GtkTable* _tmp20_;
	guint _tmp21_ = 0U;
	guint _tmp22_;
	GtkTable* _tmp23_;
	guint _tmp24_ = 0U;
	guint _tmp25_;
	GtkSwitch* _tmp26_;
	GtkEntry* _tmp27_;
	gulong _tmp28_ = 0UL;
#line 51 "/extra-data/checkout/gnome/gnome-boxes/src/winxp-installer.vala"
	self = (BoxesWinXPInstaller*) base;
#line 52 "/extra-data/checkout/gnome/gnome-boxes/src/winxp-installer.vala"
	BOXES_UNATTENDED_INSTALLER_CLASS (boxes_win_xp_installer_parent_class)->setup_ui ((BoxesUnattendedInstaller*) G_TYPE_CHECK_INSTANCE_CAST (self, BOXES_TYPE_WINDOWS_INSTALLER, BoxesWindowsInstaller));
#line 54 "/extra-data/checkout/gnome/gnome-boxes/src/winxp-installer.vala"
	_tmp0_ = ((BoxesUnattendedInstaller*) self)->setup_table;
#line 54 "/extra-data/checkout/gnome/gnome-boxes/src/winxp-installer.vala"
	_tmp1_ = ((BoxesUnattendedInstaller*) self)->setup_table;
#line 54 "/extra-data/checkout/gnome/gnome-boxes/src/winxp-installer.vala"
	g_object_get (_tmp1_, "n-rows", &_tmp2_, NULL);
#line 54 "/extra-data/checkout/gnome/gnome-boxes/src/winxp-installer.vala"
	_tmp3_ = _tmp2_;
#line 54 "/extra-data/checkout/gnome/gnome-boxes/src/winxp-installer.vala"
	_tmp4_ = ((BoxesUnattendedInstaller*) self)->setup_table;
#line 54 "/extra-data/checkout/gnome/gnome-boxes/src/winxp-installer.vala"
	g_object_get (_tmp4_, "n-columns", &_tmp5_, NULL);
#line 54 "/extra-data/checkout/gnome/gnome-boxes/src/winxp-installer.vala"
	_tmp6_ = _tmp5_;
#line 54 "/extra-data/checkout/gnome/gnome-boxes/src/winxp-installer.vala"
	gtk_table_resize (_tmp0_, _tmp3_ + 1, _tmp6_);
#line 56 "/extra-data/checkout/gnome/gnome-boxes/src/winxp-installer.vala"
	_tmp7_ = (GtkHBox*) gtk_hbox_new (FALSE, 10);
#line 56 "/extra-data/checkout/gnome/gnome-boxes/src/winxp-installer.vala"
	g_object_ref_sink (_tmp7_);
#line 56 "/extra-data/checkout/gnome/gnome-boxes/src/winxp-installer.vala"
	hbox = _tmp7_;
#line 57 "/extra-data/checkout/gnome/gnome-boxes/src/winxp-installer.vala"
	gtk_widget_set_margin_top ((GtkWidget*) hbox, 12);
#line 60 "/extra-data/checkout/gnome/gnome-boxes/src/winxp-installer.vala"
	_tmp8_ = _ ("Product Key");
#line 60 "/extra-data/checkout/gnome/gnome-boxes/src/winxp-installer.vala"
	_tmp9_ = (GtkLabel*) gtk_label_new (_tmp8_);
#line 60 "/extra-data/checkout/gnome/gnome-boxes/src/winxp-installer.vala"
	g_object_ref_sink (_tmp9_);
#line 60 "/extra-data/checkout/gnome/gnome-boxes/src/winxp-installer.vala"
	label = _tmp9_;
#line 61 "/extra-data/checkout/gnome/gnome-boxes/src/winxp-installer.vala"
	gtk_widget_set_halign ((GtkWidget*) label, GTK_ALIGN_START);
#line 62 "/extra-data/checkout/gnome/gnome-boxes/src/winxp-installer.vala"
	gtk_box_pack_start ((GtkBox*) hbox, (GtkWidget*) label, TRUE, TRUE, (guint) 0);
#line 64 "/extra-data/checkout/gnome/gnome-boxes/src/winxp-installer.vala"
	_tmp10_ = boxes_unattended_installer_create_input_entry ((BoxesUnattendedInstaller*) self, "", TRUE, TRUE);
#line 64 "/extra-data/checkout/gnome/gnome-boxes/src/winxp-installer.vala"
	_g_object_unref0 (self->priv->key_entry);
#line 64 "/extra-data/checkout/gnome/gnome-boxes/src/winxp-installer.vala"
	self->priv->key_entry = _tmp10_;
#line 65 "/extra-data/checkout/gnome/gnome-boxes/src/winxp-installer.vala"
	_tmp11_ = self->priv->key_entry;
#line 65 "/extra-data/checkout/gnome/gnome-boxes/src/winxp-installer.vala"
	gtk_entry_set_width_chars (_tmp11_, 29);
#line 66 "/extra-data/checkout/gnome/gnome-boxes/src/winxp-installer.vala"
	_tmp12_ = self->priv->key_entry;
#line 66 "/extra-data/checkout/gnome/gnome-boxes/src/winxp-installer.vala"
	gtk_entry_set_max_length (_tmp12_, 29);
#line 67 "/extra-data/checkout/gnome/gnome-boxes/src/winxp-installer.vala"
	_tmp13_ = self->priv->key_entry;
#line 67 "/extra-data/checkout/gnome/gnome-boxes/src/winxp-installer.vala"
	_tmp14_ = gtk_widget_get_style_context ((GtkWidget*) _tmp13_);
#line 67 "/extra-data/checkout/gnome/gnome-boxes/src/winxp-installer.vala"
	gtk_style_context_add_class (_tmp14_, "boxes-product-key-entry");
#line 68 "/extra-data/checkout/gnome/gnome-boxes/src/winxp-installer.vala"
	_tmp15_ = self->priv->key_entry;
#line 68 "/extra-data/checkout/gnome/gnome-boxes/src/winxp-installer.vala"
	gtk_box_pack_start ((GtkBox*) hbox, (GtkWidget*) _tmp15_, TRUE, TRUE, (guint) 0);
#line 69 "/extra-data/checkout/gnome/gnome-boxes/src/winxp-installer.vala"
	_tmp16_ = ((BoxesUnattendedInstaller*) self)->setup_table;
#line 69 "/extra-data/checkout/gnome/gnome-boxes/src/winxp-installer.vala"
	_tmp17_ = ((BoxesUnattendedInstaller*) self)->setup_table;
#line 69 "/extra-data/checkout/gnome/gnome-boxes/src/winxp-installer.vala"
	g_object_get (_tmp17_, "n-columns", &_tmp18_, NULL);
#line 69 "/extra-data/checkout/gnome/gnome-boxes/src/winxp-installer.vala"
	_tmp19_ = _tmp18_;
#line 69 "/extra-data/checkout/gnome/gnome-boxes/src/winxp-installer.vala"
	_tmp20_ = ((BoxesUnattendedInstaller*) self)->setup_table;
#line 69 "/extra-data/checkout/gnome/gnome-boxes/src/winxp-installer.vala"
	g_object_get (_tmp20_, "n-rows", &_tmp21_, NULL);
#line 69 "/extra-data/checkout/gnome/gnome-boxes/src/winxp-installer.vala"
	_tmp22_ = _tmp21_;
#line 69 "/extra-data/checkout/gnome/gnome-boxes/src/winxp-installer.vala"
	_tmp23_ = ((BoxesUnattendedInstaller*) self)->setup_table;
#line 69 "/extra-data/checkout/gnome/gnome-boxes/src/winxp-installer.vala"
	g_object_get (_tmp23_, "n-rows", &_tmp24_, NULL);
#line 69 "/extra-data/checkout/gnome/gnome-boxes/src/winxp-installer.vala"
	_tmp25_ = _tmp24_;
#line 69 "/extra-data/checkout/gnome/gnome-boxes/src/winxp-installer.vala"
	gtk_table_attach_defaults (_tmp16_, (GtkWidget*) hbox, (guint) 0, _tmp19_, _tmp22_ - 1, _tmp25_);
#line 71 "/extra-data/checkout/gnome/gnome-boxes/src/winxp-installer.vala"
	_tmp26_ = ((BoxesUnattendedInstaller*) self)->express_toggle;
#line 71 "/extra-data/checkout/gnome/gnome-boxes/src/winxp-installer.vala"
	g_object_bind_property_with_closures ((GObject*) _tmp26_, "active", (GObject*) hbox, "sensitive", 0, (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, NULL)), (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, NULL)));
#line 73 "/extra-data/checkout/gnome/gnome-boxes/src/winxp-installer.vala"
	_tmp27_ = self->priv->key_entry;
#line 73 "/extra-data/checkout/gnome/gnome-boxes/src/winxp-installer.vala"
	_tmp28_ = g_signal_connect_object ((GtkEditable*) _tmp27_, "insert-text", (GCallback) _boxes_win_xp_installer_on_key_text_inserted_gtk_editable_insert_text, self, 0);
#line 73 "/extra-data/checkout/gnome/gnome-boxes/src/winxp-installer.vala"
	self->priv->key_inserted_id = _tmp28_;
#line 51 "/extra-data/checkout/gnome/gnome-boxes/src/winxp-installer.vala"
	_g_object_unref0 (label);
#line 51 "/extra-data/checkout/gnome/gnome-boxes/src/winxp-installer.vala"
	_g_object_unref0 (hbox);
#line 551 "winxp-installer.c"
}


static gchar* boxes_win_xp_installer_real_fill_unattended_data (BoxesUnattendedInstaller* base, const gchar* data, GError** error) {
	BoxesWinXPInstaller * self;
	gchar* result = NULL;
	const gchar* _tmp0_;
	gchar* _tmp1_ = NULL;
	gchar* str;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gboolean _tmp6_;
	const gchar* _tmp10_;
	gchar* _tmp11_;
	gchar* admin_pass;
	GRegex* _tmp12_;
	const gchar* _tmp13_;
	const gchar* _tmp14_;
	gint _tmp15_;
	gint _tmp16_;
	const gchar* _tmp17_;
	gchar* _tmp18_ = NULL;
	gchar* _tmp19_;
	GRegex* _tmp20_;
	const gchar* _tmp21_;
	const gchar* _tmp22_;
	gint _tmp23_;
	gint _tmp24_;
	GtkEntry* _tmp25_;
	const gchar* _tmp26_;
	const gchar* _tmp27_;
	gchar* _tmp28_ = NULL;
	gchar* _tmp29_;
	GError * _inner_error_ = NULL;
#line 76 "/extra-data/checkout/gnome/gnome-boxes/src/winxp-installer.vala"
	self = (BoxesWinXPInstaller*) base;
#line 76 "/extra-data/checkout/gnome/gnome-boxes/src/winxp-installer.vala"
	g_return_val_if_fail (data != NULL, NULL);
#line 77 "/extra-data/checkout/gnome/gnome-boxes/src/winxp-installer.vala"
	_tmp0_ = data;
#line 77 "/extra-data/checkout/gnome/gnome-boxes/src/winxp-installer.vala"
	_tmp1_ = BOXES_UNATTENDED_INSTALLER_CLASS (boxes_win_xp_installer_parent_class)->fill_unattended_data ((BoxesUnattendedInstaller*) G_TYPE_CHECK_INSTANCE_CAST (self, BOXES_TYPE_WINDOWS_INSTALLER, BoxesWindowsInstaller), _tmp0_, &_inner_error_);
#line 77 "/extra-data/checkout/gnome/gnome-boxes/src/winxp-installer.vala"
	str = _tmp1_;
#line 77 "/extra-data/checkout/gnome/gnome-boxes/src/winxp-installer.vala"
	if (_inner_error_ != NULL) {
#line 77 "/extra-data/checkout/gnome/gnome-boxes/src/winxp-installer.vala"
		if (_inner_error_->domain == G_REGEX_ERROR) {
#line 77 "/extra-data/checkout/gnome/gnome-boxes/src/winxp-installer.vala"
			g_propagate_error (error, _inner_error_);
#line 77 "/extra-data/checkout/gnome/gnome-boxes/src/winxp-installer.vala"
			return NULL;
#line 606 "winxp-installer.c"
		} else {
#line 77 "/extra-data/checkout/gnome/gnome-boxes/src/winxp-installer.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 77 "/extra-data/checkout/gnome/gnome-boxes/src/winxp-installer.vala"
			g_clear_error (&_inner_error_);
#line 77 "/extra-data/checkout/gnome/gnome-boxes/src/winxp-installer.vala"
			return NULL;
#line 614 "winxp-installer.c"
		}
	}
#line 78 "/extra-data/checkout/gnome/gnome-boxes/src/winxp-installer.vala"
	_tmp3_ = boxes_unattended_installer_get_password ((BoxesUnattendedInstaller*) self);
#line 78 "/extra-data/checkout/gnome/gnome-boxes/src/winxp-installer.vala"
	_tmp4_ = _tmp3_;
#line 78 "/extra-data/checkout/gnome/gnome-boxes/src/winxp-installer.vala"
	_tmp5_ = _tmp4_;
#line 78 "/extra-data/checkout/gnome/gnome-boxes/src/winxp-installer.vala"
	_tmp6_ = g_strcmp0 (_tmp5_, "") != 0;
#line 78 "/extra-data/checkout/gnome/gnome-boxes/src/winxp-installer.vala"
	_g_free0 (_tmp5_);
#line 78 "/extra-data/checkout/gnome/gnome-boxes/src/winxp-installer.vala"
	if (_tmp6_) {
#line 629 "winxp-installer.c"
		gchar* _tmp7_;
		gchar* _tmp8_;
#line 78 "/extra-data/checkout/gnome/gnome-boxes/src/winxp-installer.vala"
		_tmp7_ = boxes_unattended_installer_get_password ((BoxesUnattendedInstaller*) self);
#line 78 "/extra-data/checkout/gnome/gnome-boxes/src/winxp-installer.vala"
		_tmp8_ = _tmp7_;
#line 78 "/extra-data/checkout/gnome/gnome-boxes/src/winxp-installer.vala"
		_g_free0 (_tmp2_);
#line 78 "/extra-data/checkout/gnome/gnome-boxes/src/winxp-installer.vala"
		_tmp2_ = _tmp8_;
#line 640 "winxp-installer.c"
	} else {
		gchar* _tmp9_;
#line 78 "/extra-data/checkout/gnome/gnome-boxes/src/winxp-installer.vala"
		_tmp9_ = g_strdup ("*");
#line 78 "/extra-data/checkout/gnome/gnome-boxes/src/winxp-installer.vala"
		_g_free0 (_tmp2_);
#line 78 "/extra-data/checkout/gnome/gnome-boxes/src/winxp-installer.vala"
		_tmp2_ = _tmp9_;
#line 649 "winxp-installer.c"
	}
#line 78 "/extra-data/checkout/gnome/gnome-boxes/src/winxp-installer.vala"
	_tmp10_ = _tmp2_;
#line 78 "/extra-data/checkout/gnome/gnome-boxes/src/winxp-installer.vala"
	_tmp11_ = g_strdup (_tmp10_);
#line 78 "/extra-data/checkout/gnome/gnome-boxes/src/winxp-installer.vala"
	admin_pass = _tmp11_;
#line 79 "/extra-data/checkout/gnome/gnome-boxes/src/winxp-installer.vala"
	_tmp12_ = boxes_win_xp_installer_admin_pass_regex;
#line 79 "/extra-data/checkout/gnome/gnome-boxes/src/winxp-installer.vala"
	_tmp13_ = str;
#line 79 "/extra-data/checkout/gnome/gnome-boxes/src/winxp-installer.vala"
	_tmp14_ = str;
#line 79 "/extra-data/checkout/gnome/gnome-boxes/src/winxp-installer.vala"
	_tmp15_ = strlen (_tmp14_);
#line 79 "/extra-data/checkout/gnome/gnome-boxes/src/winxp-installer.vala"
	_tmp16_ = _tmp15_;
#line 79 "/extra-data/checkout/gnome/gnome-boxes/src/winxp-installer.vala"
	_tmp17_ = admin_pass;
#line 79 "/extra-data/checkout/gnome/gnome-boxes/src/winxp-installer.vala"
	_tmp18_ = g_regex_replace (_tmp12_, _tmp13_, (gssize) _tmp16_, 0, _tmp17_, 0, &_inner_error_);
#line 79 "/extra-data/checkout/gnome/gnome-boxes/src/winxp-installer.vala"
	_tmp19_ = _tmp18_;
#line 79 "/extra-data/checkout/gnome/gnome-boxes/src/winxp-installer.vala"
	if (_inner_error_ != NULL) {
#line 79 "/extra-data/checkout/gnome/gnome-boxes/src/winxp-installer.vala"
		if (_inner_error_->domain == G_REGEX_ERROR) {
#line 79 "/extra-data/checkout/gnome/gnome-boxes/src/winxp-installer.vala"
			g_propagate_error (error, _inner_error_);
#line 79 "/extra-data/checkout/gnome/gnome-boxes/src/winxp-installer.vala"
			_g_free0 (admin_pass);
#line 79 "/extra-data/checkout/gnome/gnome-boxes/src/winxp-installer.vala"
			_g_free0 (_tmp2_);
#line 79 "/extra-data/checkout/gnome/gnome-boxes/src/winxp-installer.vala"
			_g_free0 (str);
#line 79 "/extra-data/checkout/gnome/gnome-boxes/src/winxp-installer.vala"
			return NULL;
#line 687 "winxp-installer.c"
		} else {
#line 79 "/extra-data/checkout/gnome/gnome-boxes/src/winxp-installer.vala"
			_g_free0 (admin_pass);
#line 79 "/extra-data/checkout/gnome/gnome-boxes/src/winxp-installer.vala"
			_g_free0 (_tmp2_);
#line 79 "/extra-data/checkout/gnome/gnome-boxes/src/winxp-installer.vala"
			_g_free0 (str);
#line 79 "/extra-data/checkout/gnome/gnome-boxes/src/winxp-installer.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 79 "/extra-data/checkout/gnome/gnome-boxes/src/winxp-installer.vala"
			g_clear_error (&_inner_error_);
#line 79 "/extra-data/checkout/gnome/gnome-boxes/src/winxp-installer.vala"
			return NULL;
#line 701 "winxp-installer.c"
		}
	}
#line 79 "/extra-data/checkout/gnome/gnome-boxes/src/winxp-installer.vala"
	_g_free0 (str);
#line 79 "/extra-data/checkout/gnome/gnome-boxes/src/winxp-installer.vala"
	str = _tmp19_;
#line 81 "/extra-data/checkout/gnome/gnome-boxes/src/winxp-installer.vala"
	_tmp20_ = boxes_win_xp_installer_key_regex;
#line 81 "/extra-data/checkout/gnome/gnome-boxes/src/winxp-installer.vala"
	_tmp21_ = str;
#line 81 "/extra-data/checkout/gnome/gnome-boxes/src/winxp-installer.vala"
	_tmp22_ = str;
#line 81 "/extra-data/checkout/gnome/gnome-boxes/src/winxp-installer.vala"
	_tmp23_ = strlen (_tmp22_);
#line 81 "/extra-data/checkout/gnome/gnome-boxes/src/winxp-installer.vala"
	_tmp24_ = _tmp23_;
#line 81 "/extra-data/checkout/gnome/gnome-boxes/src/winxp-installer.vala"
	_tmp25_ = self->priv->key_entry;
#line 81 "/extra-data/checkout/gnome/gnome-boxes/src/winxp-installer.vala"
	_tmp26_ = gtk_entry_get_text (_tmp25_);
#line 81 "/extra-data/checkout/gnome/gnome-boxes/src/winxp-installer.vala"
	_tmp27_ = _tmp26_;
#line 81 "/extra-data/checkout/gnome/gnome-boxes/src/winxp-installer.vala"
	_tmp28_ = g_regex_replace (_tmp20_, _tmp21_, (gssize) _tmp24_, 0, _tmp27_, 0, &_inner_error_);
#line 81 "/extra-data/checkout/gnome/gnome-boxes/src/winxp-installer.vala"
	_tmp29_ = _tmp28_;
#line 81 "/extra-data/checkout/gnome/gnome-boxes/src/winxp-installer.vala"
	if (_inner_error_ != NULL) {
#line 81 "/extra-data/checkout/gnome/gnome-boxes/src/winxp-installer.vala"
		if (_inner_error_->domain == G_REGEX_ERROR) {
#line 81 "/extra-data/checkout/gnome/gnome-boxes/src/winxp-installer.vala"
			g_propagate_error (error, _inner_error_);
#line 81 "/extra-data/checkout/gnome/gnome-boxes/src/winxp-installer.vala"
			_g_free0 (admin_pass);
#line 81 "/extra-data/checkout/gnome/gnome-boxes/src/winxp-installer.vala"
			_g_free0 (_tmp2_);
#line 81 "/extra-data/checkout/gnome/gnome-boxes/src/winxp-installer.vala"
			_g_free0 (str);
#line 81 "/extra-data/checkout/gnome/gnome-boxes/src/winxp-installer.vala"
			return NULL;
#line 742 "winxp-installer.c"
		} else {
#line 81 "/extra-data/checkout/gnome/gnome-boxes/src/winxp-installer.vala"
			_g_free0 (admin_pass);
#line 81 "/extra-data/checkout/gnome/gnome-boxes/src/winxp-installer.vala"
			_g_free0 (_tmp2_);
#line 81 "/extra-data/checkout/gnome/gnome-boxes/src/winxp-installer.vala"
			_g_free0 (str);
#line 81 "/extra-data/checkout/gnome/gnome-boxes/src/winxp-installer.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 81 "/extra-data/checkout/gnome/gnome-boxes/src/winxp-installer.vala"
			g_clear_error (&_inner_error_);
#line 81 "/extra-data/checkout/gnome/gnome-boxes/src/winxp-installer.vala"
			return NULL;
#line 756 "winxp-installer.c"
		}
	}
#line 81 "/extra-data/checkout/gnome/gnome-boxes/src/winxp-installer.vala"
	result = _tmp29_;
#line 81 "/extra-data/checkout/gnome/gnome-boxes/src/winxp-installer.vala"
	_g_free0 (admin_pass);
#line 81 "/extra-data/checkout/gnome/gnome-boxes/src/winxp-installer.vala"
	_g_free0 (_tmp2_);
#line 81 "/extra-data/checkout/gnome/gnome-boxes/src/winxp-installer.vala"
	_g_free0 (str);
#line 81 "/extra-data/checkout/gnome/gnome-boxes/src/winxp-installer.vala"
	return result;
#line 769 "winxp-installer.c"
}


static guint8* string_get_data (const gchar* self, int* result_length1) {
	guint8* result;
	guint8* res;
	gint res_length1;
	gint _res_size_;
	gint _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	guint8* _tmp3_;
	gint _tmp3__length1;
	guint8* _tmp4_;
	gint _tmp4__length1;
#line 1246 "/home/zeenix/jhbuild/share/vala-0.18/vapi/glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, NULL);
#line 1247 "/home/zeenix/jhbuild/share/vala-0.18/vapi/glib-2.0.vapi"
	res = (guint8*) self;
#line 1247 "/home/zeenix/jhbuild/share/vala-0.18/vapi/glib-2.0.vapi"
	res_length1 = -1;
#line 1247 "/home/zeenix/jhbuild/share/vala-0.18/vapi/glib-2.0.vapi"
	_res_size_ = res_length1;
#line 1248 "/home/zeenix/jhbuild/share/vala-0.18/vapi/glib-2.0.vapi"
	_tmp0_ = strlen (self);
#line 1248 "/home/zeenix/jhbuild/share/vala-0.18/vapi/glib-2.0.vapi"
	_tmp1_ = _tmp0_;
#line 1248 "/home/zeenix/jhbuild/share/vala-0.18/vapi/glib-2.0.vapi"
	res_length1 = (gint) _tmp1_;
#line 1248 "/home/zeenix/jhbuild/share/vala-0.18/vapi/glib-2.0.vapi"
	_tmp2_ = res_length1;
#line 1249 "/home/zeenix/jhbuild/share/vala-0.18/vapi/glib-2.0.vapi"
	_tmp3_ = res;
#line 1249 "/home/zeenix/jhbuild/share/vala-0.18/vapi/glib-2.0.vapi"
	_tmp3__length1 = res_length1;
#line 1249 "/home/zeenix/jhbuild/share/vala-0.18/vapi/glib-2.0.vapi"
	_tmp4_ = _tmp3_;
#line 1249 "/home/zeenix/jhbuild/share/vala-0.18/vapi/glib-2.0.vapi"
	_tmp4__length1 = _tmp3__length1;
#line 1249 "/home/zeenix/jhbuild/share/vala-0.18/vapi/glib-2.0.vapi"
	if (result_length1) {
#line 1249 "/home/zeenix/jhbuild/share/vala-0.18/vapi/glib-2.0.vapi"
		*result_length1 = _tmp4__length1;
#line 813 "winxp-installer.c"
	}
#line 1249 "/home/zeenix/jhbuild/share/vala-0.18/vapi/glib-2.0.vapi"
	result = _tmp4_;
#line 1249 "/home/zeenix/jhbuild/share/vala-0.18/vapi/glib-2.0.vapi"
	return result;
#line 819 "winxp-installer.c"
}


static gboolean _vala_uint_array_contains (guint* stack, int stack_length, guint needle) {
	int i;
#line 95 "/extra-data/checkout/gnome/gnome-boxes/src/winxp-installer.vala"
	for (i = 0; i < stack_length; i++) {
#line 95 "/extra-data/checkout/gnome/gnome-boxes/src/winxp-installer.vala"
		if (needle == stack[i]) {
#line 95 "/extra-data/checkout/gnome/gnome-boxes/src/winxp-installer.vala"
			return TRUE;
#line 831 "winxp-installer.c"
		}
	}
#line 95 "/extra-data/checkout/gnome/gnome-boxes/src/winxp-installer.vala"
	return FALSE;
#line 836 "winxp-installer.c"
}


static void boxes_win_xp_installer_on_key_text_inserted (BoxesWinXPInstaller* self, const gchar* text, gint text_length, gint* position) {
	gchar* _tmp0_;
	gchar* _result_;
	guint i;
	const gchar* _tmp1_;
	guint8* _tmp2_;
	gint _tmp2__length1;
	guint8* _tmp3_;
	gint _tmp3__length1;
	const gchar* _tmp20_;
	GtkEntry* _tmp32_;
#line 84 "/extra-data/checkout/gnome/gnome-boxes/src/winxp-installer.vala"
	g_return_if_fail (self != NULL);
#line 84 "/extra-data/checkout/gnome/gnome-boxes/src/winxp-installer.vala"
	g_return_if_fail (text != NULL);
#line 85 "/extra-data/checkout/gnome/gnome-boxes/src/winxp-installer.vala"
	_tmp0_ = g_strdup ("");
#line 85 "/extra-data/checkout/gnome/gnome-boxes/src/winxp-installer.vala"
	_result_ = _tmp0_;
#line 87 "/extra-data/checkout/gnome/gnome-boxes/src/winxp-installer.vala"
	i = (guint) 0;
#line 88 "/extra-data/checkout/gnome/gnome-boxes/src/winxp-installer.vala"
	_tmp1_ = text;
#line 88 "/extra-data/checkout/gnome/gnome-boxes/src/winxp-installer.vala"
	_tmp2_ = string_get_data (_tmp1_, &_tmp2__length1);
#line 88 "/extra-data/checkout/gnome/gnome-boxes/src/winxp-installer.vala"
	_tmp3_ = _tmp2_;
#line 88 "/extra-data/checkout/gnome/gnome-boxes/src/winxp-installer.vala"
	_tmp3__length1 = _tmp2__length1;
#line 869 "winxp-installer.c"
	{
		gchar* character_collection = NULL;
		gint character_collection_length1 = 0;
		gint _character_collection_size_ = 0;
		gint character_it = 0;
#line 88 "/extra-data/checkout/gnome/gnome-boxes/src/winxp-installer.vala"
		character_collection = (gchar*) _tmp3_;
#line 88 "/extra-data/checkout/gnome/gnome-boxes/src/winxp-installer.vala"
		character_collection_length1 = (_tmp3__length1 * sizeof (guint8)) / sizeof (gchar);
#line 88 "/extra-data/checkout/gnome/gnome-boxes/src/winxp-installer.vala"
		for (character_it = 0; character_it < ((_tmp3__length1 * sizeof (guint8)) / sizeof (gchar)); character_it = character_it + 1) {
#line 881 "winxp-installer.c"
			gchar character = '\0';
#line 88 "/extra-data/checkout/gnome/gnome-boxes/src/winxp-installer.vala"
			character = character_collection[character_it];
#line 885 "winxp-installer.c"
			{
				guint _tmp4_;
				gint _tmp5_;
				guint char_position;
				gchar _tmp6_;
				const gchar* _tmp14_;
				gchar _tmp15_;
				gchar* _tmp16_ = NULL;
				gchar* _tmp17_;
				gchar* _tmp18_;
				guint _tmp19_;
#line 89 "/extra-data/checkout/gnome/gnome-boxes/src/winxp-installer.vala"
				_tmp4_ = i;
#line 89 "/extra-data/checkout/gnome/gnome-boxes/src/winxp-installer.vala"
				_tmp5_ = *position;
#line 89 "/extra-data/checkout/gnome/gnome-boxes/src/winxp-installer.vala"
				char_position = _tmp4_ + _tmp5_;
#line 91 "/extra-data/checkout/gnome/gnome-boxes/src/winxp-installer.vala"
				_tmp6_ = character;
#line 91 "/extra-data/checkout/gnome/gnome-boxes/src/winxp-installer.vala"
				if (_tmp6_ != '-') {
#line 907 "winxp-installer.c"
					gchar _tmp7_;
					gboolean _tmp8_ = FALSE;
					guint _tmp9_;
#line 92 "/extra-data/checkout/gnome/gnome-boxes/src/winxp-installer.vala"
					_tmp7_ = character;
#line 92 "/extra-data/checkout/gnome/gnome-boxes/src/winxp-installer.vala"
					_tmp8_ = g_ascii_isalnum (_tmp7_);
#line 92 "/extra-data/checkout/gnome/gnome-boxes/src/winxp-installer.vala"
					if (!_tmp8_) {
#line 93 "/extra-data/checkout/gnome/gnome-boxes/src/winxp-installer.vala"
						continue;
#line 919 "winxp-installer.c"
					}
#line 95 "/extra-data/checkout/gnome/gnome-boxes/src/winxp-installer.vala"
					_tmp9_ = char_position;
#line 95 "/extra-data/checkout/gnome/gnome-boxes/src/winxp-installer.vala"
					if (_vala_uint_array_contains (BOXES_WIN_XP_INSTALLER_allowed_dash_positions, G_N_ELEMENTS (BOXES_WIN_XP_INSTALLER_allowed_dash_positions), _tmp9_)) {
#line 925 "winxp-installer.c"
						const gchar* _tmp10_;
						gchar* _tmp11_;
						guint _tmp12_;
#line 97 "/extra-data/checkout/gnome/gnome-boxes/src/winxp-installer.vala"
						_tmp10_ = _result_;
#line 97 "/extra-data/checkout/gnome/gnome-boxes/src/winxp-installer.vala"
						_tmp11_ = g_strconcat (_tmp10_, "-", NULL);
#line 97 "/extra-data/checkout/gnome/gnome-boxes/src/winxp-installer.vala"
						_g_free0 (_result_);
#line 97 "/extra-data/checkout/gnome/gnome-boxes/src/winxp-installer.vala"
						_result_ = _tmp11_;
#line 98 "/extra-data/checkout/gnome/gnome-boxes/src/winxp-installer.vala"
						_tmp12_ = i;
#line 98 "/extra-data/checkout/gnome/gnome-boxes/src/winxp-installer.vala"
						i = _tmp12_ + 1;
#line 941 "winxp-installer.c"
					}
				} else {
					guint _tmp13_;
#line 100 "/extra-data/checkout/gnome/gnome-boxes/src/winxp-installer.vala"
					_tmp13_ = char_position;
#line 100 "/extra-data/checkout/gnome/gnome-boxes/src/winxp-installer.vala"
					if (!_vala_uint_array_contains (BOXES_WIN_XP_INSTALLER_allowed_dash_positions, G_N_ELEMENTS (BOXES_WIN_XP_INSTALLER_allowed_dash_positions), _tmp13_)) {
#line 101 "/extra-data/checkout/gnome/gnome-boxes/src/winxp-installer.vala"
						continue;
#line 951 "winxp-installer.c"
					}
				}
#line 103 "/extra-data/checkout/gnome/gnome-boxes/src/winxp-installer.vala"
				_tmp14_ = _result_;
#line 103 "/extra-data/checkout/gnome/gnome-boxes/src/winxp-installer.vala"
				_tmp15_ = character;
#line 103 "/extra-data/checkout/gnome/gnome-boxes/src/winxp-installer.vala"
				_tmp16_ = g_strdup_printf ("%c", _tmp15_);
#line 103 "/extra-data/checkout/gnome/gnome-boxes/src/winxp-installer.vala"
				_tmp17_ = _tmp16_;
#line 103 "/extra-data/checkout/gnome/gnome-boxes/src/winxp-installer.vala"
				_tmp18_ = g_strconcat (_tmp14_, _tmp17_, NULL);
#line 103 "/extra-data/checkout/gnome/gnome-boxes/src/winxp-installer.vala"
				_g_free0 (_result_);
#line 103 "/extra-data/checkout/gnome/gnome-boxes/src/winxp-installer.vala"
				_result_ = _tmp18_;
#line 103 "/extra-data/checkout/gnome/gnome-boxes/src/winxp-installer.vala"
				_g_free0 (_tmp17_);
#line 104 "/extra-data/checkout/gnome/gnome-boxes/src/winxp-installer.vala"
				_tmp19_ = i;
#line 104 "/extra-data/checkout/gnome/gnome-boxes/src/winxp-installer.vala"
				i = _tmp19_ + 1;
#line 974 "winxp-installer.c"
			}
		}
	}
#line 107 "/extra-data/checkout/gnome/gnome-boxes/src/winxp-installer.vala"
	_tmp20_ = _result_;
#line 107 "/extra-data/checkout/gnome/gnome-boxes/src/winxp-installer.vala"
	if (g_strcmp0 (_tmp20_, "") != 0) {
#line 982 "winxp-installer.c"
		GtkEntry* _tmp21_;
		gulong _tmp22_;
		GtkEntry* _tmp23_;
		const gchar* _tmp24_;
		gchar* _tmp25_ = NULL;
		gchar* _tmp26_;
		const gchar* _tmp27_;
		gint _tmp28_;
		gint _tmp29_;
		GtkEntry* _tmp30_;
		gulong _tmp31_;
#line 108 "/extra-data/checkout/gnome/gnome-boxes/src/winxp-installer.vala"
		_tmp21_ = self->priv->key_entry;
#line 108 "/extra-data/checkout/gnome/gnome-boxes/src/winxp-installer.vala"
		_tmp22_ = self->priv->key_inserted_id;
#line 108 "/extra-data/checkout/gnome/gnome-boxes/src/winxp-installer.vala"
		g_signal_handler_block (_tmp21_, _tmp22_);
#line 109 "/extra-data/checkout/gnome/gnome-boxes/src/winxp-installer.vala"
		_tmp23_ = self->priv->key_entry;
#line 109 "/extra-data/checkout/gnome/gnome-boxes/src/winxp-installer.vala"
		_tmp24_ = _result_;
#line 109 "/extra-data/checkout/gnome/gnome-boxes/src/winxp-installer.vala"
		_tmp25_ = g_utf8_strup (_tmp24_, (gssize) (-1));
#line 109 "/extra-data/checkout/gnome/gnome-boxes/src/winxp-installer.vala"
		_tmp26_ = _tmp25_;
#line 109 "/extra-data/checkout/gnome/gnome-boxes/src/winxp-installer.vala"
		_tmp27_ = _result_;
#line 109 "/extra-data/checkout/gnome/gnome-boxes/src/winxp-installer.vala"
		_tmp28_ = strlen (_tmp27_);
#line 109 "/extra-data/checkout/gnome/gnome-boxes/src/winxp-installer.vala"
		_tmp29_ = _tmp28_;
#line 109 "/extra-data/checkout/gnome/gnome-boxes/src/winxp-installer.vala"
		gtk_editable_insert_text ((GtkEditable*) _tmp23_, _tmp26_, _tmp29_, position);
#line 109 "/extra-data/checkout/gnome/gnome-boxes/src/winxp-installer.vala"
		_g_free0 (_tmp26_);
#line 110 "/extra-data/checkout/gnome/gnome-boxes/src/winxp-installer.vala"
		_tmp30_ = self->priv->key_entry;
#line 110 "/extra-data/checkout/gnome/gnome-boxes/src/winxp-installer.vala"
		_tmp31_ = self->priv->key_inserted_id;
#line 110 "/extra-data/checkout/gnome/gnome-boxes/src/winxp-installer.vala"
		g_signal_handler_unblock (_tmp30_, _tmp31_);
#line 1024 "winxp-installer.c"
	}
#line 113 "/extra-data/checkout/gnome/gnome-boxes/src/winxp-installer.vala"
	_tmp32_ = self->priv->key_entry;
#line 113 "/extra-data/checkout/gnome/gnome-boxes/src/winxp-installer.vala"
	g_signal_stop_emission_by_name (_tmp32_, "insert-text");
#line 84 "/extra-data/checkout/gnome/gnome-boxes/src/winxp-installer.vala"
	_g_free0 (_result_);
#line 1032 "winxp-installer.c"
}


BoxesWinXPInstaller* boxes_win_xp_installer_construct (GType object_type) {
	BoxesWinXPInstaller * self = NULL;
#line 4 "/extra-data/checkout/gnome/gnome-boxes/src/winxp-installer.vala"
	self = (BoxesWinXPInstaller*) boxes_windows_installer_construct (object_type);
#line 4 "/extra-data/checkout/gnome/gnome-boxes/src/winxp-installer.vala"
	return self;
#line 1042 "winxp-installer.c"
}


BoxesWinXPInstaller* boxes_win_xp_installer_new (void) {
#line 4 "/extra-data/checkout/gnome/gnome-boxes/src/winxp-installer.vala"
	return boxes_win_xp_installer_construct (BOXES_TYPE_WIN_XP_INSTALLER);
#line 1049 "winxp-installer.c"
}


static gboolean boxes_win_xp_installer_real_get_user_data_for_vm_creation_available (BoxesInstallerMedia* base) {
	gboolean result;
	BoxesWinXPInstaller* self;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_;
	gboolean _tmp5_;
#line 15 "/extra-data/checkout/gnome/gnome-boxes/src/winxp-installer.vala"
	self = (BoxesWinXPInstaller*) base;
#line 16 "/extra-data/checkout/gnome/gnome-boxes/src/winxp-installer.vala"
	_tmp1_ = BOXES_INSTALLER_MEDIA_CLASS (boxes_win_xp_installer_parent_class)->get_user_data_for_vm_creation_available ((BoxesInstallerMedia*) G_TYPE_CHECK_INSTANCE_CAST (self, BOXES_TYPE_WINDOWS_INSTALLER, BoxesWindowsInstaller));
#line 16 "/extra-data/checkout/gnome/gnome-boxes/src/winxp-installer.vala"
	if (_tmp1_) {
#line 1065 "winxp-installer.c"
		GtkEntry* _tmp2_;
		guint _tmp3_;
		guint _tmp4_;
#line 16 "/extra-data/checkout/gnome/gnome-boxes/src/winxp-installer.vala"
		_tmp2_ = self->priv->key_entry;
#line 16 "/extra-data/checkout/gnome/gnome-boxes/src/winxp-installer.vala"
		_tmp3_ = gtk_entry_get_text_length (_tmp2_);
#line 16 "/extra-data/checkout/gnome/gnome-boxes/src/winxp-installer.vala"
		_tmp4_ = _tmp3_;
#line 16 "/extra-data/checkout/gnome/gnome-boxes/src/winxp-installer.vala"
		_tmp0_ = _tmp4_ == ((guint) 29);
#line 1077 "winxp-installer.c"
	} else {
#line 16 "/extra-data/checkout/gnome/gnome-boxes/src/winxp-installer.vala"
		_tmp0_ = FALSE;
#line 1081 "winxp-installer.c"
	}
#line 16 "/extra-data/checkout/gnome/gnome-boxes/src/winxp-installer.vala"
	_tmp5_ = _tmp0_;
#line 16 "/extra-data/checkout/gnome/gnome-boxes/src/winxp-installer.vala"
	result = _tmp5_;
#line 16 "/extra-data/checkout/gnome/gnome-boxes/src/winxp-installer.vala"
	return result;
#line 1089 "winxp-installer.c"
}


static guint64 boxes_win_xp_installer_real_get_installed_size (BoxesInstallerMedia* base) {
	guint64 result;
	BoxesWinXPInstaller* self;
	gint _tmp0_ = 0;
	gboolean _tmp1_;
	gboolean _tmp2_;
	gint _tmp3_;
#line 21 "/extra-data/checkout/gnome/gnome-boxes/src/winxp-installer.vala"
	self = (BoxesWinXPInstaller*) base;
#line 22 "/extra-data/checkout/gnome/gnome-boxes/src/winxp-installer.vala"
	_tmp1_ = boxes_unattended_installer_get_express_install ((BoxesUnattendedInstaller*) self);
#line 22 "/extra-data/checkout/gnome/gnome-boxes/src/winxp-installer.vala"
	_tmp2_ = _tmp1_;
#line 22 "/extra-data/checkout/gnome/gnome-boxes/src/winxp-installer.vala"
	if (_tmp2_) {
#line 22 "/extra-data/checkout/gnome/gnome-boxes/src/winxp-installer.vala"
		_tmp0_ = 1169436672;
#line 1110 "winxp-installer.c"
	} else {
#line 22 "/extra-data/checkout/gnome/gnome-boxes/src/winxp-installer.vala"
		_tmp0_ = 0;
#line 1114 "winxp-installer.c"
	}
#line 22 "/extra-data/checkout/gnome/gnome-boxes/src/winxp-installer.vala"
	_tmp3_ = _tmp0_;
#line 22 "/extra-data/checkout/gnome/gnome-boxes/src/winxp-installer.vala"
	result = (guint64) _tmp3_;
#line 22 "/extra-data/checkout/gnome/gnome-boxes/src/winxp-installer.vala"
	return result;
#line 1122 "winxp-installer.c"
}


static void boxes_win_xp_installer_class_init (BoxesWinXPInstallerClass * klass) {
	GError * _inner_error_ = NULL;
#line 4 "/extra-data/checkout/gnome/gnome-boxes/src/winxp-installer.vala"
	boxes_win_xp_installer_parent_class = g_type_class_peek_parent (klass);
#line 4 "/extra-data/checkout/gnome/gnome-boxes/src/winxp-installer.vala"
	g_type_class_add_private (klass, sizeof (BoxesWinXPInstallerPrivate));
#line 4 "/extra-data/checkout/gnome/gnome-boxes/src/winxp-installer.vala"
	BOXES_UNATTENDED_INSTALLER_CLASS (klass)->setup_ui = boxes_win_xp_installer_real_setup_ui;
#line 4 "/extra-data/checkout/gnome/gnome-boxes/src/winxp-installer.vala"
	BOXES_UNATTENDED_INSTALLER_CLASS (klass)->fill_unattended_data = boxes_win_xp_installer_real_fill_unattended_data;
#line 4 "/extra-data/checkout/gnome/gnome-boxes/src/winxp-installer.vala"
	BOXES_INSTALLER_MEDIA_CLASS (klass)->get_user_data_for_vm_creation_available = boxes_win_xp_installer_real_get_user_data_for_vm_creation_available;
#line 4 "/extra-data/checkout/gnome/gnome-boxes/src/winxp-installer.vala"
	BOXES_INSTALLER_MEDIA_CLASS (klass)->get_installed_size = boxes_win_xp_installer_real_get_installed_size;
#line 4 "/extra-data/checkout/gnome/gnome-boxes/src/winxp-installer.vala"
	G_OBJECT_CLASS (klass)->get_property = _vala_boxes_win_xp_installer_get_property;
#line 4 "/extra-data/checkout/gnome/gnome-boxes/src/winxp-installer.vala"
	G_OBJECT_CLASS (klass)->finalize = boxes_win_xp_installer_finalize;
#line 4 "/extra-data/checkout/gnome/gnome-boxes/src/winxp-installer.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), BOXES_WIN_XP_INSTALLER_USER_DATA_FOR_VM_CREATION_AVAILABLE, g_param_spec_boolean ("user-data-for-vm-creation-available", "user-data-for-vm-creation-available", "user-data-for-vm-creation-available", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
#line 4 "/extra-data/checkout/gnome/gnome-boxes/src/winxp-installer.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), BOXES_WIN_XP_INSTALLER_INSTALLED_SIZE, g_param_spec_uint64 ("installed-size", "installed-size", "installed-size", 0, G_MAXUINT64, 0U, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
#line 1148 "winxp-installer.c"
	{
		GRegex* _tmp0_;
		GRegex* _tmp1_;
		GRegex* _tmp2_;
		GRegex* _tmp3_;
#line 28 "/extra-data/checkout/gnome/gnome-boxes/src/winxp-installer.vala"
		_tmp0_ = g_regex_new ("BOXES_PRODUCT_KEY", 0, 0, &_inner_error_);
#line 28 "/extra-data/checkout/gnome/gnome-boxes/src/winxp-installer.vala"
		_tmp1_ = _tmp0_;
#line 28 "/extra-data/checkout/gnome/gnome-boxes/src/winxp-installer.vala"
		if (_inner_error_ != NULL) {
#line 28 "/extra-data/checkout/gnome/gnome-boxes/src/winxp-installer.vala"
			if (_inner_error_->domain == G_REGEX_ERROR) {
#line 1162 "winxp-installer.c"
				goto __catch70_g_regex_error;
			}
#line 28 "/extra-data/checkout/gnome/gnome-boxes/src/winxp-installer.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 28 "/extra-data/checkout/gnome/gnome-boxes/src/winxp-installer.vala"
			g_clear_error (&_inner_error_);
#line 1169 "winxp-installer.c"
		}
#line 28 "/extra-data/checkout/gnome/gnome-boxes/src/winxp-installer.vala"
		_g_regex_unref0 (boxes_win_xp_installer_key_regex);
#line 28 "/extra-data/checkout/gnome/gnome-boxes/src/winxp-installer.vala"
		boxes_win_xp_installer_key_regex = _tmp1_;
#line 29 "/extra-data/checkout/gnome/gnome-boxes/src/winxp-installer.vala"
		_tmp2_ = g_regex_new ("BOXES_XP_ADMIN_PASSWORD", 0, 0, &_inner_error_);
#line 29 "/extra-data/checkout/gnome/gnome-boxes/src/winxp-installer.vala"
		_tmp3_ = _tmp2_;
#line 29 "/extra-data/checkout/gnome/gnome-boxes/src/winxp-installer.vala"
		if (_inner_error_ != NULL) {
#line 29 "/extra-data/checkout/gnome/gnome-boxes/src/winxp-installer.vala"
			if (_inner_error_->domain == G_REGEX_ERROR) {
#line 1183 "winxp-installer.c"
				goto __catch70_g_regex_error;
			}
#line 29 "/extra-data/checkout/gnome/gnome-boxes/src/winxp-installer.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 29 "/extra-data/checkout/gnome/gnome-boxes/src/winxp-installer.vala"
			g_clear_error (&_inner_error_);
#line 1190 "winxp-installer.c"
		}
#line 29 "/extra-data/checkout/gnome/gnome-boxes/src/winxp-installer.vala"
		_g_regex_unref0 (boxes_win_xp_installer_admin_pass_regex);
#line 29 "/extra-data/checkout/gnome/gnome-boxes/src/winxp-installer.vala"
		boxes_win_xp_installer_admin_pass_regex = _tmp3_;
#line 1196 "winxp-installer.c"
	}
	goto __finally70;
	__catch70_g_regex_error:
	{
		GError* _error_ = NULL;
#line 27 "/extra-data/checkout/gnome/gnome-boxes/src/winxp-installer.vala"
		_error_ = _inner_error_;
#line 27 "/extra-data/checkout/gnome/gnome-boxes/src/winxp-installer.vala"
		_inner_error_ = NULL;
#line 32 "/extra-data/checkout/gnome/gnome-boxes/src/winxp-installer.vala"
		g_assert_not_reached ();
#line 27 "/extra-data/checkout/gnome/gnome-boxes/src/winxp-installer.vala"
		_g_error_free0 (_error_);
#line 1210 "winxp-installer.c"
	}
	__finally70:
#line 27 "/extra-data/checkout/gnome/gnome-boxes/src/winxp-installer.vala"
	if (_inner_error_ != NULL) {
#line 27 "/extra-data/checkout/gnome/gnome-boxes/src/winxp-installer.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 27 "/extra-data/checkout/gnome/gnome-boxes/src/winxp-installer.vala"
		g_clear_error (&_inner_error_);
#line 1219 "winxp-installer.c"
	}
}


static void boxes_win_xp_installer_instance_init (BoxesWinXPInstaller * self) {
#line 4 "/extra-data/checkout/gnome/gnome-boxes/src/winxp-installer.vala"
	self->priv = BOXES_WIN_XP_INSTALLER_GET_PRIVATE (self);
#line 1227 "winxp-installer.c"
}


static void boxes_win_xp_installer_finalize (GObject* obj) {
	BoxesWinXPInstaller * self;
#line 4 "/extra-data/checkout/gnome/gnome-boxes/src/winxp-installer.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, BOXES_TYPE_WIN_XP_INSTALLER, BoxesWinXPInstaller);
#line 10 "/extra-data/checkout/gnome/gnome-boxes/src/winxp-installer.vala"
	_g_object_unref0 (self->priv->key_entry);
#line 4 "/extra-data/checkout/gnome/gnome-boxes/src/winxp-installer.vala"
	G_OBJECT_CLASS (boxes_win_xp_installer_parent_class)->finalize (obj);
#line 1239 "winxp-installer.c"
}


GType boxes_win_xp_installer_get_type (void) {
	static volatile gsize boxes_win_xp_installer_type_id__volatile = 0;
	if (g_once_init_enter (&boxes_win_xp_installer_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (BoxesWinXPInstallerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) boxes_win_xp_installer_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (BoxesWinXPInstaller), 0, (GInstanceInitFunc) boxes_win_xp_installer_instance_init, NULL };
		GType boxes_win_xp_installer_type_id;
		boxes_win_xp_installer_type_id = g_type_register_static (BOXES_TYPE_WINDOWS_INSTALLER, "BoxesWinXPInstaller", &g_define_type_info, 0);
		g_once_init_leave (&boxes_win_xp_installer_type_id__volatile, boxes_win_xp_installer_type_id);
	}
	return boxes_win_xp_installer_type_id__volatile;
}


static void _vala_boxes_win_xp_installer_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	BoxesWinXPInstaller * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, BOXES_TYPE_WIN_XP_INSTALLER, BoxesWinXPInstaller);
#line 4 "/extra-data/checkout/gnome/gnome-boxes/src/winxp-installer.vala"
	switch (property_id) {
#line 4 "/extra-data/checkout/gnome/gnome-boxes/src/winxp-installer.vala"
		case BOXES_WIN_XP_INSTALLER_USER_DATA_FOR_VM_CREATION_AVAILABLE:
#line 4 "/extra-data/checkout/gnome/gnome-boxes/src/winxp-installer.vala"
		g_value_set_boolean (value, boxes_installer_media_get_user_data_for_vm_creation_available ((BoxesInstallerMedia*) self));
#line 4 "/extra-data/checkout/gnome/gnome-boxes/src/winxp-installer.vala"
		break;
#line 4 "/extra-data/checkout/gnome/gnome-boxes/src/winxp-installer.vala"
		case BOXES_WIN_XP_INSTALLER_INSTALLED_SIZE:
#line 4 "/extra-data/checkout/gnome/gnome-boxes/src/winxp-installer.vala"
		g_value_set_uint64 (value, boxes_installer_media_get_installed_size ((BoxesInstallerMedia*) self));
#line 4 "/extra-data/checkout/gnome/gnome-boxes/src/winxp-installer.vala"
		break;
#line 1272 "winxp-installer.c"
		default:
#line 4 "/extra-data/checkout/gnome/gnome-boxes/src/winxp-installer.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 4 "/extra-data/checkout/gnome/gnome-boxes/src/winxp-installer.vala"
		break;
#line 1278 "winxp-installer.c"
	}
}



