/* vnc-display.c generated by valac 0.18.0.79-04df6, the Vala compiler
 * generated from vnc-display.vala, do not modify */

/* This file is part of GNOME Boxes. License: LGPLv2+*/

#include <glib.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include <gdk-pixbuf/gdk-pixbuf.h>
#include <libcommon.h>
#include <stdlib.h>
#include <string.h>
#include <gtk-vnc.h>
#include <libxml/uri.h>
#include <glib/gi18n-lib.h>


#define BOXES_TYPE_IPROPERTIES_PROVIDER (boxes_iproperties_provider_get_type ())
#define BOXES_IPROPERTIES_PROVIDER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), BOXES_TYPE_IPROPERTIES_PROVIDER, BoxesIPropertiesProvider))
#define BOXES_IS_IPROPERTIES_PROVIDER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), BOXES_TYPE_IPROPERTIES_PROVIDER))
#define BOXES_IPROPERTIES_PROVIDER_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), BOXES_TYPE_IPROPERTIES_PROVIDER, BoxesIPropertiesProviderIface))

typedef struct _BoxesIPropertiesProvider BoxesIPropertiesProvider;
typedef struct _BoxesIPropertiesProviderIface BoxesIPropertiesProviderIface;

#define BOXES_TYPE_PROPERTIES_PAGE (boxes_properties_page_get_type ())

#define TYPE_PROPERTY_CREATION_FLAG (property_creation_flag_get_type ())

#define BOXES_TYPE_PROPERTY (boxes_property_get_type ())
#define BOXES_PROPERTY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), BOXES_TYPE_PROPERTY, BoxesProperty))
#define BOXES_PROPERTY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), BOXES_TYPE_PROPERTY, BoxesPropertyClass))
#define BOXES_IS_PROPERTY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), BOXES_TYPE_PROPERTY))
#define BOXES_IS_PROPERTY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), BOXES_TYPE_PROPERTY))
#define BOXES_PROPERTY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), BOXES_TYPE_PROPERTY, BoxesPropertyClass))

typedef struct _BoxesProperty BoxesProperty;
typedef struct _BoxesPropertyClass BoxesPropertyClass;

#define BOXES_TYPE_DISPLAY (boxes_display_get_type ())
#define BOXES_DISPLAY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), BOXES_TYPE_DISPLAY, BoxesDisplay))
#define BOXES_DISPLAY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), BOXES_TYPE_DISPLAY, BoxesDisplayClass))
#define BOXES_IS_DISPLAY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), BOXES_TYPE_DISPLAY))
#define BOXES_IS_DISPLAY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), BOXES_TYPE_DISPLAY))
#define BOXES_DISPLAY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), BOXES_TYPE_DISPLAY, BoxesDisplayClass))

typedef struct _BoxesDisplay BoxesDisplay;
typedef struct _BoxesDisplayClass BoxesDisplayClass;
typedef struct _BoxesDisplayPrivate BoxesDisplayPrivate;

#define BOXES_TYPE_VNC_DISPLAY (boxes_vnc_display_get_type ())
#define BOXES_VNC_DISPLAY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), BOXES_TYPE_VNC_DISPLAY, BoxesVncDisplay))
#define BOXES_VNC_DISPLAY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), BOXES_TYPE_VNC_DISPLAY, BoxesVncDisplayClass))
#define BOXES_IS_VNC_DISPLAY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), BOXES_TYPE_VNC_DISPLAY))
#define BOXES_IS_VNC_DISPLAY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), BOXES_TYPE_VNC_DISPLAY))
#define BOXES_VNC_DISPLAY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), BOXES_TYPE_VNC_DISPLAY, BoxesVncDisplayClass))

typedef struct _BoxesVncDisplay BoxesVncDisplay;
typedef struct _BoxesVncDisplayClass BoxesVncDisplayClass;
typedef struct _BoxesVncDisplayPrivate BoxesVncDisplayPrivate;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _xmlFreeURI0(var) ((var == NULL) ? NULL : (var = (xmlFreeURI (var), NULL)))
#define __g_list_free__g_object_unref0_0(var) ((var == NULL) ? NULL : (var = (_g_list_free__g_object_unref0_ (var), NULL)))

typedef enum  {
	BOXES_PROPERTIES_PAGE_LOGIN,
	BOXES_PROPERTIES_PAGE_SYSTEM,
	BOXES_PROPERTIES_PAGE_DISPLAY,
	BOXES_PROPERTIES_PAGE_DEVICES,
	BOXES_PROPERTIES_PAGE_LAST
} BoxesPropertiesPage;

typedef enum  {
	PROPERTY_CREATION_FLAG_NONE = 0,
	PROPERTY_CREATION_FLAG_NO_USB = 1 << 0
} PropertyCreationFlag;

struct _BoxesIPropertiesProviderIface {
	GTypeInterface parent_iface;
	GList* (*get_properties) (BoxesIPropertiesProvider* self, BoxesPropertiesPage page, PropertyCreationFlag flags);
};

struct _BoxesDisplay {
	GObject parent_instance;
	BoxesDisplayPrivate * priv;
	GHashTable* displays;
};

struct _BoxesDisplayClass {
	GObjectClass parent_class;
	GtkWidget* (*get_display) (BoxesDisplay* self, gint n);
	GdkPixbuf* (*get_pixbuf) (BoxesDisplay* self, gint n, GError** error);
	void (*set_enable_inputs) (BoxesDisplay* self, GtkWidget* widget, gboolean enable);
	void (*set_enable_audio) (BoxesDisplay* self, gboolean enable);
	gboolean (*should_keep_alive) (BoxesDisplay* self);
	void (*connect_it) (BoxesDisplay* self, GError** error);
	void (*disconnect_it) (BoxesDisplay* self);
	void (*collect_logs) (BoxesDisplay* self, GString* builder);
	GList* (*get_properties) (BoxesDisplay* self, BoxesPropertiesPage page, PropertyCreationFlag flags);
	const gchar* (*get_protocol) (BoxesDisplay* self);
	gchar* (*get_uri) (BoxesDisplay* self);
};

struct _BoxesVncDisplay {
	BoxesDisplay parent_instance;
	BoxesVncDisplayPrivate * priv;
};

struct _BoxesVncDisplayClass {
	BoxesDisplayClass parent_class;
};

struct _BoxesVncDisplayPrivate {
	VncDisplay* display;
	gchar* host;
	gint port;
	GtkWindow* window;
	BoxesBoxConfigSyncProperty* sync_properties;
	gint sync_properties_length1;
	gint _sync_properties_size_;
	gboolean connected;
};


static gpointer boxes_vnc_display_parent_class = NULL;

GType boxes_properties_page_get_type (void) G_GNUC_CONST;
GType property_creation_flag_get_type (void) G_GNUC_CONST;
GType boxes_property_get_type (void) G_GNUC_CONST;
GType boxes_iproperties_provider_get_type (void) G_GNUC_CONST;
GType boxes_display_get_type (void) G_GNUC_CONST;
GType boxes_vnc_display_get_type (void) G_GNUC_CONST;
#define BOXES_VNC_DISPLAY_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), BOXES_TYPE_VNC_DISPLAY, BoxesVncDisplayPrivate))
enum  {
	BOXES_VNC_DISPLAY_DUMMY_PROPERTY,
	BOXES_VNC_DISPLAY_PROTOCOL,
	BOXES_VNC_DISPLAY_URI
};
static void _vala_BoxesBoxConfigSyncProperty_array_free (BoxesBoxConfigSyncProperty* array, gint array_length);
BoxesVncDisplay* boxes_vnc_display_new (BoxesBoxConfig* config, const gchar* host, gint port);
BoxesVncDisplay* boxes_vnc_display_construct (GType object_type, BoxesBoxConfig* config, const gchar* host, gint port);
BoxesDisplay* boxes_display_construct (GType object_type);
void boxes_display_set_config (BoxesDisplay* self, BoxesBoxConfig* value);
BoxesVncDisplay* boxes_vnc_display_new_with_uri (BoxesBoxConfig* config, const gchar* _uri, GError** error);
BoxesVncDisplay* boxes_vnc_display_construct_with_uri (GType object_type, BoxesBoxConfig* config, const gchar* _uri, GError** error);
static GtkWidget* boxes_vnc_display_real_get_display (BoxesDisplay* base, gint n);
static void boxes_vnc_display_real_set_enable_audio (BoxesDisplay* base, gboolean enable);
static void boxes_vnc_display_real_set_enable_inputs (BoxesDisplay* base, GtkWidget* widget, gboolean enable);
static GdkPixbuf* boxes_vnc_display_real_get_pixbuf (BoxesDisplay* base, gint n, GError** error);
static void boxes_vnc_display_real_connect_it (BoxesDisplay* base, GError** error);
const gchar* boxes_display_get_username (BoxesDisplay* self);
const gchar* boxes_display_get_password (BoxesDisplay* self);
static void boxes_vnc_display_real_disconnect_it (BoxesDisplay* base);
static GList* boxes_vnc_display_real_get_properties (BoxesDisplay* base, BoxesPropertiesPage page, PropertyCreationFlag flags);
BoxesProperty* boxes_iproperties_provider_add_property (BoxesIPropertiesProvider* self, GList** list, const gchar* name, GtkWidget* widget, GtkWidget* extra_widget);
static void _g_object_unref0_ (gpointer var);
static void _g_list_free__g_object_unref0_ (GList* self);
static GObject * boxes_vnc_display_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties);
void boxes_display_set_need_password (BoxesDisplay* self, gboolean value);
static void _boxes_vnc_display___lambda97_ (BoxesVncDisplay* self);
void boxes_display_access_start (BoxesDisplay* self);
static void __boxes_vnc_display___lambda97__vnc_display_vnc_initialized (VncDisplay* _sender, gpointer self);
static void _boxes_vnc_display___lambda98_ (BoxesVncDisplay* self);
void boxes_display_access_finish (BoxesDisplay* self);
static void __boxes_vnc_display___lambda98__vnc_display_vnc_disconnected (VncDisplay* _sender, gpointer self);
static void _boxes_vnc_display___lambda99_ (BoxesVncDisplay* self);
static void __boxes_vnc_display___lambda99__vnc_display_vnc_auth_failure (VncDisplay* _sender, const gchar* object, gpointer self);
static void _boxes_vnc_display___lambda100_ (BoxesVncDisplay* self);
static void __boxes_vnc_display___lambda100__vnc_display_vnc_auth_unsupported (VncDisplay* _sender, guint object, gpointer self);
static void _boxes_vnc_display___lambda101_ (BoxesVncDisplay* self, VncDisplay* vnc, GValueArray* creds);
static VncDisplayCredential* _vnc_display_credential_dup (VncDisplayCredential* self);
void boxes_display_set_need_username (BoxesDisplay* self, gboolean value);
const gchar* vnc_display_credential_to_string (VncDisplayCredential self);
static void __boxes_vnc_display___lambda101__vnc_display_vnc_auth_credential (VncDisplay* _sender, GValueArray* credList, gpointer self);
static void _boxes_vnc_display___lambda102_ (BoxesVncDisplay* self);
BoxesBoxConfig* boxes_display_get_config (BoxesDisplay* self);
static void __boxes_vnc_display___lambda102__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self);
static void boxes_vnc_display_finalize (GObject* obj);
const gchar* boxes_display_get_protocol (BoxesDisplay* self);
gchar* boxes_display_get_uri (BoxesDisplay* self);
static void _vala_boxes_vnc_display_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);


static void _vala_BoxesBoxConfigSyncProperty_array_free (BoxesBoxConfigSyncProperty* array, gint array_length) {
#line 12 "/extra-data/checkout/gnome/gnome-boxes/src/vnc-display.vala"
	if (array != NULL) {
#line 189 "vnc-display.c"
		int i;
#line 12 "/extra-data/checkout/gnome/gnome-boxes/src/vnc-display.vala"
		for (i = 0; i < array_length; i = i + 1) {
#line 12 "/extra-data/checkout/gnome/gnome-boxes/src/vnc-display.vala"
			boxes_box_config_sync_property_destroy (&array[i]);
#line 195 "vnc-display.c"
		}
	}
#line 12 "/extra-data/checkout/gnome/gnome-boxes/src/vnc-display.vala"
	g_free (array);
#line 200 "vnc-display.c"
}


BoxesVncDisplay* boxes_vnc_display_construct (GType object_type, BoxesBoxConfig* config, const gchar* host, gint port) {
	BoxesVncDisplay * self = NULL;
	BoxesBoxConfig* _tmp0_;
	const gchar* _tmp1_;
	gchar* _tmp2_;
	gint _tmp3_;
#line 79 "/extra-data/checkout/gnome/gnome-boxes/src/vnc-display.vala"
	g_return_val_if_fail (config != NULL, NULL);
#line 79 "/extra-data/checkout/gnome/gnome-boxes/src/vnc-display.vala"
	g_return_val_if_fail (host != NULL, NULL);
#line 79 "/extra-data/checkout/gnome/gnome-boxes/src/vnc-display.vala"
	self = (BoxesVncDisplay*) boxes_display_construct (object_type);
#line 80 "/extra-data/checkout/gnome/gnome-boxes/src/vnc-display.vala"
	_tmp0_ = config;
#line 80 "/extra-data/checkout/gnome/gnome-boxes/src/vnc-display.vala"
	boxes_display_set_config ((BoxesDisplay*) self, _tmp0_);
#line 82 "/extra-data/checkout/gnome/gnome-boxes/src/vnc-display.vala"
	_tmp1_ = host;
#line 82 "/extra-data/checkout/gnome/gnome-boxes/src/vnc-display.vala"
	_tmp2_ = g_strdup (_tmp1_);
#line 82 "/extra-data/checkout/gnome/gnome-boxes/src/vnc-display.vala"
	_g_free0 (self->priv->host);
#line 82 "/extra-data/checkout/gnome/gnome-boxes/src/vnc-display.vala"
	self->priv->host = _tmp2_;
#line 83 "/extra-data/checkout/gnome/gnome-boxes/src/vnc-display.vala"
	_tmp3_ = port;
#line 83 "/extra-data/checkout/gnome/gnome-boxes/src/vnc-display.vala"
	self->priv->port = _tmp3_;
#line 79 "/extra-data/checkout/gnome/gnome-boxes/src/vnc-display.vala"
	return self;
#line 234 "vnc-display.c"
}


BoxesVncDisplay* boxes_vnc_display_new (BoxesBoxConfig* config, const gchar* host, gint port) {
#line 79 "/extra-data/checkout/gnome/gnome-boxes/src/vnc-display.vala"
	return boxes_vnc_display_construct (BOXES_TYPE_VNC_DISPLAY, config, host, port);
#line 241 "vnc-display.c"
}


BoxesVncDisplay* boxes_vnc_display_construct_with_uri (GType object_type, BoxesBoxConfig* config, const gchar* _uri, GError** error) {
	BoxesVncDisplay * self = NULL;
	BoxesBoxConfig* _tmp0_;
	const gchar* _tmp1_;
	xmlURI* _tmp2_ = NULL;
	xmlURI* uri;
	xmlURI* _tmp3_;
	const gchar* _tmp4_;
	xmlURI* _tmp6_;
	const gchar* _tmp7_;
	xmlURI* _tmp9_;
	const gchar* _tmp10_;
	gchar* _tmp11_;
	gint _tmp12_ = 0;
	xmlURI* _tmp13_;
	gint _tmp14_;
	gint _tmp17_;
	GError * _inner_error_ = NULL;
#line 86 "/extra-data/checkout/gnome/gnome-boxes/src/vnc-display.vala"
	g_return_val_if_fail (config != NULL, NULL);
#line 86 "/extra-data/checkout/gnome/gnome-boxes/src/vnc-display.vala"
	g_return_val_if_fail (_uri != NULL, NULL);
#line 86 "/extra-data/checkout/gnome/gnome-boxes/src/vnc-display.vala"
	self = (BoxesVncDisplay*) boxes_display_construct (object_type);
#line 87 "/extra-data/checkout/gnome/gnome-boxes/src/vnc-display.vala"
	_tmp0_ = config;
#line 87 "/extra-data/checkout/gnome/gnome-boxes/src/vnc-display.vala"
	boxes_display_set_config ((BoxesDisplay*) self, _tmp0_);
#line 89 "/extra-data/checkout/gnome/gnome-boxes/src/vnc-display.vala"
	_tmp1_ = _uri;
#line 89 "/extra-data/checkout/gnome/gnome-boxes/src/vnc-display.vala"
	_tmp2_ = xmlParseURI (_tmp1_);
#line 89 "/extra-data/checkout/gnome/gnome-boxes/src/vnc-display.vala"
	uri = _tmp2_;
#line 91 "/extra-data/checkout/gnome/gnome-boxes/src/vnc-display.vala"
	_tmp3_ = uri;
#line 91 "/extra-data/checkout/gnome/gnome-boxes/src/vnc-display.vala"
	_tmp4_ = _tmp3_->scheme;
#line 91 "/extra-data/checkout/gnome/gnome-boxes/src/vnc-display.vala"
	if (g_strcmp0 (_tmp4_, "vnc") != 0) {
#line 285 "vnc-display.c"
		GError* _tmp5_;
#line 92 "/extra-data/checkout/gnome/gnome-boxes/src/vnc-display.vala"
		_tmp5_ = g_error_new_literal (BOXES_ERROR, BOXES_ERROR_INVALID, "the URI is not vnc://");
#line 92 "/extra-data/checkout/gnome/gnome-boxes/src/vnc-display.vala"
		_inner_error_ = _tmp5_;
#line 92 "/extra-data/checkout/gnome/gnome-boxes/src/vnc-display.vala"
		if (_inner_error_->domain == BOXES_ERROR) {
#line 92 "/extra-data/checkout/gnome/gnome-boxes/src/vnc-display.vala"
			g_propagate_error (error, _inner_error_);
#line 92 "/extra-data/checkout/gnome/gnome-boxes/src/vnc-display.vala"
			_xmlFreeURI0 (uri);
#line 92 "/extra-data/checkout/gnome/gnome-boxes/src/vnc-display.vala"
			_g_object_unref0 (self);
#line 92 "/extra-data/checkout/gnome/gnome-boxes/src/vnc-display.vala"
			return NULL;
#line 301 "vnc-display.c"
		} else {
#line 92 "/extra-data/checkout/gnome/gnome-boxes/src/vnc-display.vala"
			_xmlFreeURI0 (uri);
#line 92 "/extra-data/checkout/gnome/gnome-boxes/src/vnc-display.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 92 "/extra-data/checkout/gnome/gnome-boxes/src/vnc-display.vala"
			g_clear_error (&_inner_error_);
#line 92 "/extra-data/checkout/gnome/gnome-boxes/src/vnc-display.vala"
			return NULL;
#line 311 "vnc-display.c"
		}
	}
#line 94 "/extra-data/checkout/gnome/gnome-boxes/src/vnc-display.vala"
	_tmp6_ = uri;
#line 94 "/extra-data/checkout/gnome/gnome-boxes/src/vnc-display.vala"
	_tmp7_ = _tmp6_->server;
#line 94 "/extra-data/checkout/gnome/gnome-boxes/src/vnc-display.vala"
	if (_tmp7_ == NULL) {
#line 320 "vnc-display.c"
		GError* _tmp8_;
#line 95 "/extra-data/checkout/gnome/gnome-boxes/src/vnc-display.vala"
		_tmp8_ = g_error_new_literal (BOXES_ERROR, BOXES_ERROR_INVALID, "the URI is missing a server");
#line 95 "/extra-data/checkout/gnome/gnome-boxes/src/vnc-display.vala"
		_inner_error_ = _tmp8_;
#line 95 "/extra-data/checkout/gnome/gnome-boxes/src/vnc-display.vala"
		if (_inner_error_->domain == BOXES_ERROR) {
#line 95 "/extra-data/checkout/gnome/gnome-boxes/src/vnc-display.vala"
			g_propagate_error (error, _inner_error_);
#line 95 "/extra-data/checkout/gnome/gnome-boxes/src/vnc-display.vala"
			_xmlFreeURI0 (uri);
#line 95 "/extra-data/checkout/gnome/gnome-boxes/src/vnc-display.vala"
			_g_object_unref0 (self);
#line 95 "/extra-data/checkout/gnome/gnome-boxes/src/vnc-display.vala"
			return NULL;
#line 336 "vnc-display.c"
		} else {
#line 95 "/extra-data/checkout/gnome/gnome-boxes/src/vnc-display.vala"
			_xmlFreeURI0 (uri);
#line 95 "/extra-data/checkout/gnome/gnome-boxes/src/vnc-display.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 95 "/extra-data/checkout/gnome/gnome-boxes/src/vnc-display.vala"
			g_clear_error (&_inner_error_);
#line 95 "/extra-data/checkout/gnome/gnome-boxes/src/vnc-display.vala"
			return NULL;
#line 346 "vnc-display.c"
		}
	}
#line 97 "/extra-data/checkout/gnome/gnome-boxes/src/vnc-display.vala"
	_tmp9_ = uri;
#line 97 "/extra-data/checkout/gnome/gnome-boxes/src/vnc-display.vala"
	_tmp10_ = _tmp9_->server;
#line 97 "/extra-data/checkout/gnome/gnome-boxes/src/vnc-display.vala"
	_tmp11_ = g_strdup (_tmp10_);
#line 97 "/extra-data/checkout/gnome/gnome-boxes/src/vnc-display.vala"
	_g_free0 (self->priv->host);
#line 97 "/extra-data/checkout/gnome/gnome-boxes/src/vnc-display.vala"
	self->priv->host = _tmp11_;
#line 98 "/extra-data/checkout/gnome/gnome-boxes/src/vnc-display.vala"
	_tmp13_ = uri;
#line 98 "/extra-data/checkout/gnome/gnome-boxes/src/vnc-display.vala"
	_tmp14_ = _tmp13_->port;
#line 98 "/extra-data/checkout/gnome/gnome-boxes/src/vnc-display.vala"
	if (_tmp14_ <= 0) {
#line 98 "/extra-data/checkout/gnome/gnome-boxes/src/vnc-display.vala"
		_tmp12_ = 5900;
#line 367 "vnc-display.c"
	} else {
		xmlURI* _tmp15_;
		gint _tmp16_;
#line 98 "/extra-data/checkout/gnome/gnome-boxes/src/vnc-display.vala"
		_tmp15_ = uri;
#line 98 "/extra-data/checkout/gnome/gnome-boxes/src/vnc-display.vala"
		_tmp16_ = _tmp15_->port;
#line 98 "/extra-data/checkout/gnome/gnome-boxes/src/vnc-display.vala"
		_tmp12_ = _tmp16_;
#line 377 "vnc-display.c"
	}
#line 98 "/extra-data/checkout/gnome/gnome-boxes/src/vnc-display.vala"
	_tmp17_ = _tmp12_;
#line 98 "/extra-data/checkout/gnome/gnome-boxes/src/vnc-display.vala"
	self->priv->port = _tmp17_;
#line 86 "/extra-data/checkout/gnome/gnome-boxes/src/vnc-display.vala"
	_xmlFreeURI0 (uri);
#line 86 "/extra-data/checkout/gnome/gnome-boxes/src/vnc-display.vala"
	return self;
#line 387 "vnc-display.c"
}


BoxesVncDisplay* boxes_vnc_display_new_with_uri (BoxesBoxConfig* config, const gchar* _uri, GError** error) {
#line 86 "/extra-data/checkout/gnome/gnome-boxes/src/vnc-display.vala"
	return boxes_vnc_display_construct_with_uri (BOXES_TYPE_VNC_DISPLAY, config, _uri, error);
#line 394 "vnc-display.c"
}


static gpointer _g_object_ref0 (gpointer self) {
#line 104 "/extra-data/checkout/gnome/gnome-boxes/src/vnc-display.vala"
	return self ? g_object_ref (self) : NULL;
#line 401 "vnc-display.c"
}


static GtkWidget* boxes_vnc_display_real_get_display (BoxesDisplay* base, gint n) {
	BoxesVncDisplay * self;
	GtkWidget* result = NULL;
	GtkWindow* _tmp0_;
	VncDisplay* _tmp1_;
	VncDisplay* _tmp2_;
	GtkWidget* _tmp3_;
#line 101 "/extra-data/checkout/gnome/gnome-boxes/src/vnc-display.vala"
	self = (BoxesVncDisplay*) base;
#line 102 "/extra-data/checkout/gnome/gnome-boxes/src/vnc-display.vala"
	_tmp0_ = self->priv->window;
#line 102 "/extra-data/checkout/gnome/gnome-boxes/src/vnc-display.vala"
	_tmp1_ = self->priv->display;
#line 102 "/extra-data/checkout/gnome/gnome-boxes/src/vnc-display.vala"
	gtk_container_remove ((GtkContainer*) _tmp0_, (GtkWidget*) _tmp1_);
#line 104 "/extra-data/checkout/gnome/gnome-boxes/src/vnc-display.vala"
	_tmp2_ = self->priv->display;
#line 104 "/extra-data/checkout/gnome/gnome-boxes/src/vnc-display.vala"
	_tmp3_ = _g_object_ref0 ((GtkWidget*) _tmp2_);
#line 104 "/extra-data/checkout/gnome/gnome-boxes/src/vnc-display.vala"
	result = _tmp3_;
#line 104 "/extra-data/checkout/gnome/gnome-boxes/src/vnc-display.vala"
	return result;
#line 428 "vnc-display.c"
}


static void boxes_vnc_display_real_set_enable_audio (BoxesDisplay* base, gboolean enable) {
	BoxesVncDisplay * self;
#line 107 "/extra-data/checkout/gnome/gnome-boxes/src/vnc-display.vala"
	self = (BoxesVncDisplay*) base;
#line 436 "vnc-display.c"
}


static void boxes_vnc_display_real_set_enable_inputs (BoxesDisplay* base, GtkWidget* widget, gboolean enable) {
	BoxesVncDisplay * self;
	GtkWidget* _tmp0_;
	gboolean _tmp1_;
#line 110 "/extra-data/checkout/gnome/gnome-boxes/src/vnc-display.vala"
	self = (BoxesVncDisplay*) base;
#line 110 "/extra-data/checkout/gnome/gnome-boxes/src/vnc-display.vala"
	g_return_if_fail (widget != NULL);
#line 111 "/extra-data/checkout/gnome/gnome-boxes/src/vnc-display.vala"
	_tmp0_ = widget;
#line 111 "/extra-data/checkout/gnome/gnome-boxes/src/vnc-display.vala"
	_tmp1_ = enable;
#line 111 "/extra-data/checkout/gnome/gnome-boxes/src/vnc-display.vala"
	vnc_display_set_read_only (G_TYPE_CHECK_INSTANCE_TYPE (_tmp0_, vnc_display_get_type ()) ? ((VncDisplay*) _tmp0_) : NULL, !_tmp1_);
#line 454 "vnc-display.c"
}


static GdkPixbuf* boxes_vnc_display_real_get_pixbuf (BoxesDisplay* base, gint n, GError** error) {
	BoxesVncDisplay * self;
	GdkPixbuf* result = NULL;
	VncDisplay* _tmp0_;
	GdkPixbuf* _tmp1_ = NULL;
#line 114 "/extra-data/checkout/gnome/gnome-boxes/src/vnc-display.vala"
	self = (BoxesVncDisplay*) base;
#line 115 "/extra-data/checkout/gnome/gnome-boxes/src/vnc-display.vala"
	_tmp0_ = self->priv->display;
#line 115 "/extra-data/checkout/gnome/gnome-boxes/src/vnc-display.vala"
	_tmp1_ = vnc_display_get_pixbuf (_tmp0_);
#line 115 "/extra-data/checkout/gnome/gnome-boxes/src/vnc-display.vala"
	result = _tmp1_;
#line 115 "/extra-data/checkout/gnome/gnome-boxes/src/vnc-display.vala"
	return result;
#line 473 "vnc-display.c"
}


static void boxes_vnc_display_real_connect_it (BoxesDisplay* base, GError** error) {
	BoxesVncDisplay * self;
	gboolean _tmp0_;
	VncDisplay* _tmp1_;
	const gchar* _tmp2_;
	const gchar* _tmp3_;
	VncDisplay* _tmp4_;
	const gchar* _tmp5_;
	const gchar* _tmp6_;
	VncDisplay* _tmp7_;
	VncDisplay* _tmp8_;
	const gchar* _tmp9_;
	gint _tmp10_;
	gchar* _tmp11_ = NULL;
	gchar* _tmp12_;
#line 118 "/extra-data/checkout/gnome/gnome-boxes/src/vnc-display.vala"
	self = (BoxesVncDisplay*) base;
#line 120 "/extra-data/checkout/gnome/gnome-boxes/src/vnc-display.vala"
	_tmp0_ = self->priv->connected;
#line 120 "/extra-data/checkout/gnome/gnome-boxes/src/vnc-display.vala"
	if (_tmp0_) {
#line 121 "/extra-data/checkout/gnome/gnome-boxes/src/vnc-display.vala"
		return;
#line 500 "vnc-display.c"
	}
#line 122 "/extra-data/checkout/gnome/gnome-boxes/src/vnc-display.vala"
	self->priv->connected = TRUE;
#line 125 "/extra-data/checkout/gnome/gnome-boxes/src/vnc-display.vala"
	_tmp1_ = self->priv->display;
#line 125 "/extra-data/checkout/gnome/gnome-boxes/src/vnc-display.vala"
	_tmp2_ = boxes_display_get_username ((BoxesDisplay*) self);
#line 125 "/extra-data/checkout/gnome/gnome-boxes/src/vnc-display.vala"
	_tmp3_ = _tmp2_;
#line 125 "/extra-data/checkout/gnome/gnome-boxes/src/vnc-display.vala"
	vnc_display_set_credential (_tmp1_, (gint) VNC_DISPLAY_CREDENTIAL_USERNAME, _tmp3_);
#line 126 "/extra-data/checkout/gnome/gnome-boxes/src/vnc-display.vala"
	_tmp4_ = self->priv->display;
#line 126 "/extra-data/checkout/gnome/gnome-boxes/src/vnc-display.vala"
	_tmp5_ = boxes_display_get_password ((BoxesDisplay*) self);
#line 126 "/extra-data/checkout/gnome/gnome-boxes/src/vnc-display.vala"
	_tmp6_ = _tmp5_;
#line 126 "/extra-data/checkout/gnome/gnome-boxes/src/vnc-display.vala"
	vnc_display_set_credential (_tmp4_, (gint) VNC_DISPLAY_CREDENTIAL_PASSWORD, _tmp6_);
#line 127 "/extra-data/checkout/gnome/gnome-boxes/src/vnc-display.vala"
	_tmp7_ = self->priv->display;
#line 127 "/extra-data/checkout/gnome/gnome-boxes/src/vnc-display.vala"
	vnc_display_set_credential (_tmp7_, (gint) VNC_DISPLAY_CREDENTIAL_CLIENTNAME, "boxes");
#line 129 "/extra-data/checkout/gnome/gnome-boxes/src/vnc-display.vala"
	_tmp8_ = self->priv->display;
#line 129 "/extra-data/checkout/gnome/gnome-boxes/src/vnc-display.vala"
	_tmp9_ = self->priv->host;
#line 129 "/extra-data/checkout/gnome/gnome-boxes/src/vnc-display.vala"
	_tmp10_ = self->priv->port;
#line 129 "/extra-data/checkout/gnome/gnome-boxes/src/vnc-display.vala"
	_tmp11_ = g_strdup_printf ("%i", _tmp10_);
#line 129 "/extra-data/checkout/gnome/gnome-boxes/src/vnc-display.vala"
	_tmp12_ = _tmp11_;
#line 129 "/extra-data/checkout/gnome/gnome-boxes/src/vnc-display.vala"
	vnc_display_open_host (_tmp8_, _tmp9_, _tmp12_);
#line 129 "/extra-data/checkout/gnome/gnome-boxes/src/vnc-display.vala"
	_g_free0 (_tmp12_);
#line 538 "vnc-display.c"
}


static void boxes_vnc_display_real_disconnect_it (BoxesDisplay* base) {
	BoxesVncDisplay * self;
	VncDisplay* _tmp0_;
	gboolean _tmp1_ = FALSE;
#line 132 "/extra-data/checkout/gnome/gnome-boxes/src/vnc-display.vala"
	self = (BoxesVncDisplay*) base;
#line 133 "/extra-data/checkout/gnome/gnome-boxes/src/vnc-display.vala"
	_tmp0_ = self->priv->display;
#line 133 "/extra-data/checkout/gnome/gnome-boxes/src/vnc-display.vala"
	_tmp1_ = vnc_display_is_open (_tmp0_);
#line 133 "/extra-data/checkout/gnome/gnome-boxes/src/vnc-display.vala"
	if (_tmp1_) {
#line 554 "vnc-display.c"
		VncDisplay* _tmp2_;
#line 134 "/extra-data/checkout/gnome/gnome-boxes/src/vnc-display.vala"
		_tmp2_ = self->priv->display;
#line 134 "/extra-data/checkout/gnome/gnome-boxes/src/vnc-display.vala"
		vnc_display_close (_tmp2_);
#line 560 "vnc-display.c"
	}
}


static void _g_object_unref0_ (gpointer var) {
#line 137 "/extra-data/checkout/gnome/gnome-boxes/src/vnc-display.vala"
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
#line 568 "vnc-display.c"
}


static void _g_list_free__g_object_unref0_ (GList* self) {
#line 137 "/extra-data/checkout/gnome/gnome-boxes/src/vnc-display.vala"
	g_list_foreach (self, (GFunc) _g_object_unref0_, NULL);
#line 137 "/extra-data/checkout/gnome/gnome-boxes/src/vnc-display.vala"
	g_list_free (self);
#line 577 "vnc-display.c"
}


static GList* boxes_vnc_display_real_get_properties (BoxesDisplay* base, BoxesPropertiesPage page, PropertyCreationFlag flags) {
	BoxesVncDisplay * self;
	GList* result = NULL;
	GList* list;
	BoxesPropertiesPage _tmp0_;
#line 137 "/extra-data/checkout/gnome/gnome-boxes/src/vnc-display.vala"
	self = (BoxesVncDisplay*) base;
#line 138 "/extra-data/checkout/gnome/gnome-boxes/src/vnc-display.vala"
	list = NULL;
#line 140 "/extra-data/checkout/gnome/gnome-boxes/src/vnc-display.vala"
	_tmp0_ = page;
#line 140 "/extra-data/checkout/gnome/gnome-boxes/src/vnc-display.vala"
	switch (_tmp0_) {
#line 140 "/extra-data/checkout/gnome/gnome-boxes/src/vnc-display.vala"
		case BOXES_PROPERTIES_PAGE_DISPLAY:
#line 596 "vnc-display.c"
		{
			GtkSwitch* _tmp1_;
			GtkSwitch* toggle;
			VncDisplay* _tmp2_;
			GtkSwitch* _tmp3_;
			const gchar* _tmp4_ = NULL;
			GtkSwitch* _tmp5_;
			BoxesProperty* _tmp6_ = NULL;
			BoxesProperty* _tmp7_;
#line 142 "/extra-data/checkout/gnome/gnome-boxes/src/vnc-display.vala"
			_tmp1_ = (GtkSwitch*) gtk_switch_new ();
#line 142 "/extra-data/checkout/gnome/gnome-boxes/src/vnc-display.vala"
			g_object_ref_sink (_tmp1_);
#line 142 "/extra-data/checkout/gnome/gnome-boxes/src/vnc-display.vala"
			toggle = _tmp1_;
#line 143 "/extra-data/checkout/gnome/gnome-boxes/src/vnc-display.vala"
			_tmp2_ = self->priv->display;
#line 143 "/extra-data/checkout/gnome/gnome-boxes/src/vnc-display.vala"
			_tmp3_ = toggle;
#line 143 "/extra-data/checkout/gnome/gnome-boxes/src/vnc-display.vala"
			g_object_bind_property_with_closures ((GObject*) _tmp2_, "read-only", (GObject*) _tmp3_, "active", G_BINDING_BIDIRECTIONAL | G_BINDING_SYNC_CREATE, (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, NULL)), (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, NULL)));
#line 145 "/extra-data/checkout/gnome/gnome-boxes/src/vnc-display.vala"
			_tmp4_ = _ ("Read-only");
#line 145 "/extra-data/checkout/gnome/gnome-boxes/src/vnc-display.vala"
			_tmp5_ = toggle;
#line 145 "/extra-data/checkout/gnome/gnome-boxes/src/vnc-display.vala"
			_tmp6_ = boxes_iproperties_provider_add_property ((BoxesIPropertiesProvider*) self, &list, _tmp4_, (GtkWidget*) _tmp5_, NULL);
#line 145 "/extra-data/checkout/gnome/gnome-boxes/src/vnc-display.vala"
			_tmp7_ = _tmp6_;
#line 145 "/extra-data/checkout/gnome/gnome-boxes/src/vnc-display.vala"
			_g_object_unref0 (_tmp7_);
#line 146 "/extra-data/checkout/gnome/gnome-boxes/src/vnc-display.vala"
			_g_object_unref0 (toggle);
#line 146 "/extra-data/checkout/gnome/gnome-boxes/src/vnc-display.vala"
			break;
#line 632 "vnc-display.c"
		}
		default:
#line 140 "/extra-data/checkout/gnome/gnome-boxes/src/vnc-display.vala"
		break;
#line 637 "vnc-display.c"
	}
#line 149 "/extra-data/checkout/gnome/gnome-boxes/src/vnc-display.vala"
	result = list;
#line 149 "/extra-data/checkout/gnome/gnome-boxes/src/vnc-display.vala"
	return result;
#line 643 "vnc-display.c"
}


static const gchar* boxes_vnc_display_real_get_protocol (BoxesDisplay* base) {
	const gchar* result;
	BoxesVncDisplay* self;
#line 6 "/extra-data/checkout/gnome/gnome-boxes/src/vnc-display.vala"
	self = (BoxesVncDisplay*) base;
#line 6 "/extra-data/checkout/gnome/gnome-boxes/src/vnc-display.vala"
	result = "VNC";
#line 6 "/extra-data/checkout/gnome/gnome-boxes/src/vnc-display.vala"
	return result;
#line 656 "vnc-display.c"
}


static const gchar* string_to_string (const gchar* self) {
	const gchar* result = NULL;
#line 1264 "/home/zeenix/jhbuild/share/vala-0.20/vapi/glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, NULL);
#line 1265 "/home/zeenix/jhbuild/share/vala-0.20/vapi/glib-2.0.vapi"
	result = self;
#line 1265 "/home/zeenix/jhbuild/share/vala-0.20/vapi/glib-2.0.vapi"
	return result;
#line 668 "vnc-display.c"
}


static gchar* boxes_vnc_display_real_get_uri (BoxesDisplay* base) {
	gchar* result;
	BoxesVncDisplay* self;
	const gchar* _tmp0_;
	const gchar* _tmp1_ = NULL;
	gint _tmp2_;
	gchar* _tmp3_ = NULL;
	gchar* _tmp4_;
	gchar* _tmp5_ = NULL;
	gchar* _tmp6_;
#line 7 "/extra-data/checkout/gnome/gnome-boxes/src/vnc-display.vala"
	self = (BoxesVncDisplay*) base;
#line 7 "/extra-data/checkout/gnome/gnome-boxes/src/vnc-display.vala"
	_tmp0_ = self->priv->host;
#line 7 "/extra-data/checkout/gnome/gnome-boxes/src/vnc-display.vala"
	_tmp1_ = string_to_string (_tmp0_);
#line 7 "/extra-data/checkout/gnome/gnome-boxes/src/vnc-display.vala"
	_tmp2_ = self->priv->port;
#line 7 "/extra-data/checkout/gnome/gnome-boxes/src/vnc-display.vala"
	_tmp3_ = g_strdup_printf ("%i", _tmp2_);
#line 7 "/extra-data/checkout/gnome/gnome-boxes/src/vnc-display.vala"
	_tmp4_ = _tmp3_;
#line 7 "/extra-data/checkout/gnome/gnome-boxes/src/vnc-display.vala"
	_tmp5_ = g_strconcat ("vnc://", _tmp1_, ":", _tmp4_, NULL);
#line 7 "/extra-data/checkout/gnome/gnome-boxes/src/vnc-display.vala"
	_tmp6_ = _tmp5_;
#line 7 "/extra-data/checkout/gnome/gnome-boxes/src/vnc-display.vala"
	_g_free0 (_tmp4_);
#line 7 "/extra-data/checkout/gnome/gnome-boxes/src/vnc-display.vala"
	result = _tmp6_;
#line 7 "/extra-data/checkout/gnome/gnome-boxes/src/vnc-display.vala"
	return result;
#line 704 "vnc-display.c"
}


static void _boxes_vnc_display___lambda97_ (BoxesVncDisplay* self) {
#line 34 "/extra-data/checkout/gnome/gnome-boxes/src/vnc-display.vala"
	g_signal_emit_by_name ((BoxesDisplay*) self, "show", 0);
#line 35 "/extra-data/checkout/gnome/gnome-boxes/src/vnc-display.vala"
	boxes_display_access_start ((BoxesDisplay*) self);
#line 713 "vnc-display.c"
}


static void __boxes_vnc_display___lambda97__vnc_display_vnc_initialized (VncDisplay* _sender, gpointer self) {
#line 33 "/extra-data/checkout/gnome/gnome-boxes/src/vnc-display.vala"
	_boxes_vnc_display___lambda97_ (self);
#line 720 "vnc-display.c"
}


static void _boxes_vnc_display___lambda98_ (BoxesVncDisplay* self) {
#line 38 "/extra-data/checkout/gnome/gnome-boxes/src/vnc-display.vala"
	g_signal_emit_by_name ((BoxesDisplay*) self, "hide", 0);
#line 39 "/extra-data/checkout/gnome/gnome-boxes/src/vnc-display.vala"
	boxes_display_access_finish ((BoxesDisplay*) self);
#line 729 "vnc-display.c"
}


static void __boxes_vnc_display___lambda98__vnc_display_vnc_disconnected (VncDisplay* _sender, gpointer self) {
#line 37 "/extra-data/checkout/gnome/gnome-boxes/src/vnc-display.vala"
	_boxes_vnc_display___lambda98_ (self);
#line 736 "vnc-display.c"
}


static void _boxes_vnc_display___lambda99_ (BoxesVncDisplay* self) {
#line 43 "/extra-data/checkout/gnome/gnome-boxes/src/vnc-display.vala"
	g_debug ("vnc-display.vala:43: auth failure");
#line 743 "vnc-display.c"
}


static void __boxes_vnc_display___lambda99__vnc_display_vnc_auth_failure (VncDisplay* _sender, const gchar* object, gpointer self) {
#line 42 "/extra-data/checkout/gnome/gnome-boxes/src/vnc-display.vala"
	_boxes_vnc_display___lambda99_ (self);
#line 750 "vnc-display.c"
}


static void _boxes_vnc_display___lambda100_ (BoxesVncDisplay* self) {
#line 46 "/extra-data/checkout/gnome/gnome-boxes/src/vnc-display.vala"
	g_debug ("vnc-display.vala:46: auth unsupported");
#line 757 "vnc-display.c"
}


static void __boxes_vnc_display___lambda100__vnc_display_vnc_auth_unsupported (VncDisplay* _sender, guint object, gpointer self) {
#line 45 "/extra-data/checkout/gnome/gnome-boxes/src/vnc-display.vala"
	_boxes_vnc_display___lambda100_ (self);
#line 764 "vnc-display.c"
}


static VncDisplayCredential* _vnc_display_credential_dup (VncDisplayCredential* self) {
	VncDisplayCredential* dup;
#line 51 "/extra-data/checkout/gnome/gnome-boxes/src/vnc-display.vala"
	dup = g_new0 (VncDisplayCredential, 1);
#line 51 "/extra-data/checkout/gnome/gnome-boxes/src/vnc-display.vala"
	memcpy (dup, self, sizeof (VncDisplayCredential));
#line 51 "/extra-data/checkout/gnome/gnome-boxes/src/vnc-display.vala"
	return dup;
#line 776 "vnc-display.c"
}


static gpointer __vnc_display_credential_dup0 (gpointer self) {
#line 51 "/extra-data/checkout/gnome/gnome-boxes/src/vnc-display.vala"
	return self ? _vnc_display_credential_dup (self) : NULL;
#line 783 "vnc-display.c"
}


static void _boxes_vnc_display___lambda101_ (BoxesVncDisplay* self, VncDisplay* vnc, GValueArray* creds) {
	GValueArray* _tmp0_;
	VncDisplay* _tmp8_;
#line 49 "/extra-data/checkout/gnome/gnome-boxes/src/vnc-display.vala"
	g_return_if_fail (vnc != NULL);
#line 49 "/extra-data/checkout/gnome/gnome-boxes/src/vnc-display.vala"
	g_return_if_fail (creds != NULL);
#line 50 "/extra-data/checkout/gnome/gnome-boxes/src/vnc-display.vala"
	_tmp0_ = creds;
#line 796 "vnc-display.c"
	{
		GValueArray* cred_collection = NULL;
		guint cred_index = 0U;
#line 50 "/extra-data/checkout/gnome/gnome-boxes/src/vnc-display.vala"
		cred_collection = _tmp0_;
#line 50 "/extra-data/checkout/gnome/gnome-boxes/src/vnc-display.vala"
		for (cred_index = 0; cred_index < cred_collection->n_values; cred_index = cred_index + 1) {
#line 804 "vnc-display.c"
			GValue cred = {0};
#line 50 "/extra-data/checkout/gnome/gnome-boxes/src/vnc-display.vala"
			cred = *g_value_array_get_nth (cred_collection, cred_index);
#line 808 "vnc-display.c"
			{
				GValue _tmp1_;
				VncDisplayCredential* _tmp2_;
				VncDisplayCredential* credential;
				VncDisplayCredential* _tmp3_;
#line 51 "/extra-data/checkout/gnome/gnome-boxes/src/vnc-display.vala"
				_tmp1_ = cred;
#line 51 "/extra-data/checkout/gnome/gnome-boxes/src/vnc-display.vala"
				_tmp2_ = __vnc_display_credential_dup0 (g_value_get_enum (&_tmp1_));
#line 51 "/extra-data/checkout/gnome/gnome-boxes/src/vnc-display.vala"
				credential = _tmp2_;
#line 53 "/extra-data/checkout/gnome/gnome-boxes/src/vnc-display.vala"
				_tmp3_ = credential;
#line 53 "/extra-data/checkout/gnome/gnome-boxes/src/vnc-display.vala"
				switch (*_tmp3_) {
#line 53 "/extra-data/checkout/gnome/gnome-boxes/src/vnc-display.vala"
					case VNC_DISPLAY_CREDENTIAL_USERNAME:
#line 826 "vnc-display.c"
					{
#line 55 "/extra-data/checkout/gnome/gnome-boxes/src/vnc-display.vala"
						boxes_display_set_need_username ((BoxesDisplay*) self, TRUE);
#line 56 "/extra-data/checkout/gnome/gnome-boxes/src/vnc-display.vala"
						break;
#line 832 "vnc-display.c"
					}
#line 53 "/extra-data/checkout/gnome/gnome-boxes/src/vnc-display.vala"
					case VNC_DISPLAY_CREDENTIAL_PASSWORD:
#line 836 "vnc-display.c"
					{
#line 59 "/extra-data/checkout/gnome/gnome-boxes/src/vnc-display.vala"
						boxes_display_set_need_password ((BoxesDisplay*) self, TRUE);
#line 60 "/extra-data/checkout/gnome/gnome-boxes/src/vnc-display.vala"
						break;
#line 842 "vnc-display.c"
					}
#line 53 "/extra-data/checkout/gnome/gnome-boxes/src/vnc-display.vala"
					case VNC_DISPLAY_CREDENTIAL_CLIENTNAME:
#line 846 "vnc-display.c"
					{
#line 63 "/extra-data/checkout/gnome/gnome-boxes/src/vnc-display.vala"
						break;
#line 850 "vnc-display.c"
					}
					default:
					{
						VncDisplayCredential* _tmp4_;
						GEnumValue* _tmp5_;
						gchar* _tmp6_ = NULL;
						gchar* _tmp7_;
#line 66 "/extra-data/checkout/gnome/gnome-boxes/src/vnc-display.vala"
						_tmp4_ = credential;
#line 66 "/extra-data/checkout/gnome/gnome-boxes/src/vnc-display.vala"
						_tmp5_ = g_enum_get_value (g_type_class_ref (vnc_display_credential_get_type ()), *_tmp4_);
#line 66 "/extra-data/checkout/gnome/gnome-boxes/src/vnc-display.vala"
						_tmp6_ = g_strdup_printf ("Unsupported credential: %s", (_tmp5_ != NULL) ? _tmp5_->value_name : NULL);
#line 66 "/extra-data/checkout/gnome/gnome-boxes/src/vnc-display.vala"
						_tmp7_ = _tmp6_;
#line 66 "/extra-data/checkout/gnome/gnome-boxes/src/vnc-display.vala"
						g_debug ("vnc-display.vala:66: %s", _tmp7_);
#line 66 "/extra-data/checkout/gnome/gnome-boxes/src/vnc-display.vala"
						_g_free0 (_tmp7_);
#line 67 "/extra-data/checkout/gnome/gnome-boxes/src/vnc-display.vala"
						break;
#line 872 "vnc-display.c"
					}
				}
#line 50 "/extra-data/checkout/gnome/gnome-boxes/src/vnc-display.vala"
				_g_free0 (credential);
#line 877 "vnc-display.c"
			}
		}
	}
#line 71 "/extra-data/checkout/gnome/gnome-boxes/src/vnc-display.vala"
	_tmp8_ = self->priv->display;
#line 71 "/extra-data/checkout/gnome/gnome-boxes/src/vnc-display.vala"
	vnc_display_close (_tmp8_);
#line 885 "vnc-display.c"
}


static void __boxes_vnc_display___lambda101__vnc_display_vnc_auth_credential (VncDisplay* _sender, GValueArray* credList, gpointer self) {
#line 49 "/extra-data/checkout/gnome/gnome-boxes/src/vnc-display.vala"
	_boxes_vnc_display___lambda101_ (self, _sender, credList);
#line 892 "vnc-display.c"
}


static void _boxes_vnc_display___lambda102_ (BoxesVncDisplay* self) {
	BoxesBoxConfig* _tmp0_;
	BoxesBoxConfig* _tmp1_;
	VncDisplay* _tmp2_;
	BoxesBoxConfigSyncProperty* _tmp3_;
	gint _tmp3__length1;
#line 75 "/extra-data/checkout/gnome/gnome-boxes/src/vnc-display.vala"
	_tmp0_ = boxes_display_get_config ((BoxesDisplay*) self);
#line 75 "/extra-data/checkout/gnome/gnome-boxes/src/vnc-display.vala"
	_tmp1_ = _tmp0_;
#line 75 "/extra-data/checkout/gnome/gnome-boxes/src/vnc-display.vala"
	_tmp2_ = self->priv->display;
#line 75 "/extra-data/checkout/gnome/gnome-boxes/src/vnc-display.vala"
	_tmp3_ = self->priv->sync_properties;
#line 75 "/extra-data/checkout/gnome/gnome-boxes/src/vnc-display.vala"
	_tmp3__length1 = self->priv->sync_properties_length1;
#line 75 "/extra-data/checkout/gnome/gnome-boxes/src/vnc-display.vala"
	boxes_box_config_sync_properties (_tmp1_, (GObject*) _tmp2_, _tmp3_, _tmp3__length1);
#line 914 "vnc-display.c"
}


static void __boxes_vnc_display___lambda102__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self) {
#line 74 "/extra-data/checkout/gnome/gnome-boxes/src/vnc-display.vala"
	_boxes_vnc_display___lambda102_ (self);
#line 921 "vnc-display.c"
}


static GObject * boxes_vnc_display_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties) {
	GObject * obj;
	GObjectClass * parent_class;
	BoxesVncDisplay * self;
	gchar* _tmp0_;
	GValue _tmp1_ = {0};
	BoxesBoxConfigSyncProperty _tmp2_ = {0};
	BoxesBoxConfigSyncProperty* _tmp3_ = NULL;
	VncDisplay* _tmp4_;
	VncDisplay* _tmp5_;
	VncDisplay* _tmp6_;
	VncDisplay* _tmp7_;
	VncDisplay* _tmp8_;
	GtkWindow* _tmp9_;
	GtkWindow* _tmp10_;
	VncDisplay* _tmp11_;
	VncDisplay* _tmp12_;
	VncDisplay* _tmp13_;
	VncDisplay* _tmp14_;
	VncDisplay* _tmp15_;
	VncDisplay* _tmp16_;
	VncDisplay* _tmp17_;
#line 15 "/extra-data/checkout/gnome/gnome-boxes/src/vnc-display.vala"
	parent_class = G_OBJECT_CLASS (boxes_vnc_display_parent_class);
#line 15 "/extra-data/checkout/gnome/gnome-boxes/src/vnc-display.vala"
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
#line 15 "/extra-data/checkout/gnome/gnome-boxes/src/vnc-display.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, BOXES_TYPE_VNC_DISPLAY, BoxesVncDisplay);
#line 16 "/extra-data/checkout/gnome/gnome-boxes/src/vnc-display.vala"
	_tmp0_ = g_strdup ("read-only");
#line 16 "/extra-data/checkout/gnome/gnome-boxes/src/vnc-display.vala"
	g_value_init (&_tmp1_, G_TYPE_BOOLEAN);
#line 16 "/extra-data/checkout/gnome/gnome-boxes/src/vnc-display.vala"
	g_value_set_boolean (&_tmp1_, FALSE);
#line 16 "/extra-data/checkout/gnome/gnome-boxes/src/vnc-display.vala"
	memset (&_tmp2_, 0, sizeof (BoxesBoxConfigSyncProperty));
#line 16 "/extra-data/checkout/gnome/gnome-boxes/src/vnc-display.vala"
	_g_free0 (_tmp2_.name);
#line 16 "/extra-data/checkout/gnome/gnome-boxes/src/vnc-display.vala"
	_tmp2_.name = _tmp0_;
#line 16 "/extra-data/checkout/gnome/gnome-boxes/src/vnc-display.vala"
	G_IS_VALUE (&_tmp2_.default_value) ? (g_value_unset (&_tmp2_.default_value), NULL) : NULL;
#line 16 "/extra-data/checkout/gnome/gnome-boxes/src/vnc-display.vala"
	_tmp2_.default_value = _tmp1_;
#line 16 "/extra-data/checkout/gnome/gnome-boxes/src/vnc-display.vala"
	_tmp3_ = g_new0 (BoxesBoxConfigSyncProperty, 1);
#line 16 "/extra-data/checkout/gnome/gnome-boxes/src/vnc-display.vala"
	_tmp3_[0] = _tmp2_;
#line 16 "/extra-data/checkout/gnome/gnome-boxes/src/vnc-display.vala"
	self->priv->sync_properties = (_vala_BoxesBoxConfigSyncProperty_array_free (self->priv->sync_properties, self->priv->sync_properties_length1), NULL);
#line 16 "/extra-data/checkout/gnome/gnome-boxes/src/vnc-display.vala"
	self->priv->sync_properties = _tmp3_;
#line 16 "/extra-data/checkout/gnome/gnome-boxes/src/vnc-display.vala"
	self->priv->sync_properties_length1 = 1;
#line 16 "/extra-data/checkout/gnome/gnome-boxes/src/vnc-display.vala"
	self->priv->_sync_properties_size_ = self->priv->sync_properties_length1;
#line 19 "/extra-data/checkout/gnome/gnome-boxes/src/vnc-display.vala"
	boxes_display_set_need_password ((BoxesDisplay*) self, FALSE);
#line 21 "/extra-data/checkout/gnome/gnome-boxes/src/vnc-display.vala"
	_tmp4_ = (VncDisplay*) vnc_display_new ();
#line 21 "/extra-data/checkout/gnome/gnome-boxes/src/vnc-display.vala"
	g_object_ref_sink (_tmp4_);
#line 21 "/extra-data/checkout/gnome/gnome-boxes/src/vnc-display.vala"
	_g_object_unref0 (self->priv->display);
#line 21 "/extra-data/checkout/gnome/gnome-boxes/src/vnc-display.vala"
	self->priv->display = _tmp4_;
#line 22 "/extra-data/checkout/gnome/gnome-boxes/src/vnc-display.vala"
	_tmp5_ = self->priv->display;
#line 22 "/extra-data/checkout/gnome/gnome-boxes/src/vnc-display.vala"
	vnc_display_set_keyboard_grab (_tmp5_, TRUE);
#line 23 "/extra-data/checkout/gnome/gnome-boxes/src/vnc-display.vala"
	_tmp6_ = self->priv->display;
#line 23 "/extra-data/checkout/gnome/gnome-boxes/src/vnc-display.vala"
	vnc_display_set_pointer_grab (_tmp6_, TRUE);
#line 24 "/extra-data/checkout/gnome/gnome-boxes/src/vnc-display.vala"
	_tmp7_ = self->priv->display;
#line 24 "/extra-data/checkout/gnome/gnome-boxes/src/vnc-display.vala"
	vnc_display_set_force_size (_tmp7_, FALSE);
#line 25 "/extra-data/checkout/gnome/gnome-boxes/src/vnc-display.vala"
	_tmp8_ = self->priv->display;
#line 25 "/extra-data/checkout/gnome/gnome-boxes/src/vnc-display.vala"
	vnc_display_set_scaling (_tmp8_, TRUE);
#line 29 "/extra-data/checkout/gnome/gnome-boxes/src/vnc-display.vala"
	_tmp9_ = (GtkWindow*) gtk_window_new (GTK_WINDOW_TOPLEVEL);
#line 29 "/extra-data/checkout/gnome/gnome-boxes/src/vnc-display.vala"
	g_object_ref_sink (_tmp9_);
#line 29 "/extra-data/checkout/gnome/gnome-boxes/src/vnc-display.vala"
	_g_object_unref0 (self->priv->window);
#line 29 "/extra-data/checkout/gnome/gnome-boxes/src/vnc-display.vala"
	self->priv->window = _tmp9_;
#line 30 "/extra-data/checkout/gnome/gnome-boxes/src/vnc-display.vala"
	_tmp10_ = self->priv->window;
#line 30 "/extra-data/checkout/gnome/gnome-boxes/src/vnc-display.vala"
	_tmp11_ = self->priv->display;
#line 30 "/extra-data/checkout/gnome/gnome-boxes/src/vnc-display.vala"
	gtk_container_add ((GtkContainer*) _tmp10_, (GtkWidget*) _tmp11_);
#line 31 "/extra-data/checkout/gnome/gnome-boxes/src/vnc-display.vala"
	_tmp12_ = self->priv->display;
#line 31 "/extra-data/checkout/gnome/gnome-boxes/src/vnc-display.vala"
	gtk_widget_realize ((GtkWidget*) _tmp12_);
#line 33 "/extra-data/checkout/gnome/gnome-boxes/src/vnc-display.vala"
	_tmp13_ = self->priv->display;
#line 33 "/extra-data/checkout/gnome/gnome-boxes/src/vnc-display.vala"
	g_signal_connect_object (_tmp13_, "vnc-initialized", (GCallback) __boxes_vnc_display___lambda97__vnc_display_vnc_initialized, self, 0);
#line 37 "/extra-data/checkout/gnome/gnome-boxes/src/vnc-display.vala"
	_tmp14_ = self->priv->display;
#line 37 "/extra-data/checkout/gnome/gnome-boxes/src/vnc-display.vala"
	g_signal_connect_object (_tmp14_, "vnc-disconnected", (GCallback) __boxes_vnc_display___lambda98__vnc_display_vnc_disconnected, self, 0);
#line 42 "/extra-data/checkout/gnome/gnome-boxes/src/vnc-display.vala"
	_tmp15_ = self->priv->display;
#line 42 "/extra-data/checkout/gnome/gnome-boxes/src/vnc-display.vala"
	g_signal_connect_object (_tmp15_, "vnc-auth-failure", (GCallback) __boxes_vnc_display___lambda99__vnc_display_vnc_auth_failure, self, 0);
#line 45 "/extra-data/checkout/gnome/gnome-boxes/src/vnc-display.vala"
	_tmp16_ = self->priv->display;
#line 45 "/extra-data/checkout/gnome/gnome-boxes/src/vnc-display.vala"
	g_signal_connect_object (_tmp16_, "vnc-auth-unsupported", (GCallback) __boxes_vnc_display___lambda100__vnc_display_vnc_auth_unsupported, self, 0);
#line 49 "/extra-data/checkout/gnome/gnome-boxes/src/vnc-display.vala"
	_tmp17_ = self->priv->display;
#line 49 "/extra-data/checkout/gnome/gnome-boxes/src/vnc-display.vala"
	g_signal_connect_object (_tmp17_, "vnc-auth-credential", (GCallback) __boxes_vnc_display___lambda101__vnc_display_vnc_auth_credential, self, 0);
#line 74 "/extra-data/checkout/gnome/gnome-boxes/src/vnc-display.vala"
	g_signal_connect_object ((GObject*) self, "notify::config", (GCallback) __boxes_vnc_display___lambda102__g_object_notify, self, 0);
#line 15 "/extra-data/checkout/gnome/gnome-boxes/src/vnc-display.vala"
	return obj;
#line 1049 "vnc-display.c"
}


static void boxes_vnc_display_class_init (BoxesVncDisplayClass * klass) {
#line 5 "/extra-data/checkout/gnome/gnome-boxes/src/vnc-display.vala"
	boxes_vnc_display_parent_class = g_type_class_peek_parent (klass);
#line 5 "/extra-data/checkout/gnome/gnome-boxes/src/vnc-display.vala"
	g_type_class_add_private (klass, sizeof (BoxesVncDisplayPrivate));
#line 5 "/extra-data/checkout/gnome/gnome-boxes/src/vnc-display.vala"
	BOXES_DISPLAY_CLASS (klass)->get_display = boxes_vnc_display_real_get_display;
#line 5 "/extra-data/checkout/gnome/gnome-boxes/src/vnc-display.vala"
	BOXES_DISPLAY_CLASS (klass)->set_enable_audio = boxes_vnc_display_real_set_enable_audio;
#line 5 "/extra-data/checkout/gnome/gnome-boxes/src/vnc-display.vala"
	BOXES_DISPLAY_CLASS (klass)->set_enable_inputs = boxes_vnc_display_real_set_enable_inputs;
#line 5 "/extra-data/checkout/gnome/gnome-boxes/src/vnc-display.vala"
	BOXES_DISPLAY_CLASS (klass)->get_pixbuf = boxes_vnc_display_real_get_pixbuf;
#line 5 "/extra-data/checkout/gnome/gnome-boxes/src/vnc-display.vala"
	BOXES_DISPLAY_CLASS (klass)->connect_it = boxes_vnc_display_real_connect_it;
#line 5 "/extra-data/checkout/gnome/gnome-boxes/src/vnc-display.vala"
	BOXES_DISPLAY_CLASS (klass)->disconnect_it = boxes_vnc_display_real_disconnect_it;
#line 5 "/extra-data/checkout/gnome/gnome-boxes/src/vnc-display.vala"
	BOXES_DISPLAY_CLASS (klass)->get_properties = boxes_vnc_display_real_get_properties;
#line 5 "/extra-data/checkout/gnome/gnome-boxes/src/vnc-display.vala"
	BOXES_DISPLAY_CLASS (klass)->get_protocol = boxes_vnc_display_real_get_protocol;
#line 5 "/extra-data/checkout/gnome/gnome-boxes/src/vnc-display.vala"
	BOXES_DISPLAY_CLASS (klass)->get_uri = boxes_vnc_display_real_get_uri;
#line 5 "/extra-data/checkout/gnome/gnome-boxes/src/vnc-display.vala"
	G_OBJECT_CLASS (klass)->get_property = _vala_boxes_vnc_display_get_property;
#line 5 "/extra-data/checkout/gnome/gnome-boxes/src/vnc-display.vala"
	G_OBJECT_CLASS (klass)->constructor = boxes_vnc_display_constructor;
#line 5 "/extra-data/checkout/gnome/gnome-boxes/src/vnc-display.vala"
	G_OBJECT_CLASS (klass)->finalize = boxes_vnc_display_finalize;
#line 5 "/extra-data/checkout/gnome/gnome-boxes/src/vnc-display.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), BOXES_VNC_DISPLAY_PROTOCOL, g_param_spec_string ("protocol", "protocol", "protocol", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
#line 5 "/extra-data/checkout/gnome/gnome-boxes/src/vnc-display.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), BOXES_VNC_DISPLAY_URI, g_param_spec_string ("uri", "uri", "uri", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
#line 1086 "vnc-display.c"
}


static void boxes_vnc_display_instance_init (BoxesVncDisplay * self) {
#line 5 "/extra-data/checkout/gnome/gnome-boxes/src/vnc-display.vala"
	self->priv = BOXES_VNC_DISPLAY_GET_PRIVATE (self);
#line 1093 "vnc-display.c"
}


static void boxes_vnc_display_finalize (GObject* obj) {
	BoxesVncDisplay * self;
#line 5 "/extra-data/checkout/gnome/gnome-boxes/src/vnc-display.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, BOXES_TYPE_VNC_DISPLAY, BoxesVncDisplay);
#line 8 "/extra-data/checkout/gnome/gnome-boxes/src/vnc-display.vala"
	_g_object_unref0 (self->priv->display);
#line 9 "/extra-data/checkout/gnome/gnome-boxes/src/vnc-display.vala"
	_g_free0 (self->priv->host);
#line 11 "/extra-data/checkout/gnome/gnome-boxes/src/vnc-display.vala"
	_g_object_unref0 (self->priv->window);
#line 12 "/extra-data/checkout/gnome/gnome-boxes/src/vnc-display.vala"
	self->priv->sync_properties = (_vala_BoxesBoxConfigSyncProperty_array_free (self->priv->sync_properties, self->priv->sync_properties_length1), NULL);
#line 5 "/extra-data/checkout/gnome/gnome-boxes/src/vnc-display.vala"
	G_OBJECT_CLASS (boxes_vnc_display_parent_class)->finalize (obj);
#line 1111 "vnc-display.c"
}


GType boxes_vnc_display_get_type (void) {
	static volatile gsize boxes_vnc_display_type_id__volatile = 0;
	if (g_once_init_enter (&boxes_vnc_display_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (BoxesVncDisplayClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) boxes_vnc_display_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (BoxesVncDisplay), 0, (GInstanceInitFunc) boxes_vnc_display_instance_init, NULL };
		GType boxes_vnc_display_type_id;
		boxes_vnc_display_type_id = g_type_register_static (BOXES_TYPE_DISPLAY, "BoxesVncDisplay", &g_define_type_info, 0);
		g_once_init_leave (&boxes_vnc_display_type_id__volatile, boxes_vnc_display_type_id);
	}
	return boxes_vnc_display_type_id__volatile;
}


static void _vala_boxes_vnc_display_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	BoxesVncDisplay * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, BOXES_TYPE_VNC_DISPLAY, BoxesVncDisplay);
#line 5 "/extra-data/checkout/gnome/gnome-boxes/src/vnc-display.vala"
	switch (property_id) {
#line 5 "/extra-data/checkout/gnome/gnome-boxes/src/vnc-display.vala"
		case BOXES_VNC_DISPLAY_PROTOCOL:
#line 5 "/extra-data/checkout/gnome/gnome-boxes/src/vnc-display.vala"
		g_value_set_string (value, boxes_display_get_protocol ((BoxesDisplay*) self));
#line 5 "/extra-data/checkout/gnome/gnome-boxes/src/vnc-display.vala"
		break;
#line 5 "/extra-data/checkout/gnome/gnome-boxes/src/vnc-display.vala"
		case BOXES_VNC_DISPLAY_URI:
#line 5 "/extra-data/checkout/gnome/gnome-boxes/src/vnc-display.vala"
		g_value_take_string (value, boxes_display_get_uri ((BoxesDisplay*) self));
#line 5 "/extra-data/checkout/gnome/gnome-boxes/src/vnc-display.vala"
		break;
#line 1144 "vnc-display.c"
		default:
#line 5 "/extra-data/checkout/gnome/gnome-boxes/src/vnc-display.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 5 "/extra-data/checkout/gnome/gnome-boxes/src/vnc-display.vala"
		break;
#line 1150 "vnc-display.c"
	}
}



