AM_CONDITIONAL([ENABLE_DEBUG], [test "$enable_debug" = "yes"])
m4_define([gtk_required_version], [3.16.1])
m4_define([glib_required_version], [2.44.0])
m4_define([gtksourceview_required_version], [3.16.1])
m4_define([ggit_required_version], [0.22.6])
m4_define([gjs_required_version], [1.42.0])
m4_define([pygobject_required_version], [3.0.0])
m4_define([devhelp_required_version], [3.16.0])

PKG_CHECK_MODULES(BUILDER, [gtk+-3.0 >= gtk_required_version
                            gio-2.0 >= glib_required_version
                            gtksourceview-3.0 >= gtksourceview_required_version
                            libdevhelp-3.0 >= devhelp_required_version
                            libgit2-glib-1.0 >= ggit_required_version])

PKG_CHECK_MODULES(LIBIDE, [gio-2.0 >= glib_required_version
                           gio-unix-2.0 >= glib_required_version
                           gtksourceview-3.0 >= gtksourceview_required_version
                           libdevhelp-3.0 >= devhelp_required_version
                           libgit2-glib-1.0 >= ggit_required_version
                           gjs-1.0 >= gjs_required_version
                           gjs-internals-1.0 >= gjs_required_version
                           pygobject-3.0 >= pygobject_required_version])

AC_PATH_TOOL(PYTHON3_CONFIG, "python3-config")
if test -z "${PYTHON3_CONFIG}"; then
  AC_MSG_ERROR([Failed to locate python3-config.])
fi

LIBIDE_CFLAGS="${LIBIDE_CFLAGS} `${PYTHON3_CONFIG} --cflags`"
LIBIDE_LIBS="${LIBIDE_LIBS} `${PYTHON3_CONFIG} --libs`"
LIBIDE_LDFLAGS="${LIBIDE_LDFLAGS} `${PYTHON3_CONFIG} --ldflags`"

GOBJECT_INTROSPECTION_CHECK([1.30.0])
GLIB_TESTS

# Check for various compiler flags.
AS_IF([test "x$enable_maintainer_flags" = "xyes" && test "x$GCC" = "xyes"],
      [AX_CHECK_COMPILE_FLAG([-Wall],                         [MAINTAINER_CFLAGS="$MAINTAINER_CFLAGS -Wall"])
       AX_CHECK_COMPILE_FLAG([-Waggregate-return],            [MAINTAINER_CFLAGS="$MAINTAINER_CFLAGS -Waggregate-return"])
       AX_CHECK_COMPILE_FLAG([-Wcast-align],                  [MAINTAINER_CFLAGS="$MAINTAINER_CFLAGS -Wcast-align"])
       AX_CHECK_COMPILE_FLAG([-Wdeclaration-after-statement], [MAINTAINER_CFLAGS="$MAINTAINER_CFLAGS -Wdeclaration-after-statement"])
       AX_CHECK_COMPILE_FLAG([-Wempty-body],                  [MAINTAINER_CFLAGS="$MAINTAINER_CFLAGS -Wempty-body"])
       AX_CHECK_COMPILE_FLAG([-Wformat],                      [MAINTAINER_CFLAGS="$MAINTAINER_CFLAGS -Wformat"])
       AX_CHECK_COMPILE_FLAG([-Wformat-nonliteral],           [MAINTAINER_CFLAGS="$MAINTAINER_CFLAGS -Wformat-nonliteral"])
       AX_CHECK_COMPILE_FLAG([-Wformat-security],             [MAINTAINER_CFLAGS="$MAINTAINER_CFLAGS -Wformat-security"])
       AX_CHECK_COMPILE_FLAG([-Winit-self],                   [MAINTAINER_CFLAGS="$MAINTAINER_CFLAGS -Winit-self"])
       AX_CHECK_COMPILE_FLAG([-Wmissing-include-dirs],        [MAINTAINER_CFLAGS="$MAINTAINER_CFLAGS -Wmissing-include-dirs"])
       AX_CHECK_COMPILE_FLAG([-Wno-strict-aliasing],          [MAINTAINER_CFLAGS="$MAINTAINER_CFLAGS -Wno-strict-aliasing"])
       AX_CHECK_COMPILE_FLAG([-Wno-uninitialized],            [MAINTAINER_CFLAGS="$MAINTAINER_CFLAGS -Wno-uninitialized"])
       AX_CHECK_COMPILE_FLAG([-Wredundant-decls],             [MAINTAINER_CFLAGS="$MAINTAINER_CFLAGS -Wredundant-decls"])
       AX_CHECK_COMPILE_FLAG([-Wreturn-type],                 [MAINTAINER_CFLAGS="$MAINTAINER_CFLAGS -Wreturn-type"])
       AX_CHECK_COMPILE_FLAG([-Wshadow],                      [MAINTAINER_CFLAGS="$MAINTAINER_CFLAGS -Wshadow"])
       AX_CHECK_COMPILE_FLAG([-Wswitch-default],              [MAINTAINER_CFLAGS="$MAINTAINER_CFLAGS -Wswitch-default"])
       AX_CHECK_COMPILE_FLAG([-Wswitch-enum],                 [MAINTAINER_CFLAGS="$MAINTAINER_CFLAGS -Wswitch-enum"])
       AX_CHECK_COMPILE_FLAG([-Wundef],                       [MAINTAINER_CFLAGS="$MAINTAINER_CFLAGS -Wundef"])
       AX_CHECK_COMPILE_FLAG([-Wuninitialized],               [MAINTAINER_CFLAGS="$MAINTAINER_CFLAGS -Wuninitialized"])])
AC_SUBST(MAINTAINER_CFLAGS)

AC_PROG_INSTALL
AC_CHECK_PROG([GMAKE], [gmake], [gmake], [make])
AC_DEFINE_UNQUOTED([GNU_MAKE_NAME], ["$GMAKE"], [Name of GNU make on this system])
m4_ifdef([AM_SILENT_RULES], [AM_SILENT_RULES(yes)])
AM_CONDITIONAL([ENABLE_TRACING], [test "$enable_tracing" = "yes"])
