/* geocoding.c generated by valac 0.32.0.61-f103e, the Vala compiler
 * generated from geocoding.vala, do not modify */

/*
 * Copyright (C) 2013  Evgeny Bobkin <evgen.ibqn@gmail.com>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 */

#include <glib.h>
#include <glib-object.h>
#include <geoclue.h>
#include <libgweather/gweather.h>
#include <stdlib.h>
#include <string.h>
#include <float.h>
#include <math.h>
#include <gio/gio.h>
#include <geocode-glib/geocode-glib.h>


#define CLOCKS_GEO_TYPE_INFO (clocks_geo_info_get_type ())
#define CLOCKS_GEO_INFO(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CLOCKS_GEO_TYPE_INFO, ClocksGeoInfo))
#define CLOCKS_GEO_INFO_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CLOCKS_GEO_TYPE_INFO, ClocksGeoInfoClass))
#define CLOCKS_GEO_IS_INFO(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CLOCKS_GEO_TYPE_INFO))
#define CLOCKS_GEO_IS_INFO_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CLOCKS_GEO_TYPE_INFO))
#define CLOCKS_GEO_INFO_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CLOCKS_GEO_TYPE_INFO, ClocksGeoInfoClass))

typedef struct _ClocksGeoInfo ClocksGeoInfo;
typedef struct _ClocksGeoInfoClass ClocksGeoInfoClass;
typedef struct _ClocksGeoInfoPrivate ClocksGeoInfoPrivate;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _gweather_location_unref0(var) ((var == NULL) ? NULL : (var = (gweather_location_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _ClocksGeoInfoSeekData ClocksGeoInfoSeekData;
typedef struct _ClocksGeoInfoOnLocationUpdatedData ClocksGeoInfoOnLocationUpdatedData;
typedef struct _ClocksGeoInfoSeekCountryCodeData ClocksGeoInfoSeekCountryCodeData;
typedef struct _ClocksGeoInfoSearchLocationsData ClocksGeoInfoSearchLocationsData;
#define _gweather_timezone_unref0(var) ((var == NULL) ? NULL : (var = (gweather_timezone_unref (var), NULL)))

struct _ClocksGeoInfo {
	GObject parent_instance;
	ClocksGeoInfoPrivate * priv;
};

struct _ClocksGeoInfoClass {
	GObjectClass parent_class;
};

struct _ClocksGeoInfoPrivate {
	GClueLocation* _geo_location;
	GWeatherLocation* found_location;
	gchar* country_code;
	GClueSimple* simple;
	gdouble minimal_distance;
};

struct _ClocksGeoInfoSeekData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	ClocksGeoInfo* self;
	GClueSimple* _tmp0_;
	GClueSimple* _tmp1_;
	GClueSimple* _tmp2_;
	GError* e;
	GError* _tmp3_;
	const gchar* _tmp4_;
	GClueSimple* _tmp5_;
	GError * _inner_error_;
};

struct _ClocksGeoInfoOnLocationUpdatedData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	ClocksGeoInfo* self;
	GClueSimple* _tmp0_;
	GClueLocationProxy* _tmp1_;
	GWeatherLocation* _tmp2_;
	GWeatherLocation* _tmp3_;
	GWeatherLocation* _tmp4_;
};

struct _ClocksGeoInfoSeekCountryCodeData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	ClocksGeoInfo* self;
	GeocodeLocation* location;
	GClueLocation* _tmp0_;
	gdouble _tmp1_;
	gdouble _tmp2_;
	GClueLocation* _tmp3_;
	gdouble _tmp4_;
	gdouble _tmp5_;
	GeocodeLocation* _tmp6_;
	GeocodeReverse* reverse;
	GeocodeReverse* _tmp7_;
	GeocodePlace* place;
	GeocodePlace* _tmp8_;
	const gchar* _tmp9_;
	gchar* _tmp10_;
	GError* e;
	GError* _tmp11_;
	const gchar* _tmp12_;
	GError * _inner_error_;
};

struct _ClocksGeoInfoSearchLocationsData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	ClocksGeoInfo* self;
	GWeatherLocation* location;
	const gchar* _tmp0_;
	gchar* loc_country_code;
	GWeatherLocation* _tmp1_;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	const gchar* _tmp4_;
	const gchar* _tmp5_;
	const gchar* _tmp6_;
	GWeatherLocation** locations;
	GWeatherLocation* _tmp7_;
	GWeatherLocation** _tmp8_;
	GWeatherLocation** _tmp9_;
	GWeatherLocation** _tmp10_;
	gint _tmp10__length1;
	gint locations_length1;
	gint _locations_size_;
	GWeatherLocation** _tmp11_;
	gint _tmp11__length1;
	gint i;
	gboolean _tmp12_;
	gint _tmp13_;
	gint _tmp14_;
	GWeatherLocation** _tmp15_;
	gint _tmp15__length1;
	GWeatherLocation** _tmp16_;
	gint _tmp16__length1;
	gint _tmp17_;
	GWeatherLocation* _tmp18_;
	GWeatherLocationLevel _tmp19_;
	GWeatherLocation** _tmp20_;
	gint _tmp20__length1;
	gint _tmp21_;
	GWeatherLocation* _tmp22_;
	gboolean _tmp23_;
	gdouble latitude;
	gdouble longitude;
	gdouble distance;
	GWeatherLocation** _tmp24_;
	gint _tmp24__length1;
	gint _tmp25_;
	GWeatherLocation* _tmp26_;
	gdouble _tmp27_;
	gdouble _tmp28_;
	GClueLocation* _tmp29_;
	gdouble _tmp30_;
	gdouble _tmp31_;
	GClueLocation* _tmp32_;
	gdouble _tmp33_;
	gdouble _tmp34_;
	gdouble _tmp35_;
	gdouble _tmp36_;
	gdouble _tmp37_;
	gdouble _tmp38_;
	gdouble _tmp39_;
	GWeatherLocation** _tmp40_;
	gint _tmp40__length1;
	gint _tmp41_;
	GWeatherLocation* _tmp42_;
	GWeatherLocation* _tmp43_;
	gdouble _tmp44_;
	GWeatherLocation** _tmp45_;
	gint _tmp45__length1;
	gint _tmp46_;
	GWeatherLocation* _tmp47_;
};


static gpointer clocks_geo_info_parent_class = NULL;

GType clocks_geo_info_get_type (void) G_GNUC_CONST;
#define CLOCKS_GEO_INFO_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), CLOCKS_GEO_TYPE_INFO, ClocksGeoInfoPrivate))
enum  {
	CLOCKS_GEO_INFO_DUMMY_PROPERTY,
	CLOCKS_GEO_INFO_GEO_LOCATION
};
#define CLOCKS_GEO_INFO_DESKTOP_ID "org.gnome.clocks"
ClocksGeoInfo* clocks_geo_info_new (void);
ClocksGeoInfo* clocks_geo_info_construct (GType object_type);
static void clocks_geo_info_seek_data_free (gpointer _data);
void clocks_geo_info_seek (ClocksGeoInfo* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
void clocks_geo_info_seek_finish (ClocksGeoInfo* self, GAsyncResult* _res_);
static gboolean clocks_geo_info_seek_co (ClocksGeoInfoSeekData* _data_);
static void clocks_geo_info_seek_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static void __lambda24_ (ClocksGeoInfo* self);
void clocks_geo_info_on_location_updated (ClocksGeoInfo* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
void clocks_geo_info_on_location_updated_finish (ClocksGeoInfo* self, GAsyncResult* _res_);
static void ___lambda24__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self);
static void clocks_geo_info_on_location_updated_data_free (gpointer _data);
static gboolean clocks_geo_info_on_location_updated_co (ClocksGeoInfoOnLocationUpdatedData* _data_);
static void clocks_geo_info_set_geo_location (ClocksGeoInfo* self, GClueLocation* value);
static void clocks_geo_info_seek_country_code (ClocksGeoInfo* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
static void clocks_geo_info_seek_country_code_finish (ClocksGeoInfo* self, GAsyncResult* _res_);
static void clocks_geo_info_on_location_updated_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static void clocks_geo_info_search_locations (ClocksGeoInfo* self, GWeatherLocation* location, GAsyncReadyCallback _callback_, gpointer _user_data_);
static void clocks_geo_info_search_locations_finish (ClocksGeoInfo* self, GAsyncResult* _res_);
static void clocks_geo_info_seek_country_code_data_free (gpointer _data);
static gboolean clocks_geo_info_seek_country_code_co (ClocksGeoInfoSeekCountryCodeData* _data_);
GClueLocation* clocks_geo_info_get_geo_location (ClocksGeoInfo* self);
gdouble gclue_location_get_latitude (GClueLocation* self);
gdouble gclue_location_get_longitude (GClueLocation* self);
static void clocks_geo_info_seek_country_code_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static gdouble clocks_geo_info_deg_to_rad (ClocksGeoInfo* self, gdouble deg);
static gdouble clocks_geo_info_get_distance (ClocksGeoInfo* self, gdouble latitude1, gdouble longitude1, gdouble latitude2, gdouble longitude2);
static void clocks_geo_info_search_locations_data_free (gpointer _data);
static gboolean clocks_geo_info_search_locations_co (ClocksGeoInfoSearchLocationsData* _data_);
static GWeatherLocation** _vala_array_dup1 (GWeatherLocation** self, int length);
static void clocks_geo_info_search_locations_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
gboolean clocks_geo_info_is_location_similar (ClocksGeoInfo* self, GWeatherLocation* location);
static void g_cclosure_user_marshal_VOID__BOXED (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data);
static void clocks_geo_info_finalize (GObject* obj);
static void _vala_clocks_geo_info_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_clocks_geo_info_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);


ClocksGeoInfo* clocks_geo_info_construct (GType object_type) {
	ClocksGeoInfo * self = NULL;
	self = (ClocksGeoInfo*) g_object_new (object_type, NULL);
	_g_free0 (self->priv->country_code);
	self->priv->country_code = NULL;
	_gweather_location_unref0 (self->priv->found_location);
	self->priv->found_location = NULL;
	self->priv->minimal_distance = 1000.0;
	return self;
}


ClocksGeoInfo* clocks_geo_info_new (void) {
	return clocks_geo_info_construct (CLOCKS_GEO_TYPE_INFO);
}


static void clocks_geo_info_seek_data_free (gpointer _data) {
	ClocksGeoInfoSeekData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (ClocksGeoInfoSeekData, _data_);
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


void clocks_geo_info_seek (ClocksGeoInfo* self, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	ClocksGeoInfoSeekData* _data_;
	ClocksGeoInfo* _tmp0_ = NULL;
	_data_ = g_slice_new0 (ClocksGeoInfoSeekData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, clocks_geo_info_seek);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, clocks_geo_info_seek_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	clocks_geo_info_seek_co (_data_);
}


void clocks_geo_info_seek_finish (ClocksGeoInfo* self, GAsyncResult* _res_) {
	ClocksGeoInfoSeekData* _data_;
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


static void clocks_geo_info_seek_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	ClocksGeoInfoSeekData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	clocks_geo_info_seek_co (_data_);
}


static void __lambda24_ (ClocksGeoInfo* self) {
	clocks_geo_info_on_location_updated (self, NULL, NULL);
}


static void ___lambda24__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self) {
	__lambda24_ ((ClocksGeoInfo*) self);
}


static gboolean clocks_geo_info_seek_co (ClocksGeoInfoSeekData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	{
		_data_->_state_ = 1;
		gclue_simple_new (CLOCKS_GEO_INFO_DESKTOP_ID, GCLUE_ACCURACY_LEVEL_CITY, NULL, clocks_geo_info_seek_ready, _data_);
		return FALSE;
		_state_1:
		_data_->_tmp1_ = NULL;
		_data_->_tmp1_ = gclue_simple_new_finish (_data_->_res_, &_data_->_inner_error_);
		_data_->_tmp0_ = _data_->_tmp1_;
		if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
			goto __catch8_g_error;
		}
		_data_->_tmp2_ = NULL;
		_data_->_tmp2_ = _data_->_tmp0_;
		_data_->_tmp0_ = NULL;
		_g_object_unref0 (_data_->self->priv->simple);
		_data_->self->priv->simple = _data_->_tmp2_;
		_g_object_unref0 (_data_->_tmp0_);
	}
	goto __finally8;
	__catch8_g_error:
	{
		_data_->e = _data_->_inner_error_;
		_data_->_inner_error_ = NULL;
		_data_->_tmp3_ = NULL;
		_data_->_tmp3_ = _data_->e;
		_data_->_tmp4_ = NULL;
		_data_->_tmp4_ = _data_->_tmp3_->message;
		g_warning ("geocoding.vala:44: Failed to connect to GeoClue2 service: %s", _data_->_tmp4_);
		_g_error_free0 (_data_->e);
		if (_data_->_state_ == 0) {
			g_simple_async_result_complete_in_idle (_data_->_async_result);
		} else {
			g_simple_async_result_complete (_data_->_async_result);
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	__finally8:
	if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
		g_clear_error (&_data_->_inner_error_);
		return FALSE;
	}
	_data_->_tmp5_ = NULL;
	_data_->_tmp5_ = _data_->self->priv->simple;
	g_signal_connect_object ((GObject*) _data_->_tmp5_, "notify::location", (GCallback) ___lambda24__g_object_notify, _data_->self, 0);
	clocks_geo_info_on_location_updated (_data_->self, NULL, NULL);
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


static void clocks_geo_info_on_location_updated_data_free (gpointer _data) {
	ClocksGeoInfoOnLocationUpdatedData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (ClocksGeoInfoOnLocationUpdatedData, _data_);
}


void clocks_geo_info_on_location_updated (ClocksGeoInfo* self, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	ClocksGeoInfoOnLocationUpdatedData* _data_;
	ClocksGeoInfo* _tmp0_ = NULL;
	_data_ = g_slice_new0 (ClocksGeoInfoOnLocationUpdatedData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, clocks_geo_info_on_location_updated);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, clocks_geo_info_on_location_updated_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	clocks_geo_info_on_location_updated_co (_data_);
}


void clocks_geo_info_on_location_updated_finish (ClocksGeoInfo* self, GAsyncResult* _res_) {
	ClocksGeoInfoOnLocationUpdatedData* _data_;
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


static void clocks_geo_info_on_location_updated_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	ClocksGeoInfoOnLocationUpdatedData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	clocks_geo_info_on_location_updated_co (_data_);
}


static gboolean clocks_geo_info_on_location_updated_co (ClocksGeoInfoOnLocationUpdatedData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		case 2:
		goto _state_2;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = NULL;
	_data_->_tmp0_ = _data_->self->priv->simple;
	_data_->_tmp1_ = NULL;
	_data_->_tmp1_ = gclue_simple_get_location (_data_->_tmp0_);
	clocks_geo_info_set_geo_location (_data_->self, (GClueLocation*) _data_->_tmp1_);
	_data_->_state_ = 1;
	clocks_geo_info_seek_country_code (_data_->self, clocks_geo_info_on_location_updated_ready, _data_);
	return FALSE;
	_state_1:
	clocks_geo_info_seek_country_code_finish (_data_->self, _data_->_res_);
	_data_->_tmp2_ = NULL;
	_data_->_tmp2_ = gweather_location_get_world ();
	_data_->_state_ = 2;
	clocks_geo_info_search_locations (_data_->self, _data_->_tmp2_, clocks_geo_info_on_location_updated_ready, _data_);
	return FALSE;
	_state_2:
	clocks_geo_info_search_locations_finish (_data_->self, _data_->_res_);
	_data_->_tmp3_ = NULL;
	_data_->_tmp3_ = _data_->self->priv->found_location;
	if (_data_->_tmp3_ != NULL) {
		_data_->_tmp4_ = NULL;
		_data_->_tmp4_ = _data_->self->priv->found_location;
		g_signal_emit_by_name (_data_->self, "location-changed", _data_->_tmp4_);
	}
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


static void clocks_geo_info_seek_country_code_data_free (gpointer _data) {
	ClocksGeoInfoSeekCountryCodeData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (ClocksGeoInfoSeekCountryCodeData, _data_);
}


static void clocks_geo_info_seek_country_code (ClocksGeoInfo* self, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	ClocksGeoInfoSeekCountryCodeData* _data_;
	ClocksGeoInfo* _tmp0_ = NULL;
	_data_ = g_slice_new0 (ClocksGeoInfoSeekCountryCodeData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, clocks_geo_info_seek_country_code);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, clocks_geo_info_seek_country_code_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	clocks_geo_info_seek_country_code_co (_data_);
}


static void clocks_geo_info_seek_country_code_finish (ClocksGeoInfo* self, GAsyncResult* _res_) {
	ClocksGeoInfoSeekCountryCodeData* _data_;
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


static void clocks_geo_info_seek_country_code_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	ClocksGeoInfoSeekCountryCodeData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	clocks_geo_info_seek_country_code_co (_data_);
}


static gboolean clocks_geo_info_seek_country_code_co (ClocksGeoInfoSeekCountryCodeData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = NULL;
	_data_->_tmp0_ = _data_->self->priv->_geo_location;
	_data_->_tmp1_ = 0.0;
	g_object_get (_data_->_tmp0_, "latitude", &_data_->_tmp1_, NULL);
	_data_->_tmp2_ = 0.0;
	_data_->_tmp2_ = _data_->_tmp1_;
	_data_->_tmp3_ = NULL;
	_data_->_tmp3_ = _data_->self->priv->_geo_location;
	_data_->_tmp4_ = 0.0;
	g_object_get (_data_->_tmp3_, "longitude", &_data_->_tmp4_, NULL);
	_data_->_tmp5_ = 0.0;
	_data_->_tmp5_ = _data_->_tmp4_;
	_data_->_tmp6_ = NULL;
	_data_->_tmp6_ = geocode_location_new (_data_->_tmp2_, _data_->_tmp5_, (gdouble) GEOCODE_LOCATION_ACCURACY_UNKNOWN);
	_data_->location = _data_->_tmp6_;
	_data_->_tmp7_ = NULL;
	_data_->_tmp7_ = geocode_reverse_new_for_location (_data_->location);
	_data_->reverse = _data_->_tmp7_;
	{
		_data_->_state_ = 1;
		geocode_reverse_resolve_async (_data_->reverse, NULL, clocks_geo_info_seek_country_code_ready, _data_);
		return FALSE;
		_state_1:
		_data_->_tmp8_ = NULL;
		_data_->_tmp8_ = geocode_reverse_resolve_finish (_data_->reverse, _data_->_res_, &_data_->_inner_error_);
		_data_->place = _data_->_tmp8_;
		if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
			goto __catch9_g_error;
		}
		_data_->_tmp9_ = NULL;
		_data_->_tmp9_ = geocode_place_get_country_code (_data_->place);
		_data_->_tmp10_ = NULL;
		_data_->_tmp10_ = g_strdup (_data_->_tmp9_);
		_g_free0 (_data_->self->priv->country_code);
		_data_->self->priv->country_code = _data_->_tmp10_;
		_g_object_unref0 (_data_->place);
	}
	goto __finally9;
	__catch9_g_error:
	{
		_data_->e = _data_->_inner_error_;
		_data_->_inner_error_ = NULL;
		_data_->_tmp11_ = NULL;
		_data_->_tmp11_ = _data_->e;
		_data_->_tmp12_ = NULL;
		_data_->_tmp12_ = _data_->_tmp11_->message;
		g_warning ("geocoding.vala:76: Failed to obtain country code: %s", _data_->_tmp12_);
		_g_error_free0 (_data_->e);
	}
	__finally9:
	if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
		_g_object_unref0 (_data_->reverse);
		_g_object_unref0 (_data_->location);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
		g_clear_error (&_data_->_inner_error_);
		return FALSE;
	}
	_g_object_unref0 (_data_->reverse);
	_g_object_unref0 (_data_->location);
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


static gdouble clocks_geo_info_deg_to_rad (ClocksGeoInfo* self, gdouble deg) {
	gdouble result = 0.0;
	gdouble _tmp0_ = 0.0;
	g_return_val_if_fail (self != NULL, 0.0);
	_tmp0_ = deg;
	result = (G_PI / 180.0) * _tmp0_;
	return result;
}


static gdouble clocks_geo_info_get_distance (ClocksGeoInfo* self, gdouble latitude1, gdouble longitude1, gdouble latitude2, gdouble longitude2) {
	gdouble result = 0.0;
	static const gdouble earth_radius = 6372.795;
	gdouble lat1 = 0.0;
	gdouble _tmp0_ = 0.0;
	gdouble _tmp1_ = 0.0;
	gdouble lat2 = 0.0;
	gdouble _tmp2_ = 0.0;
	gdouble _tmp3_ = 0.0;
	gdouble lon1 = 0.0;
	gdouble _tmp4_ = 0.0;
	gdouble _tmp5_ = 0.0;
	gdouble lon2 = 0.0;
	gdouble _tmp6_ = 0.0;
	gdouble _tmp7_ = 0.0;
	gdouble _tmp8_ = 0.0;
	gdouble _tmp9_ = 0.0;
	gdouble _tmp10_ = 0.0;
	gdouble _tmp11_ = 0.0;
	gdouble _tmp12_ = 0.0;
	gdouble _tmp13_ = 0.0;
	g_return_val_if_fail (self != NULL, 0.0);
	_tmp0_ = latitude1;
	_tmp1_ = clocks_geo_info_deg_to_rad (self, _tmp0_);
	lat1 = _tmp1_;
	_tmp2_ = latitude2;
	_tmp3_ = clocks_geo_info_deg_to_rad (self, _tmp2_);
	lat2 = _tmp3_;
	_tmp4_ = longitude1;
	_tmp5_ = clocks_geo_info_deg_to_rad (self, _tmp4_);
	lon1 = _tmp5_;
	_tmp6_ = longitude2;
	_tmp7_ = clocks_geo_info_deg_to_rad (self, _tmp6_);
	lon2 = _tmp7_;
	_tmp8_ = cos (lat1);
	_tmp9_ = cos (lat2);
	_tmp10_ = cos (lon1 - lon2);
	_tmp11_ = sin (lat1);
	_tmp12_ = sin (lat2);
	_tmp13_ = acos (((_tmp8_ * _tmp9_) * _tmp10_) + (_tmp11_ * _tmp12_));
	result = _tmp13_ * earth_radius;
	return result;
}


static void clocks_geo_info_search_locations_data_free (gpointer _data) {
	ClocksGeoInfoSearchLocationsData* _data_;
	_data_ = _data;
	_gweather_location_unref0 (_data_->location);
	_g_object_unref0 (_data_->self);
	g_slice_free (ClocksGeoInfoSearchLocationsData, _data_);
}


static gpointer _gweather_location_ref0 (gpointer self) {
	return self ? gweather_location_ref (self) : NULL;
}


static void clocks_geo_info_search_locations (ClocksGeoInfo* self, GWeatherLocation* location, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	ClocksGeoInfoSearchLocationsData* _data_;
	ClocksGeoInfo* _tmp0_ = NULL;
	GWeatherLocation* _tmp1_ = NULL;
	GWeatherLocation* _tmp2_ = NULL;
	_data_ = g_slice_new0 (ClocksGeoInfoSearchLocationsData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, clocks_geo_info_search_locations);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, clocks_geo_info_search_locations_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = location;
	_tmp2_ = _gweather_location_ref0 (_tmp1_);
	_gweather_location_unref0 (_data_->location);
	_data_->location = _tmp2_;
	clocks_geo_info_search_locations_co (_data_);
}


static void clocks_geo_info_search_locations_finish (ClocksGeoInfo* self, GAsyncResult* _res_) {
	ClocksGeoInfoSearchLocationsData* _data_;
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


static GWeatherLocation** _vala_array_dup1 (GWeatherLocation** self, int length) {
	GWeatherLocation** result;
	int i;
	result = g_new0 (GWeatherLocation*, length + 1);
	for (i = 0; i < length; i++) {
		GWeatherLocation* _tmp0_ = NULL;
		_tmp0_ = _gweather_location_ref0 (self[i]);
		result[i] = _tmp0_;
	}
	return result;
}


static void clocks_geo_info_search_locations_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	ClocksGeoInfoSearchLocationsData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	clocks_geo_info_search_locations_co (_data_);
}


static gboolean clocks_geo_info_search_locations_co (ClocksGeoInfoSearchLocationsData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = NULL;
	_data_->_tmp0_ = _data_->self->priv->country_code;
	if (_data_->_tmp0_ != NULL) {
		_data_->_tmp1_ = NULL;
		_data_->_tmp1_ = _data_->location;
		_data_->_tmp2_ = NULL;
		_data_->_tmp2_ = gweather_location_get_country (_data_->_tmp1_);
		_data_->_tmp3_ = NULL;
		_data_->_tmp3_ = g_strdup (_data_->_tmp2_);
		_data_->loc_country_code = _data_->_tmp3_;
		_data_->_tmp4_ = NULL;
		_data_->_tmp4_ = _data_->loc_country_code;
		if (_data_->_tmp4_ != NULL) {
			_data_->_tmp5_ = NULL;
			_data_->_tmp5_ = _data_->loc_country_code;
			_data_->_tmp6_ = NULL;
			_data_->_tmp6_ = _data_->self->priv->country_code;
			if (g_strcmp0 (_data_->_tmp5_, _data_->_tmp6_) != 0) {
				_g_free0 (_data_->loc_country_code);
				if (_data_->_state_ == 0) {
					g_simple_async_result_complete_in_idle (_data_->_async_result);
				} else {
					g_simple_async_result_complete (_data_->_async_result);
				}
				g_object_unref (_data_->_async_result);
				return FALSE;
			}
		}
		_g_free0 (_data_->loc_country_code);
	}
	_data_->_tmp7_ = NULL;
	_data_->_tmp7_ = _data_->location;
	_data_->_tmp8_ = NULL;
	_data_->_tmp9_ = NULL;
	_data_->_tmp9_ = _data_->_tmp8_ = gweather_location_get_children (_data_->_tmp7_);
	_data_->_tmp10_ = NULL;
	_data_->_tmp10__length1 = 0;
	_data_->_tmp10_ = (_data_->_tmp9_ != NULL) ? _vala_array_dup1 (_data_->_tmp9_, _vala_array_length (_data_->_tmp8_)) : ((gpointer) _data_->_tmp9_);
	_data_->_tmp10__length1 = _vala_array_length (_data_->_tmp8_);
	_data_->locations_length1 = 0;
	_data_->_locations_size_ = 0;
	_data_->locations = _data_->_tmp10_;
	_data_->locations_length1 = _data_->_tmp10__length1;
	_data_->_locations_size_ = _data_->locations_length1;
	_data_->_tmp11_ = NULL;
	_data_->_tmp11__length1 = 0;
	_data_->_tmp11_ = _data_->locations;
	_data_->_tmp11__length1 = _data_->locations_length1;
	if (_data_->_tmp11_ != NULL) {
		{
			_data_->i = 0;
			{
				_data_->_tmp12_ = TRUE;
				while (TRUE) {
					if (!_data_->_tmp12_) {
						_data_->_tmp13_ = 0;
						_data_->_tmp13_ = _data_->i;
						_data_->i = _data_->_tmp13_ + 1;
					}
					_data_->_tmp12_ = FALSE;
					_data_->_tmp14_ = 0;
					_data_->_tmp14_ = _data_->i;
					_data_->_tmp15_ = NULL;
					_data_->_tmp15__length1 = 0;
					_data_->_tmp15_ = _data_->locations;
					_data_->_tmp15__length1 = _data_->locations_length1;
					if (!(_data_->_tmp14_ < _data_->_tmp15__length1)) {
						break;
					}
					_data_->_tmp16_ = NULL;
					_data_->_tmp16__length1 = 0;
					_data_->_tmp16_ = _data_->locations;
					_data_->_tmp16__length1 = _data_->locations_length1;
					_data_->_tmp17_ = 0;
					_data_->_tmp17_ = _data_->i;
					_data_->_tmp18_ = NULL;
					_data_->_tmp18_ = _data_->_tmp16_[_data_->_tmp17_];
					_data_->_tmp19_ = 0;
					_data_->_tmp19_ = gweather_location_get_level (_data_->_tmp18_);
					if (_data_->_tmp19_ == GWEATHER_LOCATION_CITY) {
						_data_->_tmp20_ = NULL;
						_data_->_tmp20__length1 = 0;
						_data_->_tmp20_ = _data_->locations;
						_data_->_tmp20__length1 = _data_->locations_length1;
						_data_->_tmp21_ = 0;
						_data_->_tmp21_ = _data_->i;
						_data_->_tmp22_ = NULL;
						_data_->_tmp22_ = _data_->_tmp20_[_data_->_tmp21_];
						_data_->_tmp23_ = FALSE;
						_data_->_tmp23_ = gweather_location_has_coords (_data_->_tmp22_);
						if (_data_->_tmp23_) {
							_data_->_tmp24_ = NULL;
							_data_->_tmp24__length1 = 0;
							_data_->_tmp24_ = _data_->locations;
							_data_->_tmp24__length1 = _data_->locations_length1;
							_data_->_tmp25_ = 0;
							_data_->_tmp25_ = _data_->i;
							_data_->_tmp26_ = NULL;
							_data_->_tmp26_ = _data_->_tmp24_[_data_->_tmp25_];
							_data_->_tmp27_ = 0.0;
							_data_->_tmp28_ = 0.0;
							gweather_location_get_coords (_data_->_tmp26_, &_data_->_tmp27_, &_data_->_tmp28_);
							_data_->latitude = _data_->_tmp27_;
							_data_->longitude = _data_->_tmp28_;
							_data_->_tmp29_ = NULL;
							_data_->_tmp29_ = _data_->self->priv->_geo_location;
							_data_->_tmp30_ = 0.0;
							g_object_get (_data_->_tmp29_, "latitude", &_data_->_tmp30_, NULL);
							_data_->_tmp31_ = 0.0;
							_data_->_tmp31_ = _data_->_tmp30_;
							_data_->_tmp32_ = NULL;
							_data_->_tmp32_ = _data_->self->priv->_geo_location;
							_data_->_tmp33_ = 0.0;
							g_object_get (_data_->_tmp32_, "longitude", &_data_->_tmp33_, NULL);
							_data_->_tmp34_ = 0.0;
							_data_->_tmp34_ = _data_->_tmp33_;
							_data_->_tmp35_ = 0.0;
							_data_->_tmp35_ = _data_->latitude;
							_data_->_tmp36_ = 0.0;
							_data_->_tmp36_ = _data_->longitude;
							_data_->_tmp37_ = 0.0;
							_data_->_tmp37_ = clocks_geo_info_get_distance (_data_->self, _data_->_tmp31_, _data_->_tmp34_, _data_->_tmp35_, _data_->_tmp36_);
							_data_->distance = _data_->_tmp37_;
							_data_->_tmp38_ = 0.0;
							_data_->_tmp38_ = _data_->distance;
							_data_->_tmp39_ = 0.0;
							_data_->_tmp39_ = _data_->self->priv->minimal_distance;
							if (_data_->_tmp38_ < _data_->_tmp39_) {
								_data_->_tmp40_ = NULL;
								_data_->_tmp40__length1 = 0;
								_data_->_tmp40_ = _data_->locations;
								_data_->_tmp40__length1 = _data_->locations_length1;
								_data_->_tmp41_ = 0;
								_data_->_tmp41_ = _data_->i;
								_data_->_tmp42_ = NULL;
								_data_->_tmp42_ = _data_->_tmp40_[_data_->_tmp41_];
								_data_->_tmp43_ = NULL;
								_data_->_tmp43_ = _gweather_location_ref0 (_data_->_tmp42_);
								_gweather_location_unref0 (_data_->self->priv->found_location);
								_data_->self->priv->found_location = _data_->_tmp43_;
								_data_->_tmp44_ = 0.0;
								_data_->_tmp44_ = _data_->distance;
								_data_->self->priv->minimal_distance = _data_->_tmp44_;
							}
						}
					}
					_data_->_tmp45_ = NULL;
					_data_->_tmp45__length1 = 0;
					_data_->_tmp45_ = _data_->locations;
					_data_->_tmp45__length1 = _data_->locations_length1;
					_data_->_tmp46_ = 0;
					_data_->_tmp46_ = _data_->i;
					_data_->_tmp47_ = NULL;
					_data_->_tmp47_ = _data_->_tmp45_[_data_->_tmp46_];
					_data_->_state_ = 1;
					clocks_geo_info_search_locations (_data_->self, _data_->_tmp47_, clocks_geo_info_search_locations_ready, _data_);
					return FALSE;
					_state_1:
					clocks_geo_info_search_locations_finish (_data_->self, _data_->_res_);
				}
			}
		}
	}
	_data_->locations = (_vala_array_free (_data_->locations, _data_->locations_length1, (GDestroyNotify) gweather_location_unref), NULL);
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


static gpointer _gweather_timezone_ref0 (gpointer self) {
	return self ? gweather_timezone_ref (self) : NULL;
}


gboolean clocks_geo_info_is_location_similar (ClocksGeoInfo* self, GWeatherLocation* location) {
	gboolean result = FALSE;
	GWeatherLocation* _tmp0_ = NULL;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (location != NULL, FALSE);
	_tmp0_ = self->priv->found_location;
	if (_tmp0_ != NULL) {
		gchar* country_code = NULL;
		GWeatherLocation* _tmp1_ = NULL;
		const gchar* _tmp2_ = NULL;
		gchar* _tmp3_ = NULL;
		gchar* found_country_code = NULL;
		GWeatherLocation* _tmp4_ = NULL;
		const gchar* _tmp5_ = NULL;
		gchar* _tmp6_ = NULL;
		gboolean _tmp7_ = FALSE;
		const gchar* _tmp8_ = NULL;
		_tmp1_ = location;
		_tmp2_ = gweather_location_get_country (_tmp1_);
		_tmp3_ = g_strdup (_tmp2_);
		country_code = _tmp3_;
		_tmp4_ = self->priv->found_location;
		_tmp5_ = gweather_location_get_country (_tmp4_);
		_tmp6_ = g_strdup (_tmp5_);
		found_country_code = _tmp6_;
		_tmp8_ = country_code;
		if (_tmp8_ != NULL) {
			const gchar* _tmp9_ = NULL;
			const gchar* _tmp10_ = NULL;
			_tmp9_ = country_code;
			_tmp10_ = found_country_code;
			_tmp7_ = g_strcmp0 (_tmp9_, _tmp10_) == 0;
		} else {
			_tmp7_ = FALSE;
		}
		if (_tmp7_) {
			GWeatherTimezone* timezone = NULL;
			GWeatherLocation* _tmp11_ = NULL;
			GWeatherTimezone* _tmp12_ = NULL;
			GWeatherTimezone* _tmp13_ = NULL;
			GWeatherTimezone* found_timezone = NULL;
			GWeatherLocation* _tmp14_ = NULL;
			GWeatherTimezone* _tmp15_ = NULL;
			GWeatherTimezone* _tmp16_ = NULL;
			gboolean _tmp17_ = FALSE;
			GWeatherTimezone* _tmp18_ = NULL;
			_tmp11_ = location;
			_tmp12_ = gweather_location_get_timezone (_tmp11_);
			_tmp13_ = _gweather_timezone_ref0 (_tmp12_);
			timezone = _tmp13_;
			_tmp14_ = self->priv->found_location;
			_tmp15_ = gweather_location_get_timezone (_tmp14_);
			_tmp16_ = _gweather_timezone_ref0 (_tmp15_);
			found_timezone = _tmp16_;
			_tmp18_ = timezone;
			if (_tmp18_ != NULL) {
				GWeatherTimezone* _tmp19_ = NULL;
				_tmp19_ = found_timezone;
				_tmp17_ = _tmp19_ != NULL;
			} else {
				_tmp17_ = FALSE;
			}
			if (_tmp17_) {
				gchar* tzid = NULL;
				GWeatherTimezone* _tmp20_ = NULL;
				const gchar* _tmp21_ = NULL;
				gchar* _tmp22_ = NULL;
				gchar* found_tzid = NULL;
				GWeatherTimezone* _tmp23_ = NULL;
				const gchar* _tmp24_ = NULL;
				gchar* _tmp25_ = NULL;
				const gchar* _tmp26_ = NULL;
				const gchar* _tmp27_ = NULL;
				_tmp20_ = timezone;
				_tmp21_ = gweather_timezone_get_tzid (_tmp20_);
				_tmp22_ = g_strdup (_tmp21_);
				tzid = _tmp22_;
				_tmp23_ = found_timezone;
				_tmp24_ = gweather_timezone_get_tzid (_tmp23_);
				_tmp25_ = g_strdup (_tmp24_);
				found_tzid = _tmp25_;
				_tmp26_ = tzid;
				_tmp27_ = found_tzid;
				if (g_strcmp0 (_tmp26_, _tmp27_) == 0) {
					result = TRUE;
					_g_free0 (found_tzid);
					_g_free0 (tzid);
					_gweather_timezone_unref0 (found_timezone);
					_gweather_timezone_unref0 (timezone);
					_g_free0 (found_country_code);
					_g_free0 (country_code);
					return result;
				}
				_g_free0 (found_tzid);
				_g_free0 (tzid);
			}
			_gweather_timezone_unref0 (found_timezone);
			_gweather_timezone_unref0 (timezone);
		}
		_g_free0 (found_country_code);
		_g_free0 (country_code);
	}
	result = FALSE;
	return result;
}


GClueLocation* clocks_geo_info_get_geo_location (ClocksGeoInfo* self) {
	GClueLocation* result;
	GClueLocation* _tmp0_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_geo_location;
	result = _tmp0_;
	return result;
}


static void clocks_geo_info_set_geo_location (ClocksGeoInfo* self, GClueLocation* value) {
	GClueLocation* _tmp0_ = NULL;
	GClueLocation* _tmp1_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	_g_object_unref0 (self->priv->_geo_location);
	self->priv->_geo_location = _tmp1_;
	g_object_notify ((GObject *) self, "geo-location");
}


static void g_cclosure_user_marshal_VOID__BOXED (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data) {
	typedef void (*GMarshalFunc_VOID__BOXED) (gpointer data1, gpointer arg_1, gpointer data2);
	register GMarshalFunc_VOID__BOXED callback;
	register GCClosure * cc;
	register gpointer data1;
	register gpointer data2;
	cc = (GCClosure *) closure;
	g_return_if_fail (n_param_values == 2);
	if (G_CCLOSURE_SWAP_DATA (closure)) {
		data1 = closure->data;
		data2 = param_values->data[0].v_pointer;
	} else {
		data1 = param_values->data[0].v_pointer;
		data2 = closure->data;
	}
	callback = (GMarshalFunc_VOID__BOXED) (marshal_data ? marshal_data : cc->callback);
	callback (data1, g_value_get_boxed (param_values + 1), data2);
}


static void clocks_geo_info_class_init (ClocksGeoInfoClass * klass) {
	clocks_geo_info_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (ClocksGeoInfoPrivate));
	G_OBJECT_CLASS (klass)->get_property = _vala_clocks_geo_info_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_clocks_geo_info_set_property;
	G_OBJECT_CLASS (klass)->finalize = clocks_geo_info_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), CLOCKS_GEO_INFO_GEO_LOCATION, g_param_spec_object ("geo-location", "geo-location", "geo-location", gclue_location_get_type (), G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_signal_new ("location_changed", CLOCKS_GEO_TYPE_INFO, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__BOXED, G_TYPE_NONE, 1, gweather_location_get_type ());
}


static void clocks_geo_info_instance_init (ClocksGeoInfo * self) {
	self->priv = CLOCKS_GEO_INFO_GET_PRIVATE (self);
	self->priv->_geo_location = NULL;
}


static void clocks_geo_info_finalize (GObject* obj) {
	ClocksGeoInfo * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, CLOCKS_GEO_TYPE_INFO, ClocksGeoInfo);
	_g_object_unref0 (self->priv->_geo_location);
	_gweather_location_unref0 (self->priv->found_location);
	_g_free0 (self->priv->country_code);
	_g_object_unref0 (self->priv->simple);
	G_OBJECT_CLASS (clocks_geo_info_parent_class)->finalize (obj);
}


GType clocks_geo_info_get_type (void) {
	static volatile gsize clocks_geo_info_type_id__volatile = 0;
	if (g_once_init_enter (&clocks_geo_info_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (ClocksGeoInfoClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) clocks_geo_info_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ClocksGeoInfo), 0, (GInstanceInitFunc) clocks_geo_info_instance_init, NULL };
		GType clocks_geo_info_type_id;
		clocks_geo_info_type_id = g_type_register_static (G_TYPE_OBJECT, "ClocksGeoInfo", &g_define_type_info, 0);
		g_once_init_leave (&clocks_geo_info_type_id__volatile, clocks_geo_info_type_id);
	}
	return clocks_geo_info_type_id__volatile;
}


static void _vala_clocks_geo_info_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	ClocksGeoInfo * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, CLOCKS_GEO_TYPE_INFO, ClocksGeoInfo);
	switch (property_id) {
		case CLOCKS_GEO_INFO_GEO_LOCATION:
		g_value_set_object (value, clocks_geo_info_get_geo_location (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_clocks_geo_info_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	ClocksGeoInfo * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, CLOCKS_GEO_TYPE_INFO, ClocksGeoInfo);
	switch (property_id) {
		case CLOCKS_GEO_INFO_GEO_LOCATION:
		clocks_geo_info_set_geo_location (self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static gint _vala_array_length (gpointer array) {
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}



