# Release number can be specified with rpm --define 'rel SOMETHING' ...
# If no such --define is used, the release number is 1.
#
# Source archive's extension can be specified with rpm --define 'srcext .foo'
# where .foo is the source archive's actual extension.
# To compile an RPM from a .gz source archive, give the command
#   rpmbuild -tb --define 'srcext .gz' gnome-commander-1.2.1.tar.gz
#

%if %{?rel:0}%{!?rel:1}
%define rel 1
%endif
%if %{?srcext:0}%{!?srcext:1}
%define srcext .bz2
%endif

Name:          gnome-commander
Version:       1.2.1
Release:       %{rel}
Summary:       GNOME Commander is a nice and fast file manager for the GNOME desktop. 
Summary(pl):   Menadżer plików dla GNOME oparty o Norton Commander'a (TM)
Summary(sv):   GNOME Commander är en snabb och smidig filhanderare för GNOME.

Group:         Applications/File
License:       GPL2
URL:           http://www.freesoftware.fsf.org/gcmd/
Source0:       http://freesoftware.fsf.org/download/gcmd/gcmd.pkg/1.2.1/gnome-commander-1.2.1.tar%{srcext}
BuildRoot:     %{_tmppath}/%{name}-%{version}-%{release}-root-%(%{__id_u} -n)
BuildRequires: scrollkeeper gettext >= 0.10.36
Requires:      gtk2 >= 2.6
Requires:      glib >= 2.6
Requires:      gnome-vfs2 >= 2.0
BuildRequires: gnome-vfs2-devel >= 2.0
Requires:      libgnomeui >= 2.0
BuildRequires: libgnomeui-devel >= 2.0
BuildRequires: intltool
BuildRequires: gnome-doc-utils >= 0.3.2

BuildRequires: gnome-doc-utils >= 0.3.2
Requires(post): desktop-file-utils
Requires(postun): desktop-file-utils

Requires(post): scrollkeeper
Requires(postun): scrollkeeper

Distribution:  Any

%description
GNOME Commander is a nice and fast file manager for the GNOME desktop. In addition to performing the basic filemanager functions the program is also an FTP-client and it can browse SMB-networks.

%description -l pl
GNOME Commander to niewielki i wydajny menadżer plików umożliwiający wykonywanie za pomocą klawiatury wszystkich standardowych operacji na plikach. Dostępne są również dodatkowe funkcje jak np. obsługa FTP, czy też obsługa sieci SMB.

%description -l ru
Быстро работающий файловый менеджер для Gnome. Может выполнять большинство типовых операций с файлами, умеет обнаруживать изменения, внесенные в файлы другими программами, и автоматически обновлять отображаемый список файлов. Поддерживает описания файловых структур в формате DND и кодировки MIME. Реализует на базовом уровне поддержку FTP через GnomeVFS.

%description -l sv
GNOME Commander är en snabb och smidig filhanderare för GNOME. Utöver att kunna hantera filer på din egen dator så kan programmet även ansluta till FTP-servrar och SMB-nätverk.

%prep
%setup -q

%build
%configure --disable-scrollkeeper
%{__make} %{?_smp_mflags}

%install
%{__rm} -rf %{buildroot}
%makeinstall

%find_lang %{name}

%post
#scrollkeeper
scrollkeeper-update -q -o %{_datadir}/omf/%{name} || :

#install the desktop file in menus
update-desktop-database &> /dev/null ||:

#update icon cache
touch --no-create %{_datadir}/icons/hicolor || :
if [ -x %{_bindir}/gtk-update-icon-cache ]; then
   %{_bindir}/gtk-update-icon-cache --quiet %{_datadir}/icons/hicolor || :
fi

%postun
#scrollkeeper
scrollkeeper-update -q || :

#uninstall the desktop file in menus
update-desktop-database &> /dev/null ||:

#update icon cache
touch --no-create %{_datadir}/icons/hicolor || :
if [ -x %{_bindir}/gtk-update-icon-cache ]; then
   %{_bindir}/gtk-update-icon-cache --quiet %{_datadir}/icons/hicolor || :
fi

    
%clean
%{__rm} -rf %{buildroot}

%files -f %{name}.lang
%defattr(-,root,root,-)
%doc AUTHORS BUGS ChangeLog COPYING INSTALL NEWS README TODO doc/*.txt
%doc %{_mandir}/man1/gnome-commander.1*
%{_bindir}/*
%{_libdir}/gnome-commander/lib*
%{_libdir}/gnome-commander/plugins/lib*
%{_datadir}/applications/gnome-commander.desktop
%{_datadir}/gnome/help/gnome-commander/*
%{_datadir}/omf
%{_datadir}/pixmaps

%changelog
* Mon Jul 17 2006 Piotr Eljasiak <epiotr@use.pl>
- added glib dependencies

* Sun May 14 2006 Stephanos Manos <stefmanos@gmail.com>
- Fixed Scrollkeeper database update
	-disabled scrollkeeper update from make
	-added scrollkeeper-database-update in the %post & %postun section
- Added %post & %postun entries for the desktop file
- Added %post & %postun entries for the gtk+ icon cache file

* Sun Apr 9 2006 Piotr Eljasiak <epiotr@use.pl>
- minor cleanups

* Thu Mar 5 2006 Piotr Eljasiak <epiotr@use.pl>
- added OMF files

* Mon Feb 13 2006 Piotr Eljasiak <epiotr@use.pl>
- install gnome-commander icon to %{_datadir}/pixmaps/
- install gnome-commander.1* to %{_mandir}/man1/

* Sat Feb 11 2006 Piotr Eljasiak <epiotr@use.pl>
- set default srcext to .bz2

* Fri Jan 28 2005 Piotr Eljasiak <epiotr@use.pl>
- fixed typo: rpm --> rpmbuild

* Mon May 03 2004 Piotr Eljasiak <epiotr@use.pl>
- converted spec file to utf-8
- used RPM macros a bit more

* Thu Jun 19 2003 Piotr Eljasiak <epiotr@use.pl>
- added libraries

* Tue Mar 25 2003 Piotr Eljasiak <epiotr@use.pl>
- updated Sources

* Mon Jan 20 2003 Piotr Eljasiak <epiotr@use.pl>
- added build dependencies

* Fri Jan 10 2003 Piotr Eljasiak <epiotr@use.pl>
- added localization

* Thu Jan 09 2003 Piotr Eljasiak <epiotr@use.pl>
- added dependencies

* Mon Jun 24 2002 Piotr Eljasiak <epiotr@use.pl>
- more cleanup in install section 

* Sat Jun 15 2002 Piotr Eljasiak <epiotr@use.pl>
- simplified install and files sections

* Mon Jun 10 2002 Piotr Eljasiak <epiotr@use.pl>
- .spec file is now generated from .spec.in

* Mon Jun 10 2002 Marcus Bjurman <marbj499@student.liu.se>
- The default icon for this project is now called gnome-commander.png
  The xpm variant of the same icon is now also renamed in the same manner.

* Sat Mar  9 2002 Marcus Bjurman <marbj499@student.liu.se>
- Pumped up the version nr

* Sun Nov  4 2001 Marcus Bjurman <marbj499@student.liu.se>
- Initial build.
