/*  GNOME-DB Components
 *  Copyrigth (C) 2000 Rodrigo Moya
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include <gnomedb-com.h>
#include <gnome-db-help.h>

static void go_back_cb    (GtkWidget *w, GnomeDbControlInstance *control_instance);
static void go_forward_cb (GtkWidget *w, GnomeDbControlInstance *control_instance);
static void go_home_cb    (GtkWidget *w, GnomeDbControlInstance *control_instance);

static GnomeDbControl* help_control = NULL;
static GnomeUIInfo help_control_toolbar[] =
{
  { GNOME_APP_UI_ITEM, N_("Back"), N_("Display previous page in history"),
    go_back_cb, NULL, NULL, GNOME_APP_PIXMAP_STOCK,
    GNOME_STOCK_PIXMAP_BACK, 0, 0, NULL },
  { GNOME_APP_UI_ITEM, N_("Home"), N_("Display help system home page"),
    go_home_cb, NULL, NULL, GNOME_APP_PIXMAP_STOCK,
    GNOME_STOCK_PIXMAP_HOME, 0, 0, NULL },
  { GNOME_APP_UI_ITEM, N_("Forward"), N_("Display next page in history"),
    go_forward_cb, NULL, NULL, GNOME_APP_PIXMAP_STOCK,
    GNOME_STOCK_PIXMAP_FORWARD, 0, 0, NULL },
  GNOMEUIINFO_END
};

/*
 * Callbacks
 */
static void
go_back_cb (GtkWidget *w, GnomeDbControlInstance *control_instance)
{
  GtkWidget* help;
  
  g_return_if_fail(GNOME_DB_IS_CONTROL_INSTANCE(control_instance));
  
  help = gnome_db_control_instance_get_widget(control_instance);
  if (GNOME_DB_IS_HELP(help))
    {
      gnome_db_help_go_back(GNOME_DB_HELP(help));
    }
}

static void
go_forward_cb (GtkWidget *w, GnomeDbControlInstance *control_instance)
{
  GtkWidget* help;
  
  g_return_if_fail(GNOME_DB_IS_CONTROL_INSTANCE(control_instance));
  
  help = gnome_db_control_instance_get_widget(control_instance);
  if (GNOME_DB_IS_HELP(help))
    {
      gnome_db_help_go_forward(GNOME_DB_HELP(help));
    }
}

static void
go_home_cb (GtkWidget *w, GnomeDbControlInstance *control_instance)
{
  GtkWidget* help;
  
  g_return_if_fail(GNOME_DB_IS_CONTROL_INSTANCE(control_instance));
  
  help = gnome_db_control_instance_get_widget(control_instance);
  if (GNOME_DB_IS_HELP(help))
    {
      gnome_db_help_go_home(GNOME_DB_HELP(help));
    }
}

static GnomeDbControlInstance *
help_create_instance_cb (GnomeDbControl *control)
{
  GtkWidget*              help;
  GnomeDbControlInstance* control_instance;
 
  g_return_val_if_fail(GNOME_DB_IS_CONTROL(control), NULL);
   
  help = gnome_db_help_new();
  gtk_widget_show_all(help);
  
  control_instance = gnome_db_control_instance_new(control, help);
  if (GNOME_DB_IS_CONTROL_INSTANCE(control_instance))
    {
      gnome_db_control_instance_set_toolbar(control_instance, help_control_toolbar);
    }
  return control_instance;
}

/*
 * Public functions
 */
void
components_help_init (void)
{
  if (!GNOME_DB_IS_CONTROL(help_control))
    {
      gchar* oafiid;

      oafiid = g_strdup("OAFIID:GNOME_DB_HelpViewer_ControlFactory");
      
      /* register factory */
      help_control = gnome_db_control_new(oafiid, help_create_instance_cb);
      if (GNOME_DB_IS_CONTROL(help_control))
        {
        }
      else g_error(_("Could not initialize %s component"), oafiid);
      
      g_free((gpointer) oafiid);
    }
}
