/*  GNOME-DB Monikers
 *  Copyrigth (C) 2000 Rodrigo Moya
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include <gnomedb-monikers.h>
#include <bonobo/bonobo-shlib-factory.h>

/*
 * Private functions
 */
static BonoboObject *
database_moniker_resolve (GnomeDbMoniker *moniker, const gchar *requested_interface)
{
	Bonobo_Moniker    corba_parent;
	CORBA_Environment ev;
	const gchar*      name;

	g_return_val_if_fail(GNOME_DB_IS_MONIKER(moniker), NULL);
	g_return_val_if_fail(requested_interface != NULL, NULL);

	CORBA_exception_init(&ev);

	/* retrieve parent */
	corba_parent = bonobo_moniker_get_parent(moniker, &ev);
	if (BONOBO_EX(&ev))
		return CORBA_OBJECT_NIL;
	name = bonobo_moniker_get_name(moniker);

	if (!strcmp(requested_interface, "IDL:Bonobo/Control:1.0")) {
	}
	else if (!strcmp(requested_interface, "IDL:Bonobo/PropertyBag:1.0")) {
		/* return a property bag for the requested object */
	}
	
	return NULL;
}

static BonoboObject *
database_moniker_factory (BonoboGenericFactory *factory, void *closure) {
	GnomeDbMoniker* new_moniker;
	
	g_return_val_if_fail(BONOBO_IS_GENERIC_FACTORY(factory), NULL);
	
	new_moniker = gnome_db_moniker_new(GNOME_DB_OAFIID_MONIKER_DATABASE,
	                                   "database:",
	                                   (GnomeDbMonikerResolveFunc) database_moniker_resolve);
	if (!GNOME_DB_IS_MONIKER(new_moniker)) {
		g_warning(_("Could not create 'database:' moniker instance"));
		return NULL;
	}
	
	return BONOBO_OBJECT(new_moniker);
}

/*
 * Public functions
 */
BONOBO_OAF_SHLIB_FACTORY(GNOME_DB_OAFIID_MONIKER_DATABASE_FACTORY,
                          "GNOME-DB database moniker",
                          database_moniker_factory,
                          NULL)
