/*  GNOME-DB Front End
 *  Copyrigth (C) 2000 Rodrigo Moya
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#if !defined(__gnomedb_fe_h__)
#  define __gnomedb_fe_h__

#include <gnome.h>
#include <gnome-db.h>
#include <bonobo.h>

#include <config.h>

BEGIN_GNOME_DECLS

/*
 * Callbacks
 */
void fe_about_cb              (GtkWidget *w, gpointer user_data);
void fe_activate_component_cb (GtkWidget *w, gpointer user_data);
void fe_do_copy_clipboard_cb  (GtkWidget *w, gpointer user_data);
void fe_do_cut_clipboard_cb   (GtkWidget *w, gpointer user_data);
void fe_do_paste_clipboard_cb (GtkWidget *w, gpointer user_data);
void fe_do_print_cb           (GtkWidget *w, gpointer user_data);
void fe_preferences_cb        (GtkWidget *w, gpointer user_data);
void fe_quit_cb               (GtkWidget *w, gpointer user_data);

/*
 * Configuration
 */
void fe_config_load        (void);
void fe_config_save        (void);

void fe_config_open_dialog (void);

/*
 * Work area
 */
GtkWidget* fe_workarea_create          (void);
void       fe_workarea_add_tab         (GtkWidget *tab, const gchar *label);
void       fe_workarea_activate_tab    (GtkWidget *tab);
GtkWidget* fe_workarea_get_current_tab (void);
void       fe_workarea_remove_tab      (GtkWidget *tab);

/*
 * Global variables
 */
extern GtkWidget*  glb_mainwin;

/*
 * Configuration sections
 */
#define GNOMEDB_FE_CONFIG_SECTION_MAIN "/gnomedb-fe"
#define GNOMEDB_FE_CONFIG_SECTION_LOAD "/gnomedb-fe/Load"

#define GNOMEDB_FE_CONFIG_KEY_SAVE_WINDOW_POS "/gnomedb-fe/General/SaveWindowPos"

END_GNOME_DECLS

#endif