/* GNOME DB library
 * Copyright (C) 2000 Rodrigo Moya
 *
 * This Library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This Library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this Library; see the file COPYING.LIB.  If not,
 * write to the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

#if !defined(__gnome_db_log_viewer_h__)
#  define __gnome_db_log_viewer_h__

#include <gtk/gtkvbox.h>
#include <libgnome/gnome-defs.h>

BEGIN_GNOME_DECLS

#define GNOME_DB_TYPE_LOG_VIEWER            (gnome_db_log_viewer_get_type())
#define GNOME_DB_LOG_VIEWER(obj)            GTK_CHECK_CAST(obj, GNOME_DB_TYPE_LOG_VIEWER, GnomeDbLogViewer)
#define GNOME_DB_LOG_VIEWER_CLASS(klass)    GTK_CHECK_CLASS_CAST(klass, GNOME_DB_TYPE_LOG_VIEWER, GnomeDbLogViewerClass)
#define GNOME_DB_IS_LOG_VIEWER(obj)         GTK_CHECK_TYPE(obj, GNOME_DB_TYPE_LOG_VIEWER)
#define GNOME_DB_IS_LOG_VIEWER_CLASS(klass) (GTK_CHECK_CLASS_TYPE((klass), GNOME_DB_TYPE_LOG_VIEWER))

typedef struct _GnomeDbLogViewer      GnomeDbLogViewer;
typedef struct _GnomeDbLogViewerClass GnomeDbLogViewerClass;

struct _GnomeDbLogViewer {
	GtkVBox    vbox;

	/* these fields are private, don't use them */
	GtkWidget* msg_list;
	gchar*     filename;
};

struct _GnomeDbLogViewerClass {
	GtkVBoxClass parent_class;
};

GtkType    gnome_db_log_viewer_get_type     (void);
GtkWidget* gnome_db_log_viewer_new          (void);
gboolean   gnome_db_log_viewer_load_file    (GnomeDbLogViewer *viewer,
											 const gchar *filename);
void       gnome_db_log_viewer_refresh      (GnomeDbLogViewer *viewer);
void       gnome_db_log_viewer_clear        (GnomeDbLogViewer *viewer);
void       gnome_db_log_viewer_show_current (GnomeDbLogViewer *viewer);

void       gnome_db_log_viewer_save         (GnomeDbLogViewer *viewer, const gchar *filename);

END_GNOME_DECLS

#endif
