/*  -*- Mode: C; tab-width: 4; indent-tabs-mode: nil; c-basic-offset: 4 -*-
 * 
 * This file is part of the GNOME Debugging Framework.
 * 
 * Copyright (C) 1999-2000 Dave Camp <campd@oit.edu>
 *                         Martin Baulig <martin@home-of-linux.org>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.  
 */

/* Miscellaneous GDF tools/macros */

#ifndef __GDF_TOOLS_H__
#define __GDF_TOOLS_H__

#include <glib.h>

BEGIN_GNOME_DECLS

/* FIXME: Toggle this */

#ifdef __GNUC__

#undef DO_GDF_TRACE

#ifdef DO_GDF_TRACE

#define GDF_TRACE()  G_STMT_START {             \
    g_log (G_LOG_DOMAIN,                      \
	   G_LOG_LEVEL_DEBUG,                 \
	   "file %s: line %d (%s)",           \
	   __FILE__,                          \
	   __LINE__,                          \
	   __PRETTY_FUNCTION__); } G_STMT_END 

#define GDF_TRACE_EXTRA(format, args...) G_STMT_START {     \
    g_log (G_LOG_DOMAIN,                      \
	   G_LOG_LEVEL_DEBUG,                 \
	   "file %s: line %d (%s): "format,   \
	   __FILE__,                          \
	   __LINE__,                          \
	   __PRETTY_FUNCTION__,               \
	   ##args); } G_STMT_END                   
    
#else /* __GNUC__ */

#define GDF_TRACE()  G_STMT_START {             \
    g_log (G_LOG_DOMAIN,                      \
	   G_LOG_LEVEL_DEBUG,                 \
	   "file %s: line %d",                \
	   __FILE__,                          \
	   __LINE__); } G_STMT_END 

#define GDF_TRACE_EXTRA(format, args...) G_STMT_START {     \
    g_log (G_LOG_DOMAIN,                      \
	   G_LOG_LEVEL_DEBUG,                 \
	   "file %s: line %d: "format,        \
	   __FILE__,                          \
	   __LINE__,                          \
	   ##args); } G_STMT_END                       
#endif /* __GNUC__ */

#else 
#define GDF_TRACE()
#define GDF_TRACE_EXTRA()
#endif

END_GNOME_DECLS

#endif
