/*  -*- Mode: C; tab-width: 4; indent-tabs-mode: nil; c-basic-offset: 4 -*-
 * 
 * This file is part of the GNOME Debugging Framework.
 * 
 * Copyright (C) 1999-2000 Martin Baulig <martin@home-of-linux.org>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.  
 */

#ifndef __GDF_EVENT_CHANNEL_CLIENT_H__
#define __GDF_EVENT_CHANNEL_CLIENT_H__

#include <bonobo.h>
#include "gnome-debug.h"

BEGIN_GNOME_DECLS

#define GDF_EVENT_CHANNEL_CLIENT_TYPE		(gdf_event_channel_client_get_type ())
#define GDF_EVENT_CHANNEL_CLIENT(o)		(GTK_CHECK_CAST ((o), GDF_EVENT_CHANNEL_CLIENT_TYPE, GdfEventChannelClient))
#define GDF_EVENT_CHANNEL_CLIENT_CLASS(k)	(GTK_CHECK_CLASS_CAST((k), GDF_EVENT_CHANNEL_CLIENT_TYPE, GdfEventChannelClientClass))
#define GDF_IS_EVENT_CHANNEL_CLIENT(o)		(GTK_CHECK_TYPE ((o), GDF_EVENT_CHANNEL_CLIENT_TYPE))
#define GDF_IS_EVENT_CHANNEL_CLIENT_CLASS(k)	(GTK_CHECK_CLASS_TYPE ((k), GDF_EVENT_CHANNEL_CLIENT_TYPE))

typedef struct _GdfEventChannelClient		GdfEventChannelClient;
typedef struct _GdfEventChannelClientPrivate	GdfEventChannelClientPrivate;
typedef struct _GdfEventChannelClientClass	GdfEventChannelClientClass;


struct _GdfEventChannelClient {
    BonoboObjectClient parent;

    GdfEventChannelClientPrivate *priv;
};

struct _GdfEventChannelClientClass {
    BonoboObjectClientClass parent_class;

    void (*event_pushed) (GdfEventChannelClient *, CORBA_any *);
};

extern GdfEventChannelClient *
gdf_event_channel_client_new (void);

extern GdfEventChannelClient *
gdf_event_channel_client_new_from_corba (CosEventChannelAdmin_EventChannel);

extern GdfEventChannelClient *
gdf_event_channel_client_construct (GdfEventChannelClient *,
                                    CosEventChannelAdmin_EventChannel);

extern void
gdf_event_channel_client_push (GdfEventChannelClient *, CORBA_any *);

extern void
gdf_event_channel_client_destroy_channel (GdfEventChannelClient *);

extern void
gdf_event_channel_client_listen (GdfEventChannelClient *);

extern GtkType 
gdf_event_channel_client_get_type (void);

END_GNOME_DECLS

#endif
