<?xml version="1.0" encoding="UTF-8"?>
<xslt:stylesheet xmlns:xslt="http://www.w3.org/1999/XSL/Transform" xmlns:msg="http://www.gnome.org/~shaunm/gnome-doc-utils/xsl-format" version="1.0">
  <title xmlns="http://www.gnome.org/~shaunm/xsldoc">Format Templates</title>
  <template xmlns="http://www.gnome.org/~shaunm/xsldoc">
    <name>format.citetitle</name>
    <description>
    Format a <xmltag>citetitle</xmltag> element
  </description>
    <parameter>
      <name>lang</name>
      <description>
              The language language to use for formatting
            </description>
    </parameter>
    <parameter>
      <name>node</name>
      <description>
      The <xmltag>citetitle</xmltag> element to format
    </description>
    </parameter>
    <parameter>
      <name>role</name>
      <description>
      The role of the label
    </description>
    </parameter>
  </template>
  <xslt:template name="format.citetitle">
    <xslt:param select="." name="node"/>
    <xslt:param name="role"/>
    <xslt:param name="lang" select="$node/ancestor-or-self::*[@lang][1]/@lang"/>
    <xslt:variable name="lang_lang">
      <xslt:call-template name="gettext.get.language">
        <xslt:with-param name="lang" select="$lang"/>
      </xslt:call-template>
    </xslt:variable>
    <xslt:variable name="lang_region">
      <xslt:call-template name="gettext.get.region">
        <xslt:with-param name="lang" select="$lang"/>
      </xslt:call-template>
    </xslt:variable>
    <xslt:variable name="lang_variant">
      <xslt:call-template name="gettext.get.variant">
        <xslt:with-param name="lang" select="$lang"/>
      </xslt:call-template>
    </xslt:variable>
    <xslt:variable name="lang_charset">
      <xslt:call-template name="gettext.get.charset">
        <xslt:with-param name="lang" select="$lang"/>
      </xslt:call-template>
    </xslt:variable>
    <xslt:choose>
      <xslt:when test="$role = 'article'">
        <xslt:text>“</xslt:text>
        <xslt:apply-templates select="$node/node()"/>
        <xslt:text>”</xslt:text>
      </xslt:when>
      <xslt:otherwise>
        <i>
          <xslt:text/>
          <xslt:apply-templates select="$node/node()"/>
          <xslt:text/>
        </i>
      </xslt:otherwise>
    </xslt:choose>
  </xslt:template>
  <template xmlns="http://www.gnome.org/~shaunm/xsldoc">
    <name>format.date</name>
    <description>
    Format a date
  </description>
    <parameter>
      <name>lang</name>
      <description>
              The language language to use for formatting
            </description>
    </parameter>
    <parameter>
      <node>year</node>
      <description>
      The year in the Gregorian calendar
    </description>
    </parameter>
    <parameter>
      <name>month</name>
      <description>
      The number of the month
    </description>
    </parameter>
    <parameter>
      <name>day</name>
      <description>
      The number of the day in the month
    </description>
    </parameter>
  </template>
  <xslt:template name="format.date">
    <xslt:param name="year"/>
    <xslt:param name="month"/>
    <xslt:param name="day"/>
    <xslt:param name="lang" select="$node/ancestor-or-self::*[@lang][1]/@lang"/>
    <xslt:variable name="lang_lang">
      <xslt:call-template name="gettext.get.language">
        <xslt:with-param name="lang" select="$lang"/>
      </xslt:call-template>
    </xslt:variable>
    <xslt:variable name="lang_region">
      <xslt:call-template name="gettext.get.region">
        <xslt:with-param name="lang" select="$lang"/>
      </xslt:call-template>
    </xslt:variable>
    <xslt:variable name="lang_variant">
      <xslt:call-template name="gettext.get.variant">
        <xslt:with-param name="lang" select="$lang"/>
      </xslt:call-template>
    </xslt:variable>
    <xslt:variable name="lang_charset">
      <xslt:call-template name="gettext.get.charset">
        <xslt:with-param name="lang" select="$lang"/>
      </xslt:call-template>
    </xslt:variable>
    <xslt:choose>
      <xslt:when test="$month =  1">
        <xslt:text>January </xslt:text>
      </xslt:when>
      <xslt:when test="$month =  2">
        <xslt:text>February </xslt:text>
      </xslt:when>
      <xslt:when test="$month =  3">
        <xslt:text>March </xslt:text>
      </xslt:when>
      <xslt:when test="$month =  4">
        <xslt:text>April </xslt:text>
      </xslt:when>
      <xslt:when test="$month =  5">
        <xslt:text>May </xslt:text>
      </xslt:when>
      <xslt:when test="$month =  6">
        <xslt:text>June </xslt:text>
      </xslt:when>
      <xslt:when test="$month =  7">
        <xslt:text>July </xslt:text>
      </xslt:when>
      <xslt:when test="$month =  8">
        <xslt:text>August </xslt:text>
      </xslt:when>
      <xslt:when test="$month =  9">
        <xslt:text>September </xslt:text>
      </xslt:when>
      <xslt:when test="$month = 10">
        <xslt:text>October </xslt:text>
      </xslt:when>
      <xslt:when test="$month = 11">
        <xslt:text>November </xslt:text>
      </xslt:when>
      <xslt:when test="$month = 12">
        <xslt:text>December </xslt:text>
      </xslt:when>
    </xslt:choose>
    <xslt:value-of select="$day"/>
    <xslt:text>, </xslt:text>
    <xslt:value-of select="$year"/>
  </xslt:template>
  <template xmlns="http://www.gnome.org/~shaunm/xsldoc">
    <name>format.quote.outer</name>
    <description>
    Format a <xmltag>quote</xmltag> element
  </description>
    <parameter>
      <name>lang</name>
      <description>
              The language language to use for formatting
            </description>
    </parameter>
    <parameter>
      <name>node</name>
      <description>
      The <xmltag>quote</xmltag> element to format
    </description>
    </parameter>
  </template>
  <xslt:template name="format.quote.outer">
    <xslt:param select="." name="node"/>
    <xslt:param name="lang" select="$node/ancestor-or-self::*[@lang][1]/@lang"/>
    <xslt:variable name="lang_lang">
      <xslt:call-template name="gettext.get.language">
        <xslt:with-param name="lang" select="$lang"/>
      </xslt:call-template>
    </xslt:variable>
    <xslt:variable name="lang_region">
      <xslt:call-template name="gettext.get.region">
        <xslt:with-param name="lang" select="$lang"/>
      </xslt:call-template>
    </xslt:variable>
    <xslt:variable name="lang_variant">
      <xslt:call-template name="gettext.get.variant">
        <xslt:with-param name="lang" select="$lang"/>
      </xslt:call-template>
    </xslt:variable>
    <xslt:variable name="lang_charset">
      <xslt:call-template name="gettext.get.charset">
        <xslt:with-param name="lang" select="$lang"/>
      </xslt:call-template>
    </xslt:variable>
    <xslt:text>“</xslt:text>
    <xslt:apply-templates select="$node/node()"/>
    <xslt:text>”</xslt:text>
  </xslt:template>
  <template xmlns="http://www.gnome.org/~shaunm/xsldoc">
    <name>format.quote.inner</name>
    <description>
    Format a nested <xmltag>quote</xmltag> element
  </description>
    <parameter>
      <name>lang</name>
      <description>
              The language language to use for formatting
            </description>
    </parameter>
    <parameter>
      <name>node</name>
      <description>
      The <xmltag>quote</xmltag> element to format
    </description>
    </parameter>
  </template>
  <xslt:template name="format.quote.inner">
    <xslt:param select="." name="node"/>
    <xslt:param name="lang" select="$node/ancestor-or-self::*[@lang][1]/@lang"/>
    <xslt:variable name="lang_lang">
      <xslt:call-template name="gettext.get.language">
        <xslt:with-param name="lang" select="$lang"/>
      </xslt:call-template>
    </xslt:variable>
    <xslt:variable name="lang_region">
      <xslt:call-template name="gettext.get.region">
        <xslt:with-param name="lang" select="$lang"/>
      </xslt:call-template>
    </xslt:variable>
    <xslt:variable name="lang_variant">
      <xslt:call-template name="gettext.get.variant">
        <xslt:with-param name="lang" select="$lang"/>
      </xslt:call-template>
    </xslt:variable>
    <xslt:variable name="lang_charset">
      <xslt:call-template name="gettext.get.charset">
        <xslt:with-param name="lang" select="$lang"/>
      </xslt:call-template>
    </xslt:variable>
    <xslt:choose>
      <xslt:when test="$lang_lang = 'en' and $lang_region = 'CA'">
        <xslt:text>format.quote.outer</xslt:text>
      </xslt:when>
      <xslt:when test="$lang_lang = 'en' and $lang_region = 'GB'">
        <xslt:text>format.quote.outer</xslt:text>
      </xslt:when>
      <xslt:when test="$lang_lang = 'cs'">
        <xslt:text>format.quote.outer</xslt:text>
      </xslt:when>
      <xslt:otherwise>
        <xslt:text>‘</xslt:text>
        <xslt:apply-templates select="$node/node()"/>
        <xslt:text>’</xslt:text>
      </xslt:otherwise>
    </xslt:choose>
  </xslt:template>
  <template xmlns="http://www.gnome.org/~shaunm/xsldoc">
    <name>format.chapter.label</name>
    <description>
    Format the label for a <xmltag>chapter</xmltag> element
  </description>
    <parameter>
      <name>lang</name>
      <description>
              The language language to use for formatting
            </description>
    </parameter>
    <parameter>
      <name>node</name>
      <description>
      The <xmltag>chapter</xmltag> element to format
    </description>
    </parameter>
    <parameter>
      <name>role</name>
      <description>
      The role of the label
    </description>
    </parameter>
    <parameter>
      <name>depth_in_chunk</name>
      <description>
      The depth of the element in the containing chunk
    </description>
    </parameter>
  </template>
  <xslt:template name="format.chapter.label">
    <xslt:param select="." name="node"/>
    <xslt:param name="role"/>
    <xslt:param name="depth_in_chunk">
      <xslt:call-template name="db.chunk.depth-in-chunk">
        <xslt:with-param select="$node" name="node"/>
      </xslt:call-template>
    </xslt:param>
    <xslt:param name="lang" select="$node/ancestor-or-self::*[@lang][1]/@lang"/>
    <xslt:variable name="lang_lang">
      <xslt:call-template name="gettext.get.language">
        <xslt:with-param name="lang" select="$lang"/>
      </xslt:call-template>
    </xslt:variable>
    <xslt:variable name="lang_region">
      <xslt:call-template name="gettext.get.region">
        <xslt:with-param name="lang" select="$lang"/>
      </xslt:call-template>
    </xslt:variable>
    <xslt:variable name="lang_variant">
      <xslt:call-template name="gettext.get.variant">
        <xslt:with-param name="lang" select="$lang"/>
      </xslt:call-template>
    </xslt:variable>
    <xslt:variable name="lang_charset">
      <xslt:call-template name="gettext.get.charset">
        <xslt:with-param name="lang" select="$lang"/>
      </xslt:call-template>
    </xslt:variable>
    <xslt:text>Chapter </xslt:text>
    <xslt:call-template name="db.label.number">
      <xslt:with-param select="$node" name="node"/>
      <xslt:with-param select="$depth_in_chunk" name="depth_in_chunk"/>
    </xslt:call-template>
    <xslt:text/>
  </xslt:template>
  <template xmlns="http://www.gnome.org/~shaunm/xsldoc">
    <name>format.figure.label</name>
    <description>
    Format the label for a <xmltag>figure</xmltag> element
  </description>
    <parameter>
      <name>lang</name>
      <description>
              The language language to use for formatting
            </description>
    </parameter>
    <parameter>
      <name>node</name>
      <description>
      The <xmltag>figure</xmltag> element to format
    </description>
    </parameter>
    <parameter>
      <name>role</name>
      <description>
      The role of the label
    </description>
    </parameter>
    <parameter>
      <name>depth_in_chunk</name>
      <description>
      The depth of the element in the containing chunk
    </description>
    </parameter>
  </template>
  <xslt:template name="format.figure.label">
    <xslt:param select="." name="node"/>
    <xslt:param name="role"/>
    <xslt:param name="depth_in_chunk">
      <xslt:call-template name="db.chunk.depth-in-chunk">
        <xslt:with-param select="$node" name="node"/>
      </xslt:call-template>
    </xslt:param>
    <xslt:param name="lang" select="$node/ancestor-or-self::*[@lang][1]/@lang"/>
    <xslt:variable name="lang_lang">
      <xslt:call-template name="gettext.get.language">
        <xslt:with-param name="lang" select="$lang"/>
      </xslt:call-template>
    </xslt:variable>
    <xslt:variable name="lang_region">
      <xslt:call-template name="gettext.get.region">
        <xslt:with-param name="lang" select="$lang"/>
      </xslt:call-template>
    </xslt:variable>
    <xslt:variable name="lang_variant">
      <xslt:call-template name="gettext.get.variant">
        <xslt:with-param name="lang" select="$lang"/>
      </xslt:call-template>
    </xslt:variable>
    <xslt:variable name="lang_charset">
      <xslt:call-template name="gettext.get.charset">
        <xslt:with-param name="lang" select="$lang"/>
      </xslt:call-template>
    </xslt:variable>
    <xslt:text>Figure </xslt:text>
    <xslt:call-template name="db.label.number">
      <xslt:with-param select="$node" name="node"/>
      <xslt:with-param select="$depth_in_chunk" name="depth_in_chunk"/>
    </xslt:call-template>
    <xslt:text/>
  </xslt:template>
  <template xmlns="http://www.gnome.org/~shaunm/xsldoc">
    <name>format.section.label</name>
    <description>
    Format the label for a <xmltag>section</xmltag> element
  </description>
    <parameter>
      <name>lang</name>
      <description>
              The language language to use for formatting
            </description>
    </parameter>
    <parameter>
      <name>node</name>
      <description>
      The <xmltag>section</xmltag> element to format
    </description>
    </parameter>
    <parameter>
      <name>role</name>
      <description><template><name>format.example.label</name><description>
    Format the label for a <xmltag>example</xmltag> element
  </description><parameter><name>lang</name><description>
              The language language to use for formatting
            </description></parameter><parameter><name>node</name><description>
      The <xmltag>example</xmltag> element to format
    </description></parameter><parameter><name>role</name><description>
      The role of the label
    </description></parameter><parameter><name>depth_in_chunk</name><description>
      The depth of the element in the containing chunk
    </description></parameter></template><xslt:template name="format.example.label"><xslt:param select="." name="node"/><xslt:param name="role"/><xslt:param name="depth_in_chunk"><xslt:call-template name="db.chunk.depth-in-chunk"><xslt:with-param select="$node" name="node"/></xslt:call-template></xslt:param><xslt:param name="lang" select="$node/ancestor-or-self::*[@lang][1]/@lang"/><xslt:variable name="lang_lang"><xslt:call-template name="gettext.get.language"><xslt:with-param name="lang" select="$lang"/></xslt:call-template></xslt:variable><xslt:variable name="lang_region"><xslt:call-template name="gettext.get.region"><xslt:with-param name="lang" select="$lang"/></xslt:call-template></xslt:variable><xslt:variable name="lang_variant"><xslt:call-template name="gettext.get.variant"><xslt:with-param name="lang" select="$lang"/></xslt:call-template></xslt:variable><xslt:variable name="lang_charset"><xslt:call-template name="gettext.get.charset"><xslt:with-param name="lang" select="$lang"/></xslt:call-template></xslt:variable><xslt:text>Example </xslt:text><xslt:call-template name="db.label.number"><xslt:with-param select="$node" name="node"/><xslt:with-param select="$depth_in_chunk" name="depth_in_chunk"/></xslt:call-template><xslt:text/></xslt:template>


      The role of the label
    </description>
    </parameter>
    <parameter>
      <name>depth_in_chunk</name>
      <description>
      The depth of the element in the containing chunk
    </description>
    </parameter>
  </template>
  <xslt:template name="format.section.label">
    <xslt:param select="." name="node"/>
    <xslt:param name="role"/>
    <xslt:param name="depth_in_chunk">
      <xslt:call-template name="db.chunk.depth-in-chunk">
        <xslt:with-param select="$node" name="node"/>
      </xslt:call-template>
    </xslt:param>
    <xslt:param name="lang" select="$node/ancestor-or-self::*[@lang][1]/@lang"/>
    <xslt:variable name="lang_lang">
      <xslt:call-template name="gettext.get.language">
        <xslt:with-param name="lang" select="$lang"/>
      </xslt:call-template>
    </xslt:variable>
    <xslt:variable name="lang_region">
      <xslt:call-template name="gettext.get.region">
        <xslt:with-param name="lang" select="$lang"/>
      </xslt:call-template>
    </xslt:variable>
    <xslt:variable name="lang_variant">
      <xslt:call-template name="gettext.get.variant">
        <xslt:with-param name="lang" select="$lang"/>
      </xslt:call-template>
    </xslt:variable>
    <xslt:variable name="lang_charset">
      <xslt:call-template name="gettext.get.charset">
        <xslt:with-param name="lang" select="$lang"/>
      </xslt:call-template>
    </xslt:variable>
    <xslt:text>Section </xslt:text>
    <xslt:call-template name="db.label.number">
      <xslt:with-param select="$node" name="node"/>
      <xslt:with-param select="$depth_in_chunk" name="depth_in_chunk"/>
    </xslt:call-template>
    <xslt:text/>
  </xslt:template>
  <template xmlns="http://www.gnome.org/~shaunm/xsldoc">
    <name>format.table.label</name>
    <description>
    Format the label for a <xmltag>table</xmltag> element
  </description>
    <parameter>
      <name>lang</name>
      <description>
              The language language to use for formatting
            </description>
    </parameter>
    <parameter>
      <name>node</name>
      <description>
      The <xmltag>table</xmltag> element to format
    </description>
    </parameter>
    <parameter>
      <name>role</name>
      <description>
      The role of the label
    </description>
    </parameter>
    <parameter>
      <name>depth_in_chunk</name>
      <description>
      The depth of the element in the containing chunk
    </description>
    </parameter>
  </template>
  <xslt:template name="format.table.label">
    <xslt:param select="." name="node"/>
    <xslt:param name="role"/>
    <xslt:param name="depth_in_chunk">
      <xslt:call-template name="db.chunk.depth-in-chunk">
        <xslt:with-param select="$node" name="node"/>
      </xslt:call-template>
    </xslt:param>
    <xslt:param name="lang" select="$node/ancestor-or-self::*[@lang][1]/@lang"/>
    <xslt:variable name="lang_lang">
      <xslt:call-template name="gettext.get.language">
        <xslt:with-param name="lang" select="$lang"/>
      </xslt:call-template>
    </xslt:variable>
    <xslt:variable name="lang_region">
      <xslt:call-template name="gettext.get.region">
        <xslt:with-param name="lang" select="$lang"/>
      </xslt:call-template>
    </xslt:variable>
    <xslt:variable name="lang_variant">
      <xslt:call-template name="gettext.get.variant">
        <xslt:with-param name="lang" select="$lang"/>
      </xslt:call-template>
    </xslt:variable>
    <xslt:variable name="lang_charset">
      <xslt:call-template name="gettext.get.charset">
        <xslt:with-param name="lang" select="$lang"/>
      </xslt:call-template>
    </xslt:variable>
    <xslt:text>Table </xslt:text>
    <xslt:call-template name="db.label.number">
      <xslt:with-param select="$node" name="node"/>
      <xslt:with-param select="$depth_in_chunk" name="depth_in_chunk"/>
    </xslt:call-template>
    <xslt:text/>
  </xslt:template>
  <template xmlns="http://www.gnome.org/~shaunm/xsldoc">
    <name>format.example.number</name>
    <description>
    Format the number for a <xmltag>example</xmltag> element
  </description>
    <parameter>
      <name>lang</name>
      <description>
              The language language to use for formatting
            </description>
    </parameter>
    <parameter>
      <name>node</name>
      <description>
      The element for which to generate a number
    </description>
    </parameter>
  </template>
  <xslt:template name="format.example.number">
    <xslt:param select="." name="node"/>
    <xslt:param name="lang" select="$node/ancestor-or-self::*[@lang][1]/@lang"/>
    <xslt:variable name="lang_lang">
      <xslt:call-template name="gettext.get.language">
        <xslt:with-param name="lang" select="$lang"/>
      </xslt:call-template>
    </xslt:variable>
    <xslt:variable name="lang_region">
      <xslt:call-template name="gettext.get.region">
        <xslt:with-param name="lang" select="$lang"/>
      </xslt:call-template>
    </xslt:variable>
    <xslt:variable name="lang_variant">
      <xslt:call-template name="gettext.get.variant">
        <xslt:with-param name="lang" select="$lang"/>
      </xslt:call-template>
    </xslt:variable>
    <xslt:variable name="lang_charset">
      <xslt:call-template name="gettext.get.charset">
        <xslt:with-param name="lang" select="$lang"/>
      </xslt:call-template>
    </xslt:variable>
    <xslt:text/>
    <xslt:call-template name="db.label.number">
      <xslt:with-param select="                       $node/ancestor::appendix |                       $node/ancestor::chapter  " name="node"/>
    </xslt:call-template>
    <xslt:text>-</xslt:text>
    <xslt:number format="1" level="any" from="chapter | appendix" count="example"/>
    <xslt:text/>
  </xslt:template>
  <template xmlns="http://www.gnome.org/~shaunm/xsldoc">
    <name>format.example.number.flat</name>
    <description>
    Format the number for a <xmltag>example</xmltag> element in a flat document
  </description>
    <parameter>
      <name>lang</name>
      <description>
              The language language to use for formatting
            </description>
    </parameter>
    <parameter>
      <name>node</name>
      <description>
      The element for which to generate a number
    </description>
    </parameter>
  </template>
  <xslt:template name="format.example.number.flat">
    <xslt:param select="." name="node"/>
    <xslt:param name="lang" select="$node/ancestor-or-self::*[@lang][1]/@lang"/>
    <xslt:variable name="lang_lang">
      <xslt:call-template name="gettext.get.language">
        <xslt:with-param name="lang" select="$lang"/>
      </xslt:call-template>
    </xslt:variable>
    <xslt:variable name="lang_region">
      <xslt:call-template name="gettext.get.region">
        <xslt:with-param name="lang" select="$lang"/>
      </xslt:call-template>
    </xslt:variable>
    <xslt:variable name="lang_variant">
      <xslt:call-template name="gettext.get.variant">
        <xslt:with-param name="lang" select="$lang"/>
      </xslt:call-template>
    </xslt:variable>
    <xslt:variable name="lang_charset">
      <xslt:call-template name="gettext.get.charset">
        <xslt:with-param name="lang" select="$lang"/>
      </xslt:call-template>
    </xslt:variable>
    <xslt:text/>
    <xslt:number format="1" level="any" from="chapter | appendix" count="example"/>
    <xslt:text/>
  </xslt:template>
  <template xmlns="http://www.gnome.org/~shaunm/xsldoc">
    <name>format.figure.number</name>
    <description>
    Format the number for a <xmltag>figure</xmltag> element
  </description>
    <parameter>
      <name>lang</name>
      <description>
              The language language to use for formatting
            </description>
    </parameter>
    <parameter>
      <name>node</name>
      <description>
      The element for which to generate a number
    </description>
    </parameter>
  </template>
  <xslt:template name="format.figure.number">
    <xslt:param select="." name="node"/>
    <xslt:param name="lang" select="$node/ancestor-or-self::*[@lang][1]/@lang"/>
    <xslt:variable name="lang_lang">
      <xslt:call-template name="gettext.get.language">
        <xslt:with-param name="lang" select="$lang"/>
      </xslt:call-template>
    </xslt:variable>
    <xslt:variable name="lang_region">
      <xslt:call-template name="gettext.get.region">
        <xslt:with-param name="lang" select="$lang"/>
      </xslt:call-template>
    </xslt:variable>
    <xslt:variable name="lang_variant">
      <xslt:call-template name="gettext.get.variant">
        <xslt:with-param name="lang" select="$lang"/>
      </xslt:call-template>
    </xslt:variable>
    <xslt:variable name="lang_charset">
      <xslt:call-template name="gettext.get.charset">
        <xslt:with-param name="lang" select="$lang"/>
      </xslt:call-template>
    </xslt:variable>
    <xslt:text/>
    <xslt:call-template name="db.label.number">
      <xslt:with-param select="                       $node/ancestor::appendix |                       $node/ancestor::chapter  " name="node"/>
    </xslt:call-template>
    <xslt:text>-</xslt:text>
    <xslt:number format="1" level="any" from="chapter | appendix" count="figure"/>
    <xslt:text/>
  </xslt:template>
  <template xmlns="http://www.gnome.org/~shaunm/xsldoc">
    <name>format.figure.number.flat</name>
    <description>
    Format the number for a <xmltag>figure</xmltag> element in a flat document
  </description>
    <parameter>
      <name>lang</name>
      <description>
              The language language to use for formatting
            </description>
    </parameter>
    <parameter>
      <name>node</name>
      <description>
      The element for which to generate a number
    </description>
    </parameter>
  </template>
  <xslt:template name="format.figure.number.flat">
    <xslt:param select="." name="node"/>
    <xslt:param name="lang" select="$node/ancestor-or-self::*[@lang][1]/@lang"/>
    <xslt:variable name="lang_lang">
      <xslt:call-template name="gettext.get.language">
        <xslt:with-param name="lang" select="$lang"/>
      </xslt:call-template>
    </xslt:variable>
    <xslt:variable name="lang_region">
      <xslt:call-template name="gettext.get.region">
        <xslt:with-param name="lang" select="$lang"/>
      </xslt:call-template>
    </xslt:variable>
    <xslt:variable name="lang_variant">
      <xslt:call-template name="gettext.get.variant">
        <xslt:with-param name="lang" select="$lang"/>
      </xslt:call-template>
    </xslt:variable>
    <xslt:variable name="lang_charset">
      <xslt:call-template name="gettext.get.charset">
        <xslt:with-param name="lang" select="$lang"/>
      </xslt:call-template>
    </xslt:variable>
    <xslt:text/>
    <xslt:number format="1" level="any" from="chapter | appendix" count="figure"/>
    <xslt:text/>
  </xslt:template>
  <template xmlns="http://www.gnome.org/~shaunm/xsldoc">
    <name>format.table.number</name>
    <description>
    Format the number for a <xmltag>table</xmltag> element
  </description>
    <parameter>
      <name>lang</name>
      <description>
              The language language to use for formatting
            </description>
    </parameter>
    <parameter>
      <name>node</name>
      <description>
      The element for which to generate a number
    </description>
    </parameter>
  </template>
  <xslt:template name="format.table.number">
    <xslt:param select="." name="node"/>
    <xslt:param name="lang" select="$node/ancestor-or-self::*[@lang][1]/@lang"/>
    <xslt:variable name="lang_lang">
      <xslt:call-template name="gettext.get.language">
        <xslt:with-param name="lang" select="$lang"/>
      </xslt:call-template>
    </xslt:variable>
    <xslt:variable name="lang_region">
      <xslt:call-template name="gettext.get.region">
        <xslt:with-param name="lang" select="$lang"/>
      </xslt:call-template>
    </xslt:variable>
    <xslt:variable name="lang_variant">
      <xslt:call-template name="gettext.get.variant">
        <xslt:with-param name="lang" select="$lang"/>
      </xslt:call-template>
    </xslt:variable>
    <xslt:variable name="lang_charset">
      <xslt:call-template name="gettext.get.charset">
        <xslt:with-param name="lang" select="$lang"/>
      </xslt:call-template>
    </xslt:variable>
    <xslt:text/>
    <xslt:call-template name="db.label.number">
      <xslt:with-param select="                       $node/ancestor::appendix |                       $node/ancestor::chapter  " name="node"/>
    </xslt:call-template>
    <xslt:text>-</xslt:text>
    <xslt:number format="1" level="any" from="chapter | appendix" count="table"/>
    <xslt:text/>
  </xslt:template>
  <template xmlns="http://www.gnome.org/~shaunm/xsldoc">
    <name>format.table.number.flat</name>
    <description>
    Format the number for a <xmltag>table</xmltag> element in a flat document
  </description>
    <parameter>
      <name>lang</name>
      <description>
              The language language to use for formatting
            </description>
    </parameter>
    <parameter>
      <name>node</name>
      <description>
      The element for which to generate a number
    </description>
    </parameter>
  </template>
  <xslt:template name="format.table.number.flat">
    <xslt:param select="." name="node"/>
    <xslt:param name="lang" select="$node/ancestor-or-self::*[@lang][1]/@lang"/>
    <xslt:variable name="lang_lang">
      <xslt:call-template name="gettext.get.language">
        <xslt:with-param name="lang" select="$lang"/>
      </xslt:call-template>
    </xslt:variable>
    <xslt:variable name="lang_region">
      <xslt:call-template name="gettext.get.region">
        <xslt:with-param name="lang" select="$lang"/>
      </xslt:call-template>
    </xslt:variable>
    <xslt:variable name="lang_variant">
      <xslt:call-template name="gettext.get.variant">
        <xslt:with-param name="lang" select="$lang"/>
      </xslt:call-template>
    </xslt:variable>
    <xslt:variable name="lang_charset">
      <xslt:call-template name="gettext.get.charset">
        <xslt:with-param name="lang" select="$lang"/>
      </xslt:call-template>
    </xslt:variable>
    <xslt:text/>
    <xslt:number format="1" level="any" from="chapter | appendix" count="table"/>
    <xslt:text/>
  </xslt:template>
</xslt:stylesheet>
