<?xml version='1.0' encoding='UTF-8'?><!-- -*- indent-tabs-mode: nil -*- -->
<!--
This program is free software; you can redistribute it and/or modify it under
the terms of the GNU Lesser General Public License as published by the Free
Software Foundation; either version 2 of the License, or (at your option) any
later version.

This program is distributed in the hope that it will be useful, but WITHOUT
ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License for more
details.

You should have received a copy of the GNU Lesser General Public License
along with this program; see the file COPYING.LGPL.  If not, write to the
Free Software Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
02111-1307, USA.
-->

<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                xmlns:doc="http://www.gnome.org/~shaunm/xsldoc"
                xmlns="http://www.w3.org/1999/xhtml"
                exclude-result-prefixes="doc"
                version="1.0">

<doc:title>Links and Cross References</doc:title>


<!-- == db2html.anchor ===================================================== -->

<template xmlns="http://www.gnome.org/~shaunm/xsldoc">
  <name>db2html.anchor</name>
  <purpose>
    Generate an anchor point for an element
  </purpose>
</template>

<xsl:template name="db2html.anchor">
  <xsl:param name="node" select="."/>
  <xsl:param name="name" select="$node/@id"/>
  <xsl:if test="$name">
    <a name="{$name}"/>
  </xsl:if>
</xsl:template>


<!-- == Matched Templates ================================================== -->

<!-- = anchor = -->
<xsl:template match="anchor">
  <xsl:call-template name="db2html.anchor"/>
</xsl:template>

<!-- = link = -->
<xsl:template name="db2html.link" match="link">
  <xsl:param name="linkend" select="@linkend"/>
  <xsl:param name="target" select="key('idkey', $linkend)"/>
  <a class="link">
    <xsl:attribute name="href">
      <xsl:call-template name="db.xref.target">
        <xsl:with-param name="linkend" select="$linkend"/>
      </xsl:call-template>
    </xsl:attribute>
    <xsl:attribute name="title">
      <xsl:call-template name="db.xref.tooltip">
        <xsl:with-param name="linkend" select="$linkend"/>
        <xsl:with-param name="target" select="$target"/>
      </xsl:call-template>
    </xsl:attribute>
    <xsl:choose>
      <xsl:when test="normalize-space(.) != ''">
        <xsl:apply-templates/>
      </xsl:when>
      <xsl:when test="@endterm">
        <xsl:apply-templates select="key('idkey', @endterm)/node()"/>
      </xsl:when>
    </xsl:choose>
  </a>
</xsl:template>

<!-- 
<xsl:template match="olink">
<xsl:call-template name="FIXME"/>
</xsl:template>
-->

<!-- = ulink = -->
<xsl:template name="db2html.ulink" match="ulink">
  <xsl:param name="url" select="@url"/>
  <xsl:param name="content" select="false()"/>
  <a class="ulink" href="{$url}">
    <xsl:attribute name="title">
      <xsl:call-template name="db.ulink.tooltip"/>
    </xsl:attribute>
    <xsl:choose>
      <xsl:when test="$content">
        <xsl:copy-of select="$content"/>
      </xsl:when>
      <xsl:when test="string-length(normalize-space(node())) != 0">
        <xsl:apply-templates/>
      </xsl:when>
      <xsl:otherwise>
        <xsl:value-of select="$url"/>
      </xsl:otherwise>
    </xsl:choose>
  </a>
</xsl:template>

<!-- = xref = -->
<xsl:template name="db2html.xref" match="xref">
  <xsl:param name="linkend"   select="@linkend"/>
  <xsl:param name="target"    select="key('idkey', $linkend)"/>
  <xsl:param name="endterm"   select="@endterm"/>
  <xsl:param name="xrefstyle" select="@xrefstyle"/>
  <xsl:param name="content"   select="false()"/>
  <a class="xref">
    <xsl:attribute name="href">
      <xsl:call-template name="db.xref.target">
        <xsl:with-param name="linkend" select="$linkend"/>
        <xsl:with-param name="target" select="$target"/>
      </xsl:call-template>
    </xsl:attribute>
    <xsl:attribute name="title">
      <xsl:call-template name="db.xref.tooltip">
        <xsl:with-param name="linkend" select="$linkend"/>
        <xsl:with-param name="target" select="$target"/>
      </xsl:call-template>
    </xsl:attribute>
    <xsl:choose>
      <xsl:when test="$content">
        <xsl:copy-of select="$content"/>
      </xsl:when>
      <xsl:when test="$endterm">
        <xsl:apply-templates select="key('idkey', $endterm)"/>
      </xsl:when>
      <xsl:otherwise>
        <xsl:call-template name="db.xref.content">
          <xsl:with-param name="linkend" select="$linkend"/>
          <xsl:with-param name="target" select="$target"/>
          <xsl:with-param name="xrefstyle" select="$xrefstyle"/>
        </xsl:call-template>
      </xsl:otherwise>
    </xsl:choose>
  </a>
</xsl:template>

</xsl:stylesheet>
