
#ifndef __SRC_EVENT_H__
#define __SRC_EVENT_H__

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <time.h>

G_BEGIN_DECLS


#define DVB_TYPE_EVENT (dvb_event_get_type ())
#define DVB_EVENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_TYPE_EVENT, DVBEvent))
#define DVB_EVENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DVB_TYPE_EVENT, DVBEventClass))
#define DVB_IS_EVENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_TYPE_EVENT))
#define DVB_IS_EVENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DVB_TYPE_EVENT))
#define DVB_EVENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DVB_TYPE_EVENT, DVBEventClass))

typedef struct _DVBEvent DVBEvent;
typedef struct _DVBEventClass DVBEventClass;
typedef struct _DVBEventPrivate DVBEventPrivate;

#define DVB_EVENT_TYPE_AUDIO_COMPONENT (dvb_event_audio_component_get_type ())
#define DVB_EVENT_AUDIO_COMPONENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_EVENT_TYPE_AUDIO_COMPONENT, DVBEventAudioComponent))
#define DVB_EVENT_AUDIO_COMPONENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DVB_EVENT_TYPE_AUDIO_COMPONENT, DVBEventAudioComponentClass))
#define DVB_EVENT_IS_AUDIO_COMPONENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_EVENT_TYPE_AUDIO_COMPONENT))
#define DVB_EVENT_IS_AUDIO_COMPONENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DVB_EVENT_TYPE_AUDIO_COMPONENT))
#define DVB_EVENT_AUDIO_COMPONENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DVB_EVENT_TYPE_AUDIO_COMPONENT, DVBEventAudioComponentClass))

typedef struct _DVBEventAudioComponent DVBEventAudioComponent;
typedef struct _DVBEventAudioComponentClass DVBEventAudioComponentClass;
typedef struct _DVBEventAudioComponentPrivate DVBEventAudioComponentPrivate;
typedef struct _DVBEventParamSpecAudioComponent DVBEventParamSpecAudioComponent;

#define DVB_EVENT_TYPE_VIDEO_COMPONENT (dvb_event_video_component_get_type ())
#define DVB_EVENT_VIDEO_COMPONENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_EVENT_TYPE_VIDEO_COMPONENT, DVBEventVideoComponent))
#define DVB_EVENT_VIDEO_COMPONENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DVB_EVENT_TYPE_VIDEO_COMPONENT, DVBEventVideoComponentClass))
#define DVB_EVENT_IS_VIDEO_COMPONENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_EVENT_TYPE_VIDEO_COMPONENT))
#define DVB_EVENT_IS_VIDEO_COMPONENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DVB_EVENT_TYPE_VIDEO_COMPONENT))
#define DVB_EVENT_VIDEO_COMPONENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DVB_EVENT_TYPE_VIDEO_COMPONENT, DVBEventVideoComponentClass))

typedef struct _DVBEventVideoComponent DVBEventVideoComponent;
typedef struct _DVBEventVideoComponentClass DVBEventVideoComponentClass;
typedef struct _DVBEventVideoComponentPrivate DVBEventVideoComponentPrivate;
typedef struct _DVBEventParamSpecVideoComponent DVBEventParamSpecVideoComponent;

#define DVB_EVENT_TYPE_TELETEXT_COMPONENT (dvb_event_teletext_component_get_type ())
#define DVB_EVENT_TELETEXT_COMPONENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_EVENT_TYPE_TELETEXT_COMPONENT, DVBEventTeletextComponent))
#define DVB_EVENT_TELETEXT_COMPONENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DVB_EVENT_TYPE_TELETEXT_COMPONENT, DVBEventTeletextComponentClass))
#define DVB_EVENT_IS_TELETEXT_COMPONENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_EVENT_TYPE_TELETEXT_COMPONENT))
#define DVB_EVENT_IS_TELETEXT_COMPONENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DVB_EVENT_TYPE_TELETEXT_COMPONENT))
#define DVB_EVENT_TELETEXT_COMPONENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DVB_EVENT_TYPE_TELETEXT_COMPONENT, DVBEventTeletextComponentClass))

typedef struct _DVBEventTeletextComponent DVBEventTeletextComponent;
typedef struct _DVBEventTeletextComponentClass DVBEventTeletextComponentClass;
typedef struct _DVBEventTeletextComponentPrivate DVBEventTeletextComponentPrivate;
typedef struct _DVBEventParamSpecTeletextComponent DVBEventParamSpecTeletextComponent;
typedef struct _DVBParamSpecEvent DVBParamSpecEvent;

/**
     * Represents an EPG event (i.e. a show with all its information)
     */
struct _DVBEvent {
	GTypeInstance parent_instance;
	volatile int ref_count;
	DVBEventPrivate * priv;
	guint id;
	guint year;
	guint month;
	guint hour;
	guint day;
	guint minute;
	guint second;
	guint duration;
	guint running_status;
	gboolean free_ca_mode;
	char* name;
	char* description;
	char* extended_description;
	GSList* audio_components;
	GSList* video_components;
	GSList* teletext_components;
};

struct _DVBEventClass {
	GTypeClass parent_class;
	void (*finalize) (DVBEvent *self);
};

struct _DVBEventAudioComponent {
	GTypeInstance parent_instance;
	volatile int ref_count;
	DVBEventAudioComponentPrivate * priv;
	char* type;
};

struct _DVBEventAudioComponentClass {
	GTypeClass parent_class;
	void (*finalize) (DVBEventAudioComponent *self);
};

struct _DVBEventParamSpecAudioComponent {
	GParamSpec parent_instance;
};

struct _DVBEventVideoComponent {
	GTypeInstance parent_instance;
	volatile int ref_count;
	DVBEventVideoComponentPrivate * priv;
	gboolean high_definition;
	char* aspect_ratio;
	gint frequency;
};

struct _DVBEventVideoComponentClass {
	GTypeClass parent_class;
	void (*finalize) (DVBEventVideoComponent *self);
};

struct _DVBEventParamSpecVideoComponent {
	GParamSpec parent_instance;
};

struct _DVBEventTeletextComponent {
	GTypeInstance parent_instance;
	volatile int ref_count;
	DVBEventTeletextComponentPrivate * priv;
	char* type;
};

struct _DVBEventTeletextComponentClass {
	GTypeClass parent_class;
	void (*finalize) (DVBEventTeletextComponent *self);
};

struct _DVBEventParamSpecTeletextComponent {
	GParamSpec parent_instance;
};

struct _DVBParamSpecEvent {
	GParamSpec parent_instance;
};


#define DVB_EVENT_RUNNING_STATUS_UNDEFINED ((guint) (0))
#define DVB_EVENT_RUNNING_STATUS_NOT_RUNNING ((guint) (1))
#define DVB_EVENT_RUNNING_STATUS_STARTS_SOON ((guint) (2))
#define DVB_EVENT_RUNNING_STATUS_PAUSING ((guint) (3))
#define DVB_EVENT_RUNNING_STATUS_RUNNING ((guint) (4))
gboolean dvb_event_has_expired (DVBEvent* self);
gboolean dvb_event_is_running (DVBEvent* self);
char* dvb_event_to_string (DVBEvent* self);
struct tm dvb_event_get_local_start_time (DVBEvent* self);
struct tm dvb_event_get_utc_start_time (DVBEvent* self);
gint dvb_event_compare (DVBEvent* event1, DVBEvent* event2);
gboolean dvb_event_equal (DVBEvent* event1, DVBEvent* event2);
DVBEvent* dvb_event_construct (GType object_type);
DVBEvent* dvb_event_new (void);
DVBEventAudioComponent* dvb_event_audio_component_construct (GType object_type);
DVBEventAudioComponent* dvb_event_audio_component_new (void);
GParamSpec* dvb_event_param_spec_audio_component (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
gpointer dvb_event_value_get_audio_component (const GValue* value);
void dvb_event_value_set_audio_component (GValue* value, gpointer v_object);
GType dvb_event_audio_component_get_type (void);
gpointer dvb_event_audio_component_ref (gpointer instance);
void dvb_event_audio_component_unref (gpointer instance);
DVBEventVideoComponent* dvb_event_video_component_construct (GType object_type);
DVBEventVideoComponent* dvb_event_video_component_new (void);
GParamSpec* dvb_event_param_spec_video_component (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
gpointer dvb_event_value_get_video_component (const GValue* value);
void dvb_event_value_set_video_component (GValue* value, gpointer v_object);
GType dvb_event_video_component_get_type (void);
gpointer dvb_event_video_component_ref (gpointer instance);
void dvb_event_video_component_unref (gpointer instance);
DVBEventTeletextComponent* dvb_event_teletext_component_construct (GType object_type);
DVBEventTeletextComponent* dvb_event_teletext_component_new (void);
GParamSpec* dvb_event_param_spec_teletext_component (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
gpointer dvb_event_value_get_teletext_component (const GValue* value);
void dvb_event_value_set_teletext_component (GValue* value, gpointer v_object);
GType dvb_event_teletext_component_get_type (void);
gpointer dvb_event_teletext_component_ref (gpointer instance);
void dvb_event_teletext_component_unref (gpointer instance);
GParamSpec* dvb_param_spec_event (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
gpointer dvb_value_get_event (const GValue* value);
void dvb_value_set_event (GValue* value, gpointer v_object);
GType dvb_event_get_type (void);
gpointer dvb_event_ref (gpointer instance);
void dvb_event_unref (gpointer instance);


G_END_DECLS

#endif
