
#ifndef __SRC_MANAGER_H__
#define __SRC_MANAGER_H__

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include "src/DeviceGroup.h"
#include "src/Recorder.h"
#include "src/EPGScanner.h"

G_BEGIN_DECLS


#define DVB_TYPE_MANAGER (dvb_manager_get_type ())
#define DVB_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_TYPE_MANAGER, DVBManager))
#define DVB_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DVB_TYPE_MANAGER, DVBManagerClass))
#define DVB_IS_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_TYPE_MANAGER))
#define DVB_IS_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DVB_TYPE_MANAGER))
#define DVB_MANAGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DVB_TYPE_MANAGER, DVBManagerClass))

typedef struct _DVBManager DVBManager;
typedef struct _DVBManagerClass DVBManagerClass;
typedef struct _DVBManagerPrivate DVBManagerPrivate;

struct _DVBManager {
	GObject parent_instance;
	DVBManagerPrivate * priv;
};

struct _DVBManagerClass {
	GObjectClass parent_class;
};


DVBManager* dvb_manager_get_instance (void);
char** dvb_manager_GetScannerForDevice (DVBManager* self, guint adapter, guint frontend, int* result_length1);
guint* dvb_manager_GetRegisteredDeviceGroups (DVBManager* self, int* result_length1);
char* dvb_manager_GetTypeOfDeviceGroup (DVBManager* self, guint group_id);
char* dvb_manager_GetRecorder (DVBManager* self, guint group_id);
gboolean dvb_manager_AddDeviceToNewGroup (DVBManager* self, guint adapter, guint frontend, const char* channels_conf, const char* recordings_dir);
gboolean dvb_manager_AddDeviceToExistingGroup (DVBManager* self, guint adapter, guint frontend, guint group_id);
gboolean dvb_manager_RemoveDeviceFromGroup (DVBManager* self, guint adapter, guint frontend, guint group_id);
char* dvb_manager_GetChannelList (DVBManager* self, guint group_id);
char** dvb_manager_GetDeviceGroupMembers (DVBManager* self, guint group_id, int* result_length1);
char* dvb_manager_GetNameOfRegisteredDevice (DVBManager* self, guint adapter, guint frontend);
char* dvb_manager_GetSchedule (DVBManager* self, guint group_id, guint channel_sid);
gboolean dvb_manager_add_device_group (DVBManager* self, DVBDeviceGroup* device);
DVBRecorder* dvb_manager_get_recorder_for_device_group (DVBManager* self, DVBDeviceGroup* device);
DVBEPGScanner* dvb_manager_get_epg_scanner (DVBManager* self, DVBDeviceGroup* devgroup);
void dvb_manager_create_and_start_epg_scanner (DVBManager* self, DVBDeviceGroup* devgroup);
DVBManager* dvb_manager_construct (GType object_type);
DVBManager* dvb_manager_new (void);
GType dvb_manager_get_type (void);


G_END_DECLS

#endif
