
#include <src/Utils.h>




#define DVB_UTILS_BUFFER_SIZE 4096
static void _g_slist_free_g_object_unref (GSList* self);



const char* dvb_utils_get_nick_from_enum (GType enumtype, gint val) {
	GEnumClass* eclass;
	char* _tmp0;
	eclass = ((GEnumClass*) (g_type_class_ref (enumtype)));
	_tmp0 = NULL;
	return (_tmp0 = g_enum_get_value (eclass, val)->value_nick, (eclass == NULL ? NULL : (eclass = (g_type_class_unref (eclass), NULL))), _tmp0);
}


gint dvb_utils_get_value_by_name_from_enum (GType enumtype, const char* name) {
	GEnumClass* enumclass;
	gint _tmp0;
	g_return_val_if_fail (name != NULL, 0);
	enumclass = ((GEnumClass*) (g_type_class_ref (enumtype)));
	return (_tmp0 = g_enum_get_value_by_name (enumclass, name)->value, (enumclass == NULL ? NULL : (enumclass = (g_type_class_unref (enumclass), NULL))), _tmp0);
}


const char* dvb_utils_get_name_by_value_from_enum (GType enumtype, gint val) {
	GEnumClass* enumclass;
	char* _tmp0;
	enumclass = ((GEnumClass*) (g_type_class_ref (enumtype)));
	_tmp0 = NULL;
	return (_tmp0 = g_enum_get_value (enumclass, val)->value_name, (enumclass == NULL ? NULL : (enumclass = (g_type_class_unref (enumclass), NULL))), _tmp0);
}


static void _g_slist_free_g_object_unref (GSList* self) {
	g_slist_foreach (self, ((GFunc) (g_object_unref)), NULL);
	g_slist_free (self);
}


void dvb_utils_mkdirs (GFile* directory, GError** error) {
	GError * inner_error;
	GSList* create_dirs;
	GFile* _tmp0;
	GFile* current_dir;
	g_return_if_fail (G_IS_FILE (directory));
	inner_error = NULL;
	create_dirs = NULL;
	_tmp0 = NULL;
	current_dir = (_tmp0 = directory, (_tmp0 == NULL ? NULL : g_object_ref (_tmp0)));
	while (current_dir != NULL) {
		GFile* _tmp1;
		GFile* _tmp2;
		if (g_file_query_exists (current_dir, NULL)) {
			break;
		}
		_tmp1 = NULL;
		create_dirs = g_slist_prepend (create_dirs, (_tmp1 = current_dir, (_tmp1 == NULL ? NULL : g_object_ref (_tmp1))));
		_tmp2 = NULL;
		current_dir = (_tmp2 = g_file_get_parent (current_dir), (current_dir == NULL ? NULL : (current_dir = (g_object_unref (current_dir), NULL))), _tmp2);
	}
	{
		GSList* dir_collection;
		GSList* dir_it;
		dir_collection = create_dirs;
		for (dir_it = dir_collection; dir_it != NULL; dir_it = dir_it->next) {
			GFile* _tmp4;
			GFile* dir;
			_tmp4 = NULL;
			dir = (_tmp4 = ((GFile*) (dir_it->data)), (_tmp4 == NULL ? NULL : g_object_ref (_tmp4)));
			{
				char* _tmp3;
				_tmp3 = NULL;
				g_debug ("Utils.vala:33: Creating %s", (_tmp3 = g_file_get_path (dir)));
				_tmp3 = (g_free (_tmp3), NULL);
				g_file_make_directory (dir, NULL, &inner_error);
				if (inner_error != NULL) {
					g_propagate_error (error, inner_error);
					(dir == NULL ? NULL : (dir = (g_object_unref (dir), NULL)));
					(create_dirs == NULL ? NULL : (create_dirs = (_g_slist_free_g_object_unref (create_dirs), NULL)));
					(current_dir == NULL ? NULL : (current_dir = (g_object_unref (current_dir), NULL)));
					return;
				}
				(dir == NULL ? NULL : (dir = (g_object_unref (dir), NULL)));
			}
		}
	}
	(create_dirs == NULL ? NULL : (create_dirs = (_g_slist_free_g_object_unref (create_dirs), NULL)));
	(current_dir == NULL ? NULL : (current_dir = (g_object_unref (current_dir), NULL)));
}


char* dvb_utils_remove_nonalphanums (const char* text) {
	GError * inner_error;
	GRegex* regex;
	char* new_text;
	char* _tmp6;
	g_return_val_if_fail (text != NULL, NULL);
	inner_error = NULL;
	regex = NULL;
	{
		GRegex* _tmp0;
		_tmp0 = NULL;
		regex = (_tmp0 = g_regex_new ("\\W", 0, 0, &inner_error), (regex == NULL ? NULL : (regex = (g_regex_unref (regex), NULL))), _tmp0);
		if (inner_error != NULL) {
			if (inner_error->domain == G_REGEX_ERROR) {
				goto __catch35_g_regex_error;
			}
			g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, inner_error->message);
			g_clear_error (&inner_error);
		}
	}
	goto __finally35;
	__catch35_g_regex_error:
	{
		GError * e;
		e = inner_error;
		inner_error = NULL;
		{
			const char* _tmp1;
			char* _tmp2;
			g_error (e->message);
			_tmp1 = NULL;
			_tmp2 = NULL;
			return (_tmp2 = (_tmp1 = text, (_tmp1 == NULL ? NULL : g_strdup (_tmp1))), (e == NULL ? NULL : (e = (g_error_free (e), NULL))), (regex == NULL ? NULL : (regex = (g_regex_unref (regex), NULL))), _tmp2);
		}
	}
	__finally35:
	;
	new_text = NULL;
	{
		char* _tmp3;
		_tmp3 = NULL;
		new_text = (_tmp3 = g_regex_replace_literal (regex, text, strlen (text), 0, "_", 0, &inner_error), (new_text = (g_free (new_text), NULL)), _tmp3);
		if (inner_error != NULL) {
			if (inner_error->domain == G_REGEX_ERROR) {
				goto __catch36_g_regex_error;
			}
			g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, inner_error->message);
			g_clear_error (&inner_error);
		}
	}
	goto __finally36;
	__catch36_g_regex_error:
	{
		GError * e;
		e = inner_error;
		inner_error = NULL;
		{
			const char* _tmp4;
			char* _tmp5;
			g_error (e->message);
			_tmp4 = NULL;
			_tmp5 = NULL;
			return (_tmp5 = (_tmp4 = text, (_tmp4 == NULL ? NULL : g_strdup (_tmp4))), (e == NULL ? NULL : (e = (g_error_free (e), NULL))), (regex == NULL ? NULL : (regex = (g_regex_unref (regex), NULL))), (new_text = (g_free (new_text), NULL)), _tmp5);
		}
	}
	__finally36:
	;
	_tmp6 = NULL;
	return (_tmp6 = new_text, (regex == NULL ? NULL : (regex = (g_regex_unref (regex), NULL))), _tmp6);
}


/**
     * @returns: Difference in seconds
     */
gint64 dvb_utils_difftime (struct tm* t1, struct tm* t2) {
	gint64 ts1;
	gint64 ts2;
	gint64 diff;
	ts1 = ((gint64) (mktime (&(*t1))));
	ts2 = ((gint64) (mktime (&(*t2))));
	diff = ts1 - ts2;
	if (diff < 0) {
		return -1 * diff;
	} else {
		return diff;
	}
}


/**
     * Creates Time of local time
     */
struct tm dvb_utils_create_time (gint year, gint month, gint day, gint hour, gint minute, gint second) {
	time_t _tmp2 = {0};
	time_t _tmp0 = {0};
	struct tm _tmp1 = {0};
	struct tm t;
	g_assert (year >= 1900 && month >= 1 && day >= 1 && hour >= 0 && minute >= 0 && second >= 0);
	/* Create Time with some initial value, otherwise time is wrong*/
	t = (localtime_r ((_tmp2 = (time (&_tmp0), _tmp0), &_tmp2), &_tmp1), _tmp1);
	t.tm_year = year - 1900;
	t.tm_mon = month - 1;
	t.tm_mday = day;
	t.tm_hour = hour;
	t.tm_min = minute;
	t.tm_sec = second;
	return t;
}


/**
     * Creates Time of UTC time
     */
struct tm dvb_utils_create_utc_time (gint year, gint month, gint day, gint hour, gint minute, gint second) {
	time_t _tmp2 = {0};
	time_t _tmp0 = {0};
	struct tm _tmp1 = {0};
	struct tm t;
	g_assert (year >= 1900 && month >= 1 && day >= 1 && hour >= 0 && minute >= 0 && second >= 0);
	/* Create Time with some initial value, otherwise time is wrong*/
	t = (gmtime_r ((_tmp2 = (time (&_tmp0), _tmp0), &_tmp2), &_tmp1), _tmp1);
	t.tm_year = year - 1900;
	t.tm_mon = month - 1;
	t.tm_mday = day;
	t.tm_hour = hour;
	t.tm_min = minute;
	t.tm_sec = second;
	t.tm_isdst = -1;
	/* undefined*/
	return t;
}


/* TODO throw error*/
char* dvb_utils_read_file_contents (GFile* file, GError** error) {
	GError * inner_error;
	char* attrs;
	GFileInfo* info;
	GFileInputStream* stream;
	GString* sb;
	gchar* _tmp8;
	gint buffer_length1;
	gchar* buffer;
	glong bytes_read;
	const char* _tmp9;
	char* _tmp10;
	g_return_val_if_fail (G_IS_FILE (file), NULL);
	inner_error = NULL;
	attrs = g_strdup_printf ("%s,%s", G_FILE_ATTRIBUTE_STANDARD_TYPE, G_FILE_ATTRIBUTE_ACCESS_CAN_READ);
	info = NULL;
	{
		GFileInfo* _tmp0;
		_tmp0 = NULL;
		info = (_tmp0 = g_file_query_info (file, attrs, 0, NULL, &inner_error), (info == NULL ? NULL : (info = (g_object_unref (info), NULL))), _tmp0);
		if (inner_error != NULL) {
			goto __catch37_g_error;
		}
	}
	goto __finally37;
	__catch37_g_error:
	{
		GError * e;
		e = inner_error;
		inner_error = NULL;
		{
			char* _tmp1;
			g_critical (e->message);
			_tmp1 = NULL;
			return (_tmp1 = NULL, (e == NULL ? NULL : (e = (g_error_free (e), NULL))), (attrs = (g_free (attrs), NULL)), (info == NULL ? NULL : (info = (g_object_unref (info), NULL))), _tmp1);
		}
	}
	__finally37:
	;
	if (g_file_info_get_file_type (info) != G_FILE_TYPE_REGULAR) {
		char* _tmp2;
		char* _tmp3;
		_tmp2 = NULL;
		g_critical ("Utils.vala:130: %s is not a regular file", (_tmp2 = g_file_get_path (file)));
		_tmp2 = (g_free (_tmp2), NULL);
		_tmp3 = NULL;
		return (_tmp3 = NULL, (attrs = (g_free (attrs), NULL)), (info == NULL ? NULL : (info = (g_object_unref (info), NULL))), _tmp3);
	}
	if (!g_file_info_get_attribute_boolean (info, G_FILE_ATTRIBUTE_ACCESS_CAN_READ)) {
		char* _tmp4;
		char* _tmp5;
		_tmp4 = NULL;
		g_critical ("Utils.vala:135: Cannot read %s", (_tmp4 = g_file_get_path (file)));
		_tmp4 = (g_free (_tmp4), NULL);
		_tmp5 = NULL;
		return (_tmp5 = NULL, (attrs = (g_free (attrs), NULL)), (info == NULL ? NULL : (info = (g_object_unref (info), NULL))), _tmp5);
	}
	stream = NULL;
	{
		GFileInputStream* _tmp6;
		_tmp6 = NULL;
		stream = (_tmp6 = g_file_read (file, NULL, &inner_error), (stream == NULL ? NULL : (stream = (g_object_unref (stream), NULL))), _tmp6);
		if (inner_error != NULL) {
			if (inner_error->domain == G_IO_ERROR) {
				goto __catch38_g_io_error;
			}
			g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, inner_error->message);
			g_clear_error (&inner_error);
		}
	}
	goto __finally38;
	__catch38_g_io_error:
	{
		GError * e;
		e = inner_error;
		inner_error = NULL;
		{
			char* _tmp7;
			g_critical (e->message);
			_tmp7 = NULL;
			return (_tmp7 = NULL, (e == NULL ? NULL : (e = (g_error_free (e), NULL))), (attrs = (g_free (attrs), NULL)), (info == NULL ? NULL : (info = (g_object_unref (info), NULL))), (stream == NULL ? NULL : (stream = (g_object_unref (stream), NULL))), _tmp7);
		}
	}
	__finally38:
	;
	sb = g_string_new ("");
	_tmp8 = NULL;
	buffer = (_tmp8 = g_new0 (gchar, DVB_UTILS_BUFFER_SIZE), buffer_length1 = DVB_UTILS_BUFFER_SIZE, _tmp8);
	bytes_read = 0L;
	while ((bytes_read = g_input_stream_read (G_INPUT_STREAM (stream), buffer, ((gulong) (DVB_UTILS_BUFFER_SIZE)), NULL, &inner_error)) > 0) {
		{
			gint i;
			i = 0;
			for (; i < bytes_read; i++) {
				g_string_append_c (sb, buffer[i]);
			}
		}
	}
	g_input_stream_close (G_INPUT_STREAM (stream), NULL, &inner_error);
	if (inner_error != NULL) {
		g_propagate_error (error, inner_error);
		attrs = (g_free (attrs), NULL);
		(info == NULL ? NULL : (info = (g_object_unref (info), NULL)));
		(stream == NULL ? NULL : (stream = (g_object_unref (stream), NULL)));
		(sb == NULL ? NULL : (sb = (g_string_free (sb, TRUE), NULL)));
		buffer = (g_free (buffer), NULL);
		return NULL;
	}
	_tmp9 = NULL;
	_tmp10 = NULL;
	return (_tmp10 = (_tmp9 = sb->str, (_tmp9 == NULL ? NULL : g_strdup (_tmp9))), (attrs = (g_free (attrs), NULL)), (info == NULL ? NULL : (info = (g_object_unref (info), NULL))), (stream == NULL ? NULL : (stream = (g_object_unref (stream), NULL))), (sb == NULL ? NULL : (sb = (g_string_free (sb, TRUE), NULL))), (buffer = (g_free (buffer), NULL)), _tmp10);
}


void dvb_utils_delete_dir_recursively (GFile* dir, GError** error) {
	GError * inner_error;
	char* attrs;
	GFileEnumerator* files;
	GFileEnumerator* _tmp0;
	GFileInfo* childinfo;
	GFileInfo* _tmp1;
	char* _tmp4;
	g_return_if_fail (G_IS_FILE (dir));
	inner_error = NULL;
	attrs = g_strdup_printf ("%s,%s", G_FILE_ATTRIBUTE_STANDARD_TYPE, G_FILE_ATTRIBUTE_STANDARD_NAME);
	files = NULL;
	_tmp0 = NULL;
	files = (_tmp0 = g_file_enumerate_children (dir, attrs, 0, NULL, &inner_error), (files == NULL ? NULL : (files = (g_object_unref (files), NULL))), _tmp0);
	if (inner_error != NULL) {
		g_propagate_error (error, inner_error);
		attrs = (g_free (attrs), NULL);
		(files == NULL ? NULL : (files = (g_object_unref (files), NULL)));
		return;
	}
	if (files == NULL) {
		attrs = (g_free (attrs), NULL);
		(files == NULL ? NULL : (files = (g_object_unref (files), NULL)));
		return;
	}
	childinfo = NULL;
	_tmp1 = NULL;
	while ((childinfo = (_tmp1 = g_file_enumerator_next_file (files, NULL, &inner_error), (childinfo == NULL ? NULL : (childinfo = (g_object_unref (childinfo), NULL))), _tmp1)) != NULL) {
		guint32 type;
		GFile* child;
		guint32 _tmp3;
		type = ((guint32) (g_file_info_get_attribute_uint32 (childinfo, G_FILE_ATTRIBUTE_STANDARD_TYPE)));
		child = g_file_get_child (dir, g_file_info_get_name (childinfo));
		_tmp3 = type;
		if (_tmp3 == G_FILE_TYPE_DIRECTORY)
		do {
			dvb_utils_delete_dir_recursively (child, &inner_error);
			if (inner_error != NULL) {
				g_propagate_error (error, inner_error);
				(child == NULL ? NULL : (child = (g_object_unref (child), NULL)));
				attrs = (g_free (attrs), NULL);
				(files == NULL ? NULL : (files = (g_object_unref (files), NULL)));
				(childinfo == NULL ? NULL : (childinfo = (g_object_unref (childinfo), NULL)));
				return;
			}
			break;
		} while (0); else if (_tmp3 == G_FILE_TYPE_REGULAR)
		do {
			char* _tmp2;
			_tmp2 = NULL;
			g_debug ("Utils.vala:182: Deleting file %s", (_tmp2 = g_file_get_path (child)));
			_tmp2 = (g_free (_tmp2), NULL);
			g_file_delete (child, NULL, &inner_error);
			if (inner_error != NULL) {
				g_propagate_error (error, inner_error);
				(child == NULL ? NULL : (child = (g_object_unref (child), NULL)));
				attrs = (g_free (attrs), NULL);
				(files == NULL ? NULL : (files = (g_object_unref (files), NULL)));
				(childinfo == NULL ? NULL : (childinfo = (g_object_unref (childinfo), NULL)));
				return;
			}
			break;
		} while (0);
		(child == NULL ? NULL : (child = (g_object_unref (child), NULL)));
	}
	_tmp4 = NULL;
	g_debug ("Utils.vala:188: Deleting directory %s", (_tmp4 = g_file_get_path (dir)));
	_tmp4 = (g_free (_tmp4), NULL);
	g_file_delete (dir, NULL, &inner_error);
	if (inner_error != NULL) {
		g_propagate_error (error, inner_error);
		attrs = (g_free (attrs), NULL);
		(files == NULL ? NULL : (files = (g_object_unref (files), NULL)));
		(childinfo == NULL ? NULL : (childinfo = (g_object_unref (childinfo), NULL)));
		return;
	}
	attrs = (g_free (attrs), NULL);
	(files == NULL ? NULL : (files = (g_object_unref (files), NULL)));
	(childinfo == NULL ? NULL : (childinfo = (g_object_unref (childinfo), NULL)));
}




