
#ifndef __SRC_SATELLITE_SATELLITESCANNER_H__
#define __SRC_SATELLITE_SATELLITESCANNER_H__

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <gst/gst.h>
#include "src/Scanner.h"
#include "src/Device.h"
#include "src/ScannedItem.h"
#include "src/Channel.h"
#include <dbus/dbus.h>
#include <dbus/dbus-glib.h>

G_BEGIN_DECLS


#define DVB_TYPE_ID_BUS_SATELLITE_SCANNER (dvb_id_bus_satellite_scanner_get_type ())
#define DVB_ID_BUS_SATELLITE_SCANNER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_TYPE_ID_BUS_SATELLITE_SCANNER, DVBIDBusSatelliteScanner))
#define DVB_IS_ID_BUS_SATELLITE_SCANNER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_TYPE_ID_BUS_SATELLITE_SCANNER))
#define DVB_ID_BUS_SATELLITE_SCANNER_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), DVB_TYPE_ID_BUS_SATELLITE_SCANNER, DVBIDBusSatelliteScannerIface))

typedef struct _DVBIDBusSatelliteScanner DVBIDBusSatelliteScanner;
typedef struct _DVBIDBusSatelliteScannerIface DVBIDBusSatelliteScannerIface;

#define DVB_TYPE_SATELLITE_SCANNER (dvb_satellite_scanner_get_type ())
#define DVB_SATELLITE_SCANNER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_TYPE_SATELLITE_SCANNER, DVBSatelliteScanner))
#define DVB_SATELLITE_SCANNER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DVB_TYPE_SATELLITE_SCANNER, DVBSatelliteScannerClass))
#define DVB_IS_SATELLITE_SCANNER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_TYPE_SATELLITE_SCANNER))
#define DVB_IS_SATELLITE_SCANNER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DVB_TYPE_SATELLITE_SCANNER))
#define DVB_SATELLITE_SCANNER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DVB_TYPE_SATELLITE_SCANNER, DVBSatelliteScannerClass))

typedef struct _DVBSatelliteScanner DVBSatelliteScanner;
typedef struct _DVBSatelliteScannerClass DVBSatelliteScannerClass;
typedef struct _DVBSatelliteScannerPrivate DVBSatelliteScannerPrivate;

struct _DVBIDBusSatelliteScannerIface {
	GTypeInterface parent_iface;
	void (*Run) (DVBIDBusSatelliteScanner* self);
	void (*Destroy) (DVBIDBusSatelliteScanner* self);
	gboolean (*WriteChannelsToFile) (DVBIDBusSatelliteScanner* self, const char* path);
	guint (*GetQueueSize) (DVBIDBusSatelliteScanner* self);
	void (*AddScanningData) (DVBIDBusSatelliteScanner* self, guint frequency, const char* polarization, guint symbol_rate);
	gboolean (*AddScanningDataFromFile) (DVBIDBusSatelliteScanner* self, const char* path);
};

struct _DVBSatelliteScanner {
	DVBScanner parent_instance;
	DVBSatelliteScannerPrivate * priv;
};

struct _DVBSatelliteScannerClass {
	DVBScannerClass parent_class;
};


void dvb_id_bus_satellite_scanner_Run (DVBIDBusSatelliteScanner* self);
void dvb_id_bus_satellite_scanner_Destroy (DVBIDBusSatelliteScanner* self);
gboolean dvb_id_bus_satellite_scanner_WriteChannelsToFile (DVBIDBusSatelliteScanner* self, const char* path);
guint dvb_id_bus_satellite_scanner_GetQueueSize (DVBIDBusSatelliteScanner* self);
void dvb_id_bus_satellite_scanner_AddScanningData (DVBIDBusSatelliteScanner* self, guint frequency, const char* polarization, guint symbol_rate);
gboolean dvb_id_bus_satellite_scanner_AddScanningDataFromFile (DVBIDBusSatelliteScanner* self, const char* path);
void dvb_id_bus_satellite_scanner_dbus_register_object (DBusConnection* connection, const char* path, void* object);
DBusHandlerResult dvb_id_bus_satellite_scanner_dbus_message (DBusConnection* connection, DBusMessage* message, void* object);
GType dvb_id_bus_satellite_scanner_get_type (void);
DVBIDBusSatelliteScanner* dvb_id_bus_satellite_scanner_dbus_proxy_new (DBusGConnection* connection, const char* name, const char* path);
DVBSatelliteScanner* dvb_satellite_scanner_construct (GType object_type, DVBDevice* device);
DVBSatelliteScanner* dvb_satellite_scanner_new (DVBDevice* device);
void dvb_satellite_scanner_dbus_register_object (DBusConnection* connection, const char* path, void* object);
DBusHandlerResult dvb_satellite_scanner_dbus_message (DBusConnection* connection, DBusMessage* message, void* object);
GType dvb_satellite_scanner_get_type (void);


G_END_DECLS

#endif
