
#ifndef __SRC_DEVICEGROUP_H__
#define __SRC_DEVICEGROUP_H__

#include <glib.h>
#include <glib-object.h>
#include <gee/iterable.h>
#include <gee/iterator.h>
#include <gio/gio.h>
#include "src/Device.h"
#include "src/ChannelList.h"

G_BEGIN_DECLS


#define DVB_TYPE_DEVICE_GROUP (dvb_device_group_get_type ())
#define DVB_DEVICE_GROUP(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_TYPE_DEVICE_GROUP, DVBDeviceGroup))
#define DVB_DEVICE_GROUP_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DVB_TYPE_DEVICE_GROUP, DVBDeviceGroupClass))
#define DVB_IS_DEVICE_GROUP(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_TYPE_DEVICE_GROUP))
#define DVB_IS_DEVICE_GROUP_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DVB_TYPE_DEVICE_GROUP))
#define DVB_DEVICE_GROUP_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DVB_TYPE_DEVICE_GROUP, DVBDeviceGroupClass))

typedef struct _DVBDeviceGroup DVBDeviceGroup;
typedef struct _DVBDeviceGroupClass DVBDeviceGroupClass;
typedef struct _DVBDeviceGroupPrivate DVBDeviceGroupPrivate;

/**
     * A group of devices that share the same settings
     * (list of channels, recordings dir)
     */
struct _DVBDeviceGroup {
	GObject parent_instance;
	DVBDeviceGroupPrivate * priv;
};

struct _DVBDeviceGroupClass {
	GObjectClass parent_class;
};


DVBDeviceGroup* dvb_device_group_construct (GType object_type, guint id, DVBDevice* reference_device);
DVBDeviceGroup* dvb_device_group_new (guint id, DVBDevice* reference_device);
void dvb_device_group_create_and_add_device (DVBDeviceGroup* self, guint adapter, guint frontend);
gboolean dvb_device_group_add (DVBDeviceGroup* self, DVBDevice* device);
gboolean dvb_device_group_contains (DVBDeviceGroup* self, DVBDevice* device);
gboolean dvb_device_group_remove (DVBDeviceGroup* self, DVBDevice* device);
DVBDevice* dvb_device_group_get_next_free_device (DVBDeviceGroup* self);
gint dvb_device_group_get_size (DVBDeviceGroup* self);
guint dvb_device_group_get_Id (DVBDeviceGroup* self);
DVBChannelList* dvb_device_group_get_Channels (DVBDeviceGroup* self);
GFile* dvb_device_group_get_RecordingsDirectory (DVBDeviceGroup* self);
DVBAdapterType dvb_device_group_get_Type (DVBDeviceGroup* self);
DVBDevice* dvb_device_group_get_reference_device (DVBDeviceGroup* self);
GType dvb_device_group_get_type (void);


G_END_DECLS

#endif
