
#ifndef __SRC_EPGSTORE_H__
#define __SRC_EPGSTORE_H__

#include <glib.h>
#include <glib-object.h>
#include <gee/list.h>
#include "src/Event.h"
#include "src/Channel.h"

G_BEGIN_DECLS


#define DVB_TYPE_EPG_STORE (dvb_epg_store_get_type ())
#define DVB_EPG_STORE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_TYPE_EPG_STORE, DVBEPGStore))
#define DVB_EPG_STORE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DVB_TYPE_EPG_STORE, DVBEPGStoreClass))
#define DVB_IS_EPG_STORE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_TYPE_EPG_STORE))
#define DVB_IS_EPG_STORE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DVB_TYPE_EPG_STORE))
#define DVB_EPG_STORE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DVB_TYPE_EPG_STORE, DVBEPGStoreClass))

typedef struct _DVBEPGStore DVBEPGStore;
typedef struct _DVBEPGStoreClass DVBEPGStoreClass;
typedef struct _DVBEPGStorePrivate DVBEPGStorePrivate;

struct _DVBEPGStore {
	GObject parent_instance;
	DVBEPGStorePrivate * priv;
};

struct _DVBEPGStoreClass {
	GObjectClass parent_class;
};


DVBEPGStore* dvb_epg_store_get_instance (void);
gboolean dvb_epg_store_add_or_update_event (DVBEPGStore* self, DVBEvent* event, DVBChannel* channel);
DVBEvent* dvb_epg_store_get_event (DVBEPGStore* self, guint event_id, guint channel_sid);
gboolean dvb_epg_store_remove_event (DVBEPGStore* self, guint event_id, DVBChannel* channel);
gboolean dvb_epg_store_contains_event (DVBEPGStore* self, DVBEvent* event, DVBChannel* channel);
GeeList* dvb_epg_store_get_events (DVBEPGStore* self, DVBChannel* channel);
DVBEPGStore* dvb_epg_store_construct (GType object_type);
DVBEPGStore* dvb_epg_store_new (void);
GType dvb_epg_store_get_type (void);


G_END_DECLS

#endif
