
#include <src/IDBusSchedule.h>

typedef DBusGProxy DVBIDBusScheduleDBusProxy;
typedef DBusGProxyClass DVBIDBusScheduleDBusProxyClass;
typedef struct _DBusObjectVTable _DBusObjectVTable;

struct _DBusObjectVTable {
	void (*register_object) (DBusConnection*, const char*, void*);
};



void _dvb_id_bus_schedule_dbus_unregister (DBusConnection* connection, void* user_data);
static DBusMessage* _dbus_dvb_id_bus_schedule_introspect (DVBIDBusSchedule* self, DBusConnection* connection, DBusMessage* message);
static DBusMessage* _dbus_dvb_id_bus_schedule_property_get (DVBIDBusSchedule* self, DBusConnection* connection, DBusMessage* message);
static DBusMessage* _dbus_dvb_id_bus_schedule_property_set (DVBIDBusSchedule* self, DBusConnection* connection, DBusMessage* message);
static DBusMessage* _dbus_dvb_id_bus_schedule_property_get_all (DVBIDBusSchedule* self, DBusConnection* connection, DBusMessage* message);
static DBusMessage* _dbus_dvb_id_bus_schedule_GetAllEvents (DVBIDBusSchedule* self, DBusConnection* connection, DBusMessage* message);
static DBusMessage* _dbus_dvb_id_bus_schedule_NowPlaying (DVBIDBusSchedule* self, DBusConnection* connection, DBusMessage* message);
static DBusMessage* _dbus_dvb_id_bus_schedule_Next (DVBIDBusSchedule* self, DBusConnection* connection, DBusMessage* message);
static DBusMessage* _dbus_dvb_id_bus_schedule_GetName (DVBIDBusSchedule* self, DBusConnection* connection, DBusMessage* message);
static DBusMessage* _dbus_dvb_id_bus_schedule_GetShortDescription (DVBIDBusSchedule* self, DBusConnection* connection, DBusMessage* message);
static DBusMessage* _dbus_dvb_id_bus_schedule_GetExtendedDescription (DVBIDBusSchedule* self, DBusConnection* connection, DBusMessage* message);
static DBusMessage* _dbus_dvb_id_bus_schedule_GetDuration (DVBIDBusSchedule* self, DBusConnection* connection, DBusMessage* message);
static DBusMessage* _dbus_dvb_id_bus_schedule_GetLocalStartTime (DVBIDBusSchedule* self, DBusConnection* connection, DBusMessage* message);
static DBusMessage* _dbus_dvb_id_bus_schedule_IsRunning (DVBIDBusSchedule* self, DBusConnection* connection, DBusMessage* message);
static DBusMessage* _dbus_dvb_id_bus_schedule_IsScrambled (DVBIDBusSchedule* self, DBusConnection* connection, DBusMessage* message);
static guint32* dvb_id_bus_schedule_dbus_proxy_GetAllEvents (DVBIDBusSchedule* self, int* result_length1);
static guint32 dvb_id_bus_schedule_dbus_proxy_NowPlaying (DVBIDBusSchedule* self);
static guint32 dvb_id_bus_schedule_dbus_proxy_Next (DVBIDBusSchedule* self, guint32 event_id);
static char* dvb_id_bus_schedule_dbus_proxy_GetName (DVBIDBusSchedule* self, guint32 event_id);
static char* dvb_id_bus_schedule_dbus_proxy_GetShortDescription (DVBIDBusSchedule* self, guint32 event_id);
static char* dvb_id_bus_schedule_dbus_proxy_GetExtendedDescription (DVBIDBusSchedule* self, guint32 event_id);
static guint dvb_id_bus_schedule_dbus_proxy_GetDuration (DVBIDBusSchedule* self, guint32 event_id);
static guint* dvb_id_bus_schedule_dbus_proxy_GetLocalStartTime (DVBIDBusSchedule* self, guint32 event_id, int* result_length1);
static gboolean dvb_id_bus_schedule_dbus_proxy_IsRunning (DVBIDBusSchedule* self, guint32 event_id);
static gboolean dvb_id_bus_schedule_dbus_proxy_IsScrambled (DVBIDBusSchedule* self, guint32 event_id);
static void dvb_id_bus_schedule_dbus_proxy_interface_init (DVBIDBusScheduleIface* iface);
static void _vala_dbus_register_object (DBusConnection* connection, const char* path, void* object);

static const DBusObjectPathVTable _dvb_id_bus_schedule_dbus_path_vtable = {_dvb_id_bus_schedule_dbus_unregister, dvb_id_bus_schedule_dbus_message};
static const _DBusObjectVTable _dvb_id_bus_schedule_dbus_vtable = {dvb_id_bus_schedule_dbus_register_object};


guint32* dvb_id_bus_schedule_GetAllEvents (DVBIDBusSchedule* self, int* result_length1) {
	return DVB_ID_BUS_SCHEDULE_GET_INTERFACE (self)->GetAllEvents (self, result_length1);
}


/**
         * @returns: ID of currently running event
         */
guint32 dvb_id_bus_schedule_NowPlaying (DVBIDBusSchedule* self) {
	return DVB_ID_BUS_SCHEDULE_GET_INTERFACE (self)->NowPlaying (self);
}


/**
         * @returnns: ID of event that follows the given event
         */
guint32 dvb_id_bus_schedule_Next (DVBIDBusSchedule* self, guint32 event_id) {
	return DVB_ID_BUS_SCHEDULE_GET_INTERFACE (self)->Next (self, event_id);
}


char* dvb_id_bus_schedule_GetName (DVBIDBusSchedule* self, guint32 event_id) {
	return DVB_ID_BUS_SCHEDULE_GET_INTERFACE (self)->GetName (self, event_id);
}


char* dvb_id_bus_schedule_GetShortDescription (DVBIDBusSchedule* self, guint32 event_id) {
	return DVB_ID_BUS_SCHEDULE_GET_INTERFACE (self)->GetShortDescription (self, event_id);
}


char* dvb_id_bus_schedule_GetExtendedDescription (DVBIDBusSchedule* self, guint32 event_id) {
	return DVB_ID_BUS_SCHEDULE_GET_INTERFACE (self)->GetExtendedDescription (self, event_id);
}


guint dvb_id_bus_schedule_GetDuration (DVBIDBusSchedule* self, guint32 event_id) {
	return DVB_ID_BUS_SCHEDULE_GET_INTERFACE (self)->GetDuration (self, event_id);
}


guint* dvb_id_bus_schedule_GetLocalStartTime (DVBIDBusSchedule* self, guint32 event_id, int* result_length1) {
	return DVB_ID_BUS_SCHEDULE_GET_INTERFACE (self)->GetLocalStartTime (self, event_id, result_length1);
}


gboolean dvb_id_bus_schedule_IsRunning (DVBIDBusSchedule* self, guint32 event_id) {
	return DVB_ID_BUS_SCHEDULE_GET_INTERFACE (self)->IsRunning (self, event_id);
}


gboolean dvb_id_bus_schedule_IsScrambled (DVBIDBusSchedule* self, guint32 event_id) {
	return DVB_ID_BUS_SCHEDULE_GET_INTERFACE (self)->IsScrambled (self, event_id);
}


void _dvb_id_bus_schedule_dbus_unregister (DBusConnection* connection, void* user_data) {
}


static DBusMessage* _dbus_dvb_id_bus_schedule_introspect (DVBIDBusSchedule* self, DBusConnection* connection, DBusMessage* message) {
	DBusMessage* reply;
	DBusMessageIter iter;
	GString* xml_data;
	char** children;
	int i;
	reply = dbus_message_new_method_return (message);
	dbus_message_iter_init_append (reply, &iter);
	xml_data = g_string_new ("<!DOCTYPE node PUBLIC \"-//freedesktop//DTD D-BUS Object Introspection 1.0//EN\" \"http://www.freedesktop.org/standards/dbus/1.0/introspect.dtd\">\n");
	g_string_append (xml_data, "<node>\n<interface name=\"org.freedesktop.DBus.Introspectable\">\n  <method name=\"Introspect\">\n    <arg name=\"data\" direction=\"out\" type=\"s\"/>\n  </method>\n</interface>\n<interface name=\"org.freedesktop.DBus.Properties\">\n  <method name=\"Get\">\n    <arg name=\"interface\" direction=\"in\" type=\"s\"/>\n    <arg name=\"propname\" direction=\"in\" type=\"s\"/>\n    <arg name=\"value\" direction=\"out\" type=\"v\"/>\n  </method>\n  <method name=\"Set\">\n    <arg name=\"interface\" direction=\"in\" type=\"s\"/>\n    <arg name=\"propname\" direction=\"in\" type=\"s\"/>\n    <arg name=\"value\" direction=\"in\" type=\"v\"/>\n  </method>\n  <method name=\"GetAll\">\n    <arg name=\"interface\" direction=\"in\" type=\"s\"/>\n    <arg name=\"props\" direction=\"out\" type=\"a{sv}\"/>\n  </method>\n</interface>\n<interface name=\"org.gnome.DVB.Schedule\">\n  <method name=\"GetAllEvents\">\n    <arg name=\"result\" type=\"au\" direction=\"out\"/>\n  </method>\n  <method name=\"NowPlaying\">\n    <arg name=\"result\" type=\"u\" direction=\"out\"/>\n  </method>\n  <method name=\"Next\">\n    <arg name=\"event_id\" type=\"u\" direction=\"in\"/>\n    <arg name=\"result\" type=\"u\" direction=\"out\"/>\n  </method>\n  <method name=\"GetName\">\n    <arg name=\"event_id\" type=\"u\" direction=\"in\"/>\n    <arg name=\"result\" type=\"s\" direction=\"out\"/>\n  </method>\n  <method name=\"GetShortDescription\">\n    <arg name=\"event_id\" type=\"u\" direction=\"in\"/>\n    <arg name=\"result\" type=\"s\" direction=\"out\"/>\n  </method>\n  <method name=\"GetExtendedDescription\">\n    <arg name=\"event_id\" type=\"u\" direction=\"in\"/>\n    <arg name=\"result\" type=\"s\" direction=\"out\"/>\n  </method>\n  <method name=\"GetDuration\">\n    <arg name=\"event_id\" type=\"u\" direction=\"in\"/>\n    <arg name=\"result\" type=\"u\" direction=\"out\"/>\n  </method>\n  <method name=\"GetLocalStartTime\">\n    <arg name=\"event_id\" type=\"u\" direction=\"in\"/>\n    <arg name=\"result\" type=\"au\" direction=\"out\"/>\n  </method>\n  <method name=\"IsRunning\">\n    <arg name=\"event_id\" type=\"u\" direction=\"in\"/>\n    <arg name=\"result\" type=\"b\" direction=\"out\"/>\n  </method>\n  <method name=\"IsScrambled\">\n    <arg name=\"event_id\" type=\"u\" direction=\"in\"/>\n    <arg name=\"result\" type=\"b\" direction=\"out\"/>\n  </method>\n</interface>\n");
	dbus_connection_list_registered (connection, g_object_get_data ((GObject *) self, "dbus_object_path"), &children);
	for (i = 0; children[i]; i++) {
		g_string_append_printf (xml_data, "<node name=\"%s\"/>\n", children[i]);
	}
	g_string_append (xml_data, "</node>\n");
	dbus_message_iter_append_basic (&iter, DBUS_TYPE_STRING, &xml_data->str);
	g_string_free (xml_data, TRUE);
	return reply;
}


static DBusMessage* _dbus_dvb_id_bus_schedule_property_get (DVBIDBusSchedule* self, DBusConnection* connection, DBusMessage* message) {
	return NULL;
}


static DBusMessage* _dbus_dvb_id_bus_schedule_property_set (DVBIDBusSchedule* self, DBusConnection* connection, DBusMessage* message) {
	return NULL;
}


static DBusMessage* _dbus_dvb_id_bus_schedule_property_get_all (DVBIDBusSchedule* self, DBusConnection* connection, DBusMessage* message) {
	DBusMessage* reply;
	DBusMessageIter iter, reply_iter, subiter, entry_iter, value_iter;
	char* interface_name;
	const char* _tmp4;
	const char* property_name;
	if (strcmp (dbus_message_get_signature (message), "s")) {
		return NULL;
	}
	dbus_message_iter_init (message, &iter);
	reply = dbus_message_new_method_return (message);
	dbus_message_iter_init_append (reply, &reply_iter);
	dbus_message_iter_get_basic (&iter, &_tmp4);
	dbus_message_iter_next (&iter);
	interface_name = g_strdup (_tmp4);
	if (strcmp (interface_name, "org.gnome.DVB.Schedule") == 0) {
		dbus_message_iter_open_container (&reply_iter, DBUS_TYPE_ARRAY, "{sv}", &subiter);
		dbus_message_iter_close_container (&reply_iter, &subiter);
	} else {
		return NULL;
	}
	return reply;
}


static DBusMessage* _dbus_dvb_id_bus_schedule_GetAllEvents (DVBIDBusSchedule* self, DBusConnection* connection, DBusMessage* message) {
	DBusMessageIter iter;
	GError* error;
	int result_length1;
	guint32* result;
	DBusMessage* reply;
	DBusMessageIter _tmp5;
	int _tmp6;
	error = NULL;
	if (strcmp (dbus_message_get_signature (message), "")) {
		return NULL;
	}
	dbus_message_iter_init (message, &iter);
	result_length1 = 0;
	result = dvb_id_bus_schedule_GetAllEvents (self, &result_length1);
	reply = dbus_message_new_method_return (message);
	dbus_message_iter_init_append (reply, &iter);
	dbus_message_iter_open_container (&iter, DBUS_TYPE_ARRAY, "u", &_tmp5);
	for (_tmp6 = 0; _tmp6 < result_length1; _tmp6++) {
		dbus_uint32_t _tmp7;
		_tmp7 = result[_tmp6];
		dbus_message_iter_append_basic (&_tmp5, DBUS_TYPE_UINT32, &_tmp7);
	}
	dbus_message_iter_close_container (&iter, &_tmp5);
	return reply;
}


static DBusMessage* _dbus_dvb_id_bus_schedule_NowPlaying (DVBIDBusSchedule* self, DBusConnection* connection, DBusMessage* message) {
	DBusMessageIter iter;
	GError* error;
	guint32 result;
	DBusMessage* reply;
	dbus_uint32_t _tmp8;
	error = NULL;
	if (strcmp (dbus_message_get_signature (message), "")) {
		return NULL;
	}
	dbus_message_iter_init (message, &iter);
	result = dvb_id_bus_schedule_NowPlaying (self);
	reply = dbus_message_new_method_return (message);
	dbus_message_iter_init_append (reply, &iter);
	_tmp8 = result;
	dbus_message_iter_append_basic (&iter, DBUS_TYPE_UINT32, &_tmp8);
	return reply;
}


static DBusMessage* _dbus_dvb_id_bus_schedule_Next (DVBIDBusSchedule* self, DBusConnection* connection, DBusMessage* message) {
	DBusMessageIter iter;
	GError* error;
	guint32 event_id;
	dbus_uint32_t _tmp9;
	guint32 result;
	DBusMessage* reply;
	dbus_uint32_t _tmp10;
	error = NULL;
	if (strcmp (dbus_message_get_signature (message), "u")) {
		return NULL;
	}
	dbus_message_iter_init (message, &iter);
	event_id = 0U;
	dbus_message_iter_get_basic (&iter, &_tmp9);
	dbus_message_iter_next (&iter);
	event_id = _tmp9;
	result = dvb_id_bus_schedule_Next (self, event_id);
	reply = dbus_message_new_method_return (message);
	dbus_message_iter_init_append (reply, &iter);
	_tmp10 = result;
	dbus_message_iter_append_basic (&iter, DBUS_TYPE_UINT32, &_tmp10);
	return reply;
}


static DBusMessage* _dbus_dvb_id_bus_schedule_GetName (DVBIDBusSchedule* self, DBusConnection* connection, DBusMessage* message) {
	DBusMessageIter iter;
	GError* error;
	guint32 event_id;
	dbus_uint32_t _tmp11;
	char* result;
	DBusMessage* reply;
	const char* _tmp12;
	error = NULL;
	if (strcmp (dbus_message_get_signature (message), "u")) {
		return NULL;
	}
	dbus_message_iter_init (message, &iter);
	event_id = 0U;
	dbus_message_iter_get_basic (&iter, &_tmp11);
	dbus_message_iter_next (&iter);
	event_id = _tmp11;
	result = dvb_id_bus_schedule_GetName (self, event_id);
	reply = dbus_message_new_method_return (message);
	dbus_message_iter_init_append (reply, &iter);
	_tmp12 = result;
	dbus_message_iter_append_basic (&iter, DBUS_TYPE_STRING, &_tmp12);
	return reply;
}


static DBusMessage* _dbus_dvb_id_bus_schedule_GetShortDescription (DVBIDBusSchedule* self, DBusConnection* connection, DBusMessage* message) {
	DBusMessageIter iter;
	GError* error;
	guint32 event_id;
	dbus_uint32_t _tmp13;
	char* result;
	DBusMessage* reply;
	const char* _tmp14;
	error = NULL;
	if (strcmp (dbus_message_get_signature (message), "u")) {
		return NULL;
	}
	dbus_message_iter_init (message, &iter);
	event_id = 0U;
	dbus_message_iter_get_basic (&iter, &_tmp13);
	dbus_message_iter_next (&iter);
	event_id = _tmp13;
	result = dvb_id_bus_schedule_GetShortDescription (self, event_id);
	reply = dbus_message_new_method_return (message);
	dbus_message_iter_init_append (reply, &iter);
	_tmp14 = result;
	dbus_message_iter_append_basic (&iter, DBUS_TYPE_STRING, &_tmp14);
	return reply;
}


static DBusMessage* _dbus_dvb_id_bus_schedule_GetExtendedDescription (DVBIDBusSchedule* self, DBusConnection* connection, DBusMessage* message) {
	DBusMessageIter iter;
	GError* error;
	guint32 event_id;
	dbus_uint32_t _tmp15;
	char* result;
	DBusMessage* reply;
	const char* _tmp16;
	error = NULL;
	if (strcmp (dbus_message_get_signature (message), "u")) {
		return NULL;
	}
	dbus_message_iter_init (message, &iter);
	event_id = 0U;
	dbus_message_iter_get_basic (&iter, &_tmp15);
	dbus_message_iter_next (&iter);
	event_id = _tmp15;
	result = dvb_id_bus_schedule_GetExtendedDescription (self, event_id);
	reply = dbus_message_new_method_return (message);
	dbus_message_iter_init_append (reply, &iter);
	_tmp16 = result;
	dbus_message_iter_append_basic (&iter, DBUS_TYPE_STRING, &_tmp16);
	return reply;
}


static DBusMessage* _dbus_dvb_id_bus_schedule_GetDuration (DVBIDBusSchedule* self, DBusConnection* connection, DBusMessage* message) {
	DBusMessageIter iter;
	GError* error;
	guint32 event_id;
	dbus_uint32_t _tmp17;
	guint result;
	DBusMessage* reply;
	dbus_uint32_t _tmp18;
	error = NULL;
	if (strcmp (dbus_message_get_signature (message), "u")) {
		return NULL;
	}
	dbus_message_iter_init (message, &iter);
	event_id = 0U;
	dbus_message_iter_get_basic (&iter, &_tmp17);
	dbus_message_iter_next (&iter);
	event_id = _tmp17;
	result = dvb_id_bus_schedule_GetDuration (self, event_id);
	reply = dbus_message_new_method_return (message);
	dbus_message_iter_init_append (reply, &iter);
	_tmp18 = result;
	dbus_message_iter_append_basic (&iter, DBUS_TYPE_UINT32, &_tmp18);
	return reply;
}


static DBusMessage* _dbus_dvb_id_bus_schedule_GetLocalStartTime (DVBIDBusSchedule* self, DBusConnection* connection, DBusMessage* message) {
	DBusMessageIter iter;
	GError* error;
	guint32 event_id;
	dbus_uint32_t _tmp19;
	int result_length1;
	guint* result;
	DBusMessage* reply;
	DBusMessageIter _tmp20;
	int _tmp21;
	error = NULL;
	if (strcmp (dbus_message_get_signature (message), "u")) {
		return NULL;
	}
	dbus_message_iter_init (message, &iter);
	event_id = 0U;
	dbus_message_iter_get_basic (&iter, &_tmp19);
	dbus_message_iter_next (&iter);
	event_id = _tmp19;
	result_length1 = 0;
	result = dvb_id_bus_schedule_GetLocalStartTime (self, event_id, &result_length1);
	reply = dbus_message_new_method_return (message);
	dbus_message_iter_init_append (reply, &iter);
	dbus_message_iter_open_container (&iter, DBUS_TYPE_ARRAY, "u", &_tmp20);
	for (_tmp21 = 0; _tmp21 < result_length1; _tmp21++) {
		dbus_uint32_t _tmp22;
		_tmp22 = result[_tmp21];
		dbus_message_iter_append_basic (&_tmp20, DBUS_TYPE_UINT32, &_tmp22);
	}
	dbus_message_iter_close_container (&iter, &_tmp20);
	return reply;
}


static DBusMessage* _dbus_dvb_id_bus_schedule_IsRunning (DVBIDBusSchedule* self, DBusConnection* connection, DBusMessage* message) {
	DBusMessageIter iter;
	GError* error;
	guint32 event_id;
	dbus_uint32_t _tmp23;
	gboolean result;
	DBusMessage* reply;
	dbus_bool_t _tmp24;
	error = NULL;
	if (strcmp (dbus_message_get_signature (message), "u")) {
		return NULL;
	}
	dbus_message_iter_init (message, &iter);
	event_id = 0U;
	dbus_message_iter_get_basic (&iter, &_tmp23);
	dbus_message_iter_next (&iter);
	event_id = _tmp23;
	result = dvb_id_bus_schedule_IsRunning (self, event_id);
	reply = dbus_message_new_method_return (message);
	dbus_message_iter_init_append (reply, &iter);
	_tmp24 = result;
	dbus_message_iter_append_basic (&iter, DBUS_TYPE_BOOLEAN, &_tmp24);
	return reply;
}


static DBusMessage* _dbus_dvb_id_bus_schedule_IsScrambled (DVBIDBusSchedule* self, DBusConnection* connection, DBusMessage* message) {
	DBusMessageIter iter;
	GError* error;
	guint32 event_id;
	dbus_uint32_t _tmp25;
	gboolean result;
	DBusMessage* reply;
	dbus_bool_t _tmp26;
	error = NULL;
	if (strcmp (dbus_message_get_signature (message), "u")) {
		return NULL;
	}
	dbus_message_iter_init (message, &iter);
	event_id = 0U;
	dbus_message_iter_get_basic (&iter, &_tmp25);
	dbus_message_iter_next (&iter);
	event_id = _tmp25;
	result = dvb_id_bus_schedule_IsScrambled (self, event_id);
	reply = dbus_message_new_method_return (message);
	dbus_message_iter_init_append (reply, &iter);
	_tmp26 = result;
	dbus_message_iter_append_basic (&iter, DBUS_TYPE_BOOLEAN, &_tmp26);
	return reply;
}


DBusHandlerResult dvb_id_bus_schedule_dbus_message (DBusConnection* connection, DBusMessage* message, void* object) {
	DBusMessage* reply;
	reply = NULL;
	if (dbus_message_is_method_call (message, "org.freedesktop.DBus.Introspectable", "Introspect")) {
		reply = _dbus_dvb_id_bus_schedule_introspect (object, connection, message);
	} else if (dbus_message_is_method_call (message, "org.freedesktop.DBus.Properties", "Get")) {
		reply = _dbus_dvb_id_bus_schedule_property_get (object, connection, message);
	} else if (dbus_message_is_method_call (message, "org.freedesktop.DBus.Properties", "Set")) {
		reply = _dbus_dvb_id_bus_schedule_property_set (object, connection, message);
	} else if (dbus_message_is_method_call (message, "org.freedesktop.DBus.Properties", "GetAll")) {
		reply = _dbus_dvb_id_bus_schedule_property_get_all (object, connection, message);
	} else if (dbus_message_is_method_call (message, "org.gnome.DVB.Schedule", "GetAllEvents")) {
		reply = _dbus_dvb_id_bus_schedule_GetAllEvents (object, connection, message);
	} else if (dbus_message_is_method_call (message, "org.gnome.DVB.Schedule", "NowPlaying")) {
		reply = _dbus_dvb_id_bus_schedule_NowPlaying (object, connection, message);
	} else if (dbus_message_is_method_call (message, "org.gnome.DVB.Schedule", "Next")) {
		reply = _dbus_dvb_id_bus_schedule_Next (object, connection, message);
	} else if (dbus_message_is_method_call (message, "org.gnome.DVB.Schedule", "GetName")) {
		reply = _dbus_dvb_id_bus_schedule_GetName (object, connection, message);
	} else if (dbus_message_is_method_call (message, "org.gnome.DVB.Schedule", "GetShortDescription")) {
		reply = _dbus_dvb_id_bus_schedule_GetShortDescription (object, connection, message);
	} else if (dbus_message_is_method_call (message, "org.gnome.DVB.Schedule", "GetExtendedDescription")) {
		reply = _dbus_dvb_id_bus_schedule_GetExtendedDescription (object, connection, message);
	} else if (dbus_message_is_method_call (message, "org.gnome.DVB.Schedule", "GetDuration")) {
		reply = _dbus_dvb_id_bus_schedule_GetDuration (object, connection, message);
	} else if (dbus_message_is_method_call (message, "org.gnome.DVB.Schedule", "GetLocalStartTime")) {
		reply = _dbus_dvb_id_bus_schedule_GetLocalStartTime (object, connection, message);
	} else if (dbus_message_is_method_call (message, "org.gnome.DVB.Schedule", "IsRunning")) {
		reply = _dbus_dvb_id_bus_schedule_IsRunning (object, connection, message);
	} else if (dbus_message_is_method_call (message, "org.gnome.DVB.Schedule", "IsScrambled")) {
		reply = _dbus_dvb_id_bus_schedule_IsScrambled (object, connection, message);
	}
	if (reply) {
		dbus_connection_send (connection, reply, NULL);
		dbus_message_unref (reply);
		return DBUS_HANDLER_RESULT_HANDLED;
	} else {
		return DBUS_HANDLER_RESULT_NOT_YET_HANDLED;
	}
}


void dvb_id_bus_schedule_dbus_register_object (DBusConnection* connection, const char* path, void* object) {
	if (!g_object_get_data (object, "dbus_object_path")) {
		g_object_set_data (object, "dbus_object_path", g_strdup (path));
		dbus_connection_register_object_path (connection, path, &_dvb_id_bus_schedule_dbus_path_vtable, object);
	}
}


static void dvb_id_bus_schedule_base_init (DVBIDBusScheduleIface * iface) {
	static gboolean initialized = FALSE;
	if (!initialized) {
		initialized = TRUE;
		g_type_set_qdata (DVB_TYPE_ID_BUS_SCHEDULE, g_quark_from_static_string ("DBusObjectVTable"), (void*) (&_dvb_id_bus_schedule_dbus_vtable));
	}
}


GType dvb_id_bus_schedule_get_type (void) {
	static GType dvb_id_bus_schedule_type_id = 0;
	if (dvb_id_bus_schedule_type_id == 0) {
		static const GTypeInfo g_define_type_info = { sizeof (DVBIDBusScheduleIface), (GBaseInitFunc) dvb_id_bus_schedule_base_init, (GBaseFinalizeFunc) NULL, (GClassInitFunc) NULL, (GClassFinalizeFunc) NULL, NULL, 0, 0, (GInstanceInitFunc) NULL, NULL };
		dvb_id_bus_schedule_type_id = g_type_register_static (G_TYPE_INTERFACE, "DVBIDBusSchedule", &g_define_type_info, 0);
		g_type_interface_add_prerequisite (dvb_id_bus_schedule_type_id, G_TYPE_OBJECT);
	}
	return dvb_id_bus_schedule_type_id;
}


G_DEFINE_TYPE_EXTENDED (DVBIDBusScheduleDBusProxy, dvb_id_bus_schedule_dbus_proxy, DBUS_TYPE_G_PROXY, 0, G_IMPLEMENT_INTERFACE (DVB_TYPE_ID_BUS_SCHEDULE, dvb_id_bus_schedule_dbus_proxy_interface_init));
DVBIDBusSchedule* dvb_id_bus_schedule_dbus_proxy_new (DBusGConnection* connection, const char* name, const char* path) {
	return g_object_new (dvb_id_bus_schedule_dbus_proxy_get_type (), "connection", connection, "name", name, "path", path, "interface", "org.gnome.DVB.Schedule", NULL);
}


static void dvb_id_bus_schedule_dbus_proxy_class_init (DVBIDBusScheduleDBusProxyClass* klass) {
}


static void dvb_id_bus_schedule_dbus_proxy_init (DVBIDBusScheduleDBusProxy* self) {
}


static guint32* dvb_id_bus_schedule_dbus_proxy_GetAllEvents (DVBIDBusSchedule* self, int* result_length1) {
	DBusGConnection *_connection;
	DBusMessage *_message, *_reply;
	DBusMessageIter _iter;
	guint32* _result;
	int _result_length1;
	guint32* _tmp27;
	int _tmp27_length;
	int _tmp27_size;
	int _tmp27_length1;
	DBusMessageIter _tmp28;
	_message = dbus_message_new_method_call (dbus_g_proxy_get_bus_name ((DBusGProxy*) self), dbus_g_proxy_get_path ((DBusGProxy*) self), "org.gnome.DVB.Schedule", "GetAllEvents");
	dbus_message_iter_init_append (_message, &_iter);
	g_object_get (self, "connection", &_connection, NULL);
	_reply = dbus_connection_send_with_reply_and_block (dbus_g_connection_get_connection (_connection), _message, -1, NULL);
	dbus_g_connection_unref (_connection);
	dbus_message_unref (_message);
	dbus_message_iter_init (_reply, &_iter);
	_result_length1 = 0;
	_tmp27 = NULL;
	_tmp27_length = 0;
	_tmp27_size = 0;
	_tmp27_length1 = 0;
	dbus_message_iter_recurse (&_iter, &_tmp28);
	for (; dbus_message_iter_get_arg_type (&_tmp28); _tmp27_length1++) {
		dbus_uint32_t _tmp29;
		if (_tmp27_size == _tmp27_length) {
			_tmp27_size = (_tmp27_size > 0) ? (2 * _tmp27_size) : 4;
			_tmp27 = g_renew (guint32, _tmp27, _tmp27_size);
		}
		dbus_message_iter_get_basic (&_tmp28, &_tmp29);
		dbus_message_iter_next (&_tmp28);
		_tmp27[_tmp27_length++] = _tmp29;
	}
	_result_length1 = _tmp27_length1;
	dbus_message_iter_next (&_iter);
	_result = _tmp27;
	*result_length1 = _result_length1;
	dbus_message_unref (_reply);
	return _result;
}


static guint32 dvb_id_bus_schedule_dbus_proxy_NowPlaying (DVBIDBusSchedule* self) {
	DBusGConnection *_connection;
	DBusMessage *_message, *_reply;
	DBusMessageIter _iter;
	guint32 _result;
	dbus_uint32_t _tmp30;
	_message = dbus_message_new_method_call (dbus_g_proxy_get_bus_name ((DBusGProxy*) self), dbus_g_proxy_get_path ((DBusGProxy*) self), "org.gnome.DVB.Schedule", "NowPlaying");
	dbus_message_iter_init_append (_message, &_iter);
	g_object_get (self, "connection", &_connection, NULL);
	_reply = dbus_connection_send_with_reply_and_block (dbus_g_connection_get_connection (_connection), _message, -1, NULL);
	dbus_g_connection_unref (_connection);
	dbus_message_unref (_message);
	dbus_message_iter_init (_reply, &_iter);
	dbus_message_iter_get_basic (&_iter, &_tmp30);
	dbus_message_iter_next (&_iter);
	_result = _tmp30;
	dbus_message_unref (_reply);
	return _result;
}


static guint32 dvb_id_bus_schedule_dbus_proxy_Next (DVBIDBusSchedule* self, guint32 event_id) {
	DBusGConnection *_connection;
	DBusMessage *_message, *_reply;
	DBusMessageIter _iter;
	dbus_uint32_t _tmp31;
	guint32 _result;
	dbus_uint32_t _tmp32;
	_message = dbus_message_new_method_call (dbus_g_proxy_get_bus_name ((DBusGProxy*) self), dbus_g_proxy_get_path ((DBusGProxy*) self), "org.gnome.DVB.Schedule", "Next");
	dbus_message_iter_init_append (_message, &_iter);
	_tmp31 = event_id;
	dbus_message_iter_append_basic (&_iter, DBUS_TYPE_UINT32, &_tmp31);
	g_object_get (self, "connection", &_connection, NULL);
	_reply = dbus_connection_send_with_reply_and_block (dbus_g_connection_get_connection (_connection), _message, -1, NULL);
	dbus_g_connection_unref (_connection);
	dbus_message_unref (_message);
	dbus_message_iter_init (_reply, &_iter);
	dbus_message_iter_get_basic (&_iter, &_tmp32);
	dbus_message_iter_next (&_iter);
	_result = _tmp32;
	dbus_message_unref (_reply);
	return _result;
}


static char* dvb_id_bus_schedule_dbus_proxy_GetName (DVBIDBusSchedule* self, guint32 event_id) {
	DBusGConnection *_connection;
	DBusMessage *_message, *_reply;
	DBusMessageIter _iter;
	dbus_uint32_t _tmp33;
	char* _result;
	const char* _tmp34;
	_message = dbus_message_new_method_call (dbus_g_proxy_get_bus_name ((DBusGProxy*) self), dbus_g_proxy_get_path ((DBusGProxy*) self), "org.gnome.DVB.Schedule", "GetName");
	dbus_message_iter_init_append (_message, &_iter);
	_tmp33 = event_id;
	dbus_message_iter_append_basic (&_iter, DBUS_TYPE_UINT32, &_tmp33);
	g_object_get (self, "connection", &_connection, NULL);
	_reply = dbus_connection_send_with_reply_and_block (dbus_g_connection_get_connection (_connection), _message, -1, NULL);
	dbus_g_connection_unref (_connection);
	dbus_message_unref (_message);
	dbus_message_iter_init (_reply, &_iter);
	dbus_message_iter_get_basic (&_iter, &_tmp34);
	dbus_message_iter_next (&_iter);
	_result = g_strdup (_tmp34);
	dbus_message_unref (_reply);
	return _result;
}


static char* dvb_id_bus_schedule_dbus_proxy_GetShortDescription (DVBIDBusSchedule* self, guint32 event_id) {
	DBusGConnection *_connection;
	DBusMessage *_message, *_reply;
	DBusMessageIter _iter;
	dbus_uint32_t _tmp35;
	char* _result;
	const char* _tmp36;
	_message = dbus_message_new_method_call (dbus_g_proxy_get_bus_name ((DBusGProxy*) self), dbus_g_proxy_get_path ((DBusGProxy*) self), "org.gnome.DVB.Schedule", "GetShortDescription");
	dbus_message_iter_init_append (_message, &_iter);
	_tmp35 = event_id;
	dbus_message_iter_append_basic (&_iter, DBUS_TYPE_UINT32, &_tmp35);
	g_object_get (self, "connection", &_connection, NULL);
	_reply = dbus_connection_send_with_reply_and_block (dbus_g_connection_get_connection (_connection), _message, -1, NULL);
	dbus_g_connection_unref (_connection);
	dbus_message_unref (_message);
	dbus_message_iter_init (_reply, &_iter);
	dbus_message_iter_get_basic (&_iter, &_tmp36);
	dbus_message_iter_next (&_iter);
	_result = g_strdup (_tmp36);
	dbus_message_unref (_reply);
	return _result;
}


static char* dvb_id_bus_schedule_dbus_proxy_GetExtendedDescription (DVBIDBusSchedule* self, guint32 event_id) {
	DBusGConnection *_connection;
	DBusMessage *_message, *_reply;
	DBusMessageIter _iter;
	dbus_uint32_t _tmp37;
	char* _result;
	const char* _tmp38;
	_message = dbus_message_new_method_call (dbus_g_proxy_get_bus_name ((DBusGProxy*) self), dbus_g_proxy_get_path ((DBusGProxy*) self), "org.gnome.DVB.Schedule", "GetExtendedDescription");
	dbus_message_iter_init_append (_message, &_iter);
	_tmp37 = event_id;
	dbus_message_iter_append_basic (&_iter, DBUS_TYPE_UINT32, &_tmp37);
	g_object_get (self, "connection", &_connection, NULL);
	_reply = dbus_connection_send_with_reply_and_block (dbus_g_connection_get_connection (_connection), _message, -1, NULL);
	dbus_g_connection_unref (_connection);
	dbus_message_unref (_message);
	dbus_message_iter_init (_reply, &_iter);
	dbus_message_iter_get_basic (&_iter, &_tmp38);
	dbus_message_iter_next (&_iter);
	_result = g_strdup (_tmp38);
	dbus_message_unref (_reply);
	return _result;
}


static guint dvb_id_bus_schedule_dbus_proxy_GetDuration (DVBIDBusSchedule* self, guint32 event_id) {
	DBusGConnection *_connection;
	DBusMessage *_message, *_reply;
	DBusMessageIter _iter;
	dbus_uint32_t _tmp39;
	guint _result;
	dbus_uint32_t _tmp40;
	_message = dbus_message_new_method_call (dbus_g_proxy_get_bus_name ((DBusGProxy*) self), dbus_g_proxy_get_path ((DBusGProxy*) self), "org.gnome.DVB.Schedule", "GetDuration");
	dbus_message_iter_init_append (_message, &_iter);
	_tmp39 = event_id;
	dbus_message_iter_append_basic (&_iter, DBUS_TYPE_UINT32, &_tmp39);
	g_object_get (self, "connection", &_connection, NULL);
	_reply = dbus_connection_send_with_reply_and_block (dbus_g_connection_get_connection (_connection), _message, -1, NULL);
	dbus_g_connection_unref (_connection);
	dbus_message_unref (_message);
	dbus_message_iter_init (_reply, &_iter);
	dbus_message_iter_get_basic (&_iter, &_tmp40);
	dbus_message_iter_next (&_iter);
	_result = _tmp40;
	dbus_message_unref (_reply);
	return _result;
}


static guint* dvb_id_bus_schedule_dbus_proxy_GetLocalStartTime (DVBIDBusSchedule* self, guint32 event_id, int* result_length1) {
	DBusGConnection *_connection;
	DBusMessage *_message, *_reply;
	DBusMessageIter _iter;
	dbus_uint32_t _tmp41;
	guint* _result;
	int _result_length1;
	guint* _tmp42;
	int _tmp42_length;
	int _tmp42_size;
	int _tmp42_length1;
	DBusMessageIter _tmp43;
	_message = dbus_message_new_method_call (dbus_g_proxy_get_bus_name ((DBusGProxy*) self), dbus_g_proxy_get_path ((DBusGProxy*) self), "org.gnome.DVB.Schedule", "GetLocalStartTime");
	dbus_message_iter_init_append (_message, &_iter);
	_tmp41 = event_id;
	dbus_message_iter_append_basic (&_iter, DBUS_TYPE_UINT32, &_tmp41);
	g_object_get (self, "connection", &_connection, NULL);
	_reply = dbus_connection_send_with_reply_and_block (dbus_g_connection_get_connection (_connection), _message, -1, NULL);
	dbus_g_connection_unref (_connection);
	dbus_message_unref (_message);
	dbus_message_iter_init (_reply, &_iter);
	_result_length1 = 0;
	_tmp42 = NULL;
	_tmp42_length = 0;
	_tmp42_size = 0;
	_tmp42_length1 = 0;
	dbus_message_iter_recurse (&_iter, &_tmp43);
	for (; dbus_message_iter_get_arg_type (&_tmp43); _tmp42_length1++) {
		dbus_uint32_t _tmp44;
		if (_tmp42_size == _tmp42_length) {
			_tmp42_size = (_tmp42_size > 0) ? (2 * _tmp42_size) : 4;
			_tmp42 = g_renew (guint, _tmp42, _tmp42_size);
		}
		dbus_message_iter_get_basic (&_tmp43, &_tmp44);
		dbus_message_iter_next (&_tmp43);
		_tmp42[_tmp42_length++] = _tmp44;
	}
	_result_length1 = _tmp42_length1;
	dbus_message_iter_next (&_iter);
	_result = _tmp42;
	*result_length1 = _result_length1;
	dbus_message_unref (_reply);
	return _result;
}


static gboolean dvb_id_bus_schedule_dbus_proxy_IsRunning (DVBIDBusSchedule* self, guint32 event_id) {
	DBusGConnection *_connection;
	DBusMessage *_message, *_reply;
	DBusMessageIter _iter;
	dbus_uint32_t _tmp45;
	gboolean _result;
	dbus_bool_t _tmp46;
	_message = dbus_message_new_method_call (dbus_g_proxy_get_bus_name ((DBusGProxy*) self), dbus_g_proxy_get_path ((DBusGProxy*) self), "org.gnome.DVB.Schedule", "IsRunning");
	dbus_message_iter_init_append (_message, &_iter);
	_tmp45 = event_id;
	dbus_message_iter_append_basic (&_iter, DBUS_TYPE_UINT32, &_tmp45);
	g_object_get (self, "connection", &_connection, NULL);
	_reply = dbus_connection_send_with_reply_and_block (dbus_g_connection_get_connection (_connection), _message, -1, NULL);
	dbus_g_connection_unref (_connection);
	dbus_message_unref (_message);
	dbus_message_iter_init (_reply, &_iter);
	dbus_message_iter_get_basic (&_iter, &_tmp46);
	dbus_message_iter_next (&_iter);
	_result = _tmp46;
	dbus_message_unref (_reply);
	return _result;
}


static gboolean dvb_id_bus_schedule_dbus_proxy_IsScrambled (DVBIDBusSchedule* self, guint32 event_id) {
	DBusGConnection *_connection;
	DBusMessage *_message, *_reply;
	DBusMessageIter _iter;
	dbus_uint32_t _tmp47;
	gboolean _result;
	dbus_bool_t _tmp48;
	_message = dbus_message_new_method_call (dbus_g_proxy_get_bus_name ((DBusGProxy*) self), dbus_g_proxy_get_path ((DBusGProxy*) self), "org.gnome.DVB.Schedule", "IsScrambled");
	dbus_message_iter_init_append (_message, &_iter);
	_tmp47 = event_id;
	dbus_message_iter_append_basic (&_iter, DBUS_TYPE_UINT32, &_tmp47);
	g_object_get (self, "connection", &_connection, NULL);
	_reply = dbus_connection_send_with_reply_and_block (dbus_g_connection_get_connection (_connection), _message, -1, NULL);
	dbus_g_connection_unref (_connection);
	dbus_message_unref (_message);
	dbus_message_iter_init (_reply, &_iter);
	dbus_message_iter_get_basic (&_iter, &_tmp48);
	dbus_message_iter_next (&_iter);
	_result = _tmp48;
	dbus_message_unref (_reply);
	return _result;
}


static void dvb_id_bus_schedule_dbus_proxy_interface_init (DVBIDBusScheduleIface* iface) {
	iface->GetAllEvents = dvb_id_bus_schedule_dbus_proxy_GetAllEvents;
	iface->NowPlaying = dvb_id_bus_schedule_dbus_proxy_NowPlaying;
	iface->Next = dvb_id_bus_schedule_dbus_proxy_Next;
	iface->GetName = dvb_id_bus_schedule_dbus_proxy_GetName;
	iface->GetShortDescription = dvb_id_bus_schedule_dbus_proxy_GetShortDescription;
	iface->GetExtendedDescription = dvb_id_bus_schedule_dbus_proxy_GetExtendedDescription;
	iface->GetDuration = dvb_id_bus_schedule_dbus_proxy_GetDuration;
	iface->GetLocalStartTime = dvb_id_bus_schedule_dbus_proxy_GetLocalStartTime;
	iface->IsRunning = dvb_id_bus_schedule_dbus_proxy_IsRunning;
	iface->IsScrambled = dvb_id_bus_schedule_dbus_proxy_IsScrambled;
}


static void _vala_dbus_register_object (DBusConnection* connection, const char* path, void* object) {
	const _DBusObjectVTable * vtable;
	vtable = g_type_get_qdata (G_TYPE_FROM_INSTANCE (object), g_quark_from_static_string ("DBusObjectVTable"));
	vtable->register_object (connection, path, object);
}




